from __future__ import annotations

from typing import Any, Optional

class Stack:
    items: Any = ...
    def __init__(self) -> None: ...
    def push(self, item: Any) -> None: ...
    def pop(self): ...
    def is_empty(self): ...
    def peek(self): ...

class Event:
    reader_cost_averager: Any = ...
    batch_cost_averager: Any = ...
    total_samples: int = ...
    total_iters: int = ...
    skip_iter: int = ...
    reader_records: Any = ...
    batch_records: Any = ...
    speed_records: Any = ...
    reader: Any = ...
    need_record: bool = ...
    speed_mode: str = ...
    speed_unit: str = ...
    def __init__(self) -> None: ...
    def reset(self) -> None: ...
    def record_reader(self, usetime: Any) -> None: ...
    def record_batch(self, usetime: Any, num_samples: Optional[Any] = ...) -> None: ...
    def reader_average(self): ...
    def batch_average(self): ...
    def speed_average(self): ...
    def get_summary(self): ...

class Hook:
    def begin(self, benchmark: Any) -> None: ...
    def end(self, benchmark: Any) -> None: ...
    def before_reader(self, benchmark: Any) -> None: ...
    def after_reader(self, benchmark: Any) -> None: ...
    def after_step(self, benchmark: Any) -> None: ...

class TimerHook(Hook):
    start_time: Any = ...
    start_reader: Any = ...
    def __init__(self) -> None: ...
    def begin(self, benchmark: Any) -> None: ...
    def before_reader(self, benchmark: Any) -> None: ...
    def after_reader(self, benchmark: Any) -> None: ...
    def after_step(self, benchmark: Any) -> None: ...
    def end(self, benchmark: Any) -> None: ...

class TimeAverager:
    def __init__(self) -> None: ...
    def reset(self) -> None: ...
    def record(self, usetime: Any, num_samples: Optional[Any] = ...) -> None: ...
    def get_average(self): ...
    def get_ips_average(self): ...
    def get_step_average(self): ...

class Benchmark:
    num_samples: Any = ...
    hooks: Any = ...
    current_event: Any = ...
    events: Any = ...
    def __init__(self) -> None: ...
    def step(self, num_samples: Optional[Any] = ...) -> None: ...
    def step_info(self, unit: Any): ...
    def begin(self) -> None: ...
    def before_reader(self) -> None: ...
    def after_reader(self) -> None: ...
    def after_step(self) -> None: ...
    def end(self) -> None: ...
    def check_if_need_record(self, reader: Any) -> None: ...

def benchmark(): ...
