from __future__ import annotations

from typing import Any, Optional

from ...fluid.layer_helper import LayerHelper as LayerHelper
from .. import Layer as Layer

class AvgPool1D(Layer):
    kernel_size: Any = ...
    stride: Any = ...
    padding: Any = ...
    ceil_mode: Any = ...
    exclusive: Any = ...
    name: Any = ...
    def __init__(
        self,
        kernel_size: Any,
        stride: Optional[Any] = ...,
        padding: int = ...,
        exclusive: bool = ...,
        ceil_mode: bool = ...,
        name: Optional[Any] = ...,
    ) -> None: ...
    def forward(self, x: Any): ...
    def extra_repr(self): ...

class AvgPool2D(Layer):
    ksize: Any = ...
    stride: Any = ...
    padding: Any = ...
    ceil_mode: Any = ...
    exclusive: Any = ...
    divisor: Any = ...
    data_format: Any = ...
    name: Any = ...
    def __init__(
        self,
        kernel_size: Any,
        stride: Optional[Any] = ...,
        padding: int = ...,
        ceil_mode: bool = ...,
        exclusive: bool = ...,
        divisor_override: Optional[Any] = ...,
        data_format: str = ...,
        name: Optional[Any] = ...,
    ) -> None: ...
    def forward(self, x: Any): ...
    def extra_repr(self): ...

class AvgPool3D(Layer):
    ksize: Any = ...
    stride: Any = ...
    padding: Any = ...
    ceil_mode: Any = ...
    exclusive: Any = ...
    divisor: Any = ...
    data_format: Any = ...
    name: Any = ...
    def __init__(
        self,
        kernel_size: Any,
        stride: Optional[Any] = ...,
        padding: int = ...,
        ceil_mode: bool = ...,
        exclusive: bool = ...,
        divisor_override: Optional[Any] = ...,
        data_format: str = ...,
        name: Optional[Any] = ...,
    ) -> None: ...
    def forward(self, x: Any): ...
    def extra_repr(self): ...

class MaxPool1D(Layer):
    kernel_size: Any = ...
    stride: Any = ...
    padding: Any = ...
    ceil_mode: Any = ...
    return_mask: Any = ...
    name: Any = ...
    def __init__(
        self,
        kernel_size: Any,
        stride: Optional[Any] = ...,
        padding: int = ...,
        return_mask: bool = ...,
        ceil_mode: bool = ...,
        name: Optional[Any] = ...,
    ) -> None: ...
    def forward(self, input: Any): ...
    def extra_repr(self): ...

class MaxPool2D(Layer):
    ksize: Any = ...
    stride: Any = ...
    padding: Any = ...
    return_mask: Any = ...
    ceil_mode: Any = ...
    data_format: Any = ...
    name: Any = ...
    def __init__(
        self,
        kernel_size: Any,
        stride: Optional[Any] = ...,
        padding: int = ...,
        return_mask: bool = ...,
        ceil_mode: bool = ...,
        data_format: str = ...,
        name: Optional[Any] = ...,
    ) -> None: ...
    def forward(self, x: Any): ...
    def extra_repr(self): ...

class MaxPool3D(Layer):
    ksize: Any = ...
    stride: Any = ...
    padding: Any = ...
    return_mask: Any = ...
    ceil_mode: Any = ...
    data_format: Any = ...
    name: Any = ...
    def __init__(
        self,
        kernel_size: Any,
        stride: Optional[Any] = ...,
        padding: int = ...,
        return_mask: bool = ...,
        ceil_mode: bool = ...,
        data_format: str = ...,
        name: Optional[Any] = ...,
    ) -> None: ...
    def forward(self, x: Any): ...
    def extra_repr(self): ...

class AdaptiveAvgPool1D(Layer):
    output_size: Any = ...
    name: Any = ...
    def __init__(self, output_size: Any, name: Optional[Any] = ...) -> None: ...
    def forward(self, input: Any): ...
    def extra_repr(self): ...

class AdaptiveAvgPool2D(Layer):
    def __init__(self, output_size: Any, data_format: str = ..., name: Optional[Any] = ...) -> None: ...
    def forward(self, x: Any): ...
    def extra_repr(self): ...

class AdaptiveAvgPool3D(Layer):
    def __init__(self, output_size: Any, data_format: str = ..., name: Optional[Any] = ...) -> None: ...
    def forward(self, x: Any): ...
    def extra_repr(self): ...

class AdaptiveMaxPool1D(Layer):
    output_size: Any = ...
    return_mask: Any = ...
    name: Any = ...
    def __init__(self, output_size: Any, return_mask: bool = ..., name: Optional[Any] = ...) -> None: ...
    def forward(self, input: Any): ...
    def extra_repr(self): ...

class AdaptiveMaxPool2D(Layer):
    def __init__(self, output_size: Any, return_mask: bool = ..., name: Optional[Any] = ...) -> None: ...
    def forward(self, x: Any): ...
    def extra_repr(self): ...

class AdaptiveMaxPool3D(Layer):
    def __init__(self, output_size: Any, return_mask: bool = ..., name: Optional[Any] = ...) -> None: ...
    def forward(self, x: Any): ...
    def extra_repr(self): ...

class MaxUnPool1D(Layer):
    ksize: Any = ...
    stride: Any = ...
    padding: Any = ...
    data_format: Any = ...
    output_size: Any = ...
    name: Any = ...
    def __init__(
        self,
        kernel_size: Any,
        stride: Optional[Any] = ...,
        padding: int = ...,
        data_format: str = ...,
        output_size: Optional[Any] = ...,
        name: Optional[Any] = ...,
    ) -> None: ...
    def forward(self, x: Any, indices: Any): ...
    def extra_repr(self): ...

class MaxUnPool2D(Layer):
    ksize: Any = ...
    stride: Any = ...
    padding: Any = ...
    data_format: Any = ...
    output_size: Any = ...
    name: Any = ...
    def __init__(
        self,
        kernel_size: Any,
        stride: Optional[Any] = ...,
        padding: int = ...,
        data_format: str = ...,
        output_size: Optional[Any] = ...,
        name: Optional[Any] = ...,
    ) -> None: ...
    def forward(self, x: Any, indices: Any): ...
    def extra_repr(self): ...

class MaxUnPool3D(Layer):
    ksize: Any = ...
    stride: Any = ...
    padding: Any = ...
    data_format: Any = ...
    output_size: Any = ...
    name: Any = ...
    def __init__(
        self,
        kernel_size: Any,
        stride: Optional[Any] = ...,
        padding: int = ...,
        data_format: str = ...,
        output_size: Optional[Any] = ...,
        name: Optional[Any] = ...,
    ) -> None: ...
    def forward(self, x: Any, indices: Any): ...
    def extra_repr(self): ...
