from __future__ import annotations

from typing import Any, Optional

from .. import Layer as Layer

class BCEWithLogitsLoss(Layer):
    weight: Any = ...
    reduction: Any = ...
    pos_weight: Any = ...
    name: Any = ...
    def __init__(
        self,
        weight: Optional[Any] = ...,
        reduction: str = ...,
        pos_weight: Optional[Any] = ...,
        name: Optional[Any] = ...,
    ) -> None: ...
    def forward(self, logit: Any, label: Any): ...

class CrossEntropyLoss(Layer):
    weight: Any = ...
    reduction: Any = ...
    ignore_index: Any = ...
    soft_label: Any = ...
    axis: Any = ...
    use_softmax: Any = ...
    name: Any = ...
    def __init__(
        self,
        weight: Optional[Any] = ...,
        ignore_index: int = ...,
        reduction: str = ...,
        soft_label: bool = ...,
        axis: int = ...,
        use_softmax: bool = ...,
        name: Optional[Any] = ...,
    ) -> None: ...
    def forward(self, input: Any, label: Any): ...

class HSigmoidLoss(Layer):
    weight: Any = ...
    bias: Any = ...
    def __init__(
        self,
        feature_size: Any,
        num_classes: Any,
        weight_attr: Optional[Any] = ...,
        bias_attr: Optional[Any] = ...,
        is_custom: bool = ...,
        is_sparse: bool = ...,
        name: Optional[Any] = ...,
    ) -> None: ...
    def forward(self, input: Any, label: Any, path_table: Optional[Any] = ..., path_code: Optional[Any] = ...): ...

class MSELoss(Layer):
    reduction: Any = ...
    def __init__(self, reduction: str = ...) -> None: ...
    def forward(self, input: Any, label: Any): ...

class L1Loss(Layer):
    reduction: Any = ...
    name: Any = ...
    def __init__(self, reduction: str = ..., name: Optional[Any] = ...) -> None: ...
    def forward(self, input: Any, label: Any): ...

class BCELoss(Layer):
    weight: Any = ...
    reduction: Any = ...
    name: Any = ...
    def __init__(self, weight: Optional[Any] = ..., reduction: str = ..., name: Optional[Any] = ...) -> None: ...
    def forward(self, input: Any, label: Any): ...

class NLLLoss(Layer):
    def __init__(
        self, weight: Optional[Any] = ..., ignore_index: int = ..., reduction: str = ..., name: Optional[Any] = ...
    ) -> None: ...
    def forward(self, input: Any, label: Any): ...

class KLDivLoss(Layer):
    reduction: Any = ...
    def __init__(self, reduction: str = ...) -> None: ...
    def forward(self, input: Any, label: Any): ...

class MarginRankingLoss(Layer):
    margin: Any = ...
    reduction: Any = ...
    name: Any = ...
    def __init__(self, margin: float = ..., reduction: str = ..., name: Optional[Any] = ...) -> None: ...
    def forward(self, input: Any, other: Any, label: Any): ...

class CTCLoss(Layer):
    blank: Any = ...
    reduction: Any = ...
    def __init__(self, blank: int = ..., reduction: str = ...) -> None: ...
    def forward(
        self, log_probs: Any, labels: Any, input_lengths: Any, label_lengths: Any, norm_by_times: bool = ...
    ): ...

class SmoothL1Loss(Layer):
    reduction: Any = ...
    delta: Any = ...
    name: Any = ...
    def __init__(self, reduction: str = ..., delta: float = ..., name: Optional[Any] = ...) -> None: ...
    def forward(self, input: Any, label: Any): ...

class HingeEmbeddingLoss(Layer):
    margin: Any = ...
    reduction: Any = ...
    name: Any = ...
    def __init__(self, margin: float = ..., reduction: str = ..., name: Optional[Any] = ...) -> None: ...
    def forward(self, input: Any, label: Any): ...
