from __future__ import annotations

from typing import Any, Optional

def fc(
    input: Any,
    size: Any,
    num_flatten_dims: int = ...,
    param_attr: Optional[Any] = ...,
    bias_attr: Optional[Any] = ...,
    act: Optional[Any] = ...,
    name: Optional[Any] = ...,
): ...
def embedding(
    input: Any,
    size: Any,
    is_sparse: bool = ...,
    is_distributed: bool = ...,
    padding_idx: Optional[Any] = ...,
    param_attr: Optional[Any] = ...,
    dtype: str = ...,
): ...
def linear_chain_crf(input: Any, label: Any, param_attr: Optional[Any] = ..., length: Optional[Any] = ...): ...
def crf_decoding(input: Any, param_attr: Any, label: Optional[Any] = ..., length: Optional[Any] = ...): ...
def cos_sim(X: Any, Y: Any): ...
def dropout(
    x: Any,
    dropout_prob: Any,
    is_test: Optional[Any] = ...,
    seed: Optional[Any] = ...,
    name: Optional[Any] = ...,
    dropout_implementation: str = ...,
): ...
def chunk_eval(
    input: Any,
    label: Any,
    chunk_scheme: Any,
    num_chunk_types: Any,
    excluded_chunk_types: Optional[Any] = ...,
    seq_length: Optional[Any] = ...,
): ...
def softmax(input: Any, use_cudnn: bool = ..., name: Optional[Any] = ..., axis: int = ...): ...
def conv2d(
    input: Any,
    num_filters: Any,
    filter_size: Any,
    stride: int = ...,
    padding: int = ...,
    dilation: int = ...,
    groups: Optional[Any] = ...,
    param_attr: Optional[Any] = ...,
    bias_attr: Optional[Any] = ...,
    use_cudnn: bool = ...,
    act: Optional[Any] = ...,
    name: Optional[Any] = ...,
    data_format: str = ...,
): ...
def conv3d(
    input: Any,
    num_filters: Any,
    filter_size: Any,
    stride: int = ...,
    padding: int = ...,
    dilation: int = ...,
    groups: Optional[Any] = ...,
    param_attr: Optional[Any] = ...,
    bias_attr: Optional[Any] = ...,
    use_cudnn: bool = ...,
    act: Optional[Any] = ...,
    name: Optional[Any] = ...,
    data_format: str = ...,
): ...
def pool2d(
    input: Any,
    pool_size: int = ...,
    pool_type: str = ...,
    pool_stride: int = ...,
    pool_padding: int = ...,
    global_pooling: bool = ...,
    use_cudnn: bool = ...,
    ceil_mode: bool = ...,
    name: Optional[Any] = ...,
    exclusive: bool = ...,
    data_format: str = ...,
): ...
def pool3d(
    input: Any,
    pool_size: int = ...,
    pool_type: str = ...,
    pool_stride: int = ...,
    pool_padding: int = ...,
    global_pooling: bool = ...,
    use_cudnn: bool = ...,
    ceil_mode: bool = ...,
    name: Optional[Any] = ...,
    exclusive: bool = ...,
    data_format: str = ...,
): ...
def adaptive_pool2d(
    input: Any, pool_size: Any, pool_type: str = ..., require_index: bool = ..., name: Optional[Any] = ...
): ...
def adaptive_pool3d(
    input: Any, pool_size: Any, pool_type: str = ..., require_index: bool = ..., name: Optional[Any] = ...
): ...
def batch_norm(
    input: Any,
    act: Optional[Any] = ...,
    is_test: bool = ...,
    momentum: float = ...,
    epsilon: float = ...,
    param_attr: Optional[Any] = ...,
    bias_attr: Optional[Any] = ...,
    data_layout: str = ...,
    in_place: bool = ...,
    name: Optional[Any] = ...,
    moving_mean_name: Optional[Any] = ...,
    moving_variance_name: Optional[Any] = ...,
    do_model_average_for_mean_and_var: bool = ...,
    use_global_stats: bool = ...,
): ...
def inplace_abn(
    input: Any,
    act: Optional[Any] = ...,
    is_test: bool = ...,
    momentum: float = ...,
    epsilon: float = ...,
    param_attr: Optional[Any] = ...,
    bias_attr: Optional[Any] = ...,
    data_layout: str = ...,
    name: Optional[Any] = ...,
    moving_mean_name: Optional[Any] = ...,
    moving_variance_name: Optional[Any] = ...,
    do_model_average_for_mean_and_var: bool = ...,
    use_global_stats: bool = ...,
    act_alpha: float = ...,
): ...
def instance_norm(
    input: Any,
    epsilon: float = ...,
    param_attr: Optional[Any] = ...,
    bias_attr: Optional[Any] = ...,
    name: Optional[Any] = ...,
): ...
def data_norm(
    input: Any,
    act: Optional[Any] = ...,
    epsilon: float = ...,
    param_attr: Optional[Any] = ...,
    data_layout: str = ...,
    in_place: bool = ...,
    name: Optional[Any] = ...,
    moving_mean_name: Optional[Any] = ...,
    moving_variance_name: Optional[Any] = ...,
    do_model_average_for_mean_and_var: bool = ...,
    slot_dim: int = ...,
    sync_stats: bool = ...,
    summary_decay_rate: float = ...,
    enable_scale_and_shift: bool = ...,
): ...
def layer_norm(
    input: Any,
    scale: bool = ...,
    shift: bool = ...,
    begin_norm_axis: int = ...,
    epsilon: float = ...,
    param_attr: Optional[Any] = ...,
    bias_attr: Optional[Any] = ...,
    act: Optional[Any] = ...,
    name: Optional[Any] = ...,
): ...
def group_norm(
    input: Any,
    groups: Any,
    epsilon: float = ...,
    param_attr: Optional[Any] = ...,
    bias_attr: Optional[Any] = ...,
    act: Optional[Any] = ...,
    data_layout: str = ...,
    name: Optional[Any] = ...,
): ...
def spectral_norm(weight: Any, dim: int = ..., power_iters: int = ..., eps: float = ..., name: Optional[Any] = ...): ...
def conv2d_transpose(
    input: Any,
    num_filters: Any,
    output_size: Optional[Any] = ...,
    filter_size: Optional[Any] = ...,
    padding: int = ...,
    stride: int = ...,
    dilation: int = ...,
    groups: Optional[Any] = ...,
    param_attr: Optional[Any] = ...,
    bias_attr: Optional[Any] = ...,
    use_cudnn: bool = ...,
    act: Optional[Any] = ...,
    name: Optional[Any] = ...,
    data_format: str = ...,
): ...
def conv3d_transpose(
    input: Any,
    num_filters: Any,
    output_size: Optional[Any] = ...,
    filter_size: Optional[Any] = ...,
    padding: int = ...,
    stride: int = ...,
    dilation: int = ...,
    groups: Optional[Any] = ...,
    param_attr: Optional[Any] = ...,
    bias_attr: Optional[Any] = ...,
    use_cudnn: bool = ...,
    act: Optional[Any] = ...,
    name: Optional[Any] = ...,
    data_format: str = ...,
): ...
def reduce_sum(input: Any, dim: Optional[Any] = ..., keep_dim: bool = ..., name: Optional[Any] = ...): ...
def reduce_mean(input: Any, dim: Optional[Any] = ..., keep_dim: bool = ..., name: Optional[Any] = ...): ...
def reduce_max(input: Any, dim: Optional[Any] = ..., keep_dim: bool = ..., name: Optional[Any] = ...): ...
def reduce_min(input: Any, dim: Optional[Any] = ..., keep_dim: bool = ..., name: Optional[Any] = ...): ...
def reduce_prod(input: Any, dim: Optional[Any] = ..., keep_dim: bool = ..., name: Optional[Any] = ...): ...
def reduce_all(input: Any, dim: Optional[Any] = ..., keep_dim: bool = ..., name: Optional[Any] = ...): ...
def reduce_any(input: Any, dim: Optional[Any] = ..., keep_dim: bool = ..., name: Optional[Any] = ...): ...
def split(input: Any, num_or_sections: Any, dim: int = ..., name: Optional[Any] = ...): ...
def l2_normalize(x: Any, axis: Any, epsilon: float = ..., name: Optional[Any] = ...): ...
def matmul(
    x: Any, y: Any, transpose_x: bool = ..., transpose_y: bool = ..., alpha: float = ..., name: Optional[Any] = ...
): ...
def topk(input: Any, k: Any, name: Optional[Any] = ...): ...
def ctc_greedy_decoder(
    input: Any, blank: Any, input_length: Optional[Any] = ..., padding_value: int = ..., name: Optional[Any] = ...
): ...
def transpose(x: Any, perm: Any, name: Optional[Any] = ...): ...
def im2sequence(
    input: Any,
    filter_size: int = ...,
    stride: int = ...,
    padding: int = ...,
    input_image_size: Optional[Any] = ...,
    out_stride: int = ...,
    name: Optional[Any] = ...,
): ...
def row_conv(input: Any, future_context_size: Any, param_attr: Optional[Any] = ..., act: Optional[Any] = ...): ...
def multiplex(inputs: Any, index: Any, name: Optional[Any] = ...): ...
def smooth_l1(
    x: Any, y: Any, inside_weight: Optional[Any] = ..., outside_weight: Optional[Any] = ..., sigma: Optional[Any] = ...
): ...
def one_hot(input: Any, depth: Any, allow_out_of_range: bool = ...): ...
def autoincreased_step_counter(counter_name: Optional[Any] = ..., begin: int = ..., step: int = ...): ...
def reshape(
    x: Any,
    shape: Any,
    actual_shape: Optional[Any] = ...,
    act: Optional[Any] = ...,
    inplace: bool = ...,
    name: Optional[Any] = ...,
): ...
def squeeze(input: Any, axes: Any, name: Optional[Any] = ...): ...
def unsqueeze(input: Any, axes: Any, name: Optional[Any] = ...): ...
def lod_reset(x: Any, y: Optional[Any] = ..., target_lod: Optional[Any] = ...): ...
def lod_append(x: Any, level: Any): ...
def lrn(
    input: Any,
    n: int = ...,
    k: float = ...,
    alpha: float = ...,
    beta: float = ...,
    name: Optional[Any] = ...,
    data_format: str = ...,
): ...
def pad(x: Any, paddings: Any, pad_value: float = ..., name: Optional[Any] = ...): ...
def pad_constant_like(x: Any, y: Any, pad_value: float = ..., name: Optional[Any] = ...): ...
def label_smooth(
    label: Any, prior_dist: Optional[Any] = ..., epsilon: float = ..., dtype: str = ..., name: Optional[Any] = ...
): ...
def roi_pool(
    input: Any,
    rois: Any,
    pooled_height: int = ...,
    pooled_width: int = ...,
    spatial_scale: float = ...,
    rois_num: Optional[Any] = ...,
    name: Optional[Any] = ...,
): ...
def roi_align(
    input: Any,
    rois: Any,
    pooled_height: int = ...,
    pooled_width: int = ...,
    spatial_scale: float = ...,
    sampling_ratio: int = ...,
    rois_num: Optional[Any] = ...,
    name: Optional[Any] = ...,
): ...
def dice_loss(input: Any, label: Any, epsilon: float = ..., name: Optional[Any] = ...): ...
def image_resize(
    input: Any,
    out_shape: Optional[Any] = ...,
    scale: Optional[Any] = ...,
    name: Optional[Any] = ...,
    resample: str = ...,
    actual_shape: Optional[Any] = ...,
    align_corners: bool = ...,
    align_mode: int = ...,
    data_format: str = ...,
): ...
def resize_linear(
    input: Any,
    out_shape: Optional[Any] = ...,
    scale: Optional[Any] = ...,
    name: Optional[Any] = ...,
    actual_shape: Optional[Any] = ...,
    align_corners: bool = ...,
    align_mode: int = ...,
    data_format: str = ...,
): ...
def resize_bilinear(
    input: Any,
    out_shape: Optional[Any] = ...,
    scale: Optional[Any] = ...,
    name: Optional[Any] = ...,
    actual_shape: Optional[Any] = ...,
    align_corners: bool = ...,
    align_mode: int = ...,
    data_format: str = ...,
): ...
def resize_trilinear(
    input: Any,
    out_shape: Optional[Any] = ...,
    scale: Optional[Any] = ...,
    name: Optional[Any] = ...,
    actual_shape: Optional[Any] = ...,
    align_corners: bool = ...,
    align_mode: int = ...,
    data_format: str = ...,
): ...
def resize_nearest(
    input: Any,
    out_shape: Optional[Any] = ...,
    scale: Optional[Any] = ...,
    name: Optional[Any] = ...,
    actual_shape: Optional[Any] = ...,
    align_corners: bool = ...,
    data_format: str = ...,
): ...
def image_resize_short(input: Any, out_short_len: Any, resample: str = ...): ...
def gather(input: Any, index: Any, overwrite: bool = ...): ...
def gather_nd(input: Any, index: Any, name: Optional[Any] = ...): ...
def scatter(input: Any, index: Any, updates: Any, name: Optional[Any] = ..., overwrite: bool = ...): ...
def scatter_nd_add(ref: Any, index: Any, updates: Any, name: Optional[Any] = ...): ...
def scatter_nd(index: Any, updates: Any, shape: Any, name: Optional[Any] = ...): ...
def random_crop(x: Any, shape: Any, seed: Optional[Any] = ...): ...
def log(x: Any, name: Optional[Any] = ...): ...
def relu(x: Any, name: Optional[Any] = ...): ...
def selu(x: Any, scale: Optional[Any] = ..., alpha: Optional[Any] = ..., name: Optional[Any] = ...): ...
def mean_iou(input: Any, label: Any, num_classes: Any): ...
def crop(x: Any, shape: Optional[Any] = ..., offsets: Optional[Any] = ..., name: Optional[Any] = ...): ...
def crop_tensor(x: Any, shape: Optional[Any] = ..., offsets: Optional[Any] = ..., name: Optional[Any] = ...): ...
def affine_grid(theta: Any, out_shape: Any, name: Optional[Any] = ...): ...
def pad2d(
    input: Any,
    paddings: Any = ...,
    mode: str = ...,
    pad_value: float = ...,
    data_format: str = ...,
    name: Optional[Any] = ...,
): ...
def elu(x: Any, alpha: float = ..., name: Optional[Any] = ...): ...
def relu6(x: Any, threshold: float = ..., name: Optional[Any] = ...): ...
def pow(x: Any, factor: float = ..., name: Optional[Any] = ...): ...
def stanh(x: Any, scale_a: float = ..., scale_b: float = ..., name: Optional[Any] = ...): ...
def hard_sigmoid(x: Any, slope: float = ..., offset: float = ..., name: Optional[Any] = ...): ...
def swish(x: Any, beta: float = ..., name: Optional[Any] = ...): ...
def prelu(x: Any, mode: Any, param_attr: Optional[Any] = ..., data_format: str = ..., name: Optional[Any] = ...): ...
def brelu(x: Any, t_min: float = ..., t_max: float = ..., name: Optional[Any] = ...): ...
def leaky_relu(x: Any, alpha: float = ..., name: Optional[Any] = ...): ...
def soft_relu(x: Any, threshold: float = ..., name: Optional[Any] = ...): ...
def flatten(x: Any, axis: int = ..., name: Optional[Any] = ...): ...
def stack(x: Any, axis: int = ..., name: Optional[Any] = ...): ...
def filter_by_instag(ins: Any, ins_tag: Any, filter_tag: Any, is_lod: Any, out_val_if_empty: int = ...): ...
def unstack(x: Any, axis: int = ..., num: Optional[Any] = ...): ...
def expand(x: Any, expand_times: Any, name: Optional[Any] = ...): ...
def expand_as(x: Any, target_tensor: Any, name: Optional[Any] = ...): ...
def uniform_random_batch_size_like(
    input: Any,
    shape: Any,
    dtype: str = ...,
    input_dim_idx: int = ...,
    output_dim_idx: int = ...,
    min: Any = ...,
    max: float = ...,
    seed: int = ...,
): ...
def gaussian_random(
    shape: Any, mean: float = ..., std: float = ..., seed: int = ..., dtype: str = ..., name: Optional[Any] = ...
): ...
def sampling_id(x: Any, min: float = ..., max: float = ..., seed: int = ..., dtype: str = ...): ...
def gaussian_random_batch_size_like(
    input: Any,
    shape: Any,
    input_dim_idx: int = ...,
    output_dim_idx: int = ...,
    mean: float = ...,
    std: float = ...,
    seed: int = ...,
    dtype: str = ...,
): ...
def sum(x: Any): ...
def slice(input: Any, axes: Any, starts: Any, ends: Any): ...
def strided_slice(input: Any, axes: Any, starts: Any, ends: Any, strides: Any): ...
def shape(input: Any): ...
def rank(input: Any): ...
def size(input: Any): ...
def scale(
    x: Any,
    scale: float = ...,
    bias: float = ...,
    bias_after_scale: bool = ...,
    act: Optional[Any] = ...,
    name: Optional[Any] = ...,
): ...
def elementwise_add(x: Any, y: Any, axis: int = ..., act: Optional[Any] = ..., name: Optional[Any] = ...): ...
def elementwise_div(x: Any, y: Any, axis: int = ..., act: Optional[Any] = ..., name: Optional[Any] = ...): ...
def elementwise_sub(x: Any, y: Any, axis: int = ..., act: Optional[Any] = ..., name: Optional[Any] = ...): ...
def elementwise_mul(x: Any, y: Any, axis: int = ..., act: Optional[Any] = ..., name: Optional[Any] = ...): ...
def elementwise_max(x: Any, y: Any, axis: int = ..., act: Optional[Any] = ..., name: Optional[Any] = ...): ...
def elementwise_min(x: Any, y: Any, axis: int = ..., act: Optional[Any] = ..., name: Optional[Any] = ...): ...
def elementwise_pow(x: Any, y: Any, axis: int = ..., act: Optional[Any] = ..., name: Optional[Any] = ...): ...
def elementwise_mod(x: Any, y: Any, axis: int = ..., act: Optional[Any] = ..., name: Optional[Any] = ...): ...
def elementwise_floordiv(x: Any, y: Any, axis: int = ..., act: Optional[Any] = ..., name: Optional[Any] = ...): ...
def logical_and(x: Any, y: Any, out: Optional[Any] = ..., name: Optional[Any] = ...): ...
def logical_or(x: Any, y: Any, out: Optional[Any] = ..., name: Optional[Any] = ...): ...
def logical_xor(x: Any, y: Any, out: Optional[Any] = ..., name: Optional[Any] = ...): ...
def logical_not(x: Any, out: Optional[Any] = ..., name: Optional[Any] = ...): ...
def clip(x: Any, min: Any, max: Any, name: Optional[Any] = ...): ...
def clip_by_norm(x: Any, max_norm: Any, name: Optional[Any] = ...): ...
def mean(x: Any, name: Optional[Any] = ...): ...
def merge_selected_rows(x: Any, name: Optional[Any] = ...): ...
def mul(x: Any, y: Any, x_num_col_dims: int = ..., y_num_col_dims: int = ..., name: Optional[Any] = ...): ...
def maxout(x: Any, groups: Any, name: Optional[Any] = ..., axis: int = ...): ...
def space_to_depth(x: Any, blocksize: Any, name: Optional[Any] = ...): ...
def affine_channel(
    x: Any,
    scale: Optional[Any] = ...,
    bias: Optional[Any] = ...,
    data_layout: str = ...,
    name: Optional[Any] = ...,
    act: Optional[Any] = ...,
): ...
def similarity_focus(input: Any, axis: Any, indexes: Any, name: Optional[Any] = ...): ...
def hash(input: Any, hash_size: Any, num_hash: int = ..., name: Optional[Any] = ...): ...
def grid_sampler(x: Any, grid: Any, name: Optional[Any] = ...): ...
def log_loss(input: Any, label: Any, epsilon: float = ..., name: Optional[Any] = ...): ...
def add_position_encoding(input: Any, alpha: Any, beta: Any, name: Optional[Any] = ...): ...
def bilinear_tensor_product(
    x: Any,
    y: Any,
    size: Any,
    act: Optional[Any] = ...,
    name: Optional[Any] = ...,
    param_attr: Optional[Any] = ...,
    bias_attr: Optional[Any] = ...,
): ...
def get_tensor_from_selected_rows(x: Any, name: Optional[Any] = ...): ...
def shuffle_channel(x: Any, group: Any, name: Optional[Any] = ...): ...
def temporal_shift(
    x: Any, seg_num: Any, shift_ratio: float = ..., name: Optional[Any] = ..., data_format: str = ...
): ...

class PyFuncRegistry:
    def __init__(self, func: Any) -> None: ...
    @classmethod
    def registered_func(cls, idx: Any): ...
    @classmethod
    def registered_func_num(cls): ...
    @property
    def id(self): ...
    def __call__(self, *args: Any): ...

def py_func(
    func: Any, x: Any, out: Any, backward_func: Optional[Any] = ..., skip_vars_in_backward_input: Optional[Any] = ...
): ...
def psroi_pool(
    input: Any,
    rois: Any,
    output_channels: Any,
    spatial_scale: Any,
    pooled_height: Any,
    pooled_width: Any,
    name: Optional[Any] = ...,
): ...
def prroi_pool(
    input: Any,
    rois: Any,
    spatial_scale: float = ...,
    pooled_height: int = ...,
    pooled_width: int = ...,
    batch_roi_nums: Optional[Any] = ...,
    name: Optional[Any] = ...,
): ...
def pixel_shuffle(x: Any, upscale_factor: Any): ...
def fsp_matrix(x: Any, y: Any): ...
def continuous_value_model(input: Any, cvm: Any, use_cvm: bool = ...): ...
def where(condition: Any): ...
def sign(x: Any): ...
def unique(x: Any, dtype: str = ...): ...
def unique_with_counts(x: Any, dtype: str = ...): ...
def deformable_conv(
    input: Any,
    offset: Any,
    mask: Any,
    num_filters: Any,
    filter_size: Any,
    stride: int = ...,
    padding: int = ...,
    dilation: int = ...,
    groups: Optional[Any] = ...,
    deformable_groups: Optional[Any] = ...,
    im2col_step: Optional[Any] = ...,
    param_attr: Optional[Any] = ...,
    bias_attr: Optional[Any] = ...,
    modulated: bool = ...,
    name: Optional[Any] = ...,
): ...
def unfold(
    x: Any, kernel_sizes: Any, strides: int = ..., paddings: int = ..., dilations: int = ..., name: Optional[Any] = ...
): ...
def deformable_roi_pooling(
    input: Any,
    rois: Any,
    trans: Any,
    no_trans: bool = ...,
    spatial_scale: float = ...,
    group_size: Any = ...,
    pooled_height: int = ...,
    pooled_width: int = ...,
    part_size: Optional[Any] = ...,
    sample_per_part: int = ...,
    trans_std: float = ...,
    position_sensitive: bool = ...,
    name: Optional[Any] = ...,
): ...
def shard_index(input: Any, index_num: Any, nshards: Any, shard_id: Any, ignore_value: int = ...): ...
def hard_swish(x: Any, threshold: float = ..., scale: float = ..., offset: float = ..., name: Optional[Any] = ...): ...
def mish(x: Any, threshold: int = ..., name: Optional[Any] = ...): ...
def gather_tree(ids: Any, parents: Any): ...
def uniform_random(
    shape: Any, dtype: str = ..., min: Any = ..., max: float = ..., seed: int = ..., name: Optional[Any] = ...
): ...
def unbind(input: Any, axis: int = ...): ...
