from __future__ import annotations

from typing import Any, Optional

from ...compiler import CompiledProgram as CompiledProgram

class SerializableBase:
    def serialize(self, path: Any) -> None: ...
    def deserialize(self, path: Any) -> None: ...

class PaddleModel(SerializableBase):
    def __init__(self, exe: Any, program: Any) -> None: ...
    def serialize(self, path: Any) -> None: ...
    def deserialize(self, path: Any) -> None: ...

class CheckpointSaver:
    def __init__(self, fs: Any) -> None: ...
    def save_checkpoint(self, path: Any, slists: Any, trainer_id: Optional[Any] = ..., local_cache_path: str = ...): ...
    def load_checkpoint(
        self,
        path: Any,
        slists: Any,
        trainer_id: Any,
        local_cache_path: str = ...,
        checkpoint_no: Optional[Any] = ...,
        ignore_empty: bool = ...,
    ): ...
    def get_checkpoint_no(self, root_path: Any): ...
    def clean_redundant_checkpoints(self, root_path: Any, reserved: Any = ...) -> None: ...
