from __future__ import annotations

import unittest
from typing import Any

class TestWeightQuantization(unittest.TestCase):
    weight_quantization_dir: str = ...
    cache_folder: Any = ...
    def setUp(self) -> None: ...
    def download_model(self, model_name: Any, data_url: Any, data_md5: Any): ...
    def cache_unzipping(self, target_folder: Any, zip_path: Any) -> None: ...
    def quantize_to_int(
        self,
        model_name: Any,
        model_data_url: Any,
        model_data_md5: Any,
        weight_bits: Any,
        quantizable_op_type: Any,
        weight_quantize_type: Any,
        generate_test_model: Any,
        threshold_rate: Any,
    ) -> None: ...
    def convert_to_fp16(
        self, model_name: Any, model_data_url: Any, model_data_md5: Any, model_filename: Any, params_filename: Any
    ) -> None: ...
    def run_models(
        self, model_dir: Any, model_filename: Any, params_filename: Any, input_data: Any, is_fp16_model: Any
    ): ...

class TestWeightQuantizationMobilenetv1(TestWeightQuantization):
    nocomb_model_name: str = ...
    nocomb_model_data_url: str = ...
    nocomb_model_data_md5: str = ...
    comb_model_name: str = ...
    comb_model_data_url: str = ...
    comb_model_data_md5: str = ...
    def test_weight_quantization_mobilenetv1_8bit_abs_max(self) -> None: ...
    def test_weight_quantization_mobilenetv1_8bit_channel_wise_abs_max(self) -> None: ...
    def test_weight_quantization_mobilenetv1_16bit_abs_max(self) -> None: ...
    def test_weight_quantization_mobilenetv1_16bit_channel_wise_abs_max(self) -> None: ...
    def test_mobilenetv1_fp16_combined(self) -> None: ...
    def test_mobilenetv1_fp16_nocombined(self) -> None: ...
