from __future__ import annotations

import unittest
from typing import Any, Optional

def linear_fc(num: Any): ...
def residual_block(num: Any, quant_skip_pattern: Optional[Any] = ...): ...
def conv_net(img: Any, label: Any, quant_skip_pattern: Any): ...

class TestQuantizationTransformPass(unittest.TestCase):
    quantizable_op_and_inputs: Any = ...
    quantizable_grad_op_inputs: Any = ...
    def setUp(self) -> None: ...
    def check_program(self, program: Any) -> None: ...
    def linear_fc_quant(self, activation_quant_type: Any, weight_quantize_type: Any, for_ci: bool = ...) -> None: ...
    def test_linear_fc_quant_abs_max(self) -> None: ...
    def test_linear_fc_quant_range_abs_max(self) -> None: ...
    def test_linear_fc_quant_moving_average_abs_max(self) -> None: ...
    def residual_block_quant(
        self, activation_quant_type: Any, weight_quantize_type: Any, quantizable_op_type: Any, for_ci: bool = ...
    ) -> None: ...
    def test_residual_block_abs_max(self) -> None: ...
    def test_residual_block_range_abs_max(self) -> None: ...
    def test_residual_block_moving_average_abs_max(self) -> None: ...

class TestQuantizationFreezePass(unittest.TestCase):
    def freeze_graph(
        self,
        use_cuda: Any,
        seed: Any,
        activation_quant_type: Any,
        bias_correction: bool = ...,
        weight_quant_type: str = ...,
        for_ci: bool = ...,
        quant_skip_pattern: str = ...,
    ): ...
    def test_freeze_graph_cuda_dynamic(self) -> None: ...
    def test_freeze_graph_cpu_dynamic(self) -> None: ...
    def test_freeze_graph_cuda_static(self) -> None: ...
    def test_freeze_graph_cpu_static(self) -> None: ...

def quant_dequant_residual_block(num: Any, quant_skip_pattern: Optional[Any] = ...): ...

class TestAddQuantDequantPass(unittest.TestCase):
    def setUp(self) -> None: ...
    def check_graph(self, graph: Any, skip_pattern: Optional[Any] = ...) -> None: ...
    def residual_block_quant(
        self, quantizable_op_type: Any, skip_pattern: Optional[Any] = ..., for_ci: bool = ...
    ) -> None: ...
    def test_residual_block(self) -> None: ...
    def test_residual_block_skip_pattern(self) -> None: ...
    def test_residual_block_skip_pattern_1(self) -> None: ...

class TestQuantizationTransformPassV2(unittest.TestCase):
    quantizable_op_and_inputs: Any = ...
    quantizable_grad_op_inputs: Any = ...
    def setUp(self) -> None: ...
    def check_program(self, program: Any) -> None: ...
    def linear_fc_quant(self, activation_quant_type: Any, weight_quantize_type: Any, for_ci: bool = ...) -> None: ...
    def test_linear_fc_quant_abs_max(self) -> None: ...
    def test_linear_fc_quant_channel_wise_abs_max(self) -> None: ...
    def residual_block_quant(
        self, activation_quant_type: Any, weight_quantize_type: Any, quantizable_op_type: Any, for_ci: bool = ...
    ) -> None: ...
    def test_residual_block_abs_max(self) -> None: ...
    def test_residual_block_channel_wise_abs_max(self) -> None: ...
