from __future__ import annotations

import unittest
from typing import Any, Optional

from PIL import ImageEnhance as ImageEnhance

DATA_DIM: int
THREAD: int
BUF_SIZE: int
DATA_DIR: str
img_mean: Any
img_std: Any

def resize_short(img: Any, target_size: Any): ...
def crop_image(img: Any, target_size: Any, center: Any): ...
def process_image(sample: Any, mode: Any, color_jitter: Any, rotate: Any): ...
def val(data_dir: Any = ...): ...

class TestPostTrainingQuantization(unittest.TestCase):
    int8_download: str = ...
    cache_folder: Any = ...
    data_cache_folder: str = ...
    batch_size: Any = ...
    sample_iterations: Any = ...
    infer_iterations: Any = ...
    root_path: Any = ...
    int8_model: Any = ...
    def setUp(self) -> None: ...
    def tearDown(self) -> None: ...
    def cache_unzipping(self, target_folder: Any, zip_path: Any) -> None: ...
    def download_data(self, data_urls: Any, data_md5s: Any, folder_name: Any, is_model: bool = ...): ...
    def download_model(self) -> None: ...
    def run_program(self, model_path: Any, batch_size: Any, infer_iterations: Any): ...
    def generate_quantized_model(
        self,
        model_path: Any,
        quantizable_op_type: Any,
        algo: str = ...,
        round_type: str = ...,
        is_full_quantize: bool = ...,
        is_use_cache_file: bool = ...,
        is_optimize_model: bool = ...,
        onnx_format: bool = ...,
        skip_tensor_list: Optional[Any] = ...,
    ) -> None: ...
    def run_test(
        self,
        model: Any,
        algo: Any,
        round_type: Any,
        data_urls: Any,
        data_md5s: Any,
        quantizable_op_type: Any,
        is_full_quantize: Any,
        is_use_cache_file: Any,
        is_optimize_model: Any,
        diff_threshold: Any,
        onnx_format: bool = ...,
        skip_tensor_list: Optional[Any] = ...,
    ) -> None: ...

class TestPostTrainingKLForMobilenetv1(TestPostTrainingQuantization):
    def test_post_training_kl_mobilenetv1(self) -> None: ...

class TestPostTrainingavgForMobilenetv1(TestPostTrainingQuantization):
    def test_post_training_avg_mobilenetv1(self) -> None: ...

class TestPostTraininghistForMobilenetv1(TestPostTrainingQuantization):
    def test_post_training_hist_mobilenetv1(self) -> None: ...

class TestPostTrainingAbsMaxForMobilenetv1(TestPostTrainingQuantization):
    def test_post_training_abs_max_mobilenetv1(self) -> None: ...

class TestPostTrainingAvgONNXFormatForMobilenetv1(TestPostTrainingQuantization):
    def test_post_training_onnx_format_mobilenetv1(self) -> None: ...

class TestPostTrainingForMobilenetv1SkipOP(TestPostTrainingQuantization):
    def test_post_training_mobilenetv1_skip(self) -> None: ...
