from __future__ import annotations

from typing import Any

ETCD_PROTOCAL: str

class Master:
    MAIN: str = ...
    STANDBY: str = ...
    PATICIPANT: str = ...
    ctx: Any = ...
    server: Any = ...
    initialized: bool = ...
    endpoint: Any = ...
    def __init__(self, ctx: Any) -> None: ...
    def stop(self) -> None: ...
    def set_status(self, status: Any) -> None: ...
    def get_status(self) -> None: ...
    def restart_peer(self) -> None: ...
    def sync_peers(self, prefix: Any, key: Any, value: Any, size: Any, rank: Any = ...) -> tuple[list, int]: ...
    @classmethod
    def factory(cls, ctx: Any): ...

class HTTPMaster(Master):
    role: Any = ...
    endpoint: Any = ...
    server: Any = ...
    client: Any = ...
    initialized: bool = ...
    def lazy_init(self) -> None: ...
    def stop(self) -> None: ...
    def sync_peers(self, prefix: Any, key: Any, value: Any, size: Any, rank: Any = ...) -> tuple[list, int]: ...

class ETCDMaster(Master):
    endpoint: Any = ...
    client: Any = ...
    def __init__(self, ctx: Any) -> None: ...
    def sync_peers(self, prefix: Any, key: Any, value: Any, size: Any, rank: Any = ...) -> tuple[list, int]: ...
    job_prefix: Any = ...
    heartbeat_prefix: Any = ...
    beat_thread: Any = ...
    def register_heartbeat(self, job_id: Any, pod_id: Any, ttl: int = ...) -> None: ...
    def fetch_peer_alive(self): ...
    def wait_peer_ready(self, replicas_min: Any, replicas_max: Any, timeout: Any): ...
    def restart_peer(self) -> None: ...
    def set_status(self, status: Any) -> None: ...
    def get_status(self): ...
    def stop(self) -> None: ...
