"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const bundling_1 = require("./bundling");
const util_1 = require("./util");
/**
 * (experimental) A Golang Lambda function.
 *
 * @experimental
 */
class GoFunction extends lambda.Function {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c, _d;
        if (props.runtime && (props.runtime.family !== lambda.RuntimeFamily.GO && props.runtime.family != lambda.RuntimeFamily.OTHER)) {
            throw new Error('Only `go` and `provided` runtimes are supported.');
        }
        const entry = path.resolve(props.entry);
        // Find the project root
        let moduleDir;
        if (props.moduleDir) {
            const parsedModuleDir = path.parse(props.moduleDir);
            if (parsedModuleDir.base && parsedModuleDir.ext && parsedModuleDir.base === 'go.mod') {
                if (!fs.existsSync(props.moduleDir)) {
                    throw new Error(`go.mod file at ${props.moduleDir} doesn't exist`);
                }
            }
            else if (parsedModuleDir.base && parsedModuleDir.ext && parsedModuleDir.base != 'go.mod') {
                throw new Error('moduleDir is specifying a file that is not go.mod');
            }
            else if (!fs.existsSync(path.join(props.moduleDir, 'go.mod'))) {
                throw new Error(`go.mod file at ${props.moduleDir} doesn't exist`);
            }
            moduleDir = props.moduleDir;
        }
        else {
            const modFile = util_1.findUp('go.mod', entry);
            if (!modFile) {
                throw new Error('Cannot find go.mod. Please specify it with `moduleDir`.');
            }
            moduleDir = modFile;
        }
        const runtime = (_b = props.runtime) !== null && _b !== void 0 ? _b : lambda.Runtime.PROVIDED_AL2;
        const architecture = (_c = props.architecture) !== null && _c !== void 0 ? _c : lambda.Architecture.X86_64;
        super(scope, id, {
            ...props,
            runtime,
            code: bundling_1.Bundling.bundle({
                ...(_d = props.bundling) !== null && _d !== void 0 ? _d : {},
                entry,
                runtime,
                architecture,
                moduleDir,
            }),
            handler: 'bootstrap',
        });
    }
}
exports.GoFunction = GoFunction;
_a = JSII_RTTI_SYMBOL_1;
GoFunction[_a] = { fqn: "@aws-cdk/aws-lambda-go.GoFunction", version: "1.132.0" };
//# sourceMappingURL=data:application/json;base64,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