# Generated by Django 2.2.5 on 2020-02-01 15:28

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Event',
            fields=[
                ('event_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('event_type', models.CharField(max_length=254)),
                ('object_type', models.CharField(blank=True, max_length=254, null=True)),
                ('object_id', models.CharField(blank=True, max_length=255, null=True)),
                ('account_id', models.UUIDField(blank=True, null=True)),
                ('meta_data', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('registerd_at', models.DateTimeField(null=True)),
            ],
            options={
                'verbose_name': 'event',
                'verbose_name_plural': 'events',
            },
        ),
        migrations.CreateModel(
            name='PushNotification',
            fields=[
                ('push_notification_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('callback_url', models.URLField()),
                ('pattern', models.CharField(max_length=10000)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('deleted_at', models.DateTimeField(null=True)),
            ],
            options={
                'verbose_name': 'push notification',
                'verbose_name_plural': 'push notifications',
                'unique_together': {('callback_url', 'pattern')},
            },
        ),
        migrations.CreateModel(
            name='PushNotificationEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('retry', models.IntegerField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('processed_at', models.DateTimeField(null=True)),
                ('last_retried_at', models.DateTimeField(null=True)),
                ('event', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='event.Event')),
                ('push_notification', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='event.PushNotification')),
            ],
            options={
                'verbose_name': 'push notification event',
                'verbose_name_plural': 'push notification events',
            },
        ),
        migrations.AddIndex(
            model_name='pushnotificationevent',
            index=models.Index(fields=['processed_at', 'retry', 'last_retried_at'], name='event_pushn_process_4728e8_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='pushnotificationevent',
            unique_together={('push_notification', 'event')},
        ),
    ]
