# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['meta_package_manager',
 'meta_package_manager.bar_plugin',
 'meta_package_manager.managers',
 'meta_package_manager.tests']

package_data = \
{'': ['*']}

install_requires = \
['boltons>=21.0.0,<22.0.0',
 'click-extra>=3.2.3,<4.0.0',
 'click>=8.1.2,<9.0.0',
 'tabulate[widechars]>=0.8.9,<0.9.0',
 'tomli_w>=1.0.0,<2.0.0',
 'xmltodict>=0.13.0,<0.14.0']

extras_require = \
{':python_version < "3.11"': ['tomli>=2.0.1,<3.0.0']}

entry_points = \
{'console_scripts': ['mpm = meta_package_manager.cli:mpm']}

setup_kwargs = {
    'name': 'meta-package-manager',
    'version': '5.6.2',
    'description': '🎁 a wrapper around all package managers',
    'long_description': '<p align="center">\n  <a href="https://github.com/kdeldycke/meta-package-manager/">\n    <img src="https://raw.githubusercontent.com/kdeldycke/meta-package-manager/main/docs/images/logo-banner.svg" alt="Meta Package Manager">\n  </a>\n</p>\n\n<a href="https://xkcd.com/1654/" alt="XKCD #1654: Universal Install Script">\n<img align="right" width="20%" height="20%" src="http://imgs.xkcd.com/comics/universal_install_script.png"/>\n</a>\n\n[![Last release](https://img.shields.io/pypi/v/meta-package-manager.svg)](https://pypi.python.org/pypi/meta-package-manager)\n[![Python versions](https://img.shields.io/pypi/pyversions/meta-package-manager.svg)](https://pypi.python.org/pypi/meta-package-manager)\n[![Type checked with mypy](http://www.mypy-lang.org/static/mypy_badge.svg)](http://mypy-lang.org/)\n[![Unittests status](https://github.com/kdeldycke/meta-package-manager/actions/workflows/tests.yaml/badge.svg?branch=main)](https://github.com/kdeldycke/meta-package-manager/actions/workflows/tests.yaml?query=branch%3Amain)\n[![Coverage status](https://codecov.io/gh/kdeldycke/meta-package-manager/branch/main/graph/badge.svg)](https://codecov.io/gh/kdeldycke/meta-package-manager/branch/main)\n[![Documentation status](https://github.com/kdeldycke/meta-package-manager/actions/workflows/docs.yaml/badge.svg?branch=main)](https://github.com/kdeldycke/meta-package-manager/actions/workflows/docs.yaml?query=branch%3Amain)\n[![DOI](https://zenodo.org/badge/65922807.svg)](https://zenodo.org/badge/latestdoi/65922807)\n\n**What is Meta Package Manager?**\n\n- provides the `mpm` CLI, a wrapper around all package managers\n- `mpm` is like [`yt-dlp`](https://github.com/yt-dlp/yt-dlp), but for package\n  managers instead of videos\n- `mpm` solves [XKCD #1654: Universal Install Script](https://xkcd.com/1654/)\n\n______________________________________________________________________\n\n## Features\n\n<img align="right" width="30%" height="30%" src="https://raw.githubusercontent.com/kdeldycke/meta-package-manager/main/docs/images/mpm-outdated-cli.png"/>\n\n<img align="right" width="30%" height="30%" src="https://raw.githubusercontent.com/kdeldycke/meta-package-manager/main/docs/images/mpm-managers-cli.png"/>\n\n- Inventory and list all package managers available on the system.\n- Supports macOS, Linux and Windows.\n- List installed packages.\n- Search for packages.\n- Install a package.\n- Remove a package.\n- List outdated packages.\n- Sync local package infos.\n- Upgrade all outdated packages.\n- Backup list of installed packages to TOML file.\n- Restore/install list of packages from TOML files.\n- Pin-point commands to a subset of package managers (include/exclude\n  selectors).\n- Export results in JSON or user-friendly tables.\n- Shell auto-completion for Bash, Zsh and Fish.\n- Provides a\n  [Xbar/SwiftBar plugin](https://kdeldycke.github.io/meta-package-manager/bar-plugin.html) for\n  friendly macOS integration.\n- Because `mpm` try to wrap all other package managers, it became another\n  pathological case of [XKCD #927: Standards](https://xkcd.com/927/)\n\n## Supported package managers and operations\n\n| Package manager                                                           | Min. version | Linux | macOS | Windows | `installed` | `outdated` | `search` | `install` | `upgrade` | `upgrade_all` | `remove` | `sync` | `cleanup` |\n| ------------------------------------------------------------------------- | ------------ | :---: | :---: | :-----: | :---------: | :--------: | :------: | :-------: | :-------: | :-----------: | :------: | :----: | :-------: |\n| [`apm`](https://atom.io/packages)                                         | 1.0.0        |   🐧   |   🍎   |    🪟    |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |          |        |           |\n| [`apt`](https://wiki.debian.org/AptCLI)                                   | 1.0.0        |   🐧   |       |         |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |          |   ✓    |     ✓     |\n| [`apt-mint`](https://github.com/kdeldycke/meta-package-manager/issues/52) | 1.0.0        |   🐧   |       |         |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |          |   ✓    |     ✓     |\n| [`brew`](https://brew.sh)                                                 | 2.7.0        |   🐧   |   🍎   |         |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |    ✓     |   ✓    |     ✓     |\n| [`cargo`](https://doc.rust-lang.org/cargo/)                               | 1.0.0        |   🐧   |   🍎   |    🪟    |      ✓      |            |    ✓     |     ✓     |           |               |    ✓     |        |           |\n| [`cask`](https://caskroom.github.io)                                      | 2.7.0        |       |   🍎   |         |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |    ✓     |   ✓    |     ✓     |\n| [`choco`](https://chocolatey.org)                                         | 0.10.4       |       |       |    🪟    |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |          |        |           |\n| [`composer`](https://getcomposer.org)                                     | 1.4.0        |   🐧   |   🍎   |    🪟    |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |          |        |     ✓     |\n| [`dnf`](https://github.com/rpm-software-management/dnf)                   | 4.0.0        |   🐧   |       |         |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |          |   ✓    |     ✓     |\n| [`emerge`](https://wiki.gentoo.org/wiki/Portage#emerge)                   | 3.0.0        |   🐧   |       |         |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |          |   ✓    |     ✓     |\n| [`flatpak`](https://flatpak.org)                                          | 1.2.0        |   🐧   |       |         |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |          |        |     ✓     |\n| [`gem`](https://rubygems.org)                                             | 2.5.0        |   🐧   |   🍎   |    🪟    |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |          |        |     ✓     |\n| [`mas`](https://github.com/argon/mas)                                     | 1.6.1        |       |   🍎   |         |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |          |        |           |\n| [`npm`](https://www.npmjs.com)                                            | 4.0.0        |   🐧   |   🍎   |    🪟    |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |    ✓     |        |           |\n| [`opkg`](https://git.yoctoproject.org/cgit/cgit.cgi/opkg/)                | 0.2.0        |   🐧   |       |         |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |          |   ✓    |           |\n| [`pacman`](https://wiki.archlinux.org/title/pacman)                       | 5.0.0        |   🐧   |       |         |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |    ✓     |   ✓    |     ✓     |\n| [`paru`](https://github.com/Morganamilo/paru)                             | 1.9.3        |   🐧   |       |         |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |    ✓     |   ✓    |     ✓     |\n| [`pip`](https://pip.pypa.io)                                              | 10.0.0       |   🐧   |   🍎   |    🪟    |      ✓      |     ✓      |          |     ✓     |     ✓     |       ✓       |    ✓     |        |           |\n| [`pipx`](https://pypa.github.io/pipx/)                                    | 1.0.0        |   🐧   |   🍎   |    🪟    |      ✓      |     ✓      |          |     ✓     |     ✓     |       ✓       |    ✓     |        |           |\n| [`snap`](https://snapcraft.io)                                            | 2.0.0        |   🐧   |       |         |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |          |        |           |\n| [`steamcmd`](https://developer.valvesoftware.com/wiki/SteamCMD)           | None         |   🐧   |   🍎   |    🪟    |             |            |          |     ✓     |           |               |          |        |           |\n| [`vscode`](https://code.visualstudio.com)                                 | 1.60.0       |   🐧   |   🍎   |    🪟    |      ✓      |            |          |     ✓     |           |               |          |        |           |\n| [`yarn`](https://yarnpkg.com)                                             | 1.20.0       |   🐧   |   🍎   |    🪟    |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |    ✓     |        |     ✓     |\n| [`yay`](https://github.com/Jguer/yay)                                     | 11.0.0       |   🐧   |       |         |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |    ✓     |   ✓    |     ✓     |\n| [`yum`](http://yum.baseurl.org)                                           | 4.0.0        |   🐧   |       |         |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |          |   ✓    |     ✓     |\n| [`zypper`](https://en.opensuse.org/Portal:Zypper)                         | 1.14.0       |   🐧   |       |         |      ✓      |     ✓      |    ✓     |     ✓     |     ✓     |       ✓       |          |   ✓    |     ✓     |\n\n## Quickstart\n\nEasiest way is to install `mpm` with [`pipx`](https://pypa.github.io/pipx/):\n\n```shell-session\n$ pipx install meta-package-manager\n```\n\nOther\n[alternatives installation methods](https://kdeldycke.github.io/meta-package-manager/install.html)\nare available in the documentation.\n\n## List managers\n\nList all supported package managers and their status on current system (macOS\nin this case):\n\n```shell-session\n$ mpm --all-managers managers\n╭────────────────────┬──────────┬────────────────┬───────────────────────────┬────────────┬──────────────╮\n│ Package manager    │ ID       │ Supported      │ CLI                       │ Executable │ Version      │\n├────────────────────┼──────────┼────────────────┼───────────────────────────┼────────────┼──────────────┤\n│ Atom\'s apm         │ apm      │ ✓              │ ✓ /usr/local/bin/apm      │ ✓          │ ✓ 2.6.2      │\n│ APT                │ apt      │ ✘ Linux only   │ ✓ /usr/bin/apt            │ ✓          │ ✘            │\n│ Linux Mint\'s apt   │ apt-mint │ ✘ Linux only   │ ✓ /usr/bin/apt            │ ✓          │ ✘            │\n│ Homebrew Formulae  │ brew     │ ✓              │ ✓ /usr/local/bin/brew     │ ✓          │ ✓ 3.2.16     │\n│ Rust\'s cargo       │ cargo    │ ✓              │ ✓ /opt/homebrew/bin/cargo │ ✓          │ ✓ 1.59.0     │\n│ Homebrew Cask      │ cask     │ ✓              │ ✓ /usr/local/bin/brew     │ ✓          │ ✓ 3.2.16     │\n│ Chocolatey         │ choco    │ ✘ Windows only │ ✘ choco not found         │            │              │\n│ PHP\'s Composer     │ composer │ ✓              │ ✓ /usr/local/bin/composer │ ✓          │ ✓ 2.1.8      │\n│ DNF                │ dnf      │ ✘ Linux only   │ ✘ dnf not found           │            │              │\n│ Emerge             │ emerge   │ ✘ Linux only   │ ✘ emerge not found        │            │              │\n│ Flatpak            │ flatpak  │ ✘ Linux only   │ ✘ flatpak not found       │            │              │\n│ Ruby Gems          │ gem      │ ✓              │ ✓ /usr/bin/gem            │ ✓          │ ✓ 3.0.3      │\n│ Mac AppStore       │ mas      │ ✓              │ ✓ /usr/local/bin/mas      │ ✓          │ ✓ 1.8.3      │\n│ Node\'s npm         │ npm      │ ✓              │ ✓ /usr/local/bin/npm      │ ✓          │ ✓ 7.24.0     │\n│ OPKG               │ opkg     │ ✘ Linux only   │ ✘ opkg not found          │            │              │\n│ Pacman             │ pacman   │ ✘ Linux only   │ ✘ pacman not found        │            │              │\n│ Pip                │ pip      │ ✓              │ ✓ /usr/local/bin/python3  │ ✓          │ ✓ 21.2.4     │\n│ Pipx               │ pipx     │ ✓              │ ✓ /opt/homebrew/bin/pipx  │ ✓          │ ✓ 1.0.0      │\n│ Snap               │ snap     │ ✘ Linux only   │ ✘ snap not found          │            │              │\n│ SteamCMD           │ steamcmd │ ✓              │ ✓ /opt/local/bin/steamcmd │ ✓          │ ✓ 1648077083 │\n│ Visual Studio Code │ vscode   │ ✓              │ ✓ /usr/local/bin/code     │ ✓          │ ✓ 1.61.0     │\n│ Node\'s yarn        │ yarn     │ ✓              │ ✘ yarn not found          │            │              │\n│ Yay                │ yay      │ ✘ Linux only   │ ✘ yay not found           │            │              │\n│ YUM                │ yum      │ ✘ Linux only   │ ✘ yum not found           │            │              │\n│ Zypper             │ zypper   │ ✘ Linux only   │ ✘ zypper not found        │            │              │\n╰────────────────────┴──────────┴────────────────┴───────────────────────────┴────────────┴──────────────╯\n```\n\nIf your favorite manager is not supported yet, you can help! See the [contibution guide](https://kdeldycke.github.io/meta-package-manager/contributing.html).\n\n## List installed packages\n\nList all packages installed on current system:\n\n```shell-session\n$ mpm installed\n╭─────────────────────────────┬─────────────────────────────┬─────────┬────────────────────╮\n│ Package name                │ ID                          │ Manager │ Installed version  │\n├─────────────────────────────┼─────────────────────────────┼─────────┼────────────────────┤\n│ github                      │ github                      │ apm     │ 0.36.9             │\n│ update-package-dependencies │ update-package-dependencies │ apm     │ 0.13.1             │\n│ rust                        │ rust                        │ brew    │ 1.55.0             │\n│ x264                        │ x264                        │ brew    │ r3060              │\n│ atom                        │ atom                        │ cask    │ 1.58.0             │\n│ visual-studio-code          │ visual-studio-code          │ cask    │ 1.52.0             │\n│ nokogiri                    │ nokogiri                    │ gem     │ x86_64-darwin      │\n│ rake                        │ rake                        │ gem     │ 13.0.3             │\n│ iMovie                      │ 408981434                   │ mas     │ 10.2.5             │\n│ Telegram                    │ 747648890                   │ mas     │ 8.1                │\n│ npm                         │ npm                         │ npm     │ 7.24.0             │\n│ raven                       │ raven                       │ npm     │ 2.6.4              │\n│ jupyterlab                  │ jupyterlab                  │ pip     │ 3.1.14             │\n│ Sphinx                      │ Sphinx                      │ pip     │ 4.2.0              │\n│ ms-python.python            │ ms-python.python            │ vscode  │ 2021.10.1317843341 │\n│ ms-toolsai.jupyter          │ ms-toolsai.jupyter          │ vscode  │ 2021.9.1001312534  │\n╰─────────────────────────────┴─────────────────────────────┴─────────┴────────────────────╯\n16 packages total (brew: 2, pip: 2, apm: 2, gem: 2, cask: 2, mas: 2, vscode: 2, npm: 2, composer: 0).\n```\n\n## List outdated packages\n\nList all packages installed for which an upgrade is available:\n\n```shell-session\n$ mpm outdated\n╭──────────────┬─────────────┬─────────┬───────────────────┬────────────────╮\n│ Package name │ ID          │ Manager │ Installed version │ Latest version │\n├──────────────┼─────────────┼─────────┼───────────────────┼────────────────┤\n│ curl         │ curl        │ brew    │ 7.79.1            │ 7.79.1_1       │\n│ git          │ git         │ brew    │ 2.33.0            │ 2.33.0_1       │\n│ openssl@1.1  │ openssl@1.1 │ brew    │ 1.1.1l            │ 1.1.1l_1       │\n│ rake         │ rake        │ gem     │ 13.0.3            │ 13.0.6         │\n│ Telegram     │ 747648890   │ mas     │ 8.1               │ 8.1.3          │\n│ npm          │ npm@8.0.0   │ npm     │ 7.24.0            │ 8.0.0          │\n│ pip          │ pip         │ pip     │ 21.2.4            │ 21.3           │\n│ regex        │ regex       │ pip     │ 2021.9.30         │ 2021.10.8      │\n╰──────────────┴─────────────┴─────────┴───────────────────┴────────────────╯\n8 packages total (brew: 3, pip: 2, gem: 1, mas: 1, npm: 1, apm: 0, cask: 0, composer: 0).\n```\n\n## Usage\n\nMore documentation is available in:\n\n- the\n  [detailed help screens](https://kdeldycke.github.io/meta-package-manager/cli-help.html)\n- the\n  [list of use-cases](https://kdeldycke.github.io/meta-package-manager/usecase.html)\n  where you’ll find inspiration on how to leverage `mpm` power\n',
    'author': 'Kevin Deldycke',
    'author_email': 'kevin@deldycke.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/kdeldycke/meta-package-manager',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
