/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.registry.Documentation;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.xml.ModelDocumentation;
import org.java.plugin.registry.xml.ModelDocumentationReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DocumentationImpl<T extends Identity>
implements Documentation<T> {
    protected static Log log = LogFactory.getLog(DocumentationImpl.class);
    private final T identity;
    private final ModelDocumentation model;
    private List<Documentation.Reference<T>> references;

    DocumentationImpl(T anIdentity, ModelDocumentation aModel) {
        this.identity = anIdentity;
        this.model = aModel;
        if (this.model.getCaption() == null || this.model.getCaption().trim().length() == 0) {
            this.model.setCaption("");
        }
        this.references = new ArrayList<Documentation.Reference<T>>(this.model.getReferences().size());
        for (ModelDocumentationReference reference : this.model.getReferences()) {
            this.references.add(new ReferenceImpl(reference));
        }
        this.references = Collections.unmodifiableList(this.references);
        if (this.model.getText() == null) {
            this.model.setText("");
        }
        if (log.isDebugEnabled()) {
            log.debug("object instantiated: " + this);
        }
    }

    @Override
    public String getCaption() {
        return this.model.getCaption();
    }

    @Override
    public String getText() {
        return this.model.getText();
    }

    @Override
    public Collection<Documentation.Reference<T>> getReferences() {
        return this.references;
    }

    @Override
    public T getDeclaringIdentity() {
        return this.identity;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReferenceImpl
    implements Documentation.Reference<T> {
        private final ModelDocumentationReference modelRef;

        ReferenceImpl(ModelDocumentationReference aModel) {
            this.modelRef = aModel;
            if (this.modelRef.getCaption() == null || this.modelRef.getCaption().trim().length() == 0) {
                this.modelRef.setCaption("");
            }
            if (this.modelRef.getPath() == null || this.modelRef.getPath().trim().length() == 0) {
                this.modelRef.setPath("");
            }
            if (log.isDebugEnabled()) {
                log.debug("object instantiated: " + this);
            }
        }

        @Override
        public String getCaption() {
            return this.modelRef.getCaption();
        }

        @Override
        public String getRef() {
            return this.modelRef.getPath();
        }

        @Override
        public T getDeclaringIdentity() {
            return DocumentationImpl.this.getDeclaringIdentity();
        }
    }
}

