/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.database;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.lifecycle.Closeable;

public class ReleasableStatementContainer
implements Closeable {
    private static final Logger LOG = Logger.getLogger(ReleasableStatementContainer.class.getName());
    private List<Statement> objects = new ArrayList<Statement>();

    public <T extends Statement> T add(T statement) {
        this.objects.add(statement);
        return statement;
    }

    public void clear() {
        this.objects.clear();
    }

    @Override
    public void close() {
        for (Statement statement : this.objects) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOG.log(Level.WARNING, "Unable to close database statement.", e);
            }
        }
        this.objects.clear();
    }
}

