/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.bound.v0_6;

import java.util.Map;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityProcessor;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.GenericObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.SimpleObjectStore;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.task.v0_6.SinkSource;

public class BoundComputer
implements SinkSource,
EntityProcessor {
    private Sink sink;
    private SimpleObjectStore<EntityContainer> objects = new SimpleObjectStore(new GenericObjectSerializationFactory(), "cbbo", true);
    private double top = 0.0;
    private double bottom = 0.0;
    private double left = 0.0;
    private double right = 0.0;
    private boolean nodesSeen = false;
    private String origin;

    public BoundComputer(String origin) {
        this.origin = origin;
    }

    @Override
    public void initialize(Map<String, Object> metaTags) {
        this.sink.initialize(metaTags);
    }

    @Override
    public void process(EntityContainer entityContainer) {
        entityContainer.process(this);
    }

    @Override
    public void complete() {
        this.objects.complete();
        if (this.nodesSeen) {
            this.sink.process(new BoundContainer(new Bound(this.right, this.left, this.top, this.bottom, this.origin)));
        }
        try (ReleasableIterator<EntityContainer> i = this.objects.iterate();){
            while (i.hasNext()) {
                this.sink.process((EntityContainer)i.next());
            }
        }
        this.sink.complete();
    }

    @Override
    public void close() {
        this.sink.close();
        this.objects.close();
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }

    @Override
    public void process(BoundContainer bound) {
    }

    @Override
    public void process(NodeContainer nodeContainer) {
        Node node = nodeContainer.getEntity();
        if (this.nodesSeen) {
            this.left = Math.min(this.left, node.getLongitude());
            this.right = Math.max(this.right, node.getLongitude());
            this.bottom = Math.min(this.bottom, node.getLatitude());
            this.top = Math.max(this.top, node.getLatitude());
        } else {
            this.left = node.getLongitude();
            this.right = node.getLongitude();
            this.top = node.getLatitude();
            this.bottom = node.getLatitude();
            this.nodesSeen = true;
        }
        this.objects.add(nodeContainer);
    }

    @Override
    public void process(WayContainer way) {
        this.objects.add(way);
    }

    @Override
    public void process(RelationContainer relation) {
        this.objects.add(relation);
    }
}

