#!/usr/bin/env python3
# coding: utf-8
#
# Copyright 2020-2022 F4PGA Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0

import argparse
import json
from .sdfparse import emit
from .sdfparse import parse


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--emit', action='store_const', const=True,
                        help='When set SDF file will be generated from JSON.')
    parser.add_argument('--sdf', type=str, help='Path to SDF file')
    parser.add_argument('--json', type=str, help='Path to JSON file')

    args = parser.parse_args()

    if args.emit:
        with open(args.json, 'r') as fp:
            input = json.loads(fp.read())
            timings = emit(input)
            open(args.sdf, 'w').write(timings)
    else:
        with open(args.sdf, 'r') as fp:
            timings = parse(fp.read())

        with open(args.json, 'w') as fp:
            json.dump(timings, fp, indent=4, sort_keys=True)


if __name__ == '__main__':
    main()
