# -*- coding: utf-8 -*-
# Author: Arthur Imbert <arthur.imbert.pro@gmail.com>
# License: BSD 3 clause

"""
The apifish.classification subpackage includes functions to prepare input data,
craft features and train classification models.
"""

from .input_preparation import prepare_extracted_data

from .features import compute_features
from .features import get_features_name
from .features import features_distance
from .features import features_in_out_nucleus
from .features import features_protrusion
from .features import features_dispersion
from .features import features_topography
from .features import features_foci
from .features import features_area
from .features import features_centrosome


_input_preparation = [
    "prepare_extracted_data"]

_features = [
    "compute_features",
    "get_features_name",
    "features_distance"
    "features_in_out_nucleus"
    "features_protrusion"
    "features_dispersion"
    "features_topography"
    "features_foci"
    "features_area"
    "features_centrosome"]

__all__ = _input_preparation + _features
