# -*- coding: utf-8 -*-

"""
    mundiapi

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from mundiapi.api_helper import APIHelper
import mundiapi.models.get_split_response
import mundiapi.models.get_gateway_response_response
import mundiapi.models.get_antifraud_response
import mundiapi.models.get_card_response
import mundiapi.models.get_billing_address_response
import mundiapi.models.pix_additional_information

class GetTransactionResponse(object):

    """Implementation of the 'GetTransactionResponse' model.

    Generic response object for getting a transaction.

    Attributes:
        gateway_id (string): Gateway transaction id
        amount (int): Amount in cents
        status (string): Transaction status
        success (bool): Indicates if the transaction ocurred successfuly
        created_at (datetime): Creation date
        updated_at (datetime): Last update date
        attempt_count (int): Number of attempts tried
        max_attempts (int): Max attempts
        splits (list of GetSplitResponse): Splits
        next_attempt (datetime): Date and time of the next attempt
        transaction_type (string): TODO: type description here.
        id (string): Código da transação
        gateway_response (GetGatewayResponseResponse): The Gateway Response
        antifraud_response (GetAntifraudResponse): TODO: type description
            here.
        metadata (dict<object, string>): TODO: type description here.
        split (list of GetSplitResponse): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "gateway_id":'gateway_id',
        "amount":'amount',
        "status":'status',
        "success":'success',
        "created_at":'created_at',
        "updated_at":'updated_at',
        "attempt_count":'attempt_count',
        "max_attempts":'max_attempts',
        "splits":'splits',
        "id":'id',
        "gateway_response":'gateway_response',
        "antifraud_response":'antifraud_response',
        "split":'split',
        "next_attempt":'next_attempt',
        "transaction_type":'transaction_type',
        "metadata":'metadata'
    }

    def __init__(self,
                 gateway_id=None,
                 amount=None,
                 status=None,
                 success=None,
                 created_at=None,
                 updated_at=None,
                 attempt_count=None,
                 max_attempts=None,
                 splits=None,
                 id=None,
                 gateway_response=None,
                 antifraud_response=None,
                 split=None,
                 next_attempt=None,
                 transaction_type=None,
                 metadata=None):
        """Constructor for the GetTransactionResponse class"""

        # Initialize members of the class
        self.gateway_id = gateway_id
        self.amount = amount
        self.status = status
        self.success = success
        self.created_at = APIHelper.RFC3339DateTime(created_at) if created_at else None
        self.updated_at = APIHelper.RFC3339DateTime(updated_at) if updated_at else None
        self.attempt_count = attempt_count
        self.max_attempts = max_attempts
        self.splits = splits
        self.next_attempt = APIHelper.RFC3339DateTime(next_attempt) if next_attempt else None
        self.transaction_type = transaction_type
        self.id = id
        self.gateway_response = gateway_response
        self.antifraud_response = antifraud_response
        self.metadata = metadata
        self.split = split


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        discriminators = {
            'bank_transfer': GetBankTransferTransactionResponse.from_dictionary,
            'debit_card': GetDebitCardTransactionResponse.from_dictionary,
            'voucher': GetVoucherTransactionResponse.from_dictionary,
            'boleto': GetBoletoTransactionResponse.from_dictionary,
            'cash': GetCashTransactionResponse.from_dictionary,
            'safetypay': GetSafetyPayTransactionResponse.from_dictionary,
            'credit_card': GetCreditCardTransactionResponse.from_dictionary,
            'private_label': GetPrivateLabelTransactionResponse.from_dictionary,
            'pix': GetPixTransactionResponse.from_dictionary
        }
        unboxer = discriminators.get(dictionary.get('transaction_type'))

        # Delegate unboxing to another function if a discriminator
        # value for a child class is present.
        if unboxer:
            return unboxer(dictionary)

        # Extract variables from the dictionary
        gateway_id = dictionary.get('gateway_id')
        amount = dictionary.get('amount')
        status = dictionary.get('status')
        success = dictionary.get('success')
        created_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("created_at")).datetime if dictionary.get("created_at") else None
        updated_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("updated_at")).datetime if dictionary.get("updated_at") else None
        attempt_count = dictionary.get('attempt_count')
        max_attempts = dictionary.get('max_attempts')
        splits = None
        if dictionary.get('splits') != None:
            splits = list()
            for structure in dictionary.get('splits'):
                splits.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        id = dictionary.get('id')
        gateway_response = mundiapi.models.get_gateway_response_response.GetGatewayResponseResponse.from_dictionary(dictionary.get('gateway_response')) if dictionary.get('gateway_response') else None
        antifraud_response = mundiapi.models.get_antifraud_response.GetAntifraudResponse.from_dictionary(dictionary.get('antifraud_response')) if dictionary.get('antifraud_response') else None
        split = None
        if dictionary.get('split') != None:
            split = list()
            for structure in dictionary.get('split'):
                split.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        next_attempt = APIHelper.RFC3339DateTime.from_value(dictionary.get("next_attempt")).datetime if dictionary.get("next_attempt") else None
        transaction_type = dictionary.get('transaction_type')
        metadata = dictionary.get('metadata')

        # Return an object of this model
        return cls(gateway_id,
                   amount,
                   status,
                   success,
                   created_at,
                   updated_at,
                   attempt_count,
                   max_attempts,
                   splits,
                   id,
                   gateway_response,
                   antifraud_response,
                   split,
                   next_attempt,
                   transaction_type,
                   metadata)


class GetBankTransferTransactionResponse(GetTransactionResponse):

    """Implementation of the 'GetBankTransferTransactionResponse' model.

    Response object for getting a bank transfer transaction
    NOTE: This class inherits from 'GetTransactionResponse'.

    Attributes:
        url (string): Payment url
        bank_tid (string): Transaction identifier for the bank
        bank (string): Bank
        paid_at (datetime): Payment date
        paid_amount (int): Paid amount

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "url":'url',
        "bank_tid":'bank_tid',
        "bank":'bank',
        "gateway_id":'gateway_id',
        "amount":'amount',
        "status":'status',
        "success":'success',
        "created_at":'created_at',
        "updated_at":'updated_at',
        "attempt_count":'attempt_count',
        "max_attempts":'max_attempts',
        "splits":'splits',
        "id":'id',
        "gateway_response":'gateway_response',
        "antifraud_response":'antifraud_response',
        "split":'split',
        "paid_at":'paid_at',
        "paid_amount":'paid_amount',
        "next_attempt":'next_attempt',
        "transaction_type":'transaction_type',
        "metadata":'metadata'
    }

    def __init__(self,
                 url=None,
                 bank_tid=None,
                 bank=None,
                 gateway_id=None,
                 amount=None,
                 status=None,
                 success=None,
                 created_at=None,
                 updated_at=None,
                 attempt_count=None,
                 max_attempts=None,
                 splits=None,
                 id=None,
                 gateway_response=None,
                 antifraud_response=None,
                 split=None,
                 paid_at=None,
                 paid_amount=None,
                 next_attempt=None,
                 transaction_type=None,
                 metadata=None):
        """Constructor for the GetBankTransferTransactionResponse class"""

        # Initialize members of the class
        self.url = url
        self.bank_tid = bank_tid
        self.bank = bank
        self.paid_at = APIHelper.RFC3339DateTime(paid_at) if paid_at else None
        self.paid_amount = paid_amount

        # Call the constructor for the base class
        super(GetBankTransferTransactionResponse, self).__init__(gateway_id,
                                                                 amount,
                                                                 status,
                                                                 success,
                                                                 created_at,
                                                                 updated_at,
                                                                 attempt_count,
                                                                 max_attempts,
                                                                 splits,
                                                                 id,
                                                                 gateway_response,
                                                                 antifraud_response,
                                                                 split,
                                                                 next_attempt,
                                                                 transaction_type,
                                                                 metadata)


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        url = dictionary.get('url')
        bank_tid = dictionary.get('bank_tid')
        bank = dictionary.get('bank')
        gateway_id = dictionary.get('gateway_id')
        amount = dictionary.get('amount')
        status = dictionary.get('status')
        success = dictionary.get('success')
        created_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("created_at")).datetime if dictionary.get("created_at") else None
        updated_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("updated_at")).datetime if dictionary.get("updated_at") else None
        attempt_count = dictionary.get('attempt_count')
        max_attempts = dictionary.get('max_attempts')
        splits = None
        if dictionary.get('splits') != None:
            splits = list()
            for structure in dictionary.get('splits'):
                splits.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        id = dictionary.get('id')
        gateway_response = mundiapi.models.get_gateway_response_response.GetGatewayResponseResponse.from_dictionary(dictionary.get('gateway_response')) if dictionary.get('gateway_response') else None
        antifraud_response = mundiapi.models.get_antifraud_response.GetAntifraudResponse.from_dictionary(dictionary.get('antifraud_response')) if dictionary.get('antifraud_response') else None
        split = None
        if dictionary.get('split') != None:
            split = list()
            for structure in dictionary.get('split'):
                split.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        paid_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("paid_at")).datetime if dictionary.get("paid_at") else None
        paid_amount = dictionary.get('paid_amount')
        next_attempt = APIHelper.RFC3339DateTime.from_value(dictionary.get("next_attempt")).datetime if dictionary.get("next_attempt") else None
        transaction_type = dictionary.get('transaction_type')
        metadata = dictionary.get('metadata')

        # Return an object of this model
        return cls(url,
                   bank_tid,
                   bank,
                   gateway_id,
                   amount,
                   status,
                   success,
                   created_at,
                   updated_at,
                   attempt_count,
                   max_attempts,
                   splits,
                   id,
                   gateway_response,
                   antifraud_response,
                   split,
                   paid_at,
                   paid_amount,
                   next_attempt,
                   transaction_type,
                   metadata)


class GetDebitCardTransactionResponse(GetTransactionResponse):

    """Implementation of the 'GetDebitCardTransactionResponse' model.

    Response object for getting a debit card transaction
    NOTE: This class inherits from 'GetTransactionResponse'.

    Attributes:
        statement_descriptor (string): Text that will appear on the debit
            card's statement
        acquirer_name (string): Acquirer name
        acquirer_affiliation_code (string): Aquirer affiliation code
        acquirer_tid (string): Acquirer TID
        acquirer_nsu (string): Acquirer NSU
        acquirer_auth_code (string): Acquirer authorization code
        operation_type (string): Operation type
        card (GetCardResponse): Card data
        acquirer_message (string): Acquirer message
        acquirer_return_code (string): Acquirer Return Code
        mpi (string): Merchant Plugin
        eci (string): Electronic Commerce Indicator (ECI)
        authentication_type (string): Authentication type
        threed_authentication_url (string): 3D-S Authentication Url

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "statement_descriptor":'statement_descriptor',
        "acquirer_name":'acquirer_name',
        "acquirer_affiliation_code":'acquirer_affiliation_code',
        "acquirer_tid":'acquirer_tid',
        "acquirer_nsu":'acquirer_nsu',
        "acquirer_auth_code":'acquirer_auth_code',
        "operation_type":'operation_type',
        "card":'card',
        "acquirer_message":'acquirer_message',
        "acquirer_return_code":'acquirer_return_code',
        "mpi":'mpi',
        "eci":'eci',
        "authentication_type":'authentication_type',
        "threed_authentication_url":'threed_authentication_url',
        "gateway_id":'gateway_id',
        "amount":'amount',
        "status":'status',
        "success":'success',
        "created_at":'created_at',
        "updated_at":'updated_at',
        "attempt_count":'attempt_count',
        "max_attempts":'max_attempts',
        "splits":'splits',
        "id":'id',
        "gateway_response":'gateway_response',
        "antifraud_response":'antifraud_response',
        "split":'split',
        "next_attempt":'next_attempt',
        "transaction_type":'transaction_type',
        "metadata":'metadata'
    }

    def __init__(self,
                 statement_descriptor=None,
                 acquirer_name=None,
                 acquirer_affiliation_code=None,
                 acquirer_tid=None,
                 acquirer_nsu=None,
                 acquirer_auth_code=None,
                 operation_type=None,
                 card=None,
                 acquirer_message=None,
                 acquirer_return_code=None,
                 mpi=None,
                 eci=None,
                 authentication_type=None,
                 threed_authentication_url=None,
                 gateway_id=None,
                 amount=None,
                 status=None,
                 success=None,
                 created_at=None,
                 updated_at=None,
                 attempt_count=None,
                 max_attempts=None,
                 splits=None,
                 id=None,
                 gateway_response=None,
                 antifraud_response=None,
                 split=None,
                 next_attempt=None,
                 transaction_type=None,
                 metadata=None):
        """Constructor for the GetDebitCardTransactionResponse class"""

        # Initialize members of the class
        self.statement_descriptor = statement_descriptor
        self.acquirer_name = acquirer_name
        self.acquirer_affiliation_code = acquirer_affiliation_code
        self.acquirer_tid = acquirer_tid
        self.acquirer_nsu = acquirer_nsu
        self.acquirer_auth_code = acquirer_auth_code
        self.operation_type = operation_type
        self.card = card
        self.acquirer_message = acquirer_message
        self.acquirer_return_code = acquirer_return_code
        self.mpi = mpi
        self.eci = eci
        self.authentication_type = authentication_type
        self.threed_authentication_url = threed_authentication_url

        # Call the constructor for the base class
        super(GetDebitCardTransactionResponse, self).__init__(gateway_id,
                                                              amount,
                                                              status,
                                                              success,
                                                              created_at,
                                                              updated_at,
                                                              attempt_count,
                                                              max_attempts,
                                                              splits,
                                                              id,
                                                              gateway_response,
                                                              antifraud_response,
                                                              split,
                                                              next_attempt,
                                                              transaction_type,
                                                              metadata)


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        statement_descriptor = dictionary.get('statement_descriptor')
        acquirer_name = dictionary.get('acquirer_name')
        acquirer_affiliation_code = dictionary.get('acquirer_affiliation_code')
        acquirer_tid = dictionary.get('acquirer_tid')
        acquirer_nsu = dictionary.get('acquirer_nsu')
        acquirer_auth_code = dictionary.get('acquirer_auth_code')
        operation_type = dictionary.get('operation_type')
        card = mundiapi.models.get_card_response.GetCardResponse.from_dictionary(dictionary.get('card')) if dictionary.get('card') else None
        acquirer_message = dictionary.get('acquirer_message')
        acquirer_return_code = dictionary.get('acquirer_return_code')
        mpi = dictionary.get('mpi')
        eci = dictionary.get('eci')
        authentication_type = dictionary.get('authentication_type')
        threed_authentication_url = dictionary.get('threed_authentication_url')
        gateway_id = dictionary.get('gateway_id')
        amount = dictionary.get('amount')
        status = dictionary.get('status')
        success = dictionary.get('success')
        created_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("created_at")).datetime if dictionary.get("created_at") else None
        updated_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("updated_at")).datetime if dictionary.get("updated_at") else None
        attempt_count = dictionary.get('attempt_count')
        max_attempts = dictionary.get('max_attempts')
        splits = None
        if dictionary.get('splits') != None:
            splits = list()
            for structure in dictionary.get('splits'):
                splits.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        id = dictionary.get('id')
        gateway_response = mundiapi.models.get_gateway_response_response.GetGatewayResponseResponse.from_dictionary(dictionary.get('gateway_response')) if dictionary.get('gateway_response') else None
        antifraud_response = mundiapi.models.get_antifraud_response.GetAntifraudResponse.from_dictionary(dictionary.get('antifraud_response')) if dictionary.get('antifraud_response') else None
        split = None
        if dictionary.get('split') != None:
            split = list()
            for structure in dictionary.get('split'):
                split.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        next_attempt = APIHelper.RFC3339DateTime.from_value(dictionary.get("next_attempt")).datetime if dictionary.get("next_attempt") else None
        transaction_type = dictionary.get('transaction_type')
        metadata = dictionary.get('metadata')

        # Return an object of this model
        return cls(statement_descriptor,
                   acquirer_name,
                   acquirer_affiliation_code,
                   acquirer_tid,
                   acquirer_nsu,
                   acquirer_auth_code,
                   operation_type,
                   card,
                   acquirer_message,
                   acquirer_return_code,
                   mpi,
                   eci,
                   authentication_type,
                   threed_authentication_url,
                   gateway_id,
                   amount,
                   status,
                   success,
                   created_at,
                   updated_at,
                   attempt_count,
                   max_attempts,
                   splits,
                   id,
                   gateway_response,
                   antifraud_response,
                   split,
                   next_attempt,
                   transaction_type,
                   metadata)


class GetVoucherTransactionResponse(GetTransactionResponse):

    """Implementation of the 'GetVoucherTransactionResponse' model.

    Response for voucher transactions
    NOTE: This class inherits from 'GetTransactionResponse'.

    Attributes:
        statement_descriptor (string): Text that will appear on the voucher's
            statement
        acquirer_name (string): Acquirer name
        acquirer_affiliation_code (string): Acquirer affiliation code
        acquirer_tid (string): Acquirer TID
        acquirer_nsu (string): Acquirer NSU
        acquirer_auth_code (string): Acquirer authorization code
        acquirer_message (string): acquirer_message
        acquirer_return_code (string): Acquirer return code
        operation_type (string): Operation type
        card (GetCardResponse): Card data

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "statement_descriptor":'statement_descriptor',
        "acquirer_name":'acquirer_name',
        "acquirer_affiliation_code":'acquirer_affiliation_code',
        "acquirer_tid":'acquirer_tid',
        "acquirer_nsu":'acquirer_nsu',
        "acquirer_auth_code":'acquirer_auth_code',
        "acquirer_message":'acquirer_message',
        "acquirer_return_code":'acquirer_return_code',
        "operation_type":'operation_type',
        "card":'card',
        "gateway_id":'gateway_id',
        "amount":'amount',
        "status":'status',
        "success":'success',
        "created_at":'created_at',
        "updated_at":'updated_at',
        "attempt_count":'attempt_count',
        "max_attempts":'max_attempts',
        "splits":'splits',
        "id":'id',
        "gateway_response":'gateway_response',
        "antifraud_response":'antifraud_response',
        "split":'split',
        "next_attempt":'next_attempt',
        "transaction_type":'transaction_type',
        "metadata":'metadata'
    }

    def __init__(self,
                 statement_descriptor=None,
                 acquirer_name=None,
                 acquirer_affiliation_code=None,
                 acquirer_tid=None,
                 acquirer_nsu=None,
                 acquirer_auth_code=None,
                 acquirer_message=None,
                 acquirer_return_code=None,
                 operation_type=None,
                 card=None,
                 gateway_id=None,
                 amount=None,
                 status=None,
                 success=None,
                 created_at=None,
                 updated_at=None,
                 attempt_count=None,
                 max_attempts=None,
                 splits=None,
                 id=None,
                 gateway_response=None,
                 antifraud_response=None,
                 split=None,
                 next_attempt=None,
                 transaction_type=None,
                 metadata=None):
        """Constructor for the GetVoucherTransactionResponse class"""

        # Initialize members of the class
        self.statement_descriptor = statement_descriptor
        self.acquirer_name = acquirer_name
        self.acquirer_affiliation_code = acquirer_affiliation_code
        self.acquirer_tid = acquirer_tid
        self.acquirer_nsu = acquirer_nsu
        self.acquirer_auth_code = acquirer_auth_code
        self.acquirer_message = acquirer_message
        self.acquirer_return_code = acquirer_return_code
        self.operation_type = operation_type
        self.card = card

        # Call the constructor for the base class
        super(GetVoucherTransactionResponse, self).__init__(gateway_id,
                                                            amount,
                                                            status,
                                                            success,
                                                            created_at,
                                                            updated_at,
                                                            attempt_count,
                                                            max_attempts,
                                                            splits,
                                                            id,
                                                            gateway_response,
                                                            antifraud_response,
                                                            split,
                                                            next_attempt,
                                                            transaction_type,
                                                            metadata)


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        statement_descriptor = dictionary.get('statement_descriptor')
        acquirer_name = dictionary.get('acquirer_name')
        acquirer_affiliation_code = dictionary.get('acquirer_affiliation_code')
        acquirer_tid = dictionary.get('acquirer_tid')
        acquirer_nsu = dictionary.get('acquirer_nsu')
        acquirer_auth_code = dictionary.get('acquirer_auth_code')
        acquirer_message = dictionary.get('acquirer_message')
        acquirer_return_code = dictionary.get('acquirer_return_code')
        operation_type = dictionary.get('operation_type')
        card = mundiapi.models.get_card_response.GetCardResponse.from_dictionary(dictionary.get('card')) if dictionary.get('card') else None
        gateway_id = dictionary.get('gateway_id')
        amount = dictionary.get('amount')
        status = dictionary.get('status')
        success = dictionary.get('success')
        created_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("created_at")).datetime if dictionary.get("created_at") else None
        updated_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("updated_at")).datetime if dictionary.get("updated_at") else None
        attempt_count = dictionary.get('attempt_count')
        max_attempts = dictionary.get('max_attempts')
        splits = None
        if dictionary.get('splits') != None:
            splits = list()
            for structure in dictionary.get('splits'):
                splits.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        id = dictionary.get('id')
        gateway_response = mundiapi.models.get_gateway_response_response.GetGatewayResponseResponse.from_dictionary(dictionary.get('gateway_response')) if dictionary.get('gateway_response') else None
        antifraud_response = mundiapi.models.get_antifraud_response.GetAntifraudResponse.from_dictionary(dictionary.get('antifraud_response')) if dictionary.get('antifraud_response') else None
        split = None
        if dictionary.get('split') != None:
            split = list()
            for structure in dictionary.get('split'):
                split.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        next_attempt = APIHelper.RFC3339DateTime.from_value(dictionary.get("next_attempt")).datetime if dictionary.get("next_attempt") else None
        transaction_type = dictionary.get('transaction_type')
        metadata = dictionary.get('metadata')

        # Return an object of this model
        return cls(statement_descriptor,
                   acquirer_name,
                   acquirer_affiliation_code,
                   acquirer_tid,
                   acquirer_nsu,
                   acquirer_auth_code,
                   acquirer_message,
                   acquirer_return_code,
                   operation_type,
                   card,
                   gateway_id,
                   amount,
                   status,
                   success,
                   created_at,
                   updated_at,
                   attempt_count,
                   max_attempts,
                   splits,
                   id,
                   gateway_response,
                   antifraud_response,
                   split,
                   next_attempt,
                   transaction_type,
                   metadata)


class GetBoletoTransactionResponse(GetTransactionResponse):

    """Implementation of the 'GetBoletoTransactionResponse' model.

    Response object for getting a boleto transaction
    NOTE: This class inherits from 'GetTransactionResponse'.

    Attributes:
        url (string): TODO: type description here.
        barcode (string): TODO: type description here.
        nosso_numero (string): TODO: type description here.
        bank (string): TODO: type description here.
        document_number (string): TODO: type description here.
        instructions (string): TODO: type description here.
        billing_address (GetBillingAddressResponse): TODO: type description
            here.
        due_at (datetime): TODO: type description here.
        qr_code (string): TODO: type description here.
        line (string): TODO: type description here.
        pdf_password (string): TODO: type description here.
        pdf (string): TODO: type description here.
        paid_at (datetime): TODO: type description here.
        paid_amount (string): TODO: type description here.
        mtype (string): TODO: type description here.
        credit_at (datetime): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "url":'url',
        "barcode":'barcode',
        "nosso_numero":'nosso_numero',
        "bank":'bank',
        "document_number":'document_number',
        "instructions":'instructions',
        "billing_address":'billing_address',
        "qr_code":'qr_code',
        "line":'line',
        "pdf_password":'pdf_password',
        "pdf":'pdf',
        "paid_amount":'paid_amount',
        "mtype":'type',
        "gateway_id":'gateway_id',
        "amount":'amount',
        "status":'status',
        "success":'success',
        "created_at":'created_at',
        "updated_at":'updated_at',
        "attempt_count":'attempt_count',
        "max_attempts":'max_attempts',
        "splits":'splits',
        "id":'id',
        "gateway_response":'gateway_response',
        "antifraud_response":'antifraud_response',
        "split":'split',
        "due_at":'due_at',
        "paid_at":'paid_at',
        "credit_at":'credit_at',
        "next_attempt":'next_attempt',
        "transaction_type":'transaction_type',
        "metadata":'metadata'
    }

    def __init__(self,
                 url=None,
                 barcode=None,
                 nosso_numero=None,
                 bank=None,
                 document_number=None,
                 instructions=None,
                 billing_address=None,
                 qr_code=None,
                 line=None,
                 pdf_password=None,
                 pdf=None,
                 paid_amount=None,
                 mtype=None,
                 gateway_id=None,
                 amount=None,
                 status=None,
                 success=None,
                 created_at=None,
                 updated_at=None,
                 attempt_count=None,
                 max_attempts=None,
                 splits=None,
                 id=None,
                 gateway_response=None,
                 antifraud_response=None,
                 split=None,
                 due_at=None,
                 paid_at=None,
                 credit_at=None,
                 next_attempt=None,
                 transaction_type=None,
                 metadata=None):
        """Constructor for the GetBoletoTransactionResponse class"""

        # Initialize members of the class
        self.url = url
        self.barcode = barcode
        self.nosso_numero = nosso_numero
        self.bank = bank
        self.document_number = document_number
        self.instructions = instructions
        self.billing_address = billing_address
        self.due_at = APIHelper.RFC3339DateTime(due_at) if due_at else None
        self.qr_code = qr_code
        self.line = line
        self.pdf_password = pdf_password
        self.pdf = pdf
        self.paid_at = APIHelper.RFC3339DateTime(paid_at) if paid_at else None
        self.paid_amount = paid_amount
        self.mtype = mtype
        self.credit_at = APIHelper.RFC3339DateTime(credit_at) if credit_at else None

        # Call the constructor for the base class
        super(GetBoletoTransactionResponse, self).__init__(gateway_id,
                                                           amount,
                                                           status,
                                                           success,
                                                           created_at,
                                                           updated_at,
                                                           attempt_count,
                                                           max_attempts,
                                                           splits,
                                                           id,
                                                           gateway_response,
                                                           antifraud_response,
                                                           split,
                                                           next_attempt,
                                                           transaction_type,
                                                           metadata)


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        url = dictionary.get('url')
        barcode = dictionary.get('barcode')
        nosso_numero = dictionary.get('nosso_numero')
        bank = dictionary.get('bank')
        document_number = dictionary.get('document_number')
        instructions = dictionary.get('instructions')
        billing_address = mundiapi.models.get_billing_address_response.GetBillingAddressResponse.from_dictionary(dictionary.get('billing_address')) if dictionary.get('billing_address') else None
        qr_code = dictionary.get('qr_code')
        line = dictionary.get('line')
        pdf_password = dictionary.get('pdf_password')
        pdf = dictionary.get('pdf')
        paid_amount = dictionary.get('paid_amount')
        mtype = dictionary.get('type')
        gateway_id = dictionary.get('gateway_id')
        amount = dictionary.get('amount')
        status = dictionary.get('status')
        success = dictionary.get('success')
        created_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("created_at")).datetime if dictionary.get("created_at") else None
        updated_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("updated_at")).datetime if dictionary.get("updated_at") else None
        attempt_count = dictionary.get('attempt_count')
        max_attempts = dictionary.get('max_attempts')
        splits = None
        if dictionary.get('splits') != None:
            splits = list()
            for structure in dictionary.get('splits'):
                splits.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        id = dictionary.get('id')
        gateway_response = mundiapi.models.get_gateway_response_response.GetGatewayResponseResponse.from_dictionary(dictionary.get('gateway_response')) if dictionary.get('gateway_response') else None
        antifraud_response = mundiapi.models.get_antifraud_response.GetAntifraudResponse.from_dictionary(dictionary.get('antifraud_response')) if dictionary.get('antifraud_response') else None
        split = None
        if dictionary.get('split') != None:
            split = list()
            for structure in dictionary.get('split'):
                split.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        due_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("due_at")).datetime if dictionary.get("due_at") else None
        paid_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("paid_at")).datetime if dictionary.get("paid_at") else None
        credit_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("credit_at")).datetime if dictionary.get("credit_at") else None
        next_attempt = APIHelper.RFC3339DateTime.from_value(dictionary.get("next_attempt")).datetime if dictionary.get("next_attempt") else None
        transaction_type = dictionary.get('transaction_type')
        metadata = dictionary.get('metadata')

        # Return an object of this model
        return cls(url,
                   barcode,
                   nosso_numero,
                   bank,
                   document_number,
                   instructions,
                   billing_address,
                   qr_code,
                   line,
                   pdf_password,
                   pdf,
                   paid_amount,
                   mtype,
                   gateway_id,
                   amount,
                   status,
                   success,
                   created_at,
                   updated_at,
                   attempt_count,
                   max_attempts,
                   splits,
                   id,
                   gateway_response,
                   antifraud_response,
                   split,
                   due_at,
                   paid_at,
                   credit_at,
                   next_attempt,
                   transaction_type,
                   metadata)


class GetCashTransactionResponse(GetTransactionResponse):

    """Implementation of the 'GetCashTransactionResponse' model.

    Response object for getting a cash transaction
    NOTE: This class inherits from 'GetTransactionResponse'.

    Attributes:
        description (string): Description

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "description":'description',
        "gateway_id":'gateway_id',
        "amount":'amount',
        "status":'status',
        "success":'success',
        "created_at":'created_at',
        "updated_at":'updated_at',
        "attempt_count":'attempt_count',
        "max_attempts":'max_attempts',
        "splits":'splits',
        "id":'id',
        "gateway_response":'gateway_response',
        "antifraud_response":'antifraud_response',
        "split":'split',
        "next_attempt":'next_attempt',
        "transaction_type":'transaction_type',
        "metadata":'metadata'
    }

    def __init__(self,
                 description=None,
                 gateway_id=None,
                 amount=None,
                 status=None,
                 success=None,
                 created_at=None,
                 updated_at=None,
                 attempt_count=None,
                 max_attempts=None,
                 splits=None,
                 id=None,
                 gateway_response=None,
                 antifraud_response=None,
                 split=None,
                 next_attempt=None,
                 transaction_type=None,
                 metadata=None):
        """Constructor for the GetCashTransactionResponse class"""

        # Initialize members of the class
        self.description = description

        # Call the constructor for the base class
        super(GetCashTransactionResponse, self).__init__(gateway_id,
                                                         amount,
                                                         status,
                                                         success,
                                                         created_at,
                                                         updated_at,
                                                         attempt_count,
                                                         max_attempts,
                                                         splits,
                                                         id,
                                                         gateway_response,
                                                         antifraud_response,
                                                         split,
                                                         next_attempt,
                                                         transaction_type,
                                                         metadata)


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        description = dictionary.get('description')
        gateway_id = dictionary.get('gateway_id')
        amount = dictionary.get('amount')
        status = dictionary.get('status')
        success = dictionary.get('success')
        created_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("created_at")).datetime if dictionary.get("created_at") else None
        updated_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("updated_at")).datetime if dictionary.get("updated_at") else None
        attempt_count = dictionary.get('attempt_count')
        max_attempts = dictionary.get('max_attempts')
        splits = None
        if dictionary.get('splits') != None:
            splits = list()
            for structure in dictionary.get('splits'):
                splits.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        id = dictionary.get('id')
        gateway_response = mundiapi.models.get_gateway_response_response.GetGatewayResponseResponse.from_dictionary(dictionary.get('gateway_response')) if dictionary.get('gateway_response') else None
        antifraud_response = mundiapi.models.get_antifraud_response.GetAntifraudResponse.from_dictionary(dictionary.get('antifraud_response')) if dictionary.get('antifraud_response') else None
        split = None
        if dictionary.get('split') != None:
            split = list()
            for structure in dictionary.get('split'):
                split.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        next_attempt = APIHelper.RFC3339DateTime.from_value(dictionary.get("next_attempt")).datetime if dictionary.get("next_attempt") else None
        transaction_type = dictionary.get('transaction_type')
        metadata = dictionary.get('metadata')

        # Return an object of this model
        return cls(description,
                   gateway_id,
                   amount,
                   status,
                   success,
                   created_at,
                   updated_at,
                   attempt_count,
                   max_attempts,
                   splits,
                   id,
                   gateway_response,
                   antifraud_response,
                   split,
                   next_attempt,
                   transaction_type,
                   metadata)


class GetSafetyPayTransactionResponse(GetTransactionResponse):

    """Implementation of the 'GetSafetyPayTransactionResponse' model.

    Response object for getting a safety pay transaction
    NOTE: This class inherits from 'GetTransactionResponse'.

    Attributes:
        url (string): Payment url
        bank_tid (string): Transaction identifier on bank
        paid_at (datetime): Payment date
        paid_amount (int): Paid amount

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "url":'url',
        "bank_tid":'bank_tid',
        "gateway_id":'gateway_id',
        "amount":'amount',
        "status":'status',
        "success":'success',
        "created_at":'created_at',
        "updated_at":'updated_at',
        "attempt_count":'attempt_count',
        "max_attempts":'max_attempts',
        "splits":'splits',
        "id":'id',
        "gateway_response":'gateway_response',
        "antifraud_response":'antifraud_response',
        "split":'split',
        "paid_at":'paid_at',
        "paid_amount":'paid_amount',
        "next_attempt":'next_attempt',
        "transaction_type":'transaction_type',
        "metadata":'metadata'
    }

    def __init__(self,
                 url=None,
                 bank_tid=None,
                 gateway_id=None,
                 amount=None,
                 status=None,
                 success=None,
                 created_at=None,
                 updated_at=None,
                 attempt_count=None,
                 max_attempts=None,
                 splits=None,
                 id=None,
                 gateway_response=None,
                 antifraud_response=None,
                 split=None,
                 paid_at=None,
                 paid_amount=None,
                 next_attempt=None,
                 transaction_type=None,
                 metadata=None):
        """Constructor for the GetSafetyPayTransactionResponse class"""

        # Initialize members of the class
        self.url = url
        self.bank_tid = bank_tid
        self.paid_at = APIHelper.RFC3339DateTime(paid_at) if paid_at else None
        self.paid_amount = paid_amount

        # Call the constructor for the base class
        super(GetSafetyPayTransactionResponse, self).__init__(gateway_id,
                                                              amount,
                                                              status,
                                                              success,
                                                              created_at,
                                                              updated_at,
                                                              attempt_count,
                                                              max_attempts,
                                                              splits,
                                                              id,
                                                              gateway_response,
                                                              antifraud_response,
                                                              split,
                                                              next_attempt,
                                                              transaction_type,
                                                              metadata)


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        url = dictionary.get('url')
        bank_tid = dictionary.get('bank_tid')
        gateway_id = dictionary.get('gateway_id')
        amount = dictionary.get('amount')
        status = dictionary.get('status')
        success = dictionary.get('success')
        created_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("created_at")).datetime if dictionary.get("created_at") else None
        updated_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("updated_at")).datetime if dictionary.get("updated_at") else None
        attempt_count = dictionary.get('attempt_count')
        max_attempts = dictionary.get('max_attempts')
        splits = None
        if dictionary.get('splits') != None:
            splits = list()
            for structure in dictionary.get('splits'):
                splits.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        id = dictionary.get('id')
        gateway_response = mundiapi.models.get_gateway_response_response.GetGatewayResponseResponse.from_dictionary(dictionary.get('gateway_response')) if dictionary.get('gateway_response') else None
        antifraud_response = mundiapi.models.get_antifraud_response.GetAntifraudResponse.from_dictionary(dictionary.get('antifraud_response')) if dictionary.get('antifraud_response') else None
        split = None
        if dictionary.get('split') != None:
            split = list()
            for structure in dictionary.get('split'):
                split.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        paid_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("paid_at")).datetime if dictionary.get("paid_at") else None
        paid_amount = dictionary.get('paid_amount')
        next_attempt = APIHelper.RFC3339DateTime.from_value(dictionary.get("next_attempt")).datetime if dictionary.get("next_attempt") else None
        transaction_type = dictionary.get('transaction_type')
        metadata = dictionary.get('metadata')

        # Return an object of this model
        return cls(url,
                   bank_tid,
                   gateway_id,
                   amount,
                   status,
                   success,
                   created_at,
                   updated_at,
                   attempt_count,
                   max_attempts,
                   splits,
                   id,
                   gateway_response,
                   antifraud_response,
                   split,
                   paid_at,
                   paid_amount,
                   next_attempt,
                   transaction_type,
                   metadata)


class GetCreditCardTransactionResponse(GetTransactionResponse):

    """Implementation of the 'GetCreditCardTransactionResponse' model.

    Response object for getting a credit card transaction
    NOTE: This class inherits from 'GetTransactionResponse'.

    Attributes:
        statement_descriptor (string): Text that will appear on the credit
            card's statement
        acquirer_name (string): Acquirer name
        acquirer_affiliation_code (string): Aquirer affiliation code
        acquirer_tid (string): Acquirer TID
        acquirer_nsu (string): Acquirer NSU
        acquirer_auth_code (string): Acquirer authorization code
        operation_type (string): Operation type
        card (GetCardResponse): Card data
        acquirer_message (string): Acquirer message
        acquirer_return_code (string): Acquirer Return Code
        installments (int): Number of installments
        threed_authentication_url (string): 3D-S authentication Url

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "statement_descriptor":'statement_descriptor',
        "acquirer_name":'acquirer_name',
        "acquirer_affiliation_code":'acquirer_affiliation_code',
        "acquirer_tid":'acquirer_tid',
        "acquirer_nsu":'acquirer_nsu',
        "acquirer_auth_code":'acquirer_auth_code',
        "operation_type":'operation_type',
        "card":'card',
        "acquirer_message":'acquirer_message',
        "acquirer_return_code":'acquirer_return_code',
        "threed_authentication_url":'threed_authentication_url',
        "gateway_id":'gateway_id',
        "amount":'amount',
        "status":'status',
        "success":'success',
        "created_at":'created_at',
        "updated_at":'updated_at',
        "attempt_count":'attempt_count',
        "max_attempts":'max_attempts',
        "splits":'splits',
        "id":'id',
        "gateway_response":'gateway_response',
        "antifraud_response":'antifraud_response',
        "split":'split',
        "installments":'installments',
        "next_attempt":'next_attempt',
        "transaction_type":'transaction_type',
        "metadata":'metadata'
    }

    def __init__(self,
                 statement_descriptor=None,
                 acquirer_name=None,
                 acquirer_affiliation_code=None,
                 acquirer_tid=None,
                 acquirer_nsu=None,
                 acquirer_auth_code=None,
                 operation_type=None,
                 card=None,
                 acquirer_message=None,
                 acquirer_return_code=None,
                 threed_authentication_url=None,
                 gateway_id=None,
                 amount=None,
                 status=None,
                 success=None,
                 created_at=None,
                 updated_at=None,
                 attempt_count=None,
                 max_attempts=None,
                 splits=None,
                 id=None,
                 gateway_response=None,
                 antifraud_response=None,
                 split=None,
                 installments=None,
                 next_attempt=None,
                 transaction_type=None,
                 metadata=None):
        """Constructor for the GetCreditCardTransactionResponse class"""

        # Initialize members of the class
        self.statement_descriptor = statement_descriptor
        self.acquirer_name = acquirer_name
        self.acquirer_affiliation_code = acquirer_affiliation_code
        self.acquirer_tid = acquirer_tid
        self.acquirer_nsu = acquirer_nsu
        self.acquirer_auth_code = acquirer_auth_code
        self.operation_type = operation_type
        self.card = card
        self.acquirer_message = acquirer_message
        self.acquirer_return_code = acquirer_return_code
        self.installments = installments
        self.threed_authentication_url = threed_authentication_url

        # Call the constructor for the base class
        super(GetCreditCardTransactionResponse, self).__init__(gateway_id,
                                                               amount,
                                                               status,
                                                               success,
                                                               created_at,
                                                               updated_at,
                                                               attempt_count,
                                                               max_attempts,
                                                               splits,
                                                               id,
                                                               gateway_response,
                                                               antifraud_response,
                                                               split,
                                                               next_attempt,
                                                               transaction_type,
                                                               metadata)


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        statement_descriptor = dictionary.get('statement_descriptor')
        acquirer_name = dictionary.get('acquirer_name')
        acquirer_affiliation_code = dictionary.get('acquirer_affiliation_code')
        acquirer_tid = dictionary.get('acquirer_tid')
        acquirer_nsu = dictionary.get('acquirer_nsu')
        acquirer_auth_code = dictionary.get('acquirer_auth_code')
        operation_type = dictionary.get('operation_type')
        card = mundiapi.models.get_card_response.GetCardResponse.from_dictionary(dictionary.get('card')) if dictionary.get('card') else None
        acquirer_message = dictionary.get('acquirer_message')
        acquirer_return_code = dictionary.get('acquirer_return_code')
        threed_authentication_url = dictionary.get('threed_authentication_url')
        gateway_id = dictionary.get('gateway_id')
        amount = dictionary.get('amount')
        status = dictionary.get('status')
        success = dictionary.get('success')
        created_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("created_at")).datetime if dictionary.get("created_at") else None
        updated_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("updated_at")).datetime if dictionary.get("updated_at") else None
        attempt_count = dictionary.get('attempt_count')
        max_attempts = dictionary.get('max_attempts')
        splits = None
        if dictionary.get('splits') != None:
            splits = list()
            for structure in dictionary.get('splits'):
                splits.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        id = dictionary.get('id')
        gateway_response = mundiapi.models.get_gateway_response_response.GetGatewayResponseResponse.from_dictionary(dictionary.get('gateway_response')) if dictionary.get('gateway_response') else None
        antifraud_response = mundiapi.models.get_antifraud_response.GetAntifraudResponse.from_dictionary(dictionary.get('antifraud_response')) if dictionary.get('antifraud_response') else None
        split = None
        if dictionary.get('split') != None:
            split = list()
            for structure in dictionary.get('split'):
                split.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        installments = dictionary.get('installments')
        next_attempt = APIHelper.RFC3339DateTime.from_value(dictionary.get("next_attempt")).datetime if dictionary.get("next_attempt") else None
        transaction_type = dictionary.get('transaction_type')
        metadata = dictionary.get('metadata')

        # Return an object of this model
        return cls(statement_descriptor,
                   acquirer_name,
                   acquirer_affiliation_code,
                   acquirer_tid,
                   acquirer_nsu,
                   acquirer_auth_code,
                   operation_type,
                   card,
                   acquirer_message,
                   acquirer_return_code,
                   threed_authentication_url,
                   gateway_id,
                   amount,
                   status,
                   success,
                   created_at,
                   updated_at,
                   attempt_count,
                   max_attempts,
                   splits,
                   id,
                   gateway_response,
                   antifraud_response,
                   split,
                   installments,
                   next_attempt,
                   transaction_type,
                   metadata)


class GetPrivateLabelTransactionResponse(GetTransactionResponse):

    """Implementation of the 'GetPrivateLabelTransactionResponse' model.

    Response object for getting a private label transaction
    NOTE: This class inherits from 'GetTransactionResponse'.

    Attributes:
        statement_descriptor (string): Text that will appear on the credit
            card's statement
        acquirer_name (string): Acquirer name
        acquirer_affiliation_code (string): Aquirer affiliation code
        acquirer_tid (string): Acquirer TID
        acquirer_nsu (string): Acquirer NSU
        acquirer_auth_code (string): Acquirer authorization code
        operation_type (string): Operation type
        card (GetCardResponse): Card data
        acquirer_message (string): Acquirer message
        acquirer_return_code (string): Acquirer Return Code
        installments (int): Number of installments

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "statement_descriptor":'statement_descriptor',
        "acquirer_name":'acquirer_name',
        "acquirer_affiliation_code":'acquirer_affiliation_code',
        "acquirer_tid":'acquirer_tid',
        "acquirer_nsu":'acquirer_nsu',
        "acquirer_auth_code":'acquirer_auth_code',
        "operation_type":'operation_type',
        "card":'card',
        "acquirer_message":'acquirer_message',
        "acquirer_return_code":'acquirer_return_code',
        "gateway_id":'gateway_id',
        "amount":'amount',
        "status":'status',
        "success":'success',
        "created_at":'created_at',
        "updated_at":'updated_at',
        "attempt_count":'attempt_count',
        "max_attempts":'max_attempts',
        "splits":'splits',
        "id":'id',
        "gateway_response":'gateway_response',
        "antifraud_response":'antifraud_response',
        "split":'split',
        "installments":'installments',
        "next_attempt":'next_attempt',
        "transaction_type":'transaction_type',
        "metadata":'metadata'
    }

    def __init__(self,
                 statement_descriptor=None,
                 acquirer_name=None,
                 acquirer_affiliation_code=None,
                 acquirer_tid=None,
                 acquirer_nsu=None,
                 acquirer_auth_code=None,
                 operation_type=None,
                 card=None,
                 acquirer_message=None,
                 acquirer_return_code=None,
                 gateway_id=None,
                 amount=None,
                 status=None,
                 success=None,
                 created_at=None,
                 updated_at=None,
                 attempt_count=None,
                 max_attempts=None,
                 splits=None,
                 id=None,
                 gateway_response=None,
                 antifraud_response=None,
                 split=None,
                 installments=None,
                 next_attempt=None,
                 transaction_type=None,
                 metadata=None):
        """Constructor for the GetPrivateLabelTransactionResponse class"""

        # Initialize members of the class
        self.statement_descriptor = statement_descriptor
        self.acquirer_name = acquirer_name
        self.acquirer_affiliation_code = acquirer_affiliation_code
        self.acquirer_tid = acquirer_tid
        self.acquirer_nsu = acquirer_nsu
        self.acquirer_auth_code = acquirer_auth_code
        self.operation_type = operation_type
        self.card = card
        self.acquirer_message = acquirer_message
        self.acquirer_return_code = acquirer_return_code
        self.installments = installments

        # Call the constructor for the base class
        super(GetPrivateLabelTransactionResponse, self).__init__(gateway_id,
                                                                 amount,
                                                                 status,
                                                                 success,
                                                                 created_at,
                                                                 updated_at,
                                                                 attempt_count,
                                                                 max_attempts,
                                                                 splits,
                                                                 id,
                                                                 gateway_response,
                                                                 antifraud_response,
                                                                 split,
                                                                 next_attempt,
                                                                 transaction_type,
                                                                 metadata)


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        statement_descriptor = dictionary.get('statement_descriptor')
        acquirer_name = dictionary.get('acquirer_name')
        acquirer_affiliation_code = dictionary.get('acquirer_affiliation_code')
        acquirer_tid = dictionary.get('acquirer_tid')
        acquirer_nsu = dictionary.get('acquirer_nsu')
        acquirer_auth_code = dictionary.get('acquirer_auth_code')
        operation_type = dictionary.get('operation_type')
        card = mundiapi.models.get_card_response.GetCardResponse.from_dictionary(dictionary.get('card')) if dictionary.get('card') else None
        acquirer_message = dictionary.get('acquirer_message')
        acquirer_return_code = dictionary.get('acquirer_return_code')
        gateway_id = dictionary.get('gateway_id')
        amount = dictionary.get('amount')
        status = dictionary.get('status')
        success = dictionary.get('success')
        created_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("created_at")).datetime if dictionary.get("created_at") else None
        updated_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("updated_at")).datetime if dictionary.get("updated_at") else None
        attempt_count = dictionary.get('attempt_count')
        max_attempts = dictionary.get('max_attempts')
        splits = None
        if dictionary.get('splits') != None:
            splits = list()
            for structure in dictionary.get('splits'):
                splits.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        id = dictionary.get('id')
        gateway_response = mundiapi.models.get_gateway_response_response.GetGatewayResponseResponse.from_dictionary(dictionary.get('gateway_response')) if dictionary.get('gateway_response') else None
        antifraud_response = mundiapi.models.get_antifraud_response.GetAntifraudResponse.from_dictionary(dictionary.get('antifraud_response')) if dictionary.get('antifraud_response') else None
        split = None
        if dictionary.get('split') != None:
            split = list()
            for structure in dictionary.get('split'):
                split.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        installments = dictionary.get('installments')
        next_attempt = APIHelper.RFC3339DateTime.from_value(dictionary.get("next_attempt")).datetime if dictionary.get("next_attempt") else None
        transaction_type = dictionary.get('transaction_type')
        metadata = dictionary.get('metadata')

        # Return an object of this model
        return cls(statement_descriptor,
                   acquirer_name,
                   acquirer_affiliation_code,
                   acquirer_tid,
                   acquirer_nsu,
                   acquirer_auth_code,
                   operation_type,
                   card,
                   acquirer_message,
                   acquirer_return_code,
                   gateway_id,
                   amount,
                   status,
                   success,
                   created_at,
                   updated_at,
                   attempt_count,
                   max_attempts,
                   splits,
                   id,
                   gateway_response,
                   antifraud_response,
                   split,
                   installments,
                   next_attempt,
                   transaction_type,
                   metadata)


class GetPixTransactionResponse(GetTransactionResponse):

    """Implementation of the 'GetPixTransactionResponse' model.

    Response object when getting a pix transaction
    NOTE: This class inherits from 'GetTransactionResponse'.

    Attributes:
        qr_code (string): TODO: type description here.
        qr_code_url (string): TODO: type description here.
        expires_at (datetime): TODO: type description here.
        additional_information (list of PixAdditionalInformation): TODO: type
            description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "qr_code":'qr_code',
        "qr_code_url":'qr_code_url',
        "expires_at":'expires_at',
        "additional_information":'additional_information',
        "gateway_id":'gateway_id',
        "amount":'amount',
        "status":'status',
        "success":'success',
        "created_at":'created_at',
        "updated_at":'updated_at',
        "attempt_count":'attempt_count',
        "max_attempts":'max_attempts',
        "splits":'splits',
        "id":'id',
        "gateway_response":'gateway_response',
        "antifraud_response":'antifraud_response',
        "split":'split',
        "next_attempt":'next_attempt',
        "transaction_type":'transaction_type',
        "metadata":'metadata'
    }

    def __init__(self,
                 qr_code=None,
                 qr_code_url=None,
                 expires_at=None,
                 additional_information=None,
                 gateway_id=None,
                 amount=None,
                 status=None,
                 success=None,
                 created_at=None,
                 updated_at=None,
                 attempt_count=None,
                 max_attempts=None,
                 splits=None,
                 id=None,
                 gateway_response=None,
                 antifraud_response=None,
                 split=None,
                 next_attempt=None,
                 transaction_type=None,
                 metadata=None):
        """Constructor for the GetPixTransactionResponse class"""

        # Initialize members of the class
        self.qr_code = qr_code
        self.qr_code_url = qr_code_url
        self.expires_at = APIHelper.RFC3339DateTime(expires_at) if expires_at else None
        self.additional_information = additional_information

        # Call the constructor for the base class
        super(GetPixTransactionResponse, self).__init__(gateway_id,
                                                        amount,
                                                        status,
                                                        success,
                                                        created_at,
                                                        updated_at,
                                                        attempt_count,
                                                        max_attempts,
                                                        splits,
                                                        id,
                                                        gateway_response,
                                                        antifraud_response,
                                                        split,
                                                        next_attempt,
                                                        transaction_type,
                                                        metadata)


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        qr_code = dictionary.get('qr_code')
        qr_code_url = dictionary.get('qr_code_url')
        expires_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("expires_at")).datetime if dictionary.get("expires_at") else None
        additional_information = None
        if dictionary.get('additional_information') != None:
            additional_information = list()
            for structure in dictionary.get('additional_information'):
                additional_information.append(mundiapi.models.pix_additional_information.PixAdditionalInformation.from_dictionary(structure))
        gateway_id = dictionary.get('gateway_id')
        amount = dictionary.get('amount')
        status = dictionary.get('status')
        success = dictionary.get('success')
        created_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("created_at")).datetime if dictionary.get("created_at") else None
        updated_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("updated_at")).datetime if dictionary.get("updated_at") else None
        attempt_count = dictionary.get('attempt_count')
        max_attempts = dictionary.get('max_attempts')
        splits = None
        if dictionary.get('splits') != None:
            splits = list()
            for structure in dictionary.get('splits'):
                splits.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        id = dictionary.get('id')
        gateway_response = mundiapi.models.get_gateway_response_response.GetGatewayResponseResponse.from_dictionary(dictionary.get('gateway_response')) if dictionary.get('gateway_response') else None
        antifraud_response = mundiapi.models.get_antifraud_response.GetAntifraudResponse.from_dictionary(dictionary.get('antifraud_response')) if dictionary.get('antifraud_response') else None
        split = None
        if dictionary.get('split') != None:
            split = list()
            for structure in dictionary.get('split'):
                split.append(mundiapi.models.get_split_response.GetSplitResponse.from_dictionary(structure))
        next_attempt = APIHelper.RFC3339DateTime.from_value(dictionary.get("next_attempt")).datetime if dictionary.get("next_attempt") else None
        transaction_type = dictionary.get('transaction_type')
        metadata = dictionary.get('metadata')

        # Return an object of this model
        return cls(qr_code,
                   qr_code_url,
                   expires_at,
                   additional_information,
                   gateway_id,
                   amount,
                   status,
                   success,
                   created_at,
                   updated_at,
                   attempt_count,
                   max_attempts,
                   splits,
                   id,
                   gateway_response,
                   antifraud_response,
                   split,
                   next_attempt,
                   transaction_type,
                   metadata)


