# kkpyui

Tkinter-based GUI widget library for building small tool applications

## Motivation

- Small GUI tools come in handy in experiments and atomic productivity boosts

- Full-fledged GUI toolkits such as GTK or Qt and web-app frameworks are often too heavy for these purposes

- Python is my go-to dev language and its bundled Tkinter (with its `ttk` ) in theory is well-suited for small tool development, but it is often criticized for being outdated and too clunky to use; however, it remains attractive for distribution convenience

- This project thus aims to enhance Tkinter for developing small tools features by creating a thin wrapper, hoping to reduce boilerplates in app code

## Features

- Single-page form UI building blocks with data-binding widgets

- Model-View-Controller architecture

- Input validation 

- Per-entry default values

- Per-entry help doc

- Saving and loading presets

- Customizable parameter tracers

## Demo
```sh
cd /path/to/kkpyui
poetry install

# run form demo
poetry run python demo/form.py

# run controller demo
poetry run python demo/controller.py
```
