# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.paginate_match import PaginateMatch
from vulncheck_sdk.models.paginate_param import PaginateParam
from typing import Optional, Set
from typing_extensions import Self

class PaginatePagination(BaseModel):
    """
    PaginatePagination
    """ # noqa: E501
    cursor: Optional[StrictStr] = Field(default=None, description="Cursor for the current page")
    first_item: Optional[StrictInt] = Field(default=None, description="First and last Item")
    index: Optional[StrictStr] = Field(default=None, description="The requested index")
    last_item: Optional[StrictInt] = None
    limit: Optional[StrictInt] = Field(default=None, description="Per-Page limit")
    matches: Optional[List[PaginateMatch]] = None
    max_pages: Optional[StrictInt] = None
    next_cursor: Optional[StrictStr] = Field(default=None, description="Cursor for the next page")
    opensearch_query: Optional[Dict[str, Any]] = None
    order: Optional[StrictStr] = None
    page: Optional[StrictInt] = Field(default=None, description="The current Page number")
    pages: Optional[List[StrictStr]] = None
    parameters: Optional[List[PaginateParam]] = None
    show_pages: Optional[StrictBool] = None
    show_query: Optional[StrictBool] = None
    sort: Optional[StrictStr] = None
    timestamp: Optional[StrictStr] = None
    total_documents: Optional[StrictInt] = Field(default=None, description="The total number of items")
    total_pages: Optional[StrictInt] = Field(default=None, description="The total number of pages")
    warnings: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["cursor", "first_item", "index", "last_item", "limit", "matches", "max_pages", "next_cursor", "opensearch_query", "order", "page", "pages", "parameters", "show_pages", "show_query", "sort", "timestamp", "total_documents", "total_pages", "warnings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PaginatePagination from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in matches (list)
        _items = []
        if self.matches:
            for _item_matches in self.matches:
                if _item_matches:
                    _items.append(_item_matches.to_dict())
            _dict['matches'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in parameters (list)
        _items = []
        if self.parameters:
            for _item_parameters in self.parameters:
                if _item_parameters:
                    _items.append(_item_parameters.to_dict())
            _dict['parameters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PaginatePagination from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cursor": obj.get("cursor"),
            "first_item": obj.get("first_item"),
            "index": obj.get("index"),
            "last_item": obj.get("last_item"),
            "limit": obj.get("limit"),
            "matches": [PaginateMatch.from_dict(_item) for _item in obj["matches"]] if obj.get("matches") is not None else None,
            "max_pages": obj.get("max_pages"),
            "next_cursor": obj.get("next_cursor"),
            "opensearch_query": obj.get("opensearch_query"),
            "order": obj.get("order"),
            "page": obj.get("page"),
            "pages": obj.get("pages"),
            "parameters": [PaginateParam.from_dict(_item) for _item in obj["parameters"]] if obj.get("parameters") is not None else None,
            "show_pages": obj.get("show_pages"),
            "show_query": obj.get("show_query"),
            "sort": obj.get("sort"),
            "timestamp": obj.get("timestamp"),
            "total_documents": obj.get("total_documents"),
            "total_pages": obj.get("total_pages"),
            "warnings": obj.get("warnings")
        })
        return _obj


