# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_nvd20_configuration import AdvisoryNVD20Configuration
from vulncheck_sdk.models.api_categorization_extended import ApiCategorizationExtended
from vulncheck_sdk.models.api_mitre_attack_tech import ApiMitreAttackTech
from vulncheck_sdk.models.api_nvd20_description import ApiNVD20Description
from vulncheck_sdk.models.api_nvd20_metric_extended import ApiNVD20MetricExtended
from vulncheck_sdk.models.api_nvd20_reference_extended import ApiNVD20ReferenceExtended
from vulncheck_sdk.models.api_nvd20_vendor_comment import ApiNVD20VendorComment
from vulncheck_sdk.models.api_nvd20_weakness_extended import ApiNVD20WeaknessExtended
from vulncheck_sdk.models.api_related_attack_pattern import ApiRelatedAttackPattern
from typing import Optional, Set
from typing_extensions import Self

class ApiNVD20CVEExtended(BaseModel):
    """
    ApiNVD20CVEExtended
    """ # noqa: E501
    alias: Optional[StrictStr] = Field(default=None, alias="ALIAS")
    status: Optional[StrictStr] = Field(default=None, alias="STATUS")
    timestamp: Optional[StrictStr] = Field(default=None, description="the deep tag instructs deep.Equal to ignore this field (used during OpenSearch loading)", alias="_timestamp")
    categorization: Optional[ApiCategorizationExtended] = None
    cisa_action_due: Optional[StrictStr] = Field(default=None, alias="cisaActionDue")
    cisa_exploit_add: Optional[StrictStr] = Field(default=None, alias="cisaExploitAdd")
    cisa_required_action: Optional[StrictStr] = Field(default=None, alias="cisaRequiredAction")
    cisa_vulnerability_name: Optional[StrictStr] = Field(default=None, alias="cisaVulnerabilityName")
    configurations: Optional[List[AdvisoryNVD20Configuration]] = None
    date_added: Optional[StrictStr] = None
    descriptions: Optional[List[ApiNVD20Description]] = None
    document_generation_date: Optional[StrictStr] = Field(default=None, alias="documentGenerationDate")
    evaluator_comment: Optional[StrictStr] = Field(default=None, alias="evaluatorComment")
    evaluator_impact: Optional[StrictStr] = Field(default=None, alias="evaluatorImpact")
    evaluator_solution: Optional[StrictStr] = Field(default=None, alias="evaluatorSolution")
    id: Optional[StrictStr] = None
    last_modified: Optional[StrictStr] = Field(default=None, alias="lastModified")
    metrics: Optional[ApiNVD20MetricExtended] = None
    mitre_attack_techniques: Optional[List[ApiMitreAttackTech]] = Field(default=None, alias="mitreAttackTechniques")
    published: Optional[StrictStr] = None
    references: Optional[List[ApiNVD20ReferenceExtended]] = None
    related_attack_patterns: Optional[List[ApiRelatedAttackPattern]] = Field(default=None, alias="relatedAttackPatterns")
    source_identifier: Optional[StrictStr] = Field(default=None, alias="sourceIdentifier")
    vc_configurations: Optional[List[AdvisoryNVD20Configuration]] = Field(default=None, alias="vcConfigurations")
    vc_vulnerable_cpes: Optional[List[StrictStr]] = Field(default=None, alias="vcVulnerableCPEs")
    vendor_comments: Optional[List[ApiNVD20VendorComment]] = Field(default=None, alias="vendorComments")
    vuln_status: Optional[StrictStr] = Field(default=None, alias="vulnStatus")
    vulncheck_kev_exploit_add: Optional[StrictStr] = Field(default=None, alias="vulncheckKEVExploitAdd")
    vulnerable_cpes: Optional[List[StrictStr]] = Field(default=None, alias="vulnerableCPEs")
    weaknesses: Optional[List[ApiNVD20WeaknessExtended]] = None
    __properties: ClassVar[List[str]] = ["ALIAS", "STATUS", "_timestamp", "categorization", "cisaActionDue", "cisaExploitAdd", "cisaRequiredAction", "cisaVulnerabilityName", "configurations", "date_added", "descriptions", "documentGenerationDate", "evaluatorComment", "evaluatorImpact", "evaluatorSolution", "id", "lastModified", "metrics", "mitreAttackTechniques", "published", "references", "relatedAttackPatterns", "sourceIdentifier", "vcConfigurations", "vcVulnerableCPEs", "vendorComments", "vulnStatus", "vulncheckKEVExploitAdd", "vulnerableCPEs", "weaknesses"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiNVD20CVEExtended from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of categorization
        if self.categorization:
            _dict['categorization'] = self.categorization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in configurations (list)
        _items = []
        if self.configurations:
            for _item_configurations in self.configurations:
                if _item_configurations:
                    _items.append(_item_configurations.to_dict())
            _dict['configurations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in descriptions (list)
        _items = []
        if self.descriptions:
            for _item_descriptions in self.descriptions:
                if _item_descriptions:
                    _items.append(_item_descriptions.to_dict())
            _dict['descriptions'] = _items
        # override the default output from pydantic by calling `to_dict()` of metrics
        if self.metrics:
            _dict['metrics'] = self.metrics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in mitre_attack_techniques (list)
        _items = []
        if self.mitre_attack_techniques:
            for _item_mitre_attack_techniques in self.mitre_attack_techniques:
                if _item_mitre_attack_techniques:
                    _items.append(_item_mitre_attack_techniques.to_dict())
            _dict['mitreAttackTechniques'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item_references in self.references:
                if _item_references:
                    _items.append(_item_references.to_dict())
            _dict['references'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in related_attack_patterns (list)
        _items = []
        if self.related_attack_patterns:
            for _item_related_attack_patterns in self.related_attack_patterns:
                if _item_related_attack_patterns:
                    _items.append(_item_related_attack_patterns.to_dict())
            _dict['relatedAttackPatterns'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in vc_configurations (list)
        _items = []
        if self.vc_configurations:
            for _item_vc_configurations in self.vc_configurations:
                if _item_vc_configurations:
                    _items.append(_item_vc_configurations.to_dict())
            _dict['vcConfigurations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in vendor_comments (list)
        _items = []
        if self.vendor_comments:
            for _item_vendor_comments in self.vendor_comments:
                if _item_vendor_comments:
                    _items.append(_item_vendor_comments.to_dict())
            _dict['vendorComments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in weaknesses (list)
        _items = []
        if self.weaknesses:
            for _item_weaknesses in self.weaknesses:
                if _item_weaknesses:
                    _items.append(_item_weaknesses.to_dict())
            _dict['weaknesses'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiNVD20CVEExtended from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ALIAS": obj.get("ALIAS"),
            "STATUS": obj.get("STATUS"),
            "_timestamp": obj.get("_timestamp"),
            "categorization": ApiCategorizationExtended.from_dict(obj["categorization"]) if obj.get("categorization") is not None else None,
            "cisaActionDue": obj.get("cisaActionDue"),
            "cisaExploitAdd": obj.get("cisaExploitAdd"),
            "cisaRequiredAction": obj.get("cisaRequiredAction"),
            "cisaVulnerabilityName": obj.get("cisaVulnerabilityName"),
            "configurations": [AdvisoryNVD20Configuration.from_dict(_item) for _item in obj["configurations"]] if obj.get("configurations") is not None else None,
            "date_added": obj.get("date_added"),
            "descriptions": [ApiNVD20Description.from_dict(_item) for _item in obj["descriptions"]] if obj.get("descriptions") is not None else None,
            "documentGenerationDate": obj.get("documentGenerationDate"),
            "evaluatorComment": obj.get("evaluatorComment"),
            "evaluatorImpact": obj.get("evaluatorImpact"),
            "evaluatorSolution": obj.get("evaluatorSolution"),
            "id": obj.get("id"),
            "lastModified": obj.get("lastModified"),
            "metrics": ApiNVD20MetricExtended.from_dict(obj["metrics"]) if obj.get("metrics") is not None else None,
            "mitreAttackTechniques": [ApiMitreAttackTech.from_dict(_item) for _item in obj["mitreAttackTechniques"]] if obj.get("mitreAttackTechniques") is not None else None,
            "published": obj.get("published"),
            "references": [ApiNVD20ReferenceExtended.from_dict(_item) for _item in obj["references"]] if obj.get("references") is not None else None,
            "relatedAttackPatterns": [ApiRelatedAttackPattern.from_dict(_item) for _item in obj["relatedAttackPatterns"]] if obj.get("relatedAttackPatterns") is not None else None,
            "sourceIdentifier": obj.get("sourceIdentifier"),
            "vcConfigurations": [AdvisoryNVD20Configuration.from_dict(_item) for _item in obj["vcConfigurations"]] if obj.get("vcConfigurations") is not None else None,
            "vcVulnerableCPEs": obj.get("vcVulnerableCPEs"),
            "vendorComments": [ApiNVD20VendorComment.from_dict(_item) for _item in obj["vendorComments"]] if obj.get("vendorComments") is not None else None,
            "vulnStatus": obj.get("vulnStatus"),
            "vulncheckKEVExploitAdd": obj.get("vulncheckKEVExploitAdd"),
            "vulnerableCPEs": obj.get("vulnerableCPEs"),
            "weaknesses": [ApiNVD20WeaknessExtended.from_dict(_item) for _item in obj["weaknesses"]] if obj.get("weaknesses") is not None else None
        })
        return _obj


