# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ApiInitialAccessArtifact(BaseModel):
    """
    ApiInitialAccessArtifact
    """ # noqa: E501
    artifact_name: Optional[StrictStr] = Field(default=None, description="ArtifactName is a title to associate with this artifact.", alias="artifactName")
    artifacts_url: Optional[List[StrictStr]] = Field(default=None, description="ArtifactsURL are URLs to the available artifact.", alias="artifactsURL")
    censys_queries: Optional[List[StrictStr]] = Field(default=None, description="CensysQueries are queries for examining potential Internet-exposed devices & applications with Censys in URL form.", alias="censysQueries")
    censys_raw_queries: Optional[List[StrictStr]] = Field(default=None, description="CensysRawQueries are raw queries for examining potential Internet-exposed devices & applications with Censys.", alias="censysRawQueries")
    clone_sshurl: Optional[StrictStr] = Field(default=None, description="CloneSSHURL is the git URL to clone the artifact with.", alias="cloneSSHURL")
    date_added: Optional[StrictStr] = Field(default=None, description="DateAdded is when this artifact entry was first added to the InitialAccess data set.", alias="dateAdded")
    exploit: Optional[StrictBool] = Field(default=None, description="Exploit indicates whether or not an exploit is available in this artifact.")
    fofa_queries: Optional[List[StrictStr]] = Field(default=None, description="FOFAQueries are raw queries for examining potential Internet-exposed devices & applications with FOFA.", alias="fofaQueries")
    greynoise_queries: Optional[List[StrictStr]] = Field(default=None, description="GreynoiseQueries are queries for finding the vulnerability via honeypot data.", alias="greynoiseQueries")
    nmap_script: Optional[StrictBool] = Field(default=None, description="NmapScript indicates whether or not an nmap script for scanning environment exists in this artifact.", alias="nmapScript")
    pcap: Optional[StrictBool] = Field(default=None, description="PCAP indicates whether of not a package capture of the exploit PoC exploiting a vulnerable system exists in this artifact.")
    product: Optional[List[StrictStr]] = Field(default=None, description="Product are the software that has the vulnerability.")
    shodan_queries: Optional[List[StrictStr]] = Field(default=None, description="ShodanQueries are queries for examining potential Internet-exposed devices & applications with Shodan in URL form.", alias="shodanQueries")
    shodan_raw_queries: Optional[List[StrictStr]] = Field(default=None, description="ShodanRawQueries are raw queries for examining potential Internet-exposed devices & applications with Shodan.", alias="shodanRawQueries")
    snort_rule: Optional[StrictBool] = Field(default=None, description="SnortRule indicates whether or not a Snort rule designed to detect the exploitation of the vulnerability over the network exists in this artifact.", alias="snortRule")
    suricata_rule: Optional[StrictBool] = Field(default=None, description="SuricataRule indicates whether or not a Suricata rule designed to detect the exploitation of the vulnerability over the network exists in this artifact.", alias="suricataRule")
    target_docker: Optional[StrictBool] = Field(default=None, description="TargetDocker indicates whether or not there is an available docker image with the vulnerability.", alias="targetDocker")
    target_service: Optional[StrictStr] = Field(default=None, description="TargetService indicates the service (HTTP, FTP, etc) that this exploit targets.", alias="targetService")
    vendor: Optional[StrictStr] = Field(default=None, description="Vendor of the vulnerable product")
    version_scanner: Optional[StrictBool] = Field(default=None, description="VersionScanner indicates whether or not the exploit PoC can determine if target system is vulnerable without sending exploit payload in this artifact.", alias="versionScanner")
    yara: Optional[StrictBool] = Field(default=None, description="YARA indicates whether or not a YARA rule designed to detect the exploit on an endpoint exists in this artifact.")
    zeroday: Optional[StrictBool] = Field(default=None, description="Zeroday indicates whether or not it is a VulnCheck zeroday.")
    zoom_eye_queries: Optional[List[StrictStr]] = Field(default=None, description="ZoomEyeQueries are raw queries for examining potential Internet-exposed devices & applications with ZoomEye.", alias="zoomEyeQueries")
    __properties: ClassVar[List[str]] = ["artifactName", "artifactsURL", "censysQueries", "censysRawQueries", "cloneSSHURL", "dateAdded", "exploit", "fofaQueries", "greynoiseQueries", "nmapScript", "pcap", "product", "shodanQueries", "shodanRawQueries", "snortRule", "suricataRule", "targetDocker", "targetService", "vendor", "versionScanner", "yara", "zeroday", "zoomEyeQueries"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiInitialAccessArtifact from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiInitialAccessArtifact from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "artifactName": obj.get("artifactName"),
            "artifactsURL": obj.get("artifactsURL"),
            "censysQueries": obj.get("censysQueries"),
            "censysRawQueries": obj.get("censysRawQueries"),
            "cloneSSHURL": obj.get("cloneSSHURL"),
            "dateAdded": obj.get("dateAdded"),
            "exploit": obj.get("exploit"),
            "fofaQueries": obj.get("fofaQueries"),
            "greynoiseQueries": obj.get("greynoiseQueries"),
            "nmapScript": obj.get("nmapScript"),
            "pcap": obj.get("pcap"),
            "product": obj.get("product"),
            "shodanQueries": obj.get("shodanQueries"),
            "shodanRawQueries": obj.get("shodanRawQueries"),
            "snortRule": obj.get("snortRule"),
            "suricataRule": obj.get("suricataRule"),
            "targetDocker": obj.get("targetDocker"),
            "targetService": obj.get("targetService"),
            "vendor": obj.get("vendor"),
            "versionScanner": obj.get("versionScanner"),
            "yara": obj.get("yara"),
            "zeroday": obj.get("zeroday"),
            "zoomEyeQueries": obj.get("zoomEyeQueries")
        })
        return _obj


