# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_cvssv40 import AdvisoryCVSSV40
from vulncheck_sdk.models.advisory_cvssv40_threat import AdvisoryCVSSV40Threat
from vulncheck_sdk.models.api_base_metric_v2 import ApiBaseMetricV2
from vulncheck_sdk.models.api_base_metric_v3 import ApiBaseMetricV3
from vulncheck_sdk.models.api_epss import ApiEPSS
from vulncheck_sdk.models.api_ssvc import ApiSSVC
from vulncheck_sdk.models.api_temporal_metric_v2 import ApiTemporalMetricV2
from vulncheck_sdk.models.api_temporal_metric_v3 import ApiTemporalMetricV3
from typing import Optional, Set
from typing_extensions import Self

class ApiImpactExtended(BaseModel):
    """
    ApiImpactExtended
    """ # noqa: E501
    base_metric_v2: Optional[ApiBaseMetricV2] = Field(default=None, alias="baseMetricV2")
    base_metric_v3: Optional[ApiBaseMetricV3] = Field(default=None, alias="baseMetricV3")
    corrected_base_metric_v3: Optional[ApiBaseMetricV3] = Field(default=None, alias="correctedBaseMetricV3")
    epss: Optional[ApiEPSS] = None
    metric_v40: Optional[AdvisoryCVSSV40] = Field(default=None, alias="metricV40")
    ssvc: Optional[List[ApiSSVC]] = None
    temporal_metric_v2: Optional[ApiTemporalMetricV2] = Field(default=None, alias="temporalMetricV2")
    temporal_metric_v3: Optional[ApiTemporalMetricV3] = Field(default=None, alias="temporalMetricV3")
    temporal_v3_corrected: Optional[ApiTemporalMetricV3] = Field(default=None, alias="temporalV3Corrected")
    threat_metric_v40: Optional[AdvisoryCVSSV40Threat] = Field(default=None, alias="threatMetricV40")
    __properties: ClassVar[List[str]] = ["baseMetricV2", "baseMetricV3", "correctedBaseMetricV3", "epss", "metricV40", "ssvc", "temporalMetricV2", "temporalMetricV3", "temporalV3Corrected", "threatMetricV40"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiImpactExtended from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of base_metric_v2
        if self.base_metric_v2:
            _dict['baseMetricV2'] = self.base_metric_v2.to_dict()
        # override the default output from pydantic by calling `to_dict()` of base_metric_v3
        if self.base_metric_v3:
            _dict['baseMetricV3'] = self.base_metric_v3.to_dict()
        # override the default output from pydantic by calling `to_dict()` of corrected_base_metric_v3
        if self.corrected_base_metric_v3:
            _dict['correctedBaseMetricV3'] = self.corrected_base_metric_v3.to_dict()
        # override the default output from pydantic by calling `to_dict()` of epss
        if self.epss:
            _dict['epss'] = self.epss.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metric_v40
        if self.metric_v40:
            _dict['metricV40'] = self.metric_v40.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in ssvc (list)
        _items = []
        if self.ssvc:
            for _item_ssvc in self.ssvc:
                if _item_ssvc:
                    _items.append(_item_ssvc.to_dict())
            _dict['ssvc'] = _items
        # override the default output from pydantic by calling `to_dict()` of temporal_metric_v2
        if self.temporal_metric_v2:
            _dict['temporalMetricV2'] = self.temporal_metric_v2.to_dict()
        # override the default output from pydantic by calling `to_dict()` of temporal_metric_v3
        if self.temporal_metric_v3:
            _dict['temporalMetricV3'] = self.temporal_metric_v3.to_dict()
        # override the default output from pydantic by calling `to_dict()` of temporal_v3_corrected
        if self.temporal_v3_corrected:
            _dict['temporalV3Corrected'] = self.temporal_v3_corrected.to_dict()
        # override the default output from pydantic by calling `to_dict()` of threat_metric_v40
        if self.threat_metric_v40:
            _dict['threatMetricV40'] = self.threat_metric_v40.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiImpactExtended from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "baseMetricV2": ApiBaseMetricV2.from_dict(obj["baseMetricV2"]) if obj.get("baseMetricV2") is not None else None,
            "baseMetricV3": ApiBaseMetricV3.from_dict(obj["baseMetricV3"]) if obj.get("baseMetricV3") is not None else None,
            "correctedBaseMetricV3": ApiBaseMetricV3.from_dict(obj["correctedBaseMetricV3"]) if obj.get("correctedBaseMetricV3") is not None else None,
            "epss": ApiEPSS.from_dict(obj["epss"]) if obj.get("epss") is not None else None,
            "metricV40": AdvisoryCVSSV40.from_dict(obj["metricV40"]) if obj.get("metricV40") is not None else None,
            "ssvc": [ApiSSVC.from_dict(_item) for _item in obj["ssvc"]] if obj.get("ssvc") is not None else None,
            "temporalMetricV2": ApiTemporalMetricV2.from_dict(obj["temporalMetricV2"]) if obj.get("temporalMetricV2") is not None else None,
            "temporalMetricV3": ApiTemporalMetricV3.from_dict(obj["temporalMetricV3"]) if obj.get("temporalMetricV3") is not None else None,
            "temporalV3Corrected": ApiTemporalMetricV3.from_dict(obj["temporalV3Corrected"]) if obj.get("temporalV3Corrected") is not None else None,
            "threatMetricV40": AdvisoryCVSSV40Threat.from_dict(obj["threatMetricV40"]) if obj.get("threatMetricV40") is not None else None
        })
        return _obj


