# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.api_epss import ApiEPSS
from vulncheck_sdk.models.api_exploits_trending import ApiExploitsTrending
from vulncheck_sdk.models.api_exploits_v3_count import ApiExploitsV3Count
from vulncheck_sdk.models.api_exploits_v3_timeline import ApiExploitsV3Timeline
from vulncheck_sdk.models.api_normalized_exploit_v3_entry import ApiNormalizedExploitV3Entry
from vulncheck_sdk.models.api_normalized_report_v3_entry import ApiNormalizedReportV3Entry
from typing import Optional, Set
from typing_extensions import Self

class ApiExploitV3Result(BaseModel):
    """
    ApiExploitV3Result
    """ # noqa: E501
    timestamp: Optional[StrictStr] = Field(default=None, description="ignore this field when checking for differences/changes", alias="_timestamp")
    commercial_exploit_found: Optional[StrictBool] = None
    counts: Optional[ApiExploitsV3Count] = None
    date_added: Optional[StrictStr] = None
    epss: Optional[ApiEPSS] = Field(default=None, description="exclude EPSS from changelog")
    exploits: Optional[List[ApiNormalizedExploitV3Entry]] = None
    id: Optional[StrictStr] = None
    in_kev: Optional[StrictBool] = Field(default=None, alias="inKEV")
    in_vckev: Optional[StrictBool] = Field(default=None, alias="inVCKEV")
    max_exploit_maturity: Optional[StrictStr] = None
    public_exploit_found: Optional[StrictBool] = None
    reported_exploitation: Optional[List[ApiNormalizedReportV3Entry]] = None
    reported_exploited: Optional[StrictBool] = None
    reported_exploited_by_botnets: Optional[StrictBool] = None
    reported_exploited_by_ransomware: Optional[StrictBool] = None
    reported_exploited_by_threat_actors: Optional[StrictBool] = None
    timeline: Optional[ApiExploitsV3Timeline] = None
    trending: Optional[ApiExploitsTrending] = None
    weaponized_exploit_found: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["_timestamp", "commercial_exploit_found", "counts", "date_added", "epss", "exploits", "id", "inKEV", "inVCKEV", "max_exploit_maturity", "public_exploit_found", "reported_exploitation", "reported_exploited", "reported_exploited_by_botnets", "reported_exploited_by_ransomware", "reported_exploited_by_threat_actors", "timeline", "trending", "weaponized_exploit_found"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiExploitV3Result from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of counts
        if self.counts:
            _dict['counts'] = self.counts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of epss
        if self.epss:
            _dict['epss'] = self.epss.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in exploits (list)
        _items = []
        if self.exploits:
            for _item_exploits in self.exploits:
                if _item_exploits:
                    _items.append(_item_exploits.to_dict())
            _dict['exploits'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in reported_exploitation (list)
        _items = []
        if self.reported_exploitation:
            for _item_reported_exploitation in self.reported_exploitation:
                if _item_reported_exploitation:
                    _items.append(_item_reported_exploitation.to_dict())
            _dict['reported_exploitation'] = _items
        # override the default output from pydantic by calling `to_dict()` of timeline
        if self.timeline:
            _dict['timeline'] = self.timeline.to_dict()
        # override the default output from pydantic by calling `to_dict()` of trending
        if self.trending:
            _dict['trending'] = self.trending.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiExploitV3Result from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_timestamp": obj.get("_timestamp"),
            "commercial_exploit_found": obj.get("commercial_exploit_found"),
            "counts": ApiExploitsV3Count.from_dict(obj["counts"]) if obj.get("counts") is not None else None,
            "date_added": obj.get("date_added"),
            "epss": ApiEPSS.from_dict(obj["epss"]) if obj.get("epss") is not None else None,
            "exploits": [ApiNormalizedExploitV3Entry.from_dict(_item) for _item in obj["exploits"]] if obj.get("exploits") is not None else None,
            "id": obj.get("id"),
            "inKEV": obj.get("inKEV"),
            "inVCKEV": obj.get("inVCKEV"),
            "max_exploit_maturity": obj.get("max_exploit_maturity"),
            "public_exploit_found": obj.get("public_exploit_found"),
            "reported_exploitation": [ApiNormalizedReportV3Entry.from_dict(_item) for _item in obj["reported_exploitation"]] if obj.get("reported_exploitation") is not None else None,
            "reported_exploited": obj.get("reported_exploited"),
            "reported_exploited_by_botnets": obj.get("reported_exploited_by_botnets"),
            "reported_exploited_by_ransomware": obj.get("reported_exploited_by_ransomware"),
            "reported_exploited_by_threat_actors": obj.get("reported_exploited_by_threat_actors"),
            "timeline": ApiExploitsV3Timeline.from_dict(obj["timeline"]) if obj.get("timeline") is not None else None,
            "trending": ApiExploitsTrending.from_dict(obj["trending"]) if obj.get("trending") is not None else None,
            "weaponized_exploit_found": obj.get("weaponized_exploit_found")
        })
        return _obj


