# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_mitre_cve_list_v5_ref import AdvisoryMitreCVEListV5Ref
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryVulnCheckCVEListV5(BaseModel):
    """
    AdvisoryVulnCheckCVEListV5
    """ # noqa: E501
    cve: Optional[List[StrictStr]] = None
    date_added: Optional[StrictStr] = None
    mitre_ref: Optional[AdvisoryMitreCVEListV5Ref] = None
    summary: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    url: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["cve", "date_added", "mitre_ref", "summary", "title", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryVulnCheckCVEListV5 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of mitre_ref
        if self.mitre_ref:
            _dict['mitre_ref'] = self.mitre_ref.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryVulnCheckCVEListV5 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cve": obj.get("cve"),
            "date_added": obj.get("date_added"),
            "mitre_ref": AdvisoryMitreCVEListV5Ref.from_dict(obj["mitre_ref"]) if obj.get("mitre_ref") is not None else None,
            "summary": obj.get("summary"),
            "title": obj.get("title"),
            "url": obj.get("url")
        })
        return _obj


