# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_siemens_document import AdvisorySiemensDocument
from vulncheck_sdk.models.advisory_siemens_product_tree import AdvisorySiemensProductTree
from vulncheck_sdk.models.advisory_siemens_vulnerability import AdvisorySiemensVulnerability
from typing import Optional, Set
from typing_extensions import Self

class AdvisorySSASource(BaseModel):
    """
    AdvisorySSASource
    """ # noqa: E501
    document: Optional[AdvisorySiemensDocument] = None
    product_tree: Optional[AdvisorySiemensProductTree] = None
    vulnerabilities: Optional[List[AdvisorySiemensVulnerability]] = None
    __properties: ClassVar[List[str]] = ["document", "product_tree", "vulnerabilities"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisorySSASource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of document
        if self.document:
            _dict['document'] = self.document.to_dict()
        # override the default output from pydantic by calling `to_dict()` of product_tree
        if self.product_tree:
            _dict['product_tree'] = self.product_tree.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in vulnerabilities (list)
        _items = []
        if self.vulnerabilities:
            for _item_vulnerabilities in self.vulnerabilities:
                if _item_vulnerabilities:
                    _items.append(_item_vulnerabilities.to_dict())
            _dict['vulnerabilities'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisorySSASource from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "document": AdvisorySiemensDocument.from_dict(obj["document"]) if obj.get("document") is not None else None,
            "product_tree": AdvisorySiemensProductTree.from_dict(obj["product_tree"]) if obj.get("product_tree") is not None else None,
            "vulnerabilities": [AdvisorySiemensVulnerability.from_dict(_item) for _item in obj["vulnerabilities"]] if obj.get("vulnerabilities") is not None else None
        })
        return _obj


