# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_siemens_cwe import AdvisorySiemensCWE
from vulncheck_sdk.models.advisory_siemens_notes import AdvisorySiemensNotes
from vulncheck_sdk.models.advisory_siemens_product_status import AdvisorySiemensProductStatus
from vulncheck_sdk.models.advisory_siemens_references import AdvisorySiemensReferences
from vulncheck_sdk.models.advisory_siemens_remediation import AdvisorySiemensRemediation
from vulncheck_sdk.models.advisory_siemens_score import AdvisorySiemensScore
from typing import Optional, Set
from typing_extensions import Self

class AdvisorySiemensVulnerability(BaseModel):
    """
    AdvisorySiemensVulnerability
    """ # noqa: E501
    cve: Optional[StrictStr] = None
    cwe: Optional[AdvisorySiemensCWE] = None
    notes: Optional[List[AdvisorySiemensNotes]] = None
    product_status: Optional[AdvisorySiemensProductStatus] = None
    references: Optional[List[AdvisorySiemensReferences]] = None
    remediations: Optional[List[AdvisorySiemensRemediation]] = None
    scores: Optional[List[AdvisorySiemensScore]] = None
    title: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["cve", "cwe", "notes", "product_status", "references", "remediations", "scores", "title"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisorySiemensVulnerability from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cwe
        if self.cwe:
            _dict['cwe'] = self.cwe.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in notes (list)
        _items = []
        if self.notes:
            for _item_notes in self.notes:
                if _item_notes:
                    _items.append(_item_notes.to_dict())
            _dict['notes'] = _items
        # override the default output from pydantic by calling `to_dict()` of product_status
        if self.product_status:
            _dict['product_status'] = self.product_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item_references in self.references:
                if _item_references:
                    _items.append(_item_references.to_dict())
            _dict['references'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in remediations (list)
        _items = []
        if self.remediations:
            for _item_remediations in self.remediations:
                if _item_remediations:
                    _items.append(_item_remediations.to_dict())
            _dict['remediations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in scores (list)
        _items = []
        if self.scores:
            for _item_scores in self.scores:
                if _item_scores:
                    _items.append(_item_scores.to_dict())
            _dict['scores'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisorySiemensVulnerability from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cve": obj.get("cve"),
            "cwe": AdvisorySiemensCWE.from_dict(obj["cwe"]) if obj.get("cwe") is not None else None,
            "notes": [AdvisorySiemensNotes.from_dict(_item) for _item in obj["notes"]] if obj.get("notes") is not None else None,
            "product_status": AdvisorySiemensProductStatus.from_dict(obj["product_status"]) if obj.get("product_status") is not None else None,
            "references": [AdvisorySiemensReferences.from_dict(_item) for _item in obj["references"]] if obj.get("references") is not None else None,
            "remediations": [AdvisorySiemensRemediation.from_dict(_item) for _item in obj["remediations"]] if obj.get("remediations") is not None else None,
            "scores": [AdvisorySiemensScore.from_dict(_item) for _item in obj["scores"]] if obj.get("scores") is not None else None,
            "title": obj.get("title")
        })
        return _obj


