# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryRustsecFrontMatterAdvisory(BaseModel):
    """
    AdvisoryRustsecFrontMatterAdvisory
    """ # noqa: E501
    aliases: Optional[List[StrictStr]] = Field(default=None, description="Vulnerability aliases, e.g. CVE IDs (optional but recommended) Request a CVE for your RustSec vulns: https://iwantacve.org/")
    categories: Optional[List[StrictStr]] = Field(default=None, description="Optional: Categories this advisory falls under. Valid categories are: \"code-execution\", \"crypto-failure\", \"denial-of-service\", \"file-disclosure\" \"format-injection\", \"memory-corruption\", \"memory-exposure\", \"privilege-escalation\"")
    cvss: Optional[StrictStr] = Field(default=None, description="Optional: a Common Vulnerability Scoring System score. More information can be found on the CVSS website, https://www.first.org/cvss/.")
    var_date: Optional[StrictStr] = Field(default=None, description="Disclosure date of the advisory as an RFC 3339 date (mandatory)", alias="date")
    informational: Optional[StrictStr] = Field(default=None, description="Optional: Indicates the type of informational security  advisory  - \"unsound\" for soundness issues  - \"unmaintained\" for crates that are no longer maintained  - \"notice\" for other informational notices")
    keywords: Optional[List[StrictStr]] = Field(default=None, description="Freeform keywords which describe this vulnerability, similar to Cargo (optional)")
    package: Optional[StrictStr] = Field(default=None, description="Name of the affected crate (mandatory)")
    references: Optional[List[StrictStr]] = Field(default=None, description="URL to additional helpful references regarding the advisory (optional)")
    related: Optional[List[StrictStr]] = Field(default=None, description="Related vulnerabilities (optional) e.g. CVE for a C library wrapped by a -sys crate)")
    rustsec_id: Optional[StrictStr] = Field(default=None, description="Identifier for the advisory (mandatory). Will be assigned a \"RUSTSEC-YYYY-NNNN\" identifier e.g. RUSTSEC-2018-0001. Please use \"RUSTSEC-0000-0000\" in PRs.")
    url: Optional[StrictStr] = Field(default=None, description="URL to a long-form description of this issue, e.g. a GitHub issue/PR, a change log entry, or a blogpost announcing the release (optional)")
    withdrawn: Optional[StrictStr] = Field(default=None, description="Whether the advisory is withdrawn (optional)")
    __properties: ClassVar[List[str]] = ["aliases", "categories", "cvss", "date", "informational", "keywords", "package", "references", "related", "rustsec_id", "url", "withdrawn"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryRustsecFrontMatterAdvisory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryRustsecFrontMatterAdvisory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "aliases": obj.get("aliases"),
            "categories": obj.get("categories"),
            "cvss": obj.get("cvss"),
            "date": obj.get("date"),
            "informational": obj.get("informational"),
            "keywords": obj.get("keywords"),
            "package": obj.get("package"),
            "references": obj.get("references"),
            "related": obj.get("related"),
            "rustsec_id": obj.get("rustsec_id"),
            "url": obj.get("url"),
            "withdrawn": obj.get("withdrawn")
        })
        return _obj


