# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_rocky_cve import AdvisoryRockyCve
from vulncheck_sdk.models.advisory_rocky_fix import AdvisoryRockyFix
from vulncheck_sdk.models.advisory_rocky_version import AdvisoryRockyVersion
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryRockyAdvisory(BaseModel):
    """
    AdvisoryRockyAdvisory
    """ # noqa: E501
    affected_products: Optional[List[StrictStr]] = Field(default=None, alias="affectedProducts")
    build_references: Optional[List[StrictStr]] = Field(default=None, alias="buildReferences")
    cves: Optional[List[AdvisoryRockyCve]] = None
    description: Optional[StrictStr] = None
    fixes: Optional[List[AdvisoryRockyFix]] = None
    name: Optional[StrictStr] = None
    published_at: Optional[StrictStr] = Field(default=None, alias="publishedAt")
    reboot_suggested: Optional[StrictBool] = Field(default=None, alias="rebootSuggested")
    references: Optional[List[StrictStr]] = None
    rpms: Optional[Dict[str, AdvisoryRockyVersion]] = None
    severity: Optional[StrictStr] = None
    short_code: Optional[StrictStr] = Field(default=None, alias="shortCode")
    solution: Optional[StrictStr] = None
    synopsis: Optional[StrictStr] = None
    topic: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["affectedProducts", "buildReferences", "cves", "description", "fixes", "name", "publishedAt", "rebootSuggested", "references", "rpms", "severity", "shortCode", "solution", "synopsis", "topic", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryRockyAdvisory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in cves (list)
        _items = []
        if self.cves:
            for _item_cves in self.cves:
                if _item_cves:
                    _items.append(_item_cves.to_dict())
            _dict['cves'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in fixes (list)
        _items = []
        if self.fixes:
            for _item_fixes in self.fixes:
                if _item_fixes:
                    _items.append(_item_fixes.to_dict())
            _dict['fixes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in rpms (dict)
        _field_dict = {}
        if self.rpms:
            for _key_rpms in self.rpms:
                if self.rpms[_key_rpms]:
                    _field_dict[_key_rpms] = self.rpms[_key_rpms].to_dict()
            _dict['rpms'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryRockyAdvisory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "affectedProducts": obj.get("affectedProducts"),
            "buildReferences": obj.get("buildReferences"),
            "cves": [AdvisoryRockyCve.from_dict(_item) for _item in obj["cves"]] if obj.get("cves") is not None else None,
            "description": obj.get("description"),
            "fixes": [AdvisoryRockyFix.from_dict(_item) for _item in obj["fixes"]] if obj.get("fixes") is not None else None,
            "name": obj.get("name"),
            "publishedAt": obj.get("publishedAt"),
            "rebootSuggested": obj.get("rebootSuggested"),
            "references": obj.get("references"),
            "rpms": dict(
                (_k, AdvisoryRockyVersion.from_dict(_v))
                for _k, _v in obj["rpms"].items()
            )
            if obj.get("rpms") is not None
            else None,
            "severity": obj.get("severity"),
            "shortCode": obj.get("shortCode"),
            "solution": obj.get("solution"),
            "synopsis": obj.get("synopsis"),
            "topic": obj.get("topic"),
            "type": obj.get("type")
        })
        return _obj


