# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_py_pa_advisory_affected_inner import AdvisoryPyPAAdvisoryAffectedInner
from vulncheck_sdk.models.advisory_py_pa_advisory_references_inner import AdvisoryPyPAAdvisoryReferencesInner
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryPyPAAdvisory(BaseModel):
    """
    AdvisoryPyPAAdvisory
    """ # noqa: E501
    advisory_id: Optional[StrictStr] = Field(default=None, description="ID is the PYSEC- identifier")
    affected: Optional[List[AdvisoryPyPAAdvisoryAffectedInner]] = Field(default=None, description="Affected will list out the vulnerable versions.")
    aliases: Optional[List[StrictStr]] = Field(default=None, description="Aliases are other identifiers that refer to this, such as a CVE")
    date_added: Optional[StrictStr] = Field(default=None, description="DateAdded is the RFC3339Nano published timestamp")
    details: Optional[StrictStr] = Field(default=None, description="Details discuss the vulnerability information")
    modified: Optional[StrictStr] = Field(default=None, description="Modified is non-zero Time if entry was updated")
    published: Optional[StrictStr] = Field(default=None, description="Published is the datetime when this was released")
    references: Optional[List[AdvisoryPyPAAdvisoryReferencesInner]] = Field(default=None, description="References are links to more detailed advisories, fixes, etc.")
    was_withdrawn: Optional[StrictBool] = Field(default=None, description="WasWD indicates if the advisory was withdrawn or not.")
    withdrawn: Optional[StrictStr] = Field(default=None, description="Withdrawn is non-zero if this advisory has been withdrawn")
    __properties: ClassVar[List[str]] = ["advisory_id", "affected", "aliases", "date_added", "details", "modified", "published", "references", "was_withdrawn", "withdrawn"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryPyPAAdvisory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in affected (list)
        _items = []
        if self.affected:
            for _item_affected in self.affected:
                if _item_affected:
                    _items.append(_item_affected.to_dict())
            _dict['affected'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item_references in self.references:
                if _item_references:
                    _items.append(_item_references.to_dict())
            _dict['references'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryPyPAAdvisory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "advisory_id": obj.get("advisory_id"),
            "affected": [AdvisoryPyPAAdvisoryAffectedInner.from_dict(_item) for _item in obj["affected"]] if obj.get("affected") is not None else None,
            "aliases": obj.get("aliases"),
            "date_added": obj.get("date_added"),
            "details": obj.get("details"),
            "modified": obj.get("modified"),
            "published": obj.get("published"),
            "references": [AdvisoryPyPAAdvisoryReferencesInner.from_dict(_item) for _item in obj["references"]] if obj.get("references") is not None else None,
            "was_withdrawn": obj.get("was_withdrawn"),
            "withdrawn": obj.get("withdrawn")
        })
        return _obj


