# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_document_publisher import AdvisoryDocumentPublisher
from vulncheck_sdk.models.advisory_m_document_tracking import AdvisoryMDocumentTracking
from vulncheck_sdk.models.advisory_m_product_tree import AdvisoryMProductTree
from vulncheck_sdk.models.advisory_m_vulnerability import AdvisoryMVulnerability
from vulncheck_sdk.models.advisory_ms_document_title import AdvisoryMSDocumentTitle
from vulncheck_sdk.models.advisory_r_note import AdvisoryRNote
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryMSCVRF(BaseModel):
    """
    AdvisoryMSCVRF
    """ # noqa: E501
    document_title: Optional[AdvisoryMSDocumentTitle] = Field(default=None, alias="DocumentTitle")
    document_tracking: Optional[AdvisoryMDocumentTracking] = Field(default=None, alias="DocumentTracking")
    product_tree: Optional[AdvisoryMProductTree] = Field(default=None, alias="ProductTree")
    document_type: Optional[StrictStr] = None
    documentnotes: Optional[List[AdvisoryRNote]] = Field(default=None, description="diff")
    documentpublisher: Optional[AdvisoryDocumentPublisher] = None
    vulnerability: Optional[List[AdvisoryMVulnerability]] = None
    __properties: ClassVar[List[str]] = ["DocumentTitle", "DocumentTracking", "ProductTree", "document_type", "documentnotes", "documentpublisher", "vulnerability"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryMSCVRF from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of document_title
        if self.document_title:
            _dict['DocumentTitle'] = self.document_title.to_dict()
        # override the default output from pydantic by calling `to_dict()` of document_tracking
        if self.document_tracking:
            _dict['DocumentTracking'] = self.document_tracking.to_dict()
        # override the default output from pydantic by calling `to_dict()` of product_tree
        if self.product_tree:
            _dict['ProductTree'] = self.product_tree.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in documentnotes (list)
        _items = []
        if self.documentnotes:
            for _item_documentnotes in self.documentnotes:
                if _item_documentnotes:
                    _items.append(_item_documentnotes.to_dict())
            _dict['documentnotes'] = _items
        # override the default output from pydantic by calling `to_dict()` of documentpublisher
        if self.documentpublisher:
            _dict['documentpublisher'] = self.documentpublisher.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in vulnerability (list)
        _items = []
        if self.vulnerability:
            for _item_vulnerability in self.vulnerability:
                if _item_vulnerability:
                    _items.append(_item_vulnerability.to_dict())
            _dict['vulnerability'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryMSCVRF from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "DocumentTitle": AdvisoryMSDocumentTitle.from_dict(obj["DocumentTitle"]) if obj.get("DocumentTitle") is not None else None,
            "DocumentTracking": AdvisoryMDocumentTracking.from_dict(obj["DocumentTracking"]) if obj.get("DocumentTracking") is not None else None,
            "ProductTree": AdvisoryMProductTree.from_dict(obj["ProductTree"]) if obj.get("ProductTree") is not None else None,
            "document_type": obj.get("document_type"),
            "documentnotes": [AdvisoryRNote.from_dict(_item) for _item in obj["documentnotes"]] if obj.get("documentnotes") is not None else None,
            "documentpublisher": AdvisoryDocumentPublisher.from_dict(obj["documentpublisher"]) if obj.get("documentpublisher") is not None else None,
            "vulnerability": [AdvisoryMVulnerability.from_dict(_item) for _item in obj["vulnerability"]] if obj.get("vulnerability") is not None else None
        })
        return _obj


