# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_m_full_product_name import AdvisoryMFullProductName
from vulncheck_sdk.models.advisory_m_item import AdvisoryMItem
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryMBranch(BaseModel):
    """
    AdvisoryMBranch
    """ # noqa: E501
    branch: Optional[List[AdvisoryMBranch]] = Field(default=None, alias="Branch")
    full_product_name: Optional[List[AdvisoryMFullProductName]] = Field(default=None, alias="FullProductName")
    items: Optional[List[AdvisoryMItem]] = Field(default=None, alias="Items")
    name: Optional[StrictStr] = None
    type: Optional[StrictInt] = Field(default=None, description="diff")
    __properties: ClassVar[List[str]] = ["Branch", "FullProductName", "Items", "name", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryMBranch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in branch (list)
        _items = []
        if self.branch:
            for _item_branch in self.branch:
                if _item_branch:
                    _items.append(_item_branch.to_dict())
            _dict['Branch'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in full_product_name (list)
        _items = []
        if self.full_product_name:
            for _item_full_product_name in self.full_product_name:
                if _item_full_product_name:
                    _items.append(_item_full_product_name.to_dict())
            _dict['FullProductName'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['Items'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryMBranch from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Branch": [AdvisoryMBranch.from_dict(_item) for _item in obj["Branch"]] if obj.get("Branch") is not None else None,
            "FullProductName": [AdvisoryMFullProductName.from_dict(_item) for _item in obj["FullProductName"]] if obj.get("FullProductName") is not None else None,
            "Items": [AdvisoryMItem.from_dict(_item) for _item in obj["Items"]] if obj.get("Items") is not None else None,
            "name": obj.get("name"),
            "type": obj.get("type")
        })
        return _obj

# TODO: Rewrite to not use raise_errors
AdvisoryMBranch.model_rebuild(raise_errors=False)

