# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_haskell_sadb_affected import AdvisoryHaskellSADBAffected
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryHaskellSADBAdvisory(BaseModel):
    """
    AdvisoryHaskellSADBAdvisory
    """ # noqa: E501
    advisory_id: Optional[StrictStr] = None
    affected_packages: Optional[List[AdvisoryHaskellSADBAffected]] = None
    aliases: Optional[List[StrictStr]] = None
    cves: Optional[List[StrictStr]] = None
    cwes: Optional[List[StrictInt]] = None
    date_added: Optional[StrictStr] = None
    keywords: Optional[List[StrictStr]] = None
    references: Optional[Dict[str, List[StrictStr]]] = None
    related_vulns: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["advisory_id", "affected_packages", "aliases", "cves", "cwes", "date_added", "keywords", "references", "related_vulns"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryHaskellSADBAdvisory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in affected_packages (list)
        _items = []
        if self.affected_packages:
            for _item_affected_packages in self.affected_packages:
                if _item_affected_packages:
                    _items.append(_item_affected_packages.to_dict())
            _dict['affected_packages'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryHaskellSADBAdvisory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "advisory_id": obj.get("advisory_id"),
            "affected_packages": [AdvisoryHaskellSADBAffected.from_dict(_item) for _item in obj["affected_packages"]] if obj.get("affected_packages") is not None else None,
            "aliases": obj.get("aliases"),
            "cves": obj.get("cves"),
            "cwes": obj.get("cwes"),
            "date_added": obj.get("date_added"),
            "keywords": obj.get("keywords"),
            "references": obj.get("references"),
            "related_vulns": obj.get("related_vulns")
        })
        return _obj


