# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryGitlabAdvisory(BaseModel):
    """
    AdvisoryGitlabAdvisory
    """ # noqa: E501
    affected_range: Optional[StrictStr] = None
    affected_versions: Optional[StrictStr] = None
    cve: Optional[List[StrictStr]] = None
    cvss_v2: Optional[StrictStr] = None
    cvss_v3: Optional[StrictStr] = None
    cwe: Optional[List[StrictStr]] = None
    var_date: Optional[StrictStr] = Field(default=None, alias="date")
    date_added: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    filename: Optional[StrictStr] = None
    fixed_versions: Optional[List[StrictStr]] = None
    ghsa: Optional[List[StrictStr]] = None
    gitlab_url: Optional[StrictStr] = None
    identifier: Optional[StrictStr] = None
    identifiers: Optional[List[StrictStr]] = None
    not_impacted: Optional[StrictStr] = None
    package_manager: Optional[StrictStr] = None
    package_name: Optional[StrictStr] = None
    package_slug: Optional[StrictStr] = None
    pubdate: Optional[StrictStr] = None
    solution: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    urls: Optional[List[StrictStr]] = None
    uuid: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["affected_range", "affected_versions", "cve", "cvss_v2", "cvss_v3", "cwe", "date", "date_added", "description", "filename", "fixed_versions", "ghsa", "gitlab_url", "identifier", "identifiers", "not_impacted", "package_manager", "package_name", "package_slug", "pubdate", "solution", "title", "urls", "uuid"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryGitlabAdvisory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryGitlabAdvisory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "affected_range": obj.get("affected_range"),
            "affected_versions": obj.get("affected_versions"),
            "cve": obj.get("cve"),
            "cvss_v2": obj.get("cvss_v2"),
            "cvss_v3": obj.get("cvss_v3"),
            "cwe": obj.get("cwe"),
            "date": obj.get("date"),
            "date_added": obj.get("date_added"),
            "description": obj.get("description"),
            "filename": obj.get("filename"),
            "fixed_versions": obj.get("fixed_versions"),
            "ghsa": obj.get("ghsa"),
            "gitlab_url": obj.get("gitlab_url"),
            "identifier": obj.get("identifier"),
            "identifiers": obj.get("identifiers"),
            "not_impacted": obj.get("not_impacted"),
            "package_manager": obj.get("package_manager"),
            "package_name": obj.get("package_name"),
            "package_slug": obj.get("package_slug"),
            "pubdate": obj.get("pubdate"),
            "solution": obj.get("solution"),
            "title": obj.get("title"),
            "urls": obj.get("urls"),
            "uuid": obj.get("uuid")
        })
        return _obj


