# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_csaf_note import AdvisoryCSAFNote
from vulncheck_sdk.models.advisory_csaf_reference import AdvisoryCSAFReference
from vulncheck_sdk.models.advisory_publisher import AdvisoryPublisher
from vulncheck_sdk.models.advisory_tracking import AdvisoryTracking
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryDocumentMetadata(BaseModel):
    """
    AdvisoryDocumentMetadata
    """ # noqa: E501
    category: Optional[StrictStr] = None
    csaf_version: Optional[StrictStr] = None
    distribution: Optional[Dict[str, Any]] = None
    lang: Optional[StrictStr] = None
    notes: Optional[List[AdvisoryCSAFNote]] = Field(default=None, description="used by ncsc")
    publisher: Optional[AdvisoryPublisher] = None
    references: Optional[List[AdvisoryCSAFReference]] = None
    title: Optional[StrictStr] = Field(default=None, description="Aggregate severity is a vehicle that is provided by the document producer to convey the urgency and criticality with which the one or more vulnerabilities reported should be addressed.")
    tracking: Optional[AdvisoryTracking] = None
    __properties: ClassVar[List[str]] = ["category", "csaf_version", "distribution", "lang", "notes", "publisher", "references", "title", "tracking"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryDocumentMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in notes (list)
        _items = []
        if self.notes:
            for _item_notes in self.notes:
                if _item_notes:
                    _items.append(_item_notes.to_dict())
            _dict['notes'] = _items
        # override the default output from pydantic by calling `to_dict()` of publisher
        if self.publisher:
            _dict['publisher'] = self.publisher.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item_references in self.references:
                if _item_references:
                    _items.append(_item_references.to_dict())
            _dict['references'] = _items
        # override the default output from pydantic by calling `to_dict()` of tracking
        if self.tracking:
            _dict['tracking'] = self.tracking.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryDocumentMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "category": obj.get("category"),
            "csaf_version": obj.get("csaf_version"),
            "distribution": obj.get("distribution"),
            "lang": obj.get("lang"),
            "notes": [AdvisoryCSAFNote.from_dict(_item) for _item in obj["notes"]] if obj.get("notes") is not None else None,
            "publisher": AdvisoryPublisher.from_dict(obj["publisher"]) if obj.get("publisher") is not None else None,
            "references": [AdvisoryCSAFReference.from_dict(_item) for _item in obj["references"]] if obj.get("references") is not None else None,
            "title": obj.get("title"),
            "tracking": AdvisoryTracking.from_dict(obj["tracking"]) if obj.get("tracking") is not None else None
        })
        return _obj


