# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryCVSSV40(BaseModel):
    """
    AdvisoryCVSSV40
    """ # noqa: E501
    attack_complexity: Optional[StrictStr] = Field(default=None, alias="attackComplexity")
    attack_requirements: Optional[StrictStr] = Field(default=None, alias="attackRequirements")
    attack_vector: Optional[StrictStr] = Field(default=None, alias="attackVector")
    automatable: Optional[StrictStr] = Field(default=None, description="mod NVD")
    availability_requirements: Optional[StrictStr] = Field(default=None, description="mod NVD", alias="availabilityRequirements")
    base_score: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="baseScore")
    base_severity: Optional[StrictStr] = Field(default=None, alias="baseSeverity")
    confidentiality_requirements: Optional[StrictStr] = Field(default=None, description="mod NVD", alias="confidentialityRequirements")
    exploit_maturity: Optional[StrictStr] = Field(default=None, alias="exploitMaturity")
    integrity_requirements: Optional[StrictStr] = Field(default=None, description="mod NVD", alias="integrityRequirements")
    modified_attack_complexity: Optional[StrictStr] = Field(default=None, alias="modifiedAttackComplexity")
    modified_attack_requirements: Optional[StrictStr] = Field(default=None, alias="modifiedAttackRequirements")
    modified_attack_vector: Optional[StrictStr] = Field(default=None, alias="modifiedAttackVector")
    modified_privileges_required: Optional[StrictStr] = Field(default=None, alias="modifiedPrivilegesRequired")
    modified_subsequent_system_availability: Optional[StrictStr] = Field(default=None, description="mod NVD", alias="modifiedSubsequentSystemAvailability")
    modified_subsequent_system_confidentiality: Optional[StrictStr] = Field(default=None, description="mod NVD", alias="modifiedSubsequentSystemConfidentiality")
    modified_subsequent_system_integrity: Optional[StrictStr] = Field(default=None, description="mod NVD", alias="modifiedSubsequentSystemIntegrity")
    modified_user_interaction: Optional[StrictStr] = Field(default=None, alias="modifiedUserInteraction")
    modified_vulnerable_system_availability: Optional[StrictStr] = Field(default=None, description="mod NVD", alias="modifiedVulnerableSystemAvailability")
    modified_vulnerable_system_confidentiality: Optional[StrictStr] = Field(default=None, description="mod NVD", alias="modifiedVulnerableSystemConfidentiality")
    modified_vulnerable_system_integrity: Optional[StrictStr] = Field(default=None, description="mod NVD", alias="modifiedVulnerableSystemIntegrity")
    privileges_required: Optional[StrictStr] = Field(default=None, alias="privilegesRequired")
    provider_urgency: Optional[StrictStr] = Field(default=None, alias="providerUrgency")
    recovery: Optional[StrictStr] = Field(default=None, description="mod NVD")
    safety: Optional[StrictStr] = Field(default=None, description="mod NVD")
    subsequent_system_availability: Optional[StrictStr] = Field(default=None, description="mod NVD", alias="subsequentSystemAvailability")
    subsequent_system_confidentiality: Optional[StrictStr] = Field(default=None, description="mod NVD", alias="subsequentSystemConfidentiality")
    subsequent_system_integrity: Optional[StrictStr] = Field(default=None, description="mod NVD", alias="subsequentSystemIntegrity")
    user_interaction: Optional[StrictStr] = Field(default=None, alias="userInteraction")
    value_density: Optional[StrictStr] = Field(default=None, alias="valueDensity")
    vector_string: Optional[StrictStr] = Field(default=None, alias="vectorString")
    version: Optional[StrictStr] = None
    vulnerability_response_effort: Optional[StrictStr] = Field(default=None, alias="vulnerabilityResponseEffort")
    vulnerable_system_availability: Optional[StrictStr] = Field(default=None, description="mod NVD", alias="vulnerableSystemAvailability")
    vulnerable_system_confidentiality: Optional[StrictStr] = Field(default=None, description="mod NVD", alias="vulnerableSystemConfidentiality")
    vulnerable_system_integrity: Optional[StrictStr] = Field(default=None, description="mod NVD", alias="vulnerableSystemIntegrity")
    __properties: ClassVar[List[str]] = ["attackComplexity", "attackRequirements", "attackVector", "automatable", "availabilityRequirements", "baseScore", "baseSeverity", "confidentialityRequirements", "exploitMaturity", "integrityRequirements", "modifiedAttackComplexity", "modifiedAttackRequirements", "modifiedAttackVector", "modifiedPrivilegesRequired", "modifiedSubsequentSystemAvailability", "modifiedSubsequentSystemConfidentiality", "modifiedSubsequentSystemIntegrity", "modifiedUserInteraction", "modifiedVulnerableSystemAvailability", "modifiedVulnerableSystemConfidentiality", "modifiedVulnerableSystemIntegrity", "privilegesRequired", "providerUrgency", "recovery", "safety", "subsequentSystemAvailability", "subsequentSystemConfidentiality", "subsequentSystemIntegrity", "userInteraction", "valueDensity", "vectorString", "version", "vulnerabilityResponseEffort", "vulnerableSystemAvailability", "vulnerableSystemConfidentiality", "vulnerableSystemIntegrity"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryCVSSV40 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryCVSSV40 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attackComplexity": obj.get("attackComplexity"),
            "attackRequirements": obj.get("attackRequirements"),
            "attackVector": obj.get("attackVector"),
            "automatable": obj.get("automatable"),
            "availabilityRequirements": obj.get("availabilityRequirements"),
            "baseScore": obj.get("baseScore"),
            "baseSeverity": obj.get("baseSeverity"),
            "confidentialityRequirements": obj.get("confidentialityRequirements"),
            "exploitMaturity": obj.get("exploitMaturity"),
            "integrityRequirements": obj.get("integrityRequirements"),
            "modifiedAttackComplexity": obj.get("modifiedAttackComplexity"),
            "modifiedAttackRequirements": obj.get("modifiedAttackRequirements"),
            "modifiedAttackVector": obj.get("modifiedAttackVector"),
            "modifiedPrivilegesRequired": obj.get("modifiedPrivilegesRequired"),
            "modifiedSubsequentSystemAvailability": obj.get("modifiedSubsequentSystemAvailability"),
            "modifiedSubsequentSystemConfidentiality": obj.get("modifiedSubsequentSystemConfidentiality"),
            "modifiedSubsequentSystemIntegrity": obj.get("modifiedSubsequentSystemIntegrity"),
            "modifiedUserInteraction": obj.get("modifiedUserInteraction"),
            "modifiedVulnerableSystemAvailability": obj.get("modifiedVulnerableSystemAvailability"),
            "modifiedVulnerableSystemConfidentiality": obj.get("modifiedVulnerableSystemConfidentiality"),
            "modifiedVulnerableSystemIntegrity": obj.get("modifiedVulnerableSystemIntegrity"),
            "privilegesRequired": obj.get("privilegesRequired"),
            "providerUrgency": obj.get("providerUrgency"),
            "recovery": obj.get("recovery"),
            "safety": obj.get("safety"),
            "subsequentSystemAvailability": obj.get("subsequentSystemAvailability"),
            "subsequentSystemConfidentiality": obj.get("subsequentSystemConfidentiality"),
            "subsequentSystemIntegrity": obj.get("subsequentSystemIntegrity"),
            "userInteraction": obj.get("userInteraction"),
            "valueDensity": obj.get("valueDensity"),
            "vectorString": obj.get("vectorString"),
            "version": obj.get("version"),
            "vulnerabilityResponseEffort": obj.get("vulnerabilityResponseEffort"),
            "vulnerableSystemAvailability": obj.get("vulnerableSystemAvailability"),
            "vulnerableSystemConfidentiality": obj.get("vulnerableSystemConfidentiality"),
            "vulnerableSystemIntegrity": obj.get("vulnerableSystemIntegrity")
        })
        return _obj


