# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryCiscoAdvisory(BaseModel):
    """
    AdvisoryCiscoAdvisory
    """ # noqa: E501
    cisco_bug_id: Optional[StrictStr] = Field(default=None, description="multiple", alias="ciscoBugId")
    csaf: Optional[StrictStr] = None
    cve: Optional[List[StrictStr]] = Field(default=None, description="multiple")
    cvrf: Optional[StrictStr] = None
    cwe: Optional[StrictStr] = Field(default=None, description="multiple")
    date_added: Optional[StrictStr] = None
    id: Optional[StrictInt] = None
    identifier: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    related_resources: Optional[StrictStr] = None
    severity: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    summary: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    total_count: Optional[StrictInt] = Field(default=None, alias="totalCount")
    url: Optional[StrictStr] = None
    version: Optional[StrictStr] = None
    workarounds: Optional[StrictStr] = None
    workflow_status: Optional[StrictStr] = Field(default=None, alias="workflowStatus")
    __properties: ClassVar[List[str]] = ["ciscoBugId", "csaf", "cve", "cvrf", "cwe", "date_added", "id", "identifier", "name", "related_resources", "severity", "status", "summary", "title", "totalCount", "url", "version", "workarounds", "workflowStatus"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryCiscoAdvisory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryCiscoAdvisory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ciscoBugId": obj.get("ciscoBugId"),
            "csaf": obj.get("csaf"),
            "cve": obj.get("cve"),
            "cvrf": obj.get("cvrf"),
            "cwe": obj.get("cwe"),
            "date_added": obj.get("date_added"),
            "id": obj.get("id"),
            "identifier": obj.get("identifier"),
            "name": obj.get("name"),
            "related_resources": obj.get("related_resources"),
            "severity": obj.get("severity"),
            "status": obj.get("status"),
            "summary": obj.get("summary"),
            "title": obj.get("title"),
            "totalCount": obj.get("totalCount"),
            "url": obj.get("url"),
            "version": obj.get("version"),
            "workarounds": obj.get("workarounds"),
            "workflowStatus": obj.get("workflowStatus")
        })
        return _obj


