#-----------------------------------------------------------------------------
# Copyright (c) 2012 - 2020, Anaconda, Inc., and Bokeh Contributors.
# All rights reserved.
#
# The full license is in the file LICENSE.txt, distributed with this software.
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# Boilerplate
#-----------------------------------------------------------------------------
import pytest ; pytest

#-----------------------------------------------------------------------------
# Imports
#-----------------------------------------------------------------------------

# Bokeh imports
from bokeh.models.markers import Marker, Scatter, marker_types

#-----------------------------------------------------------------------------
# Setup
#-----------------------------------------------------------------------------

def test_all_markers_in_markers_dictionary() -> None:
    not_found = [marker for marker in Marker.__subclasses__()
                 if marker not in marker_types.values()]

    # except Scatter, which is not a regular plain marker
    assert len(not_found) == 1
    assert not_found[0] == Scatter

#-----------------------------------------------------------------------------
# General API
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# Dev API
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# Private API
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# Code
#-----------------------------------------------------------------------------
