# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class Parameter(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Parameter - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'parameter_type': 'str',
            'domain': 'str',
            'required': 'bool'
        }

        self.attribute_map = {
            'name': 'name',
            'parameter_type': 'parameterType',
            'domain': 'domain',
            'required': 'required'
        }

        self._name = None
        self._parameter_type = None
        self._domain = None
        self._required = None

    @property
    def name(self):
        """
        Gets the name of this Parameter.


        :return: The name of this Parameter.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Parameter.


        :param name: The name of this Parameter.
        :type: str
        """
        
        self._name = name

    @property
    def parameter_type(self):
        """
        Gets the parameter_type of this Parameter.


        :return: The parameter_type of this Parameter.
        :rtype: str
        """
        return self._parameter_type

    @parameter_type.setter
    def parameter_type(self, parameter_type):
        """
        Sets the parameter_type of this Parameter.


        :param parameter_type: The parameter_type of this Parameter.
        :type: str
        """
        allowed_values = ["UUID", "STRING", "UUIDLIST", "STRINGLIST"]
        if parameter_type.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for parameter_type -> " + parameter_type
            self._parameter_type = "outdated_sdk_version"
        else:
            self._parameter_type = parameter_type

    @property
    def domain(self):
        """
        Gets the domain of this Parameter.


        :return: The domain of this Parameter.
        :rtype: str
        """
        return self._domain

    @domain.setter
    def domain(self, domain):
        """
        Sets the domain of this Parameter.


        :param domain: The domain of this Parameter.
        :type: str
        """
        allowed_values = ["USERID", "QUEUEID", "MEDIATYPE", "DIALERCAMPAIGNID", "QMEVALFORMID", "UNKNOWN"]
        if domain.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for domain -> " + domain
            self._domain = "outdated_sdk_version"
        else:
            self._domain = domain

    @property
    def required(self):
        """
        Gets the required of this Parameter.


        :return: The required of this Parameter.
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """
        Sets the required of this Parameter.


        :param required: The required of this Parameter.
        :type: bool
        """
        
        self._required = required

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

