# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>  # noqa: E501

    The version of the OpenAPI document: 0.41.0
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from synctera_client import schemas  # noqa: F401


class OriginalCreditRequestModel(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """


    class MetaOapg:
        required = {
            "amount",
            "mid",
            "type",
            "card_id",
        }
        
        class properties:
            amount = schemas.IntSchema
            card_id = schemas.UUIDSchema
            
            
            class mid(
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    max_length = 50
                    min_length = 1
            
            
            class type(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "account_to_account": "ACCOUNT_TO_ACCOUNT",
                        "person_to_person": "PERSON_TO_PERSON",
                        "prepaid": "PREPAID",
                        "wallet_transfer": "WALLET_TRANSFER",
                        "money_transfer_by_bank": "MONEY_TRANSFER_BY_BANK",
                        "business_to_business": "BUSINESS_TO_BUSINESS",
                        "disbursement": "DISBURSEMENT",
                        "government_disbursement": "GOVERNMENT_DISBURSEMENT",
                        "gambling_payout": "GAMBLING_PAYOUT",
                        "loyalty": "LOYALTY",
                        "merchant_disbursement": "MERCHANT_DISBURSEMENT",
                        "online_gambling_payout": "ONLINE_GAMBLING_PAYOUT",
                        "pension_disbursement": "PENSION_DISBURSEMENT",
                        "prepaid_loads": "PREPAID_LOADS",
                        "card_bill_payment": "CARD_BILL_PAYMENT",
                        "bill_payment": "BILL_PAYMENT",
                        "cash_claim": "CASH_CLAIM",
                        "cash_in": "CASH_IN",
                        "cash_out": "CASH_OUT",
                        "mobile_air_time_payment": "MOBILE_AIR_TIME_PAYMENT",
                        "money_transfer_by_merchant": "MONEY_TRANSFER_BY_MERCHANT",
                        "face_to_face_merchant_payment": "FACE_TO_FACE_MERCHANT_PAYMENT",
                        "government_payment": "GOVERNMENT_PAYMENT",
                        "payments_goods_services": "PAYMENTS_GOODS_SERVICES",
                    }
                
                @schemas.classproperty
                def ACCOUNT_TO_ACCOUNT(cls):
                    return cls("account_to_account")
                
                @schemas.classproperty
                def PERSON_TO_PERSON(cls):
                    return cls("person_to_person")
                
                @schemas.classproperty
                def PREPAID(cls):
                    return cls("prepaid")
                
                @schemas.classproperty
                def WALLET_TRANSFER(cls):
                    return cls("wallet_transfer")
                
                @schemas.classproperty
                def MONEY_TRANSFER_BY_BANK(cls):
                    return cls("money_transfer_by_bank")
                
                @schemas.classproperty
                def BUSINESS_TO_BUSINESS(cls):
                    return cls("business_to_business")
                
                @schemas.classproperty
                def DISBURSEMENT(cls):
                    return cls("disbursement")
                
                @schemas.classproperty
                def GOVERNMENT_DISBURSEMENT(cls):
                    return cls("government_disbursement")
                
                @schemas.classproperty
                def GAMBLING_PAYOUT(cls):
                    return cls("gambling_payout")
                
                @schemas.classproperty
                def LOYALTY(cls):
                    return cls("loyalty")
                
                @schemas.classproperty
                def MERCHANT_DISBURSEMENT(cls):
                    return cls("merchant_disbursement")
                
                @schemas.classproperty
                def ONLINE_GAMBLING_PAYOUT(cls):
                    return cls("online_gambling_payout")
                
                @schemas.classproperty
                def PENSION_DISBURSEMENT(cls):
                    return cls("pension_disbursement")
                
                @schemas.classproperty
                def PREPAID_LOADS(cls):
                    return cls("prepaid_loads")
                
                @schemas.classproperty
                def CARD_BILL_PAYMENT(cls):
                    return cls("card_bill_payment")
                
                @schemas.classproperty
                def BILL_PAYMENT(cls):
                    return cls("bill_payment")
                
                @schemas.classproperty
                def CASH_CLAIM(cls):
                    return cls("cash_claim")
                
                @schemas.classproperty
                def CASH_IN(cls):
                    return cls("cash_in")
                
                @schemas.classproperty
                def CASH_OUT(cls):
                    return cls("cash_out")
                
                @schemas.classproperty
                def MOBILE_AIR_TIME_PAYMENT(cls):
                    return cls("mobile_air_time_payment")
                
                @schemas.classproperty
                def MONEY_TRANSFER_BY_MERCHANT(cls):
                    return cls("money_transfer_by_merchant")
                
                @schemas.classproperty
                def FACE_TO_FACE_MERCHANT_PAYMENT(cls):
                    return cls("face_to_face_merchant_payment")
                
                @schemas.classproperty
                def GOVERNMENT_PAYMENT(cls):
                    return cls("government_payment")
                
                @schemas.classproperty
                def PAYMENTS_GOODS_SERVICES(cls):
                    return cls("payments_goods_services")
        
            @staticmethod
            def card_acceptor() -> typing.Type['CardAcceptorModel']:
                return CardAcceptorModel
            screening_score = schemas.StrSchema
        
            @staticmethod
            def sender_data() -> typing.Type['OriginalCreditSenderData']:
                return OriginalCreditSenderData
            transactionPurpose = schemas.StrSchema
            __annotations__ = {
                "amount": amount,
                "card_id": card_id,
                "mid": mid,
                "type": type,
                "card_acceptor": card_acceptor,
                "screening_score": screening_score,
                "sender_data": sender_data,
                "transactionPurpose": transactionPurpose,
            }
    
    amount: MetaOapg.properties.amount
    mid: MetaOapg.properties.mid
    type: MetaOapg.properties.type
    card_id: MetaOapg.properties.card_id
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["amount"]) -> MetaOapg.properties.amount: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["card_id"]) -> MetaOapg.properties.card_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["mid"]) -> MetaOapg.properties.mid: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["type"]) -> MetaOapg.properties.type: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["card_acceptor"]) -> 'CardAcceptorModel': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["screening_score"]) -> MetaOapg.properties.screening_score: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["sender_data"]) -> 'OriginalCreditSenderData': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["transactionPurpose"]) -> MetaOapg.properties.transactionPurpose: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["amount", "card_id", "mid", "type", "card_acceptor", "screening_score", "sender_data", "transactionPurpose", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["amount"]) -> MetaOapg.properties.amount: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["card_id"]) -> MetaOapg.properties.card_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["mid"]) -> MetaOapg.properties.mid: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["type"]) -> MetaOapg.properties.type: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["card_acceptor"]) -> typing.Union['CardAcceptorModel', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["screening_score"]) -> typing.Union[MetaOapg.properties.screening_score, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["sender_data"]) -> typing.Union['OriginalCreditSenderData', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["transactionPurpose"]) -> typing.Union[MetaOapg.properties.transactionPurpose, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["amount", "card_id", "mid", "type", "card_acceptor", "screening_score", "sender_data", "transactionPurpose", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        amount: typing.Union[MetaOapg.properties.amount, decimal.Decimal, int, ],
        mid: typing.Union[MetaOapg.properties.mid, str, ],
        type: typing.Union[MetaOapg.properties.type, str, ],
        card_id: typing.Union[MetaOapg.properties.card_id, str, uuid.UUID, ],
        card_acceptor: typing.Union['CardAcceptorModel', schemas.Unset] = schemas.unset,
        screening_score: typing.Union[MetaOapg.properties.screening_score, str, schemas.Unset] = schemas.unset,
        sender_data: typing.Union['OriginalCreditSenderData', schemas.Unset] = schemas.unset,
        transactionPurpose: typing.Union[MetaOapg.properties.transactionPurpose, str, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'OriginalCreditRequestModel':
        return super().__new__(
            cls,
            *_args,
            amount=amount,
            mid=mid,
            type=type,
            card_id=card_id,
            card_acceptor=card_acceptor,
            screening_score=screening_score,
            sender_data=sender_data,
            transactionPurpose=transactionPurpose,
            _configuration=_configuration,
            **kwargs,
        )

from synctera_client.model.card_acceptor_model import CardAcceptorModel
from synctera_client.model.original_credit_sender_data import OriginalCreditSenderData
