from pykotor.common.geometry import Vector3
from pykotor.common.script import ScriptConstant, ScriptParam, ScriptFunction, DataType

KOTOR_CONSTANTS = [
    ScriptConstant(DataType.INT, "NUM_INVENTORY_SLOTS", 18),
    ScriptConstant(DataType.INT, "TRUE", 1),
    ScriptConstant(DataType.INT, "FALSE", 0),
    ScriptConstant(DataType.FLOAT, "DIRECTION_EAST", 0.0),
    ScriptConstant(DataType.FLOAT, "DIRECTION_NORTH", 90.0),
    ScriptConstant(DataType.FLOAT, "DIRECTION_WEST", 180.0),
    ScriptConstant(DataType.FLOAT, "DIRECTION_SOUTH", 270.0),
    ScriptConstant(DataType.FLOAT, "PI", 3.141592),
    ScriptConstant(DataType.INT, "ATTITUDE_NEUTRAL", 0),
    ScriptConstant(DataType.INT, "ATTITUDE_AGGRESSIVE", 1),
    ScriptConstant(DataType.INT, "ATTITUDE_DEFENSIVE", 2),
    ScriptConstant(DataType.INT, "ATTITUDE_SPECIAL", 3),
    ScriptConstant(DataType.INT, "TALKVOLUME_TALK", 0),
    ScriptConstant(DataType.INT, "TALKVOLUME_WHISPER", 1),
    ScriptConstant(DataType.INT, "TALKVOLUME_SHOUT", 2),
    ScriptConstant(DataType.INT, "TALKVOLUME_SILENT_TALK", 3),
    ScriptConstant(DataType.INT, "TALKVOLUME_SILENT_SHOUT", 4),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_HEAD", 0),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_BODY", 1),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_HANDS", 3),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_RIGHTWEAPON", 4),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_LEFTWEAPON", 5),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_LEFTARM", 7),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_RIGHTARM", 8),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_IMPLANT", 9),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_BELT", 10),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_CWEAPON_L", 14),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_CWEAPON_R", 15),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_CWEAPON_B", 16),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_CARMOUR", 17),
    ScriptConstant(DataType.INT, "DURATION_TYPE_INSTANT", 0),
    ScriptConstant(DataType.INT, "DURATION_TYPE_TEMPORARY", 1),
    ScriptConstant(DataType.INT, "DURATION_TYPE_PERMANENT", 2),
    ScriptConstant(DataType.INT, "SUBTYPE_MAGICAL", 8),
    ScriptConstant(DataType.INT, "SUBTYPE_SUPERNATURAL", 16),
    ScriptConstant(DataType.INT, "SUBTYPE_EXTRAORDINARY", 24),
    ScriptConstant(DataType.INT, "ABILITY_STRENGTH", 0),
    ScriptConstant(DataType.INT, "ABILITY_DEXTERITY", 1),
    ScriptConstant(DataType.INT, "ABILITY_CONSTITUTION", 2),
    ScriptConstant(DataType.INT, "ABILITY_INTELLIGENCE", 3),
    ScriptConstant(DataType.INT, "ABILITY_WISDOM", 4),
    ScriptConstant(DataType.INT, "ABILITY_CHARISMA", 5),
    ScriptConstant(DataType.INT, "SHAPE_SPELLCYLINDER", 0),
    ScriptConstant(DataType.INT, "SHAPE_CONE", 1),
    ScriptConstant(DataType.INT, "SHAPE_CUBE", 2),
    ScriptConstant(DataType.INT, "SHAPE_SPELLCONE", 3),
    ScriptConstant(DataType.INT, "SHAPE_SPHERE", 4),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_CREATURE", 1),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_ITEM", 2),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_TRIGGER", 4),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_DOOR", 8),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_AREA_OF_EFFECT", 16),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_WAYPOINT", 32),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_PLACEABLE", 64),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_STORE", 128),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_ENCOUNTER", 256),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_SOUND", 512),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_ALL", 32767),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_INVALID", 32767),
    ScriptConstant(DataType.INT, "GENDER_MALE", 0),
    ScriptConstant(DataType.INT, "GENDER_FEMALE", 1),
    ScriptConstant(DataType.INT, "GENDER_BOTH", 2),
    ScriptConstant(DataType.INT, "GENDER_OTHER", 3),
    ScriptConstant(DataType.INT, "GENDER_NONE", 4),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_BLUDGEONING", 1),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_PIERCING", 2),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_SLASHING", 4),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_UNIVERSAL", 8),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_ACID", 16),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_COLD", 32),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_LIGHT_SIDE", 64),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_ELECTRICAL", 128),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_FIRE", 256),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_DARK_SIDE", 512),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_SONIC", 1024),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_ION", 2048),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_BLASTER", 4096),
    ScriptConstant(DataType.INT, "AC_VS_DAMAGE_TYPE_ALL", 8199),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_1", 1),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_2", 2),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_3", 3),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_4", 4),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_5", 5),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_1d4", 6),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_1d6", 7),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_1d8", 8),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_1d10", 9),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_2d6", 10),
    ScriptConstant(DataType.INT, "DAMAGE_POWER_NORMAL", 0),
    ScriptConstant(DataType.INT, "DAMAGE_POWER_PLUS_ONE", 1),
    ScriptConstant(DataType.INT, "DAMAGE_POWER_PLUS_TWO", 2),
    ScriptConstant(DataType.INT, "DAMAGE_POWER_PLUS_THREE", 3),
    ScriptConstant(DataType.INT, "DAMAGE_POWER_PLUS_FOUR", 4),
    ScriptConstant(DataType.INT, "DAMAGE_POWER_PLUS_FIVE", 5),
    ScriptConstant(DataType.INT, "DAMAGE_POWER_ENERGY", 6),
    ScriptConstant(DataType.INT, "ATTACK_BONUS_MISC", 0),
    ScriptConstant(DataType.INT, "ATTACK_BONUS_ONHAND", 1),
    ScriptConstant(DataType.INT, "ATTACK_BONUS_OFFHAND", 2),
    ScriptConstant(DataType.INT, "AC_DODGE_BONUS", 0),
    ScriptConstant(DataType.INT, "AC_NATURAL_BONUS", 1),
    ScriptConstant(DataType.INT, "AC_ARMOUR_ENCHANTMENT_BONUS", 2),
    ScriptConstant(DataType.INT, "AC_SHIELD_ENCHANTMENT_BONUS", 3),
    ScriptConstant(DataType.INT, "AC_DEFLECTION_BONUS", 4),
    ScriptConstant(DataType.INT, "DOOR_ACTION_OPEN", 0),
    ScriptConstant(DataType.INT, "DOOR_ACTION_UNLOCK", 1),
    ScriptConstant(DataType.INT, "DOOR_ACTION_BASH", 2),
    ScriptConstant(DataType.INT, "DOOR_ACTION_IGNORE", 3),
    ScriptConstant(DataType.INT, "DOOR_ACTION_KNOCK", 4),
    ScriptConstant(DataType.INT, "PLACEABLE_ACTION_USE", 0),
    ScriptConstant(DataType.INT, "PLACEABLE_ACTION_UNLOCK", 1),
    ScriptConstant(DataType.INT, "PLACEABLE_ACTION_BASH", 2),
    ScriptConstant(DataType.INT, "PLACEABLE_ACTION_KNOCK", 4),
    ScriptConstant(DataType.INT, "RACIAL_TYPE_UNKNOWN", 0),
    ScriptConstant(DataType.INT, "RACIAL_TYPE_ELF", 1),
    ScriptConstant(DataType.INT, "RACIAL_TYPE_GNOME", 2),
    ScriptConstant(DataType.INT, "RACIAL_TYPE_HALFLING", 3),
    ScriptConstant(DataType.INT, "RACIAL_TYPE_HALFELF", 4),
    ScriptConstant(DataType.INT, "RACIAL_TYPE_DROID", 5),
    ScriptConstant(DataType.INT, "RACIAL_TYPE_HUMAN", 6),
    ScriptConstant(DataType.INT, "RACIAL_TYPE_ALL", 7),
    ScriptConstant(DataType.INT, "RACIAL_TYPE_INVALID", 8),
    ScriptConstant(DataType.INT, "ALIGNMENT_ALL", 0),
    ScriptConstant(DataType.INT, "ALIGNMENT_NEUTRAL", 1),
    ScriptConstant(DataType.INT, "ALIGNMENT_LIGHT_SIDE", 2),
    ScriptConstant(DataType.INT, "ALIGNMENT_DARK_SIDE", 3),
    ScriptConstant(DataType.INT, "SAVING_THROW_ALL", 0),
    ScriptConstant(DataType.INT, "SAVING_THROW_FORT", 1),
    ScriptConstant(DataType.INT, "SAVING_THROW_REFLEX", 2),
    ScriptConstant(DataType.INT, "SAVING_THROW_WILL", 3),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_ALL", 0),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_NONE", 0),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_ACID", 1),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_SNEAK_ATTACK", 2),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_COLD", 3),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_DEATH", 4),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_DISEASE", 5),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_LIGHT_SIDE", 6),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_ELECTRICAL", 7),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_FEAR", 8),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_FIRE", 9),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_MIND_AFFECTING", 10),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_DARK_SIDE", 11),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_POISON", 12),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_SONIC", 13),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_TRAP", 14),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_FORCE_POWER", 15),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_ION", 16),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_BLASTER", 17),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_PARALYSIS", 18),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_NONE", 0),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_MIND_SPELLS", 1),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_POISON", 2),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_DISEASE", 3),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_FEAR", 4),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_TRAP", 5),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_PARALYSIS", 6),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_BLINDNESS", 7),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_DEAFNESS", 8),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_SLOW", 9),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_ENTANGLE", 10),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_SILENCE", 11),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_STUN", 12),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_SLEEP", 13),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_CHARM", 14),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_DOMINATE", 15),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_CONFUSED", 16),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_CURSED", 17),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_DAZED", 18),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_ABILITY_DECREASE", 19),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_ATTACK_DECREASE", 20),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_DAMAGE_DECREASE", 21),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_DAMAGE_IMMUNITY_DECREASE", 22),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_AC_DECREASE", 23),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_MOVEMENT_SPEED_DECREASE", 24),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_SAVING_THROW_DECREASE", 25),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_FORCE_RESISTANCE_DECREASE", 26),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_SKILL_DECREASE", 27),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_KNOCKDOWN", 28),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_NEGATIVE_LEVEL", 29),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_SNEAK_ATTACK", 30),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_CRITICAL_HIT", 31),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_DEATH", 32),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_RANDOM", 0),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_USER_DEFINED", 1),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CITY_01", 2),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CITY_02", 3),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CITY_03", 4),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CITY_04", 5),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CITY_05", 6),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CRYPT_01", 7),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CRYPT_02", 8),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CRYPT_03", 9),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CRYPT_04", 10),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CRYPT_05", 11),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_DUNGEON_01", 12),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_DUNGEON_02", 13),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_DUNGEON_03", 14),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_DUNGEON_04", 15),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_DUNGEON_05", 16),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_DUNGEON_06", 17),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_DUNGEON_07", 18),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_DUNGEON_08", 19),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_MINES_01", 20),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_MINES_02", 21),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_MINES_03", 22),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_MINES_04", 23),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_MINES_05", 24),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_MINES_06", 25),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_MINES_07", 26),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_MINES_08", 27),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_MINES_09", 28),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_SEWER_01", 29),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_SEWER_02", 30),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_SEWER_03", 31),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_SEWER_04", 32),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_SEWER_05", 33),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CASTLE_01", 34),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CASTLE_02", 35),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CASTLE_03", 36),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CASTLE_04", 37),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CASTLE_05", 38),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CASTLE_06", 39),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CASTLE_07", 40),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CASTLE_08", 41),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_01", 42),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_02", 43),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_03", 44),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_04", 45),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_05", 46),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_06", 47),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_07", 48),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_08", 49),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_09", 50),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_10", 51),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_11", 52),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_12", 53),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_13", 54),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_14", 55),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_15", 56),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_16", 57),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_FOREST_01", 58),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_FOREST_02", 59),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_FOREST_03", 60),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_FOREST_04", 61),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_FOREST_05", 62),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_RURAL_01", 63),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_RURAL_02", 64),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_RURAL_03", 65),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_RURAL_04", 66),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_RURAL_05", 67),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CITY", 2),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CRYPT", 7),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_FOREST", 58),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_RURAL", 63),
    ScriptConstant(DataType.INT, "BODY_NODE_HAND", 0),
    ScriptConstant(DataType.INT, "BODY_NODE_CHEST", 1),
    ScriptConstant(DataType.INT, "BODY_NODE_HEAD", 2),
    ScriptConstant(DataType.INT, "BODY_NODE_HAND_LEFT", 3),
    ScriptConstant(DataType.INT, "BODY_NODE_HAND_RIGHT", 4),
    ScriptConstant(DataType.FLOAT, "RADIUS_SIZE_SMALL", 1.67),
    ScriptConstant(DataType.FLOAT, "RADIUS_SIZE_MEDIUM", 3.33),
    ScriptConstant(DataType.FLOAT, "RADIUS_SIZE_LARGE", 5.0),
    ScriptConstant(DataType.FLOAT, "RADIUS_SIZE_HUGE", 6.67),
    ScriptConstant(DataType.FLOAT, "RADIUS_SIZE_GARGANTUAN", 8.33),
    ScriptConstant(DataType.FLOAT, "RADIUS_SIZE_COLOSSAL", 10.0),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_INVALIDEFFECT", 0),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DAMAGE_RESISTANCE", 1),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_REGENERATE", 3),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DAMAGE_REDUCTION", 7),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_TEMPORARY_HITPOINTS", 9),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ENTANGLE", 11),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_INVULNERABLE", 12),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DEAF", 13),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_RESURRECTION", 14),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_IMMUNITY", 15),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ENEMY_ATTACK_BONUS", 17),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ARCANE_SPELL_FAILURE", 18),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_AREA_OF_EFFECT", 20),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_BEAM", 21),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_CHARMED", 23),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_CONFUSED", 24),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_FRIGHTENED", 25),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DOMINATED", 26),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_PARALYZE", 27),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DAZED", 28),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_STUNNED", 29),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SLEEP", 30),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_POISON", 31),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DISEASE", 32),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_CURSE", 33),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SILENCE", 34),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_TURNED", 35),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_HASTE", 36),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SLOW", 37),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ABILITY_INCREASE", 38),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ABILITY_DECREASE", 39),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ATTACK_INCREASE", 40),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ATTACK_DECREASE", 41),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DAMAGE_INCREASE", 42),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DAMAGE_DECREASE", 43),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DAMAGE_IMMUNITY_INCREASE", 44),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DAMAGE_IMMUNITY_DECREASE", 45),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_AC_INCREASE", 46),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_AC_DECREASE", 47),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_MOVEMENT_SPEED_INCREASE", 48),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_MOVEMENT_SPEED_DECREASE", 49),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SAVING_THROW_INCREASE", 50),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SAVING_THROW_DECREASE", 51),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_FORCE_RESISTANCE_INCREASE", 52),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_FORCE_RESISTANCE_DECREASE", 53),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SKILL_INCREASE", 54),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SKILL_DECREASE", 55),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_INVISIBILITY", 56),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_IMPROVEDINVISIBILITY", 57),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DARKNESS", 58),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DISPELMAGICALL", 59),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ELEMENTALSHIELD", 60),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_NEGATIVELEVEL", 61),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DISGUISE", 62),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SANCTUARY", 63),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_TRUESEEING", 64),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SEEINVISIBLE", 65),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_TIMESTOP", 66),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_BLINDNESS", 67),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SPELLLEVELABSORPTION", 68),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DISPELMAGICBEST", 69),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ULTRAVISION", 70),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_MISS_CHANCE", 71),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_CONCEALMENT", 72),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SPELL_IMMUNITY", 73),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ASSUREDHIT", 74),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_VISUAL", 75),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_LIGHTSABERTHROW", 76),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_FORCEJUMP", 77),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ASSUREDDEFLECTION", 78),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ABILITY_BONUS", 0),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_AC_BONUS", 1),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_AC_BONUS_VS_ALIGNMENT_GROUP", 2),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_AC_BONUS_VS_DAMAGE_TYPE", 3),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_AC_BONUS_VS_RACIAL_GROUP", 4),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ENHANCEMENT_BONUS", 5),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ENHANCEMENT_BONUS_VS_ALIGNMENT_GROUP", 6),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ENHANCEMENT_BONUS_VS_RACIAL_GROUP", 7),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ATTACK_PENALTY", 8),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_BONUS_FEAT", 9),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ACTIVATE_ITEM", 10),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DAMAGE_BONUS", 11),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DAMAGE_BONUS_VS_ALIGNMENT_GROUP", 12),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DAMAGE_BONUS_VS_RACIAL_GROUP", 13),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_IMMUNITY_DAMAGE_TYPE", 14),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DECREASED_DAMAGE", 15),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DAMAGE_REDUCTION", 16),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DAMAGE_RESISTANCE", 17),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DAMAGE_VULNERABILITY", 18),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DECREASED_ABILITY_SCORE", 19),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DECREASED_AC", 20),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DECREASED_SKILL_MODIFIER", 21),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_EXTRA_MELEE_DAMAGE_TYPE", 22),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_EXTRA_RANGED_DAMAGE_TYPE", 23),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_IMMUNITY", 24),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_IMPROVED_FORCE_RESISTANCE", 25),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_IMPROVED_SAVING_THROW", 26),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_IMPROVED_SAVING_THROW_SPECIFIC", 27),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_KEEN", 28),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_LIGHT", 29),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_MIGHTY", 30),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_NO_DAMAGE", 31),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ON_HIT_PROPERTIES", 32),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DECREASED_SAVING_THROWS", 33),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DECREASED_SAVING_THROWS_SPECIFIC", 34),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_REGENERATION", 35),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_SKILL_BONUS", 36),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_SECURITY_SPIKE", 37),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ATTACK_BONUS", 38),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ATTACK_BONUS_VS_ALIGNMENT_GROUP", 39),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ATTACK_BONUS_VS_RACIAL_GROUP", 40),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DECREASED_ATTACK_MODIFIER", 41),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_UNLIMITED_AMMUNITION", 42),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_USE_LIMITATION_ALIGNMENT_GROUP", 43),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_USE_LIMITATION_CLASS", 44),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_USE_LIMITATION_RACIAL_TYPE", 45),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_TRAP", 46),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_TRUE_SEEING", 47),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ON_MONSTER_HIT", 48),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_MASSIVE_CRITICALS", 49),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_FREEDOM_OF_MOVEMENT", 50),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_MONSTER_DAMAGE", 51),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_SPECIAL_WALK", 52),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_COMPUTER_SPIKE", 53),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_REGENERATION_FORCE_POINTS", 54),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_BLASTER_BOLT_DEFLECT_INCREASE", 55),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_BLASTER_BOLT_DEFLECT_DECREASE", 56),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_USE_LIMITATION_FEAT", 57),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DROID_REPAIR_KIT", 58),
    ScriptConstant(DataType.INT, "BASE_ITEM_QUARTER_STAFF", 0),
    ScriptConstant(DataType.INT, "BASE_ITEM_STUN_BATON", 1),
    ScriptConstant(DataType.INT, "BASE_ITEM_LONG_SWORD", 2),
    ScriptConstant(DataType.INT, "BASE_ITEM_VIBRO_SWORD", 3),
    ScriptConstant(DataType.INT, "BASE_ITEM_SHORT_SWORD", 4),
    ScriptConstant(DataType.INT, "BASE_ITEM_VIBRO_BLADE", 5),
    ScriptConstant(DataType.INT, "BASE_ITEM_DOUBLE_BLADED_SWORD", 6),
    ScriptConstant(DataType.INT, "BASE_ITEM_VIBRO_DOUBLE_BLADE", 7),
    ScriptConstant(DataType.INT, "BASE_ITEM_LIGHTSABER", 8),
    ScriptConstant(DataType.INT, "BASE_ITEM_DOUBLE_BLADED_LIGHTSABER", 9),
    ScriptConstant(DataType.INT, "BASE_ITEM_SHORT_LIGHTSABER", 10),
    ScriptConstant(DataType.INT, "BASE_ITEM_LIGHTSABER_CRYSTALS", 11),
    ScriptConstant(DataType.INT, "BASE_ITEM_BLASTER_PISTOL", 12),
    ScriptConstant(DataType.INT, "BASE_ITEM_HEAVY_BLASTER", 13),
    ScriptConstant(DataType.INT, "BASE_ITEM_HOLD_OUT_BLASTER", 14),
    ScriptConstant(DataType.INT, "BASE_ITEM_ION_BLASTER", 15),
    ScriptConstant(DataType.INT, "BASE_ITEM_DISRUPTER_PISTOL", 16),
    ScriptConstant(DataType.INT, "BASE_ITEM_SONIC_PISTOL", 17),
    ScriptConstant(DataType.INT, "BASE_ITEM_ION_RIFLE", 18),
    ScriptConstant(DataType.INT, "BASE_ITEM_BOWCASTER", 19),
    ScriptConstant(DataType.INT, "BASE_ITEM_BLASTER_CARBINE", 20),
    ScriptConstant(DataType.INT, "BASE_ITEM_DISRUPTER_RIFLE", 21),
    ScriptConstant(DataType.INT, "BASE_ITEM_SONIC_RIFLE", 22),
    ScriptConstant(DataType.INT, "BASE_ITEM_REPEATING_BLASTER", 23),
    ScriptConstant(DataType.INT, "BASE_ITEM_HEAVY_REPEATING_BLASTER", 24),
    ScriptConstant(DataType.INT, "BASE_ITEM_FRAGMENTATION_GRENADES", 25),
    ScriptConstant(DataType.INT, "BASE_ITEM_STUN_GRENADES", 26),
    ScriptConstant(DataType.INT, "BASE_ITEM_THERMAL_DETONATOR", 27),
    ScriptConstant(DataType.INT, "BASE_ITEM_POISON_GRENADE", 28),
    ScriptConstant(DataType.INT, "BASE_ITEM_FLASH_GRENADE", 29),
    ScriptConstant(DataType.INT, "BASE_ITEM_SONIC_GRENADE", 30),
    ScriptConstant(DataType.INT, "BASE_ITEM_ADHESIVE_GRENADE", 31),
    ScriptConstant(DataType.INT, "BASE_ITEM_CRYOBAN_GRENADE", 32),
    ScriptConstant(DataType.INT, "BASE_ITEM_FIRE_GRENADE", 33),
    ScriptConstant(DataType.INT, "BASE_ITEM_ION_GRENADE", 34),
    ScriptConstant(DataType.INT, "BASE_ITEM_JEDI_ROBE", 35),
    ScriptConstant(DataType.INT, "BASE_ITEM_JEDI_KNIGHT_ROBE", 36),
    ScriptConstant(DataType.INT, "BASE_ITEM_JEDI_MASTER_ROBE", 37),
    ScriptConstant(DataType.INT, "BASE_ITEM_ARMOR_CLASS_4", 38),
    ScriptConstant(DataType.INT, "BASE_ITEM_ARMOR_CLASS_5", 39),
    ScriptConstant(DataType.INT, "BASE_ITEM_ARMOR_CLASS_6", 40),
    ScriptConstant(DataType.INT, "BASE_ITEM_ARMOR_CLASS_7", 41),
    ScriptConstant(DataType.INT, "BASE_ITEM_ARMOR_CLASS_8", 42),
    ScriptConstant(DataType.INT, "BASE_ITEM_ARMOR_CLASS_9", 43),
    ScriptConstant(DataType.INT, "BASE_ITEM_MASK", 44),
    ScriptConstant(DataType.INT, "BASE_ITEM_GAUNTLETS", 45),
    ScriptConstant(DataType.INT, "BASE_ITEM_FOREARM_BANDS", 46),
    ScriptConstant(DataType.INT, "BASE_ITEM_BELT", 47),
    ScriptConstant(DataType.INT, "BASE_ITEM_IMPLANT_1", 48),
    ScriptConstant(DataType.INT, "BASE_ITEM_IMPLANT_2", 49),
    ScriptConstant(DataType.INT, "BASE_ITEM_IMPLANT_3", 50),
    ScriptConstant(DataType.INT, "BASE_ITEM_DATA_PAD", 52),
    ScriptConstant(DataType.INT, "BASE_ITEM_ADRENALINE", 53),
    ScriptConstant(DataType.INT, "BASE_ITEM_COMBAT_SHOTS", 54),
    ScriptConstant(DataType.INT, "BASE_ITEM_MEDICAL_EQUIPMENT", 55),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_REPAIR_EQUIPMENT", 56),
    ScriptConstant(DataType.INT, "BASE_ITEM_CREDITS", 57),
    ScriptConstant(DataType.INT, "BASE_ITEM_TRAP_KIT", 58),
    ScriptConstant(DataType.INT, "BASE_ITEM_SECURITY_SPIKES", 59),
    ScriptConstant(DataType.INT, "BASE_ITEM_PROGRAMMING_SPIKES", 60),
    ScriptConstant(DataType.INT, "BASE_ITEM_GLOW_ROD", 61),
    ScriptConstant(DataType.INT, "BASE_ITEM_COLLAR_LIGHT", 62),
    ScriptConstant(DataType.INT, "BASE_ITEM_TORCH", 63),
    ScriptConstant(DataType.INT, "BASE_ITEM_PLOT_USEABLE_ITEMS", 64),
    ScriptConstant(DataType.INT, "BASE_ITEM_AESTHETIC_ITEM", 65),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_LIGHT_PLATING", 66),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_MEDIUM_PLATING", 67),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_HEAVY_PLATING", 68),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_SEARCH_SCOPE", 69),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_MOTION_SENSORS", 70),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_SONIC_SENSORS", 71),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_TARGETING_COMPUTERS", 72),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_COMPUTER_SPIKE_MOUNT", 73),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_SECURITY_SPIKE_MOUNT", 74),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_SHIELD", 75),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_UTILITY_DEVICE", 76),
    ScriptConstant(DataType.INT, "BASE_ITEM_BLASTER_RIFLE", 77),
    ScriptConstant(DataType.INT, "BASE_ITEM_GHAFFI_STICK", 78),
    ScriptConstant(DataType.INT, "BASE_ITEM_WOOKIE_WARBLADE", 79),
    ScriptConstant(DataType.INT, "BASE_ITEM_GAMMOREAN_BATTLEAXE", 80),
    ScriptConstant(DataType.INT, "BASE_ITEM_CREATURE_ITEM_SLASH", 81),
    ScriptConstant(DataType.INT, "BASE_ITEM_CREATURE_ITEM_PIERCE", 82),
    ScriptConstant(DataType.INT, "BASE_ITEM_CREATURE_WEAPON_SL_PRC", 83),
    ScriptConstant(DataType.INT, "BASE_ITEM_CREATURE_HIDE_ITEM", 84),
    ScriptConstant(DataType.INT, "BASE_ITEM_BASIC_CLOTHING", 85),
    ScriptConstant(DataType.INT, "BASE_ITEM_INVALID", 256),
    ScriptConstant(DataType.INT, "ATTACK_RESULT_INVALID", 0),
    ScriptConstant(DataType.INT, "ATTACK_RESULT_HIT_SUCCESSFUL", 1),
    ScriptConstant(DataType.INT, "ATTACK_RESULT_CRITICAL_HIT", 2),
    ScriptConstant(DataType.INT, "ATTACK_RESULT_AUTOMATIC_HIT", 3),
    ScriptConstant(DataType.INT, "ATTACK_RESULT_MISS", 4),
    ScriptConstant(DataType.INT, "ATTACK_RESULT_ATTACK_RESISTED", 5),
    ScriptConstant(DataType.INT, "ATTACK_RESULT_ATTACK_FAILED", 6),
    ScriptConstant(DataType.INT, "ATTACK_RESULT_PARRIED", 8),
    ScriptConstant(DataType.INT, "ATTACK_RESULT_DEFLECTED", 9),
    ScriptConstant(DataType.INT, "VFX_NONE", -1),
    ScriptConstant(DataType.INT, "VFX_IMP_HEALING_SMALL", 1001),
    ScriptConstant(DataType.INT, "VFX_IMP_FORCE_JUMP_ADVANCED", 1002),
    ScriptConstant(DataType.INT, "VFX_PRO_AFFLICT", 1003),
    ScriptConstant(DataType.INT, "VFX_IMP_CHOKE", 1004),
    ScriptConstant(DataType.INT, "VFX_IMP_CURE", 1005),
    ScriptConstant(DataType.INT, "VFX_PRO_DEATH_FIELD", 1006),
    ScriptConstant(DataType.INT, "VFX_PRO_DROID_DISABLE", 1007),
    ScriptConstant(DataType.INT, "VFX_PRO_DROID_KILL", 1008),
    ScriptConstant(DataType.INT, "VFX_PRO_DRAIN", 1009),
    ScriptConstant(DataType.INT, "VFX_PRO_FORCE_ARMOR", 1010),
    ScriptConstant(DataType.INT, "VFX_PRO_FORCE_AURA", 1011),
    ScriptConstant(DataType.INT, "VFX_IMP_FORCE_BREACH", 1012),
    ScriptConstant(DataType.INT, "VFX_IMP_FORCE_PUSH", 1014),
    ScriptConstant(DataType.INT, "VFX_PRO_FORCE_SHIELD", 1015),
    ScriptConstant(DataType.INT, "VFX_IMP_FORCE_WAVE", 1017),
    ScriptConstant(DataType.INT, "VFX_IMP_FORCE_WHIRLWIND", 1018),
    ScriptConstant(DataType.INT, "VFX_IMP_HEAL", 1019),
    ScriptConstant(DataType.INT, "VFX_IMP_SPEED_KNIGHT", 1020),
    ScriptConstant(DataType.INT, "VFX_PRO_LIGHTNING_L", 1021),
    ScriptConstant(DataType.INT, "VFX_IMP_SPEED_MASTERY", 1022),
    ScriptConstant(DataType.INT, "VFX_PRO_RESIST_ELEMENTS", 1025),
    ScriptConstant(DataType.INT, "VFX_PRO_RESIST_FORCE", 1026),
    ScriptConstant(DataType.INT, "VFX_PRO_RESIST_POISON", 1027),
    ScriptConstant(DataType.INT, "VFX_PRO_LIGHTNING_S", 1028),
    ScriptConstant(DataType.INT, "VFX_IMP_MIND_FORCE", 1031),
    ScriptConstant(DataType.INT, "VFX_IMP_SUPPRESS_FORCE", 1032),
    ScriptConstant(DataType.INT, "VFX_IMP_MIND_KINIGHT", 1033),
    ScriptConstant(DataType.INT, "VFX_IMP_MIND_MASTERY", 1034),
    ScriptConstant(DataType.INT, "VFX_PRO_LIGHTNING_JEDI", 1035),
    ScriptConstant(DataType.INT, "VFX_PRO_LIGHTNING_L_SOUND", 1036),
    ScriptConstant(DataType.INT, "VFX_IMP_GRENADE_ADHESIVE_PERSONAL", 1038),
    ScriptConstant(DataType.INT, "VFX_IMP_FLAME", 1039),
    ScriptConstant(DataType.INT, "VFX_IMP_STUN", 1040),
    ScriptConstant(DataType.INT, "VFX_DUR_STEALTH_PULSE", 2000),
    ScriptConstant(DataType.INT, "VFX_DUR_INVISIBILITY", 2001),
    ScriptConstant(DataType.INT, "VFX_DUR_SPEED", 2004),
    ScriptConstant(DataType.INT, "VFX_DUR_FORCE_WHIRLWIND", 2007),
    ScriptConstant(DataType.INT, "VFX_DUR_HOLD", 2008),
    ScriptConstant(DataType.INT, "VFX_DUR_BODY_FUAL", 2024),
    ScriptConstant(DataType.INT, "VFX_DUR_PSYCHIC_STATIC", 2025),
    ScriptConstant(DataType.INT, "VFX_BEAM_DEATH_FIELD_TENTACLE", 2026),
    ScriptConstant(DataType.INT, "VFX_BEAM_DROID_DISABLE", 2027),
    ScriptConstant(DataType.INT, "VFX_BEAM_DROID_DESTROY", 2028),
    ScriptConstant(DataType.INT, "VFX_BEAM_DRAIN_LIFE", 2029),
    ScriptConstant(DataType.INT, "VFX_DUR_KNIGHTS_SPEED", 2031),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_RED_MARK_I", 2032),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_RED_MARK_II", 2034),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_RED_MARK_IV", 2035),
    ScriptConstant(DataType.INT, "VFX_BEAM_LIGHTNING_DARK_S", 2037),
    ScriptConstant(DataType.INT, "VFX_BEAM_LIGHTNING_DARK_L", 2038),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_BLUE_01", 2040),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_BLUE_02", 2041),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_BLUE_03", 2042),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_BLUE_04", 2043),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_GREEN_01", 2044),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_RED_01", 2045),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_RED_02", 2046),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_CHROME_01", 2047),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_CHROME_02", 2048),
    ScriptConstant(DataType.INT, "VFX_BEAM_ION_RAY_01", 2049),
    ScriptConstant(DataType.INT, "VFX_BEAM_ION_RAY_02", 2050),
    ScriptConstant(DataType.INT, "VFX_BEAM_COLD_RAY", 2051),
    ScriptConstant(DataType.INT, "VFX_BEAM_STUN_RAY", 2052),
    ScriptConstant(DataType.INT, "VFX_BEAM_FLAME_SPRAY", 2053),
    ScriptConstant(DataType.INT, "VFX_DUR_CARBONITE_ENCASING", 2054),
    ScriptConstant(DataType.INT, "VFX_DUR_CARBONITE_CHUNKS", 2055),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_BLUE_MARK_I", 2056),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_BLUE_MARK_II", 2058),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_BLUE_MARK_IV", 2059),
    ScriptConstant(DataType.INT, "VFX_FNF_FORCE_WAVE", 3001),
    ScriptConstant(DataType.INT, "VFX_FNF_PLOT_MAN_SONIC_WAVE", 3002),
    ScriptConstant(DataType.INT, "VFX_FNF_GRENADE_FRAGMENTATION", 3003),
    ScriptConstant(DataType.INT, "VFX_FNF_GRENADE_STUN", 3004),
    ScriptConstant(DataType.INT, "VFX_FNF_GRENADE_THERMAL_DETONATOR", 3005),
    ScriptConstant(DataType.INT, "VFX_FNF_GRENADE_POISON", 3006),
    ScriptConstant(DataType.INT, "VFX_FNF_GRENADE_SONIC", 3007),
    ScriptConstant(DataType.INT, "VFX_FNF_GRENADE_ADHESIVE", 3008),
    ScriptConstant(DataType.INT, "VFX_FNF_GRENADE_CRYOBAN", 3009),
    ScriptConstant(DataType.INT, "VFX_FNF_GRENADE_PLASMA", 3010),
    ScriptConstant(DataType.INT, "VFX_FNF_GRENADE_ION", 3011),
    ScriptConstant(DataType.INT, "VFX_FNF_GRAVITY_GENERATOR", 3013),
    ScriptConstant(DataType.INT, "VFX_COM_SPARKS_LARGE", 4003),
    ScriptConstant(DataType.INT, "VFX_COM_SPARKS_LIGHTSABER", 4004),
    ScriptConstant(DataType.INT, "VFX_COM_SPARKS_PARRY_METAL", 4011),
    ScriptConstant(DataType.INT, "VFX_COM_POWER_ATTACK_IMPROVED_STAFF", 4012),
    ScriptConstant(DataType.INT, "VFX_COM_POWER_BLAST_IMPROVED", 4013),
    ScriptConstant(DataType.INT, "VFX_COM_CRITICAL_STRIKE_IMPROVED_STAFF", 4014),
    ScriptConstant(DataType.INT, "VFX_COM_SNIPER_SHOT_IMPROVED", 4015),
    ScriptConstant(DataType.INT, "VFX_COM_MULTI_SHOT", 4016),
    ScriptConstant(DataType.INT, "VFX_COM_WHIRLWIND_STRIKE_STAFF", 4017),
    ScriptConstant(DataType.INT, "VFX_COM_CRITICAL_STRIKE_MASTERY_STAFF", 4018),
    ScriptConstant(DataType.INT, "VFX_COM_POWER_ATTACK_MASTERY_STAFF", 4019),
    ScriptConstant(DataType.INT, "VFX_COM_SNIPER_SHOT_MASTERY", 4020),
    ScriptConstant(DataType.INT, "VFX_COM_FLURRY_IMPROVED_STAFF", 4021),
    ScriptConstant(DataType.INT, "VFX_COM_RAPID_SHOT_IMPROVED", 4022),
    ScriptConstant(DataType.INT, "VFX_COM_BLASTER_DEFLECTION", 4023),
    ScriptConstant(DataType.INT, "VFX_COM_BLASTER_IMPACT", 4024),
    ScriptConstant(DataType.INT, "VFX_COM_CRITICAL_STRIKE_IMPROVED_SABER", 4025),
    ScriptConstant(DataType.INT, "VFX_COM_CRITICAL_STRIKE_MASTERY_SABER", 4026),
    ScriptConstant(DataType.INT, "VFX_COM_POWER_ATTACK_IMPROVED_SABER", 4027),
    ScriptConstant(DataType.INT, "VFX_COM_POWER_ATTACK_MASTERY_SABER", 4028),
    ScriptConstant(DataType.INT, "VFX_COM_POWER_BLAST_MASTERY", 4029),
    ScriptConstant(DataType.INT, "VFX_COM_FLURRY_IMPROVED_SABER", 4030),
    ScriptConstant(DataType.INT, "VFX_COM_WHIRLWIND_STRIKE_SABER", 4031),
    ScriptConstant(DataType.INT, "VFX_COM_BLASTER_IMPACT_GROUND", 4032),
    ScriptConstant(DataType.INT, "VFX_COM_SPARKS_BLASTER", 4033),
    ScriptConstant(DataType.INT, "VFX_COM_DROID_EXPLOSION_1", 4034),
    ScriptConstant(DataType.INT, "VFX_COM_DROID_EXPLOSION_2", 4035),
    ScriptConstant(DataType.INT, "VFX_COM_JEDI_FORCE_FIZZLE", 4036),
    ScriptConstant(DataType.INT, "VFX_COM_FORCE_RESISTED", 4037),
    ScriptConstant(DataType.INT, "VFX_ARD_LIGHT_YELLOW_10", 5000),
    ScriptConstant(DataType.INT, "VFX_ARD_LIGHT_YELLOW_20", 5001),
    ScriptConstant(DataType.INT, "VFX_ARD_LIGHT_BLIND", 5002),
    ScriptConstant(DataType.INT, "VFX_ARD_HEAT_SHIMMER", 5003),
    ScriptConstant(DataType.INT, "VFX_IMP_MIRV", 6000),
    ScriptConstant(DataType.INT, "VFX_IMP_MIRV_IMPACT", 6001),
    ScriptConstant(DataType.INT, "VFX_IMP_SCREEN_SHAKE", 6002),
    ScriptConstant(DataType.INT, "AOE_PER_FOGACID", 0),
    ScriptConstant(DataType.INT, "AOE_PER_FOGFIRE", 1),
    ScriptConstant(DataType.INT, "AOE_PER_FOGSTINK", 2),
    ScriptConstant(DataType.INT, "AOE_PER_FOGKILL", 3),
    ScriptConstant(DataType.INT, "AOE_PER_FOGMIND", 4),
    ScriptConstant(DataType.INT, "AOE_PER_WALLFIRE", 5),
    ScriptConstant(DataType.INT, "AOE_PER_WALLWIND", 6),
    ScriptConstant(DataType.INT, "AOE_PER_WALLBLADE", 7),
    ScriptConstant(DataType.INT, "AOE_PER_WEB", 8),
    ScriptConstant(DataType.INT, "AOE_PER_ENTANGLE", 9),
    ScriptConstant(DataType.INT, "AOE_PER_DARKNESS", 11),
    ScriptConstant(DataType.INT, "AOE_MOB_CIRCEVIL", 12),
    ScriptConstant(DataType.INT, "AOE_MOB_CIRCGOOD", 13),
    ScriptConstant(DataType.INT, "AOE_MOB_CIRCLAW", 14),
    ScriptConstant(DataType.INT, "AOE_MOB_CIRCCHAOS", 15),
    ScriptConstant(DataType.INT, "AOE_MOB_FEAR", 16),
    ScriptConstant(DataType.INT, "AOE_MOB_BLINDING", 17),
    ScriptConstant(DataType.INT, "AOE_MOB_UNEARTHLY", 18),
    ScriptConstant(DataType.INT, "AOE_MOB_MENACE", 19),
    ScriptConstant(DataType.INT, "AOE_MOB_UNNATURAL", 20),
    ScriptConstant(DataType.INT, "AOE_MOB_STUN", 21),
    ScriptConstant(DataType.INT, "AOE_MOB_PROTECTION", 22),
    ScriptConstant(DataType.INT, "AOE_MOB_FIRE", 23),
    ScriptConstant(DataType.INT, "AOE_MOB_FROST", 24),
    ScriptConstant(DataType.INT, "AOE_MOB_ELECTRICAL", 25),
    ScriptConstant(DataType.INT, "AOE_PER_FOGGHOUL", 26),
    ScriptConstant(DataType.INT, "AOE_MOB_TYRANT_FOG", 27),
    ScriptConstant(DataType.INT, "AOE_PER_STORM", 28),
    ScriptConstant(DataType.INT, "AOE_PER_INVIS_SPHERE", 29),
    ScriptConstant(DataType.INT, "AOE_MOB_SILENCE", 30),
    ScriptConstant(DataType.INT, "AOE_PER_DELAY_BLAST_FIREBALL", 31),
    ScriptConstant(DataType.INT, "AOE_PER_GREASE", 32),
    ScriptConstant(DataType.INT, "AOE_PER_CREEPING_DOOM", 33),
    ScriptConstant(DataType.INT, "AOE_PER_EVARDS_BLACK_TENTACLES", 34),
    ScriptConstant(DataType.INT, "AOE_MOB_INVISIBILITY_PURGE", 35),
    ScriptConstant(DataType.INT, "AOE_MOB_DRAGON_FEAR", 36),
    ScriptConstant(DataType.INT, "FORCE_POWER_ALL_FORCE_POWERS", -1),
    ScriptConstant(DataType.INT, "FORCE_POWER_MASTER_ALTER", 0),
    ScriptConstant(DataType.INT, "FORCE_POWER_MASTER_CONTROL", 1),
    ScriptConstant(DataType.INT, "FORCE_POWER_MASTER_SENSE", 2),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_JUMP_ADVANCED", 3),
    ScriptConstant(DataType.INT, "FORCE_POWER_LIGHT_SABER_THROW_ADVANCED", 4),
    ScriptConstant(DataType.INT, "FORCE_POWER_REGNERATION_ADVANCED", 5),
    ScriptConstant(DataType.INT, "FORCE_POWER_AFFECT_MIND", 6),
    ScriptConstant(DataType.INT, "FORCE_POWER_AFFLICTION", 7),
    ScriptConstant(DataType.INT, "FORCE_POWER_SPEED_BURST", 8),
    ScriptConstant(DataType.INT, "FORCE_POWER_CHOKE", 9),
    ScriptConstant(DataType.INT, "FORCE_POWER_CURE", 10),
    ScriptConstant(DataType.INT, "FORCE_POWER_DEATH_FIELD", 11),
    ScriptConstant(DataType.INT, "FORCE_POWER_DROID_DISABLE", 12),
    ScriptConstant(DataType.INT, "FORCE_POWER_DROID_DESTROY", 13),
    ScriptConstant(DataType.INT, "FORCE_POWER_DOMINATE", 14),
    ScriptConstant(DataType.INT, "FORCE_POWER_DRAIN_LIFE", 15),
    ScriptConstant(DataType.INT, "FORCE_POWER_FEAR", 16),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_ARMOR", 17),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_AURA", 18),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_BREACH", 19),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_IMMUNITY", 20),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_JUMP", 21),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_MIND", 22),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_PUSH", 23),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_SHIELD", 24),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_STORM", 25),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_WAVE", 26),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_WHIRLWIND", 27),
    ScriptConstant(DataType.INT, "FORCE_POWER_HEAL", 28),
    ScriptConstant(DataType.INT, "FORCE_POWER_HOLD", 29),
    ScriptConstant(DataType.INT, "FORCE_POWER_HORROR", 30),
    ScriptConstant(DataType.INT, "FORCE_POWER_INSANITY", 31),
    ScriptConstant(DataType.INT, "FORCE_POWER_KILL", 32),
    ScriptConstant(DataType.INT, "FORCE_POWER_KNIGHT_MIND", 33),
    ScriptConstant(DataType.INT, "FORCE_POWER_KNIGHT_SPEED", 34),
    ScriptConstant(DataType.INT, "FORCE_POWER_LIGHTNING", 35),
    ScriptConstant(DataType.INT, "FORCE_POWER_MIND_MASTERY", 36),
    ScriptConstant(DataType.INT, "FORCE_POWER_SPEED_MASTERY", 37),
    ScriptConstant(DataType.INT, "FORCE_POWER_PLAGUE", 38),
    ScriptConstant(DataType.INT, "FORCE_POWER_REGENERATION", 39),
    ScriptConstant(DataType.INT, "FORCE_POWER_RESIST_COLD_HEAT_ENERGY", 40),
    ScriptConstant(DataType.INT, "FORCE_POWER_RESIST_FORCE", 41),
    ScriptConstant(DataType.INT, "FORCE_POWER_RESIST_POISON_DISEASE_SONIC", 42),
    ScriptConstant(DataType.INT, "FORCE_POWER_SHOCK", 43),
    ScriptConstant(DataType.INT, "FORCE_POWER_SLEEP", 44),
    ScriptConstant(DataType.INT, "FORCE_POWER_SLOW", 45),
    ScriptConstant(DataType.INT, "FORCE_POWER_STUN", 46),
    ScriptConstant(DataType.INT, "FORCE_POWER_DROID_STUN", 47),
    ScriptConstant(DataType.INT, "FORCE_POWER_SUPRESS_FORCE", 48),
    ScriptConstant(DataType.INT, "FORCE_POWER_LIGHT_SABER_THROW", 49),
    ScriptConstant(DataType.INT, "FORCE_POWER_WOUND", 50),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_BATTLE_MEDITATION", 51),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_BODY_FUEL", 52),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_COMBAT_REGENERATION", 53),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_WARRIOR_STANCE", 54),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_SENTINEL_STANCE", 55),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_DOMINATE_MIND", 56),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_PSYCHIC_STANCE", 57),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_CATHAR_REFLEXES", 58),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_ENHANCED_SENSES", 59),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_CAMOFLAGE", 60),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_TAUNT", 61),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_WHIRLING_DERVISH", 62),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_RAGE", 63),
    ScriptConstant(DataType.INT, "POISON_ABILITY_SCORE_MILD", 0),
    ScriptConstant(DataType.INT, "POISON_ABILITY_SCORE_AVERAGE", 1),
    ScriptConstant(DataType.INT, "POISON_ABILITY_SCORE_VIRULENT", 2),
    ScriptConstant(DataType.INT, "POISON_DAMAGE_MILD", 3),
    ScriptConstant(DataType.INT, "POISON_DAMAGE_AVERAGE", 4),
    ScriptConstant(DataType.INT, "POISON_DAMAGE_VIRULENT", 5),
    ScriptConstant(DataType.INT, "CREATURE_TYPE_RACIAL_TYPE", 0),
    ScriptConstant(DataType.INT, "CREATURE_TYPE_PLAYER_CHAR", 1),
    ScriptConstant(DataType.INT, "CREATURE_TYPE_CLASS", 2),
    ScriptConstant(DataType.INT, "CREATURE_TYPE_REPUTATION", 3),
    ScriptConstant(DataType.INT, "CREATURE_TYPE_IS_ALIVE", 4),
    ScriptConstant(DataType.INT, "CREATURE_TYPE_HAS_SPELL_EFFECT", 5),
    ScriptConstant(DataType.INT, "CREATURE_TYPE_DOES_NOT_HAVE_SPELL_EFFECT", 6),
    ScriptConstant(DataType.INT, "CREATURE_TYPE_PERCEPTION", 7),
    ScriptConstant(DataType.INT, "REPUTATION_TYPE_FRIEND", 0),
    ScriptConstant(DataType.INT, "REPUTATION_TYPE_ENEMY", 1),
    ScriptConstant(DataType.INT, "REPUTATION_TYPE_NEUTRAL", 2),
    ScriptConstant(DataType.INT, "PERCEPTION_SEEN_AND_HEARD", 0),
    ScriptConstant(DataType.INT, "PERCEPTION_NOT_SEEN_AND_NOT_HEARD", 1),
    ScriptConstant(DataType.INT, "PERCEPTION_HEARD_AND_NOT_SEEN", 2),
    ScriptConstant(DataType.INT, "PERCEPTION_SEEN_AND_NOT_HEARD", 3),
    ScriptConstant(DataType.INT, "PERCEPTION_NOT_HEARD", 4),
    ScriptConstant(DataType.INT, "PERCEPTION_HEARD", 5),
    ScriptConstant(DataType.INT, "PERCEPTION_NOT_SEEN", 6),
    ScriptConstant(DataType.INT, "PERCEPTION_SEEN", 7),
    ScriptConstant(DataType.INT, "PLAYER_CHAR_NOT_PC", 0),
    ScriptConstant(DataType.INT, "PLAYER_CHAR_IS_PC", 1),
    ScriptConstant(DataType.INT, "CLASS_TYPE_SOLDIER", 0),
    ScriptConstant(DataType.INT, "CLASS_TYPE_SCOUT", 1),
    ScriptConstant(DataType.INT, "CLASS_TYPE_SCOUNDREL", 2),
    ScriptConstant(DataType.INT, "CLASS_TYPE_JEDIGUARDIAN", 3),
    ScriptConstant(DataType.INT, "CLASS_TYPE_JEDICONSULAR", 4),
    ScriptConstant(DataType.INT, "CLASS_TYPE_JEDISENTINEL", 5),
    ScriptConstant(DataType.INT, "CLASS_TYPE_COMBATDROID", 6),
    ScriptConstant(DataType.INT, "CLASS_TYPE_EXPERTDROID", 7),
    ScriptConstant(DataType.INT, "CLASS_TYPE_MINION", 8),
    ScriptConstant(DataType.INT, "CLASS_TYPE_INVALID", 255),
    ScriptConstant(DataType.INT, "PERSISTENT_ZONE_ACTIVE", 0),
    ScriptConstant(DataType.INT, "PERSISTENT_ZONE_FOLLOW", 1),
    ScriptConstant(DataType.INT, "INVALID_STANDARD_FACTION", -1),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_HOSTILE_1", 1),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_FRIENDLY_1", 2),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_HOSTILE_2", 3),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_FRIENDLY_2", 4),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_NEUTRAL", 5),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_INSANE", 6),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_PTAT_TUSKAN", 7),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_GLB_XOR", 8),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_SURRENDER_1", 9),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_SURRENDER_2", 10),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_PREDATOR", 11),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_PREY", 12),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_TRAP", 13),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_ENDAR_SPIRE", 14),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_RANCOR", 15),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_GIZKA_1", 16),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_GIZKA_2", 17),
    ScriptConstant(DataType.INT, "SKILL_COMPUTER_USE", 0),
    ScriptConstant(DataType.INT, "SKILL_DEMOLITIONS", 1),
    ScriptConstant(DataType.INT, "SKILL_STEALTH", 2),
    ScriptConstant(DataType.INT, "SKILL_AWARENESS", 3),
    ScriptConstant(DataType.INT, "SKILL_PERSUADE", 4),
    ScriptConstant(DataType.INT, "SKILL_REPAIR", 5),
    ScriptConstant(DataType.INT, "SKILL_SECURITY", 6),
    ScriptConstant(DataType.INT, "SKILL_TREAT_INJURY", 7),
    ScriptConstant(DataType.INT, "SKILL_MAX_SKILLS", 8),
    ScriptConstant(DataType.INT, "SUBSKILL_FLAGTRAP", 100),
    ScriptConstant(DataType.INT, "SUBSKILL_RECOVERTRAP", 101),
    ScriptConstant(DataType.INT, "SUBSKILL_EXAMINETRAP", 102),
    ScriptConstant(DataType.INT, "FEAT_ADVANCED_JEDI_DEFENSE", 1),
    ScriptConstant(DataType.INT, "FEAT_ADVANCED_GUARD_STANCE", 2),
    ScriptConstant(DataType.INT, "FEAT_AMBIDEXTERITY", 3),
    ScriptConstant(DataType.INT, "FEAT_ARMOUR_PROF_HEAVY", 4),
    ScriptConstant(DataType.INT, "FEAT_ARMOUR_PROF_LIGHT", 5),
    ScriptConstant(DataType.INT, "FEAT_ARMOUR_PROF_MEDIUM", 6),
    ScriptConstant(DataType.INT, "FEAT_CAUTIOUS", 7),
    ScriptConstant(DataType.INT, "FEAT_CRITICAL_STRIKE", 8),
    ScriptConstant(DataType.INT, "FEAT_DOUBLE_WEAPON_FIGHTING", 9),
    ScriptConstant(DataType.INT, "FEAT_EMPATHY", 10),
    ScriptConstant(DataType.INT, "FEAT_FLURRY", 11),
    ScriptConstant(DataType.INT, "FEAT_GEAR_HEAD", 12),
    ScriptConstant(DataType.INT, "FEAT_GREAT_FORTITUDE", 13),
    ScriptConstant(DataType.INT, "FEAT_IMPLANT_LEVEL_1", 14),
    ScriptConstant(DataType.INT, "FEAT_IMPLANT_LEVEL_2", 15),
    ScriptConstant(DataType.INT, "FEAT_IMPLANT_LEVEL_3", 16),
    ScriptConstant(DataType.INT, "FEAT_IMPROVED_POWER_ATTACK", 17),
    ScriptConstant(DataType.INT, "FEAT_IMPROVED_POWER_BLAST", 18),
    ScriptConstant(DataType.INT, "FEAT_IMPROVED_CRITICAL_STRIKE", 19),
    ScriptConstant(DataType.INT, "FEAT_IMPROVED_SNIPER_SHOT", 20),
    ScriptConstant(DataType.INT, "FEAT_IRON_WILL", 21),
    ScriptConstant(DataType.INT, "FEAT_LIGHTNING_REFLEXES", 22),
    ScriptConstant(DataType.INT, "FEAT_MASTER_JEDI_DEFENSE", 24),
    ScriptConstant(DataType.INT, "FEAT_MASTER_GUARD_STANCE", 25),
    ScriptConstant(DataType.INT, "FEAT_MULTI_SHOT", 26),
    ScriptConstant(DataType.INT, "FEAT_PERCEPTIVE", 27),
    ScriptConstant(DataType.INT, "FEAT_POWER_ATTACK", 28),
    ScriptConstant(DataType.INT, "FEAT_POWER_BLAST", 29),
    ScriptConstant(DataType.INT, "FEAT_RAPID_SHOT", 30),
    ScriptConstant(DataType.INT, "FEAT_SNIPER_SHOT", 31),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_FOCUS_BLASTER", 32),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_FOCUS_BLASTER_RIFLE", 33),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_FOCUS_GRENADE", 34),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_FOCUS_HEAVY_WEAPONS", 35),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_FOCUS_LIGHTSABER", 36),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_FOCUS_MELEE_WEAPONS", 37),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_FOCUS_SIMPLE_WEAPONS", 38),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_PROFICIENCY_BLASTER", 39),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_PROFICIENCY_BLASTER_RIFLE", 40),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_PROFICIENCY_GRENADE", 41),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_PROFICIENCY_HEAVY_WEAPONS", 42),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_PROFICIENCY_LIGHTSABER", 43),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_PROFICIENCY_MELEE_WEAPONS", 44),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_PROFICIENCY_SIMPLE_WEAPONS", 45),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_SPECIALIZATION_BLASTER", 46),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_SPECIALIZATION_BLASTER_RIFLE", 47),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_SPECIALIZATION_GRENADE", 48),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_SPECIALIZATION_HEAVY_WEAPONS", 49),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_SPECIALIZATION_LIGHTSABER", 50),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_SPECIALIZATION_MELEE_WEAPONS", 51),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_SPECIALIZATION_SIMPLE_WEAPONS", 52),
    ScriptConstant(DataType.INT, "FEAT_WHIRLWIND_ATTACK", 53),
    ScriptConstant(DataType.INT, "FEAT_GUARD_STANCE", 54),
    ScriptConstant(DataType.INT, "FEAT_JEDI_DEFENSE", 55),
    ScriptConstant(DataType.INT, "FEAT_UNCANNY_DODGE_1", 56),
    ScriptConstant(DataType.INT, "FEAT_UNCANNY_DODGE_2", 57),
    ScriptConstant(DataType.INT, "FEAT_SKILL_FOCUS_COMPUTER_USE", 58),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_1D6", 60),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_2D6", 61),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_3D6", 62),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_4D6", 63),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_5D6", 64),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_6D6", 65),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_7D6", 66),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_8D6", 67),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_9D6", 68),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_10D6", 69),
    ScriptConstant(DataType.INT, "FEAT_SKILL_FOCUS_DEMOLITIONS", 70),
    ScriptConstant(DataType.INT, "FEAT_SKILL_FOCUS_STEALTH", 71),
    ScriptConstant(DataType.INT, "FEAT_SKILL_FOCUS_AWARENESS", 72),
    ScriptConstant(DataType.INT, "FEAT_SKILL_FOCUS_PERSUADE", 73),
    ScriptConstant(DataType.INT, "FEAT_SKILL_FOCUS_REPAIR", 74),
    ScriptConstant(DataType.INT, "FEAT_SKILL_FOCUS_SECURITY", 75),
    ScriptConstant(DataType.INT, "FEAT_SKILL_FOCUS_TREAT_INJUURY", 76),
    ScriptConstant(DataType.INT, "FEAT_MASTER_SNIPER_SHOT", 77),
    ScriptConstant(DataType.INT, "FEAT_DROID_UPGRADE_1", 78),
    ScriptConstant(DataType.INT, "FEAT_DROID_UPGRADE_2", 79),
    ScriptConstant(DataType.INT, "FEAT_DROID_UPGRADE_3", 80),
    ScriptConstant(DataType.INT, "FEAT_MASTER_CRITICAL_STRIKE", 81),
    ScriptConstant(DataType.INT, "FEAT_MASTER_POWER_BLAST", 82),
    ScriptConstant(DataType.INT, "FEAT_MASTER_POWER_ATTACK", 83),
    ScriptConstant(DataType.INT, "FEAT_TOUGHNESS", 84),
    ScriptConstant(DataType.INT, "FEAT_ADVANCED_DOUBLE_WEAPON_FIGHTING", 85),
    ScriptConstant(DataType.INT, "FEAT_FORCE_FOCUS_ALTER", 86),
    ScriptConstant(DataType.INT, "FEAT_FORCE_FOCUS_CONTROL", 87),
    ScriptConstant(DataType.INT, "FEAT_FORCE_FOCUS_SENSE", 88),
    ScriptConstant(DataType.INT, "FEAT_FORCE_FOCUS_ADVANCED", 89),
    ScriptConstant(DataType.INT, "FEAT_FORCE_FOCUS_MASTERY", 90),
    ScriptConstant(DataType.INT, "FEAT_IMPROVED_FLURRY", 91),
    ScriptConstant(DataType.INT, "FEAT_IMPROVED_RAPID_SHOT", 92),
    ScriptConstant(DataType.INT, "FEAT_PROFICIENCY_ALL", 93),
    ScriptConstant(DataType.INT, "FEAT_BATTLE_MEDITATION", 94),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_INVALID", 0),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_CALLED_SHOT_LEG", 1),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_CALLED_SHOT_ARM", 2),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_SAP", 3),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_DISARM", 4),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_IMPROVED_DISARM", 5),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_KNOCKDOWN", 6),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_IMPROVED_KNOCKDOWN", 7),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_STUNNING_FIST", 8),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_FLURRY_OF_BLOWS", 9),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_RAPID_SHOT", 10),
    ScriptConstant(DataType.INT, "COMBAT_MODE_INVALID", 0),
    ScriptConstant(DataType.INT, "COMBAT_MODE_PARRY", 1),
    ScriptConstant(DataType.INT, "COMBAT_MODE_POWER_ATTACK", 2),
    ScriptConstant(DataType.INT, "COMBAT_MODE_IMPROVED_POWER_ATTACK", 3),
    ScriptConstant(DataType.INT, "COMBAT_MODE_FLURRY_OF_BLOWS", 4),
    ScriptConstant(DataType.INT, "COMBAT_MODE_RAPID_SHOT", 5),
    ScriptConstant(DataType.INT, "ENCOUNTER_DIFFICULTY_VERY_EASY", 0),
    ScriptConstant(DataType.INT, "ENCOUNTER_DIFFICULTY_EASY", 1),
    ScriptConstant(DataType.INT, "ENCOUNTER_DIFFICULTY_NORMAL", 2),
    ScriptConstant(DataType.INT, "ENCOUNTER_DIFFICULTY_HARD", 3),
    ScriptConstant(DataType.INT, "ENCOUNTER_DIFFICULTY_IMPOSSIBLE", 4),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_PAUSE", 0),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_PAUSE2", 1),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_LISTEN", 2),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_MEDITATE", 3),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_WORSHIP", 4),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_TALK_NORMAL", 5),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_TALK_PLEADING", 6),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_TALK_FORCEFUL", 7),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_TALK_LAUGHING", 8),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_TALK_SAD", 9),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_GET_LOW", 10),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_GET_MID", 11),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_PAUSE_TIRED", 12),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_PAUSE_DRUNK", 13),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_FLIRT", 14),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_USE_COMPUTER", 15),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_DANCE", 16),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_DANCE1", 17),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_HORROR", 18),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_READY", 19),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_DEACTIVATE", 20),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_SPASM", 21),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_SLEEP", 22),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_PRONE", 23),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_PAUSE3", 24),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_WELD", 25),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_DEAD", 26),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_TALK_INJURED", 27),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_LISTEN_INJURED", 28),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_TREAT_INJURED", 29),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_DEAD_PRONE", 30),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_KNEEL_TALK_ANGRY", 31),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_KNEEL_TALK_SAD", 32),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_CHOKE", 116),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_HEAD_TURN_LEFT", 100),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_HEAD_TURN_RIGHT", 101),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_PAUSE_SCRATCH_HEAD", 102),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_PAUSE_BORED", 103),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_SALUTE", 104),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_BOW", 105),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_GREETING", 106),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_TAUNT", 107),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_VICTORY1", 108),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_VICTORY2", 109),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_VICTORY3", 110),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_INJECT", 112),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_USE_COMPUTER", 113),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_PERSUADE", 114),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_ACTIVATE", 115),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_CHOKE", 116),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_THROW_HIGH", 117),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_THROW_LOW", 118),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_CUSTOM01", 119),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_TREAT_INJURED", 120),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ACTIVATE", 200),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_DEACTIVATE", 201),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_OPEN", 202),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_CLOSE", 203),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP01", 204),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP02", 205),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP03", 206),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP04", 207),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP05", 208),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP06", 209),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP07", 210),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP08", 211),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP09", 212),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP10", 213),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP01", 1),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP02", 2),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP03", 3),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP04", 4),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP05", 5),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP06", 6),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP07", 7),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP08", 8),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP09", 9),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP10", 10),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP11", 11),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP12", 12),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP13", 13),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP14", 14),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP15", 15),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP16", 16),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP17", 17),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP18", 18),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP19", 19),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP20", 20),
    ScriptConstant(DataType.INT, "TALENT_TYPE_FORCE", 0),
    ScriptConstant(DataType.INT, "TALENT_TYPE_SPELL", 0),
    ScriptConstant(DataType.INT, "TALENT_TYPE_FEAT", 1),
    ScriptConstant(DataType.INT, "TALENT_TYPE_SKILL", 2),
    ScriptConstant(DataType.INT, "TALENT_EXCLUDE_ALL_OF_TYPE", -1),
    ScriptConstant(DataType.INT, "INVENTORY_DISTURB_TYPE_ADDED", 0),
    ScriptConstant(DataType.INT, "INVENTORY_DISTURB_TYPE_REMOVED", 1),
    ScriptConstant(DataType.INT, "INVENTORY_DISTURB_TYPE_STOLEN", 2),
    ScriptConstant(DataType.INT, "GUI_PANEL_PLAYER_DEATH", 0),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_WEREWOLF", 0),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_WERERAT", 1),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_WERECAT", 2),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_GIANT_SPIDER", 3),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_TROLL", 4),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_UMBER_HULK", 5),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_PIXIE", 6),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_ZOMBIE", 7),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_RED_DRAGON", 8),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_FIRE_GIANT", 9),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_BALOR", 10),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_DEATH_SLAAD", 11),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_IRON_GOLEM", 12),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_HUGE_FIRE_ELEMENTAL", 13),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_HUGE_WATER_ELEMENTAL", 14),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_HUGE_EARTH_ELEMENTAL", 15),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_HUGE_AIR_ELEMENTAL", 16),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_ELDER_FIRE_ELEMENTAL", 17),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_ELDER_WATER_ELEMENTAL", 18),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_ELDER_EARTH_ELEMENTAL", 19),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_ELDER_AIR_ELEMENTAL", 20),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_BROWN_BEAR", 21),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_PANTHER", 22),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_WOLF", 23),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_BOAR", 24),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_BADGER", 25),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_PENGUIN", 26),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_COW", 27),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_DOOM_KNIGHT", 28),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_YUANTI", 29),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_IMP", 30),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_QUASIT", 31),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_SUCCUBUS", 32),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_DIRE_BROWN_BEAR", 33),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_DIRE_PANTHER", 34),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_DIRE_WOLF", 35),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_DIRE_BOAR", 36),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_DIRE_BADGER", 37),
    ScriptConstant(DataType.INT, "INVISIBILITY_TYPE_NORMAL", 1),
    ScriptConstant(DataType.INT, "INVISIBILITY_TYPE_DARKNESS", 2),
    ScriptConstant(DataType.INT, "INVISIBILITY_TYPE_IMPROVED", 4),
    ScriptConstant(DataType.INT, "CREATURE_SIZE_INVALID", 0),
    ScriptConstant(DataType.INT, "CREATURE_SIZE_TINY", 1),
    ScriptConstant(DataType.INT, "CREATURE_SIZE_SMALL", 2),
    ScriptConstant(DataType.INT, "CREATURE_SIZE_MEDIUM", 3),
    ScriptConstant(DataType.INT, "CREATURE_SIZE_LARGE", 4),
    ScriptConstant(DataType.INT, "CREATURE_SIZE_HUGE", 5),
    ScriptConstant(DataType.INT, "CAMERA_MODE_CHASE_CAMERA", 0),
    ScriptConstant(DataType.INT, "CAMERA_MODE_TOP_DOWN", 1),
    ScriptConstant(DataType.INT, "CAMERA_MODE_STIFF_CHASE_CAMERA", 2),
    ScriptConstant(DataType.INT, "PROJECTILE_PATH_TYPE_DEFAULT", 0),
    ScriptConstant(DataType.INT, "PROJECTILE_PATH_TYPE_HOMING", 1),
    ScriptConstant(DataType.INT, "PROJECTILE_PATH_TYPE_BALLISTIC", 2),
    ScriptConstant(DataType.INT, "PROJECTILE_PATH_TYPE_HIGH_BALLISTIC", 3),
    ScriptConstant(DataType.INT, "PROJECTILE_PATH_TYPE_ACCELERATING", 4),
    ScriptConstant(DataType.INT, "GAME_DIFFICULTY_VERY_EASY", 0),
    ScriptConstant(DataType.INT, "GAME_DIFFICULTY_EASY", 1),
    ScriptConstant(DataType.INT, "GAME_DIFFICULTY_NORMAL", 2),
    ScriptConstant(DataType.INT, "GAME_DIFFICULTY_CORE_RULES", 3),
    ScriptConstant(DataType.INT, "GAME_DIFFICULTY_DIFFICULT", 4),
    ScriptConstant(DataType.INT, "ACTION_MOVETOPOINT", 0),
    ScriptConstant(DataType.INT, "ACTION_PICKUPITEM", 1),
    ScriptConstant(DataType.INT, "ACTION_DROPITEM", 2),
    ScriptConstant(DataType.INT, "ACTION_ATTACKOBJECT", 3),
    ScriptConstant(DataType.INT, "ACTION_CASTSPELL", 4),
    ScriptConstant(DataType.INT, "ACTION_OPENDOOR", 5),
    ScriptConstant(DataType.INT, "ACTION_CLOSEDOOR", 6),
    ScriptConstant(DataType.INT, "ACTION_DIALOGOBJECT", 7),
    ScriptConstant(DataType.INT, "ACTION_DISABLETRAP", 8),
    ScriptConstant(DataType.INT, "ACTION_RECOVERTRAP", 9),
    ScriptConstant(DataType.INT, "ACTION_FLAGTRAP", 10),
    ScriptConstant(DataType.INT, "ACTION_EXAMINETRAP", 11),
    ScriptConstant(DataType.INT, "ACTION_SETTRAP", 12),
    ScriptConstant(DataType.INT, "ACTION_OPENLOCK", 13),
    ScriptConstant(DataType.INT, "ACTION_LOCK", 14),
    ScriptConstant(DataType.INT, "ACTION_USEOBJECT", 15),
    ScriptConstant(DataType.INT, "ACTION_ANIMALEMPATHY", 16),
    ScriptConstant(DataType.INT, "ACTION_REST", 17),
    ScriptConstant(DataType.INT, "ACTION_TAUNT", 18),
    ScriptConstant(DataType.INT, "ACTION_ITEMCASTSPELL", 19),
    ScriptConstant(DataType.INT, "ACTION_COUNTERSPELL", 31),
    ScriptConstant(DataType.INT, "ACTION_HEAL", 33),
    ScriptConstant(DataType.INT, "ACTION_PICKPOCKET", 34),
    ScriptConstant(DataType.INT, "ACTION_FOLLOW", 35),
    ScriptConstant(DataType.INT, "ACTION_WAIT", 36),
    ScriptConstant(DataType.INT, "ACTION_SIT", 37),
    ScriptConstant(DataType.INT, "ACTION_FOLLOWLEADER", 38),
    ScriptConstant(DataType.INT, "ACTION_INVALID", 65535),
    ScriptConstant(DataType.INT, "ACTION_QUEUEEMPTY", 65534),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_FLASH_STUN_MINOR", 0),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_FLASH_STUN_AVERAGE", 1),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_FLASH_STUN_DEADLY", 2),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_FRAGMENTATION_MINE_MINOR", 3),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_FRAGMENTATION_MINE_AVERAGE", 4),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_FRAGMENTATION_MINE_DEADLY", 5),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_LASER_SLICING_MINOR", 6),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_LASER_SLICING_AVERAGE", 7),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_LASER_SLICING_DEADLY", 8),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_POISON_GAS_MINOR", 9),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_POISON_GAS_AVERAGE", 10),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_POISON_GAS_DEADLY", 11),
    ScriptConstant(DataType.INT, "SWMINIGAME_TRACKFOLLOWER_SOUND_ENGINE", 0),
    ScriptConstant(DataType.INT, "SWMINIGAME_TRACKFOLLOWER_SOUND_DEATH", 1),
    ScriptConstant(DataType.INT, "CONVERSATION_TYPE_CINEMATIC", 0),
    ScriptConstant(DataType.INT, "CONVERSATION_TYPE_COMPUTER", 1),
    ScriptConstant(DataType.INT, "PLANET_ENDAR_SPIRE", 0),
    ScriptConstant(DataType.INT, "PLANET_TARIS", 1),
    ScriptConstant(DataType.INT, "PLANET_EBON_HAWK", 2),
    ScriptConstant(DataType.INT, "PLANET_DANTOOINE", 3),
    ScriptConstant(DataType.INT, "PLANET_TATOOINE", 4),
    ScriptConstant(DataType.INT, "PLANET_KASHYYYK", 5),
    ScriptConstant(DataType.INT, "PLANET_MANAAN", 6),
    ScriptConstant(DataType.INT, "PLANET_KORRIBAN", 7),
    ScriptConstant(DataType.INT, "PLANET_LEVIATHAN", 8),
    ScriptConstant(DataType.INT, "PLANET_UNKNOWN_WORLD", 9),
    ScriptConstant(DataType.INT, "PLANET_STAR_FORGE", 10),
    ScriptConstant(DataType.INT, "PLANET_LIVE_01", 11),
    ScriptConstant(DataType.INT, "PLANET_LIVE_02", 12),
    ScriptConstant(DataType.INT, "PLANET_LIVE_03", 13),
    ScriptConstant(DataType.INT, "PLANET_LIVE_04", 14),
    ScriptConstant(DataType.INT, "PLANET_LIVE_05", 15),
    ScriptConstant(DataType.INT, "NPC_PLAYER", -1),
    ScriptConstant(DataType.INT, "NPC_BASTILA", 0),
    ScriptConstant(DataType.INT, "NPC_CANDEROUS", 1),
    ScriptConstant(DataType.INT, "NPC_CARTH", 2),
    ScriptConstant(DataType.INT, "NPC_HK_47", 3),
    ScriptConstant(DataType.INT, "NPC_JOLEE", 4),
    ScriptConstant(DataType.INT, "NPC_JUHANI", 5),
    ScriptConstant(DataType.INT, "NPC_MISSION", 6),
    ScriptConstant(DataType.INT, "NPC_T3_M4", 7),
    ScriptConstant(DataType.INT, "NPC_ZAALBAR", 8),
    ScriptConstant(DataType.INT, "PARTY_AISTYLE_AGGRESSIVE", 0),
    ScriptConstant(DataType.INT, "PARTY_AISTYLE_DEFENSIVE", 1),
    ScriptConstant(DataType.INT, "PARTY_AISTYLE_PASSIVE", 2),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_DEFAULT_ATTACK", 0),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_RANGED_ATTACK", 1),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_MELEE_ATTACK", 2),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_AID", 3),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_GRENADE_THROWER", 4),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_JEDI_SUPPORT", 5),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_TEST", 1),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_T3M3", 2),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_HK47", 3),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_BASTILLA", 4),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_CAND", 5),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_CARTH", 6),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_JOLEE", 7),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_JUHANI", 8),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_ZAALBAR", 9),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MISSION", 10),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_ADMRLSAULKAR", 11),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_BITH", 12),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_CALONORD", 13),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_COMMF", 14),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_COMMKIDF", 15),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_COMMKIDM", 16),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_COMMM", 17),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_CZERLAOFF", 18),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_DARKJEDIF", 19),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_DARKJEDIM", 20),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_DARTHMALAK", 21),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_DARTHREVAN", 22),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_DODONNA", 23),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_DUROS", 24),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_FATCOMF", 25),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_FATCOMM", 26),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_SMUGGLER", 27),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_SITHSOLDIER", 28),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_JEDICOUNTF", 30),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_JEDICOUNTM", 31),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_JEDIMALEK", 32),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_JEDIMEMF", 33),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_JEDIMEMM", 34),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_MANDALORIAN", 35),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_RAKATA", 36),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_REPOFF", 37),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_REPSOLD", 38),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_RODIAN", 39),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_SELKATH", 40),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_SITHAPPREN", 41),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_SITHCOMF", 42),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_SITHCOMM", 43),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_SWOOPGANG", 45),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_TUSKEN", 46),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_TWILEKF", 47),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_TWILEKM", 48),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_WALRUSMAN", 49),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_WOOKIEF", 50),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_WOOKIEM", 51),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_YODA", 52),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_BANTHA", 53),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_BRITH", 54),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DEWBACK", 55),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDASSASSIN", 56),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDASTRO", 57),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDG", 58),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDMKFOUR", 59),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDMKONE", 60),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDMKTWO", 61),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDPROBE", 62),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDPROT", 63),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDSENTRY", 64),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDSPYDER", 65),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDWAR", 66),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_FIRIXA", 67),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_GAMMOREAN", 68),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_GIZKA", 69),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_HUTT", 70),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_IRIAZ", 71),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_ITHORIAN", 72),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_JAWA", 73),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_KATAARN", 74),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_KHOUNDA", 75),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_KHOUNDB", 76),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_KRAYTDRAGON", 77),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_MYKAL", 78),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_RAKGHOUL", 79),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_RANCOR", 80),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_SEABEAST", 81),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_TACH", 83),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_TWOHEAD", 84),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_VERKAAL", 85),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_WRAID", 86),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_RONTO", 87),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_KINRATH", 88),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_TUKATA", 89),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_TUSKENF", 90),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_SML_01", 91),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_MED_01", 92),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_LRG_01", 93),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_SML_02", 94),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_MED_02", 95),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_LRG_02", 96),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_SML_03", 97),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_MED_03", 98),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_LRG_03", 99),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_SML_04", 100),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_MED_04", 101),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_LRG_04", 102),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_SML_05", 103),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_MED_05", 104),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_LRG_05", 105),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_SML_01", 106),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_MED_01", 107),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_LRG_01", 108),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_SML_02", 109),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_MED_02", 110),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_LRG_02", 111),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_SML_03", 112),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_MED_03", 113),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_LRG_03", 114),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_SML_04", 115),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_MED_04", 116),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_LRG_04", 117),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_SML_05", 118),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_MED_05", 119),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_LRG_05", 120),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_SML_01", 121),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_MED_01", 122),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_LRG_01", 123),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_SML_02", 124),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_MED_02", 125),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_LRG_02", 126),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_SML_03", 127),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_MED_03", 128),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_LRG_03", 129),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_SML_04", 130),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_MED_04", 131),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_LRG_04", 132),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_SML_05", 133),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_MED_05", 134),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_LRG_05", 135),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_SML_01", 136),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_MED_01", 137),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_LRG_01", 138),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_SML_02", 139),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_MED_02", 140),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_LRG_02", 141),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_SML_03", 142),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_MED_03", 143),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_LRG_03", 144),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_SML_04", 145),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_MED_04", 146),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_LRG_04", 147),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_SML_05", 148),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_MED_05", 149),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_LRG_05", 150),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_SML_01", 151),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_MED_01", 152),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_LRG_01", 153),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_SML_02", 154),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_MED_02", 155),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_LRG_02", 156),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_SML_03", 157),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_MED_03", 158),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_LRG_03", 159),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_SML_04", 160),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_MED_04", 161),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_LRG_04", 162),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_SML_05", 163),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_MED_05", 164),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_LRG_05", 165),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_SML_01", 166),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_MED_01", 167),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_LRG_01", 168),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_SML_02", 169),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_MED_02", 170),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_LRG_02", 171),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_SML_03", 172),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_MED_03", 173),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_LRG_03", 174),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_SML_04", 175),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_MED_04", 176),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_LRG_04", 177),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_SML_05", 178),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_MED_05", 179),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_LRG_05", 180),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_ENVIRONMENTSUIT", 181),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_TURRET", 182),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_TURRET2", 183),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_DARTHBAND", 184),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_FEM_WHITE", 185),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_FEM_BLACK", 186),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_FEM_OLD_ASIAN", 187),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_FEM_OLD_WHITE", 188),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_FEM_OLD_BLACK", 189),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_MAL_WHITE", 190),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_MAL_BLACK", 191),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_MAL_OLD_ASIAN", 192),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_MAL_OLD_WHITE", 193),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_MAL_OLD_BLACK", 194),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_CZERKA_OFFICER_WHITE", 195),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_CZERKA_OFFICER_BLACK", 196),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_CZERKA_OFFICER_OLD_ASIAN", 197),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_CZERKA_OFFICER_OLD_WHITE", 198),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_CZERKA_OFFICER_OLD_BLACK", 199),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_FEMALE_02", 200),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_FEMALE_03", 201),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_FEMALE_04", 202),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_FEMALE_05", 203),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_FEMALE_01", 204),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_FEMALE_02", 205),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_FEMALE_03", 206),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_FEMALE_04", 207),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_FEMALE_05", 208),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_FEMALE_01", 209),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_FEMALE_02", 210),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_FEMALE_03", 211),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_FEMALE_04", 212),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_FEMALE_05", 213),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_MALE_02", 214),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_MALE_03", 215),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_MALE_04", 216),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_MALE_05", 217),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_MALE_01", 218),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_MALE_02", 219),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_MALE_03", 220),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_MALE_04", 221),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_MALE_05", 222),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_MALE_01", 223),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_MALE_02", 224),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_MALE_03", 225),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_MALE_04", 226),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_MALE_05", 227),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_HUTT_02", 228),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_HUTT_03", 229),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_HUTT_04", 230),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_DROID_ASTRO_02", 231),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_DROID_ASTRO_03", 232),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_DROID_PROTOCOL_02", 233),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_DROID_PROTOCOL_03", 234),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_DROID_PROTOCOL_04", 235),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_DROID_WAR_02", 236),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_DROID_WAR_03", 237),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_DROID_WAR_04", 238),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_DROID_WAR_05", 239),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_GAMMOREAN_02", 240),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_GAMMOREAN_03", 241),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_GAMMOREAN_04", 242),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_ITHORIAN_02", 243),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_ITHORIAN_03", 244),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_KATH_HOUND_A02", 245),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_KATH_HOUND_A03", 246),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_KATH_HOUND_A04", 247),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_KATH_HOUND_B02", 248),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_KATH_HOUND_B03", 249),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_KATH_HOUND_B04", 250),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WRAID_02", 251),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WRAID_03", 252),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WRAID_04", 253),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_RAKATA_02", 254),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_RAKATA_03", 255),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_RODIAN_02", 256),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_RODIAN_03", 257),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_RODIAN_04", 258),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SELKATH_02", 259),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SELKATH_03", 260),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_SOLDIER_03", 261),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SWOOP_GANG_02", 262),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SWOOP_GANG_03", 263),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SWOOP_GANG_04", 264),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SWOOP_GANG_05", 265),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_TUSKAN_RAIDER_02", 266),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_TUSKAN_RAIDER_03", 267),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_TUSKAN_RAIDER_04", 268),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_TWILEK_MALE_02", 269),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_TWILEK_FEMALE_02", 270),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WOOKIE_MALE_02", 271),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WOOKIE_MALE_03", 272),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WOOKIE_MALE_04", 273),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WOOKIE_MALE_05", 274),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WOOKIE_FEMALE_02", 275),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WOOKIE_FEMALE_03", 276),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WOOKIE_FEMALE_04", 277),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WOOKIE_FEMALE_05", 278),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_ENVIRONMENTSUIT_02", 279),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_YUTHURA_BAN", 280),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SHYRACK_01", 281),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SHYRACK_02", 282),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_REPUBLIC_SOLDIER_MAL_BLACK", 283),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_REPUBLIC_SOLDIER_MAL_OLD_ASIAN", 284),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_REPUBLIC_SOLDIER_MAL_OLD_WHITE", 285),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_REPUBLIC_SOLDIER_MAL_OLD_BLACK", 286),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_REPUBLIC_OFFICER_MAL_BLACK", 287),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_REPUBLIC_OFFICER_MAL_OLD_ASIAN", 288),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_REPUBLIC_OFFICER_MAL_OLD_WHITE", 289),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_REPUBLIC_OFFICER_MAL_OLD_BLACK", 290),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_FEM_WHITE", 291),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_FEM_BLACK", 292),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_FEM_OLD_ASIAN", 293),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_FEM_OLD_WHITE", 294),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_FEM_OLD_BLACK", 295),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_MAL_WHITE", 296),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_MAL_BLACK", 297),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_MAL_OLD_ASIAN", 298),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_MAL_OLD_WHITE", 299),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_MAL_OLD_BLACK", 300),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_FEM_ASIAN", 301),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_MAL_ASIAN", 302),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_OLD_MALE", 303),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_OLD_MALE", 304),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_OLD_MALE", 305),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_OLD_FEM", 306),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_OLD_FEM", 307),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_OLD_FEM", 308),
    ScriptConstant(DataType.INT, "PLOT_O_DOOM", 0),
    ScriptConstant(DataType.INT, "PLOT_O_SCARY_STUFF", 1),
    ScriptConstant(DataType.INT, "PLOT_O_BIG_MONSTERS", 2),
    ScriptConstant(DataType.INT, "FORMATION_WEDGE", 0),
    ScriptConstant(DataType.INT, "FORMATION_LINE", 1),
    ScriptConstant(DataType.INT, "SUBSCREEN_ID_NONE", 0),
    ScriptConstant(DataType.INT, "SUBSCREEN_ID_EQUIP", 1),
    ScriptConstant(DataType.INT, "SUBSCREEN_ID_ITEM", 2),
    ScriptConstant(DataType.INT, "SUBSCREEN_ID_CHARACTER_RECORD", 3),
    ScriptConstant(DataType.INT, "SUBSCREEN_ID_ABILITY", 4),
    ScriptConstant(DataType.INT, "SUBSCREEN_ID_MAP", 5),
    ScriptConstant(DataType.INT, "SUBSCREEN_ID_QUEST", 6),
    ScriptConstant(DataType.INT, "SUBSCREEN_ID_OPTIONS", 7),
    ScriptConstant(DataType.INT, "SUBSCREEN_ID_MESSAGES", 8),
    ScriptConstant(DataType.INT, "SHIELD_DROID_ENERGY_1", 0),
    ScriptConstant(DataType.INT, "SHIELD_DROID_ENERGY_2", 1),
    ScriptConstant(DataType.INT, "SHIELD_DROID_ENERGY_3", 2),
    ScriptConstant(DataType.INT, "SHIELD_DROID_ENVIRO_1", 3),
    ScriptConstant(DataType.INT, "SHIELD_DROID_ENVIRO_2", 4),
    ScriptConstant(DataType.INT, "SHIELD_DROID_ENVIRO_3", 5),
    ScriptConstant(DataType.INT, "SHIELD_ENERGY", 6),
    ScriptConstant(DataType.INT, "SHIELD_ENERGY_SITH", 7),
    ScriptConstant(DataType.INT, "SHIELD_ENERGY_ARKANIAN", 8),
    ScriptConstant(DataType.INT, "SHIELD_ECHANI", 9),
    ScriptConstant(DataType.INT, "SHIELD_MANDALORIAN_MELEE", 10),
    ScriptConstant(DataType.INT, "SHIELD_MANDALORIAN_POWER", 11),
    ScriptConstant(DataType.INT, "SHIELD_DUELING_ECHANI", 12),
    ScriptConstant(DataType.INT, "SHIELD_DUELING_YUSANIS", 13),
    ScriptConstant(DataType.INT, "SHIELD_VERPINE_PROTOTYPE", 14),
    ScriptConstant(DataType.INT, "SHIELD_ANTIQUE_DROID", 15),
    ScriptConstant(DataType.INT, "SHIELD_PLOT_TAR_M09AA", 16),
    ScriptConstant(DataType.INT, "SHIELD_PLOT_UNK_M44AA", 17),
    ScriptConstant(DataType.INT, "SUBRACE_NONE", 0),
    ScriptConstant(DataType.INT, "SUBRACE_WOOKIE", 1),
    ScriptConstant(DataType.INT, "VIDEO_EFFECT_NONE", -1),
    ScriptConstant(DataType.INT, "VIDEO_EFFECT_SECURITY_CAMERA", 0),
    ScriptConstant(DataType.INT, "VIDEO_EFFECT_FREELOOK_T3M4", 1),
    ScriptConstant(DataType.INT, "VIDEO_EFFECT_FREELOOK_HK47", 2),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_START_SWOOP_RACE", 0),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_RETURN_TO_BASE", 1),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_MOVEMENT_KEYS", 2),
    ScriptConstant(DataType.INT, "MOVEMENT_SPEED_PC", 0),
    ScriptConstant(DataType.INT, "MOVEMENT_SPEED_IMMOBILE", 1),
    ScriptConstant(DataType.INT, "MOVEMENT_SPEED_VERYSLOW", 2),
    ScriptConstant(DataType.INT, "MOVEMENT_SPEED_SLOW", 3),
    ScriptConstant(DataType.INT, "MOVEMENT_SPEED_NORMAL", 4),
    ScriptConstant(DataType.INT, "MOVEMENT_SPEED_FAST", 5),
    ScriptConstant(DataType.INT, "MOVEMENT_SPEED_VERYFAST", 6),
    ScriptConstant(DataType.INT, "MOVEMENT_SPEED_DEFAULT", 7),
    ScriptConstant(DataType.INT, "MOVEMENT_SPEED_DMFAST", 8),
    ScriptConstant(DataType.INT, "LIVE_CONTENT_PKG1", 1),
    ScriptConstant(DataType.INT, "LIVE_CONTENT_PKG2", 2),
    ScriptConstant(DataType.INT, "LIVE_CONTENT_PKG3", 3),
    ScriptConstant(DataType.INT, "LIVE_CONTENT_PKG4", 4),
    ScriptConstant(DataType.INT, "LIVE_CONTENT_PKG5", 5),
    ScriptConstant(DataType.INT, "LIVE_CONTENT_PKG6", 6),
]

TSL_CONSTANTS = [
    ScriptConstant(DataType.INT, "NUM_INVENTORY_SLOTS", 20),
    ScriptConstant(DataType.INT, "TRUE", 1),
    ScriptConstant(DataType.INT, "FALSE", 0),
    ScriptConstant(DataType.FLOAT, "DIRECTION_EAST", 0.0),
    ScriptConstant(DataType.FLOAT, "DIRECTION_NORTH", 90.0),
    ScriptConstant(DataType.FLOAT, "DIRECTION_WEST", 180.0),
    ScriptConstant(DataType.FLOAT, "DIRECTION_SOUTH", 270.0),
    ScriptConstant(DataType.FLOAT, "PI", 3.141592),
    ScriptConstant(DataType.INT, "ATTITUDE_NEUTRAL", 0),
    ScriptConstant(DataType.INT, "ATTITUDE_AGGRESSIVE", 1),
    ScriptConstant(DataType.INT, "ATTITUDE_DEFENSIVE", 2),
    ScriptConstant(DataType.INT, "ATTITUDE_SPECIAL", 3),
    ScriptConstant(DataType.INT, "TALKVOLUME_TALK", 0),
    ScriptConstant(DataType.INT, "TALKVOLUME_WHISPER", 1),
    ScriptConstant(DataType.INT, "TALKVOLUME_SHOUT", 2),
    ScriptConstant(DataType.INT, "TALKVOLUME_SILENT_TALK", 3),
    ScriptConstant(DataType.INT, "TALKVOLUME_SILENT_SHOUT", 4),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_HEAD", 0),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_BODY", 1),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_HANDS", 3),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_RIGHTWEAPON", 4),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_LEFTWEAPON", 5),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_LEFTARM", 7),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_RIGHTARM", 8),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_IMPLANT", 9),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_BELT", 10),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_CWEAPON_L", 14),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_CWEAPON_R", 15),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_CWEAPON_B", 16),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_CARMOUR", 17),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_RIGHTWEAPON2", 18),
    ScriptConstant(DataType.INT, "INVENTORY_SLOT_LEFTWEAPON2", 19),
    ScriptConstant(DataType.INT, "DURATION_TYPE_INSTANT", 0),
    ScriptConstant(DataType.INT, "DURATION_TYPE_TEMPORARY", 1),
    ScriptConstant(DataType.INT, "DURATION_TYPE_PERMANENT", 2),
    ScriptConstant(DataType.INT, "SUBTYPE_MAGICAL", 8),
    ScriptConstant(DataType.INT, "SUBTYPE_SUPERNATURAL", 16),
    ScriptConstant(DataType.INT, "SUBTYPE_EXTRAORDINARY", 24),
    ScriptConstant(DataType.INT, "ABILITY_STRENGTH", 0),
    ScriptConstant(DataType.INT, "ABILITY_DEXTERITY", 1),
    ScriptConstant(DataType.INT, "ABILITY_CONSTITUTION", 2),
    ScriptConstant(DataType.INT, "ABILITY_INTELLIGENCE", 3),
    ScriptConstant(DataType.INT, "ABILITY_WISDOM", 4),
    ScriptConstant(DataType.INT, "ABILITY_CHARISMA", 5),
    ScriptConstant(DataType.INT, "SHAPE_SPELLCYLINDER", 0),
    ScriptConstant(DataType.INT, "SHAPE_CONE", 1),
    ScriptConstant(DataType.INT, "SHAPE_CUBE", 2),
    ScriptConstant(DataType.INT, "SHAPE_SPELLCONE", 3),
    ScriptConstant(DataType.INT, "SHAPE_SPHERE", 4),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_CREATURE", 1),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_ITEM", 2),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_TRIGGER", 4),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_DOOR", 8),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_AREA_OF_EFFECT", 16),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_WAYPOINT", 32),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_PLACEABLE", 64),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_STORE", 128),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_ENCOUNTER", 256),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_SOUND", 512),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_ALL", 32767),
    ScriptConstant(DataType.INT, "OBJECT_TYPE_INVALID", 32767),
    ScriptConstant(DataType.INT, "GENDER_MALE", 0),
    ScriptConstant(DataType.INT, "GENDER_FEMALE", 1),
    ScriptConstant(DataType.INT, "GENDER_BOTH", 2),
    ScriptConstant(DataType.INT, "GENDER_OTHER", 3),
    ScriptConstant(DataType.INT, "GENDER_NONE", 4),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_BLUDGEONING", 1),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_PIERCING", 2),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_SLASHING", 4),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_UNIVERSAL", 8),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_ACID", 16),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_COLD", 32),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_LIGHT_SIDE", 64),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_ELECTRICAL", 128),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_FIRE", 256),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_DARK_SIDE", 512),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_SONIC", 1024),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_ION", 2048),
    ScriptConstant(DataType.INT, "DAMAGE_TYPE_BLASTER", 4096),
    ScriptConstant(DataType.INT, "AC_VS_DAMAGE_TYPE_ALL", 8199),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_1", 1),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_2", 2),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_3", 3),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_4", 4),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_5", 5),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_1d4", 6),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_1d6", 7),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_1d8", 8),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_1d10", 9),
    ScriptConstant(DataType.INT, "DAMAGE_BONUS_2d6", 10),
    ScriptConstant(DataType.INT, "DAMAGE_POWER_NORMAL", 0),
    ScriptConstant(DataType.INT, "DAMAGE_POWER_PLUS_ONE", 1),
    ScriptConstant(DataType.INT, "DAMAGE_POWER_PLUS_TWO", 2),
    ScriptConstant(DataType.INT, "DAMAGE_POWER_PLUS_THREE", 3),
    ScriptConstant(DataType.INT, "DAMAGE_POWER_PLUS_FOUR", 4),
    ScriptConstant(DataType.INT, "DAMAGE_POWER_PLUS_FIVE", 5),
    ScriptConstant(DataType.INT, "DAMAGE_POWER_ENERGY", 6),
    ScriptConstant(DataType.INT, "ATTACK_BONUS_MISC", 0),
    ScriptConstant(DataType.INT, "ATTACK_BONUS_ONHAND", 1),
    ScriptConstant(DataType.INT, "ATTACK_BONUS_OFFHAND", 2),
    ScriptConstant(DataType.INT, "AC_DODGE_BONUS", 0),
    ScriptConstant(DataType.INT, "AC_NATURAL_BONUS", 1),
    ScriptConstant(DataType.INT, "AC_ARMOUR_ENCHANTMENT_BONUS", 2),
    ScriptConstant(DataType.INT, "AC_SHIELD_ENCHANTMENT_BONUS", 3),
    ScriptConstant(DataType.INT, "AC_DEFLECTION_BONUS", 4),
    ScriptConstant(DataType.INT, "DOOR_ACTION_OPEN", 0),
    ScriptConstant(DataType.INT, "DOOR_ACTION_UNLOCK", 1),
    ScriptConstant(DataType.INT, "DOOR_ACTION_BASH", 2),
    ScriptConstant(DataType.INT, "DOOR_ACTION_IGNORE", 3),
    ScriptConstant(DataType.INT, "DOOR_ACTION_KNOCK", 4),
    ScriptConstant(DataType.INT, "PLACEABLE_ACTION_USE", 0),
    ScriptConstant(DataType.INT, "PLACEABLE_ACTION_UNLOCK", 1),
    ScriptConstant(DataType.INT, "PLACEABLE_ACTION_BASH", 2),
    ScriptConstant(DataType.INT, "PLACEABLE_ACTION_KNOCK", 4),
    ScriptConstant(DataType.INT, "RACIAL_TYPE_UNKNOWN", 0),
    ScriptConstant(DataType.INT, "RACIAL_TYPE_ELF", 1),
    ScriptConstant(DataType.INT, "RACIAL_TYPE_GNOME", 2),
    ScriptConstant(DataType.INT, "RACIAL_TYPE_HALFLING", 3),
    ScriptConstant(DataType.INT, "RACIAL_TYPE_HALFELF", 4),
    ScriptConstant(DataType.INT, "RACIAL_TYPE_DROID", 5),
    ScriptConstant(DataType.INT, "RACIAL_TYPE_HUMAN", 6),
    ScriptConstant(DataType.INT, "RACIAL_TYPE_ALL", 7),
    ScriptConstant(DataType.INT, "RACIAL_TYPE_INVALID", 8),
    ScriptConstant(DataType.INT, "ALIGNMENT_ALL", 0),
    ScriptConstant(DataType.INT, "ALIGNMENT_NEUTRAL", 1),
    ScriptConstant(DataType.INT, "ALIGNMENT_LIGHT_SIDE", 2),
    ScriptConstant(DataType.INT, "ALIGNMENT_DARK_SIDE", 3),
    ScriptConstant(DataType.INT, "SAVING_THROW_ALL", 0),
    ScriptConstant(DataType.INT, "SAVING_THROW_FORT", 1),
    ScriptConstant(DataType.INT, "SAVING_THROW_REFLEX", 2),
    ScriptConstant(DataType.INT, "SAVING_THROW_WILL", 3),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_ALL", 0),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_NONE", 0),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_ACID", 1),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_SNEAK_ATTACK", 2),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_COLD", 3),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_DEATH", 4),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_DISEASE", 5),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_LIGHT_SIDE", 6),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_ELECTRICAL", 7),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_FEAR", 8),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_FIRE", 9),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_MIND_AFFECTING", 10),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_DARK_SIDE", 11),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_POISON", 12),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_SONIC", 13),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_TRAP", 14),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_FORCE_POWER", 15),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_ION", 16),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_BLASTER", 17),
    ScriptConstant(DataType.INT, "SAVING_THROW_TYPE_PARALYSIS", 18),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_NONE", 0),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_MIND_SPELLS", 1),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_POISON", 2),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_DISEASE", 3),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_FEAR", 4),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_TRAP", 5),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_PARALYSIS", 6),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_BLINDNESS", 7),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_DEAFNESS", 8),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_SLOW", 9),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_ENTANGLE", 10),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_SILENCE", 11),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_STUN", 12),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_SLEEP", 13),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_CHARM", 14),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_DOMINATE", 15),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_CONFUSED", 16),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_CURSED", 17),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_DAZED", 18),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_ABILITY_DECREASE", 19),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_ATTACK_DECREASE", 20),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_DAMAGE_DECREASE", 21),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_DAMAGE_IMMUNITY_DECREASE", 22),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_AC_DECREASE", 23),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_MOVEMENT_SPEED_DECREASE", 24),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_SAVING_THROW_DECREASE", 25),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_FORCE_RESISTANCE_DECREASE", 26),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_SKILL_DECREASE", 27),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_KNOCKDOWN", 28),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_NEGATIVE_LEVEL", 29),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_SNEAK_ATTACK", 30),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_CRITICAL_HIT", 31),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_DEATH", 32),
    ScriptConstant(DataType.INT, "IMMUNITY_TYPE_DROID_CONFUSED", 33),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_RANDOM", 0),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_USER_DEFINED", 1),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CITY_01", 2),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CITY_02", 3),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CITY_03", 4),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CITY_04", 5),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CITY_05", 6),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CRYPT_01", 7),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CRYPT_02", 8),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CRYPT_03", 9),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CRYPT_04", 10),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CRYPT_05", 11),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_DUNGEON_01", 12),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_DUNGEON_02", 13),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_DUNGEON_03", 14),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_DUNGEON_04", 15),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_DUNGEON_05", 16),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_DUNGEON_06", 17),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_DUNGEON_07", 18),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_DUNGEON_08", 19),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_MINES_01", 20),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_MINES_02", 21),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_MINES_03", 22),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_MINES_04", 23),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_MINES_05", 24),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_MINES_06", 25),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_MINES_07", 26),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_MINES_08", 27),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_MINES_09", 28),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_SEWER_01", 29),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_SEWER_02", 30),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_SEWER_03", 31),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_SEWER_04", 32),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_SEWER_05", 33),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CASTLE_01", 34),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CASTLE_02", 35),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CASTLE_03", 36),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CASTLE_04", 37),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CASTLE_05", 38),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CASTLE_06", 39),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CASTLE_07", 40),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CASTLE_08", 41),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_01", 42),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_02", 43),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_03", 44),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_04", 45),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_05", 46),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_06", 47),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_07", 48),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_08", 49),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_09", 50),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_10", 51),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_11", 52),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_12", 53),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_13", 54),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_14", 55),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_15", 56),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_INTERIOR_16", 57),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_FOREST_01", 58),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_FOREST_02", 59),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_FOREST_03", 60),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_FOREST_04", 61),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_FOREST_05", 62),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_RURAL_01", 63),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_RURAL_02", 64),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_RURAL_03", 65),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_RURAL_04", 66),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_RURAL_05", 67),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CITY", 2),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_CRYPT", 7),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_FOREST", 58),
    ScriptConstant(DataType.INT, "AREA_TRANSITION_RURAL", 63),
    ScriptConstant(DataType.INT, "BODY_NODE_HAND", 0),
    ScriptConstant(DataType.INT, "BODY_NODE_CHEST", 1),
    ScriptConstant(DataType.INT, "BODY_NODE_HEAD", 2),
    ScriptConstant(DataType.INT, "BODY_NODE_HAND_LEFT", 3),
    ScriptConstant(DataType.INT, "BODY_NODE_HAND_RIGHT", 4),
    ScriptConstant(DataType.FLOAT, "RADIUS_SIZE_SMALL", 1.67),
    ScriptConstant(DataType.FLOAT, "RADIUS_SIZE_MEDIUM", 3.33),
    ScriptConstant(DataType.FLOAT, "RADIUS_SIZE_LARGE", 5.0),
    ScriptConstant(DataType.FLOAT, "RADIUS_SIZE_HUGE", 6.67),
    ScriptConstant(DataType.FLOAT, "RADIUS_SIZE_GARGANTUAN", 8.33),
    ScriptConstant(DataType.FLOAT, "RADIUS_SIZE_COLOSSAL", 10.0),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_INVALIDEFFECT", 0),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DAMAGE_RESISTANCE", 1),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_REGENERATE", 3),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DAMAGE_REDUCTION", 7),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_TEMPORARY_HITPOINTS", 9),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ENTANGLE", 11),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_INVULNERABLE", 12),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DEAF", 13),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_RESURRECTION", 14),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_IMMUNITY", 15),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ENEMY_ATTACK_BONUS", 17),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ARCANE_SPELL_FAILURE", 18),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_AREA_OF_EFFECT", 20),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_BEAM", 21),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_CHARMED", 23),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_CONFUSED", 24),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_FRIGHTENED", 25),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DOMINATED", 26),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_PARALYZE", 27),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DAZED", 28),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_STUNNED", 29),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SLEEP", 30),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_POISON", 31),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DISEASE", 32),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_CURSE", 33),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SILENCE", 34),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_TURNED", 35),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_HASTE", 36),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SLOW", 37),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ABILITY_INCREASE", 38),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ABILITY_DECREASE", 39),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ATTACK_INCREASE", 40),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ATTACK_DECREASE", 41),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DAMAGE_INCREASE", 42),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DAMAGE_DECREASE", 43),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DAMAGE_IMMUNITY_INCREASE", 44),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DAMAGE_IMMUNITY_DECREASE", 45),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_AC_INCREASE", 46),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_AC_DECREASE", 47),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_MOVEMENT_SPEED_INCREASE", 48),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_MOVEMENT_SPEED_DECREASE", 49),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SAVING_THROW_INCREASE", 50),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SAVING_THROW_DECREASE", 51),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_FORCE_RESISTANCE_INCREASE", 52),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_FORCE_RESISTANCE_DECREASE", 53),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SKILL_INCREASE", 54),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SKILL_DECREASE", 55),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_INVISIBILITY", 56),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_IMPROVEDINVISIBILITY", 57),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DARKNESS", 58),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DISPELMAGICALL", 59),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ELEMENTALSHIELD", 60),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_NEGATIVELEVEL", 61),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DISGUISE", 62),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SANCTUARY", 63),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_TRUESEEING", 64),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SEEINVISIBLE", 65),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_TIMESTOP", 66),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_BLINDNESS", 67),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SPELLLEVELABSORPTION", 68),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DISPELMAGICBEST", 69),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ULTRAVISION", 70),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_MISS_CHANCE", 71),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_CONCEALMENT", 72),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_SPELL_IMMUNITY", 73),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ASSUREDHIT", 74),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_VISUAL", 75),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_LIGHTSABERTHROW", 76),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_FORCEJUMP", 77),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_ASSUREDDEFLECTION", 78),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DROID_CONFUSED", 79),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_MINDTRICK", 80),
    ScriptConstant(DataType.INT, "EFFECT_TYPE_DROIDSCRAMBLE", 81),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ABILITY_BONUS", 0),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_AC_BONUS", 1),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_AC_BONUS_VS_ALIGNMENT_GROUP", 2),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_AC_BONUS_VS_DAMAGE_TYPE", 3),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_AC_BONUS_VS_RACIAL_GROUP", 4),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ENHANCEMENT_BONUS", 5),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ENHANCEMENT_BONUS_VS_ALIGNMENT_GROUP", 6),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ENHANCEMENT_BONUS_VS_RACIAL_GROUP", 7),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ATTACK_PENALTY", 8),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_BONUS_FEAT", 9),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ACTIVATE_ITEM", 10),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DAMAGE_BONUS", 11),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DAMAGE_BONUS_VS_ALIGNMENT_GROUP", 12),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DAMAGE_BONUS_VS_RACIAL_GROUP", 13),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_IMMUNITY_DAMAGE_TYPE", 14),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DECREASED_DAMAGE", 15),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DAMAGE_REDUCTION", 16),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DAMAGE_RESISTANCE", 17),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DAMAGE_VULNERABILITY", 18),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DECREASED_ABILITY_SCORE", 19),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DECREASED_AC", 20),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DECREASED_SKILL_MODIFIER", 21),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_EXTRA_MELEE_DAMAGE_TYPE", 22),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_EXTRA_RANGED_DAMAGE_TYPE", 23),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_IMMUNITY", 24),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_IMPROVED_FORCE_RESISTANCE", 25),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_IMPROVED_SAVING_THROW", 26),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_IMPROVED_SAVING_THROW_SPECIFIC", 27),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_KEEN", 28),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_LIGHT", 29),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_MIGHTY", 30),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_NO_DAMAGE", 31),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ON_HIT_PROPERTIES", 32),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DECREASED_SAVING_THROWS", 33),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DECREASED_SAVING_THROWS_SPECIFIC", 34),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_REGENERATION", 35),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_SKILL_BONUS", 36),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_SECURITY_SPIKE", 37),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ATTACK_BONUS", 38),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ATTACK_BONUS_VS_ALIGNMENT_GROUP", 39),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ATTACK_BONUS_VS_RACIAL_GROUP", 40),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DECREASED_ATTACK_MODIFIER", 41),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_UNLIMITED_AMMUNITION", 42),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_USE_LIMITATION_ALIGNMENT_GROUP", 43),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_USE_LIMITATION_CLASS", 44),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_USE_LIMITATION_RACIAL_TYPE", 45),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_TRAP", 46),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_TRUE_SEEING", 47),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_ON_MONSTER_HIT", 48),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_MASSIVE_CRITICALS", 49),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_FREEDOM_OF_MOVEMENT", 50),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_MONSTER_DAMAGE", 51),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_SPECIAL_WALK", 52),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_COMPUTER_SPIKE", 53),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_REGENERATION_FORCE_POINTS", 54),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_BLASTER_BOLT_DEFLECT_INCREASE", 55),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_BLASTER_BOLT_DEFLECT_DECREASE", 56),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_USE_LIMITATION_FEAT", 57),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DROID_REPAIR_KIT", 58),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DISGUISE", 59),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_LIMIT_USE_BY_GENDER", 60),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_LIMIT_USE_BY_SUBRACE", 61),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_LIMIT_USE_BY_PC", 62),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DAMPEN_SOUND", 63),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DOORCUTTING", 64),
    ScriptConstant(DataType.INT, "ITEM_PROPERTY_DOORSABERING", 65),
    ScriptConstant(DataType.INT, "BASE_ITEM_QUARTER_STAFF", 0),
    ScriptConstant(DataType.INT, "BASE_ITEM_STUN_BATON", 1),
    ScriptConstant(DataType.INT, "BASE_ITEM_LONG_SWORD", 2),
    ScriptConstant(DataType.INT, "BASE_ITEM_VIBRO_SWORD", 3),
    ScriptConstant(DataType.INT, "BASE_ITEM_SHORT_SWORD", 4),
    ScriptConstant(DataType.INT, "BASE_ITEM_VIBRO_BLADE", 5),
    ScriptConstant(DataType.INT, "BASE_ITEM_DOUBLE_BLADED_SWORD", 6),
    ScriptConstant(DataType.INT, "BASE_ITEM_VIBRO_DOUBLE_BLADE", 7),
    ScriptConstant(DataType.INT, "BASE_ITEM_LIGHTSABER", 8),
    ScriptConstant(DataType.INT, "BASE_ITEM_DOUBLE_BLADED_LIGHTSABER", 9),
    ScriptConstant(DataType.INT, "BASE_ITEM_SHORT_LIGHTSABER", 10),
    ScriptConstant(DataType.INT, "BASE_ITEM_LIGHTSABER_CRYSTALS", 11),
    ScriptConstant(DataType.INT, "BASE_ITEM_BLASTER_PISTOL", 12),
    ScriptConstant(DataType.INT, "BASE_ITEM_HEAVY_BLASTER", 13),
    ScriptConstant(DataType.INT, "BASE_ITEM_HOLD_OUT_BLASTER", 14),
    ScriptConstant(DataType.INT, "BASE_ITEM_ION_BLASTER", 15),
    ScriptConstant(DataType.INT, "BASE_ITEM_DISRUPTER_PISTOL", 16),
    ScriptConstant(DataType.INT, "BASE_ITEM_SONIC_PISTOL", 17),
    ScriptConstant(DataType.INT, "BASE_ITEM_ION_RIFLE", 18),
    ScriptConstant(DataType.INT, "BASE_ITEM_BOWCASTER", 19),
    ScriptConstant(DataType.INT, "BASE_ITEM_BLASTER_CARBINE", 20),
    ScriptConstant(DataType.INT, "BASE_ITEM_DISRUPTER_RIFLE", 21),
    ScriptConstant(DataType.INT, "BASE_ITEM_SONIC_RIFLE", 22),
    ScriptConstant(DataType.INT, "BASE_ITEM_REPEATING_BLASTER", 23),
    ScriptConstant(DataType.INT, "BASE_ITEM_HEAVY_REPEATING_BLASTER", 24),
    ScriptConstant(DataType.INT, "BASE_ITEM_FRAGMENTATION_GRENADES", 25),
    ScriptConstant(DataType.INT, "BASE_ITEM_STUN_GRENADES", 26),
    ScriptConstant(DataType.INT, "BASE_ITEM_THERMAL_DETONATOR", 27),
    ScriptConstant(DataType.INT, "BASE_ITEM_POISON_GRENADE", 28),
    ScriptConstant(DataType.INT, "BASE_ITEM_FLASH_GRENADE", 29),
    ScriptConstant(DataType.INT, "BASE_ITEM_SONIC_GRENADE", 30),
    ScriptConstant(DataType.INT, "BASE_ITEM_ADHESIVE_GRENADE", 31),
    ScriptConstant(DataType.INT, "BASE_ITEM_CRYOBAN_GRENADE", 32),
    ScriptConstant(DataType.INT, "BASE_ITEM_FIRE_GRENADE", 33),
    ScriptConstant(DataType.INT, "BASE_ITEM_ION_GRENADE", 34),
    ScriptConstant(DataType.INT, "BASE_ITEM_JEDI_ROBE", 35),
    ScriptConstant(DataType.INT, "BASE_ITEM_JEDI_KNIGHT_ROBE", 36),
    ScriptConstant(DataType.INT, "BASE_ITEM_JEDI_MASTER_ROBE", 37),
    ScriptConstant(DataType.INT, "BASE_ITEM_ARMOR_CLASS_4", 38),
    ScriptConstant(DataType.INT, "BASE_ITEM_ARMOR_CLASS_5", 39),
    ScriptConstant(DataType.INT, "BASE_ITEM_ARMOR_CLASS_6", 40),
    ScriptConstant(DataType.INT, "BASE_ITEM_ARMOR_CLASS_7", 41),
    ScriptConstant(DataType.INT, "BASE_ITEM_ARMOR_CLASS_8", 42),
    ScriptConstant(DataType.INT, "BASE_ITEM_ARMOR_CLASS_9", 43),
    ScriptConstant(DataType.INT, "BASE_ITEM_MASK", 44),
    ScriptConstant(DataType.INT, "BASE_ITEM_GAUNTLETS", 45),
    ScriptConstant(DataType.INT, "BASE_ITEM_FOREARM_BANDS", 46),
    ScriptConstant(DataType.INT, "BASE_ITEM_BELT", 47),
    ScriptConstant(DataType.INT, "BASE_ITEM_IMPLANT_1", 48),
    ScriptConstant(DataType.INT, "BASE_ITEM_IMPLANT_2", 49),
    ScriptConstant(DataType.INT, "BASE_ITEM_IMPLANT_3", 50),
    ScriptConstant(DataType.INT, "BASE_ITEM_DATA_PAD", 52),
    ScriptConstant(DataType.INT, "BASE_ITEM_ADRENALINE", 53),
    ScriptConstant(DataType.INT, "BASE_ITEM_COMBAT_SHOTS", 54),
    ScriptConstant(DataType.INT, "BASE_ITEM_MEDICAL_EQUIPMENT", 55),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_REPAIR_EQUIPMENT", 56),
    ScriptConstant(DataType.INT, "BASE_ITEM_CREDITS", 57),
    ScriptConstant(DataType.INT, "BASE_ITEM_TRAP_KIT", 58),
    ScriptConstant(DataType.INT, "BASE_ITEM_SECURITY_SPIKES", 59),
    ScriptConstant(DataType.INT, "BASE_ITEM_PROGRAMMING_SPIKES", 60),
    ScriptConstant(DataType.INT, "BASE_ITEM_GLOW_ROD", 61),
    ScriptConstant(DataType.INT, "BASE_ITEM_COLLAR_LIGHT", 62),
    ScriptConstant(DataType.INT, "BASE_ITEM_TORCH", 63),
    ScriptConstant(DataType.INT, "BASE_ITEM_PLOT_USEABLE_ITEMS", 64),
    ScriptConstant(DataType.INT, "BASE_ITEM_AESTHETIC_ITEM", 65),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_LIGHT_PLATING", 66),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_MEDIUM_PLATING", 67),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_HEAVY_PLATING", 68),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_SEARCH_SCOPE", 69),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_MOTION_SENSORS", 70),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_SONIC_SENSORS", 71),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_TARGETING_COMPUTERS", 72),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_COMPUTER_SPIKE_MOUNT", 73),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_SECURITY_SPIKE_MOUNT", 74),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_SHIELD", 75),
    ScriptConstant(DataType.INT, "BASE_ITEM_DROID_UTILITY_DEVICE", 76),
    ScriptConstant(DataType.INT, "BASE_ITEM_BLASTER_RIFLE", 77),
    ScriptConstant(DataType.INT, "BASE_ITEM_GHAFFI_STICK", 78),
    ScriptConstant(DataType.INT, "BASE_ITEM_WOOKIE_WARBLADE", 79),
    ScriptConstant(DataType.INT, "BASE_ITEM_GAMMOREAN_BATTLEAXE", 80),
    ScriptConstant(DataType.INT, "BASE_ITEM_CREATURE_ITEM_SLASH", 81),
    ScriptConstant(DataType.INT, "BASE_ITEM_CREATURE_ITEM_PIERCE", 82),
    ScriptConstant(DataType.INT, "BASE_ITEM_CREATURE_WEAPON_SL_PRC", 83),
    ScriptConstant(DataType.INT, "BASE_ITEM_CREATURE_HIDE_ITEM", 84),
    ScriptConstant(DataType.INT, "BASE_ITEM_BASIC_CLOTHING", 85),
    ScriptConstant(DataType.INT, "BASE_ITEM_WRIST_LAUNCHER", 91),
    ScriptConstant(DataType.INT, "BASE_ITEM_FORCE_PIKE", 93),
    ScriptConstant(DataType.INT, "BASE_ITEM_INVALID", 256),
    ScriptConstant(DataType.INT, "ATTACK_RESULT_INVALID", 0),
    ScriptConstant(DataType.INT, "ATTACK_RESULT_HIT_SUCCESSFUL", 1),
    ScriptConstant(DataType.INT, "ATTACK_RESULT_CRITICAL_HIT", 2),
    ScriptConstant(DataType.INT, "ATTACK_RESULT_AUTOMATIC_HIT", 3),
    ScriptConstant(DataType.INT, "ATTACK_RESULT_MISS", 4),
    ScriptConstant(DataType.INT, "ATTACK_RESULT_ATTACK_RESISTED", 5),
    ScriptConstant(DataType.INT, "ATTACK_RESULT_ATTACK_FAILED", 6),
    ScriptConstant(DataType.INT, "ATTACK_RESULT_PARRIED", 8),
    ScriptConstant(DataType.INT, "ATTACK_RESULT_DEFLECTED", 9),
    ScriptConstant(DataType.INT, "VFX_NONE", -1),
    ScriptConstant(DataType.INT, "VFX_IMP_HEALING_SMALL", 1001),
    ScriptConstant(DataType.INT, "VFX_IMP_FORCE_JUMP_ADVANCED", 1002),
    ScriptConstant(DataType.INT, "VFX_PRO_AFFLICT", 1003),
    ScriptConstant(DataType.INT, "VFX_IMP_CHOKE", 1004),
    ScriptConstant(DataType.INT, "VFX_IMP_CURE", 1005),
    ScriptConstant(DataType.INT, "VFX_PRO_DEATH_FIELD", 1006),
    ScriptConstant(DataType.INT, "VFX_PRO_DROID_DISABLE", 1007),
    ScriptConstant(DataType.INT, "VFX_PRO_DROID_KILL", 1008),
    ScriptConstant(DataType.INT, "VFX_PRO_DRAIN", 1009),
    ScriptConstant(DataType.INT, "VFX_PRO_FORCE_ARMOR", 1010),
    ScriptConstant(DataType.INT, "VFX_PRO_FORCE_AURA", 1011),
    ScriptConstant(DataType.INT, "VFX_IMP_FORCE_BREACH", 1012),
    ScriptConstant(DataType.INT, "VFX_IMP_FORCE_PUSH", 1014),
    ScriptConstant(DataType.INT, "VFX_PRO_FORCE_SHIELD", 1015),
    ScriptConstant(DataType.INT, "VFX_IMP_FORCE_WAVE", 1017),
    ScriptConstant(DataType.INT, "VFX_IMP_FORCE_WHIRLWIND", 1018),
    ScriptConstant(DataType.INT, "VFX_IMP_HEAL", 1019),
    ScriptConstant(DataType.INT, "VFX_IMP_SPEED_KNIGHT", 1020),
    ScriptConstant(DataType.INT, "VFX_PRO_LIGHTNING_L", 1021),
    ScriptConstant(DataType.INT, "VFX_IMP_SPEED_MASTERY", 1022),
    ScriptConstant(DataType.INT, "VFX_PRO_RESIST_ELEMENTS", 1025),
    ScriptConstant(DataType.INT, "VFX_PRO_RESIST_FORCE", 1026),
    ScriptConstant(DataType.INT, "VFX_PRO_RESIST_POISON", 1027),
    ScriptConstant(DataType.INT, "VFX_PRO_LIGHTNING_S", 1028),
    ScriptConstant(DataType.INT, "VFX_IMP_MIND_FORCE", 1031),
    ScriptConstant(DataType.INT, "VFX_IMP_SUPPRESS_FORCE", 1032),
    ScriptConstant(DataType.INT, "VFX_IMP_MIND_KINIGHT", 1033),
    ScriptConstant(DataType.INT, "VFX_IMP_MIND_MASTERY", 1034),
    ScriptConstant(DataType.INT, "VFX_PRO_LIGHTNING_JEDI", 1035),
    ScriptConstant(DataType.INT, "VFX_PRO_LIGHTNING_L_SOUND", 1036),
    ScriptConstant(DataType.INT, "VFX_IMP_GRENADE_ADHESIVE_PERSONAL", 1038),
    ScriptConstant(DataType.INT, "VFX_IMP_FLAME", 1039),
    ScriptConstant(DataType.INT, "VFX_IMP_STUN", 1040),
    ScriptConstant(DataType.INT, "VFX_DUR_STEALTH_PULSE", 2000),
    ScriptConstant(DataType.INT, "VFX_DUR_INVISIBILITY", 2001),
    ScriptConstant(DataType.INT, "VFX_DUR_SPEED", 2004),
    ScriptConstant(DataType.INT, "VFX_DUR_FORCE_WHIRLWIND", 2007),
    ScriptConstant(DataType.INT, "VFX_DUR_HOLD", 2008),
    ScriptConstant(DataType.INT, "VFX_DUR_BODY_FUAL", 2024),
    ScriptConstant(DataType.INT, "VFX_DUR_PSYCHIC_STATIC", 2025),
    ScriptConstant(DataType.INT, "VFX_BEAM_DEATH_FIELD_TENTACLE", 2026),
    ScriptConstant(DataType.INT, "VFX_BEAM_DROID_DISABLE", 2027),
    ScriptConstant(DataType.INT, "VFX_BEAM_DROID_DESTROY", 2028),
    ScriptConstant(DataType.INT, "VFX_BEAM_DRAIN_LIFE", 2029),
    ScriptConstant(DataType.INT, "VFX_DUR_KNIGHTS_SPEED", 2031),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_RED_MARK_I", 2032),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_RED_MARK_II", 2034),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_RED_MARK_IV", 2035),
    ScriptConstant(DataType.INT, "VFX_BEAM_LIGHTNING_DARK_S", 2037),
    ScriptConstant(DataType.INT, "VFX_BEAM_LIGHTNING_DARK_L", 2038),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_BLUE_01", 2040),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_BLUE_02", 2041),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_BLUE_03", 2042),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_BLUE_04", 2043),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_GREEN_01", 2044),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_RED_01", 2045),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_RED_02", 2046),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_CHROME_01", 2047),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_CHROME_02", 2048),
    ScriptConstant(DataType.INT, "VFX_BEAM_ION_RAY_01", 2049),
    ScriptConstant(DataType.INT, "VFX_BEAM_ION_RAY_02", 2050),
    ScriptConstant(DataType.INT, "VFX_BEAM_COLD_RAY", 2051),
    ScriptConstant(DataType.INT, "VFX_BEAM_STUN_RAY", 2052),
    ScriptConstant(DataType.INT, "VFX_BEAM_FLAME_SPRAY", 2053),
    ScriptConstant(DataType.INT, "VFX_DUR_CARBONITE_ENCASING", 2054),
    ScriptConstant(DataType.INT, "VFX_DUR_CARBONITE_CHUNKS", 2055),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_BLUE_MARK_I", 2056),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_BLUE_MARK_II", 2058),
    ScriptConstant(DataType.INT, "VFX_DUR_SHIELD_BLUE_MARK_IV", 2059),
    ScriptConstant(DataType.INT, "VFX_DUR_ELECTRICAL_SPARK", 2067),
    ScriptConstant(DataType.INT, "VFX_FNF_FORCE_WAVE", 3001),
    ScriptConstant(DataType.INT, "VFX_FNF_PLOT_MAN_SONIC_WAVE", 3002),
    ScriptConstant(DataType.INT, "VFX_FNF_GRENADE_FRAGMENTATION", 3003),
    ScriptConstant(DataType.INT, "VFX_FNF_GRENADE_STUN", 3004),
    ScriptConstant(DataType.INT, "VFX_FNF_GRENADE_THERMAL_DETONATOR", 3005),
    ScriptConstant(DataType.INT, "VFX_FNF_GRENADE_POISON", 3006),
    ScriptConstant(DataType.INT, "VFX_FNF_GRENADE_SONIC", 3007),
    ScriptConstant(DataType.INT, "VFX_FNF_GRENADE_ADHESIVE", 3008),
    ScriptConstant(DataType.INT, "VFX_FNF_GRENADE_CRYOBAN", 3009),
    ScriptConstant(DataType.INT, "VFX_FNF_GRENADE_PLASMA", 3010),
    ScriptConstant(DataType.INT, "VFX_FNF_GRENADE_ION", 3011),
    ScriptConstant(DataType.INT, "VFX_FNF_GRAVITY_GENERATOR", 3013),
    ScriptConstant(DataType.INT, "VFX_COM_SPARKS_LARGE", 4003),
    ScriptConstant(DataType.INT, "VFX_COM_SPARKS_LIGHTSABER", 4004),
    ScriptConstant(DataType.INT, "VFX_COM_SPARKS_PARRY_METAL", 4011),
    ScriptConstant(DataType.INT, "VFX_COM_POWER_ATTACK_IMPROVED_STAFF", 4012),
    ScriptConstant(DataType.INT, "VFX_COM_POWER_BLAST_IMPROVED", 4013),
    ScriptConstant(DataType.INT, "VFX_COM_CRITICAL_STRIKE_IMPROVED_STAFF", 4014),
    ScriptConstant(DataType.INT, "VFX_COM_SNIPER_SHOT_IMPROVED", 4015),
    ScriptConstant(DataType.INT, "VFX_COM_MULTI_SHOT", 4016),
    ScriptConstant(DataType.INT, "VFX_COM_WHIRLWIND_STRIKE_STAFF", 4017),
    ScriptConstant(DataType.INT, "VFX_COM_CRITICAL_STRIKE_MASTERY_STAFF", 4018),
    ScriptConstant(DataType.INT, "VFX_COM_POWER_ATTACK_MASTERY_STAFF", 4019),
    ScriptConstant(DataType.INT, "VFX_COM_SNIPER_SHOT_MASTERY", 4020),
    ScriptConstant(DataType.INT, "VFX_COM_FLURRY_IMPROVED_STAFF", 4021),
    ScriptConstant(DataType.INT, "VFX_COM_RAPID_SHOT_IMPROVED", 4022),
    ScriptConstant(DataType.INT, "VFX_COM_BLASTER_DEFLECTION", 4023),
    ScriptConstant(DataType.INT, "VFX_COM_BLASTER_IMPACT", 4024),
    ScriptConstant(DataType.INT, "VFX_COM_CRITICAL_STRIKE_IMPROVED_SABER", 4025),
    ScriptConstant(DataType.INT, "VFX_COM_CRITICAL_STRIKE_MASTERY_SABER", 4026),
    ScriptConstant(DataType.INT, "VFX_COM_POWER_ATTACK_IMPROVED_SABER", 4027),
    ScriptConstant(DataType.INT, "VFX_COM_POWER_ATTACK_MASTERY_SABER", 4028),
    ScriptConstant(DataType.INT, "VFX_COM_POWER_BLAST_MASTERY", 4029),
    ScriptConstant(DataType.INT, "VFX_COM_FLURRY_IMPROVED_SABER", 4030),
    ScriptConstant(DataType.INT, "VFX_COM_WHIRLWIND_STRIKE_SABER", 4031),
    ScriptConstant(DataType.INT, "VFX_COM_BLASTER_IMPACT_GROUND", 4032),
    ScriptConstant(DataType.INT, "VFX_COM_SPARKS_BLASTER", 4033),
    ScriptConstant(DataType.INT, "VFX_COM_DROID_EXPLOSION_1", 4034),
    ScriptConstant(DataType.INT, "VFX_COM_DROID_EXPLOSION_2", 4035),
    ScriptConstant(DataType.INT, "VFX_COM_JEDI_FORCE_FIZZLE", 4036),
    ScriptConstant(DataType.INT, "VFX_COM_FORCE_RESISTED", 4037),
    ScriptConstant(DataType.INT, "VFX_ARD_LIGHT_YELLOW_10", 5000),
    ScriptConstant(DataType.INT, "VFX_ARD_LIGHT_YELLOW_20", 5001),
    ScriptConstant(DataType.INT, "VFX_ARD_LIGHT_BLIND", 5002),
    ScriptConstant(DataType.INT, "VFX_ARD_HEAT_SHIMMER", 5003),
    ScriptConstant(DataType.INT, "VFX_IMP_MIRV", 6000),
    ScriptConstant(DataType.INT, "VFX_IMP_MIRV_IMPACT", 6001),
    ScriptConstant(DataType.INT, "VFX_IMP_SCREEN_SHAKE", 6002),
    ScriptConstant(DataType.INT, "VFX_DUR_HOLO_PROJECT", 9010),
    ScriptConstant(DataType.INT, "AOE_PER_FOGACID", 0),
    ScriptConstant(DataType.INT, "AOE_PER_FOGFIRE", 1),
    ScriptConstant(DataType.INT, "AOE_PER_FOGSTINK", 2),
    ScriptConstant(DataType.INT, "AOE_PER_FOGKILL", 3),
    ScriptConstant(DataType.INT, "AOE_PER_FOGMIND", 4),
    ScriptConstant(DataType.INT, "AOE_PER_WALLFIRE", 5),
    ScriptConstant(DataType.INT, "AOE_PER_WALLWIND", 6),
    ScriptConstant(DataType.INT, "AOE_PER_WALLBLADE", 7),
    ScriptConstant(DataType.INT, "AOE_PER_WEB", 8),
    ScriptConstant(DataType.INT, "AOE_PER_ENTANGLE", 9),
    ScriptConstant(DataType.INT, "AOE_PER_DARKNESS", 11),
    ScriptConstant(DataType.INT, "AOE_MOB_CIRCEVIL", 12),
    ScriptConstant(DataType.INT, "AOE_MOB_CIRCGOOD", 13),
    ScriptConstant(DataType.INT, "AOE_MOB_CIRCLAW", 14),
    ScriptConstant(DataType.INT, "AOE_MOB_CIRCCHAOS", 15),
    ScriptConstant(DataType.INT, "AOE_MOB_FEAR", 16),
    ScriptConstant(DataType.INT, "AOE_MOB_BLINDING", 17),
    ScriptConstant(DataType.INT, "AOE_MOB_UNEARTHLY", 18),
    ScriptConstant(DataType.INT, "AOE_MOB_MENACE", 19),
    ScriptConstant(DataType.INT, "AOE_MOB_UNNATURAL", 20),
    ScriptConstant(DataType.INT, "AOE_MOB_STUN", 21),
    ScriptConstant(DataType.INT, "AOE_MOB_PROTECTION", 22),
    ScriptConstant(DataType.INT, "AOE_MOB_FIRE", 23),
    ScriptConstant(DataType.INT, "AOE_MOB_FROST", 24),
    ScriptConstant(DataType.INT, "AOE_MOB_ELECTRICAL", 25),
    ScriptConstant(DataType.INT, "AOE_PER_FOGGHOUL", 26),
    ScriptConstant(DataType.INT, "AOE_MOB_TYRANT_FOG", 27),
    ScriptConstant(DataType.INT, "AOE_PER_STORM", 28),
    ScriptConstant(DataType.INT, "AOE_PER_INVIS_SPHERE", 29),
    ScriptConstant(DataType.INT, "AOE_MOB_SILENCE", 30),
    ScriptConstant(DataType.INT, "AOE_PER_DELAY_BLAST_FIREBALL", 31),
    ScriptConstant(DataType.INT, "AOE_PER_GREASE", 32),
    ScriptConstant(DataType.INT, "AOE_PER_CREEPING_DOOM", 33),
    ScriptConstant(DataType.INT, "AOE_PER_EVARDS_BLACK_TENTACLES", 34),
    ScriptConstant(DataType.INT, "AOE_MOB_INVISIBILITY_PURGE", 35),
    ScriptConstant(DataType.INT, "AOE_MOB_DRAGON_FEAR", 36),
    ScriptConstant(DataType.INT, "FORM_MASK_FORCE_FOCUS", 1),
    ScriptConstant(DataType.INT, "FORM_MASK_ENDURING_FORCE", 2),
    ScriptConstant(DataType.INT, "FORM_MASK_FORCE_AMPLIFICATION", 4),
    ScriptConstant(DataType.INT, "FORM_MASK_FORCE_POTENCY", 8),
    ScriptConstant(DataType.INT, "FORM_MASK_REGENERATION", 16),
    ScriptConstant(DataType.INT, "FORM_MASK_POWER_OF_THE_DARK_SIDE", 32),
    ScriptConstant(DataType.INT, "FORCE_POWER_ALL_FORCE_POWERS", -1),
    ScriptConstant(DataType.INT, "FORCE_POWER_MASTER_ALTER", 0),
    ScriptConstant(DataType.INT, "FORCE_POWER_MASTER_CONTROL", 1),
    ScriptConstant(DataType.INT, "FORCE_POWER_MASTER_SENSE", 2),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_JUMP_ADVANCED", 3),
    ScriptConstant(DataType.INT, "FORCE_POWER_LIGHT_SABER_THROW_ADVANCED", 4),
    ScriptConstant(DataType.INT, "FORCE_POWER_REGNERATION_ADVANCED", 5),
    ScriptConstant(DataType.INT, "FORCE_POWER_AFFECT_MIND", 6),
    ScriptConstant(DataType.INT, "FORCE_POWER_AFFLICTION", 7),
    ScriptConstant(DataType.INT, "FORCE_POWER_SPEED_BURST", 8),
    ScriptConstant(DataType.INT, "FORCE_POWER_CHOKE", 9),
    ScriptConstant(DataType.INT, "FORCE_POWER_CURE", 10),
    ScriptConstant(DataType.INT, "FORCE_POWER_DEATH_FIELD", 11),
    ScriptConstant(DataType.INT, "FORCE_POWER_DROID_DISABLE", 12),
    ScriptConstant(DataType.INT, "FORCE_POWER_DROID_DESTROY", 13),
    ScriptConstant(DataType.INT, "FORCE_POWER_DOMINATE", 14),
    ScriptConstant(DataType.INT, "FORCE_POWER_DRAIN_LIFE", 15),
    ScriptConstant(DataType.INT, "FORCE_POWER_FEAR", 16),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_ARMOR", 17),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_AURA", 18),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_BREACH", 19),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_IMMUNITY", 20),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_JUMP", 21),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_MIND", 22),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_PUSH", 23),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_SHIELD", 24),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_STORM", 25),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_WAVE", 26),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_WHIRLWIND", 27),
    ScriptConstant(DataType.INT, "FORCE_POWER_HEAL", 28),
    ScriptConstant(DataType.INT, "FORCE_POWER_HOLD", 29),
    ScriptConstant(DataType.INT, "FORCE_POWER_HORROR", 30),
    ScriptConstant(DataType.INT, "FORCE_POWER_INSANITY", 31),
    ScriptConstant(DataType.INT, "FORCE_POWER_KILL", 32),
    ScriptConstant(DataType.INT, "FORCE_POWER_KNIGHT_MIND", 33),
    ScriptConstant(DataType.INT, "FORCE_POWER_KNIGHT_SPEED", 34),
    ScriptConstant(DataType.INT, "FORCE_POWER_LIGHTNING", 35),
    ScriptConstant(DataType.INT, "FORCE_POWER_MIND_MASTERY", 36),
    ScriptConstant(DataType.INT, "FORCE_POWER_SPEED_MASTERY", 37),
    ScriptConstant(DataType.INT, "FORCE_POWER_PLAGUE", 38),
    ScriptConstant(DataType.INT, "FORCE_POWER_REGENERATION", 39),
    ScriptConstant(DataType.INT, "FORCE_POWER_RESIST_COLD_HEAT_ENERGY", 40),
    ScriptConstant(DataType.INT, "FORCE_POWER_RESIST_FORCE", 41),
    ScriptConstant(DataType.INT, "FORCE_POWER_RESIST_POISON_DISEASE_SONIC", 42),
    ScriptConstant(DataType.INT, "FORCE_POWER_SHOCK", 43),
    ScriptConstant(DataType.INT, "FORCE_POWER_SLEEP", 44),
    ScriptConstant(DataType.INT, "FORCE_POWER_SLOW", 45),
    ScriptConstant(DataType.INT, "FORCE_POWER_STUN", 46),
    ScriptConstant(DataType.INT, "FORCE_POWER_DROID_STUN", 47),
    ScriptConstant(DataType.INT, "FORCE_POWER_SUPRESS_FORCE", 48),
    ScriptConstant(DataType.INT, "FORCE_POWER_LIGHT_SABER_THROW", 49),
    ScriptConstant(DataType.INT, "FORCE_POWER_WOUND", 50),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_BATTLE_MEDITATION", 51),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_BODY_FUEL", 52),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_COMBAT_REGENERATION", 53),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_WARRIOR_STANCE", 54),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_SENTINEL_STANCE", 55),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_DOMINATE_MIND", 56),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_PSYCHIC_STANCE", 57),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_CATHAR_REFLEXES", 58),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_ENHANCED_SENSES", 59),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_CAMOFLAGE", 60),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_TAUNT", 61),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_WHIRLING_DERVISH", 62),
    ScriptConstant(DataType.INT, "SPECIAL_ABILITY_RAGE", 63),
    ScriptConstant(DataType.INT, "FORCE_POWER_MASTER_ENERGY_RESISTANCE", 133),
    ScriptConstant(DataType.INT, "FORCE_POWER_MASTER_HEAL", 134),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_BARRIER", 135),
    ScriptConstant(DataType.INT, "FORCE_POWER_IMPROVED_FORCE_BARRIER", 136),
    ScriptConstant(DataType.INT, "FORCE_POWER_MASTER_FORCE_BARRIER", 137),
    ScriptConstant(DataType.INT, "FORCE_POWER_BATTLE_MEDITATION_PC", 138),
    ScriptConstant(DataType.INT, "FORCE_POWER_IMPROVED_BATTLE_MEDITATION_PC", 139),
    ScriptConstant(DataType.INT, "FORCE_POWER_MASTER_BATTLE_MEDITATION_PC", 140),
    ScriptConstant(DataType.INT, "FORCE_POWER_BAT_MED_ENEMY", 141),
    ScriptConstant(DataType.INT, "FORCE_POWER_IMP_BAT_MED_ENEMY", 142),
    ScriptConstant(DataType.INT, "FORCE_POWER_MAS_BAT_MED_ENEMY", 143),
    ScriptConstant(DataType.INT, "FORCE_POWER_CRUSH_OPPOSITION_I", 144),
    ScriptConstant(DataType.INT, "FORCE_POWER_CRUSH_OPPOSITION_II", 145),
    ScriptConstant(DataType.INT, "FORCE_POWER_CRUSH_OPPOSITION_III", 146),
    ScriptConstant(DataType.INT, "FORCE_POWER_CRUSH_OPPOSITION_IV", 147),
    ScriptConstant(DataType.INT, "FORCE_POWER_CRUSH_OPPOSITION_V", 148),
    ScriptConstant(DataType.INT, "FORCE_POWER_CRUSH_OPPOSITION_VI", 149),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_BODY", 150),
    ScriptConstant(DataType.INT, "FORCE_POWER_IMPROVED_FORCE_BODY", 151),
    ScriptConstant(DataType.INT, "FORCE_POWER_MASTER_FORCE_BODY", 152),
    ScriptConstant(DataType.INT, "FORCE_POWER_DRAIN_FORCE", 153),
    ScriptConstant(DataType.INT, "FORCE_POWER_IMPROVED_DRAIN_FORCE", 154),
    ScriptConstant(DataType.INT, "FORCE_POWER_MASTER_DRAIN_FORCE", 155),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_CAMOUFLAGE", 156),
    ScriptConstant(DataType.INT, "FORCE_POWER_IMPROVED_FORCE_CAMOUFLAGE", 157),
    ScriptConstant(DataType.INT, "FORCE_POWER_MASTER_FORCE_CAMOUFLAGE", 158),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_SCREAM", 159),
    ScriptConstant(DataType.INT, "FORCE_POWER_IMPROVED_FORCE_SCREAM", 160),
    ScriptConstant(DataType.INT, "FORCE_POWER_MASTER_FORCE_SCREAM", 161),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_REPULSION", 162),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_REDIRECTION", 163),
    ScriptConstant(DataType.INT, "FORCE_POWER_FURY", 164),
    ScriptConstant(DataType.INT, "FORCE_POWER_IMPROVED_FURY", 165),
    ScriptConstant(DataType.INT, "FORCE_POWER_MASTER_FURY", 166),
    ScriptConstant(DataType.INT, "FORCE_POWER_INSPIRE_FOLLOWERS_I", 167),
    ScriptConstant(DataType.INT, "FORCE_POWER_INSPIRE_FOLLOWERS_II", 168),
    ScriptConstant(DataType.INT, "FORCE_POWER_INSPIRE_FOLLOWERS_III", 169),
    ScriptConstant(DataType.INT, "FORCE_POWER_INSPIRE_FOLLOWERS_IV", 170),
    ScriptConstant(DataType.INT, "FORCE_POWER_INSPIRE_FOLLOWERS_V", 171),
    ScriptConstant(DataType.INT, "FORCE_POWER_INSPIRE_FOLLOWERS_VI", 172),
    ScriptConstant(DataType.INT, "FORCE_POWER_REVITALIZE", 173),
    ScriptConstant(DataType.INT, "FORCE_POWER_IMPROVED_REVITALIZE", 174),
    ScriptConstant(DataType.INT, "FORCE_POWER_MASTER_REVITALIZE", 175),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_SIGHT", 176),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_CRUSH", 177),
    ScriptConstant(DataType.INT, "FORCE_POWER_PRECOGNITION", 178),
    ScriptConstant(DataType.INT, "FORCE_POWER_BATTLE_PRECOGNITION", 179),
    ScriptConstant(DataType.INT, "FORCE_POWER_FORCE_ENLIGHTENMENT", 180),
    ScriptConstant(DataType.INT, "FORCE_POWER_MIND_TRICK", 181),
    ScriptConstant(DataType.INT, "FORCE_POWER_CONFUSION", 200),
    ScriptConstant(DataType.INT, "FORCE_POWER_BEAST_TRICK", 182),
    ScriptConstant(DataType.INT, "FORCE_POWER_BEAST_CONFUSION", 184),
    ScriptConstant(DataType.INT, "FORCE_POWER_DROID_TRICK", 201),
    ScriptConstant(DataType.INT, "FORCE_POWER_DROID_CONFUSION", 269),
    ScriptConstant(DataType.INT, "FORCE_POWER_BREATH_CONTROL", 270),
    ScriptConstant(DataType.INT, "FORCE_POWER_WOOKIEE_RAGE_I", 271),
    ScriptConstant(DataType.INT, "FORCE_POWER_WOOKIEE_RAGE_II", 272),
    ScriptConstant(DataType.INT, "FORCE_POWER_WOOKIEE_RAGE_III", 273),
    ScriptConstant(DataType.INT, "FORM_LIGHTSABER_PADAWAN_I", 205),
    ScriptConstant(DataType.INT, "FORM_LIGHTSABER_PADAWAN_II", 206),
    ScriptConstant(DataType.INT, "FORM_LIGHTSABER_PADAWAN_III", 207),
    ScriptConstant(DataType.INT, "FORM_LIGHTSABER_DAKLEAN_I", 208),
    ScriptConstant(DataType.INT, "FORM_LIGHTSABER_DAKLEAN_II", 209),
    ScriptConstant(DataType.INT, "FORM_LIGHTSABER_DAKLEAN_III", 210),
    ScriptConstant(DataType.INT, "FORM_LIGHTSABER_SENTINEL_I", 211),
    ScriptConstant(DataType.INT, "FORM_LIGHTSABER_SENTINEL_II", 212),
    ScriptConstant(DataType.INT, "FORM_LIGHTSABER_SENTINEL_III", 213),
    ScriptConstant(DataType.INT, "FORM_LIGHTSABER_SODAK_I", 214),
    ScriptConstant(DataType.INT, "FORM_LIGHTSABER_SODAK_II", 215),
    ScriptConstant(DataType.INT, "FORM_LIGHTSABER_SODAK_III", 216),
    ScriptConstant(DataType.INT, "FORM_LIGHTSABER_ANCIENT_I", 217),
    ScriptConstant(DataType.INT, "FORM_LIGHTSABER_ANCIENT_II", 218),
    ScriptConstant(DataType.INT, "FORM_LIGHTSABER_ANCIENT_III", 219),
    ScriptConstant(DataType.INT, "FORM_LIGHTSABER_MASTER_I", 220),
    ScriptConstant(DataType.INT, "FORM_LIGHTSABER_MASTER_II", 221),
    ScriptConstant(DataType.INT, "FORM_LIGHTSABER_MASTER_III", 222),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_FORCE_FOCUS_I", 223),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_FORCE_FOCUS_II", 224),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_FORCE_FOCUS_III", 225),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_ENDURING_FORCE_I", 226),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_ENDURING_FORCE_II", 227),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_ENDURING_FORCE_III", 228),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_FORCE_AMPLIFICATION_I", 229),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_FORCE_AMPLIFICATION_II", 230),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_FORCE_AMPLIFICATION_III", 231),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_FORCE_SHELL_I", 232),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_FORCE_SHELL_II", 233),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_FORCE_SHELL_III", 234),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_FORCE_POTENCY_I", 235),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_FORCE_POTENCY_II", 236),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_FORCE_POTENCY_III", 237),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_REGENERATION_I", 238),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_REGENERATION_II", 239),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_REGENERATION_III", 240),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_POWER_OF_THE_DARK_SIDE_I", 241),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_POWER_OF_THE_DARK_SIDE_II", 242),
    ScriptConstant(DataType.INT, "FORM_CONSULAR_POWER_OF_THE_DARK_SIDE_III", 243),
    ScriptConstant(DataType.INT, "FORM_SABER_I_SHII_CHO", 258),
    ScriptConstant(DataType.INT, "FORM_SABER_II_MAKASHI", 259),
    ScriptConstant(DataType.INT, "FORM_SABER_III_SORESU", 260),
    ScriptConstant(DataType.INT, "FORM_SABER_IV_ATARU", 261),
    ScriptConstant(DataType.INT, "FORM_SABER_V_SHIEN", 262),
    ScriptConstant(DataType.INT, "FORM_SABER_VI_NIMAN", 263),
    ScriptConstant(DataType.INT, "FORM_SABER_VII_JUYO", 264),
    ScriptConstant(DataType.INT, "FORM_FORCE_I_FOCUS", 265),
    ScriptConstant(DataType.INT, "FORM_FORCE_II_POTENCY", 266),
    ScriptConstant(DataType.INT, "FORM_FORCE_III_AFFINITY", 267),
    ScriptConstant(DataType.INT, "FORM_FORCE_IV_MASTERY", 268),
    ScriptConstant(DataType.INT, "POISON_ABILITY_SCORE_MILD", 0),
    ScriptConstant(DataType.INT, "POISON_ABILITY_SCORE_AVERAGE", 1),
    ScriptConstant(DataType.INT, "POISON_ABILITY_SCORE_VIRULENT", 2),
    ScriptConstant(DataType.INT, "POISON_DAMAGE_MILD", 3),
    ScriptConstant(DataType.INT, "POISON_DAMAGE_AVERAGE", 4),
    ScriptConstant(DataType.INT, "POISON_DAMAGE_VIRULENT", 5),
    ScriptConstant(DataType.INT, "POISON_ABILITY_AND_DAMAGE_AVERAGE", 6),
    ScriptConstant(DataType.INT, "POISON_ABILITY_AND_DAMAGE_VIRULENT", 7),
    ScriptConstant(DataType.INT, "POISON_DAMAGE_ROCKET", 8),
    ScriptConstant(DataType.INT, "POISON_DAMAGE_NORMAL_DART", 9),
    ScriptConstant(DataType.INT, "POISON_DAMAGE_KYBER_DART", 10),
    ScriptConstant(DataType.INT, "POISON_DAMAGE_KYBER_DART_HALF", 11),
    ScriptConstant(DataType.INT, "CREATURE_TYPE_RACIAL_TYPE", 0),
    ScriptConstant(DataType.INT, "CREATURE_TYPE_PLAYER_CHAR", 1),
    ScriptConstant(DataType.INT, "CREATURE_TYPE_CLASS", 2),
    ScriptConstant(DataType.INT, "CREATURE_TYPE_REPUTATION", 3),
    ScriptConstant(DataType.INT, "CREATURE_TYPE_IS_ALIVE", 4),
    ScriptConstant(DataType.INT, "CREATURE_TYPE_HAS_SPELL_EFFECT", 5),
    ScriptConstant(DataType.INT, "CREATURE_TYPE_DOES_NOT_HAVE_SPELL_EFFECT", 6),
    ScriptConstant(DataType.INT, "CREATURE_TYPE_PERCEPTION", 7),
    ScriptConstant(DataType.INT, "REPUTATION_TYPE_FRIEND", 0),
    ScriptConstant(DataType.INT, "REPUTATION_TYPE_ENEMY", 1),
    ScriptConstant(DataType.INT, "REPUTATION_TYPE_NEUTRAL", 2),
    ScriptConstant(DataType.INT, "PERCEPTION_SEEN_AND_HEARD", 0),
    ScriptConstant(DataType.INT, "PERCEPTION_NOT_SEEN_AND_NOT_HEARD", 1),
    ScriptConstant(DataType.INT, "PERCEPTION_HEARD_AND_NOT_SEEN", 2),
    ScriptConstant(DataType.INT, "PERCEPTION_SEEN_AND_NOT_HEARD", 3),
    ScriptConstant(DataType.INT, "PERCEPTION_NOT_HEARD", 4),
    ScriptConstant(DataType.INT, "PERCEPTION_HEARD", 5),
    ScriptConstant(DataType.INT, "PERCEPTION_NOT_SEEN", 6),
    ScriptConstant(DataType.INT, "PERCEPTION_SEEN", 7),
    ScriptConstant(DataType.INT, "PLAYER_CHAR_NOT_PC", 0),
    ScriptConstant(DataType.INT, "PLAYER_CHAR_IS_PC", 1),
    ScriptConstant(DataType.INT, "CLASS_TYPE_SOLDIER", 0),
    ScriptConstant(DataType.INT, "CLASS_TYPE_SCOUT", 1),
    ScriptConstant(DataType.INT, "CLASS_TYPE_SCOUNDREL", 2),
    ScriptConstant(DataType.INT, "CLASS_TYPE_JEDIGUARDIAN", 3),
    ScriptConstant(DataType.INT, "CLASS_TYPE_JEDICONSULAR", 4),
    ScriptConstant(DataType.INT, "CLASS_TYPE_JEDISENTINEL", 5),
    ScriptConstant(DataType.INT, "CLASS_TYPE_COMBATDROID", 6),
    ScriptConstant(DataType.INT, "CLASS_TYPE_EXPERTDROID", 7),
    ScriptConstant(DataType.INT, "CLASS_TYPE_MINION", 8),
    ScriptConstant(DataType.INT, "CLASS_TYPE_TECHSPECIALIST", 9),
    ScriptConstant(DataType.INT, "CLASS_TYPE_BOUNTYHUNTER", 10),
    ScriptConstant(DataType.INT, "CLASS_TYPE_JEDIWEAPONMASTER", 11),
    ScriptConstant(DataType.INT, "CLASS_TYPE_JEDIMASTER", 12),
    ScriptConstant(DataType.INT, "CLASS_TYPE_JEDIWATCHMAN", 13),
    ScriptConstant(DataType.INT, "CLASS_TYPE_SITHMARAUDER", 14),
    ScriptConstant(DataType.INT, "CLASS_TYPE_SITHLORD", 15),
    ScriptConstant(DataType.INT, "CLASS_TYPE_SITHASSASSIN", 16),
    ScriptConstant(DataType.INT, "CLASS_TYPE_INVALID", 255),
    ScriptConstant(DataType.INT, "PERSISTENT_ZONE_ACTIVE", 0),
    ScriptConstant(DataType.INT, "PERSISTENT_ZONE_FOLLOW", 1),
    ScriptConstant(DataType.INT, "INVALID_STANDARD_FACTION", -1),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_HOSTILE_1", 1),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_FRIENDLY_1", 2),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_HOSTILE_2", 3),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_FRIENDLY_2", 4),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_NEUTRAL", 5),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_INSANE", 6),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_PTAT_TUSKAN", 7),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_GLB_XOR", 8),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_SURRENDER_1", 9),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_SURRENDER_2", 10),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_PREDATOR", 11),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_PREY", 12),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_TRAP", 13),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_ENDAR_SPIRE", 14),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_RANCOR", 15),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_GIZKA_1", 16),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_GIZKA_2", 17),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_SELF_LOATHING", 21),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_ONE_ON_ONE", 22),
    ScriptConstant(DataType.INT, "STANDARD_FACTION_PARTYPUPPET", 23),
    ScriptConstant(DataType.INT, "SKILL_COMPUTER_USE", 0),
    ScriptConstant(DataType.INT, "SKILL_DEMOLITIONS", 1),
    ScriptConstant(DataType.INT, "SKILL_STEALTH", 2),
    ScriptConstant(DataType.INT, "SKILL_AWARENESS", 3),
    ScriptConstant(DataType.INT, "SKILL_PERSUADE", 4),
    ScriptConstant(DataType.INT, "SKILL_REPAIR", 5),
    ScriptConstant(DataType.INT, "SKILL_SECURITY", 6),
    ScriptConstant(DataType.INT, "SKILL_TREAT_INJURY", 7),
    ScriptConstant(DataType.INT, "SKILL_MAX_SKILLS", 8),
    ScriptConstant(DataType.INT, "SUBSKILL_FLAGTRAP", 100),
    ScriptConstant(DataType.INT, "SUBSKILL_RECOVERTRAP", 101),
    ScriptConstant(DataType.INT, "SUBSKILL_EXAMINETRAP", 102),
    ScriptConstant(DataType.INT, "FEAT_ADVANCED_JEDI_DEFENSE", 1),
    ScriptConstant(DataType.INT, "FEAT_ADVANCED_GUARD_STANCE", 2),
    ScriptConstant(DataType.INT, "FEAT_AMBIDEXTERITY", 3),
    ScriptConstant(DataType.INT, "FEAT_ARMOUR_PROF_HEAVY", 4),
    ScriptConstant(DataType.INT, "FEAT_ARMOUR_PROF_LIGHT", 5),
    ScriptConstant(DataType.INT, "FEAT_ARMOUR_PROF_MEDIUM", 6),
    ScriptConstant(DataType.INT, "FEAT_CAUTIOUS", 7),
    ScriptConstant(DataType.INT, "FEAT_CRITICAL_STRIKE", 8),
    ScriptConstant(DataType.INT, "FEAT_DOUBLE_WEAPON_FIGHTING", 9),
    ScriptConstant(DataType.INT, "FEAT_EMPATHY", 10),
    ScriptConstant(DataType.INT, "FEAT_FLURRY", 11),
    ScriptConstant(DataType.INT, "FEAT_GEAR_HEAD", 12),
    ScriptConstant(DataType.INT, "FEAT_GREAT_FORTITUDE", 13),
    ScriptConstant(DataType.INT, "FEAT_IMPLANT_LEVEL_1", 14),
    ScriptConstant(DataType.INT, "FEAT_IMPLANT_LEVEL_2", 15),
    ScriptConstant(DataType.INT, "FEAT_IMPLANT_LEVEL_3", 16),
    ScriptConstant(DataType.INT, "FEAT_IMPROVED_POWER_ATTACK", 17),
    ScriptConstant(DataType.INT, "FEAT_IMPROVED_POWER_BLAST", 18),
    ScriptConstant(DataType.INT, "FEAT_IMPROVED_CRITICAL_STRIKE", 19),
    ScriptConstant(DataType.INT, "FEAT_IMPROVED_SNIPER_SHOT", 20),
    ScriptConstant(DataType.INT, "FEAT_IRON_WILL", 21),
    ScriptConstant(DataType.INT, "FEAT_LIGHTNING_REFLEXES", 22),
    ScriptConstant(DataType.INT, "FEAT_MASTER_JEDI_DEFENSE", 24),
    ScriptConstant(DataType.INT, "FEAT_MASTER_GUARD_STANCE", 25),
    ScriptConstant(DataType.INT, "FEAT_MULTI_SHOT", 26),
    ScriptConstant(DataType.INT, "FEAT_PERCEPTIVE", 27),
    ScriptConstant(DataType.INT, "FEAT_POWER_ATTACK", 28),
    ScriptConstant(DataType.INT, "FEAT_POWER_BLAST", 29),
    ScriptConstant(DataType.INT, "FEAT_RAPID_SHOT", 30),
    ScriptConstant(DataType.INT, "FEAT_SNIPER_SHOT", 31),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_FOCUS_BLASTER", 32),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_FOCUS_BLASTER_RIFLE", 33),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_FOCUS_GRENADE", 34),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_FOCUS_HEAVY_WEAPONS", 35),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_FOCUS_LIGHTSABER", 36),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_FOCUS_MELEE_WEAPONS", 37),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_FOCUS_SIMPLE_WEAPONS", 38),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_PROFICIENCY_BLASTER", 39),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_PROFICIENCY_BLASTER_RIFLE", 40),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_PROFICIENCY_GRENADE", 41),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_PROFICIENCY_HEAVY_WEAPONS", 42),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_PROFICIENCY_LIGHTSABER", 43),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_PROFICIENCY_MELEE_WEAPONS", 44),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_PROFICIENCY_SIMPLE_WEAPONS", 45),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_SPECIALIZATION_BLASTER", 46),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_SPECIALIZATION_BLASTER_RIFLE", 47),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_SPECIALIZATION_GRENADE", 48),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_SPECIALIZATION_HEAVY_WEAPONS", 49),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_SPECIALIZATION_LIGHTSABER", 50),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_SPECIALIZATION_MELEE_WEAPONS", 51),
    ScriptConstant(DataType.INT, "FEAT_WEAPON_SPECIALIZATION_SIMPLE_WEAPONS", 52),
    ScriptConstant(DataType.INT, "FEAT_WHIRLWIND_ATTACK", 53),
    ScriptConstant(DataType.INT, "FEAT_GUARD_STANCE", 54),
    ScriptConstant(DataType.INT, "FEAT_JEDI_DEFENSE", 55),
    ScriptConstant(DataType.INT, "FEAT_UNCANNY_DODGE_1", 56),
    ScriptConstant(DataType.INT, "FEAT_UNCANNY_DODGE_2", 57),
    ScriptConstant(DataType.INT, "FEAT_SKILL_FOCUS_COMPUTER_USE", 58),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_1D6", 60),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_2D6", 61),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_3D6", 62),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_4D6", 63),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_5D6", 64),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_6D6", 65),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_7D6", 66),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_8D6", 67),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_9D6", 68),
    ScriptConstant(DataType.INT, "FEAT_SNEAK_ATTACK_10D6", 69),
    ScriptConstant(DataType.INT, "FEAT_SKILL_FOCUS_DEMOLITIONS", 70),
    ScriptConstant(DataType.INT, "FEAT_SKILL_FOCUS_STEALTH", 71),
    ScriptConstant(DataType.INT, "FEAT_SKILL_FOCUS_AWARENESS", 72),
    ScriptConstant(DataType.INT, "FEAT_SKILL_FOCUS_PERSUADE", 73),
    ScriptConstant(DataType.INT, "FEAT_SKILL_FOCUS_REPAIR", 74),
    ScriptConstant(DataType.INT, "FEAT_SKILL_FOCUS_SECURITY", 75),
    ScriptConstant(DataType.INT, "FEAT_SKILL_FOCUS_TREAT_INJUURY", 76),
    ScriptConstant(DataType.INT, "FEAT_MASTER_SNIPER_SHOT", 77),
    ScriptConstant(DataType.INT, "FEAT_DROID_UPGRADE_1", 78),
    ScriptConstant(DataType.INT, "FEAT_DROID_UPGRADE_2", 79),
    ScriptConstant(DataType.INT, "FEAT_DROID_UPGRADE_3", 80),
    ScriptConstant(DataType.INT, "FEAT_MASTER_CRITICAL_STRIKE", 81),
    ScriptConstant(DataType.INT, "FEAT_MASTER_POWER_BLAST", 82),
    ScriptConstant(DataType.INT, "FEAT_MASTER_POWER_ATTACK", 83),
    ScriptConstant(DataType.INT, "FEAT_TOUGHNESS", 84),
    ScriptConstant(DataType.INT, "FEAT_ADVANCED_DOUBLE_WEAPON_FIGHTING", 85),
    ScriptConstant(DataType.INT, "FEAT_FORCE_FOCUS_ALTER", 86),
    ScriptConstant(DataType.INT, "FEAT_FORCE_FOCUS_CONTROL", 87),
    ScriptConstant(DataType.INT, "FEAT_FORCE_FOCUS_SENSE", 88),
    ScriptConstant(DataType.INT, "FEAT_FORCE_FOCUS_ADVANCED", 89),
    ScriptConstant(DataType.INT, "FEAT_FORCE_FOCUS_MASTERY", 90),
    ScriptConstant(DataType.INT, "FEAT_IMPROVED_FLURRY", 91),
    ScriptConstant(DataType.INT, "FEAT_IMPROVED_RAPID_SHOT", 92),
    ScriptConstant(DataType.INT, "FEAT_PROFICIENCY_ALL", 93),
    ScriptConstant(DataType.INT, "FEAT_BATTLE_MEDITATION", 94),
    ScriptConstant(DataType.INT, "FEAT_EVASION", 125),
    ScriptConstant(DataType.INT, "FEAT_TARGETING_1", 126),
    ScriptConstant(DataType.INT, "FEAT_TARGETING_2", 127),
    ScriptConstant(DataType.INT, "FEAT_TARGETING_3", 128),
    ScriptConstant(DataType.INT, "FEAT_TARGETING_4", 129),
    ScriptConstant(DataType.INT, "FEAT_TARGETING_5", 130),
    ScriptConstant(DataType.INT, "FEAT_TARGETING_6", 131),
    ScriptConstant(DataType.INT, "FEAT_TARGETING_7", 132),
    ScriptConstant(DataType.INT, "FEAT_TARGETING_8", 133),
    ScriptConstant(DataType.INT, "FEAT_TARGETING_9", 134),
    ScriptConstant(DataType.INT, "FEAT_TARGETING_10", 135),
    ScriptConstant(DataType.INT, "FEAT_PRECISE_SHOT", 136),
    ScriptConstant(DataType.INT, "FEAT_IMPROVED_PRECISE_SHOT", 137),
    ScriptConstant(DataType.INT, "FEAT_MASTER_PRECISE_SHOT", 138),
    ScriptConstant(DataType.INT, "FEAT_CLOSE_COMBAT", 139),
    ScriptConstant(DataType.INT, "FEAT_IMPROVED_CLOSE_COMBAT", 140),
    ScriptConstant(DataType.INT, "FEAT_IMPROVED_FORCE_CAMOUFLAGE", 141),
    ScriptConstant(DataType.INT, "FEAT_MASTER_FORCE_CAMOUFLAGE", 142),
    ScriptConstant(DataType.INT, "FEAT_REGENERATE_FORCE_POINTS", 143),
    ScriptConstant(DataType.INT, "FEAT_DARK_SIDE_CORRUPTION", 149),
    ScriptConstant(DataType.INT, "FEAT_IGNORE_PAIN_1", 150),
    ScriptConstant(DataType.INT, "FEAT_IGNORE_PAIN_2", 151),
    ScriptConstant(DataType.INT, "FEAT_IGNORE_PAIN_3", 152),
    ScriptConstant(DataType.INT, "FEAT_INCREASE_COMBAT_DAMAGE_1", 153),
    ScriptConstant(DataType.INT, "FEAT_INCREASE_COMBAT_DAMAGE_2", 154),
    ScriptConstant(DataType.INT, "FEAT_INCREASE_COMBAT_DAMAGE_3", 155),
    ScriptConstant(DataType.INT, "FEAT_SUPERIOR_WEAPON_FOCUS_LIGHTSABER_1", 156),
    ScriptConstant(DataType.INT, "FEAT_SUPERIOR_WEAPON_FOCUS_LIGHTSABER_2", 157),
    ScriptConstant(DataType.INT, "FEAT_SUPERIOR_WEAPON_FOCUS_LIGHTSABER_3", 158),
    ScriptConstant(DataType.INT, "FEAT_SUPERIOR_WEAPON_FOCUS_TWO_WEAPON_1", 159),
    ScriptConstant(DataType.INT, "FEAT_SUPERIOR_WEAPON_FOCUS_TWO_WEAPON_2", 160),
    ScriptConstant(DataType.INT, "FEAT_SUPERIOR_WEAPON_FOCUS_TWO_WEAPON_3", 161),
    ScriptConstant(DataType.INT, "FEAT_LIGHT_SIDE_ENLIGHTENMENT", 167),
    ScriptConstant(DataType.INT, "FEAT_DEFLECT", 168),
    ScriptConstant(DataType.INT, "FEAT_INNER_STRENGTH_1", 169),
    ScriptConstant(DataType.INT, "FEAT_INNER_STRENGTH_2", 170),
    ScriptConstant(DataType.INT, "FEAT_INNER_STRENGTH_3", 171),
    ScriptConstant(DataType.INT, "FEAT_INCREASE_MELEE_DAMAGE_1", 172),
    ScriptConstant(DataType.INT, "FEAT_INCREASE_MELEE_DAMAGE_2", 173),
    ScriptConstant(DataType.INT, "FEAT_INCREASE_MELEE_DAMAGE_3", 174),
    ScriptConstant(DataType.INT, "FEAT_CRAFT", 175),
    ScriptConstant(DataType.INT, "FEAT_MASTERCRAFT_WEAPONS_1", 176),
    ScriptConstant(DataType.INT, "FEAT_MASTERCRAFT_WEAPONS_2", 177),
    ScriptConstant(DataType.INT, "FEAT_MASTERCRAFT_WEAPONS_3", 178),
    ScriptConstant(DataType.INT, "FEAT_MASTERCRAFT_ARMOR_1", 179),
    ScriptConstant(DataType.INT, "FEAT_MASTERCRAFT_ARMOR_2", 180),
    ScriptConstant(DataType.INT, "FEAT_MASTERCRAFT_ARMOR_3", 181),
    ScriptConstant(DataType.INT, "FEAT_DROID_INTERFACE", 182),
    ScriptConstant(DataType.INT, "FEAT_CLASS_SKILL_AWARENESS", 183),
    ScriptConstant(DataType.INT, "FEAT_CLASS_SKILL_COMPUTER_USE", 184),
    ScriptConstant(DataType.INT, "FEAT_CLASS_SKILL_DEMOLITIONS", 185),
    ScriptConstant(DataType.INT, "FEAT_CLASS_SKILL_REPAIR", 186),
    ScriptConstant(DataType.INT, "FEAT_CLASS_SKILL_SECURITY", 187),
    ScriptConstant(DataType.INT, "FEAT_CLASS_SKILL_STEALTH", 188),
    ScriptConstant(DataType.INT, "FEAT_CLASS_SKILL_TREAT_INJURY", 189),
    ScriptConstant(DataType.INT, "FEAT_DUAL_STRIKE", 190),
    ScriptConstant(DataType.INT, "FEAT_IMPROVED_DUAL_STRIKE", 191),
    ScriptConstant(DataType.INT, "FEAT_MASTER_DUAL_STRIKE", 192),
    ScriptConstant(DataType.INT, "FEAT_FINESSE_LIGHTSABERS", 193),
    ScriptConstant(DataType.INT, "FEAT_FINESSE_MELEE_WEAPONS", 194),
    ScriptConstant(DataType.INT, "FEAT_MOBILITY", 195),
    ScriptConstant(DataType.INT, "FEAT_REGENERATE_VITALITY_POINTS", 196),
    ScriptConstant(DataType.INT, "FEAT_STEALTH_RUN", 197),
    ScriptConstant(DataType.INT, "FEAT_KINETIC_COMBAT", 198),
    ScriptConstant(DataType.INT, "FEAT_SURVIVAL", 199),
    ScriptConstant(DataType.INT, "FEAT_MANDALORIAN_COURAGE", 200),
    ScriptConstant(DataType.INT, "FEAT_PERSONAL_CLOAKING_SHIELD", 201),
    ScriptConstant(DataType.INT, "FEAT_MENTOR", 202),
    ScriptConstant(DataType.INT, "FEAT_IMPLANT_SWITCHING", 203),
    ScriptConstant(DataType.INT, "FEAT_SPIRIT", 204),
    ScriptConstant(DataType.INT, "FEAT_FORCE_CHAIN", 205),
    ScriptConstant(DataType.INT, "FEAT_WAR_VETERAN", 206),
    ScriptConstant(DataType.INT, "FEAT_PRECISE_SHOT_IV", 226),
    ScriptConstant(DataType.INT, "FEAT_PRECISE_SHOT_V", 227),
    ScriptConstant(DataType.INT, "FEAT_FIGHTING_SPIRIT", 236),
    ScriptConstant(DataType.INT, "FEAT_HEROIC_RESOLVE", 237),
    ScriptConstant(DataType.INT, "FEAT_PRECISE_SHOT", 240),
    ScriptConstant(DataType.INT, "FEAT_IMPROVED_PRECISE_SHOT", 241),
    ScriptConstant(DataType.INT, "FEAT_MASTER_PRECISE_SHOT", 242),
    ScriptConstant(DataType.INT, "FEAT_PRECISE_SHOT_IV", 243),
    ScriptConstant(DataType.INT, "FEAT_PRECISE_SHOT_V", 244),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_INVALID", 0),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_CALLED_SHOT_LEG", 1),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_CALLED_SHOT_ARM", 2),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_SAP", 3),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_DISARM", 4),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_IMPROVED_DISARM", 5),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_KNOCKDOWN", 6),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_IMPROVED_KNOCKDOWN", 7),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_STUNNING_FIST", 8),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_FLURRY_OF_BLOWS", 9),
    ScriptConstant(DataType.INT, "SPECIAL_ATTACK_RAPID_SHOT", 10),
    ScriptConstant(DataType.INT, "COMBAT_MODE_INVALID", 0),
    ScriptConstant(DataType.INT, "COMBAT_MODE_PARRY", 1),
    ScriptConstant(DataType.INT, "COMBAT_MODE_POWER_ATTACK", 2),
    ScriptConstant(DataType.INT, "COMBAT_MODE_IMPROVED_POWER_ATTACK", 3),
    ScriptConstant(DataType.INT, "COMBAT_MODE_FLURRY_OF_BLOWS", 4),
    ScriptConstant(DataType.INT, "COMBAT_MODE_RAPID_SHOT", 5),
    ScriptConstant(DataType.INT, "ENCOUNTER_DIFFICULTY_VERY_EASY", 0),
    ScriptConstant(DataType.INT, "ENCOUNTER_DIFFICULTY_EASY", 1),
    ScriptConstant(DataType.INT, "ENCOUNTER_DIFFICULTY_NORMAL", 2),
    ScriptConstant(DataType.INT, "ENCOUNTER_DIFFICULTY_HARD", 3),
    ScriptConstant(DataType.INT, "ENCOUNTER_DIFFICULTY_IMPOSSIBLE", 4),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_PAUSE", 0),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_PAUSE2", 1),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_LISTEN", 2),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_MEDITATE", 3),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_WORSHIP", 4),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_TALK_NORMAL", 5),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_TALK_PLEADING", 6),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_TALK_FORCEFUL", 7),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_TALK_LAUGHING", 8),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_TALK_SAD", 9),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_GET_LOW", 10),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_GET_MID", 11),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_PAUSE_TIRED", 12),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_PAUSE_DRUNK", 13),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_FLIRT", 14),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_USE_COMPUTER", 15),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_DANCE", 16),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_DANCE1", 17),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_HORROR", 18),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_READY", 19),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_DEACTIVATE", 20),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_SPASM", 21),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_SLEEP", 22),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_PRONE", 23),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_PAUSE3", 24),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_WELD", 25),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_DEAD", 26),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_TALK_INJURED", 27),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_LISTEN_INJURED", 28),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_TREAT_INJURED", 29),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_DEAD_PRONE", 30),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_KNEEL_TALK_ANGRY", 31),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_KNEEL_TALK_SAD", 32),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_CHECK_BODY", 33),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_UNLOCK_DOOR", 34),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_SIT_AND_MEDITATE", 35),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_SIT_CHAIR", 36),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_SIT_CHAIR_DRINK", 37),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_SIT_CHAIR_PAZAK", 38),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_SIT_CHAIR_COMP1", 39),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_SIT_CHAIR_COMP2", 40),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_RAGE", 41),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_CLOSED", 43),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_STEALTH", 44),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_CHOKE_WORKING", 45),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_MEDITATE_STAND", 46),
    ScriptConstant(DataType.INT, "ANIMATION_LOOPING_CHOKE", 116),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_HEAD_TURN_LEFT", 100),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_HEAD_TURN_RIGHT", 101),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_PAUSE_SCRATCH_HEAD", 102),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_PAUSE_BORED", 103),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_SALUTE", 104),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_BOW", 105),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_GREETING", 106),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_TAUNT", 107),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_VICTORY1", 108),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_VICTORY2", 109),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_VICTORY3", 110),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_INJECT", 112),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_USE_COMPUTER", 113),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_PERSUADE", 114),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_ACTIVATE", 115),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_CHOKE", 116),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_THROW_HIGH", 117),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_THROW_LOW", 118),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_CUSTOM01", 119),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_TREAT_INJURED", 120),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_FORCE_CAST", 121),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_OPEN", 122),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_DIVE_ROLL", 123),
    ScriptConstant(DataType.INT, "ANIMATION_FIREFORGET_SCREAM", 124),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ACTIVATE", 200),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_DEACTIVATE", 201),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_OPEN", 202),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_CLOSE", 203),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP01", 204),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP02", 205),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP03", 206),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP04", 207),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP05", 208),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP06", 209),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP07", 210),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP08", 211),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP09", 212),
    ScriptConstant(DataType.INT, "ANIMATION_PLACEABLE_ANIMLOOP10", 213),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP01", 1),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP02", 2),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP03", 3),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP04", 4),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP05", 5),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP06", 6),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP07", 7),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP08", 8),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP09", 9),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP10", 10),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP11", 11),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP12", 12),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP13", 13),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP14", 14),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP15", 15),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP16", 16),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP17", 17),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP18", 18),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP19", 19),
    ScriptConstant(DataType.INT, "ANIMATION_ROOM_SCRIPTLOOP20", 20),
    ScriptConstant(DataType.INT, "TALENT_TYPE_FORCE", 0),
    ScriptConstant(DataType.INT, "TALENT_TYPE_SPELL", 0),
    ScriptConstant(DataType.INT, "TALENT_TYPE_FEAT", 1),
    ScriptConstant(DataType.INT, "TALENT_TYPE_SKILL", 2),
    ScriptConstant(DataType.INT, "TALENT_EXCLUDE_ALL_OF_TYPE", -1),
    ScriptConstant(DataType.INT, "INVENTORY_DISTURB_TYPE_ADDED", 0),
    ScriptConstant(DataType.INT, "INVENTORY_DISTURB_TYPE_REMOVED", 1),
    ScriptConstant(DataType.INT, "INVENTORY_DISTURB_TYPE_STOLEN", 2),
    ScriptConstant(DataType.INT, "GUI_PANEL_PLAYER_DEATH", 0),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_WEREWOLF", 0),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_WERERAT", 1),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_WERECAT", 2),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_GIANT_SPIDER", 3),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_TROLL", 4),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_UMBER_HULK", 5),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_PIXIE", 6),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_ZOMBIE", 7),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_RED_DRAGON", 8),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_FIRE_GIANT", 9),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_BALOR", 10),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_DEATH_SLAAD", 11),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_IRON_GOLEM", 12),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_HUGE_FIRE_ELEMENTAL", 13),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_HUGE_WATER_ELEMENTAL", 14),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_HUGE_EARTH_ELEMENTAL", 15),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_HUGE_AIR_ELEMENTAL", 16),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_ELDER_FIRE_ELEMENTAL", 17),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_ELDER_WATER_ELEMENTAL", 18),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_ELDER_EARTH_ELEMENTAL", 19),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_ELDER_AIR_ELEMENTAL", 20),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_BROWN_BEAR", 21),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_PANTHER", 22),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_WOLF", 23),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_BOAR", 24),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_BADGER", 25),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_PENGUIN", 26),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_COW", 27),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_DOOM_KNIGHT", 28),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_YUANTI", 29),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_IMP", 30),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_QUASIT", 31),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_SUCCUBUS", 32),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_DIRE_BROWN_BEAR", 33),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_DIRE_PANTHER", 34),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_DIRE_WOLF", 35),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_DIRE_BOAR", 36),
    ScriptConstant(DataType.INT, "POLYMORPH_TYPE_DIRE_BADGER", 37),
    ScriptConstant(DataType.INT, "INVISIBILITY_TYPE_NORMAL", 1),
    ScriptConstant(DataType.INT, "INVISIBILITY_TYPE_DARKNESS", 2),
    ScriptConstant(DataType.INT, "INVISIBILITY_TYPE_IMPROVED", 4),
    ScriptConstant(DataType.INT, "CREATURE_SIZE_INVALID", 0),
    ScriptConstant(DataType.INT, "CREATURE_SIZE_TINY", 1),
    ScriptConstant(DataType.INT, "CREATURE_SIZE_SMALL", 2),
    ScriptConstant(DataType.INT, "CREATURE_SIZE_MEDIUM", 3),
    ScriptConstant(DataType.INT, "CREATURE_SIZE_LARGE", 4),
    ScriptConstant(DataType.INT, "CREATURE_SIZE_HUGE", 5),
    ScriptConstant(DataType.INT, "CAMERA_MODE_CHASE_CAMERA", 0),
    ScriptConstant(DataType.INT, "CAMERA_MODE_TOP_DOWN", 1),
    ScriptConstant(DataType.INT, "CAMERA_MODE_STIFF_CHASE_CAMERA", 2),
    ScriptConstant(DataType.INT, "PROJECTILE_PATH_TYPE_DEFAULT", 0),
    ScriptConstant(DataType.INT, "PROJECTILE_PATH_TYPE_HOMING", 1),
    ScriptConstant(DataType.INT, "PROJECTILE_PATH_TYPE_BALLISTIC", 2),
    ScriptConstant(DataType.INT, "PROJECTILE_PATH_TYPE_HIGH_BALLISTIC", 3),
    ScriptConstant(DataType.INT, "PROJECTILE_PATH_TYPE_ACCELERATING", 4),
    ScriptConstant(DataType.INT, "GAME_DIFFICULTY_VERY_EASY", 0),
    ScriptConstant(DataType.INT, "GAME_DIFFICULTY_EASY", 1),
    ScriptConstant(DataType.INT, "GAME_DIFFICULTY_NORMAL", 2),
    ScriptConstant(DataType.INT, "GAME_DIFFICULTY_CORE_RULES", 3),
    ScriptConstant(DataType.INT, "GAME_DIFFICULTY_DIFFICULT", 4),
    ScriptConstant(DataType.INT, "ACTION_MOVETOPOINT", 0),
    ScriptConstant(DataType.INT, "ACTION_PICKUPITEM", 1),
    ScriptConstant(DataType.INT, "ACTION_DROPITEM", 2),
    ScriptConstant(DataType.INT, "ACTION_ATTACKOBJECT", 3),
    ScriptConstant(DataType.INT, "ACTION_CASTSPELL", 4),
    ScriptConstant(DataType.INT, "ACTION_OPENDOOR", 5),
    ScriptConstant(DataType.INT, "ACTION_CLOSEDOOR", 6),
    ScriptConstant(DataType.INT, "ACTION_DIALOGOBJECT", 7),
    ScriptConstant(DataType.INT, "ACTION_DISABLETRAP", 8),
    ScriptConstant(DataType.INT, "ACTION_RECOVERTRAP", 9),
    ScriptConstant(DataType.INT, "ACTION_FLAGTRAP", 10),
    ScriptConstant(DataType.INT, "ACTION_EXAMINETRAP", 11),
    ScriptConstant(DataType.INT, "ACTION_SETTRAP", 12),
    ScriptConstant(DataType.INT, "ACTION_OPENLOCK", 13),
    ScriptConstant(DataType.INT, "ACTION_LOCK", 14),
    ScriptConstant(DataType.INT, "ACTION_USEOBJECT", 15),
    ScriptConstant(DataType.INT, "ACTION_ANIMALEMPATHY", 16),
    ScriptConstant(DataType.INT, "ACTION_REST", 17),
    ScriptConstant(DataType.INT, "ACTION_TAUNT", 18),
    ScriptConstant(DataType.INT, "ACTION_ITEMCASTSPELL", 19),
    ScriptConstant(DataType.INT, "ACTION_COUNTERSPELL", 31),
    ScriptConstant(DataType.INT, "ACTION_HEAL", 33),
    ScriptConstant(DataType.INT, "ACTION_PICKPOCKET", 34),
    ScriptConstant(DataType.INT, "ACTION_FOLLOW", 35),
    ScriptConstant(DataType.INT, "ACTION_WAIT", 36),
    ScriptConstant(DataType.INT, "ACTION_SIT", 37),
    ScriptConstant(DataType.INT, "ACTION_FOLLOWLEADER", 38),
    ScriptConstant(DataType.INT, "ACTION_FOLLOWOWNER", 43),
    ScriptConstant(DataType.INT, "ACTION_INVALID", 65535),
    ScriptConstant(DataType.INT, "ACTION_QUEUEEMPTY", 65534),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_FLASH_STUN_MINOR", 0),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_FLASH_STUN_AVERAGE", 1),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_FLASH_STUN_DEADLY", 2),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_FRAGMENTATION_MINE_MINOR", 3),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_FRAGMENTATION_MINE_AVERAGE", 4),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_FRAGMENTATION_MINE_DEADLY", 5),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_LASER_SLICING_MINOR", 6),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_LASER_SLICING_AVERAGE", 7),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_LASER_SLICING_DEADLY", 8),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_POISON_GAS_MINOR", 9),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_POISON_GAS_AVERAGE", 10),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_POISON_GAS_DEADLY", 11),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_SONIC_CHARGE_MINOR", 14),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_SONIC_CHARGE_AVERAGE", 15),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_SONIC_CHARGE_DEADLY", 16),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_FLASH_STUN_STRONG", 17),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_FLASH_STUN_DEVASTATING", 18),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_FRAGMENTATION_MINE_STRONG", 19),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_FRAGMENTATION_MINE_DEVASTATING", 20),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_LASER_SLICING_STRONG", 21),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_LASER_SLICING_DEVASTATING", 22),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_POISON_GAS_STRONG", 23),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_POISON_GAS_DEVASTATING", 24),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_SONIC_CHARGE_STRONG", 25),
    ScriptConstant(DataType.INT, "TRAP_BASE_TYPE_SONIC_CHARGE_DEVASTATING", 26),
    ScriptConstant(DataType.INT, "SWMINIGAME_TRACKFOLLOWER_SOUND_ENGINE", 0),
    ScriptConstant(DataType.INT, "SWMINIGAME_TRACKFOLLOWER_SOUND_DEATH", 1),
    ScriptConstant(DataType.INT, "CONVERSATION_TYPE_CINEMATIC", 0),
    ScriptConstant(DataType.INT, "CONVERSATION_TYPE_COMPUTER", 1),
    ScriptConstant(DataType.INT, "PLANET_DANTOOINE", 0),
    ScriptConstant(DataType.INT, "PLANET_DXUN", 1),
    ScriptConstant(DataType.INT, "PLANET_EBON_HAWK", 2),
    ScriptConstant(DataType.INT, "PLANET_KORRIBAN", 3),
    ScriptConstant(DataType.INT, "PLANET_M4_78", 4),
    ScriptConstant(DataType.INT, "PLANET_MALACHOR_V", 5),
    ScriptConstant(DataType.INT, "PLANET_NAR_SHADDAA", 6),
    ScriptConstant(DataType.INT, "PLANET_ONDERON", 7),
    ScriptConstant(DataType.INT, "PLANET_PERAGUS", 8),
    ScriptConstant(DataType.INT, "PLANET_TELOS", 9),
    ScriptConstant(DataType.INT, "PLANET_HARBINGER", 10),
    ScriptConstant(DataType.INT, "PLANET_LIVE_01", 11),
    ScriptConstant(DataType.INT, "PLANET_LIVE_02", 12),
    ScriptConstant(DataType.INT, "PLANET_LIVE_03", 13),
    ScriptConstant(DataType.INT, "PLANET_LIVE_04", 14),
    ScriptConstant(DataType.INT, "PLANET_LIVE_05", 15),
    ScriptConstant(DataType.INT, "PLANET_LIVE_06", 16),
    ScriptConstant(DataType.INT, "NPC_PLAYER", -1),
    ScriptConstant(DataType.INT, "NPC_ATTON", 0),
    ScriptConstant(DataType.INT, "NPC_BAO_DUR", 1),
    ScriptConstant(DataType.INT, "NPC_CANDEROUS", 2),
    ScriptConstant(DataType.INT, "NPC_G0T0", 3),
    ScriptConstant(DataType.INT, "NPC_HANDMAIDEN", 4),
    ScriptConstant(DataType.INT, "NPC_HK_47", 5),
    ScriptConstant(DataType.INT, "NPC_KREIA", 6),
    ScriptConstant(DataType.INT, "NPC_MIRA", 7),
    ScriptConstant(DataType.INT, "NPC_T3_M4", 8),
    ScriptConstant(DataType.INT, "NPC_VISAS", 9),
    ScriptConstant(DataType.INT, "NPC_HANHARR", 10),
    ScriptConstant(DataType.INT, "NPC_DISCIPLE", 11),
    ScriptConstant(DataType.INT, "PUP_SENSORBALL", 0),
    ScriptConstant(DataType.INT, "PUP_OTHER1", 1),
    ScriptConstant(DataType.INT, "PUP_OTHER2", 2),
    ScriptConstant(DataType.INT, "PARTY_AISTYLE_AGGRESSIVE", 0),
    ScriptConstant(DataType.INT, "PARTY_AISTYLE_DEFENSIVE", 1),
    ScriptConstant(DataType.INT, "PARTY_AISTYLE_PASSIVE", 2),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_DEFAULT_ATTACK", 0),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_RANGED_ATTACK", 1),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_MELEE_ATTACK", 2),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_AID", 3),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_GRENADE_THROWER", 4),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_JEDI_SUPPORT", 5),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_HEALER", 6),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_SKIRMISH", 7),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_TURTLE", 8),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_PARTY_AGGRO", 9),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_PARTY_DEFENSE", 10),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_PARTY_RANGED", 11),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_PARTY_STATIONARY", 12),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_PARTY_SUPPORT", 13),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_PARTY_REMOTE", 14),
    ScriptConstant(DataType.INT, "NPC_AISTYLE_MONSTER_POWERS", 15),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_TEST", 1),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_T3M3", 2),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_HK47", 3),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_BASTILLA", 4),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_CAND", 5),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_CARTH", 6),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_JOLEE", 7),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_JUHANI", 8),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_ZAALBAR", 9),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MISSION", 10),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_ADMRLSAULKAR", 11),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_BITH", 12),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_CALONORD", 13),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_COMMF", 14),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_COMMKIDF", 15),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_COMMKIDM", 16),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_COMMM", 17),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_CZERLAOFF", 18),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_DARKJEDIF", 19),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_DARKJEDIM", 20),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_DARTHMALAK", 21),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_DARTHREVAN", 22),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_DODONNA", 23),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_DUROS", 24),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_FATCOMF", 25),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_FATCOMM", 26),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_SMUGGLER", 27),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_SITHSOLDIER", 28),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_JEDICOUNTF", 30),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_JEDICOUNTM", 31),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_JEDIMALEK", 32),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_JEDIMEMF", 33),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_JEDIMEMM", 34),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_MANDALORIAN", 35),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_RAKATA", 36),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_REPOFF", 37),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_REPSOLD", 38),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_RODIAN", 39),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_SELKATH", 40),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_SITHAPPREN", 41),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_SITHCOMF", 42),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_SITHCOMM", 43),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_SWOOPGANG", 45),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_TUSKEN", 46),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_TWILEKF", 47),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_TWILEKM", 48),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_WALRUSMAN", 49),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_WOOKIEF", 50),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_WOOKIEM", 51),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_YODA", 52),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_BANTHA", 53),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_BRITH", 54),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DEWBACK", 55),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDASSASSIN", 56),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDASTRO", 57),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDG", 58),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDMKFOUR", 59),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDMKONE", 60),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDMKTWO", 61),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDPROBE", 62),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDPROT", 63),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDSENTRY", 64),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDSPYDER", 65),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_DRDWAR", 66),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_FIRIXA", 67),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_GAMMOREAN", 68),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_GIZKA", 69),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_HUTT", 70),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_IRIAZ", 71),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_ITHORIAN", 72),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_JAWA", 73),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_KATAARN", 74),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_KHOUNDA", 75),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_KHOUNDB", 76),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_KRAYTDRAGON", 77),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_MYKAL", 78),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_RAKGHOUL", 79),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_RANCOR", 80),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_SEABEAST", 81),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_TACH", 83),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_TWOHEAD", 84),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_VERKAAL", 85),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_WRAID", 86),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_RONTO", 87),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_KINRATH", 88),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_C_TUKATA", 89),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_TUSKENF", 90),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_SML_01", 91),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_MED_01", 92),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_LRG_01", 93),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_SML_02", 94),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_MED_02", 95),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_LRG_02", 96),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_SML_03", 97),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_MED_03", 98),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_LRG_03", 99),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_SML_04", 100),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_MED_04", 101),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_LRG_04", 102),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_SML_05", 103),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_MED_05", 104),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_A_LRG_05", 105),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_SML_01", 106),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_MED_01", 107),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_LRG_01", 108),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_SML_02", 109),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_MED_02", 110),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_LRG_02", 111),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_SML_03", 112),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_MED_03", 113),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_LRG_03", 114),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_SML_04", 115),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_MED_04", 116),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_LRG_04", 117),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_SML_05", 118),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_MED_05", 119),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_B_LRG_05", 120),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_SML_01", 121),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_MED_01", 122),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_LRG_01", 123),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_SML_02", 124),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_MED_02", 125),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_LRG_02", 126),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_SML_03", 127),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_MED_03", 128),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_LRG_03", 129),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_SML_04", 130),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_MED_04", 131),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_LRG_04", 132),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_SML_05", 133),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_MED_05", 134),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_FEM_C_LRG_05", 135),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_SML_01", 136),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_MED_01", 137),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_LRG_01", 138),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_SML_02", 139),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_MED_02", 140),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_LRG_02", 141),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_SML_03", 142),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_MED_03", 143),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_LRG_03", 144),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_SML_04", 145),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_MED_04", 146),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_LRG_04", 147),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_SML_05", 148),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_MED_05", 149),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_A_LRG_05", 150),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_SML_01", 151),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_MED_01", 152),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_LRG_01", 153),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_SML_02", 154),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_MED_02", 155),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_LRG_02", 156),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_SML_03", 157),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_MED_03", 158),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_LRG_03", 159),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_SML_04", 160),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_MED_04", 161),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_LRG_04", 162),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_SML_05", 163),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_MED_05", 164),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_B_LRG_05", 165),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_SML_01", 166),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_MED_01", 167),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_LRG_01", 168),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_SML_02", 169),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_MED_02", 170),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_LRG_02", 171),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_SML_03", 172),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_MED_03", 173),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_LRG_03", 174),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_SML_04", 175),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_MED_04", 176),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_LRG_04", 177),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_SML_05", 178),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_MED_05", 179),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_P_MAL_C_LRG_05", 180),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_ENVIRONMENTSUIT", 181),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_TURRET", 182),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_TURRET2", 183),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_N_DARTHBAND", 184),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_FEM_WHITE", 185),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_FEM_BLACK", 186),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_FEM_OLD_ASIAN", 187),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_FEM_OLD_WHITE", 188),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_FEM_OLD_BLACK", 189),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_MAL_WHITE", 190),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_MAL_BLACK", 191),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_MAL_OLD_ASIAN", 192),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_MAL_OLD_WHITE", 193),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_COMMONER_MAL_OLD_BLACK", 194),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_CZERKA_OFFICER_WHITE", 195),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_CZERKA_OFFICER_BLACK", 196),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_CZERKA_OFFICER_OLD_ASIAN", 197),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_CZERKA_OFFICER_OLD_WHITE", 198),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_CZERKA_OFFICER_OLD_BLACK", 199),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_FEMALE_02", 200),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_FEMALE_03", 201),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_FEMALE_04", 202),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_FEMALE_05", 203),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_FEMALE_01", 204),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_FEMALE_02", 205),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_FEMALE_03", 206),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_FEMALE_04", 207),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_FEMALE_05", 208),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_FEMALE_01", 209),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_FEMALE_02", 210),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_FEMALE_03", 211),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_FEMALE_04", 212),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_FEMALE_05", 213),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_MALE_02", 214),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_MALE_03", 215),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_MALE_04", 216),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_MALE_05", 217),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_MALE_01", 218),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_MALE_02", 219),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_MALE_03", 220),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_MALE_04", 221),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_MALE_05", 222),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_MALE_01", 223),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_MALE_02", 224),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_MALE_03", 225),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_MALE_04", 226),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_MALE_05", 227),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_HUTT_02", 228),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_HUTT_03", 229),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_HUTT_04", 230),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_DROID_ASTRO_02", 231),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_DROID_ASTRO_03", 232),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_DROID_PROTOCOL_02", 233),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_DROID_PROTOCOL_03", 234),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_DROID_PROTOCOL_04", 235),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_DROID_WAR_02", 236),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_DROID_WAR_03", 237),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_DROID_WAR_04", 238),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_DROID_WAR_05", 239),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_GAMMOREAN_02", 240),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_GAMMOREAN_03", 241),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_GAMMOREAN_04", 242),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_ITHORIAN_02", 243),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_ITHORIAN_03", 244),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_KATH_HOUND_A02", 245),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_KATH_HOUND_A03", 246),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_KATH_HOUND_A04", 247),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_KATH_HOUND_B02", 248),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_KATH_HOUND_B03", 249),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_KATH_HOUND_B04", 250),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WRAID_02", 251),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WRAID_03", 252),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WRAID_04", 253),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_RAKATA_02", 254),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_RAKATA_03", 255),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_RODIAN_02", 256),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_RODIAN_03", 257),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_RODIAN_04", 258),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SELKATH_02", 259),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SELKATH_03", 260),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_SOLDIER_03", 261),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SWOOP_GANG_02", 262),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SWOOP_GANG_03", 263),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SWOOP_GANG_04", 264),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SWOOP_GANG_05", 265),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_TUSKAN_RAIDER_02", 266),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_TUSKAN_RAIDER_03", 267),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_TUSKAN_RAIDER_04", 268),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_TWILEK_MALE_02", 269),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_TWILEK_FEMALE_02", 270),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WOOKIE_MALE_02", 271),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WOOKIE_MALE_03", 272),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WOOKIE_MALE_04", 273),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WOOKIE_MALE_05", 274),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WOOKIE_FEMALE_02", 275),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WOOKIE_FEMALE_03", 276),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WOOKIE_FEMALE_04", 277),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_WOOKIE_FEMALE_05", 278),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_ENVIRONMENTSUIT_02", 279),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_YUTHURA_BAN", 280),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SHYRACK_01", 281),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SHYRACK_02", 282),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_REPUBLIC_SOLDIER_MAL_BLACK", 283),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_REPUBLIC_SOLDIER_MAL_OLD_ASIAN", 284),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_REPUBLIC_SOLDIER_MAL_OLD_WHITE", 285),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_REPUBLIC_SOLDIER_MAL_OLD_BLACK", 286),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_REPUBLIC_OFFICER_MAL_BLACK", 287),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_REPUBLIC_OFFICER_MAL_OLD_ASIAN", 288),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_REPUBLIC_OFFICER_MAL_OLD_WHITE", 289),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_REPUBLIC_OFFICER_MAL_OLD_BLACK", 290),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_FEM_WHITE", 291),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_FEM_BLACK", 292),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_FEM_OLD_ASIAN", 293),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_FEM_OLD_WHITE", 294),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_FEM_OLD_BLACK", 295),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_MAL_WHITE", 296),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_MAL_BLACK", 297),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_MAL_OLD_ASIAN", 298),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_MAL_OLD_WHITE", 299),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_MAL_OLD_BLACK", 300),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_FEM_ASIAN", 301),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_SITH_MAL_ASIAN", 302),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_OLD_MALE", 303),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_OLD_MALE", 304),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_OLD_MALE", 305),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_WHITE_OLD_FEM", 306),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_ASIAN_OLD_FEM", 307),
    ScriptConstant(DataType.INT, "DISGUISE_TYPE_JEDI_BLACK_OLD_FEM", 308),
    ScriptConstant(DataType.INT, "PLOT_O_DOOM", 0),
    ScriptConstant(DataType.INT, "PLOT_O_SCARY_STUFF", 1),
    ScriptConstant(DataType.INT, "PLOT_O_BIG_MONSTERS", 2),
    ScriptConstant(DataType.INT, "FORMATION_WEDGE", 0),
    ScriptConstant(DataType.INT, "FORMATION_LINE", 1),
    ScriptConstant(DataType.INT, "SUBSCREEN_ID_NONE", 0),
    ScriptConstant(DataType.INT, "SUBSCREEN_ID_EQUIP", 1),
    ScriptConstant(DataType.INT, "SUBSCREEN_ID_ITEM", 2),
    ScriptConstant(DataType.INT, "SUBSCREEN_ID_CHARACTER_RECORD", 3),
    ScriptConstant(DataType.INT, "SUBSCREEN_ID_ABILITY", 4),
    ScriptConstant(DataType.INT, "SUBSCREEN_ID_MAP", 5),
    ScriptConstant(DataType.INT, "SUBSCREEN_ID_QUEST", 6),
    ScriptConstant(DataType.INT, "SUBSCREEN_ID_OPTIONS", 7),
    ScriptConstant(DataType.INT, "SUBSCREEN_ID_MESSAGES", 8),
    ScriptConstant(DataType.INT, "SHIELD_DROID_ENERGY_1", 0),
    ScriptConstant(DataType.INT, "SHIELD_DROID_ENERGY_2", 1),
    ScriptConstant(DataType.INT, "SHIELD_DROID_ENERGY_3", 2),
    ScriptConstant(DataType.INT, "SHIELD_DROID_ENVIRO_1", 3),
    ScriptConstant(DataType.INT, "SHIELD_DROID_ENVIRO_2", 4),
    ScriptConstant(DataType.INT, "SHIELD_DROID_ENVIRO_3", 5),
    ScriptConstant(DataType.INT, "SHIELD_ENERGY", 6),
    ScriptConstant(DataType.INT, "SHIELD_ENERGY_SITH", 7),
    ScriptConstant(DataType.INT, "SHIELD_ENERGY_ARKANIAN", 8),
    ScriptConstant(DataType.INT, "SHIELD_ECHANI", 9),
    ScriptConstant(DataType.INT, "SHIELD_MANDALORIAN_MELEE", 10),
    ScriptConstant(DataType.INT, "SHIELD_MANDALORIAN_POWER", 11),
    ScriptConstant(DataType.INT, "SHIELD_DUELING_ECHANI", 12),
    ScriptConstant(DataType.INT, "SHIELD_DUELING_YUSANIS", 13),
    ScriptConstant(DataType.INT, "SHIELD_VERPINE_PROTOTYPE", 14),
    ScriptConstant(DataType.INT, "SHIELD_ANTIQUE_DROID", 15),
    ScriptConstant(DataType.INT, "SHIELD_PLOT_TAR_M09AA", 16),
    ScriptConstant(DataType.INT, "SHIELD_PLOT_UNK_M44AA", 17),
    ScriptConstant(DataType.INT, "SHIELD_PLOT_MAN_M28AA", 18),
    ScriptConstant(DataType.INT, "SHIELD_HEAT", 19),
    ScriptConstant(DataType.INT, "SHIELD_DREXL", 20),
    ScriptConstant(DataType.INT, "SUBRACE_NONE", 0),
    ScriptConstant(DataType.INT, "SUBRACE_WOOKIE", 1),
    ScriptConstant(DataType.INT, "VIDEO_EFFECT_NONE", -1),
    ScriptConstant(DataType.INT, "VIDEO_EFFECT_SECURITY_CAMERA", 0),
    ScriptConstant(DataType.INT, "VIDEO_EFFECT_FREELOOK_T3M4", 1),
    ScriptConstant(DataType.INT, "VIDEO_EFFECT_FREELOOK_HK47", 2),
    ScriptConstant(DataType.INT, "VIDEO_EFFECT_CLAIRVOYANCE", 3),
    ScriptConstant(DataType.INT, "VIDEO_EFFECT_FORCESIGHT", 4),
    ScriptConstant(DataType.INT, "VIDEO_EFFECT_VISAS_FREELOOK", 5),
    ScriptConstant(DataType.INT, "VIDEO_EFFECT_CLAIRVOYANCEFULL", 6),
    ScriptConstant(DataType.INT, "VIDEO_EFFECT_FURY_1", 7),
    ScriptConstant(DataType.INT, "VIDEO_EFFECT_FURY_2", 8),
    ScriptConstant(DataType.INT, "VIDEO_EFFECT_FURY_3", 9),
    ScriptConstant(DataType.INT, "VIDEO_FFECT_SECURITY_NO_LABEL", 10),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_START_SWOOP_RACE", 9),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_RETURN_TO_BASE", 40),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_TEMP1", 42),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_TEMP2", 43),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_TEMP3", 44),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_TEMP4", 45),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_TEMP5", 46),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_TEMP6", 47),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_TEMP7", 48),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_TEMP8", 49),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_TEMP9", 50),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_TEMP10", 51),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_TEMP11", 52),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_TEMP12", 53),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_TEMP13", 54),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_TEMP14", 55),
    ScriptConstant(DataType.INT, "TUTORIAL_WINDOW_TEMP15", 56),
    ScriptConstant(DataType.INT, "AI_LEVEL_VERY_HIGH", 4),
    ScriptConstant(DataType.INT, "AI_LEVEL_HIGH", 3),
    ScriptConstant(DataType.INT, "AI_LEVEL_NORMAL", 2),
    ScriptConstant(DataType.INT, "AI_LEVEL_LOW", 1),
    ScriptConstant(DataType.INT, "AI_LEVEL_VERY_LOW", 0),
    ScriptConstant(DataType.INT, "MOVEMENT_SPEED_PC", 0),
    ScriptConstant(DataType.INT, "MOVEMENT_SPEED_IMMOBILE", 1),
    ScriptConstant(DataType.INT, "MOVEMENT_SPEED_VERYSLOW", 2),
    ScriptConstant(DataType.INT, "MOVEMENT_SPEED_SLOW", 3),
    ScriptConstant(DataType.INT, "MOVEMENT_SPEED_NORMAL", 4),
    ScriptConstant(DataType.INT, "MOVEMENT_SPEED_FAST", 5),
    ScriptConstant(DataType.INT, "MOVEMENT_SPEED_VERYFAST", 6),
    ScriptConstant(DataType.INT, "MOVEMENT_SPEED_DEFAULT", 7),
    ScriptConstant(DataType.INT, "MOVEMENT_SPEED_DMFAST", 8),
    ScriptConstant(DataType.INT, "LIVE_CONTENT_PKG1", 1),
    ScriptConstant(DataType.INT, "LIVE_CONTENT_PKG2", 2),
    ScriptConstant(DataType.INT, "LIVE_CONTENT_PKG3", 3),
    ScriptConstant(DataType.INT, "LIVE_CONTENT_PKG4", 4),
    ScriptConstant(DataType.INT, "LIVE_CONTENT_PKG5", 5),
    ScriptConstant(DataType.INT, "LIVE_CONTENT_PKG6", 6),
    ScriptConstant(DataType.INT, "IMPLANT_NONE", 0),
    ScriptConstant(DataType.INT, "IMPLANT_REGEN", 1),
    ScriptConstant(DataType.INT, "IMPLANT_STR", 2),
    ScriptConstant(DataType.INT, "IMPLANT_END", 3),
    ScriptConstant(DataType.INT, "IMPLANT_AGI", 4),
    ScriptConstant(DataType.INT, "FORFEIT_NO_FORCE_POWERS", 1),
    ScriptConstant(DataType.INT, "FORFEIT_NO_ITEMS", 2),
    ScriptConstant(DataType.INT, "FORFEIT_NO_WEAPONS", 4),
    ScriptConstant(DataType.INT, "FORFEIT_DXUN_SWORD_ONLY", 8),
    ScriptConstant(DataType.INT, "FORFEIT_NO_ARMOR", 16),
    ScriptConstant(DataType.INT, "FORFEIT_NO_RANGED", 32),
    ScriptConstant(DataType.INT, "FORFEIT_NO_LIGHTSABER", 64),
    ScriptConstant(DataType.INT, "FORFEIT_NO_ITEM_BUT_SHIELD", 128),
]

KOTOR_FUNCTIONS = [
    ScriptFunction(
        DataType.INT,
        'Random',
        [ScriptParam(DataType.INT, 'nMaxInteger', None), ],
        '// 0: Get an integer between 0 and nMaxInteger-1.\r\n// Return value on error: 0\r\nint Random(int nMaxInteger);',
        '// 0: Get an integer between 0 and nMaxInteger-1.\r\n// Return value on error: 0\r\nint Random(int nMaxInteger);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PrintString',
        [ScriptParam(DataType.STRING, 'sString', None), ],
        '// 1: Output sString to the log file.\r\nvoid PrintString(string sString);',
        '// 1: Output sString to the log file.\r\nvoid PrintString(string sString);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PrintFloat',
        [ScriptParam(DataType.FLOAT, 'fFloat', None), ScriptParam(DataType.INT, 'nWidth', 18), ScriptParam(DataType.INT, 'nDecimals', 9), ],
        '// 2: Output a formatted float to the log file.\r\n// - nWidth should be a value from 0 to 18 inclusive.\r\n// - nDecimals should be a value from 0 to 9 inclusive.\r\nvoid PrintFloat(float fFloat, int nWidth = 18, int nDecimals = 9);',
        '// 2: Output a formatted float to the log file.\r\n// - nWidth should be a value from 0 to 18 inclusive.\r\n// - nDecimals should be a value from 0 to 9 inclusive.\r\nvoid PrintFloat(float fFloat, int nWidth = 18, int nDecimals = 9);'
    ),
    ScriptFunction(
        DataType.STRING,
        'FloatToString',
        [ScriptParam(DataType.FLOAT, 'fFloat', None), ScriptParam(DataType.INT, 'nWidth', 18), ScriptParam(DataType.INT, 'nDecimals', 9), ],
        '// 3: Convert fFloat into a string.\r\n// - nWidth should be a value from 0 to 18 inclusive.\r\n// - nDecimals should be a value from 0 to 9 inclusive.\r\nstring FloatToString(float fFloat, int nWidth = 18, int nDecimals = 9);',
        '// 3: Convert fFloat into a string.\r\n// - nWidth should be a value from 0 to 18 inclusive.\r\n// - nDecimals should be a value from 0 to 9 inclusive.\r\nstring FloatToString(float fFloat, int nWidth = 18, int nDecimals = 9);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PrintInteger',
        [ScriptParam(DataType.INT, 'nInteger', None), ],
        '// 4: Output nInteger to the log file.\r\nvoid PrintInteger(int nInteger);',
        '// 4: Output nInteger to the log file.\r\nvoid PrintInteger(int nInteger);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PrintObject',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        "// 5: Output oObject's ID to the log file.\r\nvoid PrintObject(object oObject);",
        "// 5: Output oObject's ID to the log file.\r\nvoid PrintObject(object oObject);"
    ),
    ScriptFunction(
        DataType.VOID,
        'AssignCommand',
        [ScriptParam(DataType.OBJECT, 'oActionSubject', None), ScriptParam(DataType.ACTION, 'aActionToAssign', None), ],
        '// 6: Assign aActionToAssign to oActionSubject.\r\n// * No return value, but if an error occurs, the log file will contain\r\n//   "AssignCommand failed."\r\n//   (If the object doesn\'t exist, nothing happens.)\r\nvoid AssignCommand(object oActionSubject,action aActionToAssign);',
        '// 6: Assign aActionToAssign to oActionSubject.\r\n// * No return value, but if an error occurs, the log file will contain\r\n//   "AssignCommand failed."\r\n//   (If the object doesn\'t exist, nothing happens.)\r\nvoid AssignCommand(object oActionSubject,action aActionToAssign);'
    ),
    ScriptFunction(
        DataType.VOID,
        'DelayCommand',
        [ScriptParam(DataType.FLOAT, 'fSeconds', None), ScriptParam(DataType.ACTION, 'aActionToDelay', None), ],
        '// 7: Delay aActionToDelay by fSeconds.\r\n// * No return value, but if an error occurs, the log file will contain\r\n//   "DelayCommand failed.".\r\nvoid DelayCommand(float fSeconds, action aActionToDelay);',
        '// 7: Delay aActionToDelay by fSeconds.\r\n// * No return value, but if an error occurs, the log file will contain\r\n//   "DelayCommand failed.".\r\nvoid DelayCommand(float fSeconds, action aActionToDelay);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ExecuteScript',
        [ScriptParam(DataType.STRING, 'sScript', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'nScriptVar', -1), ],
        '// 8: Make oTarget run sScript and then return execution to the calling script.\r\n// If sScript does not specify a compiled script, nothing happens.\r\n// - nScriptVar: This value will be returned by calls to GetRunScriptVar.\r\nvoid ExecuteScript(string sScript, object oTarget, int nScriptVar = -1);',
        '// 8: Make oTarget run sScript and then return execution to the calling script.\r\n// If sScript does not specify a compiled script, nothing happens.\r\n// - nScriptVar: This value will be returned by calls to GetRunScriptVar.\r\nvoid ExecuteScript(string sScript, object oTarget, int nScriptVar = -1);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ClearAllActions',
        [],
        '// 9: Clear all the actions of the caller. (This will only work on Creatures)\r\n// * No return value, but if an error occurs, the log file will contain\r\n//   "ClearAllActions failed.".\r\nvoid ClearAllActions();',
        '// 9: Clear all the actions of the caller. (This will only work on Creatures)\r\n// * No return value, but if an error occurs, the log file will contain\r\n//   "ClearAllActions failed.".\r\nvoid ClearAllActions();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetFacing',
        [ScriptParam(DataType.FLOAT, 'fDirection', None), ],
        '// 10: Cause the caller to face fDirection.\r\n// - fDirection is expressed as anticlockwise degrees from Due East.\r\n//   DIRECTION_EAST, DIRECTION_NORTH, DIRECTION_WEST and DIRECTION_SOUTH are\r\n//   predefined. (0.0f = East, 90.0f = North, 180.0f = West, 270.0f = South)\r\nvoid SetFacing(float fDirection);',
        '// 10: Cause the caller to face fDirection.\r\n// - fDirection is expressed as anticlockwise degrees from Due East.\r\n//   DIRECTION_EAST, DIRECTION_NORTH, DIRECTION_WEST and DIRECTION_SOUTH are\r\n//   predefined. (0.0f = East, 90.0f = North, 180.0f = West, 270.0f = South)\r\nvoid SetFacing(float fDirection);'
    ),
    ScriptFunction(
        DataType.INT,
        'SwitchPlayerCharacter',
        [ScriptParam(DataType.INT, 'nNPC', None), ],
        '// 11: Switches the main character to a specified NPC\r\n//     -1 specifies to switch back to the original PC\r\nint SwitchPlayerCharacter(int nNPC);',
        '// 11: Switches the main character to a specified NPC\r\n//     -1 specifies to switch back to the original PC\r\nint SwitchPlayerCharacter(int nNPC);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetTime',
        [ScriptParam(DataType.INT, 'nHour', None), ScriptParam(DataType.INT, 'nMinute', None), ScriptParam(DataType.INT, 'nSecond', None), ScriptParam(DataType.INT, 'nMillisecond', None), ],
        '// 12: Set the time to the time specified.\r\n// - nHour should be from 0 to 23 inclusive\r\n// - nMinute should be from 0 to 59 inclusive\r\n// - nSecond should be from 0 to 59 inclusive\r\n// - nMillisecond should be from 0 to 999 inclusive\r\n// 1) Time can only be advanced forwards; attempting to set the time backwards\r\n//    will result in the day advancing and then the time being set to that\r\n//    specified, e.g. if the current hour is 15 and then the hour is set to 3,\r\n//    the day will be advanced by 1 and the hour will be set to 3.\r\n// 2) If values larger than the max hour, minute, second or millisecond are\r\n//    specified, they will be wrapped around and the overflow will be used to\r\n//    advance the next field, e.g. specifying 62 hours, 250 minutes, 10 seconds\r\n//    and 10 milliseconds will result in the calendar day being advanced by 2\r\n//    and the time being set to 18 hours, 10 minutes, 10 milliseconds.\r\nvoid SetTime(int nHour,int nMinute,int nSecond,int nMillisecond);',
        '// 12: Set the time to the time specified.\r\n// - nHour should be from 0 to 23 inclusive\r\n// - nMinute should be from 0 to 59 inclusive\r\n// - nSecond should be from 0 to 59 inclusive\r\n// - nMillisecond should be from 0 to 999 inclusive\r\n// 1) Time can only be advanced forwards; attempting to set the time backwards\r\n//    will result in the day advancing and then the time being set to that\r\n//    specified, e.g. if the current hour is 15 and then the hour is set to 3,\r\n//    the day will be advanced by 1 and the hour will be set to 3.\r\n// 2) If values larger than the max hour, minute, second or millisecond are\r\n//    specified, they will be wrapped around and the overflow will be used to\r\n//    advance the next field, e.g. specifying 62 hours, 250 minutes, 10 seconds\r\n//    and 10 milliseconds will result in the calendar day being advanced by 2\r\n//    and the time being set to 18 hours, 10 minutes, 10 milliseconds.\r\nvoid SetTime(int nHour,int nMinute,int nSecond,int nMillisecond);'
    ),
    ScriptFunction(
        DataType.INT,
        'SetPartyLeader',
        [ScriptParam(DataType.INT, 'nNPC', None), ],
        '// 13: Sets (by NPC constant) which party member should be the controlled\r\n//     character\r\nint SetPartyLeader(int nNPC);',
        '// 13: Sets (by NPC constant) which party member should be the controlled\r\n//     character\r\nint SetPartyLeader(int nNPC);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetAreaUnescapable',
        [ScriptParam(DataType.INT, 'bUnescapable', None), ],
        '// 14: Sets whether the current area is escapable or not\r\n// TRUE means you can not escape the area\r\n// FALSE means you can escape the area\r\nvoid SetAreaUnescapable(int bUnescapable);',
        '// 14: Sets whether the current area is escapable or not\r\n// TRUE means you can not escape the area\r\n// FALSE means you can escape the area\r\nvoid SetAreaUnescapable(int bUnescapable);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetAreaUnescapable',
        [],
        '// 15: Returns whether the current area is escapable or not\r\n// TRUE means you can not escape the area\r\n// FALSE means you can escape the area\r\nint GetAreaUnescapable();',
        '// 15: Returns whether the current area is escapable or not\r\n// TRUE means you can not escape the area\r\n// FALSE means you can escape the area\r\nint GetAreaUnescapable();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTimeHour',
        [],
        '// 16: Get the current hour.\r\nint GetTimeHour();',
        '// 16: Get the current hour.\r\nint GetTimeHour();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTimeMinute',
        [],
        '// 17: Get the current minute\r\nint GetTimeMinute();',
        '// 17: Get the current minute\r\nint GetTimeMinute();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTimeSecond',
        [],
        '// 18: Get the current second\r\nint GetTimeSecond();',
        '// 18: Get the current second\r\nint GetTimeSecond();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTimeMillisecond',
        [],
        '// 19: Get the current millisecond\r\nint GetTimeMillisecond();',
        '// 19: Get the current millisecond\r\nint GetTimeMillisecond();'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionRandomWalk',
        [],
        '// 20: The action subject will generate a random location near its current location\r\n// and pathfind to it.  All commands will remove a RandomWalk() from the action\r\n// queue if there is one in place.\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionRandomWalk failed."\r\nvoid ActionRandomWalk();',
        '// 20: The action subject will generate a random location near its current location\r\n// and pathfind to it.  All commands will remove a RandomWalk() from the action\r\n// queue if there is one in place.\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionRandomWalk failed."\r\nvoid ActionRandomWalk();'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionMoveToLocation',
        [ScriptParam(DataType.LOCATION, 'lDestination', None), ScriptParam(DataType.INT, 'bRun', 0), ],
        '// 21: The action subject will move to lDestination.\r\n// - lDestination: The object will move to this location.  If the location is\r\n//   invalid or a path cannot be found to it, the command does nothing.\r\n// - bRun: If this is TRUE, the action subject will run rather than walk\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "MoveToPoint failed."\r\nvoid ActionMoveToLocation(location lDestination, int bRun = FALSE);',
        '// 21: The action subject will move to lDestination.\r\n// - lDestination: The object will move to this location.  If the location is\r\n//   invalid or a path cannot be found to it, the command does nothing.\r\n// - bRun: If this is TRUE, the action subject will run rather than walk\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "MoveToPoint failed."\r\nvoid ActionMoveToLocation(location lDestination, int bRun = FALSE);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionMoveToObject',
        [ScriptParam(DataType.OBJECT, 'oMoveTo', None), ScriptParam(DataType.INT, 'bRun', 0), ScriptParam(DataType.FLOAT, 'fRange', 1.0), ],
        '// 22: Cause the action subject to move to a certain distance from oMoveTo.\r\n// If there is no path to oMoveTo, this command will do nothing.\r\n// - oMoveTo: This is the object we wish the action subject to move to\r\n// - bRun: If this is TRUE, the action subject will run rather than walk\r\n// - fRange: This is the desired distance between the action subject and oMoveTo\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionMoveToObject failed."\r\nvoid ActionMoveToObject(object oMoveTo, int bRun = FALSE, float fRange = 1.0f);',
        '// 22: Cause the action subject to move to a certain distance from oMoveTo.\r\n// If there is no path to oMoveTo, this command will do nothing.\r\n// - oMoveTo: This is the object we wish the action subject to move to\r\n// - bRun: If this is TRUE, the action subject will run rather than walk\r\n// - fRange: This is the desired distance between the action subject and oMoveTo\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionMoveToObject failed."\r\nvoid ActionMoveToObject(object oMoveTo, int bRun = FALSE, float fRange = 1.0f);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionMoveAwayFromObject',
        [ScriptParam(DataType.OBJECT, 'oFleeFrom', None), ScriptParam(DataType.INT, 'bRun', 0), ScriptParam(DataType.FLOAT, 'fMoveAwayRange', 40.0), ],
        '// 23: Cause the action subject to move to a certain distance away from oFleeFrom.\r\n// - oFleeFrom: This is the object we wish the action subject to move away from.\r\n//   If oFleeFrom is not in the same area as the action subject, nothing will\r\n//   happen.\r\n// - bRun: If this is TRUE, the action subject will run rather than walk\r\n// - fMoveAwayRange: This is the distance we wish the action subject to put\r\n//   between themselves and oFleeFrom\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionMoveAwayFromObject failed."\r\nvoid ActionMoveAwayFromObject(object oFleeFrom, int bRun = FALSE, float fMoveAwayRange = 40.0f);',
        '// 23: Cause the action subject to move to a certain distance away from oFleeFrom.\r\n// - oFleeFrom: This is the object we wish the action subject to move away from.\r\n//   If oFleeFrom is not in the same area as the action subject, nothing will\r\n//   happen.\r\n// - bRun: If this is TRUE, the action subject will run rather than walk\r\n// - fMoveAwayRange: This is the distance we wish the action subject to put\r\n//   between themselves and oFleeFrom\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionMoveAwayFromObject failed."\r\nvoid ActionMoveAwayFromObject(object oFleeFrom, int bRun = FALSE, float fMoveAwayRange = 40.0f);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetArea',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 24: Get the area that oTarget is currently in\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetArea(object oTarget);',
        '// 24: Get the area that oTarget is currently in\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetArea(object oTarget);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetEnteringObject',
        [],
        '// 25: The value returned by this function depends on the object type of the caller:\r\n// 1) If the caller is a door or placeable it returns the object that last\r\n//    triggered it.\r\n// 2) If the caller is a trigger, area of effect, module, area or encounter it\r\n//    returns the object that last entered it.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetEnteringObject();',
        '// 25: The value returned by this function depends on the object type of the caller:\r\n// 1) If the caller is a door or placeable it returns the object that last\r\n//    triggered it.\r\n// 2) If the caller is a trigger, area of effect, module, area or encounter it\r\n//    returns the object that last entered it.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetEnteringObject();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetExitingObject',
        [],
        '// 26: Get the object that last left the caller.  This function works on triggers,\r\n// areas of effect, modules, areas and encounters.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetExitingObject();',
        '// 26: Get the object that last left the caller.  This function works on triggers,\r\n// areas of effect, modules, areas and encounters.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetExitingObject();'
    ),
    ScriptFunction(
        DataType.VECTOR,
        'GetPosition',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 27: Get the position of oTarget\r\n// * Return value on error: vector (0.0f, 0.0f, 0.0f)\r\nvector GetPosition(object oTarget);',
        '// 27: Get the position of oTarget\r\n// * Return value on error: vector (0.0f, 0.0f, 0.0f)\r\nvector GetPosition(object oTarget);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetFacing',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 28: Get the direction in which oTarget is facing, expressed as a float between\r\n// 0.0f and 360.0f\r\n// * Return value on error: -1.0f\r\nfloat GetFacing(object oTarget);',
        '// 28: Get the direction in which oTarget is facing, expressed as a float between\r\n// 0.0f and 360.0f\r\n// * Return value on error: -1.0f\r\nfloat GetFacing(object oTarget);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetItemPossessor',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 29: Get the possessor of oItem\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetItemPossessor(object oItem);',
        '// 29: Get the possessor of oItem\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetItemPossessor(object oItem);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetItemPossessedBy',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.STRING, 'sItemTag', None), ],
        '// 30: Get the object possessed by oCreature with the tag sItemTag\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetItemPossessedBy(object oCreature, string sItemTag);',
        '// 30: Get the object possessed by oCreature with the tag sItemTag\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetItemPossessedBy(object oCreature, string sItemTag);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'CreateItemOnObject',
        [ScriptParam(DataType.STRING, 'sItemTemplate', None), ScriptParam(DataType.OBJECT, 'oTarget', 0), ScriptParam(DataType.INT, 'nStackSize', 1), ],
        "// 31: Create an item with the template sItemTemplate in oTarget's inventory.\r\n// - nStackSize: This is the stack size of the item to be created\r\n// * Return value: The object that has been created.  On error, this returns\r\n//   OBJECT_INVALID.\r\nobject CreateItemOnObject(string sItemTemplate, object oTarget = OBJECT_SELF, int nStackSize = 1);",
        "// 31: Create an item with the template sItemTemplate in oTarget's inventory.\r\n// - nStackSize: This is the stack size of the item to be created\r\n// * Return value: The object that has been created.  On error, this returns\r\n//   OBJECT_INVALID.\r\nobject CreateItemOnObject(string sItemTemplate, object oTarget = OBJECT_SELF, int nStackSize = 1);"
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionEquipItem',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.INT, 'nInventorySlot', None), ScriptParam(DataType.INT, 'bInstant', 0), ],
        '// 32: Equip oItem into nInventorySlot.\r\n// - nInventorySlot: INVENTORY_SLOT_*\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionEquipItem failed."\r\nvoid ActionEquipItem(object oItem, int nInventorySlot, int bInstant = FALSE);',
        '// 32: Equip oItem into nInventorySlot.\r\n// - nInventorySlot: INVENTORY_SLOT_*\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionEquipItem failed."\r\nvoid ActionEquipItem(object oItem, int nInventorySlot, int bInstant = FALSE);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionUnequipItem',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.INT, 'bInstant', 0), ],
        '// 33: Unequip oItem from whatever slot it is currently in.\r\nvoid ActionUnequipItem( object oItem, int bInstant  =  FALSE );',
        '// 33: Unequip oItem from whatever slot it is currently in.\r\nvoid ActionUnequipItem( object oItem, int bInstant  =  FALSE );'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionPickUpItem',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 34: Pick up oItem from the ground.\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionPickUpItem failed."\r\nvoid ActionPickUpItem(object oItem);',
        '// 34: Pick up oItem from the ground.\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionPickUpItem failed."\r\nvoid ActionPickUpItem(object oItem);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionPutDownItem',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 35: Put down oItem on the ground.\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionPutDownItem failed."\r\nvoid ActionPutDownItem(object oItem);',
        '// 35: Put down oItem on the ground.\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionPutDownItem failed."\r\nvoid ActionPutDownItem(object oItem);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastAttacker',
        [ScriptParam(DataType.OBJECT, 'oAttackee', 0), ],
        '// 36: Get the last attacker of oAttackee.  This should only be used ONLY in the\r\n// OnAttacked events for creatures, placeables and doors.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetLastAttacker(object oAttackee = OBJECT_SELF);',
        '// 36: Get the last attacker of oAttackee.  This should only be used ONLY in the\r\n// OnAttacked events for creatures, placeables and doors.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetLastAttacker(object oAttackee = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionAttack',
        [ScriptParam(DataType.OBJECT, 'oAttackee', None), ScriptParam(DataType.INT, 'bPassive', 0), ],
        '// 37: Attack oAttackee.\r\n// - bPassive: If this is TRUE, attack is in passive mode.\r\nvoid ActionAttack(object oAttackee, int bPassive = FALSE);',
        '// 37: Attack oAttackee.\r\n// - bPassive: If this is TRUE, attack is in passive mode.\r\nvoid ActionAttack(object oAttackee, int bPassive = FALSE);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNearestCreature',
        [ScriptParam(DataType.INT, 'nFirstCriteriaType', None), ScriptParam(DataType.INT, 'nFirstCriteriaValue', None), ScriptParam(DataType.OBJECT, 'oTarget', 0), ScriptParam(DataType.INT, 'nNth', 1), ScriptParam(DataType.INT, 'nSecondCriteriaType', -1), ScriptParam(DataType.INT, 'nSecondCriteriaValue', -1), ScriptParam(DataType.INT, 'nThirdCriteriaType', -1), ScriptParam(DataType.INT, 'nThirdCriteriaValue', -1), ],
        "// 38: Get the creature nearest to oTarget, subject to all the criteria specified.\r\n// - nFirstCriteriaType: CREATURE_TYPE_*\r\n// - nFirstCriteriaValue:\r\n//   -> CLASS_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_CLASS\r\n//   -> SPELL_* if nFirstCriteriaType was CREATURE_TYPE_DOES_NOT_HAVE_SPELL_EFFECT\r\n//      or CREATURE_TYPE_HAS_SPELL_EFFECT\r\n//   -> TRUE or FALSE if nFirstCriteriaType was CREATURE_TYPE_IS_ALIVE\r\n//   -> PERCEPTION_* if nFirstCriteriaType was CREATURE_TYPE_PERCEPTION\r\n//   -> PLAYER_CHAR_IS_PC or PLAYER_CHAR_NOT_PC if nFirstCriteriaType was\r\n//      CREATURE_TYPE_PLAYER_CHAR\r\n//   -> RACIAL_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_RACIAL_TYPE\r\n//   -> REPUTATION_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_REPUTATION\r\n//   For example, to get the nearest PC, use:\r\n//   (CREATURE_TYPE_PLAYER_CHAR, PLAYER_CHAR_IS_PC)\r\n// - oTarget: We're trying to find the creature of the specified type that is\r\n//   nearest to oTarget\r\n// - nNth: We don't have to find the first nearest: we can find the Nth nearest...\r\n// - nSecondCriteriaType: This is used in the same way as nFirstCriteriaType to\r\n//   further specify the type of creature that we are looking for.\r\n// - nSecondCriteriaValue: This is used in the same way as nFirstCriteriaValue\r\n//   to further specify the type of creature that we are looking for.\r\n// - nThirdCriteriaType: This is used in the same way as nFirstCriteriaType to\r\n//   further specify the type of creature that we are looking for.\r\n// - nThirdCriteriaValue: This is used in the same way as nFirstCriteriaValue to\r\n//   further specify the type of creature that we are looking for.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestCreature(int nFirstCriteriaType, int nFirstCriteriaValue, object oTarget = OBJECT_SELF, int nNth = 1, int nSecondCriteriaType = -1, int nSecondCriteriaValue = -1, int nThirdCriteriaType = -1,  int nThirdCriteriaValue = -1 );",
        "// 38: Get the creature nearest to oTarget, subject to all the criteria specified.\r\n// - nFirstCriteriaType: CREATURE_TYPE_*\r\n// - nFirstCriteriaValue:\r\n//   -> CLASS_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_CLASS\r\n//   -> SPELL_* if nFirstCriteriaType was CREATURE_TYPE_DOES_NOT_HAVE_SPELL_EFFECT\r\n//      or CREATURE_TYPE_HAS_SPELL_EFFECT\r\n//   -> TRUE or FALSE if nFirstCriteriaType was CREATURE_TYPE_IS_ALIVE\r\n//   -> PERCEPTION_* if nFirstCriteriaType was CREATURE_TYPE_PERCEPTION\r\n//   -> PLAYER_CHAR_IS_PC or PLAYER_CHAR_NOT_PC if nFirstCriteriaType was\r\n//      CREATURE_TYPE_PLAYER_CHAR\r\n//   -> RACIAL_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_RACIAL_TYPE\r\n//   -> REPUTATION_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_REPUTATION\r\n//   For example, to get the nearest PC, use:\r\n//   (CREATURE_TYPE_PLAYER_CHAR, PLAYER_CHAR_IS_PC)\r\n// - oTarget: We're trying to find the creature of the specified type that is\r\n//   nearest to oTarget\r\n// - nNth: We don't have to find the first nearest: we can find the Nth nearest...\r\n// - nSecondCriteriaType: This is used in the same way as nFirstCriteriaType to\r\n//   further specify the type of creature that we are looking for.\r\n// - nSecondCriteriaValue: This is used in the same way as nFirstCriteriaValue\r\n//   to further specify the type of creature that we are looking for.\r\n// - nThirdCriteriaType: This is used in the same way as nFirstCriteriaType to\r\n//   further specify the type of creature that we are looking for.\r\n// - nThirdCriteriaValue: This is used in the same way as nFirstCriteriaValue to\r\n//   further specify the type of creature that we are looking for.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestCreature(int nFirstCriteriaType, int nFirstCriteriaValue, object oTarget = OBJECT_SELF, int nNth = 1, int nSecondCriteriaType = -1, int nSecondCriteriaValue = -1, int nThirdCriteriaType = -1,  int nThirdCriteriaValue = -1 );"
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionSpeakString',
        [ScriptParam(DataType.STRING, 'sStringToSpeak', None), ScriptParam(DataType.INT, 'nTalkVolume', 0), ],
        '// 39: Add a speak action to the action subject.\r\n// - sStringToSpeak: String to be spoken\r\n// - nTalkVolume: TALKVOLUME_*\r\nvoid ActionSpeakString(string sStringToSpeak, int nTalkVolume = TALKVOLUME_TALK);',
        '// 39: Add a speak action to the action subject.\r\n// - sStringToSpeak: String to be spoken\r\n// - nTalkVolume: TALKVOLUME_*\r\nvoid ActionSpeakString(string sStringToSpeak, int nTalkVolume = TALKVOLUME_TALK);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionPlayAnimation',
        [ScriptParam(DataType.INT, 'nAnimation', None), ScriptParam(DataType.FLOAT, 'fSpeed', 1.0), ScriptParam(DataType.FLOAT, 'fDurationSeconds', 0.0), ],
        '// 40: Cause the action subject to play an animation\r\n// - nAnimation: ANIMATION_*\r\n// - fSpeed: Speed of the animation\r\n// - fDurationSeconds: Duration of the animation (this is not used for Fire and\r\n//   Forget animations) If a time of -1.0f is specified for a looping animation\r\n//   it will loop until the next animation is applied.\r\nvoid ActionPlayAnimation(int nAnimation, float fSpeed = 1.0, float fDurationSeconds = 0.0);',
        '// 40: Cause the action subject to play an animation\r\n// - nAnimation: ANIMATION_*\r\n// - fSpeed: Speed of the animation\r\n// - fDurationSeconds: Duration of the animation (this is not used for Fire and\r\n//   Forget animations) If a time of -1.0f is specified for a looping animation\r\n//   it will loop until the next animation is applied.\r\nvoid ActionPlayAnimation(int nAnimation, float fSpeed = 1.0, float fDurationSeconds = 0.0);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetDistanceToObject',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 41: Get the distance from the caller to oObject in metres.\r\n// * Return value on error: -1.0f\r\nfloat GetDistanceToObject(object oObject);',
        '// 41: Get the distance from the caller to oObject in metres.\r\n// * Return value on error: -1.0f\r\nfloat GetDistanceToObject(object oObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsObjectValid',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 42: * Returns TRUE if oObject is a valid object.\r\nint GetIsObjectValid(object oObject);',
        '// 42: * Returns TRUE if oObject is a valid object.\r\nint GetIsObjectValid(object oObject);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionOpenDoor',
        [ScriptParam(DataType.OBJECT, 'oDoor', None), ],
        '// 43: Cause the action subject to open oDoor\r\nvoid ActionOpenDoor(object oDoor);',
        '// 43: Cause the action subject to open oDoor\r\nvoid ActionOpenDoor(object oDoor);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionCloseDoor',
        [ScriptParam(DataType.OBJECT, 'oDoor', None), ],
        '// 44: Cause the action subject to close oDoor\r\nvoid ActionCloseDoor(object oDoor);',
        '// 44: Cause the action subject to close oDoor\r\nvoid ActionCloseDoor(object oDoor);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetCameraFacing',
        [ScriptParam(DataType.FLOAT, 'fDirection', None), ],
        '// 45: Change the direction in which the camera is facing\r\n// - fDirection is expressed as anticlockwise degrees from Due East.\r\n//   (0.0f = East, 90.0f = North, 180.0f = West, 270.0f = South)\r\n// This can be used to change the way the camera is facing after the player\r\n// emerges from an area transition.\r\nvoid SetCameraFacing(float fDirection);',
        '// 45: Change the direction in which the camera is facing\r\n// - fDirection is expressed as anticlockwise degrees from Due East.\r\n//   (0.0f = East, 90.0f = North, 180.0f = West, 270.0f = South)\r\n// This can be used to change the way the camera is facing after the player\r\n// emerges from an area transition.\r\nvoid SetCameraFacing(float fDirection);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PlaySound',
        [ScriptParam(DataType.STRING, 'sSoundName', None), ],
        '// 46: Play sSoundName\r\n// - sSoundName: TBD - SS\r\nvoid PlaySound(string sSoundName);',
        '// 46: Play sSoundName\r\n// - sSoundName: TBD - SS\r\nvoid PlaySound(string sSoundName);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetSpellTargetObject',
        [],
        '// 47: Get the object at which the caller last cast a spell\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetSpellTargetObject();',
        '// 47: Get the object at which the caller last cast a spell\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetSpellTargetObject();'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionCastSpellAtObject',
        [ScriptParam(DataType.INT, 'nSpell', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'nMetaMagic', 0), ScriptParam(DataType.INT, 'bCheat', 0), ScriptParam(DataType.INT, 'nDomainLevel', 0), ScriptParam(DataType.INT, 'nProjectilePathType', 0), ScriptParam(DataType.INT, 'bInstantSpell', 0), ],
        "// 48: This action casts a spell at oTarget.\r\n// - nSpell: SPELL_*\r\n// - oTarget: Target for the spell\r\n// - nMetamagic: METAMAGIC_*\r\n// - bCheat: If this is TRUE, then the executor of the action doesn't have to be\r\n//   able to cast the spell.\r\n// - nDomainLevel: TBD - SS\r\n// - nProjectilePathType: PROJECTILE_PATH_TYPE_*\r\n// - bInstantSpell: If this is TRUE, the spell is cast immediately. This allows\r\n//   the end-user to simulate a high-level magic-user having lots of advance\r\n//   warning of impending trouble\r\nvoid ActionCastSpellAtObject(int nSpell, object oTarget, int nMetaMagic = 0 , int bCheat = FALSE, int nDomainLevel = 0, int nProjectilePathType = PROJECTILE_PATH_TYPE_DEFAULT, int bInstantSpell = FALSE);",
        "// 48: This action casts a spell at oTarget.\r\n// - nSpell: SPELL_*\r\n// - oTarget: Target for the spell\r\n// - nMetamagic: METAMAGIC_*\r\n// - bCheat: If this is TRUE, then the executor of the action doesn't have to be\r\n//   able to cast the spell.\r\n// - nDomainLevel: TBD - SS\r\n// - nProjectilePathType: PROJECTILE_PATH_TYPE_*\r\n// - bInstantSpell: If this is TRUE, the spell is cast immediately. This allows\r\n//   the end-user to simulate a high-level magic-user having lots of advance\r\n//   warning of impending trouble\r\nvoid ActionCastSpellAtObject(int nSpell, object oTarget, int nMetaMagic = 0 , int bCheat = FALSE, int nDomainLevel = 0, int nProjectilePathType = PROJECTILE_PATH_TYPE_DEFAULT, int bInstantSpell = FALSE);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetCurrentHitPoints',
        [ScriptParam(DataType.OBJECT, 'oObject', 0), ],
        '// 49: Get the current hitpoints of oObject\r\n// * Return value on error: 0\r\nint GetCurrentHitPoints(object oObject = OBJECT_SELF);',
        '// 49: Get the current hitpoints of oObject\r\n// * Return value on error: 0\r\nint GetCurrentHitPoints(object oObject = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetMaxHitPoints',
        [ScriptParam(DataType.OBJECT, 'oObject', 0), ],
        '// 50: Get the maximum hitpoints of oObject\r\n// * Return value on error: 0\r\nint GetMaxHitPoints(object oObject = OBJECT_SELF);',
        '// 50: Get the maximum hitpoints of oObject\r\n// * Return value on error: 0\r\nint GetMaxHitPoints(object oObject = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectAssuredHit',
        [],
        '// 51: EffectAssuredHit\r\n// Create an Assured Hit effect, which guarantees that all attacks are successful\r\neffect EffectAssuredHit();',
        '// 51: EffectAssuredHit\r\n// Create an Assured Hit effect, which guarantees that all attacks are successful\r\neffect EffectAssuredHit();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastItemEquipped',
        [],
        '// 52:\r\n// Returns the last item that was equipped by a creature.\r\nobject GetLastItemEquipped();',
        '// 52:\r\n// Returns the last item that was equipped by a creature.\r\nobject GetLastItemEquipped();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetSubScreenID',
        [],
        '// 53:\r\n// Returns the ID of the subscreen that is currently onscreen.  This will be one of the\r\n// SUBSCREEN_ID_* constant values.\r\nint GetSubScreenID();',
        '// 53:\r\n// Returns the ID of the subscreen that is currently onscreen.  This will be one of the\r\n// SUBSCREEN_ID_* constant values.\r\nint GetSubScreenID();'
    ),
    ScriptFunction(
        DataType.VOID,
        'CancelCombat',
        [ScriptParam(DataType.OBJECT, 'oidCreature', None), ],
        '// 54:\r\n// Cancels combat for the specified creature.\r\nvoid CancelCombat( object oidCreature );',
        '// 54:\r\n// Cancels combat for the specified creature.\r\nvoid CancelCombat( object oidCreature );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetCurrentForcePoints',
        [ScriptParam(DataType.OBJECT, 'oObject', 0), ],
        '// 55:\r\n// returns the current force points for the creature\r\nint GetCurrentForcePoints(object oObject = OBJECT_SELF);',
        '// 55:\r\n// returns the current force points for the creature\r\nint GetCurrentForcePoints(object oObject = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetMaxForcePoints',
        [ScriptParam(DataType.OBJECT, 'oObject', 0), ],
        '// 56:\r\n// returns the Max force points for the creature\r\nint GetMaxForcePoints(object oObject = OBJECT_SELF);',
        '// 56:\r\n// returns the Max force points for the creature\r\nint GetMaxForcePoints(object oObject = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PauseGame',
        [ScriptParam(DataType.INT, 'bPause', None), ],
        '// 57:\r\n// Pauses the game if bPause is TRUE.  Unpauses if bPause is FALSE.\r\nvoid PauseGame( int bPause );',
        '// 57:\r\n// Pauses the game if bPause is TRUE.  Unpauses if bPause is FALSE.\r\nvoid PauseGame( int bPause );'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetPlayerRestrictMode',
        [ScriptParam(DataType.INT, 'bRestrict', None), ],
        "// 58: SetPlayerRestrictMode\r\n// Sets whether the player is currently in 'restricted' mode\r\nvoid SetPlayerRestrictMode( int bRestrict );",
        "// 58: SetPlayerRestrictMode\r\n// Sets whether the player is currently in 'restricted' mode\r\nvoid SetPlayerRestrictMode( int bRestrict );"
    ),
    ScriptFunction(
        DataType.INT,
        'GetStringLength',
        [ScriptParam(DataType.STRING, 'sString', None), ],
        '// 59: Get the length of sString\r\n// * Return value on error: -1\r\nint GetStringLength(string sString);',
        '// 59: Get the length of sString\r\n// * Return value on error: -1\r\nint GetStringLength(string sString);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetStringUpperCase',
        [ScriptParam(DataType.STRING, 'sString', None), ],
        '// 60: Convert sString into upper case\r\n// * Return value on error: ""\r\nstring GetStringUpperCase(string sString);',
        '// 60: Convert sString into upper case\r\n// * Return value on error: ""\r\nstring GetStringUpperCase(string sString);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetStringLowerCase',
        [ScriptParam(DataType.STRING, 'sString', None), ],
        '// 61: Convert sString into lower case\r\n// * Return value on error: ""\r\nstring GetStringLowerCase(string sString);',
        '// 61: Convert sString into lower case\r\n// * Return value on error: ""\r\nstring GetStringLowerCase(string sString);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetStringRight',
        [ScriptParam(DataType.STRING, 'sString', None), ScriptParam(DataType.INT, 'nCount', None), ],
        '// 62: Get nCount characters from the right end of sString\r\n// * Return value on error: ""\r\nstring GetStringRight(string sString, int nCount);',
        '// 62: Get nCount characters from the right end of sString\r\n// * Return value on error: ""\r\nstring GetStringRight(string sString, int nCount);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetStringLeft',
        [ScriptParam(DataType.STRING, 'sString', None), ScriptParam(DataType.INT, 'nCount', None), ],
        '// 63: Get nCounter characters from the left end of sString\r\n// * Return value on error: ""\r\nstring GetStringLeft(string sString, int nCount);',
        '// 63: Get nCounter characters from the left end of sString\r\n// * Return value on error: ""\r\nstring GetStringLeft(string sString, int nCount);'
    ),
    ScriptFunction(
        DataType.STRING,
        'InsertString',
        [ScriptParam(DataType.STRING, 'sDestination', None), ScriptParam(DataType.STRING, 'sString', None), ScriptParam(DataType.INT, 'nPosition', None), ],
        '// 64: Insert sString into sDestination at nPosition\r\n// * Return value on error: ""\r\nstring InsertString(string sDestination, string sString, int nPosition);',
        '// 64: Insert sString into sDestination at nPosition\r\n// * Return value on error: ""\r\nstring InsertString(string sDestination, string sString, int nPosition);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetSubString',
        [ScriptParam(DataType.STRING, 'sString', None), ScriptParam(DataType.INT, 'nStart', None), ScriptParam(DataType.INT, 'nCount', None), ],
        '// 65: Get nCount characters from sString, starting at nStart\r\n// * Return value on error: ""\r\nstring GetSubString(string sString, int nStart, int nCount);',
        '// 65: Get nCount characters from sString, starting at nStart\r\n// * Return value on error: ""\r\nstring GetSubString(string sString, int nStart, int nCount);'
    ),
    ScriptFunction(
        DataType.INT,
        'FindSubString',
        [ScriptParam(DataType.STRING, 'sString', None), ScriptParam(DataType.STRING, 'sSubString', None), ],
        '// 66: Find the position of sSubstring inside sString\r\n// * Return value on error: -1\r\nint FindSubString(string sString, string sSubString);',
        '// 66: Find the position of sSubstring inside sString\r\n// * Return value on error: -1\r\nint FindSubString(string sString, string sSubString);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'fabs',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ],
        '// 67: Maths operation: absolute value of fValue\r\nfloat fabs(float fValue);',
        '// 67: Maths operation: absolute value of fValue\r\nfloat fabs(float fValue);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'cos',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ],
        '// 68: Maths operation: cosine of fValue\r\nfloat cos(float fValue);',
        '// 68: Maths operation: cosine of fValue\r\nfloat cos(float fValue);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'sin',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ],
        '// 69: Maths operation: sine of fValue\r\nfloat sin(float fValue);',
        '// 69: Maths operation: sine of fValue\r\nfloat sin(float fValue);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'tan',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ],
        '// 70: Maths operation: tan of fValue\r\nfloat tan(float fValue);',
        '// 70: Maths operation: tan of fValue\r\nfloat tan(float fValue);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'acos',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ],
        '// 71: Maths operation: arccosine of fValue\r\n// * Returns zero if fValue > 1 or fValue < -1\r\nfloat acos(float fValue);',
        '// 71: Maths operation: arccosine of fValue\r\n// * Returns zero if fValue > 1 or fValue < -1\r\nfloat acos(float fValue);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'asin',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ],
        '// 72: Maths operation: arcsine of fValue\r\n// * Returns zero if fValue >1 or fValue < -1\r\nfloat asin(float fValue);',
        '// 72: Maths operation: arcsine of fValue\r\n// * Returns zero if fValue >1 or fValue < -1\r\nfloat asin(float fValue);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'atan',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ],
        '// 73: Maths operation: arctan of fValue\r\nfloat atan(float fValue);',
        '// 73: Maths operation: arctan of fValue\r\nfloat atan(float fValue);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'log',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ],
        '// 74: Maths operation: log of fValue\r\n// * Returns zero if fValue < =  zero\r\nfloat log(float fValue);',
        '// 74: Maths operation: log of fValue\r\n// * Returns zero if fValue < =  zero\r\nfloat log(float fValue);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'pow',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ScriptParam(DataType.FLOAT, 'fExponent', None), ],
        '// 75: Maths operation: fValue is raised to the power of fExponent\r\n// * Returns zero if fValue  =  = 0 and fExponent <0\r\nfloat pow(float fValue, float fExponent);',
        '// 75: Maths operation: fValue is raised to the power of fExponent\r\n// * Returns zero if fValue  =  = 0 and fExponent <0\r\nfloat pow(float fValue, float fExponent);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'sqrt',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ],
        '// 76: Maths operation: square root of fValue\r\n// * Returns zero if fValue <0\r\nfloat sqrt(float fValue);',
        '// 76: Maths operation: square root of fValue\r\n// * Returns zero if fValue <0\r\nfloat sqrt(float fValue);'
    ),
    ScriptFunction(
        DataType.INT,
        'abs',
        [ScriptParam(DataType.INT, 'nValue', None), ],
        '// 77: Maths operation: integer absolute value of nValue\r\n// * Return value on error: 0\r\nint abs(int nValue);',
        '// 77: Maths operation: integer absolute value of nValue\r\n// * Return value on error: 0\r\nint abs(int nValue);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectHeal',
        [ScriptParam(DataType.INT, 'nDamageToHeal', None), ],
        '// 78: Create a Heal effect. This should be applied as an instantaneous effect.\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nDamageToHeal < 0.\r\neffect EffectHeal(int nDamageToHeal);',
        '// 78: Create a Heal effect. This should be applied as an instantaneous effect.\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nDamageToHeal < 0.\r\neffect EffectHeal(int nDamageToHeal);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDamage',
        [ScriptParam(DataType.INT, 'nDamageAmount', None), ScriptParam(DataType.INT, 'nDamageType', 8), ScriptParam(DataType.INT, 'nDamagePower', 0), ],
        '// 79: Create a Damage effect\r\n// - nDamageAmount: amount of damage to be dealt. This should be applied as an\r\n//   instantaneous effect.\r\n// - nDamageType: DAMAGE_TYPE_*\r\n// - nDamagePower: DAMAGE_POWER_*\r\neffect EffectDamage(int nDamageAmount, int nDamageType = DAMAGE_TYPE_UNIVERSAL, int nDamagePower = DAMAGE_POWER_NORMAL);',
        '// 79: Create a Damage effect\r\n// - nDamageAmount: amount of damage to be dealt. This should be applied as an\r\n//   instantaneous effect.\r\n// - nDamageType: DAMAGE_TYPE_*\r\n// - nDamagePower: DAMAGE_POWER_*\r\neffect EffectDamage(int nDamageAmount, int nDamageType = DAMAGE_TYPE_UNIVERSAL, int nDamagePower = DAMAGE_POWER_NORMAL);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectAbilityIncrease',
        [ScriptParam(DataType.INT, 'nAbilityToIncrease', None), ScriptParam(DataType.INT, 'nModifyBy', None), ],
        '// 80: Create an Ability Increase effect\r\n// - bAbilityToIncrease: ABILITY_*\r\neffect EffectAbilityIncrease(int nAbilityToIncrease, int nModifyBy);',
        '// 80: Create an Ability Increase effect\r\n// - bAbilityToIncrease: ABILITY_*\r\neffect EffectAbilityIncrease(int nAbilityToIncrease, int nModifyBy);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDamageResistance',
        [ScriptParam(DataType.INT, 'nDamageType', None), ScriptParam(DataType.INT, 'nAmount', None), ScriptParam(DataType.INT, 'nLimit', 0), ],
        '// 81: Create a Damage Resistance effect that removes the first nAmount points of\r\n// damage of type nDamageType, up to nLimit (or infinite if nLimit is 0)\r\n// - nDamageType: DAMAGE_TYPE_*\r\n// - nAmount\r\n// - nLimit\r\neffect EffectDamageResistance(int nDamageType, int nAmount, int nLimit = 0);',
        '// 81: Create a Damage Resistance effect that removes the first nAmount points of\r\n// damage of type nDamageType, up to nLimit (or infinite if nLimit is 0)\r\n// - nDamageType: DAMAGE_TYPE_*\r\n// - nAmount\r\n// - nLimit\r\neffect EffectDamageResistance(int nDamageType, int nAmount, int nLimit = 0);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectResurrection',
        [],
        '// 82: Create a Resurrection effect. This should be applied as an instantaneous effect.\r\neffect EffectResurrection();',
        '// 82: Create a Resurrection effect. This should be applied as an instantaneous effect.\r\neffect EffectResurrection();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetPlayerRestrictMode',
        [ScriptParam(DataType.OBJECT, 'oObject', 0), ],
        "// 83: GetPlayerRestrictMode\r\n// returns the current player 'restricted' mode\r\nint GetPlayerRestrictMode(object oObject  =  OBJECT_SELF);",
        "// 83: GetPlayerRestrictMode\r\n// returns the current player 'restricted' mode\r\nint GetPlayerRestrictMode(object oObject  =  OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetCasterLevel',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 84: Get the Caster Level of oCreature.\r\n// * Return value on error: 0;\r\nint GetCasterLevel(object oCreature);',
        '// 84: Get the Caster Level of oCreature.\r\n// * Return value on error: 0;\r\nint GetCasterLevel(object oCreature);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'GetFirstEffect',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 85: Get the first in-game effect on oCreature.\r\neffect GetFirstEffect(object oCreature);',
        '// 85: Get the first in-game effect on oCreature.\r\neffect GetFirstEffect(object oCreature);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'GetNextEffect',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 86: Get the next in-game effect on oCreature.\r\neffect GetNextEffect(object oCreature);',
        '// 86: Get the next in-game effect on oCreature.\r\neffect GetNextEffect(object oCreature);'
    ),
    ScriptFunction(
        DataType.VOID,
        'RemoveEffect',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 87: Remove eEffect from oCreature.\r\n// * No return value\r\nvoid RemoveEffect(object oCreature, effect eEffect);',
        '// 87: Remove eEffect from oCreature.\r\n// * No return value\r\nvoid RemoveEffect(object oCreature, effect eEffect);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsEffectValid',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 88: * Returns TRUE if eEffect is a valid effect.\r\nint GetIsEffectValid(effect eEffect);',
        '// 88: * Returns TRUE if eEffect is a valid effect.\r\nint GetIsEffectValid(effect eEffect);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetEffectDurationType',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 89: Get the duration type (DURATION_TYPE_*) of eEffect.\r\n// * Return value if eEffect is not valid: -1\r\nint GetEffectDurationType(effect eEffect);',
        '// 89: Get the duration type (DURATION_TYPE_*) of eEffect.\r\n// * Return value if eEffect is not valid: -1\r\nint GetEffectDurationType(effect eEffect);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetEffectSubType',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 90: Get the subtype (SUBTYPE_*) of eEffect.\r\n// * Return value on error: 0\r\nint GetEffectSubType(effect eEffect);',
        '// 90: Get the subtype (SUBTYPE_*) of eEffect.\r\n// * Return value on error: 0\r\nint GetEffectSubType(effect eEffect);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetEffectCreator',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 91: Get the object that created eEffect.\r\n// * Returns OBJECT_INVALID if eEffect is not a valid effect.\r\nobject GetEffectCreator(effect eEffect);',
        '// 91: Get the object that created eEffect.\r\n// * Returns OBJECT_INVALID if eEffect is not a valid effect.\r\nobject GetEffectCreator(effect eEffect);'
    ),
    ScriptFunction(
        DataType.STRING,
        'IntToString',
        [ScriptParam(DataType.INT, 'nInteger', None), ],
        '// 92: Convert nInteger into a string.\r\n// * Return value on error: ""\r\nstring IntToString(int nInteger);',
        '// 92: Convert nInteger into a string.\r\n// * Return value on error: ""\r\nstring IntToString(int nInteger);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFirstObjectInArea',
        [ScriptParam(DataType.OBJECT, 'oArea', 1), ScriptParam(DataType.INT, 'nObjectFilter', 1), ],
        "// 93: Get the first object in oArea.\r\n// If no valid area is specified, it will use the caller's area.\r\n// - oArea\r\n// - nObjectFilter: OBJECT_TYPE_*\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetFirstObjectInArea(object oArea = OBJECT_INVALID, int nObjectFilter = OBJECT_TYPE_CREATURE);",
        "// 93: Get the first object in oArea.\r\n// If no valid area is specified, it will use the caller's area.\r\n// - oArea\r\n// - nObjectFilter: OBJECT_TYPE_*\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetFirstObjectInArea(object oArea = OBJECT_INVALID, int nObjectFilter = OBJECT_TYPE_CREATURE);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNextObjectInArea',
        [ScriptParam(DataType.OBJECT, 'oArea', 1), ScriptParam(DataType.INT, 'nObjectFilter', 1), ],
        "// 94: Get the next object in oArea.\r\n// If no valid area is specified, it will use the caller's area.\r\n// - oArea\r\n// - nObjectFilter: OBJECT_TYPE_*\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNextObjectInArea(object oArea = OBJECT_INVALID, int nObjectFilter = OBJECT_TYPE_CREATURE);",
        "// 94: Get the next object in oArea.\r\n// If no valid area is specified, it will use the caller's area.\r\n// - oArea\r\n// - nObjectFilter: OBJECT_TYPE_*\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNextObjectInArea(object oArea = OBJECT_INVALID, int nObjectFilter = OBJECT_TYPE_CREATURE);"
    ),
    ScriptFunction(
        DataType.INT,
        'd2',
        [ScriptParam(DataType.INT, 'nNumDice', 1), ],
        '// 95: Get the total from rolling (nNumDice x d2 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d2(int nNumDice = 1);',
        '// 95: Get the total from rolling (nNumDice x d2 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d2(int nNumDice = 1);'
    ),
    ScriptFunction(
        DataType.INT,
        'd3',
        [ScriptParam(DataType.INT, 'nNumDice', 1), ],
        '// 96: Get the total from rolling (nNumDice x d3 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d3(int nNumDice = 1);',
        '// 96: Get the total from rolling (nNumDice x d3 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d3(int nNumDice = 1);'
    ),
    ScriptFunction(
        DataType.INT,
        'd4',
        [ScriptParam(DataType.INT, 'nNumDice', 1), ],
        '// 97: Get the total from rolling (nNumDice x d4 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d4(int nNumDice = 1);',
        '// 97: Get the total from rolling (nNumDice x d4 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d4(int nNumDice = 1);'
    ),
    ScriptFunction(
        DataType.INT,
        'd6',
        [ScriptParam(DataType.INT, 'nNumDice', 1), ],
        '// 98: Get the total from rolling (nNumDice x d6 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d6(int nNumDice = 1);',
        '// 98: Get the total from rolling (nNumDice x d6 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d6(int nNumDice = 1);'
    ),
    ScriptFunction(
        DataType.INT,
        'd8',
        [ScriptParam(DataType.INT, 'nNumDice', 1), ],
        '// 99: Get the total from rolling (nNumDice x d8 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d8(int nNumDice = 1);',
        '// 99: Get the total from rolling (nNumDice x d8 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d8(int nNumDice = 1);'
    ),
    ScriptFunction(
        DataType.INT,
        'd10',
        [ScriptParam(DataType.INT, 'nNumDice', 1), ],
        '// 100: Get the total from rolling (nNumDice x d10 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d10(int nNumDice = 1);',
        '// 100: Get the total from rolling (nNumDice x d10 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d10(int nNumDice = 1);'
    ),
    ScriptFunction(
        DataType.INT,
        'd12',
        [ScriptParam(DataType.INT, 'nNumDice', 1), ],
        '// 101: Get the total from rolling (nNumDice x d12 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d12(int nNumDice = 1);',
        '// 101: Get the total from rolling (nNumDice x d12 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d12(int nNumDice = 1);'
    ),
    ScriptFunction(
        DataType.INT,
        'd20',
        [ScriptParam(DataType.INT, 'nNumDice', 1), ],
        '// 102: Get the total from rolling (nNumDice x d20 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d20(int nNumDice = 1);',
        '// 102: Get the total from rolling (nNumDice x d20 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d20(int nNumDice = 1);'
    ),
    ScriptFunction(
        DataType.INT,
        'd100',
        [ScriptParam(DataType.INT, 'nNumDice', 1), ],
        '// 103: Get the total from rolling (nNumDice x d100 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d100(int nNumDice = 1);',
        '// 103: Get the total from rolling (nNumDice x d100 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d100(int nNumDice = 1);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'VectorMagnitude',
        [ScriptParam(DataType.VECTOR, 'vVector', None), ],
        '// 104: Get the magnitude of vVector; this can be used to determine the\r\n// distance between two points.\r\n// * Return value on error: 0.0f\r\nfloat VectorMagnitude(vector vVector);',
        '// 104: Get the magnitude of vVector; this can be used to determine the\r\n// distance between two points.\r\n// * Return value on error: 0.0f\r\nfloat VectorMagnitude(vector vVector);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetMetaMagicFeat',
        [],
        '// 105: Get the metamagic type (METAMAGIC_*) of the last spell cast by the caller\r\n// * Return value if the caster is not a valid object: -1\r\nint GetMetaMagicFeat();',
        '// 105: Get the metamagic type (METAMAGIC_*) of the last spell cast by the caller\r\n// * Return value if the caster is not a valid object: -1\r\nint GetMetaMagicFeat();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetObjectType',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 106: Get the object type (OBJECT_TYPE_*) of oTarget\r\n// * Return value if oTarget is not a valid object: -1\r\nint GetObjectType(object oTarget);',
        '// 106: Get the object type (OBJECT_TYPE_*) of oTarget\r\n// * Return value if oTarget is not a valid object: -1\r\nint GetObjectType(object oTarget);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetRacialType',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 107: Get the racial type (RACIAL_TYPE_*) of oCreature\r\n// * Return value if oCreature is not a valid creature: RACIAL_TYPE_INVALID\r\nint GetRacialType(object oCreature);',
        '// 107: Get the racial type (RACIAL_TYPE_*) of oCreature\r\n// * Return value if oCreature is not a valid creature: RACIAL_TYPE_INVALID\r\nint GetRacialType(object oCreature);'
    ),
    ScriptFunction(
        DataType.INT,
        'FortitudeSave',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nDC', None), ScriptParam(DataType.INT, 'nSaveType', 0), ScriptParam(DataType.OBJECT, 'oSaveVersus', 0), ],
        '// 108: Do a Fortitude Save check for the given DC\r\n// - oCreature\r\n// - nDC: Difficulty check\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\n// - oSaveVersus\r\n// Returns: 0 if the saving throw roll failed\r\n// Returns: 1 if the saving throw roll succeeded\r\n// Returns: 2 if the target was immune to the save type specified\r\nint FortitudeSave(object oCreature, int nDC, int nSaveType = SAVING_THROW_TYPE_NONE, object oSaveVersus = OBJECT_SELF);',
        '// 108: Do a Fortitude Save check for the given DC\r\n// - oCreature\r\n// - nDC: Difficulty check\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\n// - oSaveVersus\r\n// Returns: 0 if the saving throw roll failed\r\n// Returns: 1 if the saving throw roll succeeded\r\n// Returns: 2 if the target was immune to the save type specified\r\nint FortitudeSave(object oCreature, int nDC, int nSaveType = SAVING_THROW_TYPE_NONE, object oSaveVersus = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'ReflexSave',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nDC', None), ScriptParam(DataType.INT, 'nSaveType', 0), ScriptParam(DataType.OBJECT, 'oSaveVersus', 0), ],
        '// 109: Does a Reflex Save check for the given DC\r\n// - oCreature\r\n// - nDC: Difficulty check\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\n// - oSaveVersus\r\n// Returns: 0 if the saving throw roll failed\r\n// Returns: 1 if the saving throw roll succeeded\r\n// Returns: 2 if the target was immune to the save type specified\r\nint ReflexSave(object oCreature, int nDC, int nSaveType = SAVING_THROW_TYPE_NONE, object oSaveVersus = OBJECT_SELF);',
        '// 109: Does a Reflex Save check for the given DC\r\n// - oCreature\r\n// - nDC: Difficulty check\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\n// - oSaveVersus\r\n// Returns: 0 if the saving throw roll failed\r\n// Returns: 1 if the saving throw roll succeeded\r\n// Returns: 2 if the target was immune to the save type specified\r\nint ReflexSave(object oCreature, int nDC, int nSaveType = SAVING_THROW_TYPE_NONE, object oSaveVersus = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'WillSave',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nDC', None), ScriptParam(DataType.INT, 'nSaveType', 0), ScriptParam(DataType.OBJECT, 'oSaveVersus', 0), ],
        '// 110: Does a Will Save check for the given DC\r\n// - oCreature\r\n// - nDC: Difficulty check\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\n// - oSaveVersus\r\n// Returns: 0 if the saving throw roll failed\r\n// Returns: 1 if the saving throw roll succeeded\r\n// Returns: 2 if the target was immune to the save type specified\r\nint WillSave(object oCreature, int nDC, int nSaveType = SAVING_THROW_TYPE_NONE, object oSaveVersus = OBJECT_SELF);',
        '// 110: Does a Will Save check for the given DC\r\n// - oCreature\r\n// - nDC: Difficulty check\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\n// - oSaveVersus\r\n// Returns: 0 if the saving throw roll failed\r\n// Returns: 1 if the saving throw roll succeeded\r\n// Returns: 2 if the target was immune to the save type specified\r\nint WillSave(object oCreature, int nDC, int nSaveType = SAVING_THROW_TYPE_NONE, object oSaveVersus = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetSpellSaveDC',
        [],
        '// 111: Get the DC to save against for a spell (10 + spell level + relevant ability\r\n// bonus).  This can be called by a creature or by an Area of Effect object.\r\nint GetSpellSaveDC();',
        '// 111: Get the DC to save against for a spell (10 + spell level + relevant ability\r\n// bonus).  This can be called by a creature or by an Area of Effect object.\r\nint GetSpellSaveDC();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'MagicalEffect',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 112: Set the subtype of eEffect to Magical and return eEffect.\r\n// (Effects default to magical if the subtype is not set)\r\neffect MagicalEffect(effect eEffect);',
        '// 112: Set the subtype of eEffect to Magical and return eEffect.\r\n// (Effects default to magical if the subtype is not set)\r\neffect MagicalEffect(effect eEffect);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'SupernaturalEffect',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 113: Set the subtype of eEffect to Supernatural and return eEffect.\r\n// (Effects default to magical if the subtype is not set)\r\neffect SupernaturalEffect(effect eEffect);',
        '// 113: Set the subtype of eEffect to Supernatural and return eEffect.\r\n// (Effects default to magical if the subtype is not set)\r\neffect SupernaturalEffect(effect eEffect);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'ExtraordinaryEffect',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 114: Set the subtype of eEffect to Extraordinary and return eEffect.\r\n// (Effects default to magical if the subtype is not set)\r\neffect ExtraordinaryEffect(effect eEffect);',
        '// 114: Set the subtype of eEffect to Extraordinary and return eEffect.\r\n// (Effects default to magical if the subtype is not set)\r\neffect ExtraordinaryEffect(effect eEffect);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectACIncrease',
        [ScriptParam(DataType.INT, 'nValue', None), ScriptParam(DataType.INT, 'nModifyType', 0), ScriptParam(DataType.INT, 'nDamageType', 8199), ],
        '// 115: Create an AC Increase effect\r\n// - nValue: size of AC increase\r\n// - nModifyType: AC_*_BONUS\r\n// - nDamageType: DAMAGE_TYPE_*\r\n//   * Default value for nDamageType should only ever be used in this function prototype.\r\neffect EffectACIncrease(int nValue, int nModifyType = AC_DODGE_BONUS, int nDamageType = AC_VS_DAMAGE_TYPE_ALL);',
        '// 115: Create an AC Increase effect\r\n// - nValue: size of AC increase\r\n// - nModifyType: AC_*_BONUS\r\n// - nDamageType: DAMAGE_TYPE_*\r\n//   * Default value for nDamageType should only ever be used in this function prototype.\r\neffect EffectACIncrease(int nValue, int nModifyType = AC_DODGE_BONUS, int nDamageType = AC_VS_DAMAGE_TYPE_ALL);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetAC',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.INT, 'nForFutureUse', 0), ],
        "// 116: If oObject is a creature, this will return that creature's armour class\r\n// If oObject is an item, door or placeable, this will return zero.\r\n// - nForFutureUse: this parameter is not currently used\r\n// * Return value if oObject is not a creature, item, door or placeable: -1\r\nint GetAC(object oObject, int nForFutureUse = 0);",
        "// 116: If oObject is a creature, this will return that creature's armour class\r\n// If oObject is an item, door or placeable, this will return zero.\r\n// - nForFutureUse: this parameter is not currently used\r\n// * Return value if oObject is not a creature, item, door or placeable: -1\r\nint GetAC(object oObject, int nForFutureUse = 0);"
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectSavingThrowIncrease',
        [ScriptParam(DataType.INT, 'nSave', None), ScriptParam(DataType.INT, 'nValue', None), ScriptParam(DataType.INT, 'nSaveType', 0), ],
        '// 117: Create an AC Decrease effect\r\n// - nSave: SAVING_THROW_* (not SAVING_THROW_TYPE_*)\r\n// - nValue: size of AC decrease\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\neffect EffectSavingThrowIncrease(int nSave, int nValue, int nSaveType = SAVING_THROW_TYPE_ALL);',
        '// 117: Create an AC Decrease effect\r\n// - nSave: SAVING_THROW_* (not SAVING_THROW_TYPE_*)\r\n// - nValue: size of AC decrease\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\neffect EffectSavingThrowIncrease(int nSave, int nValue, int nSaveType = SAVING_THROW_TYPE_ALL);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectAttackIncrease',
        [ScriptParam(DataType.INT, 'nBonus', None), ScriptParam(DataType.INT, 'nModifierType', 0), ],
        '// 118: Create an Attack Increase effect\r\n// - nBonus: size of attack bonus\r\n// - nModifierType: ATTACK_BONUS_*\r\neffect EffectAttackIncrease(int nBonus, int nModifierType = ATTACK_BONUS_MISC);',
        '// 118: Create an Attack Increase effect\r\n// - nBonus: size of attack bonus\r\n// - nModifierType: ATTACK_BONUS_*\r\neffect EffectAttackIncrease(int nBonus, int nModifierType = ATTACK_BONUS_MISC);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDamageReduction',
        [ScriptParam(DataType.INT, 'nAmount', None), ScriptParam(DataType.INT, 'nDamagePower', None), ScriptParam(DataType.INT, 'nLimit', 0), ],
        '// 119: Create a Damage Reduction effect\r\n// - nAmount: amount of damage reduction\r\n// - nDamagePower: DAMAGE_POWER_*\r\n// - nLimit: How much damage the effect can absorb before disappearing.\r\n//   Set to zero for infinite\r\neffect EffectDamageReduction(int nAmount, int nDamagePower, int nLimit = 0);',
        '// 119: Create a Damage Reduction effect\r\n// - nAmount: amount of damage reduction\r\n// - nDamagePower: DAMAGE_POWER_*\r\n// - nLimit: How much damage the effect can absorb before disappearing.\r\n//   Set to zero for infinite\r\neffect EffectDamageReduction(int nAmount, int nDamagePower, int nLimit = 0);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDamageIncrease',
        [ScriptParam(DataType.INT, 'nBonus', None), ScriptParam(DataType.INT, 'nDamageType', 8), ],
        '// 120: Create a Damage Increase effect\r\n// - nBonus: DAMAGE_BONUS_*\r\n// - nDamageType: DAMAGE_TYPE_*\r\neffect EffectDamageIncrease(int nBonus, int nDamageType = DAMAGE_TYPE_UNIVERSAL);',
        '// 120: Create a Damage Increase effect\r\n// - nBonus: DAMAGE_BONUS_*\r\n// - nDamageType: DAMAGE_TYPE_*\r\neffect EffectDamageIncrease(int nBonus, int nDamageType = DAMAGE_TYPE_UNIVERSAL);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'RoundsToSeconds',
        [ScriptParam(DataType.INT, 'nRounds', None), ],
        '// 121: Convert nRounds into a number of seconds\r\n// A round is always 6.0 seconds\r\nfloat RoundsToSeconds(int nRounds);',
        '// 121: Convert nRounds into a number of seconds\r\n// A round is always 6.0 seconds\r\nfloat RoundsToSeconds(int nRounds);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'HoursToSeconds',
        [ScriptParam(DataType.INT, 'nHours', None), ],
        '// 122: Convert nHours into a number of seconds\r\n// The result will depend on how many minutes there are per hour (game-time)\r\nfloat HoursToSeconds(int nHours);',
        '// 122: Convert nHours into a number of seconds\r\n// The result will depend on how many minutes there are per hour (game-time)\r\nfloat HoursToSeconds(int nHours);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'TurnsToSeconds',
        [ScriptParam(DataType.INT, 'nTurns', None), ],
        '// 123: Convert nTurns into a number of seconds\r\n// A turn is always 60.0 seconds\r\nfloat TurnsToSeconds(int nTurns);',
        '// 123: Convert nTurns into a number of seconds\r\n// A turn is always 60.0 seconds\r\nfloat TurnsToSeconds(int nTurns);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SoundObjectSetFixedVariance',
        [ScriptParam(DataType.OBJECT, 'oSound', None), ScriptParam(DataType.FLOAT, 'fFixedVariance', None), ],
        '// 124. SoundObjectSetFixedVariance\r\n// Sets the constant variance at which to play the sound object\r\n// This variance is a multiplier of the original sound\r\nvoid SoundObjectSetFixedVariance( object oSound, float fFixedVariance );',
        '// 124. SoundObjectSetFixedVariance\r\n// Sets the constant variance at which to play the sound object\r\n// This variance is a multiplier of the original sound\r\nvoid SoundObjectSetFixedVariance( object oSound, float fFixedVariance );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetGoodEvilValue',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        "// 125: Get an integer between 0 and 100 (inclusive) to represent oCreature's\r\n// Good/Evil alignment\r\n// (100 = good, 0 = evil)\r\n// * Return value if oCreature is not a valid creature: -1\r\nint GetGoodEvilValue(object oCreature);",
        "// 125: Get an integer between 0 and 100 (inclusive) to represent oCreature's\r\n// Good/Evil alignment\r\n// (100 = good, 0 = evil)\r\n// * Return value if oCreature is not a valid creature: -1\r\nint GetGoodEvilValue(object oCreature);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetPartyMemberCount',
        [],
        '// 126: GetPartyMemberCount\r\n// Returns a count of how many members are in the party including the player character\r\nint GetPartyMemberCount();',
        '// 126: GetPartyMemberCount\r\n// Returns a count of how many members are in the party including the player character\r\nint GetPartyMemberCount();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetAlignmentGoodEvil',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        "// 127: Return an ALIGNMENT_* constant to represent oCreature's good/evil alignment\r\n// * Return value if oCreature is not a valid creature: -1\r\nint GetAlignmentGoodEvil(object oCreature);",
        "// 127: Return an ALIGNMENT_* constant to represent oCreature's good/evil alignment\r\n// * Return value if oCreature is not a valid creature: -1\r\nint GetAlignmentGoodEvil(object oCreature);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFirstObjectInShape',
        [ScriptParam(DataType.INT, 'nShape', None), ScriptParam(DataType.FLOAT, 'fSize', None), ScriptParam(DataType.LOCATION, 'lTarget', None), ScriptParam(DataType.INT, 'bLineOfSight', 0), ScriptParam(DataType.INT, 'nObjectFilter', 1), ScriptParam(DataType.VECTOR, 'vOrigin', Vector3(0.0, 0.0, 0.0)), ],
        '// 128: Get the first object in nShape\r\n// - nShape: SHAPE_*\r\n// - fSize:\r\n//   -> If nShape  =  =  SHAPE_SPHERE, this is the radius of the sphere\r\n//   -> If nShape  =  =  SHAPE_SPELLCYLINDER, this is the radius of the cylinder\r\n//   -> If nShape  =  =  SHAPE_CONE, this is the widest radius of the cone\r\n//   -> If nShape  =  =  SHAPE_CUBE, this is half the length of one of the sides of\r\n//      the cube\r\n// - lTarget: This is the centre of the effect, usually GetSpellTargetPosition(),\r\n//   or the end of a cylinder or cone.\r\n// - bLineOfSight: This controls whether to do a line-of-sight check on the\r\n//   object returned.\r\n//   (This can be used to ensure that spell effects do not go through walls.)\r\n// - nObjectFilter: This allows you to filter out undesired object types, using\r\n//   bitwise "or".\r\n//   For example, to return only creatures and doors, the value for this\r\n//   parameter would be OBJECT_TYPE_CREATURE | OBJECT_TYPE_DOOR\r\n// - vOrigin: This is only used for cylinders and cones, and specifies the\r\n//   origin of the effect(normally the spell-caster\'s position).\r\n// Return value on error: OBJECT_INVALID\r\nobject GetFirstObjectInShape(int nShape, float fSize, location lTarget, int bLineOfSight = FALSE, int nObjectFilter = OBJECT_TYPE_CREATURE, vector vOrigin = [0.0,0.0,0.0]);',
        '// 128: Get the first object in nShape\r\n// - nShape: SHAPE_*\r\n// - fSize:\r\n//   -> If nShape  =  =  SHAPE_SPHERE, this is the radius of the sphere\r\n//   -> If nShape  =  =  SHAPE_SPELLCYLINDER, this is the radius of the cylinder\r\n//   -> If nShape  =  =  SHAPE_CONE, this is the widest radius of the cone\r\n//   -> If nShape  =  =  SHAPE_CUBE, this is half the length of one of the sides of\r\n//      the cube\r\n// - lTarget: This is the centre of the effect, usually GetSpellTargetPosition(),\r\n//   or the end of a cylinder or cone.\r\n// - bLineOfSight: This controls whether to do a line-of-sight check on the\r\n//   object returned.\r\n//   (This can be used to ensure that spell effects do not go through walls.)\r\n// - nObjectFilter: This allows you to filter out undesired object types, using\r\n//   bitwise "or".\r\n//   For example, to return only creatures and doors, the value for this\r\n//   parameter would be OBJECT_TYPE_CREATURE | OBJECT_TYPE_DOOR\r\n// - vOrigin: This is only used for cylinders and cones, and specifies the\r\n//   origin of the effect(normally the spell-caster\'s position).\r\n// Return value on error: OBJECT_INVALID\r\nobject GetFirstObjectInShape(int nShape, float fSize, location lTarget, int bLineOfSight = FALSE, int nObjectFilter = OBJECT_TYPE_CREATURE, vector vOrigin = [0.0,0.0,0.0]);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNextObjectInShape',
        [ScriptParam(DataType.INT, 'nShape', None), ScriptParam(DataType.FLOAT, 'fSize', None), ScriptParam(DataType.LOCATION, 'lTarget', None), ScriptParam(DataType.INT, 'bLineOfSight', 0), ScriptParam(DataType.INT, 'nObjectFilter', 1), ScriptParam(DataType.VECTOR, 'vOrigin', Vector3(0.0, 0.0, 0.0)), ],
        '// 129: Get the next object in nShape\r\n// - nShape: SHAPE_*\r\n// - fSize:\r\n//   -> If nShape  =  =  SHAPE_SPHERE, this is the radius of the sphere\r\n//   -> If nShape  =  =  SHAPE_SPELLCYLINDER, this is the radius of the cylinder\r\n//   -> If nShape  =  =  SHAPE_CONE, this is the widest radius of the cone\r\n//   -> If nShape  =  =  SHAPE_CUBE, this is half the length of one of the sides of\r\n//      the cube\r\n// - lTarget: This is the centre of the effect, usually GetSpellTargetPosition(),\r\n//   or the end of a cylinder or cone.\r\n// - bLineOfSight: This controls whether to do a line-of-sight check on the\r\n//   object returned. (This can be used to ensure that spell effects do not go\r\n//   through walls.)\r\n// - nObjectFilter: This allows you to filter out undesired object types, using\r\n//   bitwise "or". For example, to return only creatures and doors, the value for\r\n//   this parameter would be OBJECT_TYPE_CREATURE | OBJECT_TYPE_DOOR\r\n// - vOrigin: This is only used for cylinders and cones, and specifies the origin\r\n//   of the effect (normally the spell-caster\'s position).\r\n// Return value on error: OBJECT_INVALID\r\nobject GetNextObjectInShape(int nShape, float fSize, location lTarget, int bLineOfSight = FALSE, int nObjectFilter = OBJECT_TYPE_CREATURE, vector vOrigin = [0.0,0.0,0.0]);',
        '// 129: Get the next object in nShape\r\n// - nShape: SHAPE_*\r\n// - fSize:\r\n//   -> If nShape  =  =  SHAPE_SPHERE, this is the radius of the sphere\r\n//   -> If nShape  =  =  SHAPE_SPELLCYLINDER, this is the radius of the cylinder\r\n//   -> If nShape  =  =  SHAPE_CONE, this is the widest radius of the cone\r\n//   -> If nShape  =  =  SHAPE_CUBE, this is half the length of one of the sides of\r\n//      the cube\r\n// - lTarget: This is the centre of the effect, usually GetSpellTargetPosition(),\r\n//   or the end of a cylinder or cone.\r\n// - bLineOfSight: This controls whether to do a line-of-sight check on the\r\n//   object returned. (This can be used to ensure that spell effects do not go\r\n//   through walls.)\r\n// - nObjectFilter: This allows you to filter out undesired object types, using\r\n//   bitwise "or". For example, to return only creatures and doors, the value for\r\n//   this parameter would be OBJECT_TYPE_CREATURE | OBJECT_TYPE_DOOR\r\n// - vOrigin: This is only used for cylinders and cones, and specifies the origin\r\n//   of the effect (normally the spell-caster\'s position).\r\n// Return value on error: OBJECT_INVALID\r\nobject GetNextObjectInShape(int nShape, float fSize, location lTarget, int bLineOfSight = FALSE, int nObjectFilter = OBJECT_TYPE_CREATURE, vector vOrigin = [0.0,0.0,0.0]);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectEntangle',
        [],
        "// 130: Create an Entangle effect\r\n// When applied, this effect will restrict the creature's movement and apply a\r\n// (-2) to all attacks and a -4 to AC.\r\neffect EffectEntangle();",
        "// 130: Create an Entangle effect\r\n// When applied, this effect will restrict the creature's movement and apply a\r\n// (-2) to all attacks and a -4 to AC.\r\neffect EffectEntangle();"
    ),
    ScriptFunction(
        DataType.VOID,
        'SignalEvent',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.EVENT, 'evToRun', None), ],
        '// 131: Cause oObject to run evToRun\r\nvoid SignalEvent(object oObject, event evToRun);',
        '// 131: Cause oObject to run evToRun\r\nvoid SignalEvent(object oObject, event evToRun);'
    ),
    ScriptFunction(
        DataType.EVENT,
        'EventUserDefined',
        [ScriptParam(DataType.INT, 'nUserDefinedEventNumber', None), ],
        '// 132: Create an event of the type nUserDefinedEventNumber\r\nevent EventUserDefined(int nUserDefinedEventNumber);',
        '// 132: Create an event of the type nUserDefinedEventNumber\r\nevent EventUserDefined(int nUserDefinedEventNumber);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDeath',
        [ScriptParam(DataType.INT, 'nSpectacularDeath', 0), ScriptParam(DataType.INT, 'nDisplayFeedback', 1), ],
        '// 133: Create a Death effect\r\n// - nSpectacularDeath: if this is TRUE, the creature to which this effect is\r\n//   applied will die in an extraordinary fashion\r\n// - nDisplayFeedback\r\neffect EffectDeath(int nSpectacularDeath = FALSE, int nDisplayFeedback = TRUE);',
        '// 133: Create a Death effect\r\n// - nSpectacularDeath: if this is TRUE, the creature to which this effect is\r\n//   applied will die in an extraordinary fashion\r\n// - nDisplayFeedback\r\neffect EffectDeath(int nSpectacularDeath = FALSE, int nDisplayFeedback = TRUE);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectKnockdown',
        [],
        '// 134: Create a Knockdown effect\r\n// This effect knocks creatures off their feet, they will sit until the effect\r\n// is removed. This should be applied as a temporary effect with a 3 second\r\n// duration minimum (1 second to fall, 1 second sitting, 1 second to get up).\r\neffect EffectKnockdown();',
        '// 134: Create a Knockdown effect\r\n// This effect knocks creatures off their feet, they will sit until the effect\r\n// is removed. This should be applied as a temporary effect with a 3 second\r\n// duration minimum (1 second to fall, 1 second sitting, 1 second to get up).\r\neffect EffectKnockdown();'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionGiveItem',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.OBJECT, 'oGiveTo', None), ],
        '// 135: Give oItem to oGiveTo\r\n// If oItem is not a valid item, or oGiveTo is not a valid object, nothing will\r\n// happen.\r\nvoid ActionGiveItem(object oItem, object oGiveTo);',
        '// 135: Give oItem to oGiveTo\r\n// If oItem is not a valid item, or oGiveTo is not a valid object, nothing will\r\n// happen.\r\nvoid ActionGiveItem(object oItem, object oGiveTo);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionTakeItem',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.OBJECT, 'oTakeFrom', None), ],
        '// 136: Take oItem from oTakeFrom\r\n// If oItem is not a valid item, or oTakeFrom is not a valid object, nothing\r\n// will happen.\r\nvoid ActionTakeItem(object oItem, object oTakeFrom);',
        '// 136: Take oItem from oTakeFrom\r\n// If oItem is not a valid item, or oTakeFrom is not a valid object, nothing\r\n// will happen.\r\nvoid ActionTakeItem(object oItem, object oTakeFrom);'
    ),
    ScriptFunction(
        DataType.VECTOR,
        'VectorNormalize',
        [ScriptParam(DataType.VECTOR, 'vVector', None), ],
        '// 137: Normalize vVector\r\nvector VectorNormalize(vector vVector);',
        '// 137: Normalize vVector\r\nvector VectorNormalize(vector vVector);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetItemStackSize',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 138:\r\n// Gets the stack size of an item.\r\nint GetItemStackSize( object oItem );',
        '// 138:\r\n// Gets the stack size of an item.\r\nint GetItemStackSize( object oItem );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetAbilityScore',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nAbilityType', None), ],
        '// 139: Get the ability score of type nAbility for a creature (otherwise 0)\r\n// - oCreature: the creature whose ability score we wish to find out\r\n// - nAbilityType: ABILITY_*\r\n// Return value on error: 0\r\nint GetAbilityScore(object oCreature, int nAbilityType);',
        '// 139: Get the ability score of type nAbility for a creature (otherwise 0)\r\n// - oCreature: the creature whose ability score we wish to find out\r\n// - nAbilityType: ABILITY_*\r\n// Return value on error: 0\r\nint GetAbilityScore(object oCreature, int nAbilityType);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsDead',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 140: * Returns TRUE if oCreature is a dead NPC, dead PC or a dying PC.\r\nint GetIsDead(object oCreature);',
        '// 140: * Returns TRUE if oCreature is a dead NPC, dead PC or a dying PC.\r\nint GetIsDead(object oCreature);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PrintVector',
        [ScriptParam(DataType.VECTOR, 'vVector', None), ScriptParam(DataType.INT, 'bPrepend', None), ],
        '// 141: Output vVector to the logfile.\r\n// - vVector\r\n// - bPrepend: if this is TRUE, the message will be prefixed with "PRINTVECTOR:"\r\nvoid PrintVector(vector vVector, int bPrepend);',
        '// 141: Output vVector to the logfile.\r\n// - vVector\r\n// - bPrepend: if this is TRUE, the message will be prefixed with "PRINTVECTOR:"\r\nvoid PrintVector(vector vVector, int bPrepend);'
    ),
    ScriptFunction(
        DataType.VECTOR,
        'Vector',
        [ScriptParam(DataType.FLOAT, 'x', 0.0), ScriptParam(DataType.FLOAT, 'y', 0.0), ScriptParam(DataType.FLOAT, 'z', 0.0), ],
        '// 142: Create a vector with the specified values for x, y and z\r\nvector Vector(float x = 0.0f, float y = 0.0f, float z = 0.0f);',
        '// 142: Create a vector with the specified values for x, y and z\r\nvector Vector(float x = 0.0f, float y = 0.0f, float z = 0.0f);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetFacingPoint',
        [ScriptParam(DataType.VECTOR, 'vTarget', None), ],
        '// 143: Cause the caller to face vTarget\r\nvoid SetFacingPoint(vector vTarget);',
        '// 143: Cause the caller to face vTarget\r\nvoid SetFacingPoint(vector vTarget);'
    ),
    ScriptFunction(
        DataType.VECTOR,
        'AngleToVector',
        [ScriptParam(DataType.FLOAT, 'fAngle', None), ],
        '// 144: Convert fAngle to a vector\r\nvector AngleToVector(float fAngle);',
        '// 144: Convert fAngle to a vector\r\nvector AngleToVector(float fAngle);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'VectorToAngle',
        [ScriptParam(DataType.VECTOR, 'vVector', None), ],
        '// 145: Convert vVector to an angle\r\nfloat VectorToAngle(vector vVector);',
        '// 145: Convert vVector to an angle\r\nfloat VectorToAngle(vector vVector);'
    ),
    ScriptFunction(
        DataType.INT,
        'TouchAttackMelee',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'bDisplayFeedback', 1), ],
        '// 146: The caller will perform a Melee Touch Attack on oTarget\r\n// This is not an action, and it assumes the caller is already within range of\r\n// oTarget\r\n// * Returns 0 on a miss, 1 on a hit and 2 on a critical hit\r\nint TouchAttackMelee(object oTarget, int bDisplayFeedback = TRUE);',
        '// 146: The caller will perform a Melee Touch Attack on oTarget\r\n// This is not an action, and it assumes the caller is already within range of\r\n// oTarget\r\n// * Returns 0 on a miss, 1 on a hit and 2 on a critical hit\r\nint TouchAttackMelee(object oTarget, int bDisplayFeedback = TRUE);'
    ),
    ScriptFunction(
        DataType.INT,
        'TouchAttackRanged',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'bDisplayFeedback', 1), ],
        '// 147: The caller will perform a Ranged Touch Attack on oTarget\r\n// * Returns 0 on a miss, 1 on a hit and 2 on a critical hit\r\nint TouchAttackRanged(object oTarget, int bDisplayFeedback = TRUE);',
        '// 147: The caller will perform a Ranged Touch Attack on oTarget\r\n// * Returns 0 on a miss, 1 on a hit and 2 on a critical hit\r\nint TouchAttackRanged(object oTarget, int bDisplayFeedback = TRUE);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectParalyze',
        [],
        '// 148: Create a Paralyze effect\r\neffect EffectParalyze();',
        '// 148: Create a Paralyze effect\r\neffect EffectParalyze();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectSpellImmunity',
        [ScriptParam(DataType.INT, 'nImmunityToSpell', -1), ],
        '// 149: Create a Spell Immunity effect.\r\n// There is a known bug with this function. There *must* be a parameter specified\r\n// when this is called (even if the desired parameter is SPELL_ALL_SPELLS),\r\n// otherwise an effect of type EFFECT_TYPE_INVALIDEFFECT will be returned.\r\n// - nImmunityToSpell: SPELL_*\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nImmunityToSpell is\r\n//   invalid.\r\neffect EffectSpellImmunity(int nImmunityToSpell = FORCE_POWER_ALL_FORCE_POWERS);',
        '// 149: Create a Spell Immunity effect.\r\n// There is a known bug with this function. There *must* be a parameter specified\r\n// when this is called (even if the desired parameter is SPELL_ALL_SPELLS),\r\n// otherwise an effect of type EFFECT_TYPE_INVALIDEFFECT will be returned.\r\n// - nImmunityToSpell: SPELL_*\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nImmunityToSpell is\r\n//   invalid.\r\neffect EffectSpellImmunity(int nImmunityToSpell = FORCE_POWER_ALL_FORCE_POWERS);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetItemStackSize',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.INT, 'nStackSize', None), ],
        '// 150:\r\n// Set the stack size of an item.\r\n// NOTE: The stack size will be clamped to between 1 and the max stack size (as\r\n//       specified in the base item).\r\nvoid SetItemStackSize( object oItem, int nStackSize );',
        '// 150:\r\n// Set the stack size of an item.\r\n// NOTE: The stack size will be clamped to between 1 and the max stack size (as\r\n//       specified in the base item).\r\nvoid SetItemStackSize( object oItem, int nStackSize );'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetDistanceBetween',
        [ScriptParam(DataType.OBJECT, 'oObjectA', None), ScriptParam(DataType.OBJECT, 'oObjectB', None), ],
        '// 151: Get the distance in metres between oObjectA and oObjectB.\r\n// * Return value if either object is invalid: 0.0f\r\nfloat GetDistanceBetween(object oObjectA, object oObjectB);',
        '// 151: Get the distance in metres between oObjectA and oObjectB.\r\n// * Return value if either object is invalid: 0.0f\r\nfloat GetDistanceBetween(object oObjectA, object oObjectB);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetReturnStrref',
        [ScriptParam(DataType.INT, 'bShow', None), ScriptParam(DataType.INT, 'srStringRef', 0), ScriptParam(DataType.INT, 'srReturnQueryStrRef', 0), ],
        "// 152: SetReturnStrref\r\n// This function will turn on/off the display of the 'return to ebon hawk' option\r\n// on the map screen and allow the string to be changed to an arbitrary string ref\r\n// srReturnQueryStrRef is the string ref that will be displayed in the query pop\r\n// up confirming that you wish to return to the specified location.\r\nvoid SetReturnStrref(int bShow, int srStringRef  =  0, int srReturnQueryStrRef  =  0);",
        "// 152: SetReturnStrref\r\n// This function will turn on/off the display of the 'return to ebon hawk' option\r\n// on the map screen and allow the string to be changed to an arbitrary string ref\r\n// srReturnQueryStrRef is the string ref that will be displayed in the query pop\r\n// up confirming that you wish to return to the specified location.\r\nvoid SetReturnStrref(int bShow, int srStringRef  =  0, int srReturnQueryStrRef  =  0);"
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectForceJump',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'nAdvanced', 0), ],
        '// 153: EffectForceJump\r\n// The effect required for force jumping\r\neffect EffectForceJump(object oTarget, int nAdvanced  =  0);',
        '// 153: EffectForceJump\r\n// The effect required for force jumping\r\neffect EffectForceJump(object oTarget, int nAdvanced  =  0);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectSleep',
        [],
        '// 154: Create a Sleep effect\r\neffect EffectSleep();',
        '// 154: Create a Sleep effect\r\neffect EffectSleep();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetItemInSlot',
        [ScriptParam(DataType.INT, 'nInventorySlot', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        "// 155: Get the object which is in oCreature's specified inventory slot\r\n// - nInventorySlot: INVENTORY_SLOT_*\r\n// - oCreature\r\n// * Returns OBJECT_INVALID if oCreature is not a valid creature or there is no\r\n//   item in nInventorySlot.\r\nobject GetItemInSlot(int nInventorySlot, object oCreature = OBJECT_SELF);",
        "// 155: Get the object which is in oCreature's specified inventory slot\r\n// - nInventorySlot: INVENTORY_SLOT_*\r\n// - oCreature\r\n// * Returns OBJECT_INVALID if oCreature is not a valid creature or there is no\r\n//   item in nInventorySlot.\r\nobject GetItemInSlot(int nInventorySlot, object oCreature = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectTemporaryForcePoints',
        [ScriptParam(DataType.INT, 'nTempForce', None), ],
        '// 156: This was previously EffectCharmed();\r\neffect EffectTemporaryForcePoints(int nTempForce);',
        '// 156: This was previously EffectCharmed();\r\neffect EffectTemporaryForcePoints(int nTempForce);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectConfused',
        [],
        '// 157: Create a Confuse effect\r\neffect EffectConfused();',
        '// 157: Create a Confuse effect\r\neffect EffectConfused();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectFrightened',
        [],
        '// 158: Create a Frighten effect\r\neffect EffectFrightened();',
        '// 158: Create a Frighten effect\r\neffect EffectFrightened();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectChoke',
        [],
        '// 159: Choke the bugger...\r\neffect EffectChoke( );',
        '// 159: Choke the bugger...\r\neffect EffectChoke( );'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetGlobalString',
        [ScriptParam(DataType.STRING, 'sIdentifier', None), ScriptParam(DataType.STRING, 'sValue', None), ],
        "// 160: Sets a global string with the specified identifier.  This is an EXTREMELY\r\n//      restricted function - do not use without expilicit permission.\r\n//      This means if you are not Preston.  Then go see him if you're even thinking\r\n//      about using this.\r\nvoid SetGlobalString( string sIdentifier, string sValue );",
        "// 160: Sets a global string with the specified identifier.  This is an EXTREMELY\r\n//      restricted function - do not use without expilicit permission.\r\n//      This means if you are not Preston.  Then go see him if you're even thinking\r\n//      about using this.\r\nvoid SetGlobalString( string sIdentifier, string sValue );"
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectStunned',
        [],
        '// 161: Create a Stun effect\r\neffect EffectStunned();',
        '// 161: Create a Stun effect\r\neffect EffectStunned();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetCommandable',
        [ScriptParam(DataType.INT, 'bCommandable', None), ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        "// 162: Set whether oTarget's action stack can be modified\r\nvoid SetCommandable(int bCommandable, object oTarget = OBJECT_SELF);",
        "// 162: Set whether oTarget's action stack can be modified\r\nvoid SetCommandable(int bCommandable, object oTarget = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetCommandable',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        "// 163: Determine whether oTarget's action stack can be modified.\r\nint GetCommandable(object oTarget = OBJECT_SELF);",
        "// 163: Determine whether oTarget's action stack can be modified.\r\nint GetCommandable(object oTarget = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectRegenerate',
        [ScriptParam(DataType.INT, 'nAmount', None), ScriptParam(DataType.FLOAT, 'fIntervalSeconds', None), ],
        '// 164: Create a Regenerate effect.\r\n// - nAmount: amount of damage to be regenerated per time interval\r\n// - fIntervalSeconds: length of interval in seconds\r\neffect EffectRegenerate(int nAmount, float fIntervalSeconds);',
        '// 164: Create a Regenerate effect.\r\n// - nAmount: amount of damage to be regenerated per time interval\r\n// - fIntervalSeconds: length of interval in seconds\r\neffect EffectRegenerate(int nAmount, float fIntervalSeconds);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectMovementSpeedIncrease',
        [ScriptParam(DataType.INT, 'nNewSpeedPercent', None), ],
        '// 165: Create a Movement Speed Increase effect.\r\n// - nNewSpeedPercent: This works in a dodgy way so please read this notes carefully.\r\n//   If you supply an integer under 100, 100 gets added to it to produce the final speed.\r\n//   e.g. if you supply 50, then the resulting speed is 150% of the original speed.\r\n//   If you supply 100 or above, then this is used directly as the resulting speed.\r\n//   e.g. if you specify 100, then the resulting speed is 100% of the original speed that is,\r\n//        it is unchanged.\r\n//        However if you specify 200, then the resulting speed is double the original speed.\r\neffect EffectMovementSpeedIncrease(int nNewSpeedPercent);',
        '// 165: Create a Movement Speed Increase effect.\r\n// - nNewSpeedPercent: This works in a dodgy way so please read this notes carefully.\r\n//   If you supply an integer under 100, 100 gets added to it to produce the final speed.\r\n//   e.g. if you supply 50, then the resulting speed is 150% of the original speed.\r\n//   If you supply 100 or above, then this is used directly as the resulting speed.\r\n//   e.g. if you specify 100, then the resulting speed is 100% of the original speed that is,\r\n//        it is unchanged.\r\n//        However if you specify 200, then the resulting speed is double the original speed.\r\neffect EffectMovementSpeedIncrease(int nNewSpeedPercent);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetHitDice',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 166: Get the number of hitdice for oCreature.\r\n// * Return value if oCreature is not a valid creature: 0\r\nint GetHitDice(object oCreature);',
        '// 166: Get the number of hitdice for oCreature.\r\n// * Return value if oCreature is not a valid creature: 0\r\nint GetHitDice(object oCreature);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionForceFollowObject',
        [ScriptParam(DataType.OBJECT, 'oFollow', None), ScriptParam(DataType.FLOAT, 'fFollowDistance', 0.0), ],
        '// 167: The action subject will follow oFollow until a ClearAllActions() is called.\r\n// - oFollow: this is the object to be followed\r\n// - fFollowDistance: follow distance in metres\r\n// * No return value\r\nvoid ActionForceFollowObject(object oFollow, float fFollowDistance = 0.0f);',
        '// 167: The action subject will follow oFollow until a ClearAllActions() is called.\r\n// - oFollow: this is the object to be followed\r\n// - fFollowDistance: follow distance in metres\r\n// * No return value\r\nvoid ActionForceFollowObject(object oFollow, float fFollowDistance = 0.0f);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetTag',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 168: Get the Tag of oObject\r\n// * Return value if oObject is not a valid object: ""\r\nstring GetTag(object oObject);',
        '// 168: Get the Tag of oObject\r\n// * Return value if oObject is not a valid object: ""\r\nstring GetTag(object oObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'ResistForce',
        [ScriptParam(DataType.OBJECT, 'oSource', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 169: Do a Force Resistance check between oSource and oTarget, returning TRUE if\r\n// the force was resisted.\r\n// * Return value if oSource or oTarget is an invalid object: FALSE\r\nint ResistForce(object oSource, object oTarget);',
        '// 169: Do a Force Resistance check between oSource and oTarget, returning TRUE if\r\n// the force was resisted.\r\n// * Return value if oSource or oTarget is an invalid object: FALSE\r\nint ResistForce(object oSource, object oTarget);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetEffectType',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 170: Get the effect type (EFFECT_TYPE_*) of eEffect.\r\n// * Return value if eEffect is invalid: EFFECT_INVALIDEFFECT\r\nint GetEffectType(effect eEffect);',
        '// 170: Get the effect type (EFFECT_TYPE_*) of eEffect.\r\n// * Return value if eEffect is invalid: EFFECT_INVALIDEFFECT\r\nint GetEffectType(effect eEffect);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectAreaOfEffect',
        [ScriptParam(DataType.INT, 'nAreaEffectId', None), ScriptParam(DataType.STRING, 'sOnEnterScript', ''), ScriptParam(DataType.STRING, 'sHeartbeatScript', ''), ScriptParam(DataType.STRING, 'sOnExitScript', ''), ],
        '// 171: Create an Area Of Effect effect in the area of the creature it is applied to.\r\n// If the scripts are not specified, default ones will be used.\r\neffect EffectAreaOfEffect(int nAreaEffectId, string sOnEnterScript = "", string sHeartbeatScript = "", string sOnExitScript = "");',
        '// 171: Create an Area Of Effect effect in the area of the creature it is applied to.\r\n// If the scripts are not specified, default ones will be used.\r\neffect EffectAreaOfEffect(int nAreaEffectId, string sOnEnterScript = "", string sHeartbeatScript = "", string sOnExitScript = "");'
    ),
    ScriptFunction(
        DataType.INT,
        'GetFactionEqual',
        [ScriptParam(DataType.OBJECT, 'oFirstObject', None), ScriptParam(DataType.OBJECT, 'oSecondObject', 0), ],
        '// 172: * Returns TRUE if the Faction Ids of the two objects are the same\r\nint GetFactionEqual(object oFirstObject, object oSecondObject = OBJECT_SELF);',
        '// 172: * Returns TRUE if the Faction Ids of the two objects are the same\r\nint GetFactionEqual(object oFirstObject, object oSecondObject = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ChangeFaction',
        [ScriptParam(DataType.OBJECT, 'oObjectToChangeFaction', None), ScriptParam(DataType.OBJECT, 'oMemberOfFactionToJoin', None), ],
        '// 173: Make oObjectToChangeFaction join the faction of oMemberOfFactionToJoin.\r\n// NB. ** This will only work for two NPCs **\r\nvoid ChangeFaction(object oObjectToChangeFaction, object oMemberOfFactionToJoin);',
        '// 173: Make oObjectToChangeFaction join the faction of oMemberOfFactionToJoin.\r\n// NB. ** This will only work for two NPCs **\r\nvoid ChangeFaction(object oObjectToChangeFaction, object oMemberOfFactionToJoin);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsListening',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 174: * Returns TRUE if oObject is listening for something\r\nint GetIsListening(object oObject);',
        '// 174: * Returns TRUE if oObject is listening for something\r\nint GetIsListening(object oObject);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetListening',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.INT, 'bValue', None), ],
        '// 175: Set whether oObject is listening.\r\nvoid SetListening(object oObject, int bValue);',
        '// 175: Set whether oObject is listening.\r\nvoid SetListening(object oObject, int bValue);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetListenPattern',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.STRING, 'sPattern', None), ScriptParam(DataType.INT, 'nNumber', 0), ],
        '// 176: Set the string for oObject to listen for.\r\n// Note: this does not set oObject to be listening.\r\nvoid SetListenPattern(object oObject, string sPattern, int nNumber = 0);',
        '// 176: Set the string for oObject to listen for.\r\n// Note: this does not set oObject to be listening.\r\nvoid SetListenPattern(object oObject, string sPattern, int nNumber = 0);'
    ),
    ScriptFunction(
        DataType.INT,
        'TestStringAgainstPattern',
        [ScriptParam(DataType.STRING, 'sPattern', None), ScriptParam(DataType.STRING, 'sStringToTest', None), ],
        '// 177: * Returns TRUE if sStringToTest matches sPattern.\r\nint TestStringAgainstPattern(string sPattern, string sStringToTest);',
        '// 177: * Returns TRUE if sStringToTest matches sPattern.\r\nint TestStringAgainstPattern(string sPattern, string sStringToTest);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetMatchedSubstring',
        [ScriptParam(DataType.INT, 'nString', None), ],
        '// 178: Get the appropriate matched string (this should only be used in\r\n// OnConversation scripts).\r\n// * Returns the appropriate matched string, otherwise returns ""\r\nstring GetMatchedSubstring(int nString);',
        '// 178: Get the appropriate matched string (this should only be used in\r\n// OnConversation scripts).\r\n// * Returns the appropriate matched string, otherwise returns ""\r\nstring GetMatchedSubstring(int nString);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetMatchedSubstringsCount',
        [],
        '// 179: Get the number of string parameters available.\r\n// * Returns -1 if no string matched (this could be because of a dialogue event)\r\nint GetMatchedSubstringsCount();',
        '// 179: Get the number of string parameters available.\r\n// * Returns -1 if no string matched (this could be because of a dialogue event)\r\nint GetMatchedSubstringsCount();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectVisualEffect',
        [ScriptParam(DataType.INT, 'nVisualEffectId', None), ScriptParam(DataType.INT, 'nMissEffect', 0), ],
        '// 180: * Create a Visual Effect that can be applied to an object.\r\n// - nVisualEffectId\r\n// - nMissEffect: if this is TRUE, a random vector near or past the target will\r\n//   be generated, on which to play the effect\r\neffect EffectVisualEffect(int nVisualEffectId, int nMissEffect = FALSE);',
        '// 180: * Create a Visual Effect that can be applied to an object.\r\n// - nVisualEffectId\r\n// - nMissEffect: if this is TRUE, a random vector near or past the target will\r\n//   be generated, on which to play the effect\r\neffect EffectVisualEffect(int nVisualEffectId, int nMissEffect = FALSE);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFactionWeakestMember',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', 0), ScriptParam(DataType.INT, 'bMustBeVisible', 1), ],
        "// 181: Get the weakest member of oFactionMember's faction.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionWeakestMember(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);",
        "// 181: Get the weakest member of oFactionMember's faction.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionWeakestMember(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFactionStrongestMember',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', 0), ScriptParam(DataType.INT, 'bMustBeVisible', 1), ],
        "// 182: Get the strongest member of oFactionMember's faction.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionStrongestMember(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);",
        "// 182: Get the strongest member of oFactionMember's faction.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionStrongestMember(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFactionMostDamagedMember',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', 0), ScriptParam(DataType.INT, 'bMustBeVisible', 1), ],
        "// 183: Get the member of oFactionMember's faction that has taken the most hit points\r\n// of damage.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionMostDamagedMember(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);",
        "// 183: Get the member of oFactionMember's faction that has taken the most hit points\r\n// of damage.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionMostDamagedMember(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFactionLeastDamagedMember',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', 0), ScriptParam(DataType.INT, 'bMustBeVisible', 1), ],
        "// 184: Get the member of oFactionMember's faction that has taken the fewest hit\r\n// points of damage.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionLeastDamagedMember(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);",
        "// 184: Get the member of oFactionMember's faction that has taken the fewest hit\r\n// points of damage.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionLeastDamagedMember(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetFactionGold',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', None), ],
        "// 185: Get the amount of gold held by oFactionMember's faction.\r\n// * Returns -1 if oFactionMember's faction is invalid.\r\nint GetFactionGold(object oFactionMember);",
        "// 185: Get the amount of gold held by oFactionMember's faction.\r\n// * Returns -1 if oFactionMember's faction is invalid.\r\nint GetFactionGold(object oFactionMember);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetFactionAverageReputation',
        [ScriptParam(DataType.OBJECT, 'oSourceFactionMember', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        "// 186: Get an integer between 0 and 100 (inclusive) that represents how\r\n// oSourceFactionMember's faction feels about oTarget.\r\n// * Return value on error: -1\r\nint GetFactionAverageReputation(object oSourceFactionMember, object oTarget);",
        "// 186: Get an integer between 0 and 100 (inclusive) that represents how\r\n// oSourceFactionMember's faction feels about oTarget.\r\n// * Return value on error: -1\r\nint GetFactionAverageReputation(object oSourceFactionMember, object oTarget);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetFactionAverageGoodEvilAlignment',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', None), ],
        "// 187: Get an integer between 0 and 100 (inclusive) that represents the average\r\n// good/evil alignment of oFactionMember's faction.\r\n// * Return value on error: -1\r\nint GetFactionAverageGoodEvilAlignment(object oFactionMember);",
        "// 187: Get an integer between 0 and 100 (inclusive) that represents the average\r\n// good/evil alignment of oFactionMember's faction.\r\n// * Return value on error: -1\r\nint GetFactionAverageGoodEvilAlignment(object oFactionMember);"
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SoundObjectGetFixedVariance',
        [ScriptParam(DataType.OBJECT, 'oSound', None), ],
        '// 188. SoundObjectGetFixedVariance\r\n// Gets the constant variance at which to play the sound object\r\nfloat SoundObjectGetFixedVariance(object oSound);',
        '// 188. SoundObjectGetFixedVariance\r\n// Gets the constant variance at which to play the sound object\r\nfloat SoundObjectGetFixedVariance(object oSound);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetFactionAverageLevel',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', None), ],
        '// 189: Get the average level of the members of the faction.\r\n// * Return value on error: -1\r\nint GetFactionAverageLevel(object oFactionMember);',
        '// 189: Get the average level of the members of the faction.\r\n// * Return value on error: -1\r\nint GetFactionAverageLevel(object oFactionMember);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetFactionAverageXP',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', None), ],
        '// 190: Get the average XP of the members of the faction.\r\n// * Return value on error: -1\r\nint GetFactionAverageXP(object oFactionMember);',
        '// 190: Get the average XP of the members of the faction.\r\n// * Return value on error: -1\r\nint GetFactionAverageXP(object oFactionMember);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetFactionMostFrequentClass',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', None), ],
        '// 191: Get the most frequent class in the faction - this can be compared with the\r\n// constants CLASS_TYPE_*.\r\n// * Return value on error: -1\r\nint GetFactionMostFrequentClass(object oFactionMember);',
        '// 191: Get the most frequent class in the faction - this can be compared with the\r\n// constants CLASS_TYPE_*.\r\n// * Return value on error: -1\r\nint GetFactionMostFrequentClass(object oFactionMember);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFactionWorstAC',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', 0), ScriptParam(DataType.INT, 'bMustBeVisible', 1), ],
        "// 192: Get the object faction member with the lowest armour class.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionWorstAC(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);",
        "// 192: Get the object faction member with the lowest armour class.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionWorstAC(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFactionBestAC',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', 0), ScriptParam(DataType.INT, 'bMustBeVisible', 1), ],
        "// 193: Get the object faction member with the highest armour class.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionBestAC(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);",
        "// 193: Get the object faction member with the highest armour class.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionBestAC(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);"
    ),
    ScriptFunction(
        DataType.STRING,
        'GetGlobalString',
        [ScriptParam(DataType.STRING, 'sIdentifier', None), ],
        "// 194: Get a global string with the specified identifier\r\n//      This is an EXTREMELY restricted function.  Use only with explicit permission.\r\n//      This means if you are not Preston.  Then go see him if you're even thinking\r\n//      about using this.\r\nstring GetGlobalString( string sIdentifier );",
        "// 194: Get a global string with the specified identifier\r\n//      This is an EXTREMELY restricted function.  Use only with explicit permission.\r\n//      This means if you are not Preston.  Then go see him if you're even thinking\r\n//      about using this.\r\nstring GetGlobalString( string sIdentifier );"
    ),
    ScriptFunction(
        DataType.INT,
        'GetListenPatternNumber',
        [],
        '// 195: In an onConversation script this gets the number of the string pattern\r\n// matched (the one that triggered the script).\r\n// * Returns -1 if no string matched\r\nint GetListenPatternNumber();',
        '// 195: In an onConversation script this gets the number of the string pattern\r\n// matched (the one that triggered the script).\r\n// * Returns -1 if no string matched\r\nint GetListenPatternNumber();'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionJumpToObject',
        [ScriptParam(DataType.OBJECT, 'oToJumpTo', None), ScriptParam(DataType.INT, 'bWalkStraightLineToPoint', 1), ],
        '// 196: Jump to an object ID, or as near to it as possible.\r\nvoid ActionJumpToObject(object oToJumpTo, int bWalkStraightLineToPoint = TRUE);',
        '// 196: Jump to an object ID, or as near to it as possible.\r\nvoid ActionJumpToObject(object oToJumpTo, int bWalkStraightLineToPoint = TRUE);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetWaypointByTag',
        [ScriptParam(DataType.STRING, 'sWaypointTag', None), ],
        '// 197: Get the first waypoint with the specified tag.\r\n// * Returns OBJECT_INVALID if the waypoint cannot be found.\r\nobject GetWaypointByTag(string sWaypointTag);',
        '// 197: Get the first waypoint with the specified tag.\r\n// * Returns OBJECT_INVALID if the waypoint cannot be found.\r\nobject GetWaypointByTag(string sWaypointTag);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetTransitionTarget',
        [ScriptParam(DataType.OBJECT, 'oTransition', None), ],
        '// 198: Get the destination (a waypoint or a door) for a trigger or a door.\r\n// * Returns OBJECT_INVALID if oTransition is not a valid trigger or door.\r\nobject GetTransitionTarget(object oTransition);',
        '// 198: Get the destination (a waypoint or a door) for a trigger or a door.\r\n// * Returns OBJECT_INVALID if oTransition is not a valid trigger or door.\r\nobject GetTransitionTarget(object oTransition);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectLinkEffects',
        [ScriptParam(DataType.EFFECT, 'eChildEffect', None), ScriptParam(DataType.EFFECT, 'eParentEffect', None), ],
        '// 199: Link the two supplied effects, returning eChildEffect as a child of\r\n// eParentEffect.\r\n// Note: When applying linked effects if the target is immune to all valid\r\n// effects all other effects will be removed as well. This means that if you\r\n// apply a visual effect and a silence effect (in a link) and the target is\r\n// immune to the silence effect that the visual effect will get removed as well.\r\n// Visual Effects are not considered "valid" effects for the purposes of\r\n// determining if an effect will be removed or not and as such should never be\r\n// packaged *only* with other visual effects in a link.\r\neffect EffectLinkEffects(effect eChildEffect, effect eParentEffect );',
        '// 199: Link the two supplied effects, returning eChildEffect as a child of\r\n// eParentEffect.\r\n// Note: When applying linked effects if the target is immune to all valid\r\n// effects all other effects will be removed as well. This means that if you\r\n// apply a visual effect and a silence effect (in a link) and the target is\r\n// immune to the silence effect that the visual effect will get removed as well.\r\n// Visual Effects are not considered "valid" effects for the purposes of\r\n// determining if an effect will be removed or not and as such should never be\r\n// packaged *only* with other visual effects in a link.\r\neffect EffectLinkEffects(effect eChildEffect, effect eParentEffect );'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetObjectByTag',
        [ScriptParam(DataType.STRING, 'sTag', None), ScriptParam(DataType.INT, 'nNth', 0), ],
        '// 200: Get the nNth object with the specified tag.\r\n// - sTag\r\n// - nNth: the nth object with this tag may be requested\r\n// * Returns OBJECT_INVALID if the object cannot be found.\r\nobject GetObjectByTag(string sTag, int nNth = 0);',
        '// 200: Get the nNth object with the specified tag.\r\n// - sTag\r\n// - nNth: the nth object with this tag may be requested\r\n// * Returns OBJECT_INVALID if the object cannot be found.\r\nobject GetObjectByTag(string sTag, int nNth = 0);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AdjustAlignment',
        [ScriptParam(DataType.OBJECT, 'oSubject', None), ScriptParam(DataType.INT, 'nAlignment', None), ScriptParam(DataType.INT, 'nShift', None), ],
        "// 201: Adjust the alignment of oSubject.\r\n// - oSubject\r\n// - nAlignment:\r\n//   -> ALIGNMENT_LIGHT_SIDE/ALIGNMENT_DARK_SIDE: oSubject's\r\n//      alignment will be shifted in the direction specified\r\n//   -> ALIGNMENT_NEUTRAL: nShift is applied to oSubject's dark side/light side\r\n//      alignment value in the direction which is towards neutrality.\r\n//     e.g. If oSubject has an alignment value of 80 (i.e. light side)\r\n//          then if nShift is 15, the alignment value will become (80-15) = 65\r\n//     Furthermore, the shift will at most take the alignment value to 50 and\r\n//     not beyond.\r\n//     e.g. If oSubject has an alignment value of 40 then if nShift is 15,\r\n//          the aligment value will become 50\r\n// - nShift: this is the desired shift in alignment\r\n// * No return value\r\nvoid AdjustAlignment(object oSubject, int nAlignment, int nShift);",
        "// 201: Adjust the alignment of oSubject.\r\n// - oSubject\r\n// - nAlignment:\r\n//   -> ALIGNMENT_LIGHT_SIDE/ALIGNMENT_DARK_SIDE: oSubject's\r\n//      alignment will be shifted in the direction specified\r\n//   -> ALIGNMENT_NEUTRAL: nShift is applied to oSubject's dark side/light side\r\n//      alignment value in the direction which is towards neutrality.\r\n//     e.g. If oSubject has an alignment value of 80 (i.e. light side)\r\n//          then if nShift is 15, the alignment value will become (80-15) = 65\r\n//     Furthermore, the shift will at most take the alignment value to 50 and\r\n//     not beyond.\r\n//     e.g. If oSubject has an alignment value of 40 then if nShift is 15,\r\n//          the aligment value will become 50\r\n// - nShift: this is the desired shift in alignment\r\n// * No return value\r\nvoid AdjustAlignment(object oSubject, int nAlignment, int nShift);"
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionWait',
        [ScriptParam(DataType.FLOAT, 'fSeconds', None), ],
        '// 202: Do nothing for fSeconds seconds.\r\nvoid ActionWait(float fSeconds);',
        '// 202: Do nothing for fSeconds seconds.\r\nvoid ActionWait(float fSeconds);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetAreaTransitionBMP',
        [ScriptParam(DataType.INT, 'nPredefinedAreaTransition', None), ScriptParam(DataType.STRING, 'sCustomAreaTransitionBMP', ''), ],
        '// 203: Set the transition bitmap of a player; this should only be called in area\r\n// transition scripts. This action should be run by the person "clicking" the\r\n// area transition via AssignCommand.\r\n// - nPredefinedAreaTransition:\r\n//   -> To use a predefined area transition bitmap, use one of AREA_TRANSITION_*\r\n//   -> To use a custom, user-defined area transition bitmap, use\r\n//      AREA_TRANSITION_USER_DEFINED and specify the filename in the second\r\n//      parameter\r\n// - sCustomAreaTransitionBMP: this is the filename of a custom, user-defined\r\n//   area transition bitmap\r\nvoid SetAreaTransitionBMP(int nPredefinedAreaTransition, string sCustomAreaTransitionBMP = "");',
        '// 203: Set the transition bitmap of a player; this should only be called in area\r\n// transition scripts. This action should be run by the person "clicking" the\r\n// area transition via AssignCommand.\r\n// - nPredefinedAreaTransition:\r\n//   -> To use a predefined area transition bitmap, use one of AREA_TRANSITION_*\r\n//   -> To use a custom, user-defined area transition bitmap, use\r\n//      AREA_TRANSITION_USER_DEFINED and specify the filename in the second\r\n//      parameter\r\n// - sCustomAreaTransitionBMP: this is the filename of a custom, user-defined\r\n//   area transition bitmap\r\nvoid SetAreaTransitionBMP(int nPredefinedAreaTransition, string sCustomAreaTransitionBMP = "");'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionStartConversation',
        [ScriptParam(DataType.OBJECT, 'oObjectToConverse', None), ScriptParam(DataType.STRING, 'sDialogResRef', ''), ScriptParam(DataType.INT, 'bPrivateConversation', 0), ScriptParam(DataType.INT, 'nConversationType', 0), ScriptParam(DataType.INT, 'bIgnoreStartRange', 0), ScriptParam(DataType.STRING, 'sNameObjectToIgnore1', ''), ScriptParam(DataType.STRING, 'sNameObjectToIgnore2', ''), ScriptParam(DataType.STRING, 'sNameObjectToIgnore3', ''), ScriptParam(DataType.STRING, 'sNameObjectToIgnore4', ''), ScriptParam(DataType.STRING, 'sNameObjectToIgnore5', ''), ScriptParam(DataType.STRING, 'sNameObjectToIgnore6', ''), ScriptParam(DataType.INT, 'bUseLeader', 0), ],
        '// 204: Starts a conversation with oObjectToConverseWith - this will cause their\r\n// OnDialog event to fire.\r\n// - oObjectToConverseWith\r\n// - sDialogResRef: If this is blank, the creature\'s own dialogue file will be used\r\n// - bPrivateConversation: If this is blank, the default is FALSE.\r\n// - nConversationType - If this is blank the default will be Cinematic, ie. a normal conversation type\r\n//                                  other choices inclue: CONVERSATION_TYPE_COMPUTER\r\n//   UPDATE:  nConversationType actually has no meaning anymore.  This has been replaced by a flag in the dialog editor.  However\r\n//                for backwards compatability it has been left here.  So when using this command place CONVERSATION_TYPE_CINEMATIC in here. - DJF\r\n// - bIgnoreStartRange - If this is blank the default will be FALSE, ie. Start conversation ranges are in effect\r\n//                                                                      Setting this to TRUE will cause creatures to start a conversation without requiring to close\r\n//                                                                      the distance between the two object in dialog.\r\n// - sNameObjectToIgnore1-6 - Normally objects in the animation list of the dialog editor have to be available for animations on that node to work\r\n//                                        these 6 strings are to indicate 6 objects that don’t need to be available for things to proceed.  The string should be EXACTLY\r\n//                                        the same as the string that it represents in the dialog editor.\r\nvoid ActionStartConversation(object oObjectToConverse, string sDialogResRef  =  "", int bPrivateConversation  =  FALSE, int nConversationType  =  CONVERSATION_TYPE_CINEMATIC, int bIgnoreStartRange  =  FALSE, string sNameObjectToIgnore1  =  "", string sNameObjectToIgnore2  =  "", string sNameObjectToIgnore3  =  "", string sNameObjectToIgnore4  =  "", string sNameObjectToIgnore5  =  "", string sNameObjectToIgnore6  =  "", int bUseLeader  =  FALSE);',
        '// 204: Starts a conversation with oObjectToConverseWith - this will cause their\r\n// OnDialog event to fire.\r\n// - oObjectToConverseWith\r\n// - sDialogResRef: If this is blank, the creature\'s own dialogue file will be used\r\n// - bPrivateConversation: If this is blank, the default is FALSE.\r\n// - nConversationType - If this is blank the default will be Cinematic, ie. a normal conversation type\r\n//                                  other choices inclue: CONVERSATION_TYPE_COMPUTER\r\n//   UPDATE:  nConversationType actually has no meaning anymore.  This has been replaced by a flag in the dialog editor.  However\r\n//                for backwards compatability it has been left here.  So when using this command place CONVERSATION_TYPE_CINEMATIC in here. - DJF\r\n// - bIgnoreStartRange - If this is blank the default will be FALSE, ie. Start conversation ranges are in effect\r\n//                                                                      Setting this to TRUE will cause creatures to start a conversation without requiring to close\r\n//                                                                      the distance between the two object in dialog.\r\n// - sNameObjectToIgnore1-6 - Normally objects in the animation list of the dialog editor have to be available for animations on that node to work\r\n//                                        these 6 strings are to indicate 6 objects that don’t need to be available for things to proceed.  The string should be EXACTLY\r\n//                                        the same as the string that it represents in the dialog editor.\r\nvoid ActionStartConversation(object oObjectToConverse, string sDialogResRef  =  "", int bPrivateConversation  =  FALSE, int nConversationType  =  CONVERSATION_TYPE_CINEMATIC, int bIgnoreStartRange  =  FALSE, string sNameObjectToIgnore1  =  "", string sNameObjectToIgnore2  =  "", string sNameObjectToIgnore3  =  "", string sNameObjectToIgnore4  =  "", string sNameObjectToIgnore5  =  "", string sNameObjectToIgnore6  =  "", int bUseLeader  =  FALSE);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionPauseConversation',
        [],
        '// 205: Pause the current conversation.\r\nvoid ActionPauseConversation();',
        '// 205: Pause the current conversation.\r\nvoid ActionPauseConversation();'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionResumeConversation',
        [],
        '// 206: Resume a conversation after it has been paused.\r\nvoid ActionResumeConversation();',
        '// 206: Resume a conversation after it has been paused.\r\nvoid ActionResumeConversation();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectBeam',
        [ScriptParam(DataType.INT, 'nBeamVisualEffect', None), ScriptParam(DataType.OBJECT, 'oEffector', None), ScriptParam(DataType.INT, 'nBodyPart', None), ScriptParam(DataType.INT, 'bMissEffect', 0), ],
        '// 207: Create a Beam effect.\r\n// - nBeamVisualEffect: VFX_BEAM_*\r\n// - oEffector: the beam is emitted from this creature\r\n// - nBodyPart: BODY_NODE_*\r\n// - bMissEffect: If this is TRUE, the beam will fire to a random vector near or\r\n//   past the target\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nBeamVisualEffect is\r\n//   not valid.\r\neffect EffectBeam(int nBeamVisualEffect, object oEffector, int nBodyPart, int bMissEffect = FALSE);',
        '// 207: Create a Beam effect.\r\n// - nBeamVisualEffect: VFX_BEAM_*\r\n// - oEffector: the beam is emitted from this creature\r\n// - nBodyPart: BODY_NODE_*\r\n// - bMissEffect: If this is TRUE, the beam will fire to a random vector near or\r\n//   past the target\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nBeamVisualEffect is\r\n//   not valid.\r\neffect EffectBeam(int nBeamVisualEffect, object oEffector, int nBodyPart, int bMissEffect = FALSE);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetReputation',
        [ScriptParam(DataType.OBJECT, 'oSource', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 208: Get an integer between 0 and 100 (inclusive) that represents how oSource\r\n// feels about oTarget.\r\n// -> 0-10 means oSource is hostile to oTarget\r\n// -> 11-89 means oSource is neutral to oTarget\r\n// -> 90-100 means oSource is friendly to oTarget\r\n// * Returns -1 if oSource or oTarget does not identify a valid object\r\nint GetReputation(object oSource, object oTarget);',
        '// 208: Get an integer between 0 and 100 (inclusive) that represents how oSource\r\n// feels about oTarget.\r\n// -> 0-10 means oSource is hostile to oTarget\r\n// -> 11-89 means oSource is neutral to oTarget\r\n// -> 90-100 means oSource is friendly to oTarget\r\n// * Returns -1 if oSource or oTarget does not identify a valid object\r\nint GetReputation(object oSource, object oTarget);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AdjustReputation',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.OBJECT, 'oSourceFactionMember', None), ScriptParam(DataType.INT, 'nAdjustment', None), ],
        "// 209: Adjust how oSourceFactionMember's faction feels about oTarget by the\r\n// specified amount.\r\n// Note: This adjusts Faction Reputation, how the entire faction that\r\n// oSourceFactionMember is in, feels about oTarget.\r\n// * No return value\r\nvoid AdjustReputation(object oTarget, object oSourceFactionMember, int nAdjustment);",
        "// 209: Adjust how oSourceFactionMember's faction feels about oTarget by the\r\n// specified amount.\r\n// Note: This adjusts Faction Reputation, how the entire faction that\r\n// oSourceFactionMember is in, feels about oTarget.\r\n// * No return value\r\nvoid AdjustReputation(object oTarget, object oSourceFactionMember, int nAdjustment);"
    ),
    ScriptFunction(
        DataType.STRING,
        'GetModuleFileName',
        [],
        '// 210: Gets the actual file name of the current module\r\nstring GetModuleFileName();',
        '// 210: Gets the actual file name of the current module\r\nstring GetModuleFileName();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetGoingToBeAttackedBy',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 211: Get the creature that is going to attack oTarget.\r\n// Note: This value is cleared out at the end of every combat round and should\r\n// not be used in any case except when getting a "going to be attacked" shout\r\n// from the master creature (and this creature is a henchman)\r\n// * Returns OBJECT_INVALID if oTarget is not a valid creature.\r\nobject GetGoingToBeAttackedBy(object oTarget);',
        '// 211: Get the creature that is going to attack oTarget.\r\n// Note: This value is cleared out at the end of every combat round and should\r\n// not be used in any case except when getting a "going to be attacked" shout\r\n// from the master creature (and this creature is a henchman)\r\n// * Returns OBJECT_INVALID if oTarget is not a valid creature.\r\nobject GetGoingToBeAttackedBy(object oTarget);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectForceResistanceIncrease',
        [ScriptParam(DataType.INT, 'nValue', None), ],
        '// 212: Create a Force Resistance Increase effect.\r\n// - nValue: size of Force Resistance increase\r\neffect EffectForceResistanceIncrease(int nValue);',
        '// 212: Create a Force Resistance Increase effect.\r\n// - nValue: size of Force Resistance increase\r\neffect EffectForceResistanceIncrease(int nValue);'
    ),
    ScriptFunction(
        DataType.LOCATION,
        'GetLocation',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 213: Get the location of oObject.\r\nlocation GetLocation(object oObject);',
        '// 213: Get the location of oObject.\r\nlocation GetLocation(object oObject);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionJumpToLocation',
        [ScriptParam(DataType.LOCATION, 'lLocation', None), ],
        '// 214: The subject will jump to lLocation instantly (even between areas).\r\n// If lLocation is invalid, nothing will happen.\r\nvoid ActionJumpToLocation(location lLocation);',
        '// 214: The subject will jump to lLocation instantly (even between areas).\r\n// If lLocation is invalid, nothing will happen.\r\nvoid ActionJumpToLocation(location lLocation);'
    ),
    ScriptFunction(
        DataType.LOCATION,
        'Location',
        [ScriptParam(DataType.VECTOR, 'vPosition', None), ScriptParam(DataType.FLOAT, 'fOrientation', None), ],
        '// 215: Create a location.\r\nlocation Location(vector vPosition, float fOrientation);',
        '// 215: Create a location.\r\nlocation Location(vector vPosition, float fOrientation);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ApplyEffectAtLocation',
        [ScriptParam(DataType.INT, 'nDurationType', None), ScriptParam(DataType.EFFECT, 'eEffect', None), ScriptParam(DataType.LOCATION, 'lLocation', None), ScriptParam(DataType.FLOAT, 'fDuration', 0.0), ],
        '// 216: Apply eEffect at lLocation.\r\nvoid ApplyEffectAtLocation(int nDurationType, effect eEffect, location lLocation, float fDuration = 0.0f);',
        '// 216: Apply eEffect at lLocation.\r\nvoid ApplyEffectAtLocation(int nDurationType, effect eEffect, location lLocation, float fDuration = 0.0f);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsPC',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 217: * Returns TRUE if oCreature is a Player Controlled character.\r\nint GetIsPC(object oCreature);',
        '// 217: * Returns TRUE if oCreature is a Player Controlled character.\r\nint GetIsPC(object oCreature);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'FeetToMeters',
        [ScriptParam(DataType.FLOAT, 'fFeet', None), ],
        '// 218: Convert fFeet into a number of meters.\r\nfloat FeetToMeters(float fFeet);',
        '// 218: Convert fFeet into a number of meters.\r\nfloat FeetToMeters(float fFeet);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'YardsToMeters',
        [ScriptParam(DataType.FLOAT, 'fYards', None), ],
        '// 219: Convert fYards into a number of meters.\r\nfloat YardsToMeters(float fYards);',
        '// 219: Convert fYards into a number of meters.\r\nfloat YardsToMeters(float fYards);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ApplyEffectToObject',
        [ScriptParam(DataType.INT, 'nDurationType', None), ScriptParam(DataType.EFFECT, 'eEffect', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.FLOAT, 'fDuration', 0.0), ],
        '// 220: Apply eEffect to oTarget.\r\nvoid ApplyEffectToObject(int nDurationType, effect eEffect, object oTarget, float fDuration = 0.0f);',
        '// 220: Apply eEffect to oTarget.\r\nvoid ApplyEffectToObject(int nDurationType, effect eEffect, object oTarget, float fDuration = 0.0f);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SpeakString',
        [ScriptParam(DataType.STRING, 'sStringToSpeak', None), ScriptParam(DataType.INT, 'nTalkVolume', 0), ],
        '// 221: The caller will immediately speak sStringToSpeak (this is different from\r\n// ActionSpeakString)\r\n// - sStringToSpeak\r\n// - nTalkVolume: TALKVOLUME_*\r\nvoid SpeakString(string sStringToSpeak, int nTalkVolume = TALKVOLUME_TALK);',
        '// 221: The caller will immediately speak sStringToSpeak (this is different from\r\n// ActionSpeakString)\r\n// - sStringToSpeak\r\n// - nTalkVolume: TALKVOLUME_*\r\nvoid SpeakString(string sStringToSpeak, int nTalkVolume = TALKVOLUME_TALK);'
    ),
    ScriptFunction(
        DataType.LOCATION,
        'GetSpellTargetLocation',
        [],
        "// 222: Get the location of the caller's last spell target.\r\nlocation GetSpellTargetLocation();",
        "// 222: Get the location of the caller's last spell target.\r\nlocation GetSpellTargetLocation();"
    ),
    ScriptFunction(
        DataType.VECTOR,
        'GetPositionFromLocation',
        [ScriptParam(DataType.LOCATION, 'lLocation', None), ],
        '// 223: Get the position vector from lLocation.\r\nvector GetPositionFromLocation(location lLocation);',
        '// 223: Get the position vector from lLocation.\r\nvector GetPositionFromLocation(location lLocation);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectBodyFuel',
        [],
        '// 224: the effect of body fule.. convers HP -> FP i think\r\neffect EffectBodyFuel( );',
        '// 224: the effect of body fule.. convers HP -> FP i think\r\neffect EffectBodyFuel( );'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetFacingFromLocation',
        [ScriptParam(DataType.LOCATION, 'lLocation', None), ],
        '// 225: Get the orientation value from lLocation.\r\nfloat GetFacingFromLocation(location lLocation);',
        '// 225: Get the orientation value from lLocation.\r\nfloat GetFacingFromLocation(location lLocation);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNearestCreatureToLocation',
        [ScriptParam(DataType.INT, 'nFirstCriteriaType', None), ScriptParam(DataType.INT, 'nFirstCriteriaValue', None), ScriptParam(DataType.LOCATION, 'lLocation', None), ScriptParam(DataType.INT, 'nNth', 1), ScriptParam(DataType.INT, 'nSecondCriteriaType', -1), ScriptParam(DataType.INT, 'nSecondCriteriaValue', -1), ScriptParam(DataType.INT, 'nThirdCriteriaType', -1), ScriptParam(DataType.INT, 'nThirdCriteriaValue', -1), ],
        "// 226: Get the creature nearest to lLocation, subject to all the criteria specified.\r\n// - nFirstCriteriaType: CREATURE_TYPE_*\r\n// - nFirstCriteriaValue:\r\n//   -> CLASS_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_CLASS\r\n//   -> SPELL_* if nFirstCriteriaType was CREATURE_TYPE_DOES_NOT_HAVE_SPELL_EFFECT\r\n//      or CREATURE_TYPE_HAS_SPELL_EFFECT\r\n//   -> TRUE or FALSE if nFirstCriteriaType was CREATURE_TYPE_IS_ALIVE\r\n//   -> PERCEPTION_* if nFirstCriteriaType was CREATURE_TYPE_PERCEPTION\r\n//   -> PLAYER_CHAR_IS_PC or PLAYER_CHAR_NOT_PC if nFirstCriteriaType was\r\n//      CREATURE_TYPE_PLAYER_CHAR\r\n//   -> RACIAL_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_RACIAL_TYPE\r\n//   -> REPUTATION_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_REPUTATION\r\n//   For example, to get the nearest PC, use\r\n//   (CREATURE_TYPE_PLAYER_CHAR, PLAYER_CHAR_IS_PC)\r\n// - lLocation: We're trying to find the creature of the specified type that is\r\n//   nearest to lLocation\r\n// - nNth: We don't have to find the first nearest: we can find the Nth nearest....\r\n// - nSecondCriteriaType: This is used in the same way as nFirstCriteriaType to\r\n//   further specify the type of creature that we are looking for.\r\n// - nSecondCriteriaValue: This is used in the same way as nFirstCriteriaValue\r\n//   to further specify the type of creature that we are looking for.\r\n// - nThirdCriteriaType: This is used in the same way as nFirstCriteriaType to\r\n//   further specify the type of creature that we are looking for.\r\n// - nThirdCriteriaValue: This is used in the same way as nFirstCriteriaValue to\r\n//   further specify the type of creature that we are looking for.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestCreatureToLocation(int nFirstCriteriaType, int nFirstCriteriaValue,  location lLocation, int nNth = 1, int nSecondCriteriaType = -1, int nSecondCriteriaValue = -1, int nThirdCriteriaType = -1,  int nThirdCriteriaValue = -1 );",
        "// 226: Get the creature nearest to lLocation, subject to all the criteria specified.\r\n// - nFirstCriteriaType: CREATURE_TYPE_*\r\n// - nFirstCriteriaValue:\r\n//   -> CLASS_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_CLASS\r\n//   -> SPELL_* if nFirstCriteriaType was CREATURE_TYPE_DOES_NOT_HAVE_SPELL_EFFECT\r\n//      or CREATURE_TYPE_HAS_SPELL_EFFECT\r\n//   -> TRUE or FALSE if nFirstCriteriaType was CREATURE_TYPE_IS_ALIVE\r\n//   -> PERCEPTION_* if nFirstCriteriaType was CREATURE_TYPE_PERCEPTION\r\n//   -> PLAYER_CHAR_IS_PC or PLAYER_CHAR_NOT_PC if nFirstCriteriaType was\r\n//      CREATURE_TYPE_PLAYER_CHAR\r\n//   -> RACIAL_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_RACIAL_TYPE\r\n//   -> REPUTATION_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_REPUTATION\r\n//   For example, to get the nearest PC, use\r\n//   (CREATURE_TYPE_PLAYER_CHAR, PLAYER_CHAR_IS_PC)\r\n// - lLocation: We're trying to find the creature of the specified type that is\r\n//   nearest to lLocation\r\n// - nNth: We don't have to find the first nearest: we can find the Nth nearest....\r\n// - nSecondCriteriaType: This is used in the same way as nFirstCriteriaType to\r\n//   further specify the type of creature that we are looking for.\r\n// - nSecondCriteriaValue: This is used in the same way as nFirstCriteriaValue\r\n//   to further specify the type of creature that we are looking for.\r\n// - nThirdCriteriaType: This is used in the same way as nFirstCriteriaType to\r\n//   further specify the type of creature that we are looking for.\r\n// - nThirdCriteriaValue: This is used in the same way as nFirstCriteriaValue to\r\n//   further specify the type of creature that we are looking for.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestCreatureToLocation(int nFirstCriteriaType, int nFirstCriteriaValue,  location lLocation, int nNth = 1, int nSecondCriteriaType = -1, int nSecondCriteriaValue = -1, int nThirdCriteriaType = -1,  int nThirdCriteriaValue = -1 );"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNearestObject',
        [ScriptParam(DataType.INT, 'nObjectType', 32767), ScriptParam(DataType.OBJECT, 'oTarget', 0), ScriptParam(DataType.INT, 'nNth', 1), ],
        '// 227: Get the Nth object nearest to oTarget that is of the specified type.\r\n// - nObjectType: OBJECT_TYPE_*\r\n// - oTarget\r\n// - nNth\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestObject(int nObjectType = OBJECT_TYPE_ALL, object oTarget = OBJECT_SELF, int nNth = 1);',
        '// 227: Get the Nth object nearest to oTarget that is of the specified type.\r\n// - nObjectType: OBJECT_TYPE_*\r\n// - oTarget\r\n// - nNth\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestObject(int nObjectType = OBJECT_TYPE_ALL, object oTarget = OBJECT_SELF, int nNth = 1);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNearestObjectToLocation',
        [ScriptParam(DataType.INT, 'nObjectType', None), ScriptParam(DataType.LOCATION, 'lLocation', None), ScriptParam(DataType.INT, 'nNth', 1), ],
        '// 228: Get the nNth object nearest to lLocation that is of the specified type.\r\n// - nObjectType: OBJECT_TYPE_*\r\n// - lLocation\r\n// - nNth\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestObjectToLocation(int nObjectType, location lLocation, int nNth = 1);',
        '// 228: Get the nNth object nearest to lLocation that is of the specified type.\r\n// - nObjectType: OBJECT_TYPE_*\r\n// - lLocation\r\n// - nNth\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestObjectToLocation(int nObjectType, location lLocation, int nNth = 1);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNearestObjectByTag',
        [ScriptParam(DataType.STRING, 'sTag', None), ScriptParam(DataType.OBJECT, 'oTarget', 0), ScriptParam(DataType.INT, 'nNth', 1), ],
        '// 229: Get the nth Object nearest to oTarget that has sTag as its tag.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestObjectByTag(string sTag, object oTarget = OBJECT_SELF, int nNth = 1);',
        '// 229: Get the nth Object nearest to oTarget that has sTag as its tag.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestObjectByTag(string sTag, object oTarget = OBJECT_SELF, int nNth = 1);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'IntToFloat',
        [ScriptParam(DataType.INT, 'nInteger', None), ],
        '// 230: Convert nInteger into a floating point number.\r\nfloat IntToFloat(int nInteger);',
        '// 230: Convert nInteger into a floating point number.\r\nfloat IntToFloat(int nInteger);'
    ),
    ScriptFunction(
        DataType.INT,
        'FloatToInt',
        [ScriptParam(DataType.FLOAT, 'fFloat', None), ],
        '// 231: Convert fFloat into the nearest integer.\r\nint FloatToInt(float fFloat);',
        '// 231: Convert fFloat into the nearest integer.\r\nint FloatToInt(float fFloat);'
    ),
    ScriptFunction(
        DataType.INT,
        'StringToInt',
        [ScriptParam(DataType.STRING, 'sNumber', None), ],
        '// 232: Convert sNumber into an integer.\r\nint StringToInt(string sNumber);',
        '// 232: Convert sNumber into an integer.\r\nint StringToInt(string sNumber);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'StringToFloat',
        [ScriptParam(DataType.STRING, 'sNumber', None), ],
        '// 233: Convert sNumber into a floating point number.\r\nfloat StringToFloat(string sNumber);',
        '// 233: Convert sNumber into a floating point number.\r\nfloat StringToFloat(string sNumber);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionCastSpellAtLocation',
        [ScriptParam(DataType.INT, 'nSpell', None), ScriptParam(DataType.LOCATION, 'lTargetLocation', None), ScriptParam(DataType.INT, 'nMetaMagic', 0), ScriptParam(DataType.INT, 'bCheat', 0), ScriptParam(DataType.INT, 'nProjectilePathType', 0), ScriptParam(DataType.INT, 'bInstantSpell', 0), ],
        "// 234: Cast spell nSpell at lTargetLocation.\r\n// - nSpell: SPELL_*\r\n// - lTargetLocation\r\n// - nMetaMagic: METAMAGIC_*\r\n// - bCheat: If this is TRUE, then the executor of the action doesn't have to be\r\n//   able to cast the spell.\r\n// - nProjectilePathType: PROJECTILE_PATH_TYPE_*\r\n// - bInstantSpell: If this is TRUE, the spell is cast immediately; this allows\r\n//   the end-user to simulate\r\n//   a high-level magic user having lots of advance warning of impending trouble.\r\nvoid   ActionCastSpellAtLocation(int nSpell, location lTargetLocation, int nMetaMagic = 0, int bCheat = FALSE, int nProjectilePathType = PROJECTILE_PATH_TYPE_DEFAULT, int bInstantSpell = FALSE);",
        "// 234: Cast spell nSpell at lTargetLocation.\r\n// - nSpell: SPELL_*\r\n// - lTargetLocation\r\n// - nMetaMagic: METAMAGIC_*\r\n// - bCheat: If this is TRUE, then the executor of the action doesn't have to be\r\n//   able to cast the spell.\r\n// - nProjectilePathType: PROJECTILE_PATH_TYPE_*\r\n// - bInstantSpell: If this is TRUE, the spell is cast immediately; this allows\r\n//   the end-user to simulate\r\n//   a high-level magic user having lots of advance warning of impending trouble.\r\nvoid   ActionCastSpellAtLocation(int nSpell, location lTargetLocation, int nMetaMagic = 0, int bCheat = FALSE, int nProjectilePathType = PROJECTILE_PATH_TYPE_DEFAULT, int bInstantSpell = FALSE);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsEnemy',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.OBJECT, 'oSource', 0), ],
        '// 235: * Returns TRUE if oSource considers oTarget as an enemy.\r\nint GetIsEnemy(object oTarget, object oSource = OBJECT_SELF);',
        '// 235: * Returns TRUE if oSource considers oTarget as an enemy.\r\nint GetIsEnemy(object oTarget, object oSource = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsFriend',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.OBJECT, 'oSource', 0), ],
        '// 236: * Returns TRUE if oSource considers oTarget as a friend.\r\nint GetIsFriend(object oTarget, object oSource = OBJECT_SELF);',
        '// 236: * Returns TRUE if oSource considers oTarget as a friend.\r\nint GetIsFriend(object oTarget, object oSource = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsNeutral',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.OBJECT, 'oSource', 0), ],
        '// 237: * Returns TRUE if oSource considers oTarget as neutral.\r\nint GetIsNeutral(object oTarget, object oSource = OBJECT_SELF);',
        '// 237: * Returns TRUE if oSource considers oTarget as neutral.\r\nint GetIsNeutral(object oTarget, object oSource = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetPCSpeaker',
        [],
        '// 238: Get the PC that is involved in the conversation.\r\n// * Returns OBJECT_INVALID on error.\r\nobject GetPCSpeaker();',
        '// 238: Get the PC that is involved in the conversation.\r\n// * Returns OBJECT_INVALID on error.\r\nobject GetPCSpeaker();'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetStringByStrRef',
        [ScriptParam(DataType.INT, 'nStrRef', None), ],
        '// 239: Get a string from the talk table using nStrRef.\r\nstring GetStringByStrRef(int nStrRef);',
        '// 239: Get a string from the talk table using nStrRef.\r\nstring GetStringByStrRef(int nStrRef);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionSpeakStringByStrRef',
        [ScriptParam(DataType.INT, 'nStrRef', None), ScriptParam(DataType.INT, 'nTalkVolume', 0), ],
        '// 240: Causes the creature to speak a translated string.\r\n// - nStrRef: Reference of the string in the talk table\r\n// - nTalkVolume: TALKVOLUME_*\r\nvoid ActionSpeakStringByStrRef(int nStrRef, int nTalkVolume = TALKVOLUME_TALK);',
        '// 240: Causes the creature to speak a translated string.\r\n// - nStrRef: Reference of the string in the talk table\r\n// - nTalkVolume: TALKVOLUME_*\r\nvoid ActionSpeakStringByStrRef(int nStrRef, int nTalkVolume = TALKVOLUME_TALK);'
    ),
    ScriptFunction(
        DataType.VOID,
        'DestroyObject',
        [ScriptParam(DataType.OBJECT, 'oDestroy', None), ScriptParam(DataType.FLOAT, 'fDelay', 0.0), ScriptParam(DataType.INT, 'bNoFade', 0), ScriptParam(DataType.FLOAT, 'fDelayUntilFade', 0.0), ],
        '// 241: Destroy oObject (irrevocably).\r\n// This will not work on modules and areas.\r\n// The bNoFade and fDelayUntilFade are for creatures and placeables only\r\nvoid DestroyObject(object oDestroy, float fDelay = 0.0f, int bNoFade  =  FALSE, float fDelayUntilFade  =  0.0f);',
        '// 241: Destroy oObject (irrevocably).\r\n// This will not work on modules and areas.\r\n// The bNoFade and fDelayUntilFade are for creatures and placeables only\r\nvoid DestroyObject(object oDestroy, float fDelay = 0.0f, int bNoFade  =  FALSE, float fDelayUntilFade  =  0.0f);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetModule',
        [],
        '// 242: Get the module.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetModule();',
        '// 242: Get the module.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetModule();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'CreateObject',
        [ScriptParam(DataType.INT, 'nObjectType', None), ScriptParam(DataType.STRING, 'sTemplate', None), ScriptParam(DataType.LOCATION, 'lLocation', None), ScriptParam(DataType.INT, 'bUseAppearAnimation', 0), ],
        '// 243: Create an object of the specified type at lLocation.\r\n// - nObjectType: OBJECT_TYPE_ITEM, OBJECT_TYPE_CREATURE, OBJECT_TYPE_PLACEABLE,\r\n//   OBJECT_TYPE_STORE\r\n// - sTemplate\r\n// - lLocation\r\n// - bUseAppearAnimation\r\n// Waypoints can now also be created using the CreateObject function.\r\n// nObjectType is: OBJECT_TYPE_WAYPOINT\r\n// sTemplate will be the tag of the waypoint\r\n// lLocation is where the waypoint will be placed\r\n// bUseAppearAnimation is ignored\r\nobject CreateObject(int nObjectType, string sTemplate, location lLocation, int bUseAppearAnimation = FALSE);',
        '// 243: Create an object of the specified type at lLocation.\r\n// - nObjectType: OBJECT_TYPE_ITEM, OBJECT_TYPE_CREATURE, OBJECT_TYPE_PLACEABLE,\r\n//   OBJECT_TYPE_STORE\r\n// - sTemplate\r\n// - lLocation\r\n// - bUseAppearAnimation\r\n// Waypoints can now also be created using the CreateObject function.\r\n// nObjectType is: OBJECT_TYPE_WAYPOINT\r\n// sTemplate will be the tag of the waypoint\r\n// lLocation is where the waypoint will be placed\r\n// bUseAppearAnimation is ignored\r\nobject CreateObject(int nObjectType, string sTemplate, location lLocation, int bUseAppearAnimation = FALSE);'
    ),
    ScriptFunction(
        DataType.EVENT,
        'EventSpellCastAt',
        [ScriptParam(DataType.OBJECT, 'oCaster', None), ScriptParam(DataType.INT, 'nSpell', None), ScriptParam(DataType.INT, 'bHarmful', 1), ],
        '// 244: Create an event which triggers the "SpellCastAt" script\r\nevent EventSpellCastAt(object oCaster, int nSpell, int bHarmful = TRUE);',
        '// 244: Create an event which triggers the "SpellCastAt" script\r\nevent EventSpellCastAt(object oCaster, int nSpell, int bHarmful = TRUE);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastSpellCaster',
        [],
        '// 245: This is for use in a "Spell Cast" script, it gets who cast the spell.\r\n// The spell could have been cast by a creature, placeable or door.\r\n// * Returns OBJECT_INVALID if the caller is not a creature, placeable or door.\r\nobject GetLastSpellCaster();',
        '// 245: This is for use in a "Spell Cast" script, it gets who cast the spell.\r\n// The spell could have been cast by a creature, placeable or door.\r\n// * Returns OBJECT_INVALID if the caller is not a creature, placeable or door.\r\nobject GetLastSpellCaster();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastSpell',
        [],
        '// 246: This is for use in a "Spell Cast" script, it gets the ID of the spell that\r\n// was cast.\r\nint GetLastSpell();',
        '// 246: This is for use in a "Spell Cast" script, it gets the ID of the spell that\r\n// was cast.\r\nint GetLastSpell();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetUserDefinedEventNumber',
        [],
        '// 247: This is for use in a user-defined script, it gets the event number.\r\nint GetUserDefinedEventNumber();',
        '// 247: This is for use in a user-defined script, it gets the event number.\r\nint GetUserDefinedEventNumber();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetSpellId',
        [],
        '// 248: This is for use in a Spell script, it gets the ID of the spell that is being\r\n// cast (SPELL_*).\r\nint GetSpellId();',
        '// 248: This is for use in a Spell script, it gets the ID of the spell that is being\r\n// cast (SPELL_*).\r\nint GetSpellId();'
    ),
    ScriptFunction(
        DataType.STRING,
        'RandomName',
        [],
        '// 249: Generate a random name.\r\nstring RandomName();',
        '// 249: Generate a random name.\r\nstring RandomName();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectPoison',
        [ScriptParam(DataType.INT, 'nPoisonType', None), ],
        '// 250: Create a Poison effect.\r\n// - nPoisonType: POISON_*\r\neffect EffectPoison(int nPoisonType);',
        '// 250: Create a Poison effect.\r\n// - nPoisonType: POISON_*\r\neffect EffectPoison(int nPoisonType);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLoadFromSaveGame',
        [],
        '// 251: Returns whether this script is being run\r\n//      while a load game is in progress\r\nint GetLoadFromSaveGame();',
        '// 251: Returns whether this script is being run\r\n//      while a load game is in progress\r\nint GetLoadFromSaveGame();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectAssuredDeflection',
        [ScriptParam(DataType.INT, 'nReturn', 0), ],
        '// 252: Assured Deflection\r\n// This effect ensures that all projectiles shot at a jedi will be deflected\r\n// without doing an opposed roll.  It takes an optional parameter to say whether\r\n// the deflected projectile will return to the attacker and cause damage\r\neffect EffectAssuredDeflection(int nReturn  =  0);',
        '// 252: Assured Deflection\r\n// This effect ensures that all projectiles shot at a jedi will be deflected\r\n// without doing an opposed roll.  It takes an optional parameter to say whether\r\n// the deflected projectile will return to the attacker and cause damage\r\neffect EffectAssuredDeflection(int nReturn  =  0);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetName',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 253: Get the name of oObject.\r\nstring GetName(object oObject);',
        '// 253: Get the name of oObject.\r\nstring GetName(object oObject);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastSpeaker',
        [],
        '// 254: Use this in a conversation script to get the person with whom you are conversing.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetLastSpeaker();',
        '// 254: Use this in a conversation script to get the person with whom you are conversing.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetLastSpeaker();'
    ),
    ScriptFunction(
        DataType.INT,
        'BeginConversation',
        [ScriptParam(DataType.STRING, 'sResRef', ''), ScriptParam(DataType.OBJECT, 'oObjectToDialog', 1), ],
        '// 255: Use this in an OnDialog script to start up the dialog tree.\r\n// - sResRef: if this is not specified, the default dialog file will be used\r\n// - oObjectToDialog: if this is not specified the person that triggered the\r\n//   event will be used\r\nint BeginConversation(string sResRef = "", object oObjectToDialog = OBJECT_INVALID);',
        '// 255: Use this in an OnDialog script to start up the dialog tree.\r\n// - sResRef: if this is not specified, the default dialog file will be used\r\n// - oObjectToDialog: if this is not specified the person that triggered the\r\n//   event will be used\r\nint BeginConversation(string sResRef = "", object oObjectToDialog = OBJECT_INVALID);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastPerceived',
        [],
        '// 256: Use this in an OnPerception script to get the object that was perceived.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetLastPerceived();',
        '// 256: Use this in an OnPerception script to get the object that was perceived.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetLastPerceived();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastPerceptionHeard',
        [],
        '// 257: Use this in an OnPerception script to determine whether the object that was\r\n// perceived was heard.\r\nint GetLastPerceptionHeard();',
        '// 257: Use this in an OnPerception script to determine whether the object that was\r\n// perceived was heard.\r\nint GetLastPerceptionHeard();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastPerceptionInaudible',
        [],
        '// 258: Use this in an OnPerception script to determine whether the object that was\r\n// perceived has become inaudible.\r\nint GetLastPerceptionInaudible();',
        '// 258: Use this in an OnPerception script to determine whether the object that was\r\n// perceived has become inaudible.\r\nint GetLastPerceptionInaudible();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastPerceptionSeen',
        [],
        '// 259: Use this in an OnPerception script to determine whether the object that was\r\n// perceived was seen.\r\nint GetLastPerceptionSeen();',
        '// 259: Use this in an OnPerception script to determine whether the object that was\r\n// perceived was seen.\r\nint GetLastPerceptionSeen();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastClosedBy',
        [],
        '// 260: Use this in an OnClosed script to get the object that closed the door or placeable.\r\n// * Returns OBJECT_INVALID if the caller is not a valid door or placeable.\r\nobject GetLastClosedBy();',
        '// 260: Use this in an OnClosed script to get the object that closed the door or placeable.\r\n// * Returns OBJECT_INVALID if the caller is not a valid door or placeable.\r\nobject GetLastClosedBy();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastPerceptionVanished',
        [],
        '// 261: Use this in an OnPerception script to determine whether the object that was\r\n// perceived has vanished.\r\nint GetLastPerceptionVanished();',
        '// 261: Use this in an OnPerception script to determine whether the object that was\r\n// perceived has vanished.\r\nint GetLastPerceptionVanished();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFirstInPersistentObject',
        [ScriptParam(DataType.OBJECT, 'oPersistentObject', 0), ScriptParam(DataType.INT, 'nResidentObjectType', 1), ScriptParam(DataType.INT, 'nPersistentZone', 0), ],
        '// 262: Get the first object within oPersistentObject.\r\n// - oPersistentObject\r\n// - nResidentObjectType: OBJECT_TYPE_*\r\n// - nPersistentZone: PERSISTENT_ZONE_ACTIVE. [This could also take the value\r\n//   PERSISTENT_ZONE_FOLLOW, but this is no longer used.]\r\n// * Returns OBJECT_INVALID if no object is found.\r\nobject GetFirstInPersistentObject(object oPersistentObject = OBJECT_SELF, int nResidentObjectType = OBJECT_TYPE_CREATURE, int nPersistentZone = PERSISTENT_ZONE_ACTIVE);',
        '// 262: Get the first object within oPersistentObject.\r\n// - oPersistentObject\r\n// - nResidentObjectType: OBJECT_TYPE_*\r\n// - nPersistentZone: PERSISTENT_ZONE_ACTIVE. [This could also take the value\r\n//   PERSISTENT_ZONE_FOLLOW, but this is no longer used.]\r\n// * Returns OBJECT_INVALID if no object is found.\r\nobject GetFirstInPersistentObject(object oPersistentObject = OBJECT_SELF, int nResidentObjectType = OBJECT_TYPE_CREATURE, int nPersistentZone = PERSISTENT_ZONE_ACTIVE);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNextInPersistentObject',
        [ScriptParam(DataType.OBJECT, 'oPersistentObject', 0), ScriptParam(DataType.INT, 'nResidentObjectType', 1), ScriptParam(DataType.INT, 'nPersistentZone', 0), ],
        '// 263: Get the next object within oPersistentObject.\r\n// - oPersistentObject\r\n// - nResidentObjectType: OBJECT_TYPE_*\r\n// - nPersistentZone: PERSISTENT_ZONE_ACTIVE. [This could also take the value\r\n//   PERSISTENT_ZONE_FOLLOW, but this is no longer used.]\r\n// * Returns OBJECT_INVALID if no object is found.\r\nobject GetNextInPersistentObject(object oPersistentObject = OBJECT_SELF, int nResidentObjectType = OBJECT_TYPE_CREATURE, int nPersistentZone = PERSISTENT_ZONE_ACTIVE);',
        '// 263: Get the next object within oPersistentObject.\r\n// - oPersistentObject\r\n// - nResidentObjectType: OBJECT_TYPE_*\r\n// - nPersistentZone: PERSISTENT_ZONE_ACTIVE. [This could also take the value\r\n//   PERSISTENT_ZONE_FOLLOW, but this is no longer used.]\r\n// * Returns OBJECT_INVALID if no object is found.\r\nobject GetNextInPersistentObject(object oPersistentObject = OBJECT_SELF, int nResidentObjectType = OBJECT_TYPE_CREATURE, int nPersistentZone = PERSISTENT_ZONE_ACTIVE);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetAreaOfEffectCreator',
        [ScriptParam(DataType.OBJECT, 'oAreaOfEffectObject', 0), ],
        '// 264: This returns the creator of oAreaOfEffectObject.\r\n// * Returns OBJECT_INVALID if oAreaOfEffectObject is not a valid Area of Effect object.\r\nobject GetAreaOfEffectCreator(object oAreaOfEffectObject = OBJECT_SELF);',
        '// 264: This returns the creator of oAreaOfEffectObject.\r\n// * Returns OBJECT_INVALID if oAreaOfEffectObject is not a valid Area of Effect object.\r\nobject GetAreaOfEffectCreator(object oAreaOfEffectObject = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'ShowLevelUpGUI',
        [],
        '// 265: Brings up the level up GUI for the player.  The GUI will only show up\r\n//      if the player has gained enough experience points to level up.\r\n// * Returns TRUE if the GUI was successfully brought up; FALSE if not.\r\nint ShowLevelUpGUI();',
        '// 265: Brings up the level up GUI for the player.  The GUI will only show up\r\n//      if the player has gained enough experience points to level up.\r\n// * Returns TRUE if the GUI was successfully brought up; FALSE if not.\r\nint ShowLevelUpGUI();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetItemNonEquippable',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.INT, 'bNonEquippable', None), ],
        '// 266: Flag the specified item as being non-equippable or not.  Set bNonEquippable\r\n//      to TRUE to prevent this item from being equipped, and FALSE to allow\r\n//      the normal equipping checks to determine if the item can be equipped.\r\n// NOTE: This will do nothing if the object passed in is not an item.  Items that\r\n//       are already equipped when this is called will not automatically be\r\n//       unequipped.  These items will just be prevented from being re-equipped\r\n//       should they be unequipped.\r\nvoid SetItemNonEquippable( object oItem, int bNonEquippable );',
        '// 266: Flag the specified item as being non-equippable or not.  Set bNonEquippable\r\n//      to TRUE to prevent this item from being equipped, and FALSE to allow\r\n//      the normal equipping checks to determine if the item can be equipped.\r\n// NOTE: This will do nothing if the object passed in is not an item.  Items that\r\n//       are already equipped when this is called will not automatically be\r\n//       unequipped.  These items will just be prevented from being re-equipped\r\n//       should they be unequipped.\r\nvoid SetItemNonEquippable( object oItem, int bNonEquippable );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetButtonMashCheck',
        [],
        '// 267: GetButtonMashCheck\r\n// This function returns whether the button mash check, used for the combat tutorial, is on\r\nint GetButtonMashCheck();',
        '// 267: GetButtonMashCheck\r\n// This function returns whether the button mash check, used for the combat tutorial, is on\r\nint GetButtonMashCheck();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetButtonMashCheck',
        [ScriptParam(DataType.INT, 'nCheck', None), ],
        '// 268: SetButtonMashCheck\r\n// This function sets the button mash check variable, and is used for turning the check on and off\r\nvoid SetButtonMashCheck(int nCheck);',
        '// 268: SetButtonMashCheck\r\n// This function sets the button mash check variable, and is used for turning the check on and off\r\nvoid SetButtonMashCheck(int nCheck);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectForcePushTargeted',
        [ScriptParam(DataType.LOCATION, 'lCentre', None), ScriptParam(DataType.INT, 'nIgnoreTestDirectLine', 0), ],
        '// 269: EffectForcePushTargeted\r\n// This effect is exactly the same as force push, except it takes a location parameter that specifies\r\n// where the location of the force push is to be done from.  All orientations are also based on this location.\r\n// AMF:  The new ignore test direct line variable should be used with extreme caution\r\n// It overrides geometry checks for force pushes, so that the object that the effect is applied to\r\n// is guaranteed to move that far, ignoring collisions.  It is best used for cutscenes.\r\neffect EffectForcePushTargeted(location lCentre, int nIgnoreTestDirectLine  =  0);',
        '// 269: EffectForcePushTargeted\r\n// This effect is exactly the same as force push, except it takes a location parameter that specifies\r\n// where the location of the force push is to be done from.  All orientations are also based on this location.\r\n// AMF:  The new ignore test direct line variable should be used with extreme caution\r\n// It overrides geometry checks for force pushes, so that the object that the effect is applied to\r\n// is guaranteed to move that far, ignoring collisions.  It is best used for cutscenes.\r\neffect EffectForcePushTargeted(location lCentre, int nIgnoreTestDirectLine  =  0);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectHaste',
        [],
        '// 270: Create a Haste effect.\r\neffect EffectHaste();',
        '// 270: Create a Haste effect.\r\neffect EffectHaste();'
    ),
    ScriptFunction(
        DataType.VOID,
        'GiveItem',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.OBJECT, 'oGiveTo', None), ],
        '// 271: Give oItem to oGiveTo (instant; for similar Action use ActionGiveItem)\r\n// If oItem is not a valid item, or oGiveTo is not a valid object, nothing will\r\n// happen.\r\nvoid GiveItem(object oItem, object oGiveTo);',
        '// 271: Give oItem to oGiveTo (instant; for similar Action use ActionGiveItem)\r\n// If oItem is not a valid item, or oGiveTo is not a valid object, nothing will\r\n// happen.\r\nvoid GiveItem(object oItem, object oGiveTo);'
    ),
    ScriptFunction(
        DataType.STRING,
        'ObjectToString',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 272: Convert oObject into a hexadecimal string.\r\nstring ObjectToString(object oObject);',
        '// 272: Convert oObject into a hexadecimal string.\r\nstring ObjectToString(object oObject);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectImmunity',
        [ScriptParam(DataType.INT, 'nImmunityType', None), ],
        '// 273: Create an Immunity effect.\r\n// - nImmunityType: IMMUNITY_TYPE_*\r\neffect EffectImmunity(int nImmunityType);',
        '// 273: Create an Immunity effect.\r\n// - nImmunityType: IMMUNITY_TYPE_*\r\neffect EffectImmunity(int nImmunityType);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsImmune',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nImmunityType', None), ScriptParam(DataType.OBJECT, 'oVersus', 1), ],
        '// 274: - oCreature\r\n// - nImmunityType: IMMUNITY_TYPE_*\r\n// - oVersus: if this is specified, then we also check for the race and\r\n//   alignment of oVersus\r\n// * Returns TRUE if oCreature has immunity of type nImmunity versus oVersus.\r\nint GetIsImmune(object oCreature, int nImmunityType, object oVersus = OBJECT_INVALID);',
        '// 274: - oCreature\r\n// - nImmunityType: IMMUNITY_TYPE_*\r\n// - oVersus: if this is specified, then we also check for the race and\r\n//   alignment of oVersus\r\n// * Returns TRUE if oCreature has immunity of type nImmunity versus oVersus.\r\nint GetIsImmune(object oCreature, int nImmunityType, object oVersus = OBJECT_INVALID);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDamageImmunityIncrease',
        [ScriptParam(DataType.INT, 'nDamageType', None), ScriptParam(DataType.INT, 'nPercentImmunity', None), ],
        '// 275: Creates a Damage Immunity Increase effect.\r\n// - nDamageType: DAMAGE_TYPE_*\r\n// - nPercentImmunity\r\neffect EffectDamageImmunityIncrease(int nDamageType, int nPercentImmunity);',
        '// 275: Creates a Damage Immunity Increase effect.\r\n// - nDamageType: DAMAGE_TYPE_*\r\n// - nPercentImmunity\r\neffect EffectDamageImmunityIncrease(int nDamageType, int nPercentImmunity);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetEncounterActive',
        [ScriptParam(DataType.OBJECT, 'oEncounter', 0), ],
        '// 276: Determine whether oEncounter is active.\r\nint  GetEncounterActive(object oEncounter = OBJECT_SELF);',
        '// 276: Determine whether oEncounter is active.\r\nint  GetEncounterActive(object oEncounter = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetEncounterActive',
        [ScriptParam(DataType.INT, 'nNewValue', None), ScriptParam(DataType.OBJECT, 'oEncounter', 0), ],
        "// 277: Set oEncounter's active state to nNewValue.\r\n// - nNewValue: TRUE/FALSE\r\n// - oEncounter\r\nvoid SetEncounterActive(int nNewValue, object oEncounter = OBJECT_SELF);",
        "// 277: Set oEncounter's active state to nNewValue.\r\n// - nNewValue: TRUE/FALSE\r\n// - oEncounter\r\nvoid SetEncounterActive(int nNewValue, object oEncounter = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetEncounterSpawnsMax',
        [ScriptParam(DataType.OBJECT, 'oEncounter', 0), ],
        '// 278: Get the maximum number of times that oEncounter will spawn.\r\nint GetEncounterSpawnsMax(object oEncounter = OBJECT_SELF);',
        '// 278: Get the maximum number of times that oEncounter will spawn.\r\nint GetEncounterSpawnsMax(object oEncounter = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetEncounterSpawnsMax',
        [ScriptParam(DataType.INT, 'nNewValue', None), ScriptParam(DataType.OBJECT, 'oEncounter', 0), ],
        '// 279: Set the maximum number of times that oEncounter can spawn\r\nvoid SetEncounterSpawnsMax(int nNewValue, object oEncounter = OBJECT_SELF);',
        '// 279: Set the maximum number of times that oEncounter can spawn\r\nvoid SetEncounterSpawnsMax(int nNewValue, object oEncounter = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetEncounterSpawnsCurrent',
        [ScriptParam(DataType.OBJECT, 'oEncounter', 0), ],
        '// 280: Get the number of times that oEncounter has spawned so far\r\nint  GetEncounterSpawnsCurrent(object oEncounter = OBJECT_SELF);',
        '// 280: Get the number of times that oEncounter has spawned so far\r\nint  GetEncounterSpawnsCurrent(object oEncounter = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetEncounterSpawnsCurrent',
        [ScriptParam(DataType.INT, 'nNewValue', None), ScriptParam(DataType.OBJECT, 'oEncounter', 0), ],
        '// 281: Set the number of times that oEncounter has spawned so far\r\nvoid SetEncounterSpawnsCurrent(int nNewValue, object oEncounter = OBJECT_SELF);',
        '// 281: Set the number of times that oEncounter has spawned so far\r\nvoid SetEncounterSpawnsCurrent(int nNewValue, object oEncounter = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetModuleItemAcquired',
        [],
        '// 282: Use this in an OnItemAcquired script to get the item that was acquired.\r\n// * Returns OBJECT_INVALID if the module is not valid.\r\nobject GetModuleItemAcquired();',
        '// 282: Use this in an OnItemAcquired script to get the item that was acquired.\r\n// * Returns OBJECT_INVALID if the module is not valid.\r\nobject GetModuleItemAcquired();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetModuleItemAcquiredFrom',
        [],
        '// 283: Use this in an OnItemAcquired script to get the creatre that previously\r\n// possessed the item.\r\n// * Returns OBJECT_INVALID if the item was picked up from the ground.\r\nobject GetModuleItemAcquiredFrom();',
        '// 283: Use this in an OnItemAcquired script to get the creatre that previously\r\n// possessed the item.\r\n// * Returns OBJECT_INVALID if the item was picked up from the ground.\r\nobject GetModuleItemAcquiredFrom();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetCustomToken',
        [ScriptParam(DataType.INT, 'nCustomTokenNumber', None), ScriptParam(DataType.STRING, 'sTokenValue', None), ],
        '// 284: Set the value for a custom token.\r\nvoid SetCustomToken(int nCustomTokenNumber, string sTokenValue);',
        '// 284: Set the value for a custom token.\r\nvoid SetCustomToken(int nCustomTokenNumber, string sTokenValue);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetHasFeat',
        [ScriptParam(DataType.INT, 'nFeat', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        '// 285: Determine whether oCreature has nFeat, and nFeat is useable.\r\n// - nFeat: FEAT_*\r\n// - oCreature\r\nint GetHasFeat(int nFeat, object oCreature = OBJECT_SELF);',
        '// 285: Determine whether oCreature has nFeat, and nFeat is useable.\r\n// - nFeat: FEAT_*\r\n// - oCreature\r\nint GetHasFeat(int nFeat, object oCreature = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetHasSkill',
        [ScriptParam(DataType.INT, 'nSkill', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        '// 286: Determine whether oCreature has nSkill, and nSkill is useable.\r\n// - nSkill: SKILL_*\r\n// - oCreature\r\nint GetHasSkill(int nSkill, object oCreature = OBJECT_SELF);',
        '// 286: Determine whether oCreature has nSkill, and nSkill is useable.\r\n// - nSkill: SKILL_*\r\n// - oCreature\r\nint GetHasSkill(int nSkill, object oCreature = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionUseFeat',
        [ScriptParam(DataType.INT, 'nFeat', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 287: Use nFeat on oTarget.\r\n// - nFeat: FEAT_*\r\n// - oTarget\r\nvoid ActionUseFeat(int nFeat, object oTarget);',
        '// 287: Use nFeat on oTarget.\r\n// - nFeat: FEAT_*\r\n// - oTarget\r\nvoid ActionUseFeat(int nFeat, object oTarget);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionUseSkill',
        [ScriptParam(DataType.INT, 'nSkill', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'nSubSkill', 0), ScriptParam(DataType.OBJECT, 'oItemUsed', 1), ],
        '// 288: Runs the action "UseSkill" on the current creature\r\n// Use nSkill on oTarget.\r\n// - nSkill: SKILL_*\r\n// - oTarget\r\n// - nSubSkill: SUBSKILL_*\r\n// - oItemUsed: Item to use in conjunction with the skill\r\nvoid ActionUseSkill(int nSkill, object oTarget, int nSubSkill = 0, object oItemUsed = OBJECT_INVALID );',
        '// 288: Runs the action "UseSkill" on the current creature\r\n// Use nSkill on oTarget.\r\n// - nSkill: SKILL_*\r\n// - oTarget\r\n// - nSubSkill: SUBSKILL_*\r\n// - oItemUsed: Item to use in conjunction with the skill\r\nvoid ActionUseSkill(int nSkill, object oTarget, int nSubSkill = 0, object oItemUsed = OBJECT_INVALID );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetObjectSeen',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.OBJECT, 'oSource', 0), ],
        '// 289: Determine whether oSource sees oTarget.\r\nint GetObjectSeen(object oTarget, object oSource = OBJECT_SELF);',
        '// 289: Determine whether oSource sees oTarget.\r\nint GetObjectSeen(object oTarget, object oSource = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetObjectHeard',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.OBJECT, 'oSource', 0), ],
        '// 290: Determine whether oSource hears oTarget.\r\nint GetObjectHeard(object oTarget, object oSource = OBJECT_SELF);',
        '// 290: Determine whether oSource hears oTarget.\r\nint GetObjectHeard(object oTarget, object oSource = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastPlayerDied',
        [],
        '// 291: Use this in an OnPlayerDeath module script to get the last player that died.\r\nobject GetLastPlayerDied();',
        '// 291: Use this in an OnPlayerDeath module script to get the last player that died.\r\nobject GetLastPlayerDied();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetModuleItemLost',
        [],
        '// 292: Use this in an OnItemLost script to get the item that was lost/dropped.\r\n// * Returns OBJECT_INVALID if the module is not valid.\r\nobject GetModuleItemLost();',
        '// 292: Use this in an OnItemLost script to get the item that was lost/dropped.\r\n// * Returns OBJECT_INVALID if the module is not valid.\r\nobject GetModuleItemLost();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetModuleItemLostBy',
        [],
        '// 293: Use this in an OnItemLost script to get the creature that lost the item.\r\n// * Returns OBJECT_INVALID if the module is not valid.\r\nobject GetModuleItemLostBy();',
        '// 293: Use this in an OnItemLost script to get the creature that lost the item.\r\n// * Returns OBJECT_INVALID if the module is not valid.\r\nobject GetModuleItemLostBy();'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionDoCommand',
        [ScriptParam(DataType.ACTION, 'aActionToDo', None), ],
        '// 294: Do aActionToDo.\r\nvoid ActionDoCommand(action aActionToDo);',
        '// 294: Do aActionToDo.\r\nvoid ActionDoCommand(action aActionToDo);'
    ),
    ScriptFunction(
        DataType.EVENT,
        'EventConversation',
        [],
        '// 295: Conversation event.\r\nevent EventConversation();',
        '// 295: Conversation event.\r\nevent EventConversation();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetEncounterDifficulty',
        [ScriptParam(DataType.INT, 'nEncounterDifficulty', None), ScriptParam(DataType.OBJECT, 'oEncounter', 0), ],
        '// 296: Set the difficulty level of oEncounter.\r\n// - nEncounterDifficulty: ENCOUNTER_DIFFICULTY_*\r\n// - oEncounter\r\nvoid SetEncounterDifficulty(int nEncounterDifficulty, object oEncounter = OBJECT_SELF);',
        '// 296: Set the difficulty level of oEncounter.\r\n// - nEncounterDifficulty: ENCOUNTER_DIFFICULTY_*\r\n// - oEncounter\r\nvoid SetEncounterDifficulty(int nEncounterDifficulty, object oEncounter = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetEncounterDifficulty',
        [ScriptParam(DataType.OBJECT, 'oEncounter', 0), ],
        '// 297: Get the difficulty level of oEncounter.\r\nint GetEncounterDifficulty(object oEncounter = OBJECT_SELF);',
        '// 297: Get the difficulty level of oEncounter.\r\nint GetEncounterDifficulty(object oEncounter = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetDistanceBetweenLocations',
        [ScriptParam(DataType.LOCATION, 'lLocationA', None), ScriptParam(DataType.LOCATION, 'lLocationB', None), ],
        '// 298: Get the distance between lLocationA and lLocationB.\r\nfloat GetDistanceBetweenLocations(location lLocationA, location lLocationB);',
        '// 298: Get the distance between lLocationA and lLocationB.\r\nfloat GetDistanceBetweenLocations(location lLocationA, location lLocationB);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetReflexAdjustedDamage',
        [ScriptParam(DataType.INT, 'nDamage', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'nDC', None), ScriptParam(DataType.INT, 'nSaveType', 0), ScriptParam(DataType.OBJECT, 'oSaveVersus', 0), ],
        "// 299: Use this in spell scripts to get nDamage adjusted by oTarget's reflex and\r\n// evasion saves.\r\n// - nDamage\r\n// - oTarget\r\n// - nDC: Difficulty check\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\n// - oSaveVersus\r\nint GetReflexAdjustedDamage(int nDamage, object oTarget, int nDC, int nSaveType = SAVING_THROW_TYPE_NONE, object oSaveVersus = OBJECT_SELF);",
        "// 299: Use this in spell scripts to get nDamage adjusted by oTarget's reflex and\r\n// evasion saves.\r\n// - nDamage\r\n// - oTarget\r\n// - nDC: Difficulty check\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\n// - oSaveVersus\r\nint GetReflexAdjustedDamage(int nDamage, object oTarget, int nDC, int nSaveType = SAVING_THROW_TYPE_NONE, object oSaveVersus = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.VOID,
        'PlayAnimation',
        [ScriptParam(DataType.INT, 'nAnimation', None), ScriptParam(DataType.FLOAT, 'fSpeed', 1.0), ScriptParam(DataType.FLOAT, 'fSeconds', 0.0), ],
        '// 300: Play nAnimation immediately.\r\n// - nAnimation: ANIMATION_*\r\n// - fSpeed\r\n// - fSeconds: Duration of the animation (this is not used for Fire and\r\n//   Forget animations) If a time of -1.0f is specified for a looping animation\r\n//   it will loop until the next animation is applied.\r\nvoid PlayAnimation(int nAnimation, float fSpeed = 1.0, float fSeconds = 0.0);',
        '// 300: Play nAnimation immediately.\r\n// - nAnimation: ANIMATION_*\r\n// - fSpeed\r\n// - fSeconds: Duration of the animation (this is not used for Fire and\r\n//   Forget animations) If a time of -1.0f is specified for a looping animation\r\n//   it will loop until the next animation is applied.\r\nvoid PlayAnimation(int nAnimation, float fSpeed = 1.0, float fSeconds = 0.0);'
    ),
    ScriptFunction(
        DataType.TALENT,
        'TalentSpell',
        [ScriptParam(DataType.INT, 'nSpell', None), ],
        '// 301: Create a Spell Talent.\r\n// - nSpell: SPELL_*\r\ntalent TalentSpell(int nSpell);',
        '// 301: Create a Spell Talent.\r\n// - nSpell: SPELL_*\r\ntalent TalentSpell(int nSpell);'
    ),
    ScriptFunction(
        DataType.TALENT,
        'TalentFeat',
        [ScriptParam(DataType.INT, 'nFeat', None), ],
        '// 302: Create a Feat Talent.\r\n// - nFeat: FEAT_*\r\ntalent TalentFeat(int nFeat);',
        '// 302: Create a Feat Talent.\r\n// - nFeat: FEAT_*\r\ntalent TalentFeat(int nFeat);'
    ),
    ScriptFunction(
        DataType.TALENT,
        'TalentSkill',
        [ScriptParam(DataType.INT, 'nSkill', None), ],
        '// 303: Create a Skill Talent.\r\n// - nSkill: SKILL_*\r\ntalent TalentSkill(int nSkill);',
        '// 303: Create a Skill Talent.\r\n// - nSkill: SKILL_*\r\ntalent TalentSkill(int nSkill);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetHasSpellEffect',
        [ScriptParam(DataType.INT, 'nSpell', None), ScriptParam(DataType.OBJECT, 'oObject', 0), ],
        '// 304: Determine if oObject has effects originating from nSpell.\r\n// - nSpell: SPELL_*\r\n// - oObject\r\nint GetHasSpellEffect(int nSpell, object oObject = OBJECT_SELF);',
        '// 304: Determine if oObject has effects originating from nSpell.\r\n// - nSpell: SPELL_*\r\n// - oObject\r\nint GetHasSpellEffect(int nSpell, object oObject = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetEffectSpellId',
        [ScriptParam(DataType.EFFECT, 'eSpellEffect', None), ],
        '// 305: Get the spell (SPELL_*) that applied eSpellEffect.\r\n// * Returns -1 if eSpellEffect was applied outside a spell script.\r\nint GetEffectSpellId(effect eSpellEffect);',
        '// 305: Get the spell (SPELL_*) that applied eSpellEffect.\r\n// * Returns -1 if eSpellEffect was applied outside a spell script.\r\nint GetEffectSpellId(effect eSpellEffect);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetCreatureHasTalent',
        [ScriptParam(DataType.TALENT, 'tTalent', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        '// 306: Determine whether oCreature has tTalent.\r\nint GetCreatureHasTalent(talent tTalent, object oCreature = OBJECT_SELF);',
        '// 306: Determine whether oCreature has tTalent.\r\nint GetCreatureHasTalent(talent tTalent, object oCreature = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.TALENT,
        'GetCreatureTalentRandom',
        [ScriptParam(DataType.INT, 'nCategory', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ScriptParam(DataType.INT, 'nInclusion', 0), ],
        '// 307: Get a random talent of oCreature, within nCategory.\r\n// - nCategory: TALENT_CATEGORY_*\r\n// - oCreature\r\n// - nInclusion: types of talent to include\r\ntalent GetCreatureTalentRandom(int nCategory, object oCreature = OBJECT_SELF, int nInclusion = 0);',
        '// 307: Get a random talent of oCreature, within nCategory.\r\n// - nCategory: TALENT_CATEGORY_*\r\n// - oCreature\r\n// - nInclusion: types of talent to include\r\ntalent GetCreatureTalentRandom(int nCategory, object oCreature = OBJECT_SELF, int nInclusion = 0);'
    ),
    ScriptFunction(
        DataType.TALENT,
        'GetCreatureTalentBest',
        [ScriptParam(DataType.INT, 'nCategory', None), ScriptParam(DataType.INT, 'nCRMax', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ScriptParam(DataType.INT, 'nInclusion', 0), ScriptParam(DataType.INT, 'nExcludeType', -1), ScriptParam(DataType.INT, 'nExcludeId', -1), ],
        '// 308: Get the best talent (i.e. closest to nCRMax without going over) of oCreature,\r\n// within nCategory.\r\n// - nCategory: TALENT_CATEGORY_*\r\n// - nCRMax: Challenge Rating of the talent\r\n// - oCreature\r\n// - nInclusion: types of talent to include\r\n// - nExcludeType: TALENT_TYPE_FEAT or TALENT_TYPE_FORCE, type of talent that we wish to ignore\r\n// - nExcludeId: Talent ID of the talent we wish to ignore.\r\n//   A value of TALENT_EXCLUDE_ALL_OF_TYPE for this parameter will mean that all talents of\r\n//   type nExcludeType are ignored.\r\ntalent GetCreatureTalentBest(int nCategory, int nCRMax, object oCreature = OBJECT_SELF, int nInclusion = 0, int nExcludeType  =  -1, int nExcludeId  =  -1);',
        '// 308: Get the best talent (i.e. closest to nCRMax without going over) of oCreature,\r\n// within nCategory.\r\n// - nCategory: TALENT_CATEGORY_*\r\n// - nCRMax: Challenge Rating of the talent\r\n// - oCreature\r\n// - nInclusion: types of talent to include\r\n// - nExcludeType: TALENT_TYPE_FEAT or TALENT_TYPE_FORCE, type of talent that we wish to ignore\r\n// - nExcludeId: Talent ID of the talent we wish to ignore.\r\n//   A value of TALENT_EXCLUDE_ALL_OF_TYPE for this parameter will mean that all talents of\r\n//   type nExcludeType are ignored.\r\ntalent GetCreatureTalentBest(int nCategory, int nCRMax, object oCreature = OBJECT_SELF, int nInclusion = 0, int nExcludeType  =  -1, int nExcludeId  =  -1);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionUseTalentOnObject',
        [ScriptParam(DataType.TALENT, 'tChosenTalent', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 309: Use tChosenTalent on oTarget.\r\nvoid ActionUseTalentOnObject(talent tChosenTalent, object oTarget);',
        '// 309: Use tChosenTalent on oTarget.\r\nvoid ActionUseTalentOnObject(talent tChosenTalent, object oTarget);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionUseTalentAtLocation',
        [ScriptParam(DataType.TALENT, 'tChosenTalent', None), ScriptParam(DataType.LOCATION, 'lTargetLocation', None), ],
        '// 310: Use tChosenTalent at lTargetLocation.\r\nvoid ActionUseTalentAtLocation(talent tChosenTalent, location lTargetLocation);',
        '// 310: Use tChosenTalent at lTargetLocation.\r\nvoid ActionUseTalentAtLocation(talent tChosenTalent, location lTargetLocation);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetGoldPieceValue',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 311: Get the gold piece value of oItem.\r\n// * Returns 0 if oItem is not a valid item.\r\nint GetGoldPieceValue(object oItem);',
        '// 311: Get the gold piece value of oItem.\r\n// * Returns 0 if oItem is not a valid item.\r\nint GetGoldPieceValue(object oItem);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsPlayableRacialType',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 312: * Returns TRUE if oCreature is of a playable racial type.\r\nint GetIsPlayableRacialType(object oCreature);',
        '// 312: * Returns TRUE if oCreature is of a playable racial type.\r\nint GetIsPlayableRacialType(object oCreature);'
    ),
    ScriptFunction(
        DataType.VOID,
        'JumpToLocation',
        [ScriptParam(DataType.LOCATION, 'lDestination', None), ],
        '// 313: Jump to lDestination.  The action is added to the TOP of the action queue.\r\nvoid JumpToLocation(location lDestination);',
        '// 313: Jump to lDestination.  The action is added to the TOP of the action queue.\r\nvoid JumpToLocation(location lDestination);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectTemporaryHitpoints',
        [ScriptParam(DataType.INT, 'nHitPoints', None), ],
        '// 314: Create a Temporary Hitpoints effect.\r\n// - nHitPoints: a positive integer\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nHitPoints < 0.\r\neffect EffectTemporaryHitpoints(int nHitPoints);',
        '// 314: Create a Temporary Hitpoints effect.\r\n// - nHitPoints: a positive integer\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nHitPoints < 0.\r\neffect EffectTemporaryHitpoints(int nHitPoints);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetSkillRank',
        [ScriptParam(DataType.INT, 'nSkill', None), ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        "// 315: Get the number of ranks that oTarget has in nSkill.\r\n// - nSkill: SKILL_*\r\n// - oTarget\r\n// * Returns -1 if oTarget doesn't have nSkill.\r\n// * Returns 0 if nSkill is untrained.\r\nint GetSkillRank(int nSkill, object oTarget = OBJECT_SELF);",
        "// 315: Get the number of ranks that oTarget has in nSkill.\r\n// - nSkill: SKILL_*\r\n// - oTarget\r\n// * Returns -1 if oTarget doesn't have nSkill.\r\n// * Returns 0 if nSkill is untrained.\r\nint GetSkillRank(int nSkill, object oTarget = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetAttackTarget',
        [ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        '// 316: Get the attack target of oCreature.\r\n// This only works when oCreature is in combat.\r\nobject GetAttackTarget(object oCreature = OBJECT_SELF);',
        '// 316: Get the attack target of oCreature.\r\n// This only works when oCreature is in combat.\r\nobject GetAttackTarget(object oCreature = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastAttackType',
        [ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        "// 317: Get the attack type (SPECIAL_ATTACK_*) of oCreature's last attack.\r\n// This only works when oCreature is in combat.\r\nint GetLastAttackType(object oCreature = OBJECT_SELF);",
        "// 317: Get the attack type (SPECIAL_ATTACK_*) of oCreature's last attack.\r\n// This only works when oCreature is in combat.\r\nint GetLastAttackType(object oCreature = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastAttackMode',
        [ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        "// 318: Get the attack mode (COMBAT_MODE_*) of oCreature's last attack.\r\n// This only works when oCreature is in combat.\r\nint GetLastAttackMode(object oCreature = OBJECT_SELF);",
        "// 318: Get the attack mode (COMBAT_MODE_*) of oCreature's last attack.\r\n// This only works when oCreature is in combat.\r\nint GetLastAttackMode(object oCreature = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetDistanceBetween2D',
        [ScriptParam(DataType.OBJECT, 'oObjectA', None), ScriptParam(DataType.OBJECT, 'oObjectB', None), ],
        '// 319: Get the distance in metres between oObjectA and oObjectB in 2D.\r\n// * Return value if either object is invalid: 0.0f\r\nfloat GetDistanceBetween2D(object oObjectA, object oObjectB);',
        '// 319: Get the distance in metres between oObjectA and oObjectB in 2D.\r\n// * Return value if either object is invalid: 0.0f\r\nfloat GetDistanceBetween2D(object oObjectA, object oObjectB);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsInCombat',
        [ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        '// 320: * Returns TRUE if oCreature is in combat.\r\nint GetIsInCombat(object oCreature = OBJECT_SELF);',
        '// 320: * Returns TRUE if oCreature is in combat.\r\nint GetIsInCombat(object oCreature = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastAssociateCommand',
        [ScriptParam(DataType.OBJECT, 'oAssociate', 0), ],
        '// 321: Get the last command (ASSOCIATE_COMMAND_*) issued to oAssociate.\r\nint GetLastAssociateCommand(object oAssociate = OBJECT_SELF);',
        '// 321: Get the last command (ASSOCIATE_COMMAND_*) issued to oAssociate.\r\nint GetLastAssociateCommand(object oAssociate = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'GiveGoldToCreature',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nGP', None), ],
        '// 322: Give nGP gold to oCreature.\r\nvoid GiveGoldToCreature(object oCreature, int nGP);',
        '// 322: Give nGP gold to oCreature.\r\nvoid GiveGoldToCreature(object oCreature, int nGP);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetIsDestroyable',
        [ScriptParam(DataType.INT, 'bDestroyable', None), ScriptParam(DataType.INT, 'bRaiseable', 1), ScriptParam(DataType.INT, 'bSelectableWhenDead', 0), ],
        '// 323: Set the destroyable status of the caller.\r\n// - bDestroyable: If this is FALSE, the caller does not fade out on death, but\r\n//   sticks around as a corpse.\r\n// - bRaiseable: If this is TRUE, the caller can be raised via resurrection.\r\n// - bSelectableWhenDead: If this is TRUE, the caller is selectable after death.\r\nvoid SetIsDestroyable(int bDestroyable, int bRaiseable = TRUE, int bSelectableWhenDead = FALSE);',
        '// 323: Set the destroyable status of the caller.\r\n// - bDestroyable: If this is FALSE, the caller does not fade out on death, but\r\n//   sticks around as a corpse.\r\n// - bRaiseable: If this is TRUE, the caller can be raised via resurrection.\r\n// - bSelectableWhenDead: If this is TRUE, the caller is selectable after death.\r\nvoid SetIsDestroyable(int bDestroyable, int bRaiseable = TRUE, int bSelectableWhenDead = FALSE);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetLocked',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'bLocked', None), ],
        '// 324: Set the locked state of oTarget, which can be a door or a placeable object.\r\nvoid SetLocked(object oTarget, int bLocked);',
        '// 324: Set the locked state of oTarget, which can be a door or a placeable object.\r\nvoid SetLocked(object oTarget, int bLocked);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLocked',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 325: Get the locked state of oTarget, which can be a door or a placeable object.\r\nint GetLocked(object oTarget);',
        '// 325: Get the locked state of oTarget, which can be a door or a placeable object.\r\nint GetLocked(object oTarget);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetClickingObject',
        [],
        "// 326: Use this in a trigger's OnClick event script to get the object that last\r\n// clicked on it.\r\n// This is identical to GetEnteringObject.\r\nobject GetClickingObject();",
        "// 326: Use this in a trigger's OnClick event script to get the object that last\r\n// clicked on it.\r\n// This is identical to GetEnteringObject.\r\nobject GetClickingObject();"
    ),
    ScriptFunction(
        DataType.VOID,
        'SetAssociateListenPatterns',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        '// 327: Initialise oTarget to listen for the standard Associates commands.\r\nvoid SetAssociateListenPatterns(object oTarget = OBJECT_SELF);',
        '// 327: Initialise oTarget to listen for the standard Associates commands.\r\nvoid SetAssociateListenPatterns(object oTarget = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastWeaponUsed',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 328: Get the last weapon that oCreature used in an attack.\r\n// * Returns OBJECT_INVALID if oCreature did not attack, or has no weapon equipped.\r\nobject GetLastWeaponUsed(object oCreature);',
        '// 328: Get the last weapon that oCreature used in an attack.\r\n// * Returns OBJECT_INVALID if oCreature did not attack, or has no weapon equipped.\r\nobject GetLastWeaponUsed(object oCreature);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionInteractObject',
        [ScriptParam(DataType.OBJECT, 'oPlaceable', None), ],
        '// 329: Use oPlaceable.\r\nvoid ActionInteractObject(object oPlaceable);',
        '// 329: Use oPlaceable.\r\nvoid ActionInteractObject(object oPlaceable);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastUsedBy',
        [],
        '// 330: Get the last object that used the placeable object that is calling this function.\r\n// * Returns OBJECT_INVALID if it is called by something other than a placeable or\r\n//   a door.\r\nobject GetLastUsedBy();',
        '// 330: Get the last object that used the placeable object that is calling this function.\r\n// * Returns OBJECT_INVALID if it is called by something other than a placeable or\r\n//   a door.\r\nobject GetLastUsedBy();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetAbilityModifier',
        [ScriptParam(DataType.INT, 'nAbility', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        "// 331: Returns the ability modifier for the specified ability\r\n// Get oCreature's ability modifier for nAbility.\r\n// - nAbility: ABILITY_*\r\n// - oCreature\r\nint GetAbilityModifier(int nAbility, object oCreature = OBJECT_SELF);",
        "// 331: Returns the ability modifier for the specified ability\r\n// Get oCreature's ability modifier for nAbility.\r\n// - nAbility: ABILITY_*\r\n// - oCreature\r\nint GetAbilityModifier(int nAbility, object oCreature = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetIdentified',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 332: Determined whether oItem has been identified.\r\nint GetIdentified(object oItem);',
        '// 332: Determined whether oItem has been identified.\r\nint GetIdentified(object oItem);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetIdentified',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.INT, 'bIdentified', None), ],
        '// 333: Set whether oItem has been identified.\r\nvoid SetIdentified(object oItem, int bIdentified);',
        '// 333: Set whether oItem has been identified.\r\nvoid SetIdentified(object oItem, int bIdentified);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetDistanceBetweenLocations2D',
        [ScriptParam(DataType.LOCATION, 'lLocationA', None), ScriptParam(DataType.LOCATION, 'lLocationB', None), ],
        '// 334: Get the distance between lLocationA and lLocationB. in 2D\r\nfloat GetDistanceBetweenLocations2D(location lLocationA, location lLocationB);',
        '// 334: Get the distance between lLocationA and lLocationB. in 2D\r\nfloat GetDistanceBetweenLocations2D(location lLocationA, location lLocationB);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetDistanceToObject2D',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 335: Get the distance from the caller to oObject in metres.\r\n// * Return value on error: -1.0f\r\nfloat GetDistanceToObject2D(object oObject);',
        '// 335: Get the distance from the caller to oObject in metres.\r\n// * Return value on error: -1.0f\r\nfloat GetDistanceToObject2D(object oObject);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetBlockingDoor',
        [],
        '// 336: Get the last blocking door encountered by the caller of this function.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetBlockingDoor();',
        '// 336: Get the last blocking door encountered by the caller of this function.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetBlockingDoor();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsDoorActionPossible',
        [ScriptParam(DataType.OBJECT, 'oTargetDoor', None), ScriptParam(DataType.INT, 'nDoorAction', None), ],
        '// 337: - oTargetDoor\r\n// - nDoorAction: DOOR_ACTION_*\r\n// * Returns TRUE if nDoorAction can be performed on oTargetDoor.\r\nint GetIsDoorActionPossible(object oTargetDoor, int nDoorAction);',
        '// 337: - oTargetDoor\r\n// - nDoorAction: DOOR_ACTION_*\r\n// * Returns TRUE if nDoorAction can be performed on oTargetDoor.\r\nint GetIsDoorActionPossible(object oTargetDoor, int nDoorAction);'
    ),
    ScriptFunction(
        DataType.VOID,
        'DoDoorAction',
        [ScriptParam(DataType.OBJECT, 'oTargetDoor', None), ScriptParam(DataType.INT, 'nDoorAction', None), ],
        '// 338: Perform nDoorAction on oTargetDoor.\r\nvoid DoDoorAction(object oTargetDoor, int nDoorAction);',
        '// 338: Perform nDoorAction on oTargetDoor.\r\nvoid DoDoorAction(object oTargetDoor, int nDoorAction);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFirstItemInInventory',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        "// 339: Get the first item in oTarget's inventory (start to cycle through oTarget's\r\n// inventory).\r\n// * Returns OBJECT_INVALID if the caller is not a creature, item, placeable or store,\r\n//   or if no item is found.\r\nobject GetFirstItemInInventory(object oTarget = OBJECT_SELF);",
        "// 339: Get the first item in oTarget's inventory (start to cycle through oTarget's\r\n// inventory).\r\n// * Returns OBJECT_INVALID if the caller is not a creature, item, placeable or store,\r\n//   or if no item is found.\r\nobject GetFirstItemInInventory(object oTarget = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNextItemInInventory',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        "// 340: Get the next item in oTarget's inventory (continue to cycle through oTarget's\r\n// inventory).\r\n// * Returns OBJECT_INVALID if the caller is not a creature, item, placeable or store,\r\n//   or if no item is found.\r\nobject GetNextItemInInventory(object oTarget = OBJECT_SELF);",
        "// 340: Get the next item in oTarget's inventory (continue to cycle through oTarget's\r\n// inventory).\r\n// * Returns OBJECT_INVALID if the caller is not a creature, item, placeable or store,\r\n//   or if no item is found.\r\nobject GetNextItemInInventory(object oTarget = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetClassByPosition',
        [ScriptParam(DataType.INT, 'nClassPosition', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        "// 341: A creature can have up to three classes.  This function determines the\r\n// creature's class (CLASS_TYPE_*) based on nClassPosition.\r\n// - nClassPosition: 1, 2 or 3\r\n// - oCreature\r\n// * Returns CLASS_TYPE_INVALID if the oCreature does not have a class in\r\n//   nClassPosition (i.e. a single-class creature will only have a value in\r\n//   nClassLocation = 1) or if oCreature is not a valid creature.\r\nint GetClassByPosition(int nClassPosition, object oCreature = OBJECT_SELF);",
        "// 341: A creature can have up to three classes.  This function determines the\r\n// creature's class (CLASS_TYPE_*) based on nClassPosition.\r\n// - nClassPosition: 1, 2 or 3\r\n// - oCreature\r\n// * Returns CLASS_TYPE_INVALID if the oCreature does not have a class in\r\n//   nClassPosition (i.e. a single-class creature will only have a value in\r\n//   nClassLocation = 1) or if oCreature is not a valid creature.\r\nint GetClassByPosition(int nClassPosition, object oCreature = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetLevelByPosition',
        [ScriptParam(DataType.INT, 'nClassPosition', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        "// 342: A creature can have up to three classes.  This function determines the\r\n// creature's class level based on nClass Position.\r\n// - nClassPosition: 1, 2 or 3\r\n// - oCreature\r\n// * Returns 0 if oCreature does not have a class in nClassPosition\r\n//   (i.e. a single-class creature will only have a value in nClassLocation = 1)\r\n//   or if oCreature is not a valid creature.\r\nint GetLevelByPosition(int nClassPosition, object oCreature = OBJECT_SELF);",
        "// 342: A creature can have up to three classes.  This function determines the\r\n// creature's class level based on nClass Position.\r\n// - nClassPosition: 1, 2 or 3\r\n// - oCreature\r\n// * Returns 0 if oCreature does not have a class in nClassPosition\r\n//   (i.e. a single-class creature will only have a value in nClassLocation = 1)\r\n//   or if oCreature is not a valid creature.\r\nint GetLevelByPosition(int nClassPosition, object oCreature = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetLevelByClass',
        [ScriptParam(DataType.INT, 'nClassType', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        '// 343: Determine the levels that oCreature holds in nClassType.\r\n// - nClassType: CLASS_TYPE_*\r\n// - oCreature\r\nint GetLevelByClass(int nClassType, object oCreature = OBJECT_SELF);',
        '// 343: Determine the levels that oCreature holds in nClassType.\r\n// - nClassType: CLASS_TYPE_*\r\n// - oCreature\r\nint GetLevelByClass(int nClassType, object oCreature = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetDamageDealtByType',
        [ScriptParam(DataType.INT, 'nDamageType', None), ],
        '// 344: Get the amount of damage of type nDamageType that has been dealt to the caller.\r\n// - nDamageType: DAMAGE_TYPE_*\r\nint GetDamageDealtByType(int nDamageType);',
        '// 344: Get the amount of damage of type nDamageType that has been dealt to the caller.\r\n// - nDamageType: DAMAGE_TYPE_*\r\nint GetDamageDealtByType(int nDamageType);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTotalDamageDealt',
        [],
        '// 345: Get the total amount of damage that has been dealt to the caller.\r\nint GetTotalDamageDealt();',
        '// 345: Get the total amount of damage that has been dealt to the caller.\r\nint GetTotalDamageDealt();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastDamager',
        [],
        '// 346: Get the last object that damaged the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid object.\r\nobject GetLastDamager();',
        '// 346: Get the last object that damaged the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid object.\r\nobject GetLastDamager();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastDisarmed',
        [],
        '// 347: Get the last object that disarmed the trap on the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid placeable, trigger or\r\n//   door.\r\nobject GetLastDisarmed();',
        '// 347: Get the last object that disarmed the trap on the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid placeable, trigger or\r\n//   door.\r\nobject GetLastDisarmed();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastDisturbed',
        [],
        '// 348: Get the last object that disturbed the inventory of the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature or placeable.\r\nobject GetLastDisturbed();',
        '// 348: Get the last object that disturbed the inventory of the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature or placeable.\r\nobject GetLastDisturbed();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastLocked',
        [],
        '// 349: Get the last object that locked the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid door or placeable.\r\nobject GetLastLocked();',
        '// 349: Get the last object that locked the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid door or placeable.\r\nobject GetLastLocked();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastUnlocked',
        [],
        '// 350: Get the last object that unlocked the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid door or placeable.\r\nobject GetLastUnlocked();',
        '// 350: Get the last object that unlocked the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid door or placeable.\r\nobject GetLastUnlocked();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectSkillIncrease',
        [ScriptParam(DataType.INT, 'nSkill', None), ScriptParam(DataType.INT, 'nValue', None), ],
        '// 351: Create a Skill Increase effect.\r\n// - nSkill: SKILL_*\r\n// - nValue\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nSkill is invalid.\r\neffect EffectSkillIncrease(int nSkill, int nValue);',
        '// 351: Create a Skill Increase effect.\r\n// - nSkill: SKILL_*\r\n// - nValue\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nSkill is invalid.\r\neffect EffectSkillIncrease(int nSkill, int nValue);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetInventoryDisturbType',
        [],
        "// 352: Get the type of disturbance (INVENTORY_DISTURB_*) that caused the caller's\r\n// OnInventoryDisturbed script to fire.  This will only work for creatures and\r\n// placeables.\r\nint GetInventoryDisturbType();",
        "// 352: Get the type of disturbance (INVENTORY_DISTURB_*) that caused the caller's\r\n// OnInventoryDisturbed script to fire.  This will only work for creatures and\r\n// placeables.\r\nint GetInventoryDisturbType();"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetInventoryDisturbItem',
        [],
        "// 353: get the item that caused the caller's OnInventoryDisturbed script to fire.\r\n// * Returns OBJECT_INVALID if the caller is not a valid object.\r\nobject GetInventoryDisturbItem();",
        "// 353: get the item that caused the caller's OnInventoryDisturbed script to fire.\r\n// * Returns OBJECT_INVALID if the caller is not a valid object.\r\nobject GetInventoryDisturbItem();"
    ),
    ScriptFunction(
        DataType.VOID,
        'ShowUpgradeScreen',
        [ScriptParam(DataType.OBJECT, 'oItem', 1), ],
        '// 354: Displays the upgrade screen where the player can modify weapons and armor\r\nvoid ShowUpgradeScreen(object oItem  =  OBJECT_INVALID);',
        '// 354: Displays the upgrade screen where the player can modify weapons and armor\r\nvoid ShowUpgradeScreen(object oItem  =  OBJECT_INVALID);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'VersusAlignmentEffect',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ScriptParam(DataType.INT, 'nLawChaos', 0), ScriptParam(DataType.INT, 'nGoodEvil', 0), ],
        '// 355: Set eEffect to be versus a specific alignment.\r\n// - eEffect\r\n// - nLawChaos: ALIGNMENT_LAWFUL/ALIGNMENT_CHAOTIC/ALIGNMENT_ALL\r\n// - nGoodEvil: ALIGNMENT_GOOD/ALIGNMENT_EVIL/ALIGNMENT_ALL\r\neffect VersusAlignmentEffect(effect eEffect, int nLawChaos = ALIGNMENT_ALL, int nGoodEvil = ALIGNMENT_ALL);',
        '// 355: Set eEffect to be versus a specific alignment.\r\n// - eEffect\r\n// - nLawChaos: ALIGNMENT_LAWFUL/ALIGNMENT_CHAOTIC/ALIGNMENT_ALL\r\n// - nGoodEvil: ALIGNMENT_GOOD/ALIGNMENT_EVIL/ALIGNMENT_ALL\r\neffect VersusAlignmentEffect(effect eEffect, int nLawChaos = ALIGNMENT_ALL, int nGoodEvil = ALIGNMENT_ALL);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'VersusRacialTypeEffect',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ScriptParam(DataType.INT, 'nRacialType', None), ],
        '// 356: Set eEffect to be versus nRacialType.\r\n// - eEffect\r\n// - nRacialType: RACIAL_TYPE_*\r\neffect VersusRacialTypeEffect(effect eEffect, int nRacialType);',
        '// 356: Set eEffect to be versus nRacialType.\r\n// - eEffect\r\n// - nRacialType: RACIAL_TYPE_*\r\neffect VersusRacialTypeEffect(effect eEffect, int nRacialType);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'VersusTrapEffect',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 357: Set eEffect to be versus traps.\r\neffect VersusTrapEffect(effect eEffect);',
        '// 357: Set eEffect to be versus traps.\r\neffect VersusTrapEffect(effect eEffect);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetGender',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 358: Get the gender of oCreature.\r\nint GetGender(object oCreature);',
        '// 358: Get the gender of oCreature.\r\nint GetGender(object oCreature);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsTalentValid',
        [ScriptParam(DataType.TALENT, 'tTalent', None), ],
        '// 359: * Returns TRUE if tTalent is valid.\r\nint GetIsTalentValid(talent tTalent);',
        '// 359: * Returns TRUE if tTalent is valid.\r\nint GetIsTalentValid(talent tTalent);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionMoveAwayFromLocation',
        [ScriptParam(DataType.LOCATION, 'lMoveAwayFrom', None), ScriptParam(DataType.INT, 'bRun', 0), ScriptParam(DataType.FLOAT, 'fMoveAwayRange', 40.0), ],
        '// 360: Causes the action subject to move away from lMoveAwayFrom.\r\nvoid ActionMoveAwayFromLocation(location lMoveAwayFrom, int bRun = FALSE, float fMoveAwayRange = 40.0f);',
        '// 360: Causes the action subject to move away from lMoveAwayFrom.\r\nvoid ActionMoveAwayFromLocation(location lMoveAwayFrom, int bRun = FALSE, float fMoveAwayRange = 40.0f);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetAttemptedAttackTarget',
        [],
        '// 361: Get the target that the caller attempted to attack - this should be used in\r\n// conjunction with GetAttackTarget(). This value is set every time an attack is\r\n// made, and is reset at the end of combat.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetAttemptedAttackTarget();',
        '// 361: Get the target that the caller attempted to attack - this should be used in\r\n// conjunction with GetAttackTarget(). This value is set every time an attack is\r\n// made, and is reset at the end of combat.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetAttemptedAttackTarget();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTypeFromTalent',
        [ScriptParam(DataType.TALENT, 'tTalent', None), ],
        '// 362: Get the type (TALENT_TYPE_*) of tTalent.\r\nint GetTypeFromTalent(talent tTalent);',
        '// 362: Get the type (TALENT_TYPE_*) of tTalent.\r\nint GetTypeFromTalent(talent tTalent);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIdFromTalent',
        [ScriptParam(DataType.TALENT, 'tTalent', None), ],
        '// 363: Get the ID of tTalent.  This could be a SPELL_*, FEAT_* or SKILL_*.\r\nint GetIdFromTalent(talent tTalent);',
        '// 363: Get the ID of tTalent.  This could be a SPELL_*, FEAT_* or SKILL_*.\r\nint GetIdFromTalent(talent tTalent);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PlayPazaak',
        [ScriptParam(DataType.INT, 'nOpponentPazaakDeck', None), ScriptParam(DataType.STRING, 'sEndScript', None), ScriptParam(DataType.INT, 'nMaxWager', None), ScriptParam(DataType.INT, 'bShowTutorial', 0), ScriptParam(DataType.OBJECT, 'oOpponent', 1), ],
        "// 364: Starts a game of pazaak.\r\n// - nOpponentPazaakDeck: Index into PazaakDecks.2da; specifies which deck the opponent will use.\r\n// - sEndScript: Script to be run when game finishes.\r\n// - nMaxWager: Max player wager.  If < =  0, the player's credits won't be modified by the result of the game and the wager screen will not show up.\r\n// - bShowTutorial: Plays in tutorial mode (nMaxWager should be 0).\r\nvoid PlayPazaak(int nOpponentPazaakDeck, string sEndScript, int nMaxWager, int bShowTutorial = FALSE, object oOpponent = OBJECT_INVALID);",
        "// 364: Starts a game of pazaak.\r\n// - nOpponentPazaakDeck: Index into PazaakDecks.2da; specifies which deck the opponent will use.\r\n// - sEndScript: Script to be run when game finishes.\r\n// - nMaxWager: Max player wager.  If < =  0, the player's credits won't be modified by the result of the game and the wager screen will not show up.\r\n// - bShowTutorial: Plays in tutorial mode (nMaxWager should be 0).\r\nvoid PlayPazaak(int nOpponentPazaakDeck, string sEndScript, int nMaxWager, int bShowTutorial = FALSE, object oOpponent = OBJECT_INVALID);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastPazaakResult',
        [],
        '// 365: Returns result of last Pazaak game.  Should be used only in an EndScript sent to PlayPazaak.\r\n// * Returns 0 if player loses, 1 if player wins.\r\nint GetLastPazaakResult();',
        '// 365: Returns result of last Pazaak game.  Should be used only in an EndScript sent to PlayPazaak.\r\n// * Returns 0 if player loses, 1 if player wins.\r\nint GetLastPazaakResult();'
    ),
    ScriptFunction(
        DataType.VOID,
        'DisplayFeedBackText',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nTextConstant', None), ],
        '// 366:  displays a feed back string for the object spicified and the constant\r\n// repersents the string to be displayed see:FeedBackText.2da\r\nvoid DisplayFeedBackText(object oCreature, int nTextConstant);',
        '// 366:  displays a feed back string for the object spicified and the constant\r\n// repersents the string to be displayed see:FeedBackText.2da\r\nvoid DisplayFeedBackText(object oCreature, int nTextConstant);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AddJournalQuestEntry',
        [ScriptParam(DataType.STRING, 'szPlotID', None), ScriptParam(DataType.INT, 'nState', None), ScriptParam(DataType.INT, 'bAllowOverrideHigher', 0), ],
        "// 367: Add a journal quest entry to the player.\r\n// - szPlotID: the plot identifier used in the toolset's Journal Editor\r\n// - nState: the state of the plot as seen in the toolset's Journal Editor\r\n// - bAllowOverrideHigher: If this is TRUE, you can set the state to a lower\r\n//   number than the one it is currently on\r\nvoid AddJournalQuestEntry(string szPlotID, int nState, int bAllowOverrideHigher = FALSE);",
        "// 367: Add a journal quest entry to the player.\r\n// - szPlotID: the plot identifier used in the toolset's Journal Editor\r\n// - nState: the state of the plot as seen in the toolset's Journal Editor\r\n// - bAllowOverrideHigher: If this is TRUE, you can set the state to a lower\r\n//   number than the one it is currently on\r\nvoid AddJournalQuestEntry(string szPlotID, int nState, int bAllowOverrideHigher = FALSE);"
    ),
    ScriptFunction(
        DataType.VOID,
        'RemoveJournalQuestEntry',
        [ScriptParam(DataType.STRING, 'szPlotID', None), ],
        "// 368: Remove a journal quest entry from the player.\r\n// - szPlotID: the plot identifier used in the toolset's Journal Editor\r\nvoid RemoveJournalQuestEntry(string szPlotID);",
        "// 368: Remove a journal quest entry from the player.\r\n// - szPlotID: the plot identifier used in the toolset's Journal Editor\r\nvoid RemoveJournalQuestEntry(string szPlotID);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetJournalEntry',
        [ScriptParam(DataType.STRING, 'szPlotID', None), ],
        "// 369: Gets the State value of a journal quest.  Returns 0 if no quest entry has been added for this szPlotID.\r\n// - szPlotID: the plot identifier used in the toolset's Journal Editor\r\nint GetJournalEntry(string szPlotID);",
        "// 369: Gets the State value of a journal quest.  Returns 0 if no quest entry has been added for this szPlotID.\r\n// - szPlotID: the plot identifier used in the toolset's Journal Editor\r\nint GetJournalEntry(string szPlotID);"
    ),
    ScriptFunction(
        DataType.INT,
        'PlayRumblePattern',
        [ScriptParam(DataType.INT, 'nPattern', None), ],
        '// 370: PlayRumblePattern\r\n// Starts a defined rumble pattern playing\r\nint PlayRumblePattern(int nPattern);',
        '// 370: PlayRumblePattern\r\n// Starts a defined rumble pattern playing\r\nint PlayRumblePattern(int nPattern);'
    ),
    ScriptFunction(
        DataType.INT,
        'StopRumblePattern',
        [ScriptParam(DataType.INT, 'nPattern', None), ],
        '// 371: StopRumblePattern\r\n// Stops a defined rumble pattern\r\nint StopRumblePattern(int nPattern);',
        '// 371: StopRumblePattern\r\n// Stops a defined rumble pattern\r\nint StopRumblePattern(int nPattern);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDamageForcePoints',
        [ScriptParam(DataType.INT, 'nDamage', None), ],
        '// 372: Damages the creatures force points\r\neffect EffectDamageForcePoints(int nDamage);',
        '// 372: Damages the creatures force points\r\neffect EffectDamageForcePoints(int nDamage);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectHealForcePoints',
        [ScriptParam(DataType.INT, 'nHeal', None), ],
        '// 373: Heals the creatures force points\r\neffect EffectHealForcePoints(int nHeal);',
        '// 373: Heals the creatures force points\r\neffect EffectHealForcePoints(int nHeal);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SendMessageToPC',
        [ScriptParam(DataType.OBJECT, 'oPlayer', None), ScriptParam(DataType.STRING, 'szMessage', None), ],
        '// 374: Send a server message (szMessage) to the oPlayer.\r\nvoid SendMessageToPC(object oPlayer, string szMessage);',
        '// 374: Send a server message (szMessage) to the oPlayer.\r\nvoid SendMessageToPC(object oPlayer, string szMessage);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetAttemptedSpellTarget',
        [],
        '// 375: Get the target at which the caller attempted to cast a spell.\r\n// This value is set every time a spell is cast and is reset at the end of\r\n// combat.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetAttemptedSpellTarget();',
        '// 375: Get the target at which the caller attempted to cast a spell.\r\n// This value is set every time a spell is cast and is reset at the end of\r\n// combat.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetAttemptedSpellTarget();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastOpenedBy',
        [],
        '// 376: Get the last creature that opened the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid door or placeable.\r\nobject GetLastOpenedBy();',
        '// 376: Get the last creature that opened the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid door or placeable.\r\nobject GetLastOpenedBy();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetHasSpell',
        [ScriptParam(DataType.INT, 'nSpell', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        '// 377: Determine whether oCreature has nSpell memorised.\r\n// - nSpell: SPELL_*\r\n// - oCreature\r\nint GetHasSpell(int nSpell, object oCreature = OBJECT_SELF);',
        '// 377: Determine whether oCreature has nSpell memorised.\r\n// - nSpell: SPELL_*\r\n// - oCreature\r\nint GetHasSpell(int nSpell, object oCreature = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'OpenStore',
        [ScriptParam(DataType.OBJECT, 'oStore', None), ScriptParam(DataType.OBJECT, 'oPC', None), ScriptParam(DataType.INT, 'nBonusMarkUp', 0), ScriptParam(DataType.INT, 'nBonusMarkDown', 0), ],
        '// 378: Open oStore for oPC.\r\nvoid OpenStore(object oStore, object oPC, int nBonusMarkUp = 0, int nBonusMarkDown = 0);',
        '// 378: Open oStore for oPC.\r\nvoid OpenStore(object oStore, object oPC, int nBonusMarkUp = 0, int nBonusMarkDown = 0);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionSurrenderToEnemies',
        [],
        '// 379:\r\nvoid ActionSurrenderToEnemies();',
        '// 379:\r\nvoid ActionSurrenderToEnemies();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFirstFactionMember',
        [ScriptParam(DataType.OBJECT, 'oMemberOfFaction', None), ScriptParam(DataType.INT, 'bPCOnly', 1), ],
        "// 380: Get the first member of oMemberOfFaction's faction (start to cycle through\r\n// oMemberOfFaction's faction).\r\n// * Returns OBJECT_INVALID if oMemberOfFaction's faction is invalid.\r\nobject GetFirstFactionMember(object oMemberOfFaction, int bPCOnly = TRUE);",
        "// 380: Get the first member of oMemberOfFaction's faction (start to cycle through\r\n// oMemberOfFaction's faction).\r\n// * Returns OBJECT_INVALID if oMemberOfFaction's faction is invalid.\r\nobject GetFirstFactionMember(object oMemberOfFaction, int bPCOnly = TRUE);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNextFactionMember',
        [ScriptParam(DataType.OBJECT, 'oMemberOfFaction', None), ScriptParam(DataType.INT, 'bPCOnly', 1), ],
        "// 381: Get the next member of oMemberOfFaction's faction (continue to cycle through\r\n// oMemberOfFaction's faction).\r\n// * Returns OBJECT_INVALID if oMemberOfFaction's faction is invalid.\r\nobject GetNextFactionMember(object oMemberOfFaction, int bPCOnly = TRUE);",
        "// 381: Get the next member of oMemberOfFaction's faction (continue to cycle through\r\n// oMemberOfFaction's faction).\r\n// * Returns OBJECT_INVALID if oMemberOfFaction's faction is invalid.\r\nobject GetNextFactionMember(object oMemberOfFaction, int bPCOnly = TRUE);"
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionForceMoveToLocation',
        [ScriptParam(DataType.LOCATION, 'lDestination', None), ScriptParam(DataType.INT, 'bRun', 0), ScriptParam(DataType.FLOAT, 'fTimeout', 30.0), ],
        '// 382: Force the action subject to move to lDestination.\r\nvoid ActionForceMoveToLocation(location lDestination, int bRun = FALSE, float fTimeout = 30.0f);',
        '// 382: Force the action subject to move to lDestination.\r\nvoid ActionForceMoveToLocation(location lDestination, int bRun = FALSE, float fTimeout = 30.0f);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionForceMoveToObject',
        [ScriptParam(DataType.OBJECT, 'oMoveTo', None), ScriptParam(DataType.INT, 'bRun', 0), ScriptParam(DataType.FLOAT, 'fRange', 1.0), ScriptParam(DataType.FLOAT, 'fTimeout', 30.0), ],
        '// 383: Force the action subject to move to oMoveTo.\r\nvoid ActionForceMoveToObject(object oMoveTo, int bRun = FALSE, float fRange = 1.0f, float fTimeout = 30.0f);',
        '// 383: Force the action subject to move to oMoveTo.\r\nvoid ActionForceMoveToObject(object oMoveTo, int bRun = FALSE, float fRange = 1.0f, float fTimeout = 30.0f);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetJournalQuestExperience',
        [ScriptParam(DataType.STRING, 'szPlotID', None), ],
        '// 384: Get the experience assigned in the journal editor for szPlotID.\r\nint GetJournalQuestExperience(string szPlotID);',
        '// 384: Get the experience assigned in the journal editor for szPlotID.\r\nint GetJournalQuestExperience(string szPlotID);'
    ),
    ScriptFunction(
        DataType.VOID,
        'JumpToObject',
        [ScriptParam(DataType.OBJECT, 'oToJumpTo', None), ScriptParam(DataType.INT, 'nWalkStraightLineToPoint', 1), ],
        '// 385: Jump to oToJumpTo (the action is added to the top of the action queue).\r\nvoid JumpToObject(object oToJumpTo, int nWalkStraightLineToPoint = 1);',
        '// 385: Jump to oToJumpTo (the action is added to the top of the action queue).\r\nvoid JumpToObject(object oToJumpTo, int nWalkStraightLineToPoint = 1);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetMapPinEnabled',
        [ScriptParam(DataType.OBJECT, 'oMapPin', None), ScriptParam(DataType.INT, 'nEnabled', None), ],
        '// 386: Set whether oMapPin is enabled.\r\n// - oMapPin\r\n// - nEnabled: 0 = Off, 1 = On\r\nvoid SetMapPinEnabled(object oMapPin, int nEnabled);',
        '// 386: Set whether oMapPin is enabled.\r\n// - oMapPin\r\n// - nEnabled: 0 = Off, 1 = On\r\nvoid SetMapPinEnabled(object oMapPin, int nEnabled);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectHitPointChangeWhenDying',
        [ScriptParam(DataType.FLOAT, 'fHitPointChangePerRound', None), ],
        '// 387: Create a Hit Point Change When Dying effect.\r\n// - fHitPointChangePerRound: this can be positive or negative, but not zero.\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if fHitPointChangePerRound is 0.\r\neffect EffectHitPointChangeWhenDying(float fHitPointChangePerRound);',
        '// 387: Create a Hit Point Change When Dying effect.\r\n// - fHitPointChangePerRound: this can be positive or negative, but not zero.\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if fHitPointChangePerRound is 0.\r\neffect EffectHitPointChangeWhenDying(float fHitPointChangePerRound);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PopUpGUIPanel',
        [ScriptParam(DataType.OBJECT, 'oPC', None), ScriptParam(DataType.INT, 'nGUIPanel', None), ],
        '// 388: Spawn a GUI panel for the client that controls oPC.\r\n// - oPC\r\n// - nGUIPanel: GUI_PANEL_*\r\n// * Nothing happens if oPC is not a player character or if an invalid value is\r\n//   used for nGUIPanel.\r\nvoid PopUpGUIPanel(object oPC, int nGUIPanel);',
        '// 388: Spawn a GUI panel for the client that controls oPC.\r\n// - oPC\r\n// - nGUIPanel: GUI_PANEL_*\r\n// * Nothing happens if oPC is not a player character or if an invalid value is\r\n//   used for nGUIPanel.\r\nvoid PopUpGUIPanel(object oPC, int nGUIPanel);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AddMultiClass',
        [ScriptParam(DataType.INT, 'nClassType', None), ScriptParam(DataType.OBJECT, 'oSource', None), ],
        '// 389: This allows you to add a new class to any creature object\r\nvoid AddMultiClass(int nClassType, object oSource);',
        '// 389: This allows you to add a new class to any creature object\r\nvoid AddMultiClass(int nClassType, object oSource);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsLinkImmune',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 390: Tests a linked effect to see if the target is immune to it.\r\n// If the target is imune to any of the linked effect then he is immune to all of it\r\nint GetIsLinkImmune(object oTarget, effect eEffect );',
        '// 390: Tests a linked effect to see if the target is immune to it.\r\n// If the target is imune to any of the linked effect then he is immune to all of it\r\nint GetIsLinkImmune(object oTarget, effect eEffect );'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDroidStun',
        [],
        '// 391: Stunn the droid\r\neffect EffectDroidStun( );',
        '// 391: Stunn the droid\r\neffect EffectDroidStun( );'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectForcePushed',
        [],
        '// 392: Force push the creature...\r\neffect EffectForcePushed();',
        '// 392: Force push the creature...\r\neffect EffectForcePushed();'
    ),
    ScriptFunction(
        DataType.VOID,
        'GiveXPToCreature',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nXpAmount', None), ],
        '// 393: Gives nXpAmount to oCreature.\r\nvoid GiveXPToCreature(object oCreature, int nXpAmount);',
        '// 393: Gives nXpAmount to oCreature.\r\nvoid GiveXPToCreature(object oCreature, int nXpAmount);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetXP',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nXpAmount', None), ],
        "// 394: Sets oCreature's experience to nXpAmount.\r\nvoid SetXP(object oCreature, int nXpAmount);",
        "// 394: Sets oCreature's experience to nXpAmount.\r\nvoid SetXP(object oCreature, int nXpAmount);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetXP',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        "// 395: Get oCreature's experience.\r\nint GetXP(object oCreature);",
        "// 395: Get oCreature's experience.\r\nint GetXP(object oCreature);"
    ),
    ScriptFunction(
        DataType.STRING,
        'IntToHexString',
        [ScriptParam(DataType.INT, 'nInteger', None), ],
        '// 396: Convert nInteger to hex, returning the hex value as a string.\r\n// * Return value has the format "0x????????" where each ? will be a hex digit\r\n//   (8 digits in total).\r\nstring IntToHexString(int nInteger);',
        '// 396: Convert nInteger to hex, returning the hex value as a string.\r\n// * Return value has the format "0x????????" where each ? will be a hex digit\r\n//   (8 digits in total).\r\nstring IntToHexString(int nInteger);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetBaseItemType',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 397: Get the base item type (BASE_ITEM_*) of oItem.\r\n// * Returns BASE_ITEM_INVALID if oItem is an invalid item.\r\nint GetBaseItemType(object oItem);',
        '// 397: Get the base item type (BASE_ITEM_*) of oItem.\r\n// * Returns BASE_ITEM_INVALID if oItem is an invalid item.\r\nint GetBaseItemType(object oItem);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetItemHasItemProperty',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.INT, 'nProperty', None), ],
        '// 398: Determines whether oItem has nProperty.\r\n// - oItem\r\n// - nProperty: ITEM_PROPERTY_*\r\n// * Returns FALSE if oItem is not a valid item, or if oItem does not have\r\n//   nProperty.\r\nint GetItemHasItemProperty(object oItem, int nProperty);',
        '// 398: Determines whether oItem has nProperty.\r\n// - oItem\r\n// - nProperty: ITEM_PROPERTY_*\r\n// * Returns FALSE if oItem is not a valid item, or if oItem does not have\r\n//   nProperty.\r\nint GetItemHasItemProperty(object oItem, int nProperty);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionEquipMostDamagingMelee',
        [ScriptParam(DataType.OBJECT, 'oVersus', 1), ScriptParam(DataType.INT, 'bOffHand', 0), ],
        '// 399: The creature will equip the melee weapon in its possession that can do the\r\n// most damage. If no valid melee weapon is found, it will equip the most\r\n// damaging range weapon. This function should only ever be called in the\r\n// EndOfCombatRound scripts, because otherwise it would have to stop the combat\r\n// round to run simulation.\r\n// - oVersus: You can try to get the most damaging weapon against oVersus\r\n// - bOffHand\r\nvoid ActionEquipMostDamagingMelee(object oVersus = OBJECT_INVALID, int bOffHand = FALSE);',
        '// 399: The creature will equip the melee weapon in its possession that can do the\r\n// most damage. If no valid melee weapon is found, it will equip the most\r\n// damaging range weapon. This function should only ever be called in the\r\n// EndOfCombatRound scripts, because otherwise it would have to stop the combat\r\n// round to run simulation.\r\n// - oVersus: You can try to get the most damaging weapon against oVersus\r\n// - bOffHand\r\nvoid ActionEquipMostDamagingMelee(object oVersus = OBJECT_INVALID, int bOffHand = FALSE);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionEquipMostDamagingRanged',
        [ScriptParam(DataType.OBJECT, 'oVersus', 1), ],
        '// 400: The creature will equip the range weapon in its possession that can do the\r\n// most damage.\r\n// If no valid range weapon can be found, it will equip the most damaging melee\r\n// weapon.\r\n// - oVersus: You can try to get the most damaging weapon against oVersus\r\nvoid ActionEquipMostDamagingRanged(object oVersus = OBJECT_INVALID);',
        '// 400: The creature will equip the range weapon in its possession that can do the\r\n// most damage.\r\n// If no valid range weapon can be found, it will equip the most damaging melee\r\n// weapon.\r\n// - oVersus: You can try to get the most damaging weapon against oVersus\r\nvoid ActionEquipMostDamagingRanged(object oVersus = OBJECT_INVALID);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetItemACValue',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 401: Get the Armour Class of oItem.\r\n// * Return 0 if the oItem is not a valid item, or if oItem has no armour value.\r\nint GetItemACValue(object oItem);',
        '// 401: Get the Armour Class of oItem.\r\n// * Return 0 if the oItem is not a valid item, or if oItem has no armour value.\r\nint GetItemACValue(object oItem);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectForceResisted',
        [ScriptParam(DataType.OBJECT, 'oSource', None), ],
        '// 402:\r\n// Effect that will play an animation and display a visual effect to indicate the\r\n// target has resisted a force power.\r\neffect EffectForceResisted( object oSource );',
        '// 402:\r\n// Effect that will play an animation and display a visual effect to indicate the\r\n// target has resisted a force power.\r\neffect EffectForceResisted( object oSource );'
    ),
    ScriptFunction(
        DataType.VOID,
        'ExploreAreaForPlayer',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.OBJECT, 'oPlayer', None), ],
        '// 403: Expose the entire map of oArea to oPlayer.\r\nvoid ExploreAreaForPlayer(object oArea, object oPlayer);',
        '// 403: Expose the entire map of oArea to oPlayer.\r\nvoid ExploreAreaForPlayer(object oArea, object oPlayer);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionEquipMostEffectiveArmor',
        [],
        '// 404: The creature will equip the armour in its possession that has the highest\r\n// armour class.\r\nvoid ActionEquipMostEffectiveArmor();',
        '// 404: The creature will equip the armour in its possession that has the highest\r\n// armour class.\r\nvoid ActionEquipMostEffectiveArmor();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsDay',
        [],
        '// 405: * Returns TRUE if it is currently day.\r\nint GetIsDay();',
        '// 405: * Returns TRUE if it is currently day.\r\nint GetIsDay();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsNight',
        [],
        '// 406: * Returns TRUE if it is currently night.\r\nint GetIsNight();',
        '// 406: * Returns TRUE if it is currently night.\r\nint GetIsNight();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsDawn',
        [],
        '// 407: * Returns TRUE if it is currently dawn.\r\nint GetIsDawn();',
        '// 407: * Returns TRUE if it is currently dawn.\r\nint GetIsDawn();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsDusk',
        [],
        '// 408: * Returns TRUE if it is currently dusk.\r\nint GetIsDusk();',
        '// 408: * Returns TRUE if it is currently dusk.\r\nint GetIsDusk();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsEncounterCreature',
        [ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        '// 409: * Returns TRUE if oCreature was spawned from an encounter.\r\nint GetIsEncounterCreature(object oCreature = OBJECT_SELF);',
        '// 409: * Returns TRUE if oCreature was spawned from an encounter.\r\nint GetIsEncounterCreature(object oCreature = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastPlayerDying',
        [],
        '// 410: Use this in an OnPlayerDying module script to get the last player who is dying.\r\nobject GetLastPlayerDying();',
        '// 410: Use this in an OnPlayerDying module script to get the last player who is dying.\r\nobject GetLastPlayerDying();'
    ),
    ScriptFunction(
        DataType.LOCATION,
        'GetStartingLocation',
        [],
        '// 411: Get the starting location of the module.\r\nlocation GetStartingLocation();',
        '// 411: Get the starting location of the module.\r\nlocation GetStartingLocation();'
    ),
    ScriptFunction(
        DataType.VOID,
        'ChangeToStandardFaction',
        [ScriptParam(DataType.OBJECT, 'oCreatureToChange', None), ScriptParam(DataType.INT, 'nStandardFaction', None), ],
        '// 412: Make oCreatureToChange join one of the standard factions.\r\n// ** This will only work on an NPC **\r\n// - nStandardFaction: STANDARD_FACTION_*\r\nvoid ChangeToStandardFaction(object oCreatureToChange, int nStandardFaction);',
        '// 412: Make oCreatureToChange join one of the standard factions.\r\n// ** This will only work on an NPC **\r\n// - nStandardFaction: STANDARD_FACTION_*\r\nvoid ChangeToStandardFaction(object oCreatureToChange, int nStandardFaction);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SoundObjectPlay',
        [ScriptParam(DataType.OBJECT, 'oSound', None), ],
        '// 413: Play oSound.\r\nvoid SoundObjectPlay(object oSound);',
        '// 413: Play oSound.\r\nvoid SoundObjectPlay(object oSound);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SoundObjectStop',
        [ScriptParam(DataType.OBJECT, 'oSound', None), ],
        '// 414: Stop playing oSound.\r\nvoid SoundObjectStop(object oSound);',
        '// 414: Stop playing oSound.\r\nvoid SoundObjectStop(object oSound);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SoundObjectSetVolume',
        [ScriptParam(DataType.OBJECT, 'oSound', None), ScriptParam(DataType.INT, 'nVolume', None), ],
        '// 415: Set the volume of oSound.\r\n// - oSound\r\n// - nVolume: 0-127\r\nvoid SoundObjectSetVolume(object oSound, int nVolume);',
        '// 415: Set the volume of oSound.\r\n// - oSound\r\n// - nVolume: 0-127\r\nvoid SoundObjectSetVolume(object oSound, int nVolume);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SoundObjectSetPosition',
        [ScriptParam(DataType.OBJECT, 'oSound', None), ScriptParam(DataType.VECTOR, 'vPosition', None), ],
        '// 416: Set the position of oSound.\r\nvoid SoundObjectSetPosition(object oSound, vector vPosition);',
        '// 416: Set the position of oSound.\r\nvoid SoundObjectSetPosition(object oSound, vector vPosition);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SpeakOneLinerConversation',
        [ScriptParam(DataType.STRING, 'sDialogResRef', ''), ScriptParam(DataType.OBJECT, 'oTokenTarget', 32767), ],
        '// 417: Immediately speak a conversation one-liner.\r\n// - sDialogResRef\r\n// - oTokenTarget: This must be specified if there are creature-specific tokens\r\n//   in the string.\r\nvoid SpeakOneLinerConversation(string sDialogResRef = "", object oTokenTarget = OBJECT_TYPE_INVALID);',
        '// 417: Immediately speak a conversation one-liner.\r\n// - sDialogResRef\r\n// - oTokenTarget: This must be specified if there are creature-specific tokens\r\n//   in the string.\r\nvoid SpeakOneLinerConversation(string sDialogResRef = "", object oTokenTarget = OBJECT_TYPE_INVALID);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetGold',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        '// 418: Get the amount of gold possessed by oTarget.\r\nint GetGold(object oTarget = OBJECT_SELF);',
        '// 418: Get the amount of gold possessed by oTarget.\r\nint GetGold(object oTarget = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastRespawnButtonPresser',
        [],
        '// 419: Use this in an OnRespawnButtonPressed module script to get the object id of\r\n// the player who last pressed the respawn button.\r\nobject GetLastRespawnButtonPresser();',
        '// 419: Use this in an OnRespawnButtonPressed module script to get the object id of\r\n// the player who last pressed the respawn button.\r\nobject GetLastRespawnButtonPresser();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectForceFizzle',
        [],
        "// 420:\r\n// Effect that will display a visual effect on the specified object's hand to\r\n// indicate a force power has fizzled out.\r\neffect EffectForceFizzle();",
        "// 420:\r\n// Effect that will display a visual effect on the specified object's hand to\r\n// indicate a force power has fizzled out.\r\neffect EffectForceFizzle();"
    ),
    ScriptFunction(
        DataType.VOID,
        'SetLightsaberPowered',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'bOverride', None), ScriptParam(DataType.INT, 'bPowered', 1), ScriptParam(DataType.INT, 'bShowTransition', 0), ],
        '// 421: SetLightsaberPowered\r\n// Allows a script to set the state of the lightsaber.  This will override any\r\n// game determined lightsaber powerstates.\r\nvoid SetLightsaberPowered( object oCreature, int bOverride, int bPowered  =  TRUE, int bShowTransition  =  FALSE);',
        '// 421: SetLightsaberPowered\r\n// Allows a script to set the state of the lightsaber.  This will override any\r\n// game determined lightsaber powerstates.\r\nvoid SetLightsaberPowered( object oCreature, int bOverride, int bPowered  =  TRUE, int bShowTransition  =  FALSE);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsWeaponEffective',
        [ScriptParam(DataType.OBJECT, 'oVersus', 1), ScriptParam(DataType.INT, 'bOffHand', 0), ],
        '// 422: * Returns TRUE if the weapon equipped is capable of damaging oVersus.\r\nint GetIsWeaponEffective(object oVersus = OBJECT_INVALID, int bOffHand = FALSE);',
        '// 422: * Returns TRUE if the weapon equipped is capable of damaging oVersus.\r\nint GetIsWeaponEffective(object oVersus = OBJECT_INVALID, int bOffHand = FALSE);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastSpellHarmful',
        [],
        '// 423: Use this in a SpellCast script to determine whether the spell was considered\r\n// harmful.\r\n// * Returns TRUE if the last spell cast was harmful.\r\nint GetLastSpellHarmful();',
        '// 423: Use this in a SpellCast script to determine whether the spell was considered\r\n// harmful.\r\n// * Returns TRUE if the last spell cast was harmful.\r\nint GetLastSpellHarmful();'
    ),
    ScriptFunction(
        DataType.EVENT,
        'EventActivateItem',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.LOCATION, 'lTarget', None), ScriptParam(DataType.OBJECT, 'oTarget', 1), ],
        '// 424: Activate oItem.\r\nevent EventActivateItem(object oItem, location lTarget, object oTarget = OBJECT_INVALID);',
        '// 424: Activate oItem.\r\nevent EventActivateItem(object oItem, location lTarget, object oTarget = OBJECT_INVALID);'
    ),
    ScriptFunction(
        DataType.VOID,
        'MusicBackgroundPlay',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ],
        '// 425: Play the background music for oArea.\r\nvoid MusicBackgroundPlay(object oArea);',
        '// 425: Play the background music for oArea.\r\nvoid MusicBackgroundPlay(object oArea);'
    ),
    ScriptFunction(
        DataType.VOID,
        'MusicBackgroundStop',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ],
        '// 426: Stop the background music for oArea.\r\nvoid MusicBackgroundStop(object oArea);',
        '// 426: Stop the background music for oArea.\r\nvoid MusicBackgroundStop(object oArea);'
    ),
    ScriptFunction(
        DataType.VOID,
        'MusicBackgroundSetDelay',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.INT, 'nDelay', None), ],
        '// 427: Set the delay for the background music for oArea.\r\n// - oArea\r\n// - nDelay: delay in milliseconds\r\nvoid MusicBackgroundSetDelay(object oArea, int nDelay);',
        '// 427: Set the delay for the background music for oArea.\r\n// - oArea\r\n// - nDelay: delay in milliseconds\r\nvoid MusicBackgroundSetDelay(object oArea, int nDelay);'
    ),
    ScriptFunction(
        DataType.VOID,
        'MusicBackgroundChangeDay',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.INT, 'nTrack', None), ],
        '// 428: Change the background day track for oArea to nTrack.\r\n// - oArea\r\n// - nTrack\r\nvoid MusicBackgroundChangeDay(object oArea, int nTrack);',
        '// 428: Change the background day track for oArea to nTrack.\r\n// - oArea\r\n// - nTrack\r\nvoid MusicBackgroundChangeDay(object oArea, int nTrack);'
    ),
    ScriptFunction(
        DataType.VOID,
        'MusicBackgroundChangeNight',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.INT, 'nTrack', None), ],
        '// 429: Change the background night track for oArea to nTrack.\r\n// - oArea\r\n// - nTrack\r\nvoid MusicBackgroundChangeNight(object oArea, int nTrack);',
        '// 429: Change the background night track for oArea to nTrack.\r\n// - oArea\r\n// - nTrack\r\nvoid MusicBackgroundChangeNight(object oArea, int nTrack);'
    ),
    ScriptFunction(
        DataType.VOID,
        'MusicBattlePlay',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ],
        '// 430: Play the battle music for oArea.\r\nvoid MusicBattlePlay(object oArea);',
        '// 430: Play the battle music for oArea.\r\nvoid MusicBattlePlay(object oArea);'
    ),
    ScriptFunction(
        DataType.VOID,
        'MusicBattleStop',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ],
        '// 431: Stop the battle music for oArea.\r\nvoid MusicBattleStop(object oArea);',
        '// 431: Stop the battle music for oArea.\r\nvoid MusicBattleStop(object oArea);'
    ),
    ScriptFunction(
        DataType.VOID,
        'MusicBattleChange',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.INT, 'nTrack', None), ],
        '// 432: Change the battle track for oArea.\r\n// - oArea\r\n// - nTrack\r\nvoid MusicBattleChange(object oArea, int nTrack);',
        '// 432: Change the battle track for oArea.\r\n// - oArea\r\n// - nTrack\r\nvoid MusicBattleChange(object oArea, int nTrack);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AmbientSoundPlay',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ],
        '// 433: Play the ambient sound for oArea.\r\nvoid AmbientSoundPlay(object oArea);',
        '// 433: Play the ambient sound for oArea.\r\nvoid AmbientSoundPlay(object oArea);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AmbientSoundStop',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ],
        '// 434: Stop the ambient sound for oArea.\r\nvoid AmbientSoundStop(object oArea);',
        '// 434: Stop the ambient sound for oArea.\r\nvoid AmbientSoundStop(object oArea);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AmbientSoundChangeDay',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.INT, 'nTrack', None), ],
        '// 435: Change the ambient day track for oArea to nTrack.\r\n// - oArea\r\n// - nTrack\r\nvoid AmbientSoundChangeDay(object oArea, int nTrack);',
        '// 435: Change the ambient day track for oArea to nTrack.\r\n// - oArea\r\n// - nTrack\r\nvoid AmbientSoundChangeDay(object oArea, int nTrack);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AmbientSoundChangeNight',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.INT, 'nTrack', None), ],
        '// 436: Change the ambient night track for oArea to nTrack.\r\n// - oArea\r\n// - nTrack\r\nvoid AmbientSoundChangeNight(object oArea, int nTrack);',
        '// 436: Change the ambient night track for oArea to nTrack.\r\n// - oArea\r\n// - nTrack\r\nvoid AmbientSoundChangeNight(object oArea, int nTrack);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastKiller',
        [],
        '// 437: Get the object that killed the caller.\r\nobject GetLastKiller();',
        '// 437: Get the object that killed the caller.\r\nobject GetLastKiller();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetSpellCastItem',
        [],
        '// 438: Use this in a spell script to get the item used to cast the spell.\r\nobject GetSpellCastItem();',
        '// 438: Use this in a spell script to get the item used to cast the spell.\r\nobject GetSpellCastItem();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetItemActivated',
        [],
        '// 439: Use this in an OnItemActivated module script to get the item that was activated.\r\nobject GetItemActivated();',
        '// 439: Use this in an OnItemActivated module script to get the item that was activated.\r\nobject GetItemActivated();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetItemActivator',
        [],
        '// 440: Use this in an OnItemActivated module script to get the creature that\r\n// activated the item.\r\nobject GetItemActivator();',
        '// 440: Use this in an OnItemActivated module script to get the creature that\r\n// activated the item.\r\nobject GetItemActivator();'
    ),
    ScriptFunction(
        DataType.LOCATION,
        'GetItemActivatedTargetLocation',
        [],
        "// 441: Use this in an OnItemActivated module script to get the location of the item's\r\n// target.\r\nlocation GetItemActivatedTargetLocation();",
        "// 441: Use this in an OnItemActivated module script to get the location of the item's\r\n// target.\r\nlocation GetItemActivatedTargetLocation();"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetItemActivatedTarget',
        [],
        "// 442: Use this in an OnItemActivated module script to get the item's target.\r\nobject GetItemActivatedTarget();",
        "// 442: Use this in an OnItemActivated module script to get the item's target.\r\nobject GetItemActivatedTarget();"
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsOpen',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 443: * Returns TRUE if oObject (which is a placeable or a door) is currently open.\r\nint GetIsOpen(object oObject);',
        '// 443: * Returns TRUE if oObject (which is a placeable or a door) is currently open.\r\nint GetIsOpen(object oObject);'
    ),
    ScriptFunction(
        DataType.VOID,
        'TakeGoldFromCreature',
        [ScriptParam(DataType.INT, 'nAmount', None), ScriptParam(DataType.OBJECT, 'oCreatureToTakeFrom', None), ScriptParam(DataType.INT, 'bDestroy', 0), ],
        '// 444: Take nAmount of gold from oCreatureToTakeFrom.\r\n// - nAmount\r\n// - oCreatureToTakeFrom: If this is not a valid creature, nothing will happen.\r\n// - bDestroy: If this is TRUE, the caller will not get the gold.  Instead, the\r\n//   gold will be destroyed and will vanish from the game.\r\nvoid TakeGoldFromCreature(int nAmount, object oCreatureToTakeFrom, int bDestroy = FALSE);',
        '// 444: Take nAmount of gold from oCreatureToTakeFrom.\r\n// - nAmount\r\n// - oCreatureToTakeFrom: If this is not a valid creature, nothing will happen.\r\n// - bDestroy: If this is TRUE, the caller will not get the gold.  Instead, the\r\n//   gold will be destroyed and will vanish from the game.\r\nvoid TakeGoldFromCreature(int nAmount, object oCreatureToTakeFrom, int bDestroy = FALSE);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsInConversation',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 445: Determine whether oObject is in conversation.\r\nint GetIsInConversation(object oObject);',
        '// 445: Determine whether oObject is in conversation.\r\nint GetIsInConversation(object oObject);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectAbilityDecrease',
        [ScriptParam(DataType.INT, 'nAbility', None), ScriptParam(DataType.INT, 'nModifyBy', None), ],
        '// 446: Create an Ability Decrease effect.\r\n// - nAbility: ABILITY_*\r\n// - nModifyBy: This is the amount by which to decrement the ability\r\neffect EffectAbilityDecrease(int nAbility, int nModifyBy);',
        '// 446: Create an Ability Decrease effect.\r\n// - nAbility: ABILITY_*\r\n// - nModifyBy: This is the amount by which to decrement the ability\r\neffect EffectAbilityDecrease(int nAbility, int nModifyBy);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectAttackDecrease',
        [ScriptParam(DataType.INT, 'nPenalty', None), ScriptParam(DataType.INT, 'nModifierType', 0), ],
        '// 447: Create an Attack Decrease effect.\r\n// - nPenalty\r\n// - nModifierType: ATTACK_BONUS_*\r\neffect EffectAttackDecrease(int nPenalty, int nModifierType = ATTACK_BONUS_MISC);',
        '// 447: Create an Attack Decrease effect.\r\n// - nPenalty\r\n// - nModifierType: ATTACK_BONUS_*\r\neffect EffectAttackDecrease(int nPenalty, int nModifierType = ATTACK_BONUS_MISC);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDamageDecrease',
        [ScriptParam(DataType.INT, 'nPenalty', None), ScriptParam(DataType.INT, 'nDamageType', 8), ],
        '// 448: Create a Damage Decrease effect.\r\n// - nPenalty\r\n// - nDamageType: DAMAGE_TYPE_*\r\neffect EffectDamageDecrease(int nPenalty, int nDamageType = DAMAGE_TYPE_UNIVERSAL);',
        '// 448: Create a Damage Decrease effect.\r\n// - nPenalty\r\n// - nDamageType: DAMAGE_TYPE_*\r\neffect EffectDamageDecrease(int nPenalty, int nDamageType = DAMAGE_TYPE_UNIVERSAL);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDamageImmunityDecrease',
        [ScriptParam(DataType.INT, 'nDamageType', None), ScriptParam(DataType.INT, 'nPercentImmunity', None), ],
        '// 449: Create a Damage Immunity Decrease effect.\r\n// - nDamageType: DAMAGE_TYPE_*\r\n// - nPercentImmunity\r\neffect EffectDamageImmunityDecrease(int nDamageType, int nPercentImmunity);',
        '// 449: Create a Damage Immunity Decrease effect.\r\n// - nDamageType: DAMAGE_TYPE_*\r\n// - nPercentImmunity\r\neffect EffectDamageImmunityDecrease(int nDamageType, int nPercentImmunity);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectACDecrease',
        [ScriptParam(DataType.INT, 'nValue', None), ScriptParam(DataType.INT, 'nModifyType', 0), ScriptParam(DataType.INT, 'nDamageType', 8199), ],
        '// 450: Create an AC Decrease effect.\r\n// - nValue\r\n// - nModifyType: AC_*\r\n// - nDamageType: DAMAGE_TYPE_*\r\n//   * Default value for nDamageType should only ever be used in this function prototype.\r\neffect EffectACDecrease(int nValue, int nModifyType = AC_DODGE_BONUS, int nDamageType = AC_VS_DAMAGE_TYPE_ALL);',
        '// 450: Create an AC Decrease effect.\r\n// - nValue\r\n// - nModifyType: AC_*\r\n// - nDamageType: DAMAGE_TYPE_*\r\n//   * Default value for nDamageType should only ever be used in this function prototype.\r\neffect EffectACDecrease(int nValue, int nModifyType = AC_DODGE_BONUS, int nDamageType = AC_VS_DAMAGE_TYPE_ALL);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectMovementSpeedDecrease',
        [ScriptParam(DataType.INT, 'nPercentChange', None), ],
        '// 451: Create a Movement Speed Decrease effect.\r\n// - nPercentChange: This is expected to be a positive integer between 1 and 99 inclusive.\r\n//   If a negative integer is supplied then a movement speed increase will result,\r\n//   and if a number > =  100 is supplied then the effect is deleted.\r\neffect EffectMovementSpeedDecrease(int nPercentChange);',
        '// 451: Create a Movement Speed Decrease effect.\r\n// - nPercentChange: This is expected to be a positive integer between 1 and 99 inclusive.\r\n//   If a negative integer is supplied then a movement speed increase will result,\r\n//   and if a number > =  100 is supplied then the effect is deleted.\r\neffect EffectMovementSpeedDecrease(int nPercentChange);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectSavingThrowDecrease',
        [ScriptParam(DataType.INT, 'nSave', None), ScriptParam(DataType.INT, 'nValue', None), ScriptParam(DataType.INT, 'nSaveType', 0), ],
        '// 452: Create a Saving Throw Decrease effect.\r\n// - nSave\r\n// - nValue\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\neffect EffectSavingThrowDecrease(int nSave, int nValue, int nSaveType = SAVING_THROW_TYPE_ALL);',
        '// 452: Create a Saving Throw Decrease effect.\r\n// - nSave\r\n// - nValue\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\neffect EffectSavingThrowDecrease(int nSave, int nValue, int nSaveType = SAVING_THROW_TYPE_ALL);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectSkillDecrease',
        [ScriptParam(DataType.INT, 'nSkill', None), ScriptParam(DataType.INT, 'nValue', None), ],
        '// 453: Create a Skill Decrease effect.\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nSkill is invalid.\r\neffect EffectSkillDecrease(int nSkill, int nValue);',
        '// 453: Create a Skill Decrease effect.\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nSkill is invalid.\r\neffect EffectSkillDecrease(int nSkill, int nValue);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectForceResistanceDecrease',
        [ScriptParam(DataType.INT, 'nValue', None), ],
        '// 454: Create a Force Resistance Decrease effect.\r\neffect EffectForceResistanceDecrease(int nValue);',
        '// 454: Create a Force Resistance Decrease effect.\r\neffect EffectForceResistanceDecrease(int nValue);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetPlotFlag',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        '// 455: Determine whether oTarget is a plot object.\r\nint GetPlotFlag(object oTarget = OBJECT_SELF);',
        '// 455: Determine whether oTarget is a plot object.\r\nint GetPlotFlag(object oTarget = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetPlotFlag',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'nPlotFlag', None), ],
        "// 456: Set oTarget's plot object status.\r\nvoid SetPlotFlag(object oTarget, int nPlotFlag);",
        "// 456: Set oTarget's plot object status.\r\nvoid SetPlotFlag(object oTarget, int nPlotFlag);"
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectInvisibility',
        [ScriptParam(DataType.INT, 'nInvisibilityType', None), ],
        '// 457: Create an Invisibility effect.\r\n// - nInvisibilityType: INVISIBILITY_TYPE_*\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nInvisibilityType\r\n//   is invalid.\r\neffect EffectInvisibility(int nInvisibilityType);',
        '// 457: Create an Invisibility effect.\r\n// - nInvisibilityType: INVISIBILITY_TYPE_*\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nInvisibilityType\r\n//   is invalid.\r\neffect EffectInvisibility(int nInvisibilityType);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectConcealment',
        [ScriptParam(DataType.INT, 'nPercentage', None), ],
        '// 458: Create a Concealment effect.\r\n// - nPercentage: 1-100 inclusive\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nPercentage < 1 or\r\n//   nPercentage > 100.\r\neffect EffectConcealment(int nPercentage);',
        '// 458: Create a Concealment effect.\r\n// - nPercentage: 1-100 inclusive\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nPercentage < 1 or\r\n//   nPercentage > 100.\r\neffect EffectConcealment(int nPercentage);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectForceShield',
        [ScriptParam(DataType.INT, 'nShield', None), ],
        '// 459: Create a Force Shield that has parameters from the guven index into the forceshields.2da\r\neffect EffectForceShield(int nShield);',
        '// 459: Create a Force Shield that has parameters from the guven index into the forceshields.2da\r\neffect EffectForceShield(int nShield);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDispelMagicAll',
        [ScriptParam(DataType.INT, 'nCasterLevel', None), ],
        '// 460: Create a Dispel Magic All effect.\r\neffect EffectDispelMagicAll(int nCasterLevel);',
        '// 460: Create a Dispel Magic All effect.\r\neffect EffectDispelMagicAll(int nCasterLevel);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetDialogPlaceableCamera',
        [ScriptParam(DataType.INT, 'nCameraId', None), ],
        "// 461: Cut immediately to placeable camera 'nCameraId' during dialog.  nCameraId must be\r\n//      an existing Placeable Camera ID.  Function only works during Dialog.\r\nvoid SetDialogPlaceableCamera( int nCameraId );",
        "// 461: Cut immediately to placeable camera 'nCameraId' during dialog.  nCameraId must be\r\n//      an existing Placeable Camera ID.  Function only works during Dialog.\r\nvoid SetDialogPlaceableCamera( int nCameraId );"
    ),
    ScriptFunction(
        DataType.INT,
        'GetSoloMode',
        [],
        "// 462:\r\n// Returns: TRUE if the player is in 'solo mode' (ie. the party is not supposed to follow the player).\r\n//          FALSE otherwise.\r\nint GetSoloMode();",
        "// 462:\r\n// Returns: TRUE if the player is in 'solo mode' (ie. the party is not supposed to follow the player).\r\n//          FALSE otherwise.\r\nint GetSoloMode();"
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDisguise',
        [ScriptParam(DataType.INT, 'nDisguiseAppearance', None), ],
        '// 463: Create a Disguise effect.\r\n// - * nDisguiseAppearance: DISGUISE_TYPE_*s\r\neffect EffectDisguise(int nDisguiseAppearance);',
        '// 463: Create a Disguise effect.\r\n// - * nDisguiseAppearance: DISGUISE_TYPE_*s\r\neffect EffectDisguise(int nDisguiseAppearance);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetMaxStealthXP',
        [],
        '// 464:\r\n// Returns the maximum amount of stealth xp available in the area.\r\nint GetMaxStealthXP();',
        '// 464:\r\n// Returns the maximum amount of stealth xp available in the area.\r\nint GetMaxStealthXP();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectTrueSeeing',
        [],
        '// 465: Create a True Seeing effect.\r\neffect EffectTrueSeeing();',
        '// 465: Create a True Seeing effect.\r\neffect EffectTrueSeeing();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectSeeInvisible',
        [],
        '// 466: Create a See Invisible effect.\r\neffect EffectSeeInvisible();',
        '// 466: Create a See Invisible effect.\r\neffect EffectSeeInvisible();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectTimeStop',
        [],
        '// 467: Create a Time Stop effect.\r\neffect EffectTimeStop();',
        '// 467: Create a Time Stop effect.\r\neffect EffectTimeStop();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetMaxStealthXP',
        [ScriptParam(DataType.INT, 'nMax', None), ],
        '// 468:\r\n// Set the maximum amount of stealth xp available in the area.\r\nvoid SetMaxStealthXP( int nMax );',
        '// 468:\r\n// Set the maximum amount of stealth xp available in the area.\r\nvoid SetMaxStealthXP( int nMax );'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectBlasterDeflectionIncrease',
        [ScriptParam(DataType.INT, 'nChange', None), ],
        '// 469: Increase the blaster deflection rate, i think...\r\neffect EffectBlasterDeflectionIncrease(int nChange);',
        '// 469: Increase the blaster deflection rate, i think...\r\neffect EffectBlasterDeflectionIncrease(int nChange);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectBlasterDeflectionDecrease',
        [ScriptParam(DataType.INT, 'nChange', None), ],
        '// 470:decrease the blaster deflection rate\r\neffect EffectBlasterDeflectionDecrease(int nChange);',
        '// 470:decrease the blaster deflection rate\r\neffect EffectBlasterDeflectionDecrease(int nChange);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectHorrified',
        [],
        '// 471: Make the creature horified. BOO!\r\neffect EffectHorrified( );',
        '// 471: Make the creature horified. BOO!\r\neffect EffectHorrified( );'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectSpellLevelAbsorption',
        [ScriptParam(DataType.INT, 'nMaxSpellLevelAbsorbed', None), ScriptParam(DataType.INT, 'nTotalSpellLevelsAbsorbed', 0), ScriptParam(DataType.INT, 'nSpellSchool', 0), ],
        '// 472: Create a Spell Level Absorption effect.\r\n// - nMaxSpellLevelAbsorbed: maximum spell level that will be absorbed by the\r\n//   effect\r\n// - nTotalSpellLevelsAbsorbed: maximum number of spell levels that will be\r\n//   absorbed by the effect\r\n// - nSpellSchool: SPELL_SCHOOL_*\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if:\r\n//   nMaxSpellLevelAbsorbed is not between -1 and 9 inclusive, or nSpellSchool\r\n//   is invalid.\r\neffect EffectSpellLevelAbsorption(int nMaxSpellLevelAbsorbed, int nTotalSpellLevelsAbsorbed = 0, int nSpellSchool = 0 );',
        '// 472: Create a Spell Level Absorption effect.\r\n// - nMaxSpellLevelAbsorbed: maximum spell level that will be absorbed by the\r\n//   effect\r\n// - nTotalSpellLevelsAbsorbed: maximum number of spell levels that will be\r\n//   absorbed by the effect\r\n// - nSpellSchool: SPELL_SCHOOL_*\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if:\r\n//   nMaxSpellLevelAbsorbed is not between -1 and 9 inclusive, or nSpellSchool\r\n//   is invalid.\r\neffect EffectSpellLevelAbsorption(int nMaxSpellLevelAbsorbed, int nTotalSpellLevelsAbsorbed = 0, int nSpellSchool = 0 );'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDispelMagicBest',
        [ScriptParam(DataType.INT, 'nCasterLevel', None), ],
        '// 473: Create a Dispel Magic Best effect.\r\neffect EffectDispelMagicBest(int nCasterLevel);',
        '// 473: Create a Dispel Magic Best effect.\r\neffect EffectDispelMagicBest(int nCasterLevel);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetCurrentStealthXP',
        [],
        '// 474:\r\n// Returns the current amount of stealth xp available in the area.\r\nint GetCurrentStealthXP();',
        '// 474:\r\n// Returns the current amount of stealth xp available in the area.\r\nint GetCurrentStealthXP();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetNumStackedItems',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 475: Get the number of stacked items that oItem comprises.\r\nint GetNumStackedItems(object oItem);',
        '// 475: Get the number of stacked items that oItem comprises.\r\nint GetNumStackedItems(object oItem);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SurrenderToEnemies',
        [],
        "// 476: Use this on an NPC to cause all creatures within a 10-metre radius to stop\r\n// what they are doing and sets the NPC's enemies within this range to be\r\n// neutral towards the NPC. If this command is run on a PC or an object that is\r\n// not a creature, nothing will happen.\r\nvoid SurrenderToEnemies();",
        "// 476: Use this on an NPC to cause all creatures within a 10-metre radius to stop\r\n// what they are doing and sets the NPC's enemies within this range to be\r\n// neutral towards the NPC. If this command is run on a PC or an object that is\r\n// not a creature, nothing will happen.\r\nvoid SurrenderToEnemies();"
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectMissChance',
        [ScriptParam(DataType.INT, 'nPercentage', None), ],
        '// 477: Create a Miss Chance effect.\r\n// - nPercentage: 1-100 inclusive\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nPercentage < 1 or\r\n//   nPercentage > 100.\r\neffect EffectMissChance(int nPercentage);',
        '// 477: Create a Miss Chance effect.\r\n// - nPercentage: 1-100 inclusive\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nPercentage < 1 or\r\n//   nPercentage > 100.\r\neffect EffectMissChance(int nPercentage);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetCurrentStealthXP',
        [ScriptParam(DataType.INT, 'nCurrent', None), ],
        '// 478:\r\n// Set the current amount of stealth xp available in the area.\r\nvoid SetCurrentStealthXP( int nCurrent );',
        '// 478:\r\n// Set the current amount of stealth xp available in the area.\r\nvoid SetCurrentStealthXP( int nCurrent );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetCreatureSize',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 479: Get the size (CREATURE_SIZE_*) of oCreature.\r\nint GetCreatureSize(object oCreature);',
        '// 479: Get the size (CREATURE_SIZE_*) of oCreature.\r\nint GetCreatureSize(object oCreature);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AwardStealthXP',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 480:\r\n// Award the stealth xp to the given oTarget.  This will only work on creatures.\r\nvoid AwardStealthXP( object oTarget );',
        '// 480:\r\n// Award the stealth xp to the given oTarget.  This will only work on creatures.\r\nvoid AwardStealthXP( object oTarget );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetStealthXPEnabled',
        [],
        '// 481:\r\n// Returns whether or not the stealth xp bonus is enabled (ie. whether or not\r\n// AwardStealthXP() will actually award any available stealth xp).\r\nint GetStealthXPEnabled();',
        '// 481:\r\n// Returns whether or not the stealth xp bonus is enabled (ie. whether or not\r\n// AwardStealthXP() will actually award any available stealth xp).\r\nint GetStealthXPEnabled();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetStealthXPEnabled',
        [ScriptParam(DataType.INT, 'bEnabled', None), ],
        '// 482:\r\n// Sets whether or not the stealth xp bonus is enabled (ie. whether or not\r\n// AwardStealthXP() will actually award any available stealth xp).\r\nvoid SetStealthXPEnabled( int bEnabled );',
        '// 482:\r\n// Sets whether or not the stealth xp bonus is enabled (ie. whether or not\r\n// AwardStealthXP() will actually award any available stealth xp).\r\nvoid SetStealthXPEnabled( int bEnabled );'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionUnlockObject',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 483: The action subject will unlock oTarget, which can be a door or a placeable\r\n// object.\r\nvoid ActionUnlockObject(object oTarget);',
        '// 483: The action subject will unlock oTarget, which can be a door or a placeable\r\n// object.\r\nvoid ActionUnlockObject(object oTarget);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionLockObject',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 484: The action subject will lock oTarget, which can be a door or a placeable\r\n// object.\r\nvoid ActionLockObject(object oTarget);',
        '// 484: The action subject will lock oTarget, which can be a door or a placeable\r\n// object.\r\nvoid ActionLockObject(object oTarget);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectModifyAttacks',
        [ScriptParam(DataType.INT, 'nAttacks', None), ],
        '// 485: Create a Modify Attacks effect to add attacks.\r\n// - nAttacks: maximum is 5, even with the effect stacked\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nAttacks > 5.\r\neffect EffectModifyAttacks(int nAttacks);',
        '// 485: Create a Modify Attacks effect to add attacks.\r\n// - nAttacks: maximum is 5, even with the effect stacked\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nAttacks > 5.\r\neffect EffectModifyAttacks(int nAttacks);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastTrapDetected',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        '// 486: Get the last trap detected by oTarget.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetLastTrapDetected(object oTarget = OBJECT_SELF);',
        '// 486: Get the last trap detected by oTarget.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetLastTrapDetected(object oTarget = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDamageShield',
        [ScriptParam(DataType.INT, 'nDamageAmount', None), ScriptParam(DataType.INT, 'nRandomAmount', None), ScriptParam(DataType.INT, 'nDamageType', None), ],
        '// 487: Create a Damage Shield effect which does (nDamageAmount + nRandomAmount)\r\n// damage to any melee attacker on a successful attack of damage type nDamageType.\r\n// - nDamageAmount: an integer value\r\n// - nRandomAmount: DAMAGE_BONUS_*\r\n// - nDamageType: DAMAGE_TYPE_*\r\neffect EffectDamageShield(int nDamageAmount, int nRandomAmount, int nDamageType);',
        '// 487: Create a Damage Shield effect which does (nDamageAmount + nRandomAmount)\r\n// damage to any melee attacker on a successful attack of damage type nDamageType.\r\n// - nDamageAmount: an integer value\r\n// - nRandomAmount: DAMAGE_BONUS_*\r\n// - nDamageType: DAMAGE_TYPE_*\r\neffect EffectDamageShield(int nDamageAmount, int nRandomAmount, int nDamageType);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNearestTrapToObject',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ScriptParam(DataType.INT, 'nTrapDetected', 1), ],
        '// 488: Get the trap nearest to oTarget.\r\n// Note : "trap objects" are actually any trigger, placeable or door that is\r\n// trapped in oTarget\'s area.\r\n// - oTarget\r\n// - nTrapDetected: if this is TRUE, the trap returned has to have been detected\r\n//   by oTarget.\r\nobject GetNearestTrapToObject(object oTarget = OBJECT_SELF, int nTrapDetected = TRUE);',
        '// 488: Get the trap nearest to oTarget.\r\n// Note : "trap objects" are actually any trigger, placeable or door that is\r\n// trapped in oTarget\'s area.\r\n// - oTarget\r\n// - nTrapDetected: if this is TRUE, the trap returned has to have been detected\r\n//   by oTarget.\r\nobject GetNearestTrapToObject(object oTarget = OBJECT_SELF, int nTrapDetected = TRUE);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetAttemptedMovementTarget',
        [],
        '// 489: the will get the last attmpted movment target\r\nobject GetAttemptedMovementTarget();',
        '// 489: the will get the last attmpted movment target\r\nobject GetAttemptedMovementTarget();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetBlockingCreature',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        '// 490: this function returns the bloking creature for the k_def_CBTBlk01 script\r\nobject GetBlockingCreature(object oTarget = OBJECT_SELF);',
        '// 490: this function returns the bloking creature for the k_def_CBTBlk01 script\r\nobject GetBlockingCreature(object oTarget = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetFortitudeSavingThrow',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        "// 491: Get oTarget's base fortitude saving throw value (this will only work for\r\n// creatures, doors, and placeables).\r\n// * Returns 0 if oTarget is invalid.\r\nint GetFortitudeSavingThrow(object oTarget);",
        "// 491: Get oTarget's base fortitude saving throw value (this will only work for\r\n// creatures, doors, and placeables).\r\n// * Returns 0 if oTarget is invalid.\r\nint GetFortitudeSavingThrow(object oTarget);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetWillSavingThrow',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        "// 492: Get oTarget's base will saving throw value (this will only work for creatures,\r\n// doors, and placeables).\r\n// * Returns 0 if oTarget is invalid.\r\nint GetWillSavingThrow(object oTarget);",
        "// 492: Get oTarget's base will saving throw value (this will only work for creatures,\r\n// doors, and placeables).\r\n// * Returns 0 if oTarget is invalid.\r\nint GetWillSavingThrow(object oTarget);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetReflexSavingThrow',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        "// 493: Get oTarget's base reflex saving throw value (this will only work for\r\n// creatures, doors, and placeables).\r\n// * Returns 0 if oTarget is invalid.\r\nint GetReflexSavingThrow(object oTarget);",
        "// 493: Get oTarget's base reflex saving throw value (this will only work for\r\n// creatures, doors, and placeables).\r\n// * Returns 0 if oTarget is invalid.\r\nint GetReflexSavingThrow(object oTarget);"
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetChallengeRating',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        "// 494: Get oCreature's challenge rating.\r\n// * Returns 0.0 if oCreature is invalid.\r\nfloat GetChallengeRating(object oCreature);",
        "// 494: Get oCreature's challenge rating.\r\n// * Returns 0.0 if oCreature is invalid.\r\nfloat GetChallengeRating(object oCreature);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFoundEnemyCreature',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        '// 495: Returns the found enemy creature on a pathfind.\r\nobject GetFoundEnemyCreature(object oTarget = OBJECT_SELF);',
        '// 495: Returns the found enemy creature on a pathfind.\r\nobject GetFoundEnemyCreature(object oTarget = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetMovementRate',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        "// 496: Get oCreature's movement rate.\r\n// * Returns 0 if oCreature is invalid.\r\nint GetMovementRate(object oCreature);",
        "// 496: Get oCreature's movement rate.\r\n// * Returns 0 if oCreature is invalid.\r\nint GetMovementRate(object oCreature);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetSubRace',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 497: GetSubRace of oCreature\r\n// Returns SUBRACE_*\r\nint GetSubRace(object oCreature);',
        '// 497: GetSubRace of oCreature\r\n// Returns SUBRACE_*\r\nint GetSubRace(object oCreature);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetStealthXPDecrement',
        [],
        '// 498:\r\n// Returns the amount the stealth xp bonus gets decreased each time the player is detected.\r\nint GetStealthXPDecrement();',
        '// 498:\r\n// Returns the amount the stealth xp bonus gets decreased each time the player is detected.\r\nint GetStealthXPDecrement();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetStealthXPDecrement',
        [ScriptParam(DataType.INT, 'nDecrement', None), ],
        '// 499:\r\n// Sets the amount the stealth xp bonus gets decreased each time the player is detected.\r\nvoid SetStealthXPDecrement( int nDecrement );',
        '// 499:\r\n// Sets the amount the stealth xp bonus gets decreased each time the player is detected.\r\nvoid SetStealthXPDecrement( int nDecrement );'
    ),
    ScriptFunction(
        DataType.VOID,
        'DuplicateHeadAppearance',
        [ScriptParam(DataType.OBJECT, 'oidCreatureToChange', None), ScriptParam(DataType.OBJECT, 'oidCreatureToMatch', None), ],
        '// 500:\r\nvoid DuplicateHeadAppearance(object oidCreatureToChange, object oidCreatureToMatch);',
        '// 500:\r\nvoid DuplicateHeadAppearance(object oidCreatureToChange, object oidCreatureToMatch);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionCastFakeSpellAtObject',
        [ScriptParam(DataType.INT, 'nSpell', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'nProjectilePathType', 0), ],
        '// 501: The action subject will fake casting a spell at oTarget; the conjure and cast\r\n// animations and visuals will occur, nothing else.\r\n// - nSpell\r\n// - oTarget\r\n// - nProjectilePathType: PROJECTILE_PATH_TYPE_*\r\nvoid ActionCastFakeSpellAtObject(int nSpell, object oTarget, int nProjectilePathType = PROJECTILE_PATH_TYPE_DEFAULT);',
        '// 501: The action subject will fake casting a spell at oTarget; the conjure and cast\r\n// animations and visuals will occur, nothing else.\r\n// - nSpell\r\n// - oTarget\r\n// - nProjectilePathType: PROJECTILE_PATH_TYPE_*\r\nvoid ActionCastFakeSpellAtObject(int nSpell, object oTarget, int nProjectilePathType = PROJECTILE_PATH_TYPE_DEFAULT);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionCastFakeSpellAtLocation',
        [ScriptParam(DataType.INT, 'nSpell', None), ScriptParam(DataType.LOCATION, 'lTarget', None), ScriptParam(DataType.INT, 'nProjectilePathType', 0), ],
        '// 502: The action subject will fake casting a spell at lLocation; the conjure and\r\n// cast animations and visuals will occur, nothing else.\r\n// - nSpell\r\n// - lTarget\r\n// - nProjectilePathType: PROJECTILE_PATH_TYPE_*\r\nvoid ActionCastFakeSpellAtLocation(int nSpell, location lTarget, int nProjectilePathType = PROJECTILE_PATH_TYPE_DEFAULT);',
        '// 502: The action subject will fake casting a spell at lLocation; the conjure and\r\n// cast animations and visuals will occur, nothing else.\r\n// - nSpell\r\n// - lTarget\r\n// - nProjectilePathType: PROJECTILE_PATH_TYPE_*\r\nvoid ActionCastFakeSpellAtLocation(int nSpell, location lTarget, int nProjectilePathType = PROJECTILE_PATH_TYPE_DEFAULT);'
    ),
    ScriptFunction(
        DataType.VOID,
        'CutsceneAttack',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'nAnimation', None), ScriptParam(DataType.INT, 'nAttackResult', None), ScriptParam(DataType.INT, 'nDamage', None), ],
        "// 503: CutsceneAttack\r\n// This function allows the designer to specify exactly what's going to happen in a combat round\r\n// There are no guarentees made that the animation specified here will be correct - only that it will be played,\r\n// so it is up to the designer to ensure that they have selected the right animation\r\n// It relies upon constants specified above for the attack result\r\nvoid CutsceneAttack(object oTarget, int nAnimation, int nAttackResult, int nDamage);",
        "// 503: CutsceneAttack\r\n// This function allows the designer to specify exactly what's going to happen in a combat round\r\n// There are no guarentees made that the animation specified here will be correct - only that it will be played,\r\n// so it is up to the designer to ensure that they have selected the right animation\r\n// It relies upon constants specified above for the attack result\r\nvoid CutsceneAttack(object oTarget, int nAnimation, int nAttackResult, int nDamage);"
    ),
    ScriptFunction(
        DataType.VOID,
        'SetCameraMode',
        [ScriptParam(DataType.OBJECT, 'oPlayer', None), ScriptParam(DataType.INT, 'nCameraMode', None), ],
        '// 504: Set the camera mode for oPlayer.\r\n// - oPlayer\r\n// - nCameraMode: CAMERA_MODE_*\r\n// * If oPlayer is not player-controlled or nCameraMode is invalid, nothing\r\n//   happens.\r\nvoid SetCameraMode(object oPlayer, int nCameraMode);',
        '// 504: Set the camera mode for oPlayer.\r\n// - oPlayer\r\n// - nCameraMode: CAMERA_MODE_*\r\n// * If oPlayer is not player-controlled or nCameraMode is invalid, nothing\r\n//   happens.\r\nvoid SetCameraMode(object oPlayer, int nCameraMode);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetLockOrientationInDialog',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.INT, 'nValue', None), ],
        '// 505: SetLockOrientationInDialog\r\n// Allows the locking and unlocking of orientation changes for an object in dialog\r\n// - oObject - Object\r\n// - nValue - TRUE or FALSE\r\nvoid SetLockOrientationInDialog(object oObject, int nValue);',
        '// 505: SetLockOrientationInDialog\r\n// Allows the locking and unlocking of orientation changes for an object in dialog\r\n// - oObject - Object\r\n// - nValue - TRUE or FALSE\r\nvoid SetLockOrientationInDialog(object oObject, int nValue);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetLockHeadFollowInDialog',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.INT, 'nValue', None), ],
        '// 506: SetLockHeadFollowInDialog\r\n// Allows the locking and undlocking of head following for an object in dialog\r\n// - oObject - Object\r\n// - nValue - TRUE or FALSE\r\nvoid SetLockHeadFollowInDialog(object oObject, int nValue);',
        '// 506: SetLockHeadFollowInDialog\r\n// Allows the locking and undlocking of head following for an object in dialog\r\n// - oObject - Object\r\n// - nValue - TRUE or FALSE\r\nvoid SetLockHeadFollowInDialog(object oObject, int nValue);'
    ),
    ScriptFunction(
        DataType.VOID,
        'CutsceneMove',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.VECTOR, 'vPosition', None), ScriptParam(DataType.INT, 'nRun', None), ],
        '// 507: CutsceneMoveToPoint\r\n// Used by the cutscene system to allow designers to script combat\r\nvoid CutsceneMove(object oObject, vector vPosition, int nRun);',
        '// 507: CutsceneMoveToPoint\r\n// Used by the cutscene system to allow designers to script combat\r\nvoid CutsceneMove(object oObject, vector vPosition, int nRun);'
    ),
    ScriptFunction(
        DataType.VOID,
        'EnableVideoEffect',
        [ScriptParam(DataType.INT, 'nEffectType', None), ],
        '// 508: EnableVideoEffect\r\n// Enables the video frame buffer effect specified by nEffectType, which is\r\n// an index into VideoEffects.2da. This video effect will apply indefinitely,\r\n// and so it should *always* be cleared by a call to DisableVideoEffect().\r\nvoid EnableVideoEffect(int nEffectType);',
        '// 508: EnableVideoEffect\r\n// Enables the video frame buffer effect specified by nEffectType, which is\r\n// an index into VideoEffects.2da. This video effect will apply indefinitely,\r\n// and so it should *always* be cleared by a call to DisableVideoEffect().\r\nvoid EnableVideoEffect(int nEffectType);'
    ),
    ScriptFunction(
        DataType.VOID,
        'StartNewModule',
        [ScriptParam(DataType.STRING, 'sModuleName', None), ScriptParam(DataType.STRING, 'sWayPoint', ''), ScriptParam(DataType.STRING, 'sMovie1', ''), ScriptParam(DataType.STRING, 'sMovie2', ''), ScriptParam(DataType.STRING, 'sMovie3', ''), ScriptParam(DataType.STRING, 'sMovie4', ''), ScriptParam(DataType.STRING, 'sMovie5', ''), ScriptParam(DataType.STRING, 'sMovie6', ''), ],
        '// 509: Shut down the currently loaded module and start a new one (moving all\r\n// currently-connected players to the starting point.\r\nvoid StartNewModule(string sModuleName, string sWayPoint = "", string sMovie1 = "", string sMovie2 = "", string sMovie3 = "", string sMovie4 = "", string sMovie5 = "", string sMovie6 = "");',
        '// 509: Shut down the currently loaded module and start a new one (moving all\r\n// currently-connected players to the starting point.\r\nvoid StartNewModule(string sModuleName, string sWayPoint = "", string sMovie1 = "", string sMovie2 = "", string sMovie3 = "", string sMovie4 = "", string sMovie5 = "", string sMovie6 = "");'
    ),
    ScriptFunction(
        DataType.VOID,
        'DisableVideoEffect',
        [],
        '// 510: DisableVideoEffect\r\n// Disables any video frame buffer effect that may be running. See\r\n// EnableVideoEffect() to see how to use them.\r\nvoid DisableVideoEffect();',
        '// 510: DisableVideoEffect\r\n// Disables any video frame buffer effect that may be running. See\r\n// EnableVideoEffect() to see how to use them.\r\nvoid DisableVideoEffect();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetWeaponRanged',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 511: * Returns TRUE if oItem is a ranged weapon.\r\nint GetWeaponRanged(object oItem);',
        '// 511: * Returns TRUE if oItem is a ranged weapon.\r\nint GetWeaponRanged(object oItem);'
    ),
    ScriptFunction(
        DataType.VOID,
        'DoSinglePlayerAutoSave',
        [],
        '// 512: Only if we are in a single player game, AutoSave the game.\r\nvoid DoSinglePlayerAutoSave();',
        '// 512: Only if we are in a single player game, AutoSave the game.\r\nvoid DoSinglePlayerAutoSave();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetGameDifficulty',
        [],
        '// 513: Get the game difficulty (GAME_DIFFICULTY_*).\r\nint GetGameDifficulty();',
        '// 513: Get the game difficulty (GAME_DIFFICULTY_*).\r\nint GetGameDifficulty();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetUserActionsPending',
        [],
        '// 514:\r\n// This will test the combat action queu to see if the user has placed any actions on the queue.\r\n// will only work during combat.\r\nint GetUserActionsPending();',
        '// 514:\r\n// This will test the combat action queu to see if the user has placed any actions on the queue.\r\n// will only work during combat.\r\nint GetUserActionsPending();'
    ),
    ScriptFunction(
        DataType.VOID,
        'RevealMap',
        [ScriptParam(DataType.VECTOR, 'vPoint', Vector3(0.0, 0.0, 0.0)), ScriptParam(DataType.INT, 'nRadius', -1), ],
        "// 515: RevealMap\r\n// Reveals the map at the given WORLD point 'vPoint' with a MAP Grid Radius 'nRadius'\r\n// If this function is called with no parameters it will reveal the entire map.\r\n// (NOTE: if this function is called with a valid point but a default radius, ie. 'nRadius' of -1\r\n//        then the entire map will be revealed)\r\nvoid RevealMap(vector vPoint = [0.0,0.0,0.0],int nRadius = -1);",
        "// 515: RevealMap\r\n// Reveals the map at the given WORLD point 'vPoint' with a MAP Grid Radius 'nRadius'\r\n// If this function is called with no parameters it will reveal the entire map.\r\n// (NOTE: if this function is called with a valid point but a default radius, ie. 'nRadius' of -1\r\n//        then the entire map will be revealed)\r\nvoid RevealMap(vector vPoint = [0.0,0.0,0.0],int nRadius = -1);"
    ),
    ScriptFunction(
        DataType.VOID,
        'SetTutorialWindowsEnabled',
        [ScriptParam(DataType.INT, 'bEnabled', None), ],
        '// 516: SetTutorialWindowsEnabled\r\n// Sets whether or not the tutorial windows are enabled (ie. whether or not they will\r\n// appear when certain things happen for the first time).\r\nvoid SetTutorialWindowsEnabled( int bEnabled );',
        '// 516: SetTutorialWindowsEnabled\r\n// Sets whether or not the tutorial windows are enabled (ie. whether or not they will\r\n// appear when certain things happen for the first time).\r\nvoid SetTutorialWindowsEnabled( int bEnabled );'
    ),
    ScriptFunction(
        DataType.VOID,
        'ShowTutorialWindow',
        [ScriptParam(DataType.INT, 'nWindow', None), ],
        '// 517: ShowTutorialWindow\r\n// Pops up the specified tutorial window.  If the tutorial window has already popped\r\n// up once before, this will do nothing.\r\nvoid ShowTutorialWindow( int nWindow );',
        '// 517: ShowTutorialWindow\r\n// Pops up the specified tutorial window.  If the tutorial window has already popped\r\n// up once before, this will do nothing.\r\nvoid ShowTutorialWindow( int nWindow );'
    ),
    ScriptFunction(
        DataType.VOID,
        'StartCreditSequence',
        [ScriptParam(DataType.INT, 'bTransparentBackground', None), ],
        '// 518: StartCreditSequence\r\n// Starts the credits sequence.  If bTransparentBackground is TRUE, the credits will be displayed\r\n// with a transparent background, allowing whatever is currently onscreen to show through.  If it\r\n// is set to FALSE, the credits will be displayed on a black background.\r\nvoid StartCreditSequence( int bTransparentBackground );',
        '// 518: StartCreditSequence\r\n// Starts the credits sequence.  If bTransparentBackground is TRUE, the credits will be displayed\r\n// with a transparent background, allowing whatever is currently onscreen to show through.  If it\r\n// is set to FALSE, the credits will be displayed on a black background.\r\nvoid StartCreditSequence( int bTransparentBackground );'
    ),
    ScriptFunction(
        DataType.INT,
        'IsCreditSequenceInProgress',
        [],
        '// 519: IsCreditSequenceInProgress\r\n// Returns TRUE if the credits sequence is currently in progress, FALSE otherwise.\r\nint IsCreditSequenceInProgress();',
        '// 519: IsCreditSequenceInProgress\r\n// Returns TRUE if the credits sequence is currently in progress, FALSE otherwise.\r\nint IsCreditSequenceInProgress();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetLateralAccelerationPerSecond',
        [ScriptParam(DataType.FLOAT, 'fLAPS', None), ],
        '// 520: Sets the minigame lateral acceleration/sec value\r\nvoid SWMG_SetLateralAccelerationPerSecond(float fLAPS);',
        '// 520: Sets the minigame lateral acceleration/sec value\r\nvoid SWMG_SetLateralAccelerationPerSecond(float fLAPS);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SWMG_GetLateralAccelerationPerSecond',
        [],
        '// 521: Returns the minigame lateral acceleration/sec value\r\nfloat SWMG_GetLateralAccelerationPerSecond();',
        '// 521: Returns the minigame lateral acceleration/sec value\r\nfloat SWMG_GetLateralAccelerationPerSecond();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetCurrentAction',
        [ScriptParam(DataType.OBJECT, 'oObject', 0), ],
        '// 522: Get the current action (ACTION_*) that oObject is executing.\r\nint GetCurrentAction(object oObject = OBJECT_SELF);',
        '// 522: Get the current action (ACTION_*) that oObject is executing.\r\nint GetCurrentAction(object oObject = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetDifficultyModifier',
        [],
        '// 523:\r\nfloat GetDifficultyModifier();',
        '// 523:\r\nfloat GetDifficultyModifier();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetAppearanceType',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        "// 524: Returns the appearance type of oCreature (0 if creature doesn't exist)\r\n// - oCreature\r\nint GetAppearanceType(object oCreature);",
        "// 524: Returns the appearance type of oCreature (0 if creature doesn't exist)\r\n// - oCreature\r\nint GetAppearanceType(object oCreature);"
    ),
    ScriptFunction(
        DataType.VOID,
        'FloatingTextStrRefOnCreature',
        [ScriptParam(DataType.INT, 'nStrRefToDisplay', None), ScriptParam(DataType.OBJECT, 'oCreatureToFloatAbove', None), ScriptParam(DataType.INT, 'bBroadcastToFaction', 1), ],
        '// 525: Display floaty text above the specified creature.\r\n// The text will also appear in the chat buffer of each player that receives the\r\n// floaty text.\r\n// - nStrRefToDisplay: String ref (therefore text is translated)\r\n// - oCreatureToFloatAbove\r\n// - bBroadcastToFaction: If this is TRUE then only creatures in the same faction\r\n//   as oCreatureToFloatAbove\r\n//   will see the floaty text, and only if they are within range (30 metres).\r\nvoid FloatingTextStrRefOnCreature(int nStrRefToDisplay, object oCreatureToFloatAbove, int bBroadcastToFaction = TRUE);',
        '// 525: Display floaty text above the specified creature.\r\n// The text will also appear in the chat buffer of each player that receives the\r\n// floaty text.\r\n// - nStrRefToDisplay: String ref (therefore text is translated)\r\n// - oCreatureToFloatAbove\r\n// - bBroadcastToFaction: If this is TRUE then only creatures in the same faction\r\n//   as oCreatureToFloatAbove\r\n//   will see the floaty text, and only if they are within range (30 metres).\r\nvoid FloatingTextStrRefOnCreature(int nStrRefToDisplay, object oCreatureToFloatAbove, int bBroadcastToFaction = TRUE);'
    ),
    ScriptFunction(
        DataType.VOID,
        'FloatingTextStringOnCreature',
        [ScriptParam(DataType.STRING, 'sStringToDisplay', None), ScriptParam(DataType.OBJECT, 'oCreatureToFloatAbove', None), ScriptParam(DataType.INT, 'bBroadcastToFaction', 1), ],
        '// 526: Display floaty text above the specified creature.\r\n// The text will also appear in the chat buffer of each player that receives the\r\n// floaty text.\r\n// - sStringToDisplay: String\r\n// - oCreatureToFloatAbove\r\n// - bBroadcastToFaction: If this is TRUE then only creatures in the same faction\r\n//   as oCreatureToFloatAbove\r\n//   will see the floaty text, and only if they are within range (30 metres).\r\nvoid FloatingTextStringOnCreature(string sStringToDisplay, object oCreatureToFloatAbove, int bBroadcastToFaction = TRUE);',
        '// 526: Display floaty text above the specified creature.\r\n// The text will also appear in the chat buffer of each player that receives the\r\n// floaty text.\r\n// - sStringToDisplay: String\r\n// - oCreatureToFloatAbove\r\n// - bBroadcastToFaction: If this is TRUE then only creatures in the same faction\r\n//   as oCreatureToFloatAbove\r\n//   will see the floaty text, and only if they are within range (30 metres).\r\nvoid FloatingTextStringOnCreature(string sStringToDisplay, object oCreatureToFloatAbove, int bBroadcastToFaction = TRUE);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTrapDisarmable',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ],
        '// 527: - oTrapObject: a placeable, door or trigger\r\n// * Returns TRUE if oTrapObject is disarmable.\r\nint GetTrapDisarmable(object oTrapObject);',
        '// 527: - oTrapObject: a placeable, door or trigger\r\n// * Returns TRUE if oTrapObject is disarmable.\r\nint GetTrapDisarmable(object oTrapObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTrapDetectable',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ],
        '// 528: - oTrapObject: a placeable, door or trigger\r\n// * Returns TRUE if oTrapObject is detectable.\r\nint GetTrapDetectable(object oTrapObject);',
        '// 528: - oTrapObject: a placeable, door or trigger\r\n// * Returns TRUE if oTrapObject is detectable.\r\nint GetTrapDetectable(object oTrapObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTrapDetectedBy',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 529: - oTrapObject: a placeable, door or trigger\r\n// - oCreature\r\n// * Returns TRUE if oCreature has detected oTrapObject\r\nint GetTrapDetectedBy(object oTrapObject, object oCreature);',
        '// 529: - oTrapObject: a placeable, door or trigger\r\n// - oCreature\r\n// * Returns TRUE if oCreature has detected oTrapObject\r\nint GetTrapDetectedBy(object oTrapObject, object oCreature);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTrapFlagged',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ],
        '// 530: - oTrapObject: a placeable, door or trigger\r\n// * Returns TRUE if oTrapObject has been flagged as visible to all creatures.\r\nint GetTrapFlagged(object oTrapObject);',
        '// 530: - oTrapObject: a placeable, door or trigger\r\n// * Returns TRUE if oTrapObject has been flagged as visible to all creatures.\r\nint GetTrapFlagged(object oTrapObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTrapBaseType',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ],
        '// 531: Get the trap base type (TRAP_BASE_TYPE_*) of oTrapObject.\r\n// - oTrapObject: a placeable, door or trigger\r\nint GetTrapBaseType(object oTrapObject);',
        '// 531: Get the trap base type (TRAP_BASE_TYPE_*) of oTrapObject.\r\n// - oTrapObject: a placeable, door or trigger\r\nint GetTrapBaseType(object oTrapObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTrapOneShot',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ],
        '// 532: - oTrapObject: a placeable, door or trigger\r\n// * Returns TRUE if oTrapObject is one-shot (i.e. it does not reset itself\r\n//   after firing.\r\nint GetTrapOneShot(object oTrapObject);',
        '// 532: - oTrapObject: a placeable, door or trigger\r\n// * Returns TRUE if oTrapObject is one-shot (i.e. it does not reset itself\r\n//   after firing.\r\nint GetTrapOneShot(object oTrapObject);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetTrapCreator',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ],
        '// 533: Get the creator of oTrapObject, the creature that set the trap.\r\n// - oTrapObject: a placeable, door or trigger\r\n// * Returns OBJECT_INVALID if oTrapObject was created in the toolset.\r\nobject GetTrapCreator(object oTrapObject);',
        '// 533: Get the creator of oTrapObject, the creature that set the trap.\r\n// - oTrapObject: a placeable, door or trigger\r\n// * Returns OBJECT_INVALID if oTrapObject was created in the toolset.\r\nobject GetTrapCreator(object oTrapObject);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetTrapKeyTag',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ],
        '// 534: Get the tag of the key that will disarm oTrapObject.\r\n// - oTrapObject: a placeable, door or trigger\r\nstring GetTrapKeyTag(object oTrapObject);',
        '// 534: Get the tag of the key that will disarm oTrapObject.\r\n// - oTrapObject: a placeable, door or trigger\r\nstring GetTrapKeyTag(object oTrapObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTrapDisarmDC',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ],
        '// 535: Get the DC for disarming oTrapObject.\r\n// - oTrapObject: a placeable, door or trigger\r\nint GetTrapDisarmDC(object oTrapObject);',
        '// 535: Get the DC for disarming oTrapObject.\r\n// - oTrapObject: a placeable, door or trigger\r\nint GetTrapDisarmDC(object oTrapObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTrapDetectDC',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ],
        '// 536: Get the DC for detecting oTrapObject.\r\n// - oTrapObject: a placeable, door or trigger\r\nint GetTrapDetectDC(object oTrapObject);',
        '// 536: Get the DC for detecting oTrapObject.\r\n// - oTrapObject: a placeable, door or trigger\r\nint GetTrapDetectDC(object oTrapObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLockKeyRequired',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 537: * Returns TRUE if a specific key is required to open the lock on oObject.\r\nint GetLockKeyRequired(object oObject);',
        '// 537: * Returns TRUE if a specific key is required to open the lock on oObject.\r\nint GetLockKeyRequired(object oObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLockKeyTag',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 538: Get the tag of the key that will open the lock on oObject.\r\nint GetLockKeyTag(object oObject);',
        '// 538: Get the tag of the key that will open the lock on oObject.\r\nint GetLockKeyTag(object oObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLockLockable',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 539: * Returns TRUE if the lock on oObject is lockable.\r\nint GetLockLockable(object oObject);',
        '// 539: * Returns TRUE if the lock on oObject is lockable.\r\nint GetLockLockable(object oObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLockUnlockDC',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 540: Get the DC for unlocking oObject.\r\nint GetLockUnlockDC(object oObject);',
        '// 540: Get the DC for unlocking oObject.\r\nint GetLockUnlockDC(object oObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLockLockDC',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 541: Get the DC for locking oObject.\r\nint GetLockLockDC(object oObject);',
        '// 541: Get the DC for locking oObject.\r\nint GetLockLockDC(object oObject);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetPCLevellingUp',
        [],
        '// 542: Get the last PC that levelled up.\r\nobject GetPCLevellingUp();',
        '// 542: Get the last PC that levelled up.\r\nobject GetPCLevellingUp();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetHasFeatEffect',
        [ScriptParam(DataType.INT, 'nFeat', None), ScriptParam(DataType.OBJECT, 'oObject', 0), ],
        '// 543: - nFeat: FEAT_*\r\n// - oObject\r\n// * Returns TRUE if oObject has effects on it originating from nFeat.\r\nint GetHasFeatEffect(int nFeat, object oObject = OBJECT_SELF);',
        '// 543: - nFeat: FEAT_*\r\n// - oObject\r\n// * Returns TRUE if oObject has effects on it originating from nFeat.\r\nint GetHasFeatEffect(int nFeat, object oObject = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetPlaceableIllumination',
        [ScriptParam(DataType.OBJECT, 'oPlaceable', 0), ScriptParam(DataType.INT, 'bIlluminate', 1), ],
        "// 544: Set the status of the illumination for oPlaceable.\r\n// - oPlaceable\r\n// - bIlluminate: if this is TRUE, oPlaceable's illumination will be turned on.\r\n//   If this is FALSE, oPlaceable's illumination will be turned off.\r\n// Note: You must call RecomputeStaticLighting() after calling this function in\r\n// order for the changes to occur visually for the players.\r\n// SetPlaceableIllumination() buffers the illumination changes, which are then\r\n// sent out to the players once RecomputeStaticLighting() is called.  As such,\r\n// it is best to call SetPlaceableIllumination() for all the placeables you wish\r\n// to set the illumination on, and then call RecomputeStaticLighting() once after\r\n// all the placeable illumination has been set.\r\n// * If oPlaceable is not a placeable object, or oPlaceable is a placeable that\r\n//   doesn't have a light, nothing will happen.\r\nvoid SetPlaceableIllumination(object oPlaceable = OBJECT_SELF, int bIlluminate = TRUE);",
        "// 544: Set the status of the illumination for oPlaceable.\r\n// - oPlaceable\r\n// - bIlluminate: if this is TRUE, oPlaceable's illumination will be turned on.\r\n//   If this is FALSE, oPlaceable's illumination will be turned off.\r\n// Note: You must call RecomputeStaticLighting() after calling this function in\r\n// order for the changes to occur visually for the players.\r\n// SetPlaceableIllumination() buffers the illumination changes, which are then\r\n// sent out to the players once RecomputeStaticLighting() is called.  As such,\r\n// it is best to call SetPlaceableIllumination() for all the placeables you wish\r\n// to set the illumination on, and then call RecomputeStaticLighting() once after\r\n// all the placeable illumination has been set.\r\n// * If oPlaceable is not a placeable object, or oPlaceable is a placeable that\r\n//   doesn't have a light, nothing will happen.\r\nvoid SetPlaceableIllumination(object oPlaceable = OBJECT_SELF, int bIlluminate = TRUE);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetPlaceableIllumination',
        [ScriptParam(DataType.OBJECT, 'oPlaceable', 0), ],
        '// 545: * Returns TRUE if the illumination for oPlaceable is on\r\nint GetPlaceableIllumination(object oPlaceable = OBJECT_SELF);',
        '// 545: * Returns TRUE if the illumination for oPlaceable is on\r\nint GetPlaceableIllumination(object oPlaceable = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsPlaceableObjectActionPossible',
        [ScriptParam(DataType.OBJECT, 'oPlaceable', None), ScriptParam(DataType.INT, 'nPlaceableAction', None), ],
        '// 546: - oPlaceable\r\n// - nPlaceableAction: PLACEABLE_ACTION_*\r\n// * Returns TRUE if nPlacebleAction is valid for oPlaceable.\r\nint GetIsPlaceableObjectActionPossible(object oPlaceable, int nPlaceableAction);',
        '// 546: - oPlaceable\r\n// - nPlaceableAction: PLACEABLE_ACTION_*\r\n// * Returns TRUE if nPlacebleAction is valid for oPlaceable.\r\nint GetIsPlaceableObjectActionPossible(object oPlaceable, int nPlaceableAction);'
    ),
    ScriptFunction(
        DataType.VOID,
        'DoPlaceableObjectAction',
        [ScriptParam(DataType.OBJECT, 'oPlaceable', None), ScriptParam(DataType.INT, 'nPlaceableAction', None), ],
        '// 547: The caller performs nPlaceableAction on oPlaceable.\r\n// - oPlaceable\r\n// - nPlaceableAction: PLACEABLE_ACTION_*\r\nvoid DoPlaceableObjectAction(object oPlaceable, int nPlaceableAction);',
        '// 547: The caller performs nPlaceableAction on oPlaceable.\r\n// - oPlaceable\r\n// - nPlaceableAction: PLACEABLE_ACTION_*\r\nvoid DoPlaceableObjectAction(object oPlaceable, int nPlaceableAction);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFirstPC',
        [],
        '// 548: Get the first PC in the player list.\r\n// This resets the position in the player list for GetNextPC().\r\nobject GetFirstPC();',
        '// 548: Get the first PC in the player list.\r\n// This resets the position in the player list for GetNextPC().\r\nobject GetFirstPC();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNextPC',
        [],
        '// 549: Get the next PC in the player list.\r\n// This picks up where the last GetFirstPC() or GetNextPC() left off.\r\nobject GetNextPC();',
        '// 549: Get the next PC in the player list.\r\n// This picks up where the last GetFirstPC() or GetNextPC() left off.\r\nobject GetNextPC();'
    ),
    ScriptFunction(
        DataType.INT,
        'SetTrapDetectedBy',
        [ScriptParam(DataType.OBJECT, 'oTrap', None), ScriptParam(DataType.OBJECT, 'oDetector', None), ],
        '// 550: Set oDetector to have detected oTrap.\r\nint SetTrapDetectedBy(object oTrap, object oDetector);',
        '// 550: Set oDetector to have detected oTrap.\r\nint SetTrapDetectedBy(object oTrap, object oDetector);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsTrapped',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 551: Note: Only placeables, doors and triggers can be trapped.\r\n// * Returns TRUE if oObject is trapped.\r\nint GetIsTrapped(object oObject);',
        '// 551: Note: Only placeables, doors and triggers can be trapped.\r\n// * Returns TRUE if oObject is trapped.\r\nint GetIsTrapped(object oObject);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'SetEffectIcon',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ScriptParam(DataType.INT, 'nIcon', None), ],
        '// 552: SetEffectIcon\r\n// This will link the specified effect icon to the specified effect.  The\r\n// effect returned will contain the link to the effect icon and applying this\r\n// effect will cause an effect icon to appear on the portrait/charsheet gui.\r\n// eEffect: The effect which should cause the effect icon to appear.\r\n// nIcon: Index into effecticon.2da of the effect icon to use.\r\neffect SetEffectIcon( effect eEffect, int nIcon );',
        '// 552: SetEffectIcon\r\n// This will link the specified effect icon to the specified effect.  The\r\n// effect returned will contain the link to the effect icon and applying this\r\n// effect will cause an effect icon to appear on the portrait/charsheet gui.\r\n// eEffect: The effect which should cause the effect icon to appear.\r\n// nIcon: Index into effecticon.2da of the effect icon to use.\r\neffect SetEffectIcon( effect eEffect, int nIcon );'
    ),
    ScriptFunction(
        DataType.VOID,
        'FaceObjectAwayFromObject',
        [ScriptParam(DataType.OBJECT, 'oFacer', None), ScriptParam(DataType.OBJECT, 'oObjectToFaceAwayFrom', None), ],
        '// 553: FaceObjectAwayFromObject\r\n// This will cause the object oFacer to face away from oObjectToFaceAwayFrom.\r\n// The objects must be in the same area for this to work.\r\nvoid FaceObjectAwayFromObject( object oFacer, object oObjectToFaceAwayFrom );',
        '// 553: FaceObjectAwayFromObject\r\n// This will cause the object oFacer to face away from oObjectToFaceAwayFrom.\r\n// The objects must be in the same area for this to work.\r\nvoid FaceObjectAwayFromObject( object oFacer, object oObjectToFaceAwayFrom );'
    ),
    ScriptFunction(
        DataType.VOID,
        'PopUpDeathGUIPanel',
        [ScriptParam(DataType.OBJECT, 'oPC', None), ScriptParam(DataType.INT, 'bRespawnButtonEnabled', 1), ScriptParam(DataType.INT, 'bWaitForHelpButtonEnabled', 1), ScriptParam(DataType.INT, 'nHelpStringReference', 0), ScriptParam(DataType.STRING, 'sHelpString', ''), ],
        '// 554: Spawn in the Death GUI.\r\n// The default (as defined by BioWare) can be spawned in by PopUpGUIPanel, but\r\n// if you want to turn off the "Respawn" or "Wait for Help" buttons, this is the\r\n// function to use.\r\n// - oPC\r\n// - bRespawnButtonEnabled: if this is TRUE, the "Respawn" button will be enabled\r\n//   on the Death GUI.\r\n// - bWaitForHelpButtonEnabled: if this is TRUE, the "Wait For Help" button will\r\n//   be enabled on the Death GUI.\r\n// - nHelpStringReference\r\n// - sHelpString\r\nvoid PopUpDeathGUIPanel(object oPC, int bRespawnButtonEnabled = TRUE, int bWaitForHelpButtonEnabled = TRUE, int nHelpStringReference = 0, string sHelpString = "");',
        '// 554: Spawn in the Death GUI.\r\n// The default (as defined by BioWare) can be spawned in by PopUpGUIPanel, but\r\n// if you want to turn off the "Respawn" or "Wait for Help" buttons, this is the\r\n// function to use.\r\n// - oPC\r\n// - bRespawnButtonEnabled: if this is TRUE, the "Respawn" button will be enabled\r\n//   on the Death GUI.\r\n// - bWaitForHelpButtonEnabled: if this is TRUE, the "Wait For Help" button will\r\n//   be enabled on the Death GUI.\r\n// - nHelpStringReference\r\n// - sHelpString\r\nvoid PopUpDeathGUIPanel(object oPC, int bRespawnButtonEnabled = TRUE, int bWaitForHelpButtonEnabled = TRUE, int nHelpStringReference = 0, string sHelpString = "");'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetTrapDisabled',
        [ScriptParam(DataType.OBJECT, 'oTrap', None), ],
        '// 555: Disable oTrap.\r\n// - oTrap: a placeable, door or trigger.\r\nvoid SetTrapDisabled(object oTrap);',
        '// 555: Disable oTrap.\r\n// - oTrap: a placeable, door or trigger.\r\nvoid SetTrapDisabled(object oTrap);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastHostileActor',
        [ScriptParam(DataType.OBJECT, 'oVictim', 0), ],
        '// 556: Get the last object that was sent as a GetLastAttacker(), GetLastDamager(),\r\n// GetLastSpellCaster() (for a hostile spell), or GetLastDisturbed() (when a\r\n// creature is pickpocketed).\r\n// Note: Return values may only ever be:\r\n// 1) A Creature\r\n// 2) Plot Characters will never have this value set\r\n// 3) Area of Effect Objects will return the AOE creator if they are registered\r\n//    as this value, otherwise they will return INVALID_OBJECT_ID\r\n// 4) Traps will not return the creature that set the trap.\r\n// 5) This value will never be overwritten by another non-creature object.\r\n// 6) This value will never be a dead/destroyed creature\r\nobject GetLastHostileActor(object oVictim = OBJECT_SELF);',
        '// 556: Get the last object that was sent as a GetLastAttacker(), GetLastDamager(),\r\n// GetLastSpellCaster() (for a hostile spell), or GetLastDisturbed() (when a\r\n// creature is pickpocketed).\r\n// Note: Return values may only ever be:\r\n// 1) A Creature\r\n// 2) Plot Characters will never have this value set\r\n// 3) Area of Effect Objects will return the AOE creator if they are registered\r\n//    as this value, otherwise they will return INVALID_OBJECT_ID\r\n// 4) Traps will not return the creature that set the trap.\r\n// 5) This value will never be overwritten by another non-creature object.\r\n// 6) This value will never be a dead/destroyed creature\r\nobject GetLastHostileActor(object oVictim = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ExportAllCharacters',
        [],
        '// 557: Force all the characters of the players who are currently in the game to\r\n// be exported to their respective directories i.e. LocalVault/ServerVault/ etc.\r\nvoid ExportAllCharacters();',
        '// 557: Force all the characters of the players who are currently in the game to\r\n// be exported to their respective directories i.e. LocalVault/ServerVault/ etc.\r\nvoid ExportAllCharacters();'
    ),
    ScriptFunction(
        DataType.INT,
        'MusicBackgroundGetDayTrack',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ],
        '// 558: Get the Day Track for oArea.\r\nint MusicBackgroundGetDayTrack(object oArea);',
        '// 558: Get the Day Track for oArea.\r\nint MusicBackgroundGetDayTrack(object oArea);'
    ),
    ScriptFunction(
        DataType.INT,
        'MusicBackgroundGetNightTrack',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ],
        '// 559: Get the Night Track for oArea.\r\nint MusicBackgroundGetNightTrack(object oArea);',
        '// 559: Get the Night Track for oArea.\r\nint MusicBackgroundGetNightTrack(object oArea);'
    ),
    ScriptFunction(
        DataType.VOID,
        'WriteTimestampedLogEntry',
        [ScriptParam(DataType.STRING, 'sLogEntry', None), ],
        '// 560: Write sLogEntry as a timestamped entry into the log file\r\nvoid WriteTimestampedLogEntry(string sLogEntry);',
        '// 560: Write sLogEntry as a timestamped entry into the log file\r\nvoid WriteTimestampedLogEntry(string sLogEntry);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetModuleName',
        [],
        "// 561: Get the module's name in the language of the server that's running it.\r\n// * If there is no entry for the language of the server, it will return an\r\n//   empty string\r\nstring GetModuleName();",
        "// 561: Get the module's name in the language of the server that's running it.\r\n// * If there is no entry for the language of the server, it will return an\r\n//   empty string\r\nstring GetModuleName();"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFactionLeader',
        [ScriptParam(DataType.OBJECT, 'oMemberOfFaction', None), ],
        '// 562: Get the leader of the faction of which oMemberOfFaction is a member.\r\n// * Returns OBJECT_INVALID if oMemberOfFaction is not a valid creature.\r\nobject GetFactionLeader(object oMemberOfFaction);',
        '// 562: Get the leader of the faction of which oMemberOfFaction is a member.\r\n// * Returns OBJECT_INVALID if oMemberOfFaction is not a valid creature.\r\nobject GetFactionLeader(object oMemberOfFaction);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetSpeedBlurEffect',
        [ScriptParam(DataType.INT, 'bEnabled', None), ScriptParam(DataType.FLOAT, 'fRatio', 0.75), ],
        '// 563: Turns on or off the speed blur effect in rendered scenes.\r\n// bEnabled: Set TRUE to turn it on, FALSE to turn it off.\r\n// fRatio: Sets the frame accumulation ratio.\r\nvoid SWMG_SetSpeedBlurEffect( int bEnabled, float fRatio = 0.75f );',
        '// 563: Turns on or off the speed blur effect in rendered scenes.\r\n// bEnabled: Set TRUE to turn it on, FALSE to turn it off.\r\n// fRatio: Sets the frame accumulation ratio.\r\nvoid SWMG_SetSpeedBlurEffect( int bEnabled, float fRatio = 0.75f );'
    ),
    ScriptFunction(
        DataType.VOID,
        'EndGame',
        [ScriptParam(DataType.INT, 'nShowEndGameGui', 1), ],
        '// 564: Immediately ends the currently running game and returns to the start screen.\r\n// nShowEndGameGui: Set TRUE to display the death gui.\r\nvoid EndGame( int nShowEndGameGui = TRUE );',
        '// 564: Immediately ends the currently running game and returns to the start screen.\r\n// nShowEndGameGui: Set TRUE to display the death gui.\r\nvoid EndGame( int nShowEndGameGui = TRUE );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetRunScriptVar',
        [],
        '// 565: Get a variable passed when calling console debug runscript\r\nint GetRunScriptVar();',
        '// 565: Get a variable passed when calling console debug runscript\r\nint GetRunScriptVar();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetCreatureMovmentType',
        [ScriptParam(DataType.OBJECT, 'oidCreature', None), ],
        '// 566: This function returns a value that matches one of the MOVEMENT_SPEED_... constants\r\n//      if the OID passed in is not found or not a creature then it will return\r\n//  MOVEMENT_SPEED_IMMOBILE.\r\nint GetCreatureMovmentType(object oidCreature);',
        '// 566: This function returns a value that matches one of the MOVEMENT_SPEED_... constants\r\n//      if the OID passed in is not found or not a creature then it will return\r\n//  MOVEMENT_SPEED_IMMOBILE.\r\nint GetCreatureMovmentType(object oidCreature);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AmbientSoundSetDayVolume',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.INT, 'nVolume', None), ],
        '// 567: Set the ambient day volume for oArea to nVolume.\r\n// - oArea\r\n// - nVolume: 0 - 100\r\nvoid AmbientSoundSetDayVolume(object oArea, int nVolume);',
        '// 567: Set the ambient day volume for oArea to nVolume.\r\n// - oArea\r\n// - nVolume: 0 - 100\r\nvoid AmbientSoundSetDayVolume(object oArea, int nVolume);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AmbientSoundSetNightVolume',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.INT, 'nVolume', None), ],
        '// 568: Set the ambient night volume for oArea to nVolume.\r\n// - oArea\r\n// - nVolume: 0 - 100\r\nvoid AmbientSoundSetNightVolume(object oArea, int nVolume);',
        '// 568: Set the ambient night volume for oArea to nVolume.\r\n// - oArea\r\n// - nVolume: 0 - 100\r\nvoid AmbientSoundSetNightVolume(object oArea, int nVolume);'
    ),
    ScriptFunction(
        DataType.INT,
        'MusicBackgroundGetBattleTrack',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ],
        '// 569: Get the Battle Track for oArea.\r\nint MusicBackgroundGetBattleTrack(object oArea);',
        '// 569: Get the Battle Track for oArea.\r\nint MusicBackgroundGetBattleTrack(object oArea);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetHasInventory',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 570: Determine whether oObject has an inventory.\r\n// * Returns TRUE for creatures and stores, and checks to see if an item or placeable object is a container.\r\n// * Returns FALSE for all other object types.\r\nint GetHasInventory(object oObject);',
        '// 570: Determine whether oObject has an inventory.\r\n// * Returns TRUE for creatures and stores, and checks to see if an item or placeable object is a container.\r\n// * Returns FALSE for all other object types.\r\nint GetHasInventory(object oObject);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetStrRefSoundDuration',
        [ScriptParam(DataType.INT, 'nStrRef', None), ],
        '// 571: Get the duration (in seconds) of the sound attached to nStrRef\r\n// * Returns 0.0f if no duration is stored or if no sound is attached\r\nfloat GetStrRefSoundDuration(int nStrRef);',
        '// 571: Get the duration (in seconds) of the sound attached to nStrRef\r\n// * Returns 0.0f if no duration is stored or if no sound is attached\r\nfloat GetStrRefSoundDuration(int nStrRef);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AddToParty',
        [ScriptParam(DataType.OBJECT, 'oPC', None), ScriptParam(DataType.OBJECT, 'oPartyLeader', None), ],
        "// 572: Add oPC to oPartyLeader's party.  This will only work on two PCs.\r\n// - oPC: player to add to a party\r\n// - oPartyLeader: player already in the party\r\nvoid AddToParty(object oPC, object oPartyLeader);",
        "// 572: Add oPC to oPartyLeader's party.  This will only work on two PCs.\r\n// - oPC: player to add to a party\r\n// - oPartyLeader: player already in the party\r\nvoid AddToParty(object oPC, object oPartyLeader);"
    ),
    ScriptFunction(
        DataType.VOID,
        'RemoveFromParty',
        [ScriptParam(DataType.OBJECT, 'oPC', None), ],
        "// 573: Remove oPC from their current party. This will only work on a PC.\r\n// - oPC: removes this player from whatever party they're currently in.\r\nvoid RemoveFromParty(object oPC);",
        "// 573: Remove oPC from their current party. This will only work on a PC.\r\n// - oPC: removes this player from whatever party they're currently in.\r\nvoid RemoveFromParty(object oPC);"
    ),
    ScriptFunction(
        DataType.INT,
        'AddPartyMember',
        [ScriptParam(DataType.INT, 'nNPC', None), ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 574: Adds a creature to the party\r\n// Returns whether the addition was successful\r\n// AddPartyMember\r\nint AddPartyMember(int nNPC, object oCreature);',
        '// 574: Adds a creature to the party\r\n// Returns whether the addition was successful\r\n// AddPartyMember\r\nint AddPartyMember(int nNPC, object oCreature);'
    ),
    ScriptFunction(
        DataType.INT,
        'RemovePartyMember',
        [ScriptParam(DataType.INT, 'nNPC', None), ],
        '// 575: Removes a creature from the party\r\n// Returns whether the removal was syccessful\r\n// RemovePartyMember\r\nint RemovePartyMember(int nNPC);',
        '// 575: Removes a creature from the party\r\n// Returns whether the removal was syccessful\r\n// RemovePartyMember\r\nint RemovePartyMember(int nNPC);'
    ),
    ScriptFunction(
        DataType.INT,
        'IsObjectPartyMember',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 576: Returns whether a specified creature is a party member\r\n// IsObjectPartyMember\r\nint IsObjectPartyMember(object oCreature);',
        '// 576: Returns whether a specified creature is a party member\r\n// IsObjectPartyMember\r\nint IsObjectPartyMember(object oCreature);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetPartyMemberByIndex',
        [ScriptParam(DataType.INT, 'nIndex', None), ],
        '// 577: Returns the party member at a given index in the party.\r\n// The order of members in the party can vary based on\r\n// who the current leader is (member 0 is always the current\r\n// party leader).\r\n// GetPartyMemberByIndex\r\nobject GetPartyMemberByIndex(int nIndex);',
        '// 577: Returns the party member at a given index in the party.\r\n// The order of members in the party can vary based on\r\n// who the current leader is (member 0 is always the current\r\n// party leader).\r\n// GetPartyMemberByIndex\r\nobject GetPartyMemberByIndex(int nIndex);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetGlobalBoolean',
        [ScriptParam(DataType.STRING, 'sIdentifier', None), ],
        '// 578: GetGlobalBoolean\r\n// This function returns the value of a global boolean (TRUE or FALSE) scripting variable.\r\nint GetGlobalBoolean( string sIdentifier );',
        '// 578: GetGlobalBoolean\r\n// This function returns the value of a global boolean (TRUE or FALSE) scripting variable.\r\nint GetGlobalBoolean( string sIdentifier );'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetGlobalBoolean',
        [ScriptParam(DataType.STRING, 'sIdentifier', None), ScriptParam(DataType.INT, 'nValue', None), ],
        '// 579: SetGlobalBoolean\r\n// This function sets the value of a global boolean (TRUE or FALSE) scripting variable.\r\nvoid SetGlobalBoolean( string sIdentifier, int nValue );',
        '// 579: SetGlobalBoolean\r\n// This function sets the value of a global boolean (TRUE or FALSE) scripting variable.\r\nvoid SetGlobalBoolean( string sIdentifier, int nValue );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetGlobalNumber',
        [ScriptParam(DataType.STRING, 'sIdentifier', None), ],
        '// 580: GetGlobalNumber\r\n// This function returns the value of a global number (-128 to +127) scripting variable.\r\nint GetGlobalNumber( string sIdentifier );',
        '// 580: GetGlobalNumber\r\n// This function returns the value of a global number (-128 to +127) scripting variable.\r\nint GetGlobalNumber( string sIdentifier );'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetGlobalNumber',
        [ScriptParam(DataType.STRING, 'sIdentifier', None), ScriptParam(DataType.INT, 'nValue', None), ],
        '// 581: SetGlobalNumber\r\n// This function sets the value of a global number (-128 to +127) scripting variable.\r\nvoid SetGlobalNumber( string sIdentifier, int nValue );',
        '// 581: SetGlobalNumber\r\n// This function sets the value of a global number (-128 to +127) scripting variable.\r\nvoid SetGlobalNumber( string sIdentifier, int nValue );'
    ),
    ScriptFunction(
        DataType.VOID,
        'AurPostString',
        [ScriptParam(DataType.STRING, 'sString', None), ScriptParam(DataType.INT, 'nX', None), ScriptParam(DataType.INT, 'nY', None), ScriptParam(DataType.FLOAT, 'fLife', None), ],
        '// 582. AurPostString\r\nvoid AurPostString(string sString, int nX, int nY, float fLife);',
        '// 582. AurPostString\r\nvoid AurPostString(string sString, int nX, int nY, float fLife);'
    ),
    ScriptFunction(
        DataType.STRING,
        'SWMG_GetLastEvent',
        [],
        '// 583: OnAnimKey\r\n// get the event and the name of the model on which the event happened\r\n// SWMG_GetLastEvent\r\nstring SWMG_GetLastEvent();',
        '// 583: OnAnimKey\r\n// get the event and the name of the model on which the event happened\r\n// SWMG_GetLastEvent\r\nstring SWMG_GetLastEvent();'
    ),
    ScriptFunction(
        DataType.STRING,
        'SWMG_GetLastEventModelName',
        [],
        '// 584: SWMG_GetLastEventModelName\r\nstring SWMG_GetLastEventModelName();',
        '// 584: SWMG_GetLastEventModelName\r\nstring SWMG_GetLastEventModelName();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'SWMG_GetObjectByName',
        [ScriptParam(DataType.STRING, 'sName', None), ],
        '// 585: gets an object by its name (duh!)\r\n// SWMG_GetObjectByName\r\nobject SWMG_GetObjectByName(string sName);',
        '// 585: gets an object by its name (duh!)\r\n// SWMG_GetObjectByName\r\nobject SWMG_GetObjectByName(string sName);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_PlayAnimation',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.STRING, 'sAnimName', None), ScriptParam(DataType.INT, 'bLooping', 1), ScriptParam(DataType.INT, 'bQueue', 0), ScriptParam(DataType.INT, 'bOverlay', 0), ],
        '// 586: plays an animation on an object\r\n// SWMG_PlayAnimation\r\nvoid SWMG_PlayAnimation(object oObject, string sAnimName, int bLooping = 1, int bQueue = 0, int bOverlay = 0);',
        '// 586: plays an animation on an object\r\n// SWMG_PlayAnimation\r\nvoid SWMG_PlayAnimation(object oObject, string sAnimName, int bLooping = 1, int bQueue = 0, int bOverlay = 0);'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetLastBulletHitDamage',
        [],
        '// 587: OnHitBullet\r\n// get the damage, the target type (see TARGETflags), and the shooter\r\n// SWMG_GetLastBulletHitDamage\r\nint SWMG_GetLastBulletHitDamage();',
        '// 587: OnHitBullet\r\n// get the damage, the target type (see TARGETflags), and the shooter\r\n// SWMG_GetLastBulletHitDamage\r\nint SWMG_GetLastBulletHitDamage();'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetLastBulletHitTarget',
        [],
        '// 588: SWMG_GetLastBulletHitTarget\r\nint SWMG_GetLastBulletHitTarget();',
        '// 588: SWMG_GetLastBulletHitTarget\r\nint SWMG_GetLastBulletHitTarget();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'SWMG_GetLastBulletHitShooter',
        [],
        '// 589: SWMG_GetLastBulletHitShooter\r\nobject SWMG_GetLastBulletHitShooter();',
        '// 589: SWMG_GetLastBulletHitShooter\r\nobject SWMG_GetLastBulletHitShooter();'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_AdjustFollowerHitPoints',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nHP', None), ScriptParam(DataType.INT, 'nAbsolute', 0), ],
        '// 590: adjusts a followers hit points, can specify the absolute value to set to\r\n// SWMG_AdjustFollowerHitPoints\r\nint SWMG_AdjustFollowerHitPoints(object oFollower, int nHP, int nAbsolute = 0);',
        '// 590: adjusts a followers hit points, can specify the absolute value to set to\r\n// SWMG_AdjustFollowerHitPoints\r\nint SWMG_AdjustFollowerHitPoints(object oFollower, int nHP, int nAbsolute = 0);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_OnBulletHit',
        [],
        '// 591: the default implementation of OnBulletHit\r\n// SWMG_OnBulletHit\r\nvoid SWMG_OnBulletHit();',
        '// 591: the default implementation of OnBulletHit\r\n// SWMG_OnBulletHit\r\nvoid SWMG_OnBulletHit();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_OnObstacleHit',
        [],
        '// 592: the default implementation of OnObstacleHit\r\n// SWMG_OnObstacleHit\r\nvoid SWMG_OnObstacleHit();',
        '// 592: the default implementation of OnObstacleHit\r\n// SWMG_OnObstacleHit\r\nvoid SWMG_OnObstacleHit();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'SWMG_GetLastFollowerHit',
        [],
        '// 593: returns the last follower and obstacle hit\r\n// SWMG_GetLastFollowerHit\r\nobject SWMG_GetLastFollowerHit();',
        '// 593: returns the last follower and obstacle hit\r\n// SWMG_GetLastFollowerHit\r\nobject SWMG_GetLastFollowerHit();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'SWMG_GetLastObstacleHit',
        [],
        '// 594: SWMG_GetLastObstacleHit\r\nobject SWMG_GetLastObstacleHit();',
        '// 594: SWMG_GetLastObstacleHit\r\nobject SWMG_GetLastObstacleHit();'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetLastBulletFiredDamage',
        [],
        '// 595: gets information about the last bullet fired\r\n// SWMG_GetLastBulletFiredDamage\r\nint SWMG_GetLastBulletFiredDamage();',
        '// 595: gets information about the last bullet fired\r\n// SWMG_GetLastBulletFiredDamage\r\nint SWMG_GetLastBulletFiredDamage();'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetLastBulletFiredTarget',
        [],
        '// 596: SWMG_GetLastBulletFiredTarget\r\nint SWMG_GetLastBulletFiredTarget();',
        '// 596: SWMG_GetLastBulletFiredTarget\r\nint SWMG_GetLastBulletFiredTarget();'
    ),
    ScriptFunction(
        DataType.STRING,
        'SWMG_GetObjectName',
        [ScriptParam(DataType.OBJECT, 'oid', 0), ],
        '// 597: gets an objects name\r\n// SWMG_GetObjectName\r\nstring SWMG_GetObjectName(object oid = OBJECT_SELF);',
        '// 597: gets an objects name\r\n// SWMG_GetObjectName\r\nstring SWMG_GetObjectName(object oid = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_OnDeath',
        [],
        '// 598: the default implementation of OnDeath\r\n// SWMG_OnDeath\r\nvoid SWMG_OnDeath();',
        '// 598: the default implementation of OnDeath\r\n// SWMG_OnDeath\r\nvoid SWMG_OnDeath();'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_IsFollower',
        [ScriptParam(DataType.OBJECT, 'oid', 0), ],
        '// 599: a bunch of Is functions for your pleasure\r\n// SWMG_IsFollower\r\nint SWMG_IsFollower(object oid = OBJECT_SELF);',
        '// 599: a bunch of Is functions for your pleasure\r\n// SWMG_IsFollower\r\nint SWMG_IsFollower(object oid = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_IsPlayer',
        [ScriptParam(DataType.OBJECT, 'oid', 0), ],
        '// 600: SWMG_IsPlayer\r\nint SWMG_IsPlayer(object oid = OBJECT_SELF);',
        '// 600: SWMG_IsPlayer\r\nint SWMG_IsPlayer(object oid = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_IsEnemy',
        [ScriptParam(DataType.OBJECT, 'oid', 0), ],
        '// 601: SWMG_IsEnemy\r\nint SWMG_IsEnemy(object oid = OBJECT_SELF);',
        '// 601: SWMG_IsEnemy\r\nint SWMG_IsEnemy(object oid = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_IsTrigger',
        [ScriptParam(DataType.OBJECT, 'oid', 0), ],
        '// 602: SWMG_IsTrigger\r\nint SWMG_IsTrigger(object oid = OBJECT_SELF);',
        '// 602: SWMG_IsTrigger\r\nint SWMG_IsTrigger(object oid = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_IsObstacle',
        [ScriptParam(DataType.OBJECT, 'oid', 0), ],
        '// 603: SWMG_IsObstacle\r\nint SWMG_IsObstacle(object oid = OBJECT_SELF);',
        '// 603: SWMG_IsObstacle\r\nint SWMG_IsObstacle(object oid = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetFollowerHitPoints',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nHP', None), ],
        '// 604: SWMG_SetFollowerHitPoints\r\nvoid SWMG_SetFollowerHitPoints(object oFollower, int nHP);',
        '// 604: SWMG_SetFollowerHitPoints\r\nvoid SWMG_SetFollowerHitPoints(object oFollower, int nHP);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_OnDamage',
        [],
        '// 605: SWMG_OnDamage\r\nvoid SWMG_OnDamage();',
        '// 605: SWMG_OnDamage\r\nvoid SWMG_OnDamage();'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetLastHPChange',
        [],
        '// 606: SWMG_GetLastHPChange\r\nint SWMG_GetLastHPChange();',
        '// 606: SWMG_GetLastHPChange\r\nint SWMG_GetLastHPChange();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_RemoveAnimation',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.STRING, 'sAnimName', None), ],
        '// 607: SWMG_RemoveAnimation\r\nvoid SWMG_RemoveAnimation(object oObject, string sAnimName);',
        '// 607: SWMG_RemoveAnimation\r\nvoid SWMG_RemoveAnimation(object oObject, string sAnimName);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SWMG_GetCameraNearClip',
        [],
        '// 608: SWMG_GetCameraNearClip\r\nfloat SWMG_GetCameraNearClip();',
        '// 608: SWMG_GetCameraNearClip\r\nfloat SWMG_GetCameraNearClip();'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SWMG_GetCameraFarClip',
        [],
        '// 609: SWMG_GetCameraFarClip\r\nfloat SWMG_GetCameraFarClip();',
        '// 609: SWMG_GetCameraFarClip\r\nfloat SWMG_GetCameraFarClip();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetCameraClip',
        [ScriptParam(DataType.FLOAT, 'fNear', None), ScriptParam(DataType.FLOAT, 'fFar', None), ],
        '// 610: SWMG_SetCameraClip\r\nvoid SWMG_SetCameraClip(float fNear, float fFar);',
        '// 610: SWMG_SetCameraClip\r\nvoid SWMG_SetCameraClip(float fNear, float fFar);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'SWMG_GetPlayer',
        [],
        '// 611: SWMG_GetPlayer\r\nobject SWMG_GetPlayer();',
        '// 611: SWMG_GetPlayer\r\nobject SWMG_GetPlayer();'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetEnemyCount',
        [],
        '// 612: SWMG_GetEnemyCount\r\nint SWMG_GetEnemyCount();',
        '// 612: SWMG_GetEnemyCount\r\nint SWMG_GetEnemyCount();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'SWMG_GetEnemy',
        [ScriptParam(DataType.INT, 'nEntry', None), ],
        '// 613: SWMG_GetEnemy\r\nobject SWMG_GetEnemy(int nEntry);',
        '// 613: SWMG_GetEnemy\r\nobject SWMG_GetEnemy(int nEntry);'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetObstacleCount',
        [],
        '// 614: SWMG_GetObstacleCount\r\nint SWMG_GetObstacleCount();',
        '// 614: SWMG_GetObstacleCount\r\nint SWMG_GetObstacleCount();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'SWMG_GetObstacle',
        [ScriptParam(DataType.INT, 'nEntry', None), ],
        '// 615: SWMG_GetObstacle\r\nobject SWMG_GetObstacle(int nEntry);',
        '// 615: SWMG_GetObstacle\r\nobject SWMG_GetObstacle(int nEntry);'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetHitPoints',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ],
        '// 616: SWMG_GetHitPoints\r\nint SWMG_GetHitPoints(object oFollower);',
        '// 616: SWMG_GetHitPoints\r\nint SWMG_GetHitPoints(object oFollower);'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetMaxHitPoints',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ],
        '// 617: SWMG_GetMaxHitPoints\r\nint SWMG_GetMaxHitPoints(object oFollower);',
        '// 617: SWMG_GetMaxHitPoints\r\nint SWMG_GetMaxHitPoints(object oFollower);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetMaxHitPoints',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nMaxHP', None), ],
        '// 618: SWMG_SetMaxHitPoints\r\nvoid SWMG_SetMaxHitPoints(object oFollower, int nMaxHP);',
        '// 618: SWMG_SetMaxHitPoints\r\nvoid SWMG_SetMaxHitPoints(object oFollower, int nMaxHP);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SWMG_GetSphereRadius',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ],
        '// 619: SWMG_GetSphereRadius\r\nfloat SWMG_GetSphereRadius(object oFollower);',
        '// 619: SWMG_GetSphereRadius\r\nfloat SWMG_GetSphereRadius(object oFollower);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetSphereRadius',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.FLOAT, 'fRadius', None), ],
        '// 620: SWMG_SetSphereRadius\r\nvoid SWMG_SetSphereRadius(object oFollower, float fRadius);',
        '// 620: SWMG_SetSphereRadius\r\nvoid SWMG_SetSphereRadius(object oFollower, float fRadius);'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetNumLoops',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ],
        '// 621: SWMG_GetNumLoops\r\nint SWMG_GetNumLoops(object oFollower);',
        '// 621: SWMG_GetNumLoops\r\nint SWMG_GetNumLoops(object oFollower);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetNumLoops',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nNumLoops', None), ],
        '// 622: SWMG_SetNumLoops\r\nvoid SWMG_SetNumLoops(object oFollower, int nNumLoops);',
        '// 622: SWMG_SetNumLoops\r\nvoid SWMG_SetNumLoops(object oFollower, int nNumLoops);'
    ),
    ScriptFunction(
        DataType.VECTOR,
        'SWMG_GetPosition',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ],
        '// 623: SWMG_GetPosition\r\nvector SWMG_GetPosition(object oFollower);',
        '// 623: SWMG_GetPosition\r\nvector SWMG_GetPosition(object oFollower);'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetGunBankCount',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ],
        '// 624: SWMG_GetGunBankCount\r\nint SWMG_GetGunBankCount(object oFollower);',
        '// 624: SWMG_GetGunBankCount\r\nint SWMG_GetGunBankCount(object oFollower);'
    ),
    ScriptFunction(
        DataType.STRING,
        'SWMG_GetGunBankBulletModel',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nGunBank', None), ],
        '// 625: SWMG_GetGunBankBulletModel\r\nstring SWMG_GetGunBankBulletModel(object oFollower, int nGunBank);',
        '// 625: SWMG_GetGunBankBulletModel\r\nstring SWMG_GetGunBankBulletModel(object oFollower, int nGunBank);'
    ),
    ScriptFunction(
        DataType.STRING,
        'SWMG_GetGunBankGunModel',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nGunBank', None), ],
        '// 626: SWMG_GetGunBankGunModel\r\nstring SWMG_GetGunBankGunModel(object oFollower, int nGunBank);',
        '// 626: SWMG_GetGunBankGunModel\r\nstring SWMG_GetGunBankGunModel(object oFollower, int nGunBank);'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetGunBankDamage',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nGunBank', None), ],
        '// 627: SWMG_GetGunBankDamage\r\nint SWMG_GetGunBankDamage(object oFollower, int nGunBank);',
        '// 627: SWMG_GetGunBankDamage\r\nint SWMG_GetGunBankDamage(object oFollower, int nGunBank);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SWMG_GetGunBankTimeBetweenShots',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nGunBank', None), ],
        '// 628: SWMG_GetGunBankTimeBetweenShots\r\nfloat SWMG_GetGunBankTimeBetweenShots(object oFollower, int nGunBank);',
        '// 628: SWMG_GetGunBankTimeBetweenShots\r\nfloat SWMG_GetGunBankTimeBetweenShots(object oFollower, int nGunBank);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SWMG_GetGunBankLifespan',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nGunBank', None), ],
        '// 629: SWMG_GetGunBankLifespan\r\nfloat SWMG_GetGunBankLifespan(object oFollower, int nGunBank);',
        '// 629: SWMG_GetGunBankLifespan\r\nfloat SWMG_GetGunBankLifespan(object oFollower, int nGunBank);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SWMG_GetGunBankSpeed',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nGunBank', None), ],
        '// 630: SWMG_GetGunBankSpeed\r\nfloat SWMG_GetGunBankSpeed(object oFollower, int nGunBank);',
        '// 630: SWMG_GetGunBankSpeed\r\nfloat SWMG_GetGunBankSpeed(object oFollower, int nGunBank);'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetGunBankTarget',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nGunBank', None), ],
        '// 631: SWMG_GetGunBankTarget\r\nint SWMG_GetGunBankTarget(object oFollower, int nGunBank);',
        '// 631: SWMG_GetGunBankTarget\r\nint SWMG_GetGunBankTarget(object oFollower, int nGunBank);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetGunBankBulletModel',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nGunBank', None), ScriptParam(DataType.STRING, 'sBulletModel', None), ],
        '// 632: SWMG_SetGunBankBulletModel\r\nvoid SWMG_SetGunBankBulletModel(object oFollower, int nGunBank, string sBulletModel);',
        '// 632: SWMG_SetGunBankBulletModel\r\nvoid SWMG_SetGunBankBulletModel(object oFollower, int nGunBank, string sBulletModel);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetGunBankGunModel',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nGunBank', None), ScriptParam(DataType.STRING, 'sGunModel', None), ],
        '// 633: SWMG_SetGunBankGunModel\r\nvoid SWMG_SetGunBankGunModel(object oFollower, int nGunBank, string sGunModel);',
        '// 633: SWMG_SetGunBankGunModel\r\nvoid SWMG_SetGunBankGunModel(object oFollower, int nGunBank, string sGunModel);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetGunBankDamage',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nGunBank', None), ScriptParam(DataType.INT, 'nDamage', None), ],
        '// 634: SWMG_SetGunBankDamage\r\nvoid SWMG_SetGunBankDamage(object oFollower, int nGunBank, int nDamage);',
        '// 634: SWMG_SetGunBankDamage\r\nvoid SWMG_SetGunBankDamage(object oFollower, int nGunBank, int nDamage);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetGunBankTimeBetweenShots',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nGunBank', None), ScriptParam(DataType.FLOAT, 'fTBS', None), ],
        '// 635: SWMG_SetGunBankTimeBetweenShots\r\nvoid SWMG_SetGunBankTimeBetweenShots(object oFollower, int nGunBank, float fTBS);',
        '// 635: SWMG_SetGunBankTimeBetweenShots\r\nvoid SWMG_SetGunBankTimeBetweenShots(object oFollower, int nGunBank, float fTBS);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetGunBankLifespan',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nGunBank', None), ScriptParam(DataType.FLOAT, 'fLifespan', None), ],
        '// 636: SWMG_SetGunBankLifespan\r\nvoid SWMG_SetGunBankLifespan(object oFollower, int nGunBank, float fLifespan);',
        '// 636: SWMG_SetGunBankLifespan\r\nvoid SWMG_SetGunBankLifespan(object oFollower, int nGunBank, float fLifespan);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetGunBankSpeed',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nGunBank', None), ScriptParam(DataType.FLOAT, 'fSpeed', None), ],
        '// 637: SWMG_SetGunBankSpeed\r\nvoid SWMG_SetGunBankSpeed(object oFollower, int nGunBank, float fSpeed);',
        '// 637: SWMG_SetGunBankSpeed\r\nvoid SWMG_SetGunBankSpeed(object oFollower, int nGunBank, float fSpeed);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetGunBankTarget',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nGunBank', None), ScriptParam(DataType.INT, 'nTarget', None), ],
        '// 638: SWMG_SetGunBankTarget\r\nvoid SWMG_SetGunBankTarget(object oFollower, int nGunBank, int nTarget);',
        '// 638: SWMG_SetGunBankTarget\r\nvoid SWMG_SetGunBankTarget(object oFollower, int nGunBank, int nTarget);'
    ),
    ScriptFunction(
        DataType.STRING,
        'SWMG_GetLastBulletHitPart',
        [],
        '// 639: SWMG_GetLastBulletHitPart\r\nstring SWMG_GetLastBulletHitPart();',
        '// 639: SWMG_GetLastBulletHitPart\r\nstring SWMG_GetLastBulletHitPart();'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_IsGunBankTargetting',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nGunBank', None), ],
        '// 640: SWMG_IsGunBankTargetting\r\nint SWMG_IsGunBankTargetting(object oFollower, int nGunBank);',
        '// 640: SWMG_IsGunBankTargetting\r\nint SWMG_IsGunBankTargetting(object oFollower, int nGunBank);'
    ),
    ScriptFunction(
        DataType.VECTOR,
        'SWMG_GetPlayerOffset',
        [],
        '// 641: SWMG_GetPlayerOffset\r\n// returns a vector with the player rotation for rotation minigames\r\n// returns a vector with the player translation for translation minigames\r\nvector SWMG_GetPlayerOffset();',
        '// 641: SWMG_GetPlayerOffset\r\n// returns a vector with the player rotation for rotation minigames\r\n// returns a vector with the player translation for translation minigames\r\nvector SWMG_GetPlayerOffset();'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SWMG_GetPlayerInvincibility',
        [],
        '// 642: SWMG_GetPlayerInvincibility\r\nfloat SWMG_GetPlayerInvincibility();',
        '// 642: SWMG_GetPlayerInvincibility\r\nfloat SWMG_GetPlayerInvincibility();'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SWMG_GetPlayerSpeed',
        [],
        '// 643: SWMG_GetPlayerSpeed\r\nfloat SWMG_GetPlayerSpeed();',
        '// 643: SWMG_GetPlayerSpeed\r\nfloat SWMG_GetPlayerSpeed();'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SWMG_GetPlayerMinSpeed',
        [],
        '// 644: SWMG_GetPlayerMinSpeed\r\nfloat SWMG_GetPlayerMinSpeed ();',
        '// 644: SWMG_GetPlayerMinSpeed\r\nfloat SWMG_GetPlayerMinSpeed ();'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SWMG_GetPlayerAccelerationPerSecond',
        [],
        '// 645: SWMG_GetPlayerAccelerationPerSecond\r\nfloat SWMG_GetPlayerAccelerationPerSecond();',
        '// 645: SWMG_GetPlayerAccelerationPerSecond\r\nfloat SWMG_GetPlayerAccelerationPerSecond();'
    ),
    ScriptFunction(
        DataType.VECTOR,
        'SWMG_GetPlayerTunnelPos',
        [],
        '// 646: SWMG_GetPlayerTunnelPos\r\nvector SWMG_GetPlayerTunnelPos();',
        '// 646: SWMG_GetPlayerTunnelPos\r\nvector SWMG_GetPlayerTunnelPos();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetPlayerOffset',
        [ScriptParam(DataType.VECTOR, 'vOffset', None), ],
        '// 647: SWMG_SetPlayerOffset\r\nvoid SWMG_SetPlayerOffset(vector vOffset);',
        '// 647: SWMG_SetPlayerOffset\r\nvoid SWMG_SetPlayerOffset(vector vOffset);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetPlayerInvincibility',
        [ScriptParam(DataType.FLOAT, 'fInvincibility', None), ],
        '// 648: SWMG_SetPlayerInvincibility\r\nvoid SWMG_SetPlayerInvincibility(float fInvincibility);',
        '// 648: SWMG_SetPlayerInvincibility\r\nvoid SWMG_SetPlayerInvincibility(float fInvincibility);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetPlayerSpeed',
        [ScriptParam(DataType.FLOAT, 'fSpeed', None), ],
        '// 649: SWMG_SetPlayerSpeed\r\nvoid SWMG_SetPlayerSpeed(float fSpeed);',
        '// 649: SWMG_SetPlayerSpeed\r\nvoid SWMG_SetPlayerSpeed(float fSpeed);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetPlayerMinSpeed',
        [ScriptParam(DataType.FLOAT, 'fMinSpeed', None), ],
        '// 650: SWMG_SetPlayerMinSpeed\r\nvoid SWMG_SetPlayerMinSpeed(float fMinSpeed);',
        '// 650: SWMG_SetPlayerMinSpeed\r\nvoid SWMG_SetPlayerMinSpeed(float fMinSpeed);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetPlayerAccelerationPerSecond',
        [ScriptParam(DataType.FLOAT, 'fAPS', None), ],
        '// 651: SWMG_SetPlayerAccelerationPerSecond\r\nvoid SWMG_SetPlayerAccelerationPerSecond(float fAPS);',
        '// 651: SWMG_SetPlayerAccelerationPerSecond\r\nvoid SWMG_SetPlayerAccelerationPerSecond(float fAPS);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetPlayerTunnelPos',
        [ScriptParam(DataType.VECTOR, 'vTunnel', None), ],
        '// 652: SWMG_SetPlayerTunnelPos\r\nvoid SWMG_SetPlayerTunnelPos(vector vTunnel);',
        '// 652: SWMG_SetPlayerTunnelPos\r\nvoid SWMG_SetPlayerTunnelPos(vector vTunnel);'
    ),
    ScriptFunction(
        DataType.VECTOR,
        'SWMG_GetPlayerTunnelNeg',
        [],
        '// 653: SWMG_GetPlayerTunnelNeg\r\nvector SWMG_GetPlayerTunnelNeg();',
        '// 653: SWMG_GetPlayerTunnelNeg\r\nvector SWMG_GetPlayerTunnelNeg();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetPlayerTunnelNeg',
        [ScriptParam(DataType.VECTOR, 'vTunnel', None), ],
        '// 654: SWMG_SetPlayerTunnelNeg\r\nvoid SWMG_SetPlayerTunnelNeg(vector vTunnel);',
        '// 654: SWMG_SetPlayerTunnelNeg\r\nvoid SWMG_SetPlayerTunnelNeg(vector vTunnel);'
    ),
    ScriptFunction(
        DataType.VECTOR,
        'SWMG_GetPlayerOrigin',
        [],
        '// 655: SWMG_GetPlayerOrigin\r\nvector SWMG_GetPlayerOrigin();',
        '// 655: SWMG_GetPlayerOrigin\r\nvector SWMG_GetPlayerOrigin();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetPlayerOrigin',
        [ScriptParam(DataType.VECTOR, 'vOrigin', None), ],
        '// 656: SWMG_SetPlayerOrigin\r\nvoid SWMG_SetPlayerOrigin(vector vOrigin);',
        '// 656: SWMG_SetPlayerOrigin\r\nvoid SWMG_SetPlayerOrigin(vector vOrigin);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SWMG_GetGunBankHorizontalSpread',
        [ScriptParam(DataType.OBJECT, 'oEnemy', None), ScriptParam(DataType.INT, 'nGunBank', None), ],
        '// 657: SWMG_GetGunBankHorizontalSpread\r\nfloat SWMG_GetGunBankHorizontalSpread(object oEnemy, int nGunBank);',
        '// 657: SWMG_GetGunBankHorizontalSpread\r\nfloat SWMG_GetGunBankHorizontalSpread(object oEnemy, int nGunBank);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SWMG_GetGunBankVerticalSpread',
        [ScriptParam(DataType.OBJECT, 'oEnemy', None), ScriptParam(DataType.INT, 'nGunBank', None), ],
        '// 658: SWMG_GetGunBankVerticalSpread\r\nfloat SWMG_GetGunBankVerticalSpread(object oEnemy, int nGunBank);',
        '// 658: SWMG_GetGunBankVerticalSpread\r\nfloat SWMG_GetGunBankVerticalSpread(object oEnemy, int nGunBank);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SWMG_GetGunBankSensingRadius',
        [ScriptParam(DataType.OBJECT, 'oEnemy', None), ScriptParam(DataType.INT, 'nGunBank', None), ],
        '// 659: SWMG_GetGunBankSensingRadius\r\nfloat SWMG_GetGunBankSensingRadius(object oEnemy, int nGunBank);',
        '// 659: SWMG_GetGunBankSensingRadius\r\nfloat SWMG_GetGunBankSensingRadius(object oEnemy, int nGunBank);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SWMG_GetGunBankInaccuracy',
        [ScriptParam(DataType.OBJECT, 'oEnemy', None), ScriptParam(DataType.INT, 'nGunBank', None), ],
        '// 660: SWMG_GetGunBankInaccuracy\r\nfloat SWMG_GetGunBankInaccuracy(object oEnemy, int nGunBank);',
        '// 660: SWMG_GetGunBankInaccuracy\r\nfloat SWMG_GetGunBankInaccuracy(object oEnemy, int nGunBank);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetGunBankHorizontalSpread',
        [ScriptParam(DataType.OBJECT, 'oEnemy', None), ScriptParam(DataType.INT, 'nGunBank', None), ScriptParam(DataType.FLOAT, 'fHorizontalSpread', None), ],
        '// 661: SWMG_SetGunBankHorizontalSpread\r\nvoid SWMG_SetGunBankHorizontalSpread(object oEnemy, int nGunBank, float fHorizontalSpread);',
        '// 661: SWMG_SetGunBankHorizontalSpread\r\nvoid SWMG_SetGunBankHorizontalSpread(object oEnemy, int nGunBank, float fHorizontalSpread);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetGunBankVerticalSpread',
        [ScriptParam(DataType.OBJECT, 'oEnemy', None), ScriptParam(DataType.INT, 'nGunBank', None), ScriptParam(DataType.FLOAT, 'fVerticalSpread', None), ],
        '// 662: SWMG_SetGunBankVerticalSpread\r\nvoid SWMG_SetGunBankVerticalSpread(object oEnemy, int nGunBank, float fVerticalSpread);',
        '// 662: SWMG_SetGunBankVerticalSpread\r\nvoid SWMG_SetGunBankVerticalSpread(object oEnemy, int nGunBank, float fVerticalSpread);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetGunBankSensingRadius',
        [ScriptParam(DataType.OBJECT, 'oEnemy', None), ScriptParam(DataType.INT, 'nGunBank', None), ScriptParam(DataType.FLOAT, 'fSensingRadius', None), ],
        '// 663: SWMG_SetGunBankSensingRadius\r\nvoid SWMG_SetGunBankSensingRadius(object oEnemy, int nGunBank, float fSensingRadius);',
        '// 663: SWMG_SetGunBankSensingRadius\r\nvoid SWMG_SetGunBankSensingRadius(object oEnemy, int nGunBank, float fSensingRadius);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetGunBankInaccuracy',
        [ScriptParam(DataType.OBJECT, 'oEnemy', None), ScriptParam(DataType.INT, 'nGunBank', None), ScriptParam(DataType.FLOAT, 'fInaccuracy', None), ],
        '// 664: SWMG_SetGunBankInaccuracy\r\nvoid SWMG_SetGunBankInaccuracy(object oEnemy, int nGunBank, float fInaccuracy);',
        '// 664: SWMG_SetGunBankInaccuracy\r\nvoid SWMG_SetGunBankInaccuracy(object oEnemy, int nGunBank, float fInaccuracy);'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetIsInvulnerable',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ],
        '// 665: GetIsInvulnerable\r\n// This returns whether the follower object is currently invulnerable to damage\r\nint SWMG_GetIsInvulnerable( object oFollower );',
        '// 665: GetIsInvulnerable\r\n// This returns whether the follower object is currently invulnerable to damage\r\nint SWMG_GetIsInvulnerable( object oFollower );'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_StartInvulnerability',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ],
        '// 666: StartInvulnerability\r\n// This will begin a period of invulnerability (as defined by Invincibility)\r\nvoid SWMG_StartInvulnerability( object oFollower );',
        '// 666: StartInvulnerability\r\n// This will begin a period of invulnerability (as defined by Invincibility)\r\nvoid SWMG_StartInvulnerability( object oFollower );'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SWMG_GetPlayerMaxSpeed',
        [],
        "// 667: GetPlayerMaxSpeed\r\n// This returns the player character's max speed\r\nfloat SWMG_GetPlayerMaxSpeed();",
        "// 667: GetPlayerMaxSpeed\r\n// This returns the player character's max speed\r\nfloat SWMG_GetPlayerMaxSpeed();"
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetPlayerMaxSpeed',
        [ScriptParam(DataType.FLOAT, 'fMaxSpeed', None), ],
        "// 668: SetPlayerMaxSpeed\r\n// This sets the player character's max speed\r\nvoid SWMG_SetPlayerMaxSpeed( float fMaxSpeed );",
        "// 668: SetPlayerMaxSpeed\r\n// This sets the player character's max speed\r\nvoid SWMG_SetPlayerMaxSpeed( float fMaxSpeed );"
    ),
    ScriptFunction(
        DataType.VOID,
        'AddJournalWorldEntry',
        [ScriptParam(DataType.INT, 'nIndex', None), ScriptParam(DataType.STRING, 'szEntry', None), ScriptParam(DataType.STRING, 'szTitle', 'World Entry'), ],
        '// 669: AddJournalWorldEntry\r\n// Adds a user entered entry to the world notices\r\nvoid AddJournalWorldEntry( int nIndex, string szEntry, string szTitle  =  "World Entry" );',
        '// 669: AddJournalWorldEntry\r\n// Adds a user entered entry to the world notices\r\nvoid AddJournalWorldEntry( int nIndex, string szEntry, string szTitle  =  "World Entry" );'
    ),
    ScriptFunction(
        DataType.VOID,
        'AddJournalWorldEntryStrref',
        [ScriptParam(DataType.INT, 'strref', None), ScriptParam(DataType.INT, 'strrefTitle', None), ],
        '// 670: AddJournalWorldEntryStrref\r\n// Adds an entry to the world notices using stringrefs\r\nvoid AddJournalWorldEntryStrref ( int strref, int strrefTitle );',
        '// 670: AddJournalWorldEntryStrref\r\n// Adds an entry to the world notices using stringrefs\r\nvoid AddJournalWorldEntryStrref ( int strref, int strrefTitle );'
    ),
    ScriptFunction(
        DataType.VOID,
        'BarkString',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'strRef', None), ],
        '// 671: BarkString\r\n// this will cause a creature to bark the strRef from the talk table\r\n// If creature is specefied as OBJECT_INVALID a general bark is made.\r\nvoid BarkString(object oCreature,int strRef);',
        '// 671: BarkString\r\n// this will cause a creature to bark the strRef from the talk table\r\n// If creature is specefied as OBJECT_INVALID a general bark is made.\r\nvoid BarkString(object oCreature,int strRef);'
    ),
    ScriptFunction(
        DataType.VOID,
        'DeleteJournalWorldAllEntries',
        [],
        "// 672: DeleteJournalWorldAllEntries\r\n// Nuke's 'em all, user entered or otherwise.\r\nvoid DeleteJournalWorldAllEntries();",
        "// 672: DeleteJournalWorldAllEntries\r\n// Nuke's 'em all, user entered or otherwise.\r\nvoid DeleteJournalWorldAllEntries();"
    ),
    ScriptFunction(
        DataType.VOID,
        'DeleteJournalWorldEntry',
        [ScriptParam(DataType.INT, 'nIndex', None), ],
        '// 673: DeleteJournalWorldEntry\r\n// Deletes a user entered world notice\r\nvoid DeleteJournalWorldEntry( int nIndex );',
        '// 673: DeleteJournalWorldEntry\r\n// Deletes a user entered world notice\r\nvoid DeleteJournalWorldEntry( int nIndex );'
    ),
    ScriptFunction(
        DataType.VOID,
        'DeleteJournalWorldEntryStrref',
        [ScriptParam(DataType.INT, 'strref', None), ],
        '// 674: DeleteJournalWorldEntryStrref\r\n// Deletes the world notice pertaining to the string ref\r\nvoid DeleteJournalWorldEntryStrref( int strref );',
        '// 674: DeleteJournalWorldEntryStrref\r\n// Deletes the world notice pertaining to the string ref\r\nvoid DeleteJournalWorldEntryStrref( int strref );'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectForceDrain',
        [ScriptParam(DataType.INT, 'nDamage', None), ],
        '// 675: EffectForceDrain\r\n// This command will reduce the force points of a creature.\r\neffect EffectForceDrain( int nDamage );',
        '// 675: EffectForceDrain\r\n// This command will reduce the force points of a creature.\r\neffect EffectForceDrain( int nDamage );'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectPsychicStatic',
        [],
        '// 676: EffectTemporaryForcePoints\r\neffect EffectPsychicStatic();',
        '// 676: EffectTemporaryForcePoints\r\neffect EffectPsychicStatic();'
    ),
    ScriptFunction(
        DataType.VOID,
        'PlayVisualAreaEffect',
        [ScriptParam(DataType.INT, 'nEffectID', None), ScriptParam(DataType.LOCATION, 'lTarget', None), ],
        '// 677: PlayVisualAreaEffect\r\nvoid PlayVisualAreaEffect(int nEffectID, location lTarget);',
        '// 677: PlayVisualAreaEffect\r\nvoid PlayVisualAreaEffect(int nEffectID, location lTarget);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetJournalQuestEntryPicture',
        [ScriptParam(DataType.STRING, 'szPlotID', None), ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.INT, 'nPictureIndex', None), ScriptParam(DataType.INT, 'bAllPartyMemebers', 1), ScriptParam(DataType.INT, 'bAllPlayers', 0), ],
        '// 678: SetJournalQuestEntryPicture\r\n// Sets the picture for the quest entry on this object (creature)\r\nvoid SetJournalQuestEntryPicture(string szPlotID, object oObject, int nPictureIndex, int bAllPartyMemebers = TRUE, int bAllPlayers = FALSE);',
        '// 678: SetJournalQuestEntryPicture\r\n// Sets the picture for the quest entry on this object (creature)\r\nvoid SetJournalQuestEntryPicture(string szPlotID, object oObject, int nPictureIndex, int bAllPartyMemebers = TRUE, int bAllPlayers = FALSE);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLocalBoolean',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.INT, 'nIndex', None), ],
        '// 679. GetLocalBoolean\r\n// This gets a boolean flag on an object\r\n// currently the index is a range between 0 and 63\r\nint GetLocalBoolean( object oObject, int nIndex );',
        '// 679. GetLocalBoolean\r\n// This gets a boolean flag on an object\r\n// currently the index is a range between 0 and 63\r\nint GetLocalBoolean( object oObject, int nIndex );'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetLocalBoolean',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.INT, 'nIndex', None), ScriptParam(DataType.INT, 'nValue', None), ],
        '// 680. SetLocalBoolean\r\n// This sets a boolean flag on an object\r\n// currently the index is a range between 0 and 63\r\nvoid SetLocalBoolean( object oObject, int nIndex, int nValue );',
        '// 680. SetLocalBoolean\r\n// This sets a boolean flag on an object\r\n// currently the index is a range between 0 and 63\r\nvoid SetLocalBoolean( object oObject, int nIndex, int nValue );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLocalNumber',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.INT, 'nIndex', None), ],
        '// 681. GetLocalNumber\r\n// This gets a number on an object\r\n// currently the index is a range between 0 and 0\r\nint GetLocalNumber( object oObject, int nIndex );',
        '// 681. GetLocalNumber\r\n// This gets a number on an object\r\n// currently the index is a range between 0 and 0\r\nint GetLocalNumber( object oObject, int nIndex );'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetLocalNumber',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.INT, 'nIndex', None), ScriptParam(DataType.INT, 'nValue', None), ],
        '// 682. SetLocalNumber\r\n// This sets a number on an object\r\n// currently the index is a range between 0 and 0\r\nvoid SetLocalNumber( object oObject, int nIndex, int nValue );',
        '// 682. SetLocalNumber\r\n// This sets a number on an object\r\n// currently the index is a range between 0 and 0\r\nvoid SetLocalNumber( object oObject, int nIndex, int nValue );'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetSoundFrequency',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nSound', None), ],
        '// 683. SWMG_GetSoundFrequency\r\n// Gets the frequency of a trackfollower sound\r\nint SWMG_GetSoundFrequency( object oFollower, int nSound );',
        '// 683. SWMG_GetSoundFrequency\r\n// Gets the frequency of a trackfollower sound\r\nint SWMG_GetSoundFrequency( object oFollower, int nSound );'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetSoundFrequency',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nSound', None), ScriptParam(DataType.INT, 'nFrequency', None), ],
        '// 684. SWMG_SetSoundFrequency\r\n// Sets the frequency of a trackfollower sound\r\nvoid SWMG_SetSoundFrequency( object oFollower, int nSound, int nFrequency );',
        '// 684. SWMG_SetSoundFrequency\r\n// Sets the frequency of a trackfollower sound\r\nvoid SWMG_SetSoundFrequency( object oFollower, int nSound, int nFrequency );'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetSoundFrequencyIsRandom',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nSound', None), ],
        '// 685. SWMG_GetSoundFrequencyIsRandom\r\n// Gets whether the frequency of a trackfollower sound is using the random model\r\nint SWMG_GetSoundFrequencyIsRandom( object oFollower, int nSound );',
        '// 685. SWMG_GetSoundFrequencyIsRandom\r\n// Gets whether the frequency of a trackfollower sound is using the random model\r\nint SWMG_GetSoundFrequencyIsRandom( object oFollower, int nSound );'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetSoundFrequencyIsRandom',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nSound', None), ScriptParam(DataType.INT, 'bIsRandom', None), ],
        '// 686. SWMG_SetSoundFrequencyIsRandom\r\n// Sets whether the frequency of a trackfollower sound is using the random model\r\nvoid SWMG_SetSoundFrequencyIsRandom( object oFollower, int nSound, int bIsRandom );',
        '// 686. SWMG_SetSoundFrequencyIsRandom\r\n// Sets whether the frequency of a trackfollower sound is using the random model\r\nvoid SWMG_SetSoundFrequencyIsRandom( object oFollower, int nSound, int bIsRandom );'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetSoundVolume',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nSound', None), ],
        '// 687. SWMG_GetSoundVolume\r\n// Gets the volume of a trackfollower sound\r\nint SWMG_GetSoundVolume( object oFollower, int nSound );',
        '// 687. SWMG_GetSoundVolume\r\n// Gets the volume of a trackfollower sound\r\nint SWMG_GetSoundVolume( object oFollower, int nSound );'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetSoundVolume',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nSound', None), ScriptParam(DataType.INT, 'nVolume', None), ],
        '// 688. SWMG_SetSoundVolume\r\n// Sets the volume of a trackfollower sound\r\nvoid SWMG_SetSoundVolume( object oFollower, int nSound, int nVolume );',
        '// 688. SWMG_SetSoundVolume\r\n// Sets the volume of a trackfollower sound\r\nvoid SWMG_SetSoundVolume( object oFollower, int nSound, int nVolume );'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SoundObjectGetPitchVariance',
        [ScriptParam(DataType.OBJECT, 'oSound', None), ],
        '// 689. SoundObjectGetPitchVariance\r\n// Gets the pitch variance of a placeable sound object\r\nfloat SoundObjectGetPitchVariance( object oSound );',
        '// 689. SoundObjectGetPitchVariance\r\n// Gets the pitch variance of a placeable sound object\r\nfloat SoundObjectGetPitchVariance( object oSound );'
    ),
    ScriptFunction(
        DataType.VOID,
        'SoundObjectSetPitchVariance',
        [ScriptParam(DataType.OBJECT, 'oSound', None), ScriptParam(DataType.FLOAT, 'fVariance', None), ],
        '// 690. SoundObjectSetPitchVariance\r\n// Sets the pitch variance of a placeable sound object\r\nvoid SoundObjectSetPitchVariance( object oSound, float fVariance );',
        '// 690. SoundObjectSetPitchVariance\r\n// Sets the pitch variance of a placeable sound object\r\nvoid SoundObjectSetPitchVariance( object oSound, float fVariance );'
    ),
    ScriptFunction(
        DataType.INT,
        'SoundObjectGetVolume',
        [ScriptParam(DataType.OBJECT, 'oSound', None), ],
        '// 691. SoundObjectGetVolume\r\n// Gets the volume of a placeable sound object\r\nint SoundObjectGetVolume( object oSound );',
        '// 691. SoundObjectGetVolume\r\n// Gets the volume of a placeable sound object\r\nint SoundObjectGetVolume( object oSound );'
    ),
    ScriptFunction(
        DataType.LOCATION,
        'GetGlobalLocation',
        [ScriptParam(DataType.STRING, 'sIdentifier', None), ],
        '// 692: GetGlobalLocation\r\n// This function returns the a global location scripting variable.\r\nlocation GetGlobalLocation( string sIdentifier );',
        '// 692: GetGlobalLocation\r\n// This function returns the a global location scripting variable.\r\nlocation GetGlobalLocation( string sIdentifier );'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetGlobalLocation',
        [ScriptParam(DataType.STRING, 'sIdentifier', None), ScriptParam(DataType.LOCATION, 'lValue', None), ],
        '// 693: SetGlobalLocation\r\n// This function sets the a global location scripting variable.\r\nvoid SetGlobalLocation( string sIdentifier, location lValue );',
        '// 693: SetGlobalLocation\r\n// This function sets the a global location scripting variable.\r\nvoid SetGlobalLocation( string sIdentifier, location lValue );'
    ),
    ScriptFunction(
        DataType.INT,
        'AddAvailableNPCByObject',
        [ScriptParam(DataType.INT, 'nNPC', None), ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 694. AddAvailableNPCByObject\r\n// This adds a NPC to the list of available party members using\r\n// a game object as the template\r\n// Returns if true if successful, false if the NPC had already\r\n// been added or the object specified is invalid\r\nint AddAvailableNPCByObject( int nNPC, object oCreature );',
        '// 694. AddAvailableNPCByObject\r\n// This adds a NPC to the list of available party members using\r\n// a game object as the template\r\n// Returns if true if successful, false if the NPC had already\r\n// been added or the object specified is invalid\r\nint AddAvailableNPCByObject( int nNPC, object oCreature );'
    ),
    ScriptFunction(
        DataType.INT,
        'RemoveAvailableNPC',
        [ScriptParam(DataType.INT, 'nNPC', None), ],
        '// 695. RemoveAvailableNPC\r\n// This removes a NPC from the list of available party members\r\n// Returns whether it was successful or not\r\nint RemoveAvailableNPC( int nNPC );',
        '// 695. RemoveAvailableNPC\r\n// This removes a NPC from the list of available party members\r\n// Returns whether it was successful or not\r\nint RemoveAvailableNPC( int nNPC );'
    ),
    ScriptFunction(
        DataType.INT,
        'IsAvailableCreature',
        [ScriptParam(DataType.INT, 'nNPC', None), ],
        '// 696. IsAvailableNPC\r\n// This returns whether a NPC is in the list of available party members\r\nint IsAvailableCreature( int nNPC );',
        '// 696. IsAvailableNPC\r\n// This returns whether a NPC is in the list of available party members\r\nint IsAvailableCreature( int nNPC );'
    ),
    ScriptFunction(
        DataType.INT,
        'AddAvailableNPCByTemplate',
        [ScriptParam(DataType.INT, 'nNPC', None), ScriptParam(DataType.STRING, 'sTemplate', None), ],
        '// 697. AddAvailableNPCByTemplate\r\n// This adds a NPC to the list of available party members using\r\n// a template\r\n// Returns if true if successful, false if the NPC had already\r\n// been added or the template specified is invalid\r\nint AddAvailableNPCByTemplate( int nNPC, string sTemplate );',
        '// 697. AddAvailableNPCByTemplate\r\n// This adds a NPC to the list of available party members using\r\n// a template\r\n// Returns if true if successful, false if the NPC had already\r\n// been added or the template specified is invalid\r\nint AddAvailableNPCByTemplate( int nNPC, string sTemplate );'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'SpawnAvailableNPC',
        [ScriptParam(DataType.INT, 'nNPC', None), ScriptParam(DataType.LOCATION, 'lPosition', None), ],
        '// 698. SpawnAvailableNPC\r\n// This spawns a NPC from the list of available creatures\r\n// Returns a pointer to the creature object\r\nobject SpawnAvailableNPC( int nNPC, location lPosition );',
        '// 698. SpawnAvailableNPC\r\n// This spawns a NPC from the list of available creatures\r\n// Returns a pointer to the creature object\r\nobject SpawnAvailableNPC( int nNPC, location lPosition );'
    ),
    ScriptFunction(
        DataType.INT,
        'IsNPCPartyMember',
        [ScriptParam(DataType.INT, 'nNPC', None), ],
        '// 699. IsNPCPartyMember\r\n// Returns if a given NPC constant is in the party currently\r\nint IsNPCPartyMember( int nNPC );',
        '// 699. IsNPCPartyMember\r\n// Returns if a given NPC constant is in the party currently\r\nint IsNPCPartyMember( int nNPC );'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionBarkString',
        [ScriptParam(DataType.INT, 'strRef', None), ],
        '// 700. ActionBarkString\r\n// this will cause a creature to bark the strRef from the talk table.\r\nvoid ActionBarkString(int strRef);',
        '// 700. ActionBarkString\r\n// this will cause a creature to bark the strRef from the talk table.\r\nvoid ActionBarkString(int strRef);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsConversationActive',
        [],
        '// 701. GetIsConversationActive\r\n// Checks to see if any conversations are currently taking place\r\nint GetIsConversationActive();',
        '// 701. GetIsConversationActive\r\n// Checks to see if any conversations are currently taking place\r\nint GetIsConversationActive();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectLightsaberThrow',
        [ScriptParam(DataType.OBJECT, 'oTarget1', None), ScriptParam(DataType.OBJECT, 'oTarget2', 1), ScriptParam(DataType.OBJECT, 'oTarget3', 1), ScriptParam(DataType.INT, 'nAdvancedDamage', 0), ],
        '// 702. EffectLightsaberThrow\r\n// This function throws a lightsaber at a target\r\n// If multiple targets are specified, then the lightsaber travels to them\r\n// sequentially, returning to the first object specified\r\n// This effect is applied to an object, so an effector is not needed\r\neffect EffectLightsaberThrow(object oTarget1, object oTarget2  =  OBJECT_INVALID, object oTarget3  =  OBJECT_INVALID, int nAdvancedDamage  =  0);',
        '// 702. EffectLightsaberThrow\r\n// This function throws a lightsaber at a target\r\n// If multiple targets are specified, then the lightsaber travels to them\r\n// sequentially, returning to the first object specified\r\n// This effect is applied to an object, so an effector is not needed\r\neffect EffectLightsaberThrow(object oTarget1, object oTarget2  =  OBJECT_INVALID, object oTarget3  =  OBJECT_INVALID, int nAdvancedDamage  =  0);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectWhirlWind',
        [],
        '// 703.\r\n// creates the effect of a whirl wind.\r\neffect EffectWhirlWind();',
        '// 703.\r\n// creates the effect of a whirl wind.\r\neffect EffectWhirlWind();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetPartyAIStyle',
        [],
        '// 704.\r\n// Returns the party ai style\r\nint GetPartyAIStyle();',
        '// 704.\r\n// Returns the party ai style\r\nint GetPartyAIStyle();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetNPCAIStyle',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 705.\r\n// Returns the party members ai style\r\nint GetNPCAIStyle(object oCreature);',
        '// 705.\r\n// Returns the party members ai style\r\nint GetNPCAIStyle(object oCreature);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetPartyAIStyle',
        [ScriptParam(DataType.INT, 'nStyle', None), ],
        '// 706.\r\n// Sets the party ai style\r\nvoid SetPartyAIStyle(int nStyle);',
        '// 706.\r\n// Sets the party ai style\r\nvoid SetPartyAIStyle(int nStyle);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetNPCAIStyle',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nStyle', None), ],
        '// 707.\r\n// Sets the party members ai style\r\nvoid SetNPCAIStyle(object oCreature, int nStyle);',
        '// 707.\r\n// Sets the party members ai style\r\nvoid SetNPCAIStyle(object oCreature, int nStyle);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetNPCSelectability',
        [ScriptParam(DataType.INT, 'nNPC', None), ScriptParam(DataType.INT, 'nSelectability', None), ],
        '// 708: SetNPCSelectability\r\nvoid SetNPCSelectability(int nNPC, int nSelectability);',
        '// 708: SetNPCSelectability\r\nvoid SetNPCSelectability(int nNPC, int nSelectability);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetNPCSelectability',
        [ScriptParam(DataType.INT, 'nNPC', None), ],
        '// 709: GetNPCSelectability\r\nint GetNPCSelectability(int nNPC);',
        '// 709: GetNPCSelectability\r\nint GetNPCSelectability(int nNPC);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ClearAllEffects',
        [],
        '// 710: Clear all the effects of the caller.\r\n// * No return value, but if an error occurs, the log file will contain\r\n//   "ClearAllEffects failed.".\r\nvoid ClearAllEffects();',
        '// 710: Clear all the effects of the caller.\r\n// * No return value, but if an error occurs, the log file will contain\r\n//   "ClearAllEffects failed.".\r\nvoid ClearAllEffects();'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetLastConversation',
        [],
        '// 711: GetLastConversation\r\n// Gets the last conversation string.\r\nstring GetLastConversation();',
        '// 711: GetLastConversation\r\n// Gets the last conversation string.\r\nstring GetLastConversation();'
    ),
    ScriptFunction(
        DataType.VOID,
        'ShowPartySelectionGUI',
        [ScriptParam(DataType.STRING, 'sExitScript', ''), ScriptParam(DataType.INT, 'nForceNPC1', -1), ScriptParam(DataType.INT, 'nForceNPC2', -1), ],
        '// 712: ShowPartySelectionGUI\r\n// Brings up the party selection GUI for the player to\r\n// select the members of the party from\r\n// if exit script is specified, will be executed when\r\n// the GUI is exited\r\nvoid ShowPartySelectionGUI(string sExitScript  =  "", int nForceNPC1  =  -1, int nForceNPC2  =  -1);',
        '// 712: ShowPartySelectionGUI\r\n// Brings up the party selection GUI for the player to\r\n// select the members of the party from\r\n// if exit script is specified, will be executed when\r\n// the GUI is exited\r\nvoid ShowPartySelectionGUI(string sExitScript  =  "", int nForceNPC1  =  -1, int nForceNPC2  =  -1);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetStandardFaction',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 713: GetStandardFaction\r\n// Find out which standard faction oObject belongs to.\r\n// * Returns INVALID_STANDARD_FACTION if oObject does not belong to\r\n//   a Standard Faction, or an error has occurred.\r\nint GetStandardFaction(object oObject);',
        '// 713: GetStandardFaction\r\n// Find out which standard faction oObject belongs to.\r\n// * Returns INVALID_STANDARD_FACTION if oObject does not belong to\r\n//   a Standard Faction, or an error has occurred.\r\nint GetStandardFaction(object oObject);'
    ),
    ScriptFunction(
        DataType.VOID,
        'GivePlotXP',
        [ScriptParam(DataType.STRING, 'sPlotName', None), ScriptParam(DataType.INT, 'nPercentage', None), ],
        '// 714: GivePlotXP\r\n// Give nPercentage% of the experience associated with plot sPlotName\r\n// to the party\r\n// - sPlotName\r\n// - nPercentage\r\nvoid GivePlotXP(string sPlotName, int nPercentage);',
        '// 714: GivePlotXP\r\n// Give nPercentage% of the experience associated with plot sPlotName\r\n// to the party\r\n// - sPlotName\r\n// - nPercentage\r\nvoid GivePlotXP(string sPlotName, int nPercentage);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetMinOneHP',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 715. GetMinOneHP\r\n// Checks to see if oObject has the MinOneHP Flag set on them.\r\nint GetMinOneHP(object oObject);',
        '// 715. GetMinOneHP\r\n// Checks to see if oObject has the MinOneHP Flag set on them.\r\nint GetMinOneHP(object oObject);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetMinOneHP',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.INT, 'nMinOneHP', None), ],
        '// 716. SetMinOneHP\r\n// Sets/Removes the MinOneHP Flag on oObject.\r\nvoid SetMinOneHP(object oObject,int nMinOneHP);',
        '// 716. SetMinOneHP\r\n// Sets/Removes the MinOneHP Flag on oObject.\r\nvoid SetMinOneHP(object oObject,int nMinOneHP);'
    ),
    ScriptFunction(
        DataType.VECTOR,
        'SWMG_GetPlayerTunnelInfinite',
        [],
        '// 717. SWMG_GetPlayerTunnelInfinite\r\n// Gets whether each of the dimensions is infinite\r\nvector SWMG_GetPlayerTunnelInfinite();',
        '// 717. SWMG_GetPlayerTunnelInfinite\r\n// Gets whether each of the dimensions is infinite\r\nvector SWMG_GetPlayerTunnelInfinite();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetPlayerTunnelInfinite',
        [ScriptParam(DataType.VECTOR, 'vInfinite', None), ],
        '// 718. SWMG_SetPlayerTunnelInfinite\r\n// Sets whether each of the dimensions is infinite\r\nvoid SWMG_SetPlayerTunnelInfinite(vector vInfinite);',
        '// 718. SWMG_SetPlayerTunnelInfinite\r\n// Sets whether each of the dimensions is infinite\r\nvoid SWMG_SetPlayerTunnelInfinite(vector vInfinite);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetGlobalFadeIn',
        [ScriptParam(DataType.FLOAT, 'fWait', 0.0), ScriptParam(DataType.FLOAT, 'fLength', 0.0), ScriptParam(DataType.FLOAT, 'fR', 0.0), ScriptParam(DataType.FLOAT, 'fG', 0.0), ScriptParam(DataType.FLOAT, 'fB', 0.0), ],
        '// 719. SetGlobalFadeIn\r\n// Sets a Fade In that starts after fWait seconds and fades for fLength Seconds.\r\n// The Fade will be from a color specified by the RGB values fR, fG, and fB.\r\n// Note that fR, fG, and fB are normalized values.\r\n// The default values are an immediate cut in from black.\r\nvoid SetGlobalFadeIn(float fWait  =  0.0f, float fLength  =  0.0f, float fR = 0.0f, float fG = 0.0f, float fB = 0.0f);',
        '// 719. SetGlobalFadeIn\r\n// Sets a Fade In that starts after fWait seconds and fades for fLength Seconds.\r\n// The Fade will be from a color specified by the RGB values fR, fG, and fB.\r\n// Note that fR, fG, and fB are normalized values.\r\n// The default values are an immediate cut in from black.\r\nvoid SetGlobalFadeIn(float fWait  =  0.0f, float fLength  =  0.0f, float fR = 0.0f, float fG = 0.0f, float fB = 0.0f);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetGlobalFadeOut',
        [ScriptParam(DataType.FLOAT, 'fWait', 0.0), ScriptParam(DataType.FLOAT, 'fLength', 0.0), ScriptParam(DataType.FLOAT, 'fR', 0.0), ScriptParam(DataType.FLOAT, 'fG', 0.0), ScriptParam(DataType.FLOAT, 'fB', 0.0), ],
        '// 720. SetGlobalFadeOut\r\n// Sets a Fade Out that starts after fWait seconds and fades for fLength Seconds.\r\n// The Fade will be to a color specified by the RGB values fR, fG, and fB.\r\n// Note that fR, fG, and fB are normalized values.\r\n// The default values are an immediate cut to from black.\r\nvoid SetGlobalFadeOut(float fWait  =  0.0f, float fLength  =  0.0f, float fR = 0.0f, float fG = 0.0f, float fB = 0.0f);',
        '// 720. SetGlobalFadeOut\r\n// Sets a Fade Out that starts after fWait seconds and fades for fLength Seconds.\r\n// The Fade will be to a color specified by the RGB values fR, fG, and fB.\r\n// Note that fR, fG, and fB are normalized values.\r\n// The default values are an immediate cut to from black.\r\nvoid SetGlobalFadeOut(float fWait  =  0.0f, float fLength  =  0.0f, float fR = 0.0f, float fG = 0.0f, float fB = 0.0f);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastHostileTarget',
        [ScriptParam(DataType.OBJECT, 'oAttacker', 0), ],
        '// 721. GetLastAttackTarget\r\n// Returns the last attack target for a given object\r\nobject GetLastHostileTarget(object oAttacker  =  OBJECT_SELF);',
        '// 721. GetLastAttackTarget\r\n// Returns the last attack target for a given object\r\nobject GetLastHostileTarget(object oAttacker  =  OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastAttackAction',
        [ScriptParam(DataType.OBJECT, 'oAttacker', 0), ],
        '// 722. GetLastAttackAction\r\n// Returns the last attack action for a given object\r\nint GetLastAttackAction(object oAttacker  =  OBJECT_SELF);',
        '// 722. GetLastAttackAction\r\n// Returns the last attack action for a given object\r\nint GetLastAttackAction(object oAttacker  =  OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastForcePowerUsed',
        [ScriptParam(DataType.OBJECT, 'oAttacker', 0), ],
        '// 723. GetLastForcePowerUsed\r\n// Returns the last force power used (as a spell number that indexes the Spells.2da) by the given object\r\nint GetLastForcePowerUsed(object oAttacker  =  OBJECT_SELF);',
        '// 723. GetLastForcePowerUsed\r\n// Returns the last force power used (as a spell number that indexes the Spells.2da) by the given object\r\nint GetLastForcePowerUsed(object oAttacker  =  OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastCombatFeatUsed',
        [ScriptParam(DataType.OBJECT, 'oAttacker', 0), ],
        '// 724. GetLastCombatFeatUsed\r\n// Returns the last feat used (as a feat number that indexes the Feats.2da) by the given object\r\nint GetLastCombatFeatUsed(object oAttacker  =  OBJECT_SELF);',
        '// 724. GetLastCombatFeatUsed\r\n// Returns the last feat used (as a feat number that indexes the Feats.2da) by the given object\r\nint GetLastCombatFeatUsed(object oAttacker  =  OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastAttackResult',
        [ScriptParam(DataType.OBJECT, 'oAttacker', 0), ],
        '// 725. GetLastAttackResult\r\n// Returns the result of the last attack\r\nint GetLastAttackResult(object oAttacker  =  OBJECT_SELF);',
        '// 725. GetLastAttackResult\r\n// Returns the result of the last attack\r\nint GetLastAttackResult(object oAttacker  =  OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetWasForcePowerSuccessful',
        [ScriptParam(DataType.OBJECT, 'oAttacker', 0), ],
        '// 726. GetWasForcePowerSuccessful\r\n// Returns whether the last force power used was successful or not\r\nint GetWasForcePowerSuccessful(object oAttacker  =  OBJECT_SELF);',
        '// 726. GetWasForcePowerSuccessful\r\n// Returns whether the last force power used was successful or not\r\nint GetWasForcePowerSuccessful(object oAttacker  =  OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFirstAttacker',
        [ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        '// 727. GetFirstAttacker\r\n// Returns the first object in the area that is attacking oCreature\r\nobject GetFirstAttacker(object oCreature  =  OBJECT_SELF);',
        '// 727. GetFirstAttacker\r\n// Returns the first object in the area that is attacking oCreature\r\nobject GetFirstAttacker(object oCreature  =  OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNextAttacker',
        [ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        '// 728. GetNextAttacker\r\n// Returns the next object in the area that is attacking oCreature\r\nobject GetNextAttacker(object oCreature  =  OBJECT_SELF);',
        '// 728. GetNextAttacker\r\n// Returns the next object in the area that is attacking oCreature\r\nobject GetNextAttacker(object oCreature  =  OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetFormation',
        [ScriptParam(DataType.OBJECT, 'oAnchor', None), ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nFormationPattern', None), ScriptParam(DataType.INT, 'nPosition', None), ],
        '// 729. SetFormation\r\n// Put oCreature into the nFormationPattern about oAnchor at position nPosition\r\n// - oAnchor: The formation is set relative to this object\r\n// - oCreature: This is the creature that you wish to join the formation\r\n// - nFormationPattern: FORMATION_*\r\n// - nPosition: Integer from 1 to 10 to specify which position in the formation\r\n//   oCreature is supposed to take.\r\nvoid SetFormation(object oAnchor, object oCreature, int nFormationPattern, int nPosition);',
        '// 729. SetFormation\r\n// Put oCreature into the nFormationPattern about oAnchor at position nPosition\r\n// - oAnchor: The formation is set relative to this object\r\n// - oCreature: This is the creature that you wish to join the formation\r\n// - nFormationPattern: FORMATION_*\r\n// - nPosition: Integer from 1 to 10 to specify which position in the formation\r\n//   oCreature is supposed to take.\r\nvoid SetFormation(object oAnchor, object oCreature, int nFormationPattern, int nPosition);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionFollowLeader',
        [],
        '// 730. ActionFollowLeader\r\n// this action has a party member follow the leader.\r\n// DO NOT USE ON A CREATURE THAT IS NOT IN THE PARTY!!\r\nvoid ActionFollowLeader();',
        '// 730. ActionFollowLeader\r\n// this action has a party member follow the leader.\r\n// DO NOT USE ON A CREATURE THAT IS NOT IN THE PARTY!!\r\nvoid ActionFollowLeader();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetForcePowerUnsuccessful',
        [ScriptParam(DataType.INT, 'nResult', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        '// 731. SetForcePowerUnsuccessful\r\n// Sets the reason (through a constant) for why a force power failed\r\nvoid SetForcePowerUnsuccessful(int nResult, object oCreature  =  OBJECT_SELF);',
        '// 731. SetForcePowerUnsuccessful\r\n// Sets the reason (through a constant) for why a force power failed\r\nvoid SetForcePowerUnsuccessful(int nResult, object oCreature  =  OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsDebilitated',
        [ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        '// 732. GetIsDebilitated\r\n// Returns whether the given object is debilitated or not\r\nint GetIsDebilitated(object oCreature  =  OBJECT_SELF);',
        '// 732. GetIsDebilitated\r\n// Returns whether the given object is debilitated or not\r\nint GetIsDebilitated(object oCreature  =  OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PlayMovie',
        [ScriptParam(DataType.STRING, 'sMovie', None), ],
        '// 733. PlayMovie\r\n// Playes a Movie.\r\nvoid PlayMovie( string sMovie );',
        '// 733. PlayMovie\r\n// Playes a Movie.\r\nvoid PlayMovie( string sMovie );'
    ),
    ScriptFunction(
        DataType.VOID,
        'SaveNPCState',
        [ScriptParam(DataType.INT, 'nNPC', None), ],
        '// 734. SaveNPCState\r\n// Tells the party table to save the state of a party member NPC\r\nvoid SaveNPCState( int nNPC );',
        '// 734. SaveNPCState\r\n// Tells the party table to save the state of a party member NPC\r\nvoid SaveNPCState( int nNPC );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetCategoryFromTalent',
        [ScriptParam(DataType.TALENT, 'tTalent', None), ],
        '// 735: Get the Category of tTalent.\r\nint GetCategoryFromTalent(talent tTalent);',
        '// 735: Get the Category of tTalent.\r\nint GetCategoryFromTalent(talent tTalent);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SurrenderByFaction',
        [ScriptParam(DataType.INT, 'nFactionFrom', None), ScriptParam(DataType.INT, 'nFactionTo', None), ],
        '// 736: This affects all creatures in the area that are in faction nFactionFrom...\r\n// - Makes them join nFactionTo\r\n// - Clears all actions\r\n// - Disables combat mode\r\nvoid SurrenderByFaction(int nFactionFrom, int nFactionTo);',
        '// 736: This affects all creatures in the area that are in faction nFactionFrom...\r\n// - Makes them join nFactionTo\r\n// - Clears all actions\r\n// - Disables combat mode\r\nvoid SurrenderByFaction(int nFactionFrom, int nFactionTo);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ChangeFactionByFaction',
        [ScriptParam(DataType.INT, 'nFactionFrom', None), ScriptParam(DataType.INT, 'nFactionTo', None), ],
        '// 737: This affects all creatures in the area that are in faction nFactionFrom.\r\n// making them change to nFactionTo\r\nvoid ChangeFactionByFaction(int nFactionFrom, int nFactionTo);',
        '// 737: This affects all creatures in the area that are in faction nFactionFrom.\r\n// making them change to nFactionTo\r\nvoid ChangeFactionByFaction(int nFactionFrom, int nFactionTo);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PlayRoomAnimation',
        [ScriptParam(DataType.STRING, 'sRoom', None), ScriptParam(DataType.INT, 'nAnimation', None), ],
        '// 738: PlayRoomAnimation\r\n// Plays a looping animation on a room\r\nvoid PlayRoomAnimation(string sRoom, int nAnimation);',
        '// 738: PlayRoomAnimation\r\n// Plays a looping animation on a room\r\nvoid PlayRoomAnimation(string sRoom, int nAnimation);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ShowGalaxyMap',
        [ScriptParam(DataType.INT, 'nPlanet', None), ],
        "// 739: ShowGalaxyMap\r\n// Brings up the Galaxy Map Gui, with 'nPlanet' selected.  'nPlanet' can only be a planet\r\n// that has already been set available and selectable.\r\nvoid ShowGalaxyMap(int nPlanet);",
        "// 739: ShowGalaxyMap\r\n// Brings up the Galaxy Map Gui, with 'nPlanet' selected.  'nPlanet' can only be a planet\r\n// that has already been set available and selectable.\r\nvoid ShowGalaxyMap(int nPlanet);"
    ),
    ScriptFunction(
        DataType.VOID,
        'SetPlanetSelectable',
        [ScriptParam(DataType.INT, 'nPlanet', None), ScriptParam(DataType.INT, 'bSelectable', None), ],
        "// 740: SetPlanetSelectable\r\n// Sets 'nPlanet' selectable on the Galaxy Map Gui.\r\nvoid SetPlanetSelectable(int nPlanet, int bSelectable);",
        "// 740: SetPlanetSelectable\r\n// Sets 'nPlanet' selectable on the Galaxy Map Gui.\r\nvoid SetPlanetSelectable(int nPlanet, int bSelectable);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetPlanetSelectable',
        [ScriptParam(DataType.INT, 'nPlanet', None), ],
        "// 741: GetPlanetSelectable\r\n// Returns wheter or not 'nPlanet' is selectable.\r\nint GetPlanetSelectable(int nPlanet);",
        "// 741: GetPlanetSelectable\r\n// Returns wheter or not 'nPlanet' is selectable.\r\nint GetPlanetSelectable(int nPlanet);"
    ),
    ScriptFunction(
        DataType.VOID,
        'SetPlanetAvailable',
        [ScriptParam(DataType.INT, 'nPlanet', None), ScriptParam(DataType.INT, 'bAvailable', None), ],
        "// 742: SetPlanetAvailable\r\n// Sets 'nPlanet' available on the Galaxy Map Gui.\r\nvoid SetPlanetAvailable(int nPlanet, int bAvailable);",
        "// 742: SetPlanetAvailable\r\n// Sets 'nPlanet' available on the Galaxy Map Gui.\r\nvoid SetPlanetAvailable(int nPlanet, int bAvailable);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetPlanetAvailable',
        [ScriptParam(DataType.INT, 'nPlanet', None), ],
        "// 743: GetPlanetAvailable\r\n// Returns wheter or not 'nPlanet' is available.\r\nint GetPlanetAvailable(int nPlanet);",
        "// 743: GetPlanetAvailable\r\n// Returns wheter or not 'nPlanet' is available.\r\nint GetPlanetAvailable(int nPlanet);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetSelectedPlanet',
        [],
        '// 744: GetSelectedPlanet\r\n// Returns the ID of the currently selected planet.  Check Planetary.2da\r\n// for which planet the return value corresponds to. If the return is -1\r\n// no planet is selected.\r\nint GetSelectedPlanet();',
        '// 744: GetSelectedPlanet\r\n// Returns the ID of the currently selected planet.  Check Planetary.2da\r\n// for which planet the return value corresponds to. If the return is -1\r\n// no planet is selected.\r\nint GetSelectedPlanet();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SoundObjectFadeAndStop',
        [ScriptParam(DataType.OBJECT, 'oSound', None), ScriptParam(DataType.FLOAT, 'fSeconds', None), ],
        "// 745: SoundObjectFadeAndStop\r\n// Fades a sound object for 'fSeconds' and then stops it.\r\nvoid SoundObjectFadeAndStop(object oSound,float fSeconds);",
        "// 745: SoundObjectFadeAndStop\r\n// Fades a sound object for 'fSeconds' and then stops it.\r\nvoid SoundObjectFadeAndStop(object oSound,float fSeconds);"
    ),
    ScriptFunction(
        DataType.VOID,
        'SetAreaFogColor',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.FLOAT, 'fRed', None), ScriptParam(DataType.FLOAT, 'fGreen', None), ScriptParam(DataType.FLOAT, 'fBlue', None), ],
        '// 746: SetAreaFogColor\r\n// Set the fog color for the area oArea.\r\nvoid SetAreaFogColor( object oArea, float fRed, float fGreen, float fBlue );',
        '// 746: SetAreaFogColor\r\n// Set the fog color for the area oArea.\r\nvoid SetAreaFogColor( object oArea, float fRed, float fGreen, float fBlue );'
    ),
    ScriptFunction(
        DataType.VOID,
        'ChangeItemCost',
        [ScriptParam(DataType.STRING, 'sItem', None), ScriptParam(DataType.FLOAT, 'fCostMultiplier', None), ],
        '// 747: ChangeItemCost\r\n// Change the cost of an item\r\nvoid ChangeItemCost( string sItem, float fCostMultiplier );',
        '// 747: ChangeItemCost\r\n// Change the cost of an item\r\nvoid ChangeItemCost( string sItem, float fCostMultiplier );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsLiveContentAvailable',
        [ScriptParam(DataType.INT, 'nPkg', None), ],
        '// 748: GetIsLiveContentAvailable\r\n// Determines whether a given live content package is available\r\n// nPkg  =  LIVE_CONTENT_PKG1, LIVE_CONTENT_PKG2, ..., LIVE_CONTENT_PKG6\r\nint GetIsLiveContentAvailable(int nPkg);',
        '// 748: GetIsLiveContentAvailable\r\n// Determines whether a given live content package is available\r\n// nPkg  =  LIVE_CONTENT_PKG1, LIVE_CONTENT_PKG2, ..., LIVE_CONTENT_PKG6\r\nint GetIsLiveContentAvailable(int nPkg);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ResetDialogState',
        [],
        '// 749: ResetDialogState\r\n// Resets the GlobalDialogState for the engine.\r\n// NOTE: NEVER USE THIS UNLESS YOU KNOW WHAT ITS FOR!\r\n//       only to be used for a failing OnDialog script\r\nvoid ResetDialogState();',
        '// 749: ResetDialogState\r\n// Resets the GlobalDialogState for the engine.\r\n// NOTE: NEVER USE THIS UNLESS YOU KNOW WHAT ITS FOR!\r\n//       only to be used for a failing OnDialog script\r\nvoid ResetDialogState();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetGoodEvilValue',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nAlignment', None), ],
        "// 750: SetAlignmentGoodEvil\r\n// Set oCreature's alignment value\r\nvoid SetGoodEvilValue( object oCreature, int nAlignment );",
        "// 750: SetAlignmentGoodEvil\r\n// Set oCreature's alignment value\r\nvoid SetGoodEvilValue( object oCreature, int nAlignment );"
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsPoisoned',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 751: GetIsPoisoned\r\n// Returns TRUE if the object specified is poisoned.\r\nint GetIsPoisoned( object oObject );',
        '// 751: GetIsPoisoned\r\n// Returns TRUE if the object specified is poisoned.\r\nint GetIsPoisoned( object oObject );'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetSpellTarget',
        [ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        '// 752: GetSpellTarget\r\n// Returns the object id of the spell target\r\nobject GetSpellTarget(object oCreature = OBJECT_SELF);',
        '// 752: GetSpellTarget\r\n// Returns the object id of the spell target\r\nobject GetSpellTarget(object oCreature = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetSoloMode',
        [ScriptParam(DataType.INT, 'bActivate', None), ],
        "// 753: SetSoloMode\r\n// Activates/Deactivates solo mode for the player's party.\r\nvoid SetSoloMode( int bActivate );",
        "// 753: SetSoloMode\r\n// Activates/Deactivates solo mode for the player's party.\r\nvoid SetSoloMode( int bActivate );"
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectCutSceneHorrified',
        [],
        '// 754: EffectCutSceneHorrified\r\n// Get a horrified effect for cutscene purposes (ie. this effect will ignore immunities).\r\neffect EffectCutSceneHorrified();',
        '// 754: EffectCutSceneHorrified\r\n// Get a horrified effect for cutscene purposes (ie. this effect will ignore immunities).\r\neffect EffectCutSceneHorrified();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectCutSceneParalyze',
        [],
        '// 755: EffectCutSceneParalyze\r\n// Get a paralyze effect for cutscene purposes (ie. this effect will ignore immunities).\r\neffect EffectCutSceneParalyze();',
        '// 755: EffectCutSceneParalyze\r\n// Get a paralyze effect for cutscene purposes (ie. this effect will ignore immunities).\r\neffect EffectCutSceneParalyze();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectCutSceneStunned',
        [],
        '// 756: EffectCutSceneStunned\r\n// Get a stun effect for cutscene purposes (ie. this effect will ignore immunities).\r\neffect EffectCutSceneStunned();',
        '// 756: EffectCutSceneStunned\r\n// Get a stun effect for cutscene purposes (ie. this effect will ignore immunities).\r\neffect EffectCutSceneStunned();'
    ),
    ScriptFunction(
        DataType.VOID,
        'CancelPostDialogCharacterSwitch',
        [],
        '// 757: CancelPostDialogCharacterSwitch()\r\n// If a dialog has been started by an NPC on a Non PartyMemeberCanInteract object\r\n// calling this function will cancel the Post Dialog switching back to the NPC\r\n// that did the initiating.\r\nvoid CancelPostDialogCharacterSwitch();',
        '// 757: CancelPostDialogCharacterSwitch()\r\n// If a dialog has been started by an NPC on a Non PartyMemeberCanInteract object\r\n// calling this function will cancel the Post Dialog switching back to the NPC\r\n// that did the initiating.\r\nvoid CancelPostDialogCharacterSwitch();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetMaxHitPoints',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.INT, 'nMaxHP', None), ],
        '// 758: SetMaxHitPoints\r\n// Set the maximum hitpoints of oObject\r\n// The objects maximum AND current hitpoints will be nMaxHP after the function is called\r\nvoid SetMaxHitPoints(object oObject, int nMaxHP);',
        '// 758: SetMaxHitPoints\r\n// Set the maximum hitpoints of oObject\r\n// The objects maximum AND current hitpoints will be nMaxHP after the function is called\r\nvoid SetMaxHitPoints(object oObject, int nMaxHP);'
    ),
    ScriptFunction(
        DataType.VOID,
        'NoClicksFor',
        [ScriptParam(DataType.FLOAT, 'fDuration', None), ],
        "// 759: NoClicksFor()\r\n// This command will not allow clicking on anything for 'fDuration' seconds\r\nvoid NoClicksFor(float fDuration);",
        "// 759: NoClicksFor()\r\n// This command will not allow clicking on anything for 'fDuration' seconds\r\nvoid NoClicksFor(float fDuration);"
    ),
    ScriptFunction(
        DataType.VOID,
        'HoldWorldFadeInForDialog',
        [],
        '// 760: HoldWorldFadeInForDialog()\r\n// This will hold the fade in at the begining of a module until a dialog starts\r\nvoid HoldWorldFadeInForDialog();',
        '// 760: HoldWorldFadeInForDialog()\r\n// This will hold the fade in at the begining of a module until a dialog starts\r\nvoid HoldWorldFadeInForDialog();'
    ),
    ScriptFunction(
        DataType.INT,
        'ShipBuild',
        [],
        '// 761: ShipBuild()\r\n// This will return if this is a shipping build. this should be used to disable all debug output.\r\nint ShipBuild();',
        '// 761: ShipBuild()\r\n// This will return if this is a shipping build. this should be used to disable all debug output.\r\nint ShipBuild();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SurrenderRetainBuffs',
        [],
        '// 762: SurrenderRetainBuffs()\r\n// This will do the same as SurrenderToEnemies, except that affected creatures will not\r\n// lose effects which they have put on themselves\r\nvoid SurrenderRetainBuffs();',
        '// 762: SurrenderRetainBuffs()\r\n// This will do the same as SurrenderToEnemies, except that affected creatures will not\r\n// lose effects which they have put on themselves\r\nvoid SurrenderRetainBuffs();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SuppressStatusSummaryEntry',
        [ScriptParam(DataType.INT, 'nNumEntries', 1), ],
        '// 763. SuppressStatusSummaryEntry\r\n// This will prevent the next n entries that should have shown up in the status summary\r\n// from being added\r\n// This will not add on to any existing summary suppressions, but rather replace it.  So\r\n// to clear the supression system pass 0 as the entry value\r\nvoid SuppressStatusSummaryEntry(int nNumEntries  =  1);',
        '// 763. SuppressStatusSummaryEntry\r\n// This will prevent the next n entries that should have shown up in the status summary\r\n// from being added\r\n// This will not add on to any existing summary suppressions, but rather replace it.  So\r\n// to clear the supression system pass 0 as the entry value\r\nvoid SuppressStatusSummaryEntry(int nNumEntries  =  1);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetCheatCode',
        [ScriptParam(DataType.INT, 'nCode', None), ],
        '// 764. GetCheatCode\r\n// Returns true if cheat code has been enabled\r\nint GetCheatCode(int nCode);',
        '// 764. GetCheatCode\r\n// Returns true if cheat code has been enabled\r\nint GetCheatCode(int nCode);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetMusicVolume',
        [ScriptParam(DataType.FLOAT, 'fVolume', 1.0), ],
        '// 765. SetMusicVolume\r\n// NEVER USE THIS!\r\nvoid SetMusicVolume(float fVolume  =  1.0f);',
        '// 765. SetMusicVolume\r\n// NEVER USE THIS!\r\nvoid SetMusicVolume(float fVolume  =  1.0f);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'CreateItemOnFloor',
        [ScriptParam(DataType.STRING, 'sTemplate', None), ScriptParam(DataType.LOCATION, 'lLocation', None), ScriptParam(DataType.INT, 'bUseAppearAnimation', 0), ],
        '// 766. CreateItemOnFloor\r\n// Should only be used for items that have been created on the ground, and will\r\n// be destroyed without ever being picked up or equipped.  Returns true if successful\r\nobject CreateItemOnFloor(string sTemplate, location lLocation, int bUseAppearAnimation = FALSE);',
        '// 766. CreateItemOnFloor\r\n// Should only be used for items that have been created on the ground, and will\r\n// be destroyed without ever being picked up or equipped.  Returns true if successful\r\nobject CreateItemOnFloor(string sTemplate, location lLocation, int bUseAppearAnimation = FALSE);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetAvailableNPCId',
        [ScriptParam(DataType.INT, 'nNPC', None), ScriptParam(DataType.INT, 'oidNPC', None), ],
        '// 767. SetAvailableNPCId\r\n// This will set the object id that should be used for a specific available NPC\r\nvoid SetAvailableNPCId(INT nNPC, OBJECT_ID oidNPC);',
        '// 767. SetAvailableNPCId\r\n// This will set the object id that should be used for a specific available NPC\r\nvoid SetAvailableNPCId(INT nNPC, OBJECT_ID oidNPC);'
    ),
    ScriptFunction(
        DataType.INT,
        'IsMoviePlaying',
        [],
        '// 768. IsMoviePlaying\r\n// Checks if a movie is currently playing.\r\nint IsMoviePlaying();',
        '// 768. IsMoviePlaying\r\n// Checks if a movie is currently playing.\r\nint IsMoviePlaying();'
    ),
    ScriptFunction(
        DataType.VOID,
        'QueueMovie',
        [ScriptParam(DataType.STRING, 'sMovie', None), ScriptParam(DataType.INT, 'bSkippable', None), ],
        '// 769. QueueMovie\r\n// Queues up a movie to be played using PlayMovieQueue.\r\n// If bSkippable is TRUE, the player can cancel the movie by hitting escape.\r\n// If bSkippable is FALSE, the player cannot cancel the movie and must wait\r\n// for it to finish playing.\r\nvoid QueueMovie( string sMovie, int bSkippable );',
        '// 769. QueueMovie\r\n// Queues up a movie to be played using PlayMovieQueue.\r\n// If bSkippable is TRUE, the player can cancel the movie by hitting escape.\r\n// If bSkippable is FALSE, the player cannot cancel the movie and must wait\r\n// for it to finish playing.\r\nvoid QueueMovie( string sMovie, int bSkippable );'
    ),
    ScriptFunction(
        DataType.VOID,
        'PlayMovieQueue',
        [ScriptParam(DataType.INT, 'bAllowSeparateSkips', None), ],
        '// 770. PlayMovieQueue\r\n// Plays the movies that have been added to the queue by QueueMovie\r\n// If bAllowSeparateSkips is TRUE, hitting escape to cancel a movie only\r\n// cancels out of the currently playing movie rather than the entire queue\r\n// of movies (assuming the currently playing movie is flagged as skippable).\r\n// If bAllowSeparateSkips is FALSE, the entire movie queue will be cancelled\r\n// if the player hits escape (assuming the currently playing movie is flagged\r\n// as skippable).\r\nvoid PlayMovieQueue( int bAllowSeparateSkips );',
        '// 770. PlayMovieQueue\r\n// Plays the movies that have been added to the queue by QueueMovie\r\n// If bAllowSeparateSkips is TRUE, hitting escape to cancel a movie only\r\n// cancels out of the currently playing movie rather than the entire queue\r\n// of movies (assuming the currently playing movie is flagged as skippable).\r\n// If bAllowSeparateSkips is FALSE, the entire movie queue will be cancelled\r\n// if the player hits escape (assuming the currently playing movie is flagged\r\n// as skippable).\r\nvoid PlayMovieQueue( int bAllowSeparateSkips );'
    ),
    ScriptFunction(
        DataType.VOID,
        'YavinHackCloseDoor',
        [ScriptParam(DataType.OBJECT, 'oidDoor', None), ],
        "// 771. YavinHackCloseDoor\r\n// This is an incredibly hacky function to allow the doors to be properly\r\n// closed on Yavin without running into the problems we've had.  It is too\r\n// late in development to fix it correctly, so thus we do this.  Life is\r\n// hard.  You'll get over it\r\nvoid YavinHackCloseDoor( object oidDoor );",
        "// 771. YavinHackCloseDoor\r\n// This is an incredibly hacky function to allow the doors to be properly\r\n// closed on Yavin without running into the problems we've had.  It is too\r\n// late in development to fix it correctly, so thus we do this.  Life is\r\n// hard.  You'll get over it\r\nvoid YavinHackCloseDoor( object oidDoor );"
    ),
]

TSL_FUNCTIONS = [
    ScriptFunction(
        DataType.INT,
        'Random',
        [ScriptParam(DataType.INT, 'nMaxInteger', None), ],
        '// 0: Get an integer between 0 and nMaxInteger-1.\r\n// Return value on error: 0\r\nint Random(int nMaxInteger);',
        '// 0: Get an integer between 0 and nMaxInteger-1.\r\n// Return value on error: 0\r\nint Random(int nMaxInteger);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PrintString',
        [ScriptParam(DataType.STRING, 'sString', None), ],
        '// 1: Output sString to the log file.\r\nvoid PrintString(string sString);',
        '// 1: Output sString to the log file.\r\nvoid PrintString(string sString);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PrintFloat',
        [ScriptParam(DataType.FLOAT, 'fFloat', None), ScriptParam(DataType.INT, 'nWidth', 18), ScriptParam(DataType.INT, 'nDecimals', 9), ],
        '// 2: Output a formatted float to the log file.\r\n// - nWidth should be a value from 0 to 18 inclusive.\r\n// - nDecimals should be a value from 0 to 9 inclusive.\r\nvoid PrintFloat(float fFloat, int nWidth = 18, int nDecimals = 9);',
        '// 2: Output a formatted float to the log file.\r\n// - nWidth should be a value from 0 to 18 inclusive.\r\n// - nDecimals should be a value from 0 to 9 inclusive.\r\nvoid PrintFloat(float fFloat, int nWidth = 18, int nDecimals = 9);'
    ),
    ScriptFunction(
        DataType.STRING,
        'FloatToString',
        [ScriptParam(DataType.FLOAT, 'fFloat', None), ScriptParam(DataType.INT, 'nWidth', 18), ScriptParam(DataType.INT, 'nDecimals', 9), ],
        '// 3: Convert fFloat into a string.\r\n// - nWidth should be a value from 0 to 18 inclusive.\r\n// - nDecimals should be a value from 0 to 9 inclusive.\r\nstring FloatToString(float fFloat, int nWidth = 18, int nDecimals = 9);',
        '// 3: Convert fFloat into a string.\r\n// - nWidth should be a value from 0 to 18 inclusive.\r\n// - nDecimals should be a value from 0 to 9 inclusive.\r\nstring FloatToString(float fFloat, int nWidth = 18, int nDecimals = 9);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PrintInteger',
        [ScriptParam(DataType.INT, 'nInteger', None), ],
        '// 4: Output nInteger to the log file.\r\nvoid PrintInteger(int nInteger);',
        '// 4: Output nInteger to the log file.\r\nvoid PrintInteger(int nInteger);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PrintObject',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        "// 5: Output oObject's ID to the log file.\r\nvoid PrintObject(object oObject);",
        "// 5: Output oObject's ID to the log file.\r\nvoid PrintObject(object oObject);"
    ),
    ScriptFunction(
        DataType.VOID,
        'AssignCommand',
        [ScriptParam(DataType.OBJECT, 'oActionSubject', None), ScriptParam(DataType.ACTION, 'aActionToAssign', None), ],
        '// 6: Assign aActionToAssign to oActionSubject.\r\n// * No return value, but if an error occurs, the log file will contain\r\n//   "AssignCommand failed."\r\n//   (If the object doesn\'t exist, nothing happens.)\r\nvoid AssignCommand(object oActionSubject,action aActionToAssign);',
        '// 6: Assign aActionToAssign to oActionSubject.\r\n// * No return value, but if an error occurs, the log file will contain\r\n//   "AssignCommand failed."\r\n//   (If the object doesn\'t exist, nothing happens.)\r\nvoid AssignCommand(object oActionSubject,action aActionToAssign);'
    ),
    ScriptFunction(
        DataType.VOID,
        'DelayCommand',
        [ScriptParam(DataType.FLOAT, 'fSeconds', None), ScriptParam(DataType.ACTION, 'aActionToDelay', None), ],
        '// 7: Delay aActionToDelay by fSeconds.\r\n// * No return value, but if an error occurs, the log file will contain\r\n//   "DelayCommand failed.".\r\nvoid DelayCommand(float fSeconds, action aActionToDelay);',
        '// 7: Delay aActionToDelay by fSeconds.\r\n// * No return value, but if an error occurs, the log file will contain\r\n//   "DelayCommand failed.".\r\nvoid DelayCommand(float fSeconds, action aActionToDelay);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ExecuteScript',
        [ScriptParam(DataType.STRING, 'sScript', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'nScriptVar', -1), ],
        '// 8: Make oTarget run sScript and then return execution to the calling script.\r\n// If sScript does not specify a compiled script, nothing happens.\r\n// - nScriptVar: This value will be returned by calls to GetRunScriptVar.\r\nvoid ExecuteScript(string sScript, object oTarget, int nScriptVar = -1);',
        '// 8: Make oTarget run sScript and then return execution to the calling script.\r\n// If sScript does not specify a compiled script, nothing happens.\r\n// - nScriptVar: This value will be returned by calls to GetRunScriptVar.\r\nvoid ExecuteScript(string sScript, object oTarget, int nScriptVar = -1);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ClearAllActions',
        [],
        '// 9: Clear all the actions of the caller. (This will only work on Creatures)\r\n// * No return value, but if an error occurs, the log file will contain\r\n//   "ClearAllActions failed.".\r\nvoid ClearAllActions();',
        '// 9: Clear all the actions of the caller. (This will only work on Creatures)\r\n// * No return value, but if an error occurs, the log file will contain\r\n//   "ClearAllActions failed.".\r\nvoid ClearAllActions();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetFacing',
        [ScriptParam(DataType.FLOAT, 'fDirection', None), ],
        '// 10: Cause the caller to face fDirection.\r\n// - fDirection is expressed as anticlockwise degrees from Due East.\r\n//   DIRECTION_EAST, DIRECTION_NORTH, DIRECTION_WEST and DIRECTION_SOUTH are\r\n//   predefined. (0.0f = East, 90.0f = North, 180.0f = West, 270.0f = South)\r\nvoid SetFacing(float fDirection);',
        '// 10: Cause the caller to face fDirection.\r\n// - fDirection is expressed as anticlockwise degrees from Due East.\r\n//   DIRECTION_EAST, DIRECTION_NORTH, DIRECTION_WEST and DIRECTION_SOUTH are\r\n//   predefined. (0.0f = East, 90.0f = North, 180.0f = West, 270.0f = South)\r\nvoid SetFacing(float fDirection);'
    ),
    ScriptFunction(
        DataType.INT,
        'SwitchPlayerCharacter',
        [ScriptParam(DataType.INT, 'nNPC', None), ],
        '// 11: Switches the main character to a specified NPC\r\n//     -1 specifies to switch back to the original PC\r\nint SwitchPlayerCharacter(int nNPC);',
        '// 11: Switches the main character to a specified NPC\r\n//     -1 specifies to switch back to the original PC\r\nint SwitchPlayerCharacter(int nNPC);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetTime',
        [ScriptParam(DataType.INT, 'nHour', None), ScriptParam(DataType.INT, 'nMinute', None), ScriptParam(DataType.INT, 'nSecond', None), ScriptParam(DataType.INT, 'nMillisecond', None), ],
        '// 12: Set the time to the time specified.\r\n// - nHour should be from 0 to 23 inclusive\r\n// - nMinute should be from 0 to 59 inclusive\r\n// - nSecond should be from 0 to 59 inclusive\r\n// - nMillisecond should be from 0 to 999 inclusive\r\n// 1) Time can only be advanced forwards; attempting to set the time backwards\r\n//    will result in the day advancing and then the time being set to that\r\n//    specified, e.g. if the current hour is 15 and then the hour is set to 3,\r\n//    the day will be advanced by 1 and the hour will be set to 3.\r\n// 2) If values larger than the max hour, minute, second or millisecond are\r\n//    specified, they will be wrapped around and the overflow will be used to\r\n//    advance the next field, e.g. specifying 62 hours, 250 minutes, 10 seconds\r\n//    and 10 milliseconds will result in the calendar day being advanced by 2\r\n//    and the time being set to 18 hours, 10 minutes, 10 milliseconds.\r\nvoid SetTime(int nHour,int nMinute,int nSecond,int nMillisecond);',
        '// 12: Set the time to the time specified.\r\n// - nHour should be from 0 to 23 inclusive\r\n// - nMinute should be from 0 to 59 inclusive\r\n// - nSecond should be from 0 to 59 inclusive\r\n// - nMillisecond should be from 0 to 999 inclusive\r\n// 1) Time can only be advanced forwards; attempting to set the time backwards\r\n//    will result in the day advancing and then the time being set to that\r\n//    specified, e.g. if the current hour is 15 and then the hour is set to 3,\r\n//    the day will be advanced by 1 and the hour will be set to 3.\r\n// 2) If values larger than the max hour, minute, second or millisecond are\r\n//    specified, they will be wrapped around and the overflow will be used to\r\n//    advance the next field, e.g. specifying 62 hours, 250 minutes, 10 seconds\r\n//    and 10 milliseconds will result in the calendar day being advanced by 2\r\n//    and the time being set to 18 hours, 10 minutes, 10 milliseconds.\r\nvoid SetTime(int nHour,int nMinute,int nSecond,int nMillisecond);'
    ),
    ScriptFunction(
        DataType.INT,
        'SetPartyLeader',
        [ScriptParam(DataType.INT, 'nNPC', None), ],
        '// 13: Sets (by NPC constant) which party member should be the controlled\r\n//     character\r\nint SetPartyLeader(int nNPC);',
        '// 13: Sets (by NPC constant) which party member should be the controlled\r\n//     character\r\nint SetPartyLeader(int nNPC);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetAreaUnescapable',
        [ScriptParam(DataType.INT, 'bUnescapable', None), ],
        '// 14: Sets whether the current area is escapable or not\r\n// TRUE means you can not escape the area\r\n// FALSE means you can escape the area\r\nvoid SetAreaUnescapable(int bUnescapable);',
        '// 14: Sets whether the current area is escapable or not\r\n// TRUE means you can not escape the area\r\n// FALSE means you can escape the area\r\nvoid SetAreaUnescapable(int bUnescapable);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetAreaUnescapable',
        [],
        '// 15: Returns whether the current area is escapable or not\r\n// TRUE means you can not escape the area\r\n// FALSE means you can escape the area\r\nint GetAreaUnescapable();',
        '// 15: Returns whether the current area is escapable or not\r\n// TRUE means you can not escape the area\r\n// FALSE means you can escape the area\r\nint GetAreaUnescapable();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTimeHour',
        [],
        '// 16: Get the current hour.\r\nint GetTimeHour();',
        '// 16: Get the current hour.\r\nint GetTimeHour();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTimeMinute',
        [],
        '// 17: Get the current minute\r\nint GetTimeMinute();',
        '// 17: Get the current minute\r\nint GetTimeMinute();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTimeSecond',
        [],
        '// 18: Get the current second\r\nint GetTimeSecond();',
        '// 18: Get the current second\r\nint GetTimeSecond();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTimeMillisecond',
        [],
        '// 19: Get the current millisecond\r\nint GetTimeMillisecond();',
        '// 19: Get the current millisecond\r\nint GetTimeMillisecond();'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionRandomWalk',
        [],
        '// 20: The action subject will generate a random location near its current location\r\n// and pathfind to it.  All commands will remove a RandomWalk() from the action\r\n// queue if there is one in place.\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionRandomWalk failed."\r\nvoid ActionRandomWalk();',
        '// 20: The action subject will generate a random location near its current location\r\n// and pathfind to it.  All commands will remove a RandomWalk() from the action\r\n// queue if there is one in place.\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionRandomWalk failed."\r\nvoid ActionRandomWalk();'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionMoveToLocation',
        [ScriptParam(DataType.LOCATION, 'lDestination', None), ScriptParam(DataType.INT, 'bRun', 0), ],
        '// 21: The action subject will move to lDestination.\r\n// - lDestination: The object will move to this location.  If the location is\r\n//   invalid or a path cannot be found to it, the command does nothing.\r\n// - bRun: If this is TRUE, the action subject will run rather than walk\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "MoveToPoint failed."\r\nvoid ActionMoveToLocation(location lDestination, int bRun = FALSE);',
        '// 21: The action subject will move to lDestination.\r\n// - lDestination: The object will move to this location.  If the location is\r\n//   invalid or a path cannot be found to it, the command does nothing.\r\n// - bRun: If this is TRUE, the action subject will run rather than walk\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "MoveToPoint failed."\r\nvoid ActionMoveToLocation(location lDestination, int bRun = FALSE);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionMoveToObject',
        [ScriptParam(DataType.OBJECT, 'oMoveTo', None), ScriptParam(DataType.INT, 'bRun', 0), ScriptParam(DataType.FLOAT, 'fRange', 1.0), ],
        '// 22: Cause the action subject to move to a certain distance from oMoveTo.\r\n// If there is no path to oMoveTo, this command will do nothing.\r\n// - oMoveTo: This is the object we wish the action subject to move to\r\n// - bRun: If this is TRUE, the action subject will run rather than walk\r\n// - fRange: This is the desired distance between the action subject and oMoveTo\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionMoveToObject failed."\r\nvoid ActionMoveToObject(object oMoveTo, int bRun = FALSE, float fRange = 1.0f);',
        '// 22: Cause the action subject to move to a certain distance from oMoveTo.\r\n// If there is no path to oMoveTo, this command will do nothing.\r\n// - oMoveTo: This is the object we wish the action subject to move to\r\n// - bRun: If this is TRUE, the action subject will run rather than walk\r\n// - fRange: This is the desired distance between the action subject and oMoveTo\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionMoveToObject failed."\r\nvoid ActionMoveToObject(object oMoveTo, int bRun = FALSE, float fRange = 1.0f);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionMoveAwayFromObject',
        [ScriptParam(DataType.OBJECT, 'oFleeFrom', None), ScriptParam(DataType.INT, 'bRun', 0), ScriptParam(DataType.FLOAT, 'fMoveAwayRange', 40.0), ],
        '// 23: Cause the action subject to move to a certain distance away from oFleeFrom.\r\n// - oFleeFrom: This is the object we wish the action subject to move away from.\r\n//   If oFleeFrom is not in the same area as the action subject, nothing will\r\n//   happen.\r\n// - bRun: If this is TRUE, the action subject will run rather than walk\r\n// - fMoveAwayRange: This is the distance we wish the action subject to put\r\n//   between themselves and oFleeFrom\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionMoveAwayFromObject failed."\r\nvoid ActionMoveAwayFromObject(object oFleeFrom, int bRun = FALSE, float fMoveAwayRange = 40.0f);',
        '// 23: Cause the action subject to move to a certain distance away from oFleeFrom.\r\n// - oFleeFrom: This is the object we wish the action subject to move away from.\r\n//   If oFleeFrom is not in the same area as the action subject, nothing will\r\n//   happen.\r\n// - bRun: If this is TRUE, the action subject will run rather than walk\r\n// - fMoveAwayRange: This is the distance we wish the action subject to put\r\n//   between themselves and oFleeFrom\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionMoveAwayFromObject failed."\r\nvoid ActionMoveAwayFromObject(object oFleeFrom, int bRun = FALSE, float fMoveAwayRange = 40.0f);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetArea',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 24: Get the area that oTarget is currently in\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetArea(object oTarget);',
        '// 24: Get the area that oTarget is currently in\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetArea(object oTarget);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetEnteringObject',
        [],
        '// 25: The value returned by this function depends on the object type of the caller:\r\n// 1) If the caller is a door or placeable it returns the object that last\r\n//    triggered it.\r\n// 2) If the caller is a trigger, area of effect, module, area or encounter it\r\n//    returns the object that last entered it.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetEnteringObject();',
        '// 25: The value returned by this function depends on the object type of the caller:\r\n// 1) If the caller is a door or placeable it returns the object that last\r\n//    triggered it.\r\n// 2) If the caller is a trigger, area of effect, module, area or encounter it\r\n//    returns the object that last entered it.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetEnteringObject();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetExitingObject',
        [],
        '// 26: Get the object that last left the caller.  This function works on triggers,\r\n// areas of effect, modules, areas and encounters.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetExitingObject();',
        '// 26: Get the object that last left the caller.  This function works on triggers,\r\n// areas of effect, modules, areas and encounters.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetExitingObject();'
    ),
    ScriptFunction(
        DataType.VECTOR,
        'GetPosition',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 27: Get the position of oTarget\r\n// * Return value on error: vector (0.0f, 0.0f, 0.0f)\r\nvector GetPosition(object oTarget);',
        '// 27: Get the position of oTarget\r\n// * Return value on error: vector (0.0f, 0.0f, 0.0f)\r\nvector GetPosition(object oTarget);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetFacing',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 28: Get the direction in which oTarget is facing, expressed as a float between\r\n// 0.0f and 360.0f\r\n// * Return value on error: -1.0f\r\nfloat GetFacing(object oTarget);',
        '// 28: Get the direction in which oTarget is facing, expressed as a float between\r\n// 0.0f and 360.0f\r\n// * Return value on error: -1.0f\r\nfloat GetFacing(object oTarget);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetItemPossessor',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 29: Get the possessor of oItem\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetItemPossessor(object oItem);',
        '// 29: Get the possessor of oItem\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetItemPossessor(object oItem);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetItemPossessedBy',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.STRING, 'sItemTag', None), ],
        '// 30: Get the object possessed by oCreature with the tag sItemTag\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetItemPossessedBy(object oCreature, string sItemTag);',
        '// 30: Get the object possessed by oCreature with the tag sItemTag\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetItemPossessedBy(object oCreature, string sItemTag);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'CreateItemOnObject',
        [ScriptParam(DataType.STRING, 'sItemTemplate', None), ScriptParam(DataType.OBJECT, 'oTarget', 0), ScriptParam(DataType.INT, 'nStackSize', 1), ScriptParam(DataType.INT, 'nHideMessage', 0), ],
        "// 31: Create an item with the template sItemTemplate in oTarget's inventory.\r\n// - nStackSize: This is the stack size of the item to be created\r\n// * Return value: The object that has been created.  On error, this returns\r\n//   OBJECT_INVALID.\r\n//RWT-OEI 12/16/03 - Added the bHideMessage parameter\r\nobject CreateItemOnObject(string sItemTemplate, object oTarget = OBJECT_SELF, int nStackSize = 1, int nHideMessage  =  0);",
        "// 31: Create an item with the template sItemTemplate in oTarget's inventory.\r\n// - nStackSize: This is the stack size of the item to be created\r\n// * Return value: The object that has been created.  On error, this returns\r\n//   OBJECT_INVALID.\r\n//RWT-OEI 12/16/03 - Added the bHideMessage parameter\r\nobject CreateItemOnObject(string sItemTemplate, object oTarget = OBJECT_SELF, int nStackSize = 1, int nHideMessage  =  0);"
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionEquipItem',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.INT, 'nInventorySlot', None), ScriptParam(DataType.INT, 'bInstant', 0), ],
        '// 32: Equip oItem into nInventorySlot.\r\n// - nInventorySlot: INVENTORY_SLOT_*\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionEquipItem failed."\r\nvoid ActionEquipItem(object oItem, int nInventorySlot, int bInstant = FALSE);',
        '// 32: Equip oItem into nInventorySlot.\r\n// - nInventorySlot: INVENTORY_SLOT_*\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionEquipItem failed."\r\nvoid ActionEquipItem(object oItem, int nInventorySlot, int bInstant = FALSE);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionUnequipItem',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.INT, 'bInstant', 0), ],
        '// 33: Unequip oItem from whatever slot it is currently in.\r\nvoid ActionUnequipItem( object oItem, int bInstant  =  FALSE );',
        '// 33: Unequip oItem from whatever slot it is currently in.\r\nvoid ActionUnequipItem( object oItem, int bInstant  =  FALSE );'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionPickUpItem',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 34: Pick up oItem from the ground.\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionPickUpItem failed."\r\nvoid ActionPickUpItem(object oItem);',
        '// 34: Pick up oItem from the ground.\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionPickUpItem failed."\r\nvoid ActionPickUpItem(object oItem);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionPutDownItem',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 35: Put down oItem on the ground.\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionPutDownItem failed."\r\nvoid ActionPutDownItem(object oItem);',
        '// 35: Put down oItem on the ground.\r\n// * No return value, but if an error occurs the log file will contain\r\n//   "ActionPutDownItem failed."\r\nvoid ActionPutDownItem(object oItem);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastAttacker',
        [ScriptParam(DataType.OBJECT, 'oAttackee', 0), ],
        '// 36: Get the last attacker of oAttackee.  This should only be used ONLY in the\r\n// OnAttacked events for creatures, placeables and doors.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetLastAttacker(object oAttackee = OBJECT_SELF);',
        '// 36: Get the last attacker of oAttackee.  This should only be used ONLY in the\r\n// OnAttacked events for creatures, placeables and doors.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetLastAttacker(object oAttackee = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionAttack',
        [ScriptParam(DataType.OBJECT, 'oAttackee', None), ScriptParam(DataType.INT, 'bPassive', 0), ],
        '// 37: Attack oAttackee.\r\n// - bPassive: If this is TRUE, attack is in passive mode.\r\nvoid ActionAttack(object oAttackee, int bPassive = FALSE);',
        '// 37: Attack oAttackee.\r\n// - bPassive: If this is TRUE, attack is in passive mode.\r\nvoid ActionAttack(object oAttackee, int bPassive = FALSE);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNearestCreature',
        [ScriptParam(DataType.INT, 'nFirstCriteriaType', None), ScriptParam(DataType.INT, 'nFirstCriteriaValue', None), ScriptParam(DataType.OBJECT, 'oTarget', 0), ScriptParam(DataType.INT, 'nNth', 1), ScriptParam(DataType.INT, 'nSecondCriteriaType', -1), ScriptParam(DataType.INT, 'nSecondCriteriaValue', -1), ScriptParam(DataType.INT, 'nThirdCriteriaType', -1), ScriptParam(DataType.INT, 'nThirdCriteriaValue', -1), ],
        "// 38: Get the creature nearest to oTarget, subject to all the criteria specified.\r\n// - nFirstCriteriaType: CREATURE_TYPE_*\r\n// - nFirstCriteriaValue:\r\n//   -> CLASS_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_CLASS\r\n//   -> SPELL_* if nFirstCriteriaType was CREATURE_TYPE_DOES_NOT_HAVE_SPELL_EFFECT\r\n//      or CREATURE_TYPE_HAS_SPELL_EFFECT\r\n//   -> TRUE or FALSE if nFirstCriteriaType was CREATURE_TYPE_IS_ALIVE\r\n//   -> PERCEPTION_* if nFirstCriteriaType was CREATURE_TYPE_PERCEPTION\r\n//   -> PLAYER_CHAR_IS_PC or PLAYER_CHAR_NOT_PC if nFirstCriteriaType was\r\n//      CREATURE_TYPE_PLAYER_CHAR\r\n//   -> RACIAL_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_RACIAL_TYPE\r\n//   -> REPUTATION_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_REPUTATION\r\n//   For example, to get the nearest PC, use:\r\n//   (CREATURE_TYPE_PLAYER_CHAR, PLAYER_CHAR_IS_PC)\r\n// - oTarget: We're trying to find the creature of the specified type that is\r\n//   nearest to oTarget\r\n// - nNth: We don't have to find the first nearest: we can find the Nth nearest...\r\n// - nSecondCriteriaType: This is used in the same way as nFirstCriteriaType to\r\n//   further specify the type of creature that we are looking for.\r\n// - nSecondCriteriaValue: This is used in the same way as nFirstCriteriaValue\r\n//   to further specify the type of creature that we are looking for.\r\n// - nThirdCriteriaType: This is used in the same way as nFirstCriteriaType to\r\n//   further specify the type of creature that we are looking for.\r\n// - nThirdCriteriaValue: This is used in the same way as nFirstCriteriaValue to\r\n//   further specify the type of creature that we are looking for.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestCreature(int nFirstCriteriaType, int nFirstCriteriaValue, object oTarget = OBJECT_SELF, int nNth = 1, int nSecondCriteriaType = -1, int nSecondCriteriaValue = -1, int nThirdCriteriaType = -1,  int nThirdCriteriaValue = -1 );",
        "// 38: Get the creature nearest to oTarget, subject to all the criteria specified.\r\n// - nFirstCriteriaType: CREATURE_TYPE_*\r\n// - nFirstCriteriaValue:\r\n//   -> CLASS_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_CLASS\r\n//   -> SPELL_* if nFirstCriteriaType was CREATURE_TYPE_DOES_NOT_HAVE_SPELL_EFFECT\r\n//      or CREATURE_TYPE_HAS_SPELL_EFFECT\r\n//   -> TRUE or FALSE if nFirstCriteriaType was CREATURE_TYPE_IS_ALIVE\r\n//   -> PERCEPTION_* if nFirstCriteriaType was CREATURE_TYPE_PERCEPTION\r\n//   -> PLAYER_CHAR_IS_PC or PLAYER_CHAR_NOT_PC if nFirstCriteriaType was\r\n//      CREATURE_TYPE_PLAYER_CHAR\r\n//   -> RACIAL_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_RACIAL_TYPE\r\n//   -> REPUTATION_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_REPUTATION\r\n//   For example, to get the nearest PC, use:\r\n//   (CREATURE_TYPE_PLAYER_CHAR, PLAYER_CHAR_IS_PC)\r\n// - oTarget: We're trying to find the creature of the specified type that is\r\n//   nearest to oTarget\r\n// - nNth: We don't have to find the first nearest: we can find the Nth nearest...\r\n// - nSecondCriteriaType: This is used in the same way as nFirstCriteriaType to\r\n//   further specify the type of creature that we are looking for.\r\n// - nSecondCriteriaValue: This is used in the same way as nFirstCriteriaValue\r\n//   to further specify the type of creature that we are looking for.\r\n// - nThirdCriteriaType: This is used in the same way as nFirstCriteriaType to\r\n//   further specify the type of creature that we are looking for.\r\n// - nThirdCriteriaValue: This is used in the same way as nFirstCriteriaValue to\r\n//   further specify the type of creature that we are looking for.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestCreature(int nFirstCriteriaType, int nFirstCriteriaValue, object oTarget = OBJECT_SELF, int nNth = 1, int nSecondCriteriaType = -1, int nSecondCriteriaValue = -1, int nThirdCriteriaType = -1,  int nThirdCriteriaValue = -1 );"
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionSpeakString',
        [ScriptParam(DataType.STRING, 'sStringToSpeak', None), ScriptParam(DataType.INT, 'nTalkVolume', 0), ],
        '// 39: Add a speak action to the action subject.\r\n// - sStringToSpeak: String to be spoken\r\n// - nTalkVolume: TALKVOLUME_*\r\nvoid ActionSpeakString(string sStringToSpeak, int nTalkVolume = TALKVOLUME_TALK);',
        '// 39: Add a speak action to the action subject.\r\n// - sStringToSpeak: String to be spoken\r\n// - nTalkVolume: TALKVOLUME_*\r\nvoid ActionSpeakString(string sStringToSpeak, int nTalkVolume = TALKVOLUME_TALK);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionPlayAnimation',
        [ScriptParam(DataType.INT, 'nAnimation', None), ScriptParam(DataType.FLOAT, 'fSpeed', 1.0), ScriptParam(DataType.FLOAT, 'fDurationSeconds', 0.0), ],
        '// 40: Cause the action subject to play an animation\r\n// - nAnimation: ANIMATION_*\r\n// - fSpeed: Speed of the animation\r\n// - fDurationSeconds: Duration of the animation (this is not used for Fire and\r\n//   Forget animations) If a time of -1.0f is specified for a looping animation\r\n//   it will loop until the next animation is applied.\r\nvoid ActionPlayAnimation(int nAnimation, float fSpeed = 1.0, float fDurationSeconds = 0.0);',
        '// 40: Cause the action subject to play an animation\r\n// - nAnimation: ANIMATION_*\r\n// - fSpeed: Speed of the animation\r\n// - fDurationSeconds: Duration of the animation (this is not used for Fire and\r\n//   Forget animations) If a time of -1.0f is specified for a looping animation\r\n//   it will loop until the next animation is applied.\r\nvoid ActionPlayAnimation(int nAnimation, float fSpeed = 1.0, float fDurationSeconds = 0.0);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetDistanceToObject',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 41: Get the distance from the caller to oObject in metres.\r\n// * Return value on error: -1.0f\r\nfloat GetDistanceToObject(object oObject);',
        '// 41: Get the distance from the caller to oObject in metres.\r\n// * Return value on error: -1.0f\r\nfloat GetDistanceToObject(object oObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsObjectValid',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 42: * Returns TRUE if oObject is a valid object.\r\nint GetIsObjectValid(object oObject);',
        '// 42: * Returns TRUE if oObject is a valid object.\r\nint GetIsObjectValid(object oObject);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionOpenDoor',
        [ScriptParam(DataType.OBJECT, 'oDoor', None), ],
        '// 43: Cause the action subject to open oDoor\r\nvoid ActionOpenDoor(object oDoor);',
        '// 43: Cause the action subject to open oDoor\r\nvoid ActionOpenDoor(object oDoor);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionCloseDoor',
        [ScriptParam(DataType.OBJECT, 'oDoor', None), ],
        '// 44: Cause the action subject to close oDoor\r\nvoid ActionCloseDoor(object oDoor);',
        '// 44: Cause the action subject to close oDoor\r\nvoid ActionCloseDoor(object oDoor);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetCameraFacing',
        [ScriptParam(DataType.FLOAT, 'fDirection', None), ],
        '// 45: Change the direction in which the camera is facing\r\n// - fDirection is expressed as anticlockwise degrees from Due East.\r\n//   (0.0f = East, 90.0f = North, 180.0f = West, 270.0f = South)\r\n// This can be used to change the way the camera is facing after the player\r\n// emerges from an area transition.\r\nvoid SetCameraFacing(float fDirection);',
        '// 45: Change the direction in which the camera is facing\r\n// - fDirection is expressed as anticlockwise degrees from Due East.\r\n//   (0.0f = East, 90.0f = North, 180.0f = West, 270.0f = South)\r\n// This can be used to change the way the camera is facing after the player\r\n// emerges from an area transition.\r\nvoid SetCameraFacing(float fDirection);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PlaySound',
        [ScriptParam(DataType.STRING, 'sSoundName', None), ],
        '// 46: Play sSoundName\r\n// - sSoundName: TBD - SS\r\nvoid PlaySound(string sSoundName);',
        '// 46: Play sSoundName\r\n// - sSoundName: TBD - SS\r\nvoid PlaySound(string sSoundName);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetSpellTargetObject',
        [],
        '// 47: Get the object at which the caller last cast a spell\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetSpellTargetObject();',
        '// 47: Get the object at which the caller last cast a spell\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetSpellTargetObject();'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionCastSpellAtObject',
        [ScriptParam(DataType.INT, 'nSpell', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'nMetaMagic', 0), ScriptParam(DataType.INT, 'bCheat', 0), ScriptParam(DataType.INT, 'nDomainLevel', 0), ScriptParam(DataType.INT, 'nProjectilePathType', 0), ScriptParam(DataType.INT, 'bInstantSpell', 0), ],
        "// 48: This action casts a spell at oTarget.\r\n// - nSpell: SPELL_*\r\n// - oTarget: Target for the spell\r\n// - nMetamagic: METAMAGIC_*\r\n// - bCheat: If this is TRUE, then the executor of the action doesn't have to be\r\n//   able to cast the spell.\r\n// - nDomainLevel: TBD - SS\r\n// - nProjectilePathType: PROJECTILE_PATH_TYPE_*\r\n// - bInstantSpell: If this is TRUE, the spell is cast immediately. This allows\r\n//   the end-user to simulate a high-level magic-user having lots of advance\r\n//   warning of impending trouble\r\nvoid ActionCastSpellAtObject(int nSpell, object oTarget, int nMetaMagic = 0 , int bCheat = FALSE, int nDomainLevel = 0, int nProjectilePathType = PROJECTILE_PATH_TYPE_DEFAULT, int bInstantSpell = FALSE);",
        "// 48: This action casts a spell at oTarget.\r\n// - nSpell: SPELL_*\r\n// - oTarget: Target for the spell\r\n// - nMetamagic: METAMAGIC_*\r\n// - bCheat: If this is TRUE, then the executor of the action doesn't have to be\r\n//   able to cast the spell.\r\n// - nDomainLevel: TBD - SS\r\n// - nProjectilePathType: PROJECTILE_PATH_TYPE_*\r\n// - bInstantSpell: If this is TRUE, the spell is cast immediately. This allows\r\n//   the end-user to simulate a high-level magic-user having lots of advance\r\n//   warning of impending trouble\r\nvoid ActionCastSpellAtObject(int nSpell, object oTarget, int nMetaMagic = 0 , int bCheat = FALSE, int nDomainLevel = 0, int nProjectilePathType = PROJECTILE_PATH_TYPE_DEFAULT, int bInstantSpell = FALSE);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetCurrentHitPoints',
        [ScriptParam(DataType.OBJECT, 'oObject', 0), ],
        '// 49: Get the current hitpoints of oObject\r\n// * Return value on error: 0\r\nint GetCurrentHitPoints(object oObject = OBJECT_SELF);',
        '// 49: Get the current hitpoints of oObject\r\n// * Return value on error: 0\r\nint GetCurrentHitPoints(object oObject = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetMaxHitPoints',
        [ScriptParam(DataType.OBJECT, 'oObject', 0), ],
        '// 50: Get the maximum hitpoints of oObject\r\n// * Return value on error: 0\r\nint GetMaxHitPoints(object oObject = OBJECT_SELF);',
        '// 50: Get the maximum hitpoints of oObject\r\n// * Return value on error: 0\r\nint GetMaxHitPoints(object oObject = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectAssuredHit',
        [],
        '// 51: EffectAssuredHit\r\n// Create an Assured Hit effect, which guarantees that all attacks are successful\r\neffect EffectAssuredHit();',
        '// 51: EffectAssuredHit\r\n// Create an Assured Hit effect, which guarantees that all attacks are successful\r\neffect EffectAssuredHit();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastItemEquipped',
        [],
        '// 52:\r\n// Returns the last item that was equipped by a creature.\r\nobject GetLastItemEquipped();',
        '// 52:\r\n// Returns the last item that was equipped by a creature.\r\nobject GetLastItemEquipped();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetSubScreenID',
        [],
        '// 53:\r\n// Returns the ID of the subscreen that is currently onscreen.  This will be one of the\r\n// SUBSCREEN_ID_* constant values.\r\nint GetSubScreenID();',
        '// 53:\r\n// Returns the ID of the subscreen that is currently onscreen.  This will be one of the\r\n// SUBSCREEN_ID_* constant values.\r\nint GetSubScreenID();'
    ),
    ScriptFunction(
        DataType.VOID,
        'CancelCombat',
        [ScriptParam(DataType.OBJECT, 'oidCreature', None), ],
        '// 54:\r\n// Cancels combat for the specified creature.\r\nvoid CancelCombat( object oidCreature );',
        '// 54:\r\n// Cancels combat for the specified creature.\r\nvoid CancelCombat( object oidCreature );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetCurrentForcePoints',
        [ScriptParam(DataType.OBJECT, 'oObject', 0), ],
        '// 55:\r\n// returns the current force points for the creature\r\nint GetCurrentForcePoints(object oObject = OBJECT_SELF);',
        '// 55:\r\n// returns the current force points for the creature\r\nint GetCurrentForcePoints(object oObject = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetMaxForcePoints',
        [ScriptParam(DataType.OBJECT, 'oObject', 0), ],
        '// 56:\r\n// returns the Max force points for the creature\r\nint GetMaxForcePoints(object oObject = OBJECT_SELF);',
        '// 56:\r\n// returns the Max force points for the creature\r\nint GetMaxForcePoints(object oObject = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PauseGame',
        [ScriptParam(DataType.INT, 'bPause', None), ],
        '// 57:\r\n// Pauses the game if bPause is TRUE.  Unpauses if bPause is FALSE.\r\nvoid PauseGame( int bPause );',
        '// 57:\r\n// Pauses the game if bPause is TRUE.  Unpauses if bPause is FALSE.\r\nvoid PauseGame( int bPause );'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetPlayerRestrictMode',
        [ScriptParam(DataType.INT, 'bRestrict', None), ],
        "// 58: SetPlayerRestrictMode\r\n// Sets whether the player is currently in 'restricted' mode\r\nvoid SetPlayerRestrictMode( int bRestrict );",
        "// 58: SetPlayerRestrictMode\r\n// Sets whether the player is currently in 'restricted' mode\r\nvoid SetPlayerRestrictMode( int bRestrict );"
    ),
    ScriptFunction(
        DataType.INT,
        'GetStringLength',
        [ScriptParam(DataType.STRING, 'sString', None), ],
        '// 59: Get the length of sString\r\n// * Return value on error: -1\r\nint GetStringLength(string sString);',
        '// 59: Get the length of sString\r\n// * Return value on error: -1\r\nint GetStringLength(string sString);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetStringUpperCase',
        [ScriptParam(DataType.STRING, 'sString', None), ],
        '// 60: Convert sString into upper case\r\n// * Return value on error: ""\r\nstring GetStringUpperCase(string sString);',
        '// 60: Convert sString into upper case\r\n// * Return value on error: ""\r\nstring GetStringUpperCase(string sString);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetStringLowerCase',
        [ScriptParam(DataType.STRING, 'sString', None), ],
        '// 61: Convert sString into lower case\r\n// * Return value on error: ""\r\nstring GetStringLowerCase(string sString);',
        '// 61: Convert sString into lower case\r\n// * Return value on error: ""\r\nstring GetStringLowerCase(string sString);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetStringRight',
        [ScriptParam(DataType.STRING, 'sString', None), ScriptParam(DataType.INT, 'nCount', None), ],
        '// 62: Get nCount characters from the right end of sString\r\n// * Return value on error: ""\r\nstring GetStringRight(string sString, int nCount);',
        '// 62: Get nCount characters from the right end of sString\r\n// * Return value on error: ""\r\nstring GetStringRight(string sString, int nCount);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetStringLeft',
        [ScriptParam(DataType.STRING, 'sString', None), ScriptParam(DataType.INT, 'nCount', None), ],
        '// 63: Get nCounter characters from the left end of sString\r\n// * Return value on error: ""\r\nstring GetStringLeft(string sString, int nCount);',
        '// 63: Get nCounter characters from the left end of sString\r\n// * Return value on error: ""\r\nstring GetStringLeft(string sString, int nCount);'
    ),
    ScriptFunction(
        DataType.STRING,
        'InsertString',
        [ScriptParam(DataType.STRING, 'sDestination', None), ScriptParam(DataType.STRING, 'sString', None), ScriptParam(DataType.INT, 'nPosition', None), ],
        '// 64: Insert sString into sDestination at nPosition\r\n// * Return value on error: ""\r\nstring InsertString(string sDestination, string sString, int nPosition);',
        '// 64: Insert sString into sDestination at nPosition\r\n// * Return value on error: ""\r\nstring InsertString(string sDestination, string sString, int nPosition);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetSubString',
        [ScriptParam(DataType.STRING, 'sString', None), ScriptParam(DataType.INT, 'nStart', None), ScriptParam(DataType.INT, 'nCount', None), ],
        '// 65: Get nCount characters from sString, starting at nStart\r\n// * Return value on error: ""\r\nstring GetSubString(string sString, int nStart, int nCount);',
        '// 65: Get nCount characters from sString, starting at nStart\r\n// * Return value on error: ""\r\nstring GetSubString(string sString, int nStart, int nCount);'
    ),
    ScriptFunction(
        DataType.INT,
        'FindSubString',
        [ScriptParam(DataType.STRING, 'sString', None), ScriptParam(DataType.STRING, 'sSubString', None), ],
        '// 66: Find the position of sSubstring inside sString\r\n// * Return value on error: -1\r\nint FindSubString(string sString, string sSubString);',
        '// 66: Find the position of sSubstring inside sString\r\n// * Return value on error: -1\r\nint FindSubString(string sString, string sSubString);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'fabs',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ],
        '// 67: Maths operation: absolute value of fValue\r\nfloat fabs(float fValue);',
        '// 67: Maths operation: absolute value of fValue\r\nfloat fabs(float fValue);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'cos',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ],
        '// 68: Maths operation: cosine of fValue\r\nfloat cos(float fValue);',
        '// 68: Maths operation: cosine of fValue\r\nfloat cos(float fValue);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'sin',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ],
        '// 69: Maths operation: sine of fValue\r\nfloat sin(float fValue);',
        '// 69: Maths operation: sine of fValue\r\nfloat sin(float fValue);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'tan',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ],
        '// 70: Maths operation: tan of fValue\r\nfloat tan(float fValue);',
        '// 70: Maths operation: tan of fValue\r\nfloat tan(float fValue);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'acos',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ],
        '// 71: Maths operation: arccosine of fValue\r\n// * Returns zero if fValue > 1 or fValue < -1\r\nfloat acos(float fValue);',
        '// 71: Maths operation: arccosine of fValue\r\n// * Returns zero if fValue > 1 or fValue < -1\r\nfloat acos(float fValue);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'asin',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ],
        '// 72: Maths operation: arcsine of fValue\r\n// * Returns zero if fValue >1 or fValue < -1\r\nfloat asin(float fValue);',
        '// 72: Maths operation: arcsine of fValue\r\n// * Returns zero if fValue >1 or fValue < -1\r\nfloat asin(float fValue);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'atan',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ],
        '// 73: Maths operation: arctan of fValue\r\nfloat atan(float fValue);',
        '// 73: Maths operation: arctan of fValue\r\nfloat atan(float fValue);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'log',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ],
        '// 74: Maths operation: log of fValue\r\n// * Returns zero if fValue < =  zero\r\nfloat log(float fValue);',
        '// 74: Maths operation: log of fValue\r\n// * Returns zero if fValue < =  zero\r\nfloat log(float fValue);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'pow',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ScriptParam(DataType.FLOAT, 'fExponent', None), ],
        '// 75: Maths operation: fValue is raised to the power of fExponent\r\n// * Returns zero if fValue  =  = 0 and fExponent <0\r\nfloat pow(float fValue, float fExponent);',
        '// 75: Maths operation: fValue is raised to the power of fExponent\r\n// * Returns zero if fValue  =  = 0 and fExponent <0\r\nfloat pow(float fValue, float fExponent);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'sqrt',
        [ScriptParam(DataType.FLOAT, 'fValue', None), ],
        '// 76: Maths operation: square root of fValue\r\n// * Returns zero if fValue <0\r\nfloat sqrt(float fValue);',
        '// 76: Maths operation: square root of fValue\r\n// * Returns zero if fValue <0\r\nfloat sqrt(float fValue);'
    ),
    ScriptFunction(
        DataType.INT,
        'abs',
        [ScriptParam(DataType.INT, 'nValue', None), ],
        '// 77: Maths operation: integer absolute value of nValue\r\n// * Return value on error: 0\r\nint abs(int nValue);',
        '// 77: Maths operation: integer absolute value of nValue\r\n// * Return value on error: 0\r\nint abs(int nValue);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectHeal',
        [ScriptParam(DataType.INT, 'nDamageToHeal', None), ],
        '// 78: Create a Heal effect. This should be applied as an instantaneous effect.\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nDamageToHeal < 0.\r\neffect EffectHeal(int nDamageToHeal);',
        '// 78: Create a Heal effect. This should be applied as an instantaneous effect.\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nDamageToHeal < 0.\r\neffect EffectHeal(int nDamageToHeal);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDamage',
        [ScriptParam(DataType.INT, 'nDamageAmount', None), ScriptParam(DataType.INT, 'nDamageType', 8), ScriptParam(DataType.INT, 'nDamagePower', 0), ],
        '// 79: Create a Damage effect\r\n// - nDamageAmount: amount of damage to be dealt. This should be applied as an\r\n//   instantaneous effect.\r\n// - nDamageType: DAMAGE_TYPE_*\r\n// - nDamagePower: DAMAGE_POWER_*\r\neffect EffectDamage(int nDamageAmount, int nDamageType = DAMAGE_TYPE_UNIVERSAL, int nDamagePower = DAMAGE_POWER_NORMAL);',
        '// 79: Create a Damage effect\r\n// - nDamageAmount: amount of damage to be dealt. This should be applied as an\r\n//   instantaneous effect.\r\n// - nDamageType: DAMAGE_TYPE_*\r\n// - nDamagePower: DAMAGE_POWER_*\r\neffect EffectDamage(int nDamageAmount, int nDamageType = DAMAGE_TYPE_UNIVERSAL, int nDamagePower = DAMAGE_POWER_NORMAL);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectAbilityIncrease',
        [ScriptParam(DataType.INT, 'nAbilityToIncrease', None), ScriptParam(DataType.INT, 'nModifyBy', None), ],
        '// 80: Create an Ability Increase effect\r\n// - bAbilityToIncrease: ABILITY_*\r\neffect EffectAbilityIncrease(int nAbilityToIncrease, int nModifyBy);',
        '// 80: Create an Ability Increase effect\r\n// - bAbilityToIncrease: ABILITY_*\r\neffect EffectAbilityIncrease(int nAbilityToIncrease, int nModifyBy);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDamageResistance',
        [ScriptParam(DataType.INT, 'nDamageType', None), ScriptParam(DataType.INT, 'nAmount', None), ScriptParam(DataType.INT, 'nLimit', 0), ],
        '// 81: Create a Damage Resistance effect that removes the first nAmount points of\r\n// damage of type nDamageType, up to nLimit (or infinite if nLimit is 0)\r\n// - nDamageType: DAMAGE_TYPE_*\r\n// - nAmount\r\n// - nLimit\r\neffect EffectDamageResistance(int nDamageType, int nAmount, int nLimit = 0);',
        '// 81: Create a Damage Resistance effect that removes the first nAmount points of\r\n// damage of type nDamageType, up to nLimit (or infinite if nLimit is 0)\r\n// - nDamageType: DAMAGE_TYPE_*\r\n// - nAmount\r\n// - nLimit\r\neffect EffectDamageResistance(int nDamageType, int nAmount, int nLimit = 0);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectResurrection',
        [ScriptParam(DataType.INT, 'nHPPercent', 0), ],
        '// 82: Create a Resurrection effect. This should be applied as an instantaneous effect.\r\n// Added a parameter for the percentage of HP the target\r\n// should receive when they are revived.\r\neffect EffectResurrection( int nHPPercent = 0 );',
        '// 82: Create a Resurrection effect. This should be applied as an instantaneous effect.\r\n// Added a parameter for the percentage of HP the target\r\n// should receive when they are revived.\r\neffect EffectResurrection( int nHPPercent = 0 );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetPlayerRestrictMode',
        [ScriptParam(DataType.OBJECT, 'oObject', 0), ],
        "// 83: GetPlayerRestrictMode\r\n// returns the current player 'restricted' mode\r\nint GetPlayerRestrictMode(object oObject  =  OBJECT_SELF);",
        "// 83: GetPlayerRestrictMode\r\n// returns the current player 'restricted' mode\r\nint GetPlayerRestrictMode(object oObject  =  OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetCasterLevel',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 84: Get the Caster Level of oCreature.\r\n// * Return value on error: 0;\r\nint GetCasterLevel(object oCreature);',
        '// 84: Get the Caster Level of oCreature.\r\n// * Return value on error: 0;\r\nint GetCasterLevel(object oCreature);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'GetFirstEffect',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 85: Get the first in-game effect on oCreature.\r\neffect GetFirstEffect(object oCreature);',
        '// 85: Get the first in-game effect on oCreature.\r\neffect GetFirstEffect(object oCreature);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'GetNextEffect',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 86: Get the next in-game effect on oCreature.\r\neffect GetNextEffect(object oCreature);',
        '// 86: Get the next in-game effect on oCreature.\r\neffect GetNextEffect(object oCreature);'
    ),
    ScriptFunction(
        DataType.VOID,
        'RemoveEffect',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 87: Remove eEffect from oCreature.\r\n// * No return value\r\nvoid RemoveEffect(object oCreature, effect eEffect);',
        '// 87: Remove eEffect from oCreature.\r\n// * No return value\r\nvoid RemoveEffect(object oCreature, effect eEffect);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsEffectValid',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 88: * Returns TRUE if eEffect is a valid effect.\r\nint GetIsEffectValid(effect eEffect);',
        '// 88: * Returns TRUE if eEffect is a valid effect.\r\nint GetIsEffectValid(effect eEffect);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetEffectDurationType',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 89: Get the duration type (DURATION_TYPE_*) of eEffect.\r\n// * Return value if eEffect is not valid: -1\r\nint GetEffectDurationType(effect eEffect);',
        '// 89: Get the duration type (DURATION_TYPE_*) of eEffect.\r\n// * Return value if eEffect is not valid: -1\r\nint GetEffectDurationType(effect eEffect);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetEffectSubType',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 90: Get the subtype (SUBTYPE_*) of eEffect.\r\n// * Return value on error: 0\r\nint GetEffectSubType(effect eEffect);',
        '// 90: Get the subtype (SUBTYPE_*) of eEffect.\r\n// * Return value on error: 0\r\nint GetEffectSubType(effect eEffect);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetEffectCreator',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 91: Get the object that created eEffect.\r\n// * Returns OBJECT_INVALID if eEffect is not a valid effect.\r\nobject GetEffectCreator(effect eEffect);',
        '// 91: Get the object that created eEffect.\r\n// * Returns OBJECT_INVALID if eEffect is not a valid effect.\r\nobject GetEffectCreator(effect eEffect);'
    ),
    ScriptFunction(
        DataType.STRING,
        'IntToString',
        [ScriptParam(DataType.INT, 'nInteger', None), ],
        '// 92: Convert nInteger into a string.\r\n// * Return value on error: ""\r\nstring IntToString(int nInteger);',
        '// 92: Convert nInteger into a string.\r\n// * Return value on error: ""\r\nstring IntToString(int nInteger);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFirstObjectInArea',
        [ScriptParam(DataType.OBJECT, 'oArea', 1), ScriptParam(DataType.INT, 'nObjectFilter', 1), ],
        "// 93: Get the first object in oArea.\r\n// If no valid area is specified, it will use the caller's area.\r\n// - oArea\r\n// - nObjectFilter: OBJECT_TYPE_*\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetFirstObjectInArea(object oArea = OBJECT_INVALID, int nObjectFilter = OBJECT_TYPE_CREATURE);",
        "// 93: Get the first object in oArea.\r\n// If no valid area is specified, it will use the caller's area.\r\n// - oArea\r\n// - nObjectFilter: OBJECT_TYPE_*\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetFirstObjectInArea(object oArea = OBJECT_INVALID, int nObjectFilter = OBJECT_TYPE_CREATURE);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNextObjectInArea',
        [ScriptParam(DataType.OBJECT, 'oArea', 1), ScriptParam(DataType.INT, 'nObjectFilter', 1), ],
        "// 94: Get the next object in oArea.\r\n// If no valid area is specified, it will use the caller's area.\r\n// - oArea\r\n// - nObjectFilter: OBJECT_TYPE_*\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNextObjectInArea(object oArea = OBJECT_INVALID, int nObjectFilter = OBJECT_TYPE_CREATURE);",
        "// 94: Get the next object in oArea.\r\n// If no valid area is specified, it will use the caller's area.\r\n// - oArea\r\n// - nObjectFilter: OBJECT_TYPE_*\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNextObjectInArea(object oArea = OBJECT_INVALID, int nObjectFilter = OBJECT_TYPE_CREATURE);"
    ),
    ScriptFunction(
        DataType.INT,
        'd2',
        [ScriptParam(DataType.INT, 'nNumDice', 1), ],
        '// 95: Get the total from rolling (nNumDice x d2 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d2(int nNumDice = 1);',
        '// 95: Get the total from rolling (nNumDice x d2 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d2(int nNumDice = 1);'
    ),
    ScriptFunction(
        DataType.INT,
        'd3',
        [ScriptParam(DataType.INT, 'nNumDice', 1), ],
        '// 96: Get the total from rolling (nNumDice x d3 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d3(int nNumDice = 1);',
        '// 96: Get the total from rolling (nNumDice x d3 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d3(int nNumDice = 1);'
    ),
    ScriptFunction(
        DataType.INT,
        'd4',
        [ScriptParam(DataType.INT, 'nNumDice', 1), ],
        '// 97: Get the total from rolling (nNumDice x d4 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d4(int nNumDice = 1);',
        '// 97: Get the total from rolling (nNumDice x d4 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d4(int nNumDice = 1);'
    ),
    ScriptFunction(
        DataType.INT,
        'd6',
        [ScriptParam(DataType.INT, 'nNumDice', 1), ],
        '// 98: Get the total from rolling (nNumDice x d6 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d6(int nNumDice = 1);',
        '// 98: Get the total from rolling (nNumDice x d6 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d6(int nNumDice = 1);'
    ),
    ScriptFunction(
        DataType.INT,
        'd8',
        [ScriptParam(DataType.INT, 'nNumDice', 1), ],
        '// 99: Get the total from rolling (nNumDice x d8 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d8(int nNumDice = 1);',
        '// 99: Get the total from rolling (nNumDice x d8 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d8(int nNumDice = 1);'
    ),
    ScriptFunction(
        DataType.INT,
        'd10',
        [ScriptParam(DataType.INT, 'nNumDice', 1), ],
        '// 100: Get the total from rolling (nNumDice x d10 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d10(int nNumDice = 1);',
        '// 100: Get the total from rolling (nNumDice x d10 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d10(int nNumDice = 1);'
    ),
    ScriptFunction(
        DataType.INT,
        'd12',
        [ScriptParam(DataType.INT, 'nNumDice', 1), ],
        '// 101: Get the total from rolling (nNumDice x d12 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d12(int nNumDice = 1);',
        '// 101: Get the total from rolling (nNumDice x d12 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d12(int nNumDice = 1);'
    ),
    ScriptFunction(
        DataType.INT,
        'd20',
        [ScriptParam(DataType.INT, 'nNumDice', 1), ],
        '// 102: Get the total from rolling (nNumDice x d20 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d20(int nNumDice = 1);',
        '// 102: Get the total from rolling (nNumDice x d20 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d20(int nNumDice = 1);'
    ),
    ScriptFunction(
        DataType.INT,
        'd100',
        [ScriptParam(DataType.INT, 'nNumDice', 1), ],
        '// 103: Get the total from rolling (nNumDice x d100 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d100(int nNumDice = 1);',
        '// 103: Get the total from rolling (nNumDice x d100 dice).\r\n// - nNumDice: If this is less than 1, the value 1 will be used.\r\nint d100(int nNumDice = 1);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'VectorMagnitude',
        [ScriptParam(DataType.VECTOR, 'vVector', None), ],
        '// 104: Get the magnitude of vVector; this can be used to determine the\r\n// distance between two points.\r\n// * Return value on error: 0.0f\r\nfloat VectorMagnitude(vector vVector);',
        '// 104: Get the magnitude of vVector; this can be used to determine the\r\n// distance between two points.\r\n// * Return value on error: 0.0f\r\nfloat VectorMagnitude(vector vVector);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetMetaMagicFeat',
        [],
        '// 105: Get the metamagic type (METAMAGIC_*) of the last spell cast by the caller\r\n// * Return value if the caster is not a valid object: -1\r\nint GetMetaMagicFeat();',
        '// 105: Get the metamagic type (METAMAGIC_*) of the last spell cast by the caller\r\n// * Return value if the caster is not a valid object: -1\r\nint GetMetaMagicFeat();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetObjectType',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 106: Get the object type (OBJECT_TYPE_*) of oTarget\r\n// * Return value if oTarget is not a valid object: -1\r\nint GetObjectType(object oTarget);',
        '// 106: Get the object type (OBJECT_TYPE_*) of oTarget\r\n// * Return value if oTarget is not a valid object: -1\r\nint GetObjectType(object oTarget);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetRacialType',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 107: Get the racial type (RACIAL_TYPE_*) of oCreature\r\n// * Return value if oCreature is not a valid creature: RACIAL_TYPE_INVALID\r\nint GetRacialType(object oCreature);',
        '// 107: Get the racial type (RACIAL_TYPE_*) of oCreature\r\n// * Return value if oCreature is not a valid creature: RACIAL_TYPE_INVALID\r\nint GetRacialType(object oCreature);'
    ),
    ScriptFunction(
        DataType.INT,
        'FortitudeSave',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nDC', None), ScriptParam(DataType.INT, 'nSaveType', 0), ScriptParam(DataType.OBJECT, 'oSaveVersus', 0), ],
        '// 108: Do a Fortitude Save check for the given DC\r\n// - oCreature\r\n// - nDC: Difficulty check\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\n// - oSaveVersus\r\n// Returns: 0 if the saving throw roll failed\r\n// Returns: 1 if the saving throw roll succeeded\r\n// Returns: 2 if the target was immune to the save type specified\r\nint FortitudeSave(object oCreature, int nDC, int nSaveType = SAVING_THROW_TYPE_NONE, object oSaveVersus = OBJECT_SELF);',
        '// 108: Do a Fortitude Save check for the given DC\r\n// - oCreature\r\n// - nDC: Difficulty check\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\n// - oSaveVersus\r\n// Returns: 0 if the saving throw roll failed\r\n// Returns: 1 if the saving throw roll succeeded\r\n// Returns: 2 if the target was immune to the save type specified\r\nint FortitudeSave(object oCreature, int nDC, int nSaveType = SAVING_THROW_TYPE_NONE, object oSaveVersus = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'ReflexSave',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nDC', None), ScriptParam(DataType.INT, 'nSaveType', 0), ScriptParam(DataType.OBJECT, 'oSaveVersus', 0), ],
        '// 109: Does a Reflex Save check for the given DC\r\n// - oCreature\r\n// - nDC: Difficulty check\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\n// - oSaveVersus\r\n// Returns: 0 if the saving throw roll failed\r\n// Returns: 1 if the saving throw roll succeeded\r\n// Returns: 2 if the target was immune to the save type specified\r\nint ReflexSave(object oCreature, int nDC, int nSaveType = SAVING_THROW_TYPE_NONE, object oSaveVersus = OBJECT_SELF);',
        '// 109: Does a Reflex Save check for the given DC\r\n// - oCreature\r\n// - nDC: Difficulty check\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\n// - oSaveVersus\r\n// Returns: 0 if the saving throw roll failed\r\n// Returns: 1 if the saving throw roll succeeded\r\n// Returns: 2 if the target was immune to the save type specified\r\nint ReflexSave(object oCreature, int nDC, int nSaveType = SAVING_THROW_TYPE_NONE, object oSaveVersus = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'WillSave',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nDC', None), ScriptParam(DataType.INT, 'nSaveType', 0), ScriptParam(DataType.OBJECT, 'oSaveVersus', 0), ],
        '// 110: Does a Will Save check for the given DC\r\n// - oCreature\r\n// - nDC: Difficulty check\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\n// - oSaveVersus\r\n// Returns: 0 if the saving throw roll failed\r\n// Returns: 1 if the saving throw roll succeeded\r\n// Returns: 2 if the target was immune to the save type specified\r\nint WillSave(object oCreature, int nDC, int nSaveType = SAVING_THROW_TYPE_NONE, object oSaveVersus = OBJECT_SELF);',
        '// 110: Does a Will Save check for the given DC\r\n// - oCreature\r\n// - nDC: Difficulty check\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\n// - oSaveVersus\r\n// Returns: 0 if the saving throw roll failed\r\n// Returns: 1 if the saving throw roll succeeded\r\n// Returns: 2 if the target was immune to the save type specified\r\nint WillSave(object oCreature, int nDC, int nSaveType = SAVING_THROW_TYPE_NONE, object oSaveVersus = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetSpellSaveDC',
        [],
        '// 111: Get the DC to save against for a spell (5 + spell level + CHA Mod + WIS Mod).\r\n// This can be called by a creature or by an Area of Effect object.\r\nint GetSpellSaveDC();',
        '// 111: Get the DC to save against for a spell (5 + spell level + CHA Mod + WIS Mod).\r\n// This can be called by a creature or by an Area of Effect object.\r\nint GetSpellSaveDC();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'MagicalEffect',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 112: Set the subtype of eEffect to Magical and return eEffect.\r\n// (Effects default to magical if the subtype is not set)\r\neffect MagicalEffect(effect eEffect);',
        '// 112: Set the subtype of eEffect to Magical and return eEffect.\r\n// (Effects default to magical if the subtype is not set)\r\neffect MagicalEffect(effect eEffect);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'SupernaturalEffect',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 113: Set the subtype of eEffect to Supernatural and return eEffect.\r\n// (Effects default to magical if the subtype is not set)\r\neffect SupernaturalEffect(effect eEffect);',
        '// 113: Set the subtype of eEffect to Supernatural and return eEffect.\r\n// (Effects default to magical if the subtype is not set)\r\neffect SupernaturalEffect(effect eEffect);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'ExtraordinaryEffect',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 114: Set the subtype of eEffect to Extraordinary and return eEffect.\r\n// (Effects default to magical if the subtype is not set)\r\neffect ExtraordinaryEffect(effect eEffect);',
        '// 114: Set the subtype of eEffect to Extraordinary and return eEffect.\r\n// (Effects default to magical if the subtype is not set)\r\neffect ExtraordinaryEffect(effect eEffect);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectACIncrease',
        [ScriptParam(DataType.INT, 'nValue', None), ScriptParam(DataType.INT, 'nModifyType', 0), ScriptParam(DataType.INT, 'nDamageType', 8199), ],
        '// 115: Create an AC Increase effect\r\n// - nValue: size of AC increase\r\n// - nModifyType: AC_*_BONUS\r\n// - nDamageType: DAMAGE_TYPE_*\r\n//   * Default value for nDamageType should only ever be used in this function prototype.\r\neffect EffectACIncrease(int nValue, int nModifyType = AC_DODGE_BONUS, int nDamageType = AC_VS_DAMAGE_TYPE_ALL);',
        '// 115: Create an AC Increase effect\r\n// - nValue: size of AC increase\r\n// - nModifyType: AC_*_BONUS\r\n// - nDamageType: DAMAGE_TYPE_*\r\n//   * Default value for nDamageType should only ever be used in this function prototype.\r\neffect EffectACIncrease(int nValue, int nModifyType = AC_DODGE_BONUS, int nDamageType = AC_VS_DAMAGE_TYPE_ALL);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetAC',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.INT, 'nForFutureUse', 0), ],
        "// 116: If oObject is a creature, this will return that creature's armour class\r\n// If oObject is an item, door or placeable, this will return zero.\r\n// - nForFutureUse: this parameter is not currently used\r\n// * Return value if oObject is not a creature, item, door or placeable: -1\r\nint GetAC(object oObject, int nForFutureUse = 0);",
        "// 116: If oObject is a creature, this will return that creature's armour class\r\n// If oObject is an item, door or placeable, this will return zero.\r\n// - nForFutureUse: this parameter is not currently used\r\n// * Return value if oObject is not a creature, item, door or placeable: -1\r\nint GetAC(object oObject, int nForFutureUse = 0);"
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectSavingThrowIncrease',
        [ScriptParam(DataType.INT, 'nSave', None), ScriptParam(DataType.INT, 'nValue', None), ScriptParam(DataType.INT, 'nSaveType', 0), ],
        '// 117: Create an AC Decrease effect\r\n// - nSave: SAVING_THROW_* (not SAVING_THROW_TYPE_*)\r\n// - nValue: size of AC decrease\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\neffect EffectSavingThrowIncrease(int nSave, int nValue, int nSaveType = SAVING_THROW_TYPE_ALL);',
        '// 117: Create an AC Decrease effect\r\n// - nSave: SAVING_THROW_* (not SAVING_THROW_TYPE_*)\r\n// - nValue: size of AC decrease\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\neffect EffectSavingThrowIncrease(int nSave, int nValue, int nSaveType = SAVING_THROW_TYPE_ALL);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectAttackIncrease',
        [ScriptParam(DataType.INT, 'nBonus', None), ScriptParam(DataType.INT, 'nModifierType', 0), ],
        '// 118: Create an Attack Increase effect\r\n// - nBonus: size of attack bonus\r\n// - nModifierType: ATTACK_BONUS_*\r\neffect EffectAttackIncrease(int nBonus, int nModifierType = ATTACK_BONUS_MISC);',
        '// 118: Create an Attack Increase effect\r\n// - nBonus: size of attack bonus\r\n// - nModifierType: ATTACK_BONUS_*\r\neffect EffectAttackIncrease(int nBonus, int nModifierType = ATTACK_BONUS_MISC);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDamageReduction',
        [ScriptParam(DataType.INT, 'nAmount', None), ScriptParam(DataType.INT, 'nDamagePower', None), ScriptParam(DataType.INT, 'nLimit', 0), ],
        '// 119: Create a Damage Reduction effect\r\n// - nAmount: amount of damage reduction\r\n// - nDamagePower: DAMAGE_POWER_*\r\n// - nLimit: How much damage the effect can absorb before disappearing.\r\n//   Set to zero for infinite\r\neffect EffectDamageReduction(int nAmount, int nDamagePower, int nLimit = 0);',
        '// 119: Create a Damage Reduction effect\r\n// - nAmount: amount of damage reduction\r\n// - nDamagePower: DAMAGE_POWER_*\r\n// - nLimit: How much damage the effect can absorb before disappearing.\r\n//   Set to zero for infinite\r\neffect EffectDamageReduction(int nAmount, int nDamagePower, int nLimit = 0);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDamageIncrease',
        [ScriptParam(DataType.INT, 'nBonus', None), ScriptParam(DataType.INT, 'nDamageType', 8), ],
        '// 120: Create a Damage Increase effect\r\n// - nBonus: DAMAGE_BONUS_*\r\n// - nDamageType: DAMAGE_TYPE_*\r\neffect EffectDamageIncrease(int nBonus, int nDamageType = DAMAGE_TYPE_UNIVERSAL);',
        '// 120: Create a Damage Increase effect\r\n// - nBonus: DAMAGE_BONUS_*\r\n// - nDamageType: DAMAGE_TYPE_*\r\neffect EffectDamageIncrease(int nBonus, int nDamageType = DAMAGE_TYPE_UNIVERSAL);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'RoundsToSeconds',
        [ScriptParam(DataType.INT, 'nRounds', None), ],
        '// 121: Convert nRounds into a number of seconds\r\n// A round is always 6.0 seconds\r\nfloat RoundsToSeconds(int nRounds);',
        '// 121: Convert nRounds into a number of seconds\r\n// A round is always 6.0 seconds\r\nfloat RoundsToSeconds(int nRounds);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'HoursToSeconds',
        [ScriptParam(DataType.INT, 'nHours', None), ],
        '// 122: Convert nHours into a number of seconds\r\n// The result will depend on how many minutes there are per hour (game-time)\r\nfloat HoursToSeconds(int nHours);',
        '// 122: Convert nHours into a number of seconds\r\n// The result will depend on how many minutes there are per hour (game-time)\r\nfloat HoursToSeconds(int nHours);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'TurnsToSeconds',
        [ScriptParam(DataType.INT, 'nTurns', None), ],
        '// 123: Convert nTurns into a number of seconds\r\n// A turn is always 60.0 seconds\r\nfloat TurnsToSeconds(int nTurns);',
        '// 123: Convert nTurns into a number of seconds\r\n// A turn is always 60.0 seconds\r\nfloat TurnsToSeconds(int nTurns);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SoundObjectSetFixedVariance',
        [ScriptParam(DataType.OBJECT, 'oSound', None), ScriptParam(DataType.FLOAT, 'fFixedVariance', None), ],
        '// 124. SoundObjectSetFixedVariance\r\n// Sets the constant variance at which to play the sound object\r\n// This variance is a multiplier of the original sound\r\nvoid SoundObjectSetFixedVariance( object oSound, float fFixedVariance );',
        '// 124. SoundObjectSetFixedVariance\r\n// Sets the constant variance at which to play the sound object\r\n// This variance is a multiplier of the original sound\r\nvoid SoundObjectSetFixedVariance( object oSound, float fFixedVariance );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetGoodEvilValue',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        "// 125: Get an integer between 0 and 100 (inclusive) to represent oCreature's\r\n// Good/Evil alignment\r\n// (100 = good, 0 = evil)\r\n// * Return value if oCreature is not a valid creature: -1\r\nint GetGoodEvilValue(object oCreature);",
        "// 125: Get an integer between 0 and 100 (inclusive) to represent oCreature's\r\n// Good/Evil alignment\r\n// (100 = good, 0 = evil)\r\n// * Return value if oCreature is not a valid creature: -1\r\nint GetGoodEvilValue(object oCreature);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetPartyMemberCount',
        [],
        '// 126: GetPartyMemberCount\r\n// Returns a count of how many members are in the party including the player character\r\nint GetPartyMemberCount();',
        '// 126: GetPartyMemberCount\r\n// Returns a count of how many members are in the party including the player character\r\nint GetPartyMemberCount();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetAlignmentGoodEvil',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        "// 127: Return an ALIGNMENT_* constant to represent oCreature's good/evil alignment\r\n// * Return value if oCreature is not a valid creature: -1\r\nint GetAlignmentGoodEvil(object oCreature);",
        "// 127: Return an ALIGNMENT_* constant to represent oCreature's good/evil alignment\r\n// * Return value if oCreature is not a valid creature: -1\r\nint GetAlignmentGoodEvil(object oCreature);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFirstObjectInShape',
        [ScriptParam(DataType.INT, 'nShape', None), ScriptParam(DataType.FLOAT, 'fSize', None), ScriptParam(DataType.LOCATION, 'lTarget', None), ScriptParam(DataType.INT, 'bLineOfSight', 0), ScriptParam(DataType.INT, 'nObjectFilter', 1), ScriptParam(DataType.VECTOR, 'vOrigin', Vector3(0.0, 0.0, 0.0)), ],
        '// 128: Get the first object in nShape\r\n// - nShape: SHAPE_*\r\n// - fSize:\r\n//   -> If nShape  =  =  SHAPE_SPHERE, this is the radius of the sphere\r\n//   -> If nShape  =  =  SHAPE_SPELLCYLINDER, this is the radius of the cylinder\r\n//   -> If nShape  =  =  SHAPE_CONE, this is the widest radius of the cone\r\n//   -> If nShape  =  =  SHAPE_CUBE, this is half the length of one of the sides of\r\n//      the cube\r\n// - lTarget: This is the centre of the effect, usually GetSpellTargetPosition(),\r\n//   or the end of a cylinder or cone.\r\n// - bLineOfSight: This controls whether to do a line-of-sight check on the\r\n//   object returned.\r\n//   (This can be used to ensure that spell effects do not go through walls.)\r\n// - nObjectFilter: This allows you to filter out undesired object types, using\r\n//   bitwise "or".\r\n//   For example, to return only creatures and doors, the value for this\r\n//   parameter would be OBJECT_TYPE_CREATURE | OBJECT_TYPE_DOOR\r\n// - vOrigin: This is only used for cylinders and cones, and specifies the\r\n//   origin of the effect(normally the spell-caster\'s position).\r\n// Return value on error: OBJECT_INVALID\r\nobject GetFirstObjectInShape(int nShape, float fSize, location lTarget, int bLineOfSight = FALSE, int nObjectFilter = OBJECT_TYPE_CREATURE, vector vOrigin = [0.0,0.0,0.0]);',
        '// 128: Get the first object in nShape\r\n// - nShape: SHAPE_*\r\n// - fSize:\r\n//   -> If nShape  =  =  SHAPE_SPHERE, this is the radius of the sphere\r\n//   -> If nShape  =  =  SHAPE_SPELLCYLINDER, this is the radius of the cylinder\r\n//   -> If nShape  =  =  SHAPE_CONE, this is the widest radius of the cone\r\n//   -> If nShape  =  =  SHAPE_CUBE, this is half the length of one of the sides of\r\n//      the cube\r\n// - lTarget: This is the centre of the effect, usually GetSpellTargetPosition(),\r\n//   or the end of a cylinder or cone.\r\n// - bLineOfSight: This controls whether to do a line-of-sight check on the\r\n//   object returned.\r\n//   (This can be used to ensure that spell effects do not go through walls.)\r\n// - nObjectFilter: This allows you to filter out undesired object types, using\r\n//   bitwise "or".\r\n//   For example, to return only creatures and doors, the value for this\r\n//   parameter would be OBJECT_TYPE_CREATURE | OBJECT_TYPE_DOOR\r\n// - vOrigin: This is only used for cylinders and cones, and specifies the\r\n//   origin of the effect(normally the spell-caster\'s position).\r\n// Return value on error: OBJECT_INVALID\r\nobject GetFirstObjectInShape(int nShape, float fSize, location lTarget, int bLineOfSight = FALSE, int nObjectFilter = OBJECT_TYPE_CREATURE, vector vOrigin = [0.0,0.0,0.0]);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNextObjectInShape',
        [ScriptParam(DataType.INT, 'nShape', None), ScriptParam(DataType.FLOAT, 'fSize', None), ScriptParam(DataType.LOCATION, 'lTarget', None), ScriptParam(DataType.INT, 'bLineOfSight', 0), ScriptParam(DataType.INT, 'nObjectFilter', 1), ScriptParam(DataType.VECTOR, 'vOrigin', Vector3(0.0, 0.0, 0.0)), ],
        '// 129: Get the next object in nShape\r\n// - nShape: SHAPE_*\r\n// - fSize:\r\n//   -> If nShape  =  =  SHAPE_SPHERE, this is the radius of the sphere\r\n//   -> If nShape  =  =  SHAPE_SPELLCYLINDER, this is the radius of the cylinder\r\n//   -> If nShape  =  =  SHAPE_CONE, this is the widest radius of the cone\r\n//   -> If nShape  =  =  SHAPE_CUBE, this is half the length of one of the sides of\r\n//      the cube\r\n// - lTarget: This is the centre of the effect, usually GetSpellTargetPosition(),\r\n//   or the end of a cylinder or cone.\r\n// - bLineOfSight: This controls whether to do a line-of-sight check on the\r\n//   object returned. (This can be used to ensure that spell effects do not go\r\n//   through walls.)\r\n// - nObjectFilter: This allows you to filter out undesired object types, using\r\n//   bitwise "or". For example, to return only creatures and doors, the value for\r\n//   this parameter would be OBJECT_TYPE_CREATURE | OBJECT_TYPE_DOOR\r\n// - vOrigin: This is only used for cylinders and cones, and specifies the origin\r\n//   of the effect (normally the spell-caster\'s position).\r\n// Return value on error: OBJECT_INVALID\r\nobject GetNextObjectInShape(int nShape, float fSize, location lTarget, int bLineOfSight = FALSE, int nObjectFilter = OBJECT_TYPE_CREATURE, vector vOrigin = [0.0,0.0,0.0]);',
        '// 129: Get the next object in nShape\r\n// - nShape: SHAPE_*\r\n// - fSize:\r\n//   -> If nShape  =  =  SHAPE_SPHERE, this is the radius of the sphere\r\n//   -> If nShape  =  =  SHAPE_SPELLCYLINDER, this is the radius of the cylinder\r\n//   -> If nShape  =  =  SHAPE_CONE, this is the widest radius of the cone\r\n//   -> If nShape  =  =  SHAPE_CUBE, this is half the length of one of the sides of\r\n//      the cube\r\n// - lTarget: This is the centre of the effect, usually GetSpellTargetPosition(),\r\n//   or the end of a cylinder or cone.\r\n// - bLineOfSight: This controls whether to do a line-of-sight check on the\r\n//   object returned. (This can be used to ensure that spell effects do not go\r\n//   through walls.)\r\n// - nObjectFilter: This allows you to filter out undesired object types, using\r\n//   bitwise "or". For example, to return only creatures and doors, the value for\r\n//   this parameter would be OBJECT_TYPE_CREATURE | OBJECT_TYPE_DOOR\r\n// - vOrigin: This is only used for cylinders and cones, and specifies the origin\r\n//   of the effect (normally the spell-caster\'s position).\r\n// Return value on error: OBJECT_INVALID\r\nobject GetNextObjectInShape(int nShape, float fSize, location lTarget, int bLineOfSight = FALSE, int nObjectFilter = OBJECT_TYPE_CREATURE, vector vOrigin = [0.0,0.0,0.0]);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectEntangle',
        [],
        "// 130: Create an Entangle effect\r\n// When applied, this effect will restrict the creature's movement and apply a\r\n// (-2) to all attacks and a -4 to AC.\r\neffect EffectEntangle();",
        "// 130: Create an Entangle effect\r\n// When applied, this effect will restrict the creature's movement and apply a\r\n// (-2) to all attacks and a -4 to AC.\r\neffect EffectEntangle();"
    ),
    ScriptFunction(
        DataType.VOID,
        'SignalEvent',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.EVENT, 'evToRun', None), ],
        '// 131: Cause oObject to run evToRun\r\nvoid SignalEvent(object oObject, event evToRun);',
        '// 131: Cause oObject to run evToRun\r\nvoid SignalEvent(object oObject, event evToRun);'
    ),
    ScriptFunction(
        DataType.EVENT,
        'EventUserDefined',
        [ScriptParam(DataType.INT, 'nUserDefinedEventNumber', None), ],
        '// 132: Create an event of the type nUserDefinedEventNumber\r\nevent EventUserDefined(int nUserDefinedEventNumber);',
        '// 132: Create an event of the type nUserDefinedEventNumber\r\nevent EventUserDefined(int nUserDefinedEventNumber);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDeath',
        [ScriptParam(DataType.INT, 'nSpectacularDeath', 0), ScriptParam(DataType.INT, 'nDisplayFeedback', 1), ScriptParam(DataType.INT, 'nNoFadeAway', 0), ],
        '// 133: Create a Death effect\r\n// - nSpectacularDeath: if this is TRUE, the creature to which this effect is\r\n//   applied will die in an extraordinary fashion\r\n// - nDisplayFeedback\r\n// - nNoFadeAway: Passing TRUE for this parameter will keep the bodies from fading after the creature\r\n//                dies. Note that NO XP will be awarded if the creature is killed with this parameter.\r\neffect EffectDeath(int nSpectacularDeath = FALSE, int nDisplayFeedback = TRUE, int nNoFadeAway = FALSE);',
        '// 133: Create a Death effect\r\n// - nSpectacularDeath: if this is TRUE, the creature to which this effect is\r\n//   applied will die in an extraordinary fashion\r\n// - nDisplayFeedback\r\n// - nNoFadeAway: Passing TRUE for this parameter will keep the bodies from fading after the creature\r\n//                dies. Note that NO XP will be awarded if the creature is killed with this parameter.\r\neffect EffectDeath(int nSpectacularDeath = FALSE, int nDisplayFeedback = TRUE, int nNoFadeAway = FALSE);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectKnockdown',
        [],
        '// 134: Create a Knockdown effect\r\n// This effect knocks creatures off their feet, they will sit until the effect\r\n// is removed. This should be applied as a temporary effect with a 3 second\r\n// duration minimum (1 second to fall, 1 second sitting, 1 second to get up).\r\neffect EffectKnockdown();',
        '// 134: Create a Knockdown effect\r\n// This effect knocks creatures off their feet, they will sit until the effect\r\n// is removed. This should be applied as a temporary effect with a 3 second\r\n// duration minimum (1 second to fall, 1 second sitting, 1 second to get up).\r\neffect EffectKnockdown();'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionGiveItem',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.OBJECT, 'oGiveTo', None), ],
        '// 135: Give oItem to oGiveTo\r\n// If oItem is not a valid item, or oGiveTo is not a valid object, nothing will\r\n// happen.\r\nvoid ActionGiveItem(object oItem, object oGiveTo);',
        '// 135: Give oItem to oGiveTo\r\n// If oItem is not a valid item, or oGiveTo is not a valid object, nothing will\r\n// happen.\r\nvoid ActionGiveItem(object oItem, object oGiveTo);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionTakeItem',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.OBJECT, 'oTakeFrom', None), ],
        '// 136: Take oItem from oTakeFrom\r\n// If oItem is not a valid item, or oTakeFrom is not a valid object, nothing\r\n// will happen.\r\nvoid ActionTakeItem(object oItem, object oTakeFrom);',
        '// 136: Take oItem from oTakeFrom\r\n// If oItem is not a valid item, or oTakeFrom is not a valid object, nothing\r\n// will happen.\r\nvoid ActionTakeItem(object oItem, object oTakeFrom);'
    ),
    ScriptFunction(
        DataType.VECTOR,
        'VectorNormalize',
        [ScriptParam(DataType.VECTOR, 'vVector', None), ],
        '// 137: Normalize vVector\r\nvector VectorNormalize(vector vVector);',
        '// 137: Normalize vVector\r\nvector VectorNormalize(vector vVector);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetItemStackSize',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 138:\r\n// Gets the stack size of an item.\r\nint GetItemStackSize( object oItem );',
        '// 138:\r\n// Gets the stack size of an item.\r\nint GetItemStackSize( object oItem );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetAbilityScore',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nAbilityType', None), ],
        '// 139: Get the ability score of type nAbility for a creature (otherwise 0)\r\n// - oCreature: the creature whose ability score we wish to find out\r\n// - nAbilityType: ABILITY_*\r\n// Return value on error: 0\r\nint GetAbilityScore(object oCreature, int nAbilityType);',
        '// 139: Get the ability score of type nAbility for a creature (otherwise 0)\r\n// - oCreature: the creature whose ability score we wish to find out\r\n// - nAbilityType: ABILITY_*\r\n// Return value on error: 0\r\nint GetAbilityScore(object oCreature, int nAbilityType);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsDead',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 140: * Returns TRUE if oCreature is a dead NPC, dead PC or a dying PC.\r\nint GetIsDead(object oCreature);',
        '// 140: * Returns TRUE if oCreature is a dead NPC, dead PC or a dying PC.\r\nint GetIsDead(object oCreature);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PrintVector',
        [ScriptParam(DataType.VECTOR, 'vVector', None), ScriptParam(DataType.INT, 'bPrepend', None), ],
        '// 141: Output vVector to the logfile.\r\n// - vVector\r\n// - bPrepend: if this is TRUE, the message will be prefixed with "PRINTVECTOR:"\r\nvoid PrintVector(vector vVector, int bPrepend);',
        '// 141: Output vVector to the logfile.\r\n// - vVector\r\n// - bPrepend: if this is TRUE, the message will be prefixed with "PRINTVECTOR:"\r\nvoid PrintVector(vector vVector, int bPrepend);'
    ),
    ScriptFunction(
        DataType.VECTOR,
        'Vector',
        [ScriptParam(DataType.FLOAT, 'x', 0.0), ScriptParam(DataType.FLOAT, 'y', 0.0), ScriptParam(DataType.FLOAT, 'z', 0.0), ],
        '// 142: Create a vector with the specified values for x, y and z\r\nvector Vector(float x = 0.0f, float y = 0.0f, float z = 0.0f);',
        '// 142: Create a vector with the specified values for x, y and z\r\nvector Vector(float x = 0.0f, float y = 0.0f, float z = 0.0f);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetFacingPoint',
        [ScriptParam(DataType.VECTOR, 'vTarget', None), ],
        '// 143: Cause the caller to face vTarget\r\nvoid SetFacingPoint(vector vTarget);',
        '// 143: Cause the caller to face vTarget\r\nvoid SetFacingPoint(vector vTarget);'
    ),
    ScriptFunction(
        DataType.VECTOR,
        'AngleToVector',
        [ScriptParam(DataType.FLOAT, 'fAngle', None), ],
        '// 144: Convert fAngle to a vector\r\nvector AngleToVector(float fAngle);',
        '// 144: Convert fAngle to a vector\r\nvector AngleToVector(float fAngle);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'VectorToAngle',
        [ScriptParam(DataType.VECTOR, 'vVector', None), ],
        '// 145: Convert vVector to an angle\r\nfloat VectorToAngle(vector vVector);',
        '// 145: Convert vVector to an angle\r\nfloat VectorToAngle(vector vVector);'
    ),
    ScriptFunction(
        DataType.INT,
        'TouchAttackMelee',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'bDisplayFeedback', 1), ],
        '// 146: The caller will perform a Melee Touch Attack on oTarget\r\n// This is not an action, and it assumes the caller is already within range of\r\n// oTarget\r\n// * Returns 0 on a miss, 1 on a hit and 2 on a critical hit\r\nint TouchAttackMelee(object oTarget, int bDisplayFeedback = TRUE);',
        '// 146: The caller will perform a Melee Touch Attack on oTarget\r\n// This is not an action, and it assumes the caller is already within range of\r\n// oTarget\r\n// * Returns 0 on a miss, 1 on a hit and 2 on a critical hit\r\nint TouchAttackMelee(object oTarget, int bDisplayFeedback = TRUE);'
    ),
    ScriptFunction(
        DataType.INT,
        'TouchAttackRanged',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'bDisplayFeedback', 1), ],
        '// 147: The caller will perform a Ranged Touch Attack on oTarget\r\n// * Returns 0 on a miss, 1 on a hit and 2 on a critical hit\r\nint TouchAttackRanged(object oTarget, int bDisplayFeedback = TRUE);',
        '// 147: The caller will perform a Ranged Touch Attack on oTarget\r\n// * Returns 0 on a miss, 1 on a hit and 2 on a critical hit\r\nint TouchAttackRanged(object oTarget, int bDisplayFeedback = TRUE);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectParalyze',
        [],
        '// 148: Create a Paralyze effect\r\neffect EffectParalyze();',
        '// 148: Create a Paralyze effect\r\neffect EffectParalyze();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectSpellImmunity',
        [ScriptParam(DataType.INT, 'nImmunityToSpell', -1), ],
        '// 149: Create a Spell Immunity effect.\r\n// There is a known bug with this function. There *must* be a parameter specified\r\n// when this is called (even if the desired parameter is SPELL_ALL_SPELLS),\r\n// otherwise an effect of type EFFECT_TYPE_INVALIDEFFECT will be returned.\r\n// - nImmunityToSpell: SPELL_*\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nImmunityToSpell is\r\n//   invalid.\r\neffect EffectSpellImmunity(int nImmunityToSpell = FORCE_POWER_ALL_FORCE_POWERS);',
        '// 149: Create a Spell Immunity effect.\r\n// There is a known bug with this function. There *must* be a parameter specified\r\n// when this is called (even if the desired parameter is SPELL_ALL_SPELLS),\r\n// otherwise an effect of type EFFECT_TYPE_INVALIDEFFECT will be returned.\r\n// - nImmunityToSpell: SPELL_*\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nImmunityToSpell is\r\n//   invalid.\r\neffect EffectSpellImmunity(int nImmunityToSpell = FORCE_POWER_ALL_FORCE_POWERS);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetItemStackSize',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.INT, 'nStackSize', None), ],
        '// 150:\r\n// Set the stack size of an item.\r\n// NOTE: The stack size will be clamped to between 1 and the max stack size (as\r\n//       specified in the base item).\r\nvoid SetItemStackSize( object oItem, int nStackSize );',
        '// 150:\r\n// Set the stack size of an item.\r\n// NOTE: The stack size will be clamped to between 1 and the max stack size (as\r\n//       specified in the base item).\r\nvoid SetItemStackSize( object oItem, int nStackSize );'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetDistanceBetween',
        [ScriptParam(DataType.OBJECT, 'oObjectA', None), ScriptParam(DataType.OBJECT, 'oObjectB', None), ],
        '// 151: Get the distance in metres between oObjectA and oObjectB.\r\n// * Return value if either object is invalid: 0.0f\r\nfloat GetDistanceBetween(object oObjectA, object oObjectB);',
        '// 151: Get the distance in metres between oObjectA and oObjectB.\r\n// * Return value if either object is invalid: 0.0f\r\nfloat GetDistanceBetween(object oObjectA, object oObjectB);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetReturnStrref',
        [ScriptParam(DataType.INT, 'bShow', None), ScriptParam(DataType.INT, 'srStringRef', 0), ScriptParam(DataType.INT, 'srReturnQueryStrRef', 0), ],
        "// 152: SetReturnStrref\r\n// This function will turn on/off the display of the 'return to ebon hawk' option\r\n// on the map screen and allow the string to be changed to an arbitrary string ref\r\n// srReturnQueryStrRef is the string ref that will be displayed in the query pop\r\n// up confirming that you wish to return to the specified location.\r\nvoid SetReturnStrref(int bShow, int srStringRef  =  0, int srReturnQueryStrRef  =  0);",
        "// 152: SetReturnStrref\r\n// This function will turn on/off the display of the 'return to ebon hawk' option\r\n// on the map screen and allow the string to be changed to an arbitrary string ref\r\n// srReturnQueryStrRef is the string ref that will be displayed in the query pop\r\n// up confirming that you wish to return to the specified location.\r\nvoid SetReturnStrref(int bShow, int srStringRef  =  0, int srReturnQueryStrRef  =  0);"
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectForceJump',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'nAdvanced', 0), ],
        '// 153: EffectForceJump\r\n// The effect required for force jumping\r\neffect EffectForceJump(object oTarget, int nAdvanced  =  0);',
        '// 153: EffectForceJump\r\n// The effect required for force jumping\r\neffect EffectForceJump(object oTarget, int nAdvanced  =  0);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectSleep',
        [],
        '// 154: Create a Sleep effect\r\neffect EffectSleep();',
        '// 154: Create a Sleep effect\r\neffect EffectSleep();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetItemInSlot',
        [ScriptParam(DataType.INT, 'nInventorySlot', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        "// 155: Get the object which is in oCreature's specified inventory slot\r\n// - nInventorySlot: INVENTORY_SLOT_*\r\n// - oCreature\r\n// * Returns OBJECT_INVALID if oCreature is not a valid creature or there is no\r\n//   item in nInventorySlot.\r\nobject GetItemInSlot(int nInventorySlot, object oCreature = OBJECT_SELF);",
        "// 155: Get the object which is in oCreature's specified inventory slot\r\n// - nInventorySlot: INVENTORY_SLOT_*\r\n// - oCreature\r\n// * Returns OBJECT_INVALID if oCreature is not a valid creature or there is no\r\n//   item in nInventorySlot.\r\nobject GetItemInSlot(int nInventorySlot, object oCreature = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectTemporaryForcePoints',
        [ScriptParam(DataType.INT, 'nTempForce', None), ],
        '// 156: This was previously EffectCharmed();\r\neffect EffectTemporaryForcePoints(int nTempForce);',
        '// 156: This was previously EffectCharmed();\r\neffect EffectTemporaryForcePoints(int nTempForce);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectConfused',
        [],
        '// 157: Create a Confuse effect\r\neffect EffectConfused();',
        '// 157: Create a Confuse effect\r\neffect EffectConfused();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectFrightened',
        [],
        '// 158: Create a Frighten effect\r\neffect EffectFrightened();',
        '// 158: Create a Frighten effect\r\neffect EffectFrightened();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectChoke',
        [],
        '// 159: Choke the bugger...\r\neffect EffectChoke( );',
        '// 159: Choke the bugger...\r\neffect EffectChoke( );'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetGlobalString',
        [ScriptParam(DataType.STRING, 'sIdentifier', None), ScriptParam(DataType.STRING, 'sValue', None), ],
        "// 160: Sets a global string with the specified identifier.  This is an EXTREMELY\r\n//      restricted function - do not use without expilicit permission.\r\n//      This means if you are not Preston.  Then go see him if you're even thinking\r\n//      about using this.\r\nvoid SetGlobalString( string sIdentifier, string sValue );",
        "// 160: Sets a global string with the specified identifier.  This is an EXTREMELY\r\n//      restricted function - do not use without expilicit permission.\r\n//      This means if you are not Preston.  Then go see him if you're even thinking\r\n//      about using this.\r\nvoid SetGlobalString( string sIdentifier, string sValue );"
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectStunned',
        [],
        '// 161: Create a Stun effect\r\neffect EffectStunned();',
        '// 161: Create a Stun effect\r\neffect EffectStunned();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetCommandable',
        [ScriptParam(DataType.INT, 'bCommandable', None), ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        "// 162: Set whether oTarget's action stack can be modified\r\nvoid SetCommandable(int bCommandable, object oTarget = OBJECT_SELF);",
        "// 162: Set whether oTarget's action stack can be modified\r\nvoid SetCommandable(int bCommandable, object oTarget = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetCommandable',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        "// 163: Determine whether oTarget's action stack can be modified.\r\nint GetCommandable(object oTarget = OBJECT_SELF);",
        "// 163: Determine whether oTarget's action stack can be modified.\r\nint GetCommandable(object oTarget = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectRegenerate',
        [ScriptParam(DataType.INT, 'nAmount', None), ScriptParam(DataType.FLOAT, 'fIntervalSeconds', None), ],
        '// 164: Create a Regenerate effect.\r\n// - nAmount: amount of damage to be regenerated per time interval\r\n// - fIntervalSeconds: length of interval in seconds\r\neffect EffectRegenerate(int nAmount, float fIntervalSeconds);',
        '// 164: Create a Regenerate effect.\r\n// - nAmount: amount of damage to be regenerated per time interval\r\n// - fIntervalSeconds: length of interval in seconds\r\neffect EffectRegenerate(int nAmount, float fIntervalSeconds);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectMovementSpeedIncrease',
        [ScriptParam(DataType.INT, 'nNewSpeedPercent', None), ],
        '// 165: Create a Movement Speed Increase effect.\r\n// - nNewSpeedPercent: This works in a dodgy way so please read this notes carefully.\r\n//   If you supply an integer under 100, 100 gets added to it to produce the final speed.\r\n//   e.g. if you supply 50, then the resulting speed is 150% of the original speed.\r\n//   If you supply 100 or above, then this is used directly as the resulting speed.\r\n//   e.g. if you specify 100, then the resulting speed is 100% of the original speed that is,\r\n//        it is unchanged.\r\n//        However if you specify 200, then the resulting speed is double the original speed.\r\neffect EffectMovementSpeedIncrease(int nNewSpeedPercent);',
        '// 165: Create a Movement Speed Increase effect.\r\n// - nNewSpeedPercent: This works in a dodgy way so please read this notes carefully.\r\n//   If you supply an integer under 100, 100 gets added to it to produce the final speed.\r\n//   e.g. if you supply 50, then the resulting speed is 150% of the original speed.\r\n//   If you supply 100 or above, then this is used directly as the resulting speed.\r\n//   e.g. if you specify 100, then the resulting speed is 100% of the original speed that is,\r\n//        it is unchanged.\r\n//        However if you specify 200, then the resulting speed is double the original speed.\r\neffect EffectMovementSpeedIncrease(int nNewSpeedPercent);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetHitDice',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 166: Get the number of hitdice for oCreature.\r\n// * Return value if oCreature is not a valid creature: 0\r\nint GetHitDice(object oCreature);',
        '// 166: Get the number of hitdice for oCreature.\r\n// * Return value if oCreature is not a valid creature: 0\r\nint GetHitDice(object oCreature);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionForceFollowObject',
        [ScriptParam(DataType.OBJECT, 'oFollow', None), ScriptParam(DataType.FLOAT, 'fFollowDistance', 0.0), ],
        '// 167: The action subject will follow oFollow until a ClearAllActions() is called.\r\n// - oFollow: this is the object to be followed\r\n// - fFollowDistance: follow distance in metres\r\n// * No return value\r\nvoid ActionForceFollowObject(object oFollow, float fFollowDistance = 0.0f);',
        '// 167: The action subject will follow oFollow until a ClearAllActions() is called.\r\n// - oFollow: this is the object to be followed\r\n// - fFollowDistance: follow distance in metres\r\n// * No return value\r\nvoid ActionForceFollowObject(object oFollow, float fFollowDistance = 0.0f);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetTag',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 168: Get the Tag of oObject\r\n// * Return value if oObject is not a valid object: ""\r\nstring GetTag(object oObject);',
        '// 168: Get the Tag of oObject\r\n// * Return value if oObject is not a valid object: ""\r\nstring GetTag(object oObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'ResistForce',
        [ScriptParam(DataType.OBJECT, 'oSource', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 169: Do a Force Resistance check between oSource and oTarget, returning TRUE if\r\n// the force was resisted.\r\n// * Return value if oSource or oTarget is an invalid object: FALSE\r\nint ResistForce(object oSource, object oTarget);',
        '// 169: Do a Force Resistance check between oSource and oTarget, returning TRUE if\r\n// the force was resisted.\r\n// * Return value if oSource or oTarget is an invalid object: FALSE\r\nint ResistForce(object oSource, object oTarget);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetEffectType',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 170: Get the effect type (EFFECT_TYPE_*) of eEffect.\r\n// * Return value if eEffect is invalid: EFFECT_INVALIDEFFECT\r\nint GetEffectType(effect eEffect);',
        '// 170: Get the effect type (EFFECT_TYPE_*) of eEffect.\r\n// * Return value if eEffect is invalid: EFFECT_INVALIDEFFECT\r\nint GetEffectType(effect eEffect);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectAreaOfEffect',
        [ScriptParam(DataType.INT, 'nAreaEffectId', None), ScriptParam(DataType.STRING, 'sOnEnterScript', ''), ScriptParam(DataType.STRING, 'sHeartbeatScript', ''), ScriptParam(DataType.STRING, 'sOnExitScript', ''), ],
        '// 171: Create an Area Of Effect effect in the area of the creature it is applied to.\r\n// If the scripts are not specified, default ones will be used.\r\neffect EffectAreaOfEffect(int nAreaEffectId, string sOnEnterScript = "", string sHeartbeatScript = "", string sOnExitScript = "");',
        '// 171: Create an Area Of Effect effect in the area of the creature it is applied to.\r\n// If the scripts are not specified, default ones will be used.\r\neffect EffectAreaOfEffect(int nAreaEffectId, string sOnEnterScript = "", string sHeartbeatScript = "", string sOnExitScript = "");'
    ),
    ScriptFunction(
        DataType.INT,
        'GetFactionEqual',
        [ScriptParam(DataType.OBJECT, 'oFirstObject', None), ScriptParam(DataType.OBJECT, 'oSecondObject', 0), ],
        '// 172: * Returns TRUE if the Faction Ids of the two objects are the same\r\nint GetFactionEqual(object oFirstObject, object oSecondObject = OBJECT_SELF);',
        '// 172: * Returns TRUE if the Faction Ids of the two objects are the same\r\nint GetFactionEqual(object oFirstObject, object oSecondObject = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ChangeFaction',
        [ScriptParam(DataType.OBJECT, 'oObjectToChangeFaction', None), ScriptParam(DataType.OBJECT, 'oMemberOfFactionToJoin', None), ],
        '// 173: Make oObjectToChangeFaction join the faction of oMemberOfFactionToJoin.\r\n// NB. ** This will only work for two NPCs **\r\nvoid ChangeFaction(object oObjectToChangeFaction, object oMemberOfFactionToJoin);',
        '// 173: Make oObjectToChangeFaction join the faction of oMemberOfFactionToJoin.\r\n// NB. ** This will only work for two NPCs **\r\nvoid ChangeFaction(object oObjectToChangeFaction, object oMemberOfFactionToJoin);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsListening',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 174: * Returns TRUE if oObject is listening for something\r\nint GetIsListening(object oObject);',
        '// 174: * Returns TRUE if oObject is listening for something\r\nint GetIsListening(object oObject);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetListening',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.INT, 'bValue', None), ],
        '// 175: Set whether oObject is listening.\r\nvoid SetListening(object oObject, int bValue);',
        '// 175: Set whether oObject is listening.\r\nvoid SetListening(object oObject, int bValue);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetListenPattern',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.STRING, 'sPattern', None), ScriptParam(DataType.INT, 'nNumber', 0), ],
        '// 176: Set the string for oObject to listen for.\r\n// Note: this does not set oObject to be listening.\r\nvoid SetListenPattern(object oObject, string sPattern, int nNumber = 0);',
        '// 176: Set the string for oObject to listen for.\r\n// Note: this does not set oObject to be listening.\r\nvoid SetListenPattern(object oObject, string sPattern, int nNumber = 0);'
    ),
    ScriptFunction(
        DataType.INT,
        'TestStringAgainstPattern',
        [ScriptParam(DataType.STRING, 'sPattern', None), ScriptParam(DataType.STRING, 'sStringToTest', None), ],
        '// 177: * Returns TRUE if sStringToTest matches sPattern.\r\nint TestStringAgainstPattern(string sPattern, string sStringToTest);',
        '// 177: * Returns TRUE if sStringToTest matches sPattern.\r\nint TestStringAgainstPattern(string sPattern, string sStringToTest);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetMatchedSubstring',
        [ScriptParam(DataType.INT, 'nString', None), ],
        '// 178: Get the appropriate matched string (this should only be used in\r\n// OnConversation scripts).\r\n// * Returns the appropriate matched string, otherwise returns ""\r\nstring GetMatchedSubstring(int nString);',
        '// 178: Get the appropriate matched string (this should only be used in\r\n// OnConversation scripts).\r\n// * Returns the appropriate matched string, otherwise returns ""\r\nstring GetMatchedSubstring(int nString);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetMatchedSubstringsCount',
        [],
        '// 179: Get the number of string parameters available.\r\n// * Returns -1 if no string matched (this could be because of a dialogue event)\r\nint GetMatchedSubstringsCount();',
        '// 179: Get the number of string parameters available.\r\n// * Returns -1 if no string matched (this could be because of a dialogue event)\r\nint GetMatchedSubstringsCount();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectVisualEffect',
        [ScriptParam(DataType.INT, 'nVisualEffectId', None), ScriptParam(DataType.INT, 'nMissEffect', 0), ],
        '// 180: * Create a Visual Effect that can be applied to an object.\r\n// - nVisualEffectId\r\n// - nMissEffect: if this is TRUE, a random vector near or past the target will\r\n//   be generated, on which to play the effect\r\neffect EffectVisualEffect(int nVisualEffectId, int nMissEffect = FALSE);',
        '// 180: * Create a Visual Effect that can be applied to an object.\r\n// - nVisualEffectId\r\n// - nMissEffect: if this is TRUE, a random vector near or past the target will\r\n//   be generated, on which to play the effect\r\neffect EffectVisualEffect(int nVisualEffectId, int nMissEffect = FALSE);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFactionWeakestMember',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', 0), ScriptParam(DataType.INT, 'bMustBeVisible', 1), ],
        "// 181: Get the weakest member of oFactionMember's faction.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionWeakestMember(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);",
        "// 181: Get the weakest member of oFactionMember's faction.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionWeakestMember(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFactionStrongestMember',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', 0), ScriptParam(DataType.INT, 'bMustBeVisible', 1), ],
        "// 182: Get the strongest member of oFactionMember's faction.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionStrongestMember(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);",
        "// 182: Get the strongest member of oFactionMember's faction.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionStrongestMember(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFactionMostDamagedMember',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', 0), ScriptParam(DataType.INT, 'bMustBeVisible', 1), ],
        "// 183: Get the member of oFactionMember's faction that has taken the most hit points\r\n// of damage.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionMostDamagedMember(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);",
        "// 183: Get the member of oFactionMember's faction that has taken the most hit points\r\n// of damage.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionMostDamagedMember(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFactionLeastDamagedMember',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', 0), ScriptParam(DataType.INT, 'bMustBeVisible', 1), ],
        "// 184: Get the member of oFactionMember's faction that has taken the fewest hit\r\n// points of damage.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionLeastDamagedMember(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);",
        "// 184: Get the member of oFactionMember's faction that has taken the fewest hit\r\n// points of damage.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionLeastDamagedMember(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetFactionGold',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', None), ],
        "// 185: Get the amount of gold held by oFactionMember's faction.\r\n// * Returns -1 if oFactionMember's faction is invalid.\r\nint GetFactionGold(object oFactionMember);",
        "// 185: Get the amount of gold held by oFactionMember's faction.\r\n// * Returns -1 if oFactionMember's faction is invalid.\r\nint GetFactionGold(object oFactionMember);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetFactionAverageReputation',
        [ScriptParam(DataType.OBJECT, 'oSourceFactionMember', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        "// 186: Get an integer between 0 and 100 (inclusive) that represents how\r\n// oSourceFactionMember's faction feels about oTarget.\r\n// * Return value on error: -1\r\nint GetFactionAverageReputation(object oSourceFactionMember, object oTarget);",
        "// 186: Get an integer between 0 and 100 (inclusive) that represents how\r\n// oSourceFactionMember's faction feels about oTarget.\r\n// * Return value on error: -1\r\nint GetFactionAverageReputation(object oSourceFactionMember, object oTarget);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetFactionAverageGoodEvilAlignment',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', None), ],
        "// 187: Get an integer between 0 and 100 (inclusive) that represents the average\r\n// good/evil alignment of oFactionMember's faction.\r\n// * Return value on error: -1\r\nint GetFactionAverageGoodEvilAlignment(object oFactionMember);",
        "// 187: Get an integer between 0 and 100 (inclusive) that represents the average\r\n// good/evil alignment of oFactionMember's faction.\r\n// * Return value on error: -1\r\nint GetFactionAverageGoodEvilAlignment(object oFactionMember);"
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SoundObjectGetFixedVariance',
        [ScriptParam(DataType.OBJECT, 'oSound', None), ],
        '// 188. SoundObjectGetFixedVariance\r\n// Gets the constant variance at which to play the sound object\r\nfloat SoundObjectGetFixedVariance(object oSound);',
        '// 188. SoundObjectGetFixedVariance\r\n// Gets the constant variance at which to play the sound object\r\nfloat SoundObjectGetFixedVariance(object oSound);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetFactionAverageLevel',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', None), ],
        '// 189: Get the average level of the members of the faction.\r\n// * Return value on error: -1\r\nint GetFactionAverageLevel(object oFactionMember);',
        '// 189: Get the average level of the members of the faction.\r\n// * Return value on error: -1\r\nint GetFactionAverageLevel(object oFactionMember);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetFactionAverageXP',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', None), ],
        '// 190: Get the average XP of the members of the faction.\r\n// * Return value on error: -1\r\nint GetFactionAverageXP(object oFactionMember);',
        '// 190: Get the average XP of the members of the faction.\r\n// * Return value on error: -1\r\nint GetFactionAverageXP(object oFactionMember);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetFactionMostFrequentClass',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', None), ],
        '// 191: Get the most frequent class in the faction - this can be compared with the\r\n// constants CLASS_TYPE_*.\r\n// * Return value on error: -1\r\nint GetFactionMostFrequentClass(object oFactionMember);',
        '// 191: Get the most frequent class in the faction - this can be compared with the\r\n// constants CLASS_TYPE_*.\r\n// * Return value on error: -1\r\nint GetFactionMostFrequentClass(object oFactionMember);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFactionWorstAC',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', 0), ScriptParam(DataType.INT, 'bMustBeVisible', 1), ],
        "// 192: Get the object faction member with the lowest armour class.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionWorstAC(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);",
        "// 192: Get the object faction member with the lowest armour class.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionWorstAC(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFactionBestAC',
        [ScriptParam(DataType.OBJECT, 'oFactionMember', 0), ScriptParam(DataType.INT, 'bMustBeVisible', 1), ],
        "// 193: Get the object faction member with the highest armour class.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionBestAC(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);",
        "// 193: Get the object faction member with the highest armour class.\r\n// * Returns OBJECT_INVALID if oFactionMember's faction is invalid.\r\nobject GetFactionBestAC(object oFactionMember = OBJECT_SELF, int bMustBeVisible = TRUE);"
    ),
    ScriptFunction(
        DataType.STRING,
        'GetGlobalString',
        [ScriptParam(DataType.STRING, 'sIdentifier', None), ],
        "// 194: Get a global string with the specified identifier\r\n//      This is an EXTREMELY restricted function.  Use only with explicit permission.\r\n//      This means if you are not Preston.  Then go see him if you're even thinking\r\n//      about using this.\r\nstring GetGlobalString( string sIdentifier );",
        "// 194: Get a global string with the specified identifier\r\n//      This is an EXTREMELY restricted function.  Use only with explicit permission.\r\n//      This means if you are not Preston.  Then go see him if you're even thinking\r\n//      about using this.\r\nstring GetGlobalString( string sIdentifier );"
    ),
    ScriptFunction(
        DataType.INT,
        'GetListenPatternNumber',
        [],
        '// 195: In an onConversation script this gets the number of the string pattern\r\n// matched (the one that triggered the script).\r\n// * Returns -1 if no string matched\r\nint GetListenPatternNumber();',
        '// 195: In an onConversation script this gets the number of the string pattern\r\n// matched (the one that triggered the script).\r\n// * Returns -1 if no string matched\r\nint GetListenPatternNumber();'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionJumpToObject',
        [ScriptParam(DataType.OBJECT, 'oToJumpTo', None), ScriptParam(DataType.INT, 'bWalkStraightLineToPoint', 1), ],
        '// 196: Jump to an object ID, or as near to it as possible.\r\nvoid ActionJumpToObject(object oToJumpTo, int bWalkStraightLineToPoint = TRUE);',
        '// 196: Jump to an object ID, or as near to it as possible.\r\nvoid ActionJumpToObject(object oToJumpTo, int bWalkStraightLineToPoint = TRUE);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetWaypointByTag',
        [ScriptParam(DataType.STRING, 'sWaypointTag', None), ],
        '// 197: Get the first waypoint with the specified tag.\r\n// * Returns OBJECT_INVALID if the waypoint cannot be found.\r\nobject GetWaypointByTag(string sWaypointTag);',
        '// 197: Get the first waypoint with the specified tag.\r\n// * Returns OBJECT_INVALID if the waypoint cannot be found.\r\nobject GetWaypointByTag(string sWaypointTag);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetTransitionTarget',
        [ScriptParam(DataType.OBJECT, 'oTransition', None), ],
        '// 198: Get the destination (a waypoint or a door) for a trigger or a door.\r\n// * Returns OBJECT_INVALID if oTransition is not a valid trigger or door.\r\nobject GetTransitionTarget(object oTransition);',
        '// 198: Get the destination (a waypoint or a door) for a trigger or a door.\r\n// * Returns OBJECT_INVALID if oTransition is not a valid trigger or door.\r\nobject GetTransitionTarget(object oTransition);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectLinkEffects',
        [ScriptParam(DataType.EFFECT, 'eChildEffect', None), ScriptParam(DataType.EFFECT, 'eParentEffect', None), ],
        '// 199: Link the two supplied effects, returning eChildEffect as a child of\r\n// eParentEffect.\r\n// Note: When applying linked effects if the target is immune to all valid\r\n// effects all other effects will be removed as well. This means that if you\r\n// apply a visual effect and a silence effect (in a link) and the target is\r\n// immune to the silence effect that the visual effect will get removed as well.\r\n// Visual Effects are not considered "valid" effects for the purposes of\r\n// determining if an effect will be removed or not and as such should never be\r\n// packaged *only* with other visual effects in a link.\r\neffect EffectLinkEffects(effect eChildEffect, effect eParentEffect );',
        '// 199: Link the two supplied effects, returning eChildEffect as a child of\r\n// eParentEffect.\r\n// Note: When applying linked effects if the target is immune to all valid\r\n// effects all other effects will be removed as well. This means that if you\r\n// apply a visual effect and a silence effect (in a link) and the target is\r\n// immune to the silence effect that the visual effect will get removed as well.\r\n// Visual Effects are not considered "valid" effects for the purposes of\r\n// determining if an effect will be removed or not and as such should never be\r\n// packaged *only* with other visual effects in a link.\r\neffect EffectLinkEffects(effect eChildEffect, effect eParentEffect );'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetObjectByTag',
        [ScriptParam(DataType.STRING, 'sTag', None), ScriptParam(DataType.INT, 'nNth', 0), ],
        '// 200: Get the nNth object with the specified tag.\r\n// - sTag\r\n// - nNth: the nth object with this tag may be requested\r\n// * Returns OBJECT_INVALID if the object cannot be found.\r\nobject GetObjectByTag(string sTag, int nNth = 0);',
        '// 200: Get the nNth object with the specified tag.\r\n// - sTag\r\n// - nNth: the nth object with this tag may be requested\r\n// * Returns OBJECT_INVALID if the object cannot be found.\r\nobject GetObjectByTag(string sTag, int nNth = 0);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AdjustAlignment',
        [ScriptParam(DataType.OBJECT, 'oSubject', None), ScriptParam(DataType.INT, 'nAlignment', None), ScriptParam(DataType.INT, 'nShift', None), ScriptParam(DataType.INT, 'bDontModifyNPCs', 0), ],
        "// 201: Adjust the alignment of oSubject.\r\n// - oSubject\r\n// - nAlignment:\r\n//   -> ALIGNMENT_LIGHT_SIDE/ALIGNMENT_DARK_SIDE: oSubject's\r\n//      alignment will be shifted in the direction specified\r\n//   -> ALIGNMENT_NEUTRAL: nShift is applied to oSubject's dark side/light side\r\n//      alignment value in the direction which is towards neutrality.\r\n//     e.g. If oSubject has an alignment value of 80 (i.e. light side)\r\n//          then if nShift is 15, the alignment value will become (80-15) = 65\r\n//     Furthermore, the shift will at most take the alignment value to 50 and\r\n//     not beyond.\r\n//     e.g. If oSubject has an alignment value of 40 then if nShift is 15,\r\n//          the aligment value will become 50\r\n// - nShift: this is the desired shift in alignment\r\n// * No return value\r\n// - bDontModifyNPCs - Defaults to 'FALSE', if you pass in 'TRUE' then you can adjust\r\n//   the playercharacter's alignment without impacting the rest of the NPCs\r\nvoid AdjustAlignment(object oSubject, int nAlignment, int nShift, int bDontModifyNPCs  =  FALSE);",
        "// 201: Adjust the alignment of oSubject.\r\n// - oSubject\r\n// - nAlignment:\r\n//   -> ALIGNMENT_LIGHT_SIDE/ALIGNMENT_DARK_SIDE: oSubject's\r\n//      alignment will be shifted in the direction specified\r\n//   -> ALIGNMENT_NEUTRAL: nShift is applied to oSubject's dark side/light side\r\n//      alignment value in the direction which is towards neutrality.\r\n//     e.g. If oSubject has an alignment value of 80 (i.e. light side)\r\n//          then if nShift is 15, the alignment value will become (80-15) = 65\r\n//     Furthermore, the shift will at most take the alignment value to 50 and\r\n//     not beyond.\r\n//     e.g. If oSubject has an alignment value of 40 then if nShift is 15,\r\n//          the aligment value will become 50\r\n// - nShift: this is the desired shift in alignment\r\n// * No return value\r\n// - bDontModifyNPCs - Defaults to 'FALSE', if you pass in 'TRUE' then you can adjust\r\n//   the playercharacter's alignment without impacting the rest of the NPCs\r\nvoid AdjustAlignment(object oSubject, int nAlignment, int nShift, int bDontModifyNPCs  =  FALSE);"
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionWait',
        [ScriptParam(DataType.FLOAT, 'fSeconds', None), ],
        '// 202: Do nothing for fSeconds seconds.\r\nvoid ActionWait(float fSeconds);',
        '// 202: Do nothing for fSeconds seconds.\r\nvoid ActionWait(float fSeconds);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetAreaTransitionBMP',
        [ScriptParam(DataType.INT, 'nPredefinedAreaTransition', None), ScriptParam(DataType.STRING, 'sCustomAreaTransitionBMP', ''), ],
        '// 203: Set the transition bitmap of a player; this should only be called in area\r\n// transition scripts. This action should be run by the person "clicking" the\r\n// area transition via AssignCommand.\r\n// - nPredefinedAreaTransition:\r\n//   -> To use a predefined area transition bitmap, use one of AREA_TRANSITION_*\r\n//   -> To use a custom, user-defined area transition bitmap, use\r\n//      AREA_TRANSITION_USER_DEFINED and specify the filename in the second\r\n//      parameter\r\n// - sCustomAreaTransitionBMP: this is the filename of a custom, user-defined\r\n//   area transition bitmap\r\nvoid SetAreaTransitionBMP(int nPredefinedAreaTransition, string sCustomAreaTransitionBMP = "");',
        '// 203: Set the transition bitmap of a player; this should only be called in area\r\n// transition scripts. This action should be run by the person "clicking" the\r\n// area transition via AssignCommand.\r\n// - nPredefinedAreaTransition:\r\n//   -> To use a predefined area transition bitmap, use one of AREA_TRANSITION_*\r\n//   -> To use a custom, user-defined area transition bitmap, use\r\n//      AREA_TRANSITION_USER_DEFINED and specify the filename in the second\r\n//      parameter\r\n// - sCustomAreaTransitionBMP: this is the filename of a custom, user-defined\r\n//   area transition bitmap\r\nvoid SetAreaTransitionBMP(int nPredefinedAreaTransition, string sCustomAreaTransitionBMP = "");'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionStartConversation',
        [ScriptParam(DataType.OBJECT, 'oObjectToConverse', None), ScriptParam(DataType.STRING, 'sDialogResRef', ''), ScriptParam(DataType.INT, 'bPrivateConversation', 0), ScriptParam(DataType.INT, 'nConversationType', 0), ScriptParam(DataType.INT, 'bIgnoreStartRange', 0), ScriptParam(DataType.STRING, 'sNameObjectToIgnore1', ''), ScriptParam(DataType.STRING, 'sNameObjectToIgnore2', ''), ScriptParam(DataType.STRING, 'sNameObjectToIgnore3', ''), ScriptParam(DataType.STRING, 'sNameObjectToIgnore4', ''), ScriptParam(DataType.STRING, 'sNameObjectToIgnore5', ''), ScriptParam(DataType.STRING, 'sNameObjectToIgnore6', ''), ScriptParam(DataType.INT, 'bUseLeader', 0), ScriptParam(DataType.INT, 'nBarkX', -1), ScriptParam(DataType.INT, 'nBarkY', -1), ScriptParam(DataType.INT, 'bDontClearAllActions', 0), ],
        '// 204: Starts a conversation with oObjectToConverseWith - this will cause their\r\n// OnDialog event to fire.\r\n// - oObjectToConverseWith\r\n// - sDialogResRef: If this is blank, the creature\'s own dialogue file will be used\r\n// - bPrivateConversation: If this is blank, the default is FALSE.\r\n// - nConversationType - If this is blank the default will be Cinematic, ie. a normal conversation type\r\n//                                  other choices inclue: CONVERSATION_TYPE_COMPUTER\r\n//   UPDATE:  nConversationType actually has no meaning anymore.  This has been replaced by a flag in the dialog editor.  However\r\n//                for backwards compatability it has been left here.  So when using this command place CONVERSATION_TYPE_CINEMATIC in here. - DJF\r\n// - bIgnoreStartRange - If this is blank the default will be FALSE, ie. Start conversation ranges are in effect\r\n//                                                                      Setting this to TRUE will cause creatures to start a conversation without requiring to close\r\n//                                                                      the distance between the two object in dialog.\r\n// - sNameObjectToIgnore1-6 - Normally objects in the animation list of the dialog editor have to be available for animations on that node to work\r\n//                                        these 6 strings are to indicate 6 objects that don\x92t need to be available for things to proceed.  The string should be EXACTLY\r\n//                                        the same as the string that it represents in the dialog editor.\r\n// - nBarkX and nBarkY - These override the left, top corner position for the bark string if the conversation starting is a bark string.\r\n//                       They only happen on a conversation by conversation basis and don\'t stay in effect in subsequent conversations.\r\nvoid ActionStartConversation(object oObjectToConverse, string sDialogResRef  =  "", int bPrivateConversation  =  FALSE, int nConversationType  =  CONVERSATION_TYPE_CINEMATIC, int bIgnoreStartRange  =  FALSE, string sNameObjectToIgnore1  =  "", string sNameObjectToIgnore2  =  "", string sNameObjectToIgnore3  =  "", string sNameObjectToIgnore4  =  "", string sNameObjectToIgnore5  =  "", string sNameObjectToIgnore6  =  "", int bUseLeader  =  FALSE, int nBarkX  =  -1, int nBarkY  =  -1, int bDontClearAllActions  =  0);',
        '// 204: Starts a conversation with oObjectToConverseWith - this will cause their\r\n// OnDialog event to fire.\r\n// - oObjectToConverseWith\r\n// - sDialogResRef: If this is blank, the creature\'s own dialogue file will be used\r\n// - bPrivateConversation: If this is blank, the default is FALSE.\r\n// - nConversationType - If this is blank the default will be Cinematic, ie. a normal conversation type\r\n//                                  other choices inclue: CONVERSATION_TYPE_COMPUTER\r\n//   UPDATE:  nConversationType actually has no meaning anymore.  This has been replaced by a flag in the dialog editor.  However\r\n//                for backwards compatability it has been left here.  So when using this command place CONVERSATION_TYPE_CINEMATIC in here. - DJF\r\n// - bIgnoreStartRange - If this is blank the default will be FALSE, ie. Start conversation ranges are in effect\r\n//                                                                      Setting this to TRUE will cause creatures to start a conversation without requiring to close\r\n//                                                                      the distance between the two object in dialog.\r\n// - sNameObjectToIgnore1-6 - Normally objects in the animation list of the dialog editor have to be available for animations on that node to work\r\n//                                        these 6 strings are to indicate 6 objects that don\x92t need to be available for things to proceed.  The string should be EXACTLY\r\n//                                        the same as the string that it represents in the dialog editor.\r\n// - nBarkX and nBarkY - These override the left, top corner position for the bark string if the conversation starting is a bark string.\r\n//                       They only happen on a conversation by conversation basis and don\'t stay in effect in subsequent conversations.\r\nvoid ActionStartConversation(object oObjectToConverse, string sDialogResRef  =  "", int bPrivateConversation  =  FALSE, int nConversationType  =  CONVERSATION_TYPE_CINEMATIC, int bIgnoreStartRange  =  FALSE, string sNameObjectToIgnore1  =  "", string sNameObjectToIgnore2  =  "", string sNameObjectToIgnore3  =  "", string sNameObjectToIgnore4  =  "", string sNameObjectToIgnore5  =  "", string sNameObjectToIgnore6  =  "", int bUseLeader  =  FALSE, int nBarkX  =  -1, int nBarkY  =  -1, int bDontClearAllActions  =  0);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionPauseConversation',
        [],
        '// 205: Pause the current conversation.\r\nvoid ActionPauseConversation();',
        '// 205: Pause the current conversation.\r\nvoid ActionPauseConversation();'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionResumeConversation',
        [],
        '// 206: Resume a conversation after it has been paused.\r\nvoid ActionResumeConversation();',
        '// 206: Resume a conversation after it has been paused.\r\nvoid ActionResumeConversation();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectBeam',
        [ScriptParam(DataType.INT, 'nBeamVisualEffect', None), ScriptParam(DataType.OBJECT, 'oEffector', None), ScriptParam(DataType.INT, 'nBodyPart', None), ScriptParam(DataType.INT, 'bMissEffect', 0), ],
        '// 207: Create a Beam effect.\r\n// - nBeamVisualEffect: VFX_BEAM_*\r\n// - oEffector: the beam is emitted from this creature\r\n// - nBodyPart: BODY_NODE_*\r\n// - bMissEffect: If this is TRUE, the beam will fire to a random vector near or\r\n//   past the target\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nBeamVisualEffect is\r\n//   not valid.\r\neffect EffectBeam(int nBeamVisualEffect, object oEffector, int nBodyPart, int bMissEffect = FALSE);',
        '// 207: Create a Beam effect.\r\n// - nBeamVisualEffect: VFX_BEAM_*\r\n// - oEffector: the beam is emitted from this creature\r\n// - nBodyPart: BODY_NODE_*\r\n// - bMissEffect: If this is TRUE, the beam will fire to a random vector near or\r\n//   past the target\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nBeamVisualEffect is\r\n//   not valid.\r\neffect EffectBeam(int nBeamVisualEffect, object oEffector, int nBodyPart, int bMissEffect = FALSE);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetReputation',
        [ScriptParam(DataType.OBJECT, 'oSource', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 208: Get an integer between 0 and 100 (inclusive) that represents how oSource\r\n// feels about oTarget.\r\n// -> 0-10 means oSource is hostile to oTarget\r\n// -> 11-89 means oSource is neutral to oTarget\r\n// -> 90-100 means oSource is friendly to oTarget\r\n// * Returns -1 if oSource or oTarget does not identify a valid object\r\nint GetReputation(object oSource, object oTarget);',
        '// 208: Get an integer between 0 and 100 (inclusive) that represents how oSource\r\n// feels about oTarget.\r\n// -> 0-10 means oSource is hostile to oTarget\r\n// -> 11-89 means oSource is neutral to oTarget\r\n// -> 90-100 means oSource is friendly to oTarget\r\n// * Returns -1 if oSource or oTarget does not identify a valid object\r\nint GetReputation(object oSource, object oTarget);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AdjustReputation',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.OBJECT, 'oSourceFactionMember', None), ScriptParam(DataType.INT, 'nAdjustment', None), ],
        "// 209: Adjust how oSourceFactionMember's faction feels about oTarget by the\r\n// specified amount.\r\n// Note: This adjusts Faction Reputation, how the entire faction that\r\n// oSourceFactionMember is in, feels about oTarget.\r\n// * No return value\r\nvoid AdjustReputation(object oTarget, object oSourceFactionMember, int nAdjustment);",
        "// 209: Adjust how oSourceFactionMember's faction feels about oTarget by the\r\n// specified amount.\r\n// Note: This adjusts Faction Reputation, how the entire faction that\r\n// oSourceFactionMember is in, feels about oTarget.\r\n// * No return value\r\nvoid AdjustReputation(object oTarget, object oSourceFactionMember, int nAdjustment);"
    ),
    ScriptFunction(
        DataType.STRING,
        'GetModuleFileName',
        [],
        '// 210: Gets the actual file name of the current module\r\nstring GetModuleFileName();',
        '// 210: Gets the actual file name of the current module\r\nstring GetModuleFileName();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetGoingToBeAttackedBy',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 211: Get the creature that is going to attack oTarget.\r\n// Note: This value is cleared out at the end of every combat round and should\r\n// not be used in any case except when getting a "going to be attacked" shout\r\n// from the master creature (and this creature is a henchman)\r\n// * Returns OBJECT_INVALID if oTarget is not a valid creature.\r\nobject GetGoingToBeAttackedBy(object oTarget);',
        '// 211: Get the creature that is going to attack oTarget.\r\n// Note: This value is cleared out at the end of every combat round and should\r\n// not be used in any case except when getting a "going to be attacked" shout\r\n// from the master creature (and this creature is a henchman)\r\n// * Returns OBJECT_INVALID if oTarget is not a valid creature.\r\nobject GetGoingToBeAttackedBy(object oTarget);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectForceResistanceIncrease',
        [ScriptParam(DataType.INT, 'nValue', None), ],
        '// 212: Create a Force Resistance Increase effect.\r\n// - nValue: size of Force Resistance increase\r\neffect EffectForceResistanceIncrease(int nValue);',
        '// 212: Create a Force Resistance Increase effect.\r\n// - nValue: size of Force Resistance increase\r\neffect EffectForceResistanceIncrease(int nValue);'
    ),
    ScriptFunction(
        DataType.LOCATION,
        'GetLocation',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 213: Get the location of oObject.\r\nlocation GetLocation(object oObject);',
        '// 213: Get the location of oObject.\r\nlocation GetLocation(object oObject);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionJumpToLocation',
        [ScriptParam(DataType.LOCATION, 'lLocation', None), ],
        '// 214: The subject will jump to lLocation instantly (even between areas).\r\n// If lLocation is invalid, nothing will happen.\r\nvoid ActionJumpToLocation(location lLocation);',
        '// 214: The subject will jump to lLocation instantly (even between areas).\r\n// If lLocation is invalid, nothing will happen.\r\nvoid ActionJumpToLocation(location lLocation);'
    ),
    ScriptFunction(
        DataType.LOCATION,
        'Location',
        [ScriptParam(DataType.VECTOR, 'vPosition', None), ScriptParam(DataType.FLOAT, 'fOrientation', None), ],
        '// 215: Create a location.\r\nlocation Location(vector vPosition, float fOrientation);',
        '// 215: Create a location.\r\nlocation Location(vector vPosition, float fOrientation);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ApplyEffectAtLocation',
        [ScriptParam(DataType.INT, 'nDurationType', None), ScriptParam(DataType.EFFECT, 'eEffect', None), ScriptParam(DataType.LOCATION, 'lLocation', None), ScriptParam(DataType.FLOAT, 'fDuration', 0.0), ],
        '// 216: Apply eEffect at lLocation.\r\nvoid ApplyEffectAtLocation(int nDurationType, effect eEffect, location lLocation, float fDuration = 0.0f);',
        '// 216: Apply eEffect at lLocation.\r\nvoid ApplyEffectAtLocation(int nDurationType, effect eEffect, location lLocation, float fDuration = 0.0f);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsPC',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 217: * Returns TRUE if oCreature is a Player Controlled character.\r\nint GetIsPC(object oCreature);',
        '// 217: * Returns TRUE if oCreature is a Player Controlled character.\r\nint GetIsPC(object oCreature);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'FeetToMeters',
        [ScriptParam(DataType.FLOAT, 'fFeet', None), ],
        '// 218: Convert fFeet into a number of meters.\r\nfloat FeetToMeters(float fFeet);',
        '// 218: Convert fFeet into a number of meters.\r\nfloat FeetToMeters(float fFeet);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'YardsToMeters',
        [ScriptParam(DataType.FLOAT, 'fYards', None), ],
        '// 219: Convert fYards into a number of meters.\r\nfloat YardsToMeters(float fYards);',
        '// 219: Convert fYards into a number of meters.\r\nfloat YardsToMeters(float fYards);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ApplyEffectToObject',
        [ScriptParam(DataType.INT, 'nDurationType', None), ScriptParam(DataType.EFFECT, 'eEffect', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.FLOAT, 'fDuration', 0.0), ],
        '// 220: Apply eEffect to oTarget.\r\nvoid ApplyEffectToObject(int nDurationType, effect eEffect, object oTarget, float fDuration = 0.0f);',
        '// 220: Apply eEffect to oTarget.\r\nvoid ApplyEffectToObject(int nDurationType, effect eEffect, object oTarget, float fDuration = 0.0f);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SpeakString',
        [ScriptParam(DataType.STRING, 'sStringToSpeak', None), ScriptParam(DataType.INT, 'nTalkVolume', 0), ],
        '// 221: The caller will immediately speak sStringToSpeak (this is different from\r\n// ActionSpeakString)\r\n// - sStringToSpeak\r\n// - nTalkVolume: TALKVOLUME_*\r\nvoid SpeakString(string sStringToSpeak, int nTalkVolume = TALKVOLUME_TALK);',
        '// 221: The caller will immediately speak sStringToSpeak (this is different from\r\n// ActionSpeakString)\r\n// - sStringToSpeak\r\n// - nTalkVolume: TALKVOLUME_*\r\nvoid SpeakString(string sStringToSpeak, int nTalkVolume = TALKVOLUME_TALK);'
    ),
    ScriptFunction(
        DataType.LOCATION,
        'GetSpellTargetLocation',
        [],
        "// 222: Get the location of the caller's last spell target.\r\nlocation GetSpellTargetLocation();",
        "// 222: Get the location of the caller's last spell target.\r\nlocation GetSpellTargetLocation();"
    ),
    ScriptFunction(
        DataType.VECTOR,
        'GetPositionFromLocation',
        [ScriptParam(DataType.LOCATION, 'lLocation', None), ],
        '// 223: Get the position vector from lLocation.\r\nvector GetPositionFromLocation(location lLocation);',
        '// 223: Get the position vector from lLocation.\r\nvector GetPositionFromLocation(location lLocation);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectBodyFuel',
        [],
        '// 224: the effect of body fule.. convers HP -> FP i think\r\neffect EffectBodyFuel( );',
        '// 224: the effect of body fule.. convers HP -> FP i think\r\neffect EffectBodyFuel( );'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetFacingFromLocation',
        [ScriptParam(DataType.LOCATION, 'lLocation', None), ],
        '// 225: Get the orientation value from lLocation.\r\nfloat GetFacingFromLocation(location lLocation);',
        '// 225: Get the orientation value from lLocation.\r\nfloat GetFacingFromLocation(location lLocation);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNearestCreatureToLocation',
        [ScriptParam(DataType.INT, 'nFirstCriteriaType', None), ScriptParam(DataType.INT, 'nFirstCriteriaValue', None), ScriptParam(DataType.LOCATION, 'lLocation', None), ScriptParam(DataType.INT, 'nNth', 1), ScriptParam(DataType.INT, 'nSecondCriteriaType', -1), ScriptParam(DataType.INT, 'nSecondCriteriaValue', -1), ScriptParam(DataType.INT, 'nThirdCriteriaType', -1), ScriptParam(DataType.INT, 'nThirdCriteriaValue', -1), ],
        "// 226: Get the creature nearest to lLocation, subject to all the criteria specified.\r\n// - nFirstCriteriaType: CREATURE_TYPE_*\r\n// - nFirstCriteriaValue:\r\n//   -> CLASS_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_CLASS\r\n//   -> SPELL_* if nFirstCriteriaType was CREATURE_TYPE_DOES_NOT_HAVE_SPELL_EFFECT\r\n//      or CREATURE_TYPE_HAS_SPELL_EFFECT\r\n//   -> TRUE or FALSE if nFirstCriteriaType was CREATURE_TYPE_IS_ALIVE\r\n//   -> PERCEPTION_* if nFirstCriteriaType was CREATURE_TYPE_PERCEPTION\r\n//   -> PLAYER_CHAR_IS_PC or PLAYER_CHAR_NOT_PC if nFirstCriteriaType was\r\n//      CREATURE_TYPE_PLAYER_CHAR\r\n//   -> RACIAL_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_RACIAL_TYPE\r\n//   -> REPUTATION_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_REPUTATION\r\n//   For example, to get the nearest PC, use\r\n//   (CREATURE_TYPE_PLAYER_CHAR, PLAYER_CHAR_IS_PC)\r\n// - lLocation: We're trying to find the creature of the specified type that is\r\n//   nearest to lLocation\r\n// - nNth: We don't have to find the first nearest: we can find the Nth nearest....\r\n// - nSecondCriteriaType: This is used in the same way as nFirstCriteriaType to\r\n//   further specify the type of creature that we are looking for.\r\n// - nSecondCriteriaValue: This is used in the same way as nFirstCriteriaValue\r\n//   to further specify the type of creature that we are looking for.\r\n// - nThirdCriteriaType: This is used in the same way as nFirstCriteriaType to\r\n//   further specify the type of creature that we are looking for.\r\n// - nThirdCriteriaValue: This is used in the same way as nFirstCriteriaValue to\r\n//   further specify the type of creature that we are looking for.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestCreatureToLocation(int nFirstCriteriaType, int nFirstCriteriaValue,  location lLocation, int nNth = 1, int nSecondCriteriaType = -1, int nSecondCriteriaValue = -1, int nThirdCriteriaType = -1,  int nThirdCriteriaValue = -1 );",
        "// 226: Get the creature nearest to lLocation, subject to all the criteria specified.\r\n// - nFirstCriteriaType: CREATURE_TYPE_*\r\n// - nFirstCriteriaValue:\r\n//   -> CLASS_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_CLASS\r\n//   -> SPELL_* if nFirstCriteriaType was CREATURE_TYPE_DOES_NOT_HAVE_SPELL_EFFECT\r\n//      or CREATURE_TYPE_HAS_SPELL_EFFECT\r\n//   -> TRUE or FALSE if nFirstCriteriaType was CREATURE_TYPE_IS_ALIVE\r\n//   -> PERCEPTION_* if nFirstCriteriaType was CREATURE_TYPE_PERCEPTION\r\n//   -> PLAYER_CHAR_IS_PC or PLAYER_CHAR_NOT_PC if nFirstCriteriaType was\r\n//      CREATURE_TYPE_PLAYER_CHAR\r\n//   -> RACIAL_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_RACIAL_TYPE\r\n//   -> REPUTATION_TYPE_* if nFirstCriteriaType was CREATURE_TYPE_REPUTATION\r\n//   For example, to get the nearest PC, use\r\n//   (CREATURE_TYPE_PLAYER_CHAR, PLAYER_CHAR_IS_PC)\r\n// - lLocation: We're trying to find the creature of the specified type that is\r\n//   nearest to lLocation\r\n// - nNth: We don't have to find the first nearest: we can find the Nth nearest....\r\n// - nSecondCriteriaType: This is used in the same way as nFirstCriteriaType to\r\n//   further specify the type of creature that we are looking for.\r\n// - nSecondCriteriaValue: This is used in the same way as nFirstCriteriaValue\r\n//   to further specify the type of creature that we are looking for.\r\n// - nThirdCriteriaType: This is used in the same way as nFirstCriteriaType to\r\n//   further specify the type of creature that we are looking for.\r\n// - nThirdCriteriaValue: This is used in the same way as nFirstCriteriaValue to\r\n//   further specify the type of creature that we are looking for.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestCreatureToLocation(int nFirstCriteriaType, int nFirstCriteriaValue,  location lLocation, int nNth = 1, int nSecondCriteriaType = -1, int nSecondCriteriaValue = -1, int nThirdCriteriaType = -1,  int nThirdCriteriaValue = -1 );"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNearestObject',
        [ScriptParam(DataType.INT, 'nObjectType', 32767), ScriptParam(DataType.OBJECT, 'oTarget', 0), ScriptParam(DataType.INT, 'nNth', 1), ],
        '// 227: Get the Nth object nearest to oTarget that is of the specified type.\r\n// - nObjectType: OBJECT_TYPE_*\r\n// - oTarget\r\n// - nNth\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestObject(int nObjectType = OBJECT_TYPE_ALL, object oTarget = OBJECT_SELF, int nNth = 1);',
        '// 227: Get the Nth object nearest to oTarget that is of the specified type.\r\n// - nObjectType: OBJECT_TYPE_*\r\n// - oTarget\r\n// - nNth\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestObject(int nObjectType = OBJECT_TYPE_ALL, object oTarget = OBJECT_SELF, int nNth = 1);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNearestObjectToLocation',
        [ScriptParam(DataType.INT, 'nObjectType', None), ScriptParam(DataType.LOCATION, 'lLocation', None), ScriptParam(DataType.INT, 'nNth', 1), ],
        '// 228: Get the nNth object nearest to lLocation that is of the specified type.\r\n// - nObjectType: OBJECT_TYPE_*\r\n// - lLocation\r\n// - nNth\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestObjectToLocation(int nObjectType, location lLocation, int nNth = 1);',
        '// 228: Get the nNth object nearest to lLocation that is of the specified type.\r\n// - nObjectType: OBJECT_TYPE_*\r\n// - lLocation\r\n// - nNth\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestObjectToLocation(int nObjectType, location lLocation, int nNth = 1);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNearestObjectByTag',
        [ScriptParam(DataType.STRING, 'sTag', None), ScriptParam(DataType.OBJECT, 'oTarget', 0), ScriptParam(DataType.INT, 'nNth', 1), ],
        '// 229: Get the nth Object nearest to oTarget that has sTag as its tag.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestObjectByTag(string sTag, object oTarget = OBJECT_SELF, int nNth = 1);',
        '// 229: Get the nth Object nearest to oTarget that has sTag as its tag.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetNearestObjectByTag(string sTag, object oTarget = OBJECT_SELF, int nNth = 1);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'IntToFloat',
        [ScriptParam(DataType.INT, 'nInteger', None), ],
        '// 230: Convert nInteger into a floating point number.\r\nfloat IntToFloat(int nInteger);',
        '// 230: Convert nInteger into a floating point number.\r\nfloat IntToFloat(int nInteger);'
    ),
    ScriptFunction(
        DataType.INT,
        'FloatToInt',
        [ScriptParam(DataType.FLOAT, 'fFloat', None), ],
        '// 231: Convert fFloat into the nearest integer.\r\nint FloatToInt(float fFloat);',
        '// 231: Convert fFloat into the nearest integer.\r\nint FloatToInt(float fFloat);'
    ),
    ScriptFunction(
        DataType.INT,
        'StringToInt',
        [ScriptParam(DataType.STRING, 'sNumber', None), ],
        '// 232: Convert sNumber into an integer.\r\nint StringToInt(string sNumber);',
        '// 232: Convert sNumber into an integer.\r\nint StringToInt(string sNumber);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'StringToFloat',
        [ScriptParam(DataType.STRING, 'sNumber', None), ],
        '// 233: Convert sNumber into a floating point number.\r\nfloat StringToFloat(string sNumber);',
        '// 233: Convert sNumber into a floating point number.\r\nfloat StringToFloat(string sNumber);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionCastSpellAtLocation',
        [ScriptParam(DataType.INT, 'nSpell', None), ScriptParam(DataType.LOCATION, 'lTargetLocation', None), ScriptParam(DataType.INT, 'nMetaMagic', 0), ScriptParam(DataType.INT, 'bCheat', 0), ScriptParam(DataType.INT, 'nProjectilePathType', 0), ScriptParam(DataType.INT, 'bInstantSpell', 0), ],
        "// 234: Cast spell nSpell at lTargetLocation.\r\n// - nSpell: SPELL_*\r\n// - lTargetLocation\r\n// - nMetaMagic: METAMAGIC_*\r\n// - bCheat: If this is TRUE, then the executor of the action doesn't have to be\r\n//   able to cast the spell.\r\n// - nProjectilePathType: PROJECTILE_PATH_TYPE_*\r\n// - bInstantSpell: If this is TRUE, the spell is cast immediately; this allows\r\n//   the end-user to simulate\r\n//   a high-level magic user having lots of advance warning of impending trouble.\r\nvoid   ActionCastSpellAtLocation(int nSpell, location lTargetLocation, int nMetaMagic = 0, int bCheat = FALSE, int nProjectilePathType = PROJECTILE_PATH_TYPE_DEFAULT, int bInstantSpell = FALSE);",
        "// 234: Cast spell nSpell at lTargetLocation.\r\n// - nSpell: SPELL_*\r\n// - lTargetLocation\r\n// - nMetaMagic: METAMAGIC_*\r\n// - bCheat: If this is TRUE, then the executor of the action doesn't have to be\r\n//   able to cast the spell.\r\n// - nProjectilePathType: PROJECTILE_PATH_TYPE_*\r\n// - bInstantSpell: If this is TRUE, the spell is cast immediately; this allows\r\n//   the end-user to simulate\r\n//   a high-level magic user having lots of advance warning of impending trouble.\r\nvoid   ActionCastSpellAtLocation(int nSpell, location lTargetLocation, int nMetaMagic = 0, int bCheat = FALSE, int nProjectilePathType = PROJECTILE_PATH_TYPE_DEFAULT, int bInstantSpell = FALSE);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsEnemy',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.OBJECT, 'oSource', 0), ],
        '// 235: * Returns TRUE if oSource considers oTarget as an enemy.\r\nint GetIsEnemy(object oTarget, object oSource = OBJECT_SELF);',
        '// 235: * Returns TRUE if oSource considers oTarget as an enemy.\r\nint GetIsEnemy(object oTarget, object oSource = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsFriend',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.OBJECT, 'oSource', 0), ],
        '// 236: * Returns TRUE if oSource considers oTarget as a friend.\r\nint GetIsFriend(object oTarget, object oSource = OBJECT_SELF);',
        '// 236: * Returns TRUE if oSource considers oTarget as a friend.\r\nint GetIsFriend(object oTarget, object oSource = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsNeutral',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.OBJECT, 'oSource', 0), ],
        '// 237: * Returns TRUE if oSource considers oTarget as neutral.\r\nint GetIsNeutral(object oTarget, object oSource = OBJECT_SELF);',
        '// 237: * Returns TRUE if oSource considers oTarget as neutral.\r\nint GetIsNeutral(object oTarget, object oSource = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetPCSpeaker',
        [],
        '// 238: Get the PC that is involved in the conversation.\r\n// * Returns OBJECT_INVALID on error.\r\nobject GetPCSpeaker();',
        '// 238: Get the PC that is involved in the conversation.\r\n// * Returns OBJECT_INVALID on error.\r\nobject GetPCSpeaker();'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetStringByStrRef',
        [ScriptParam(DataType.INT, 'nStrRef', None), ],
        '// 239: Get a string from the talk table using nStrRef.\r\nstring GetStringByStrRef(int nStrRef);',
        '// 239: Get a string from the talk table using nStrRef.\r\nstring GetStringByStrRef(int nStrRef);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionSpeakStringByStrRef',
        [ScriptParam(DataType.INT, 'nStrRef', None), ScriptParam(DataType.INT, 'nTalkVolume', 0), ],
        '// 240: Causes the creature to speak a translated string.\r\n// - nStrRef: Reference of the string in the talk table\r\n// - nTalkVolume: TALKVOLUME_*\r\nvoid ActionSpeakStringByStrRef(int nStrRef, int nTalkVolume = TALKVOLUME_TALK);',
        '// 240: Causes the creature to speak a translated string.\r\n// - nStrRef: Reference of the string in the talk table\r\n// - nTalkVolume: TALKVOLUME_*\r\nvoid ActionSpeakStringByStrRef(int nStrRef, int nTalkVolume = TALKVOLUME_TALK);'
    ),
    ScriptFunction(
        DataType.VOID,
        'DestroyObject',
        [ScriptParam(DataType.OBJECT, 'oDestroy', None), ScriptParam(DataType.FLOAT, 'fDelay', 0.0), ScriptParam(DataType.INT, 'bNoFade', 0), ScriptParam(DataType.FLOAT, 'fDelayUntilFade', 0.0), ScriptParam(DataType.INT, 'nHideFeedback', 0), ],
        '// 241: Destroy oObject (irrevocably).\r\n// This will not work on modules and areas.\r\n// The bNoFade and fDelayUntilFade are for creatures and placeables only\r\nvoid DestroyObject(object oDestroy, float fDelay = 0.0f, int bNoFade  =  FALSE, float fDelayUntilFade  =  0.0f, int nHideFeedback  =  0);',
        '// 241: Destroy oObject (irrevocably).\r\n// This will not work on modules and areas.\r\n// The bNoFade and fDelayUntilFade are for creatures and placeables only\r\nvoid DestroyObject(object oDestroy, float fDelay = 0.0f, int bNoFade  =  FALSE, float fDelayUntilFade  =  0.0f, int nHideFeedback  =  0);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetModule',
        [],
        '// 242: Get the module.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetModule();',
        '// 242: Get the module.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetModule();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'CreateObject',
        [ScriptParam(DataType.INT, 'nObjectType', None), ScriptParam(DataType.STRING, 'sTemplate', None), ScriptParam(DataType.LOCATION, 'lLocation', None), ScriptParam(DataType.INT, 'bUseAppearAnimation', 0), ],
        '// 243: Create an object of the specified type at lLocation.\r\n// - nObjectType: OBJECT_TYPE_ITEM, OBJECT_TYPE_CREATURE, OBJECT_TYPE_PLACEABLE,\r\n//   OBJECT_TYPE_STORE\r\n// - sTemplate\r\n// - lLocation\r\n// - bUseAppearAnimation\r\n// Waypoints can now also be created using the CreateObject function.\r\n// nObjectType is: OBJECT_TYPE_WAYPOINT\r\n// sTemplate will be the tag of the waypoint\r\n// lLocation is where the waypoint will be placed\r\n// bUseAppearAnimation is ignored\r\nobject CreateObject(int nObjectType, string sTemplate, location lLocation, int bUseAppearAnimation = FALSE);',
        '// 243: Create an object of the specified type at lLocation.\r\n// - nObjectType: OBJECT_TYPE_ITEM, OBJECT_TYPE_CREATURE, OBJECT_TYPE_PLACEABLE,\r\n//   OBJECT_TYPE_STORE\r\n// - sTemplate\r\n// - lLocation\r\n// - bUseAppearAnimation\r\n// Waypoints can now also be created using the CreateObject function.\r\n// nObjectType is: OBJECT_TYPE_WAYPOINT\r\n// sTemplate will be the tag of the waypoint\r\n// lLocation is where the waypoint will be placed\r\n// bUseAppearAnimation is ignored\r\nobject CreateObject(int nObjectType, string sTemplate, location lLocation, int bUseAppearAnimation = FALSE);'
    ),
    ScriptFunction(
        DataType.EVENT,
        'EventSpellCastAt',
        [ScriptParam(DataType.OBJECT, 'oCaster', None), ScriptParam(DataType.INT, 'nSpell', None), ScriptParam(DataType.INT, 'bHarmful', 1), ],
        '// 244: Create an event which triggers the "SpellCastAt" script\r\nevent EventSpellCastAt(object oCaster, int nSpell, int bHarmful = TRUE);',
        '// 244: Create an event which triggers the "SpellCastAt" script\r\nevent EventSpellCastAt(object oCaster, int nSpell, int bHarmful = TRUE);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastSpellCaster',
        [],
        '// 245: This is for use in a "Spell Cast" script, it gets who cast the spell.\r\n// The spell could have been cast by a creature, placeable or door.\r\n// * Returns OBJECT_INVALID if the caller is not a creature, placeable or door.\r\nobject GetLastSpellCaster();',
        '// 245: This is for use in a "Spell Cast" script, it gets who cast the spell.\r\n// The spell could have been cast by a creature, placeable or door.\r\n// * Returns OBJECT_INVALID if the caller is not a creature, placeable or door.\r\nobject GetLastSpellCaster();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastSpell',
        [],
        '// 246: This is for use in a "Spell Cast" script, it gets the ID of the spell that\r\n// was cast.\r\nint GetLastSpell();',
        '// 246: This is for use in a "Spell Cast" script, it gets the ID of the spell that\r\n// was cast.\r\nint GetLastSpell();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetUserDefinedEventNumber',
        [],
        '// 247: This is for use in a user-defined script, it gets the event number.\r\nint GetUserDefinedEventNumber();',
        '// 247: This is for use in a user-defined script, it gets the event number.\r\nint GetUserDefinedEventNumber();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetSpellId',
        [],
        '// 248: This is for use in a Spell script, it gets the ID of the spell that is being\r\n// cast (SPELL_*).\r\nint GetSpellId();',
        '// 248: This is for use in a Spell script, it gets the ID of the spell that is being\r\n// cast (SPELL_*).\r\nint GetSpellId();'
    ),
    ScriptFunction(
        DataType.STRING,
        'RandomName',
        [],
        '// 249: Generate a random name.\r\nstring RandomName();',
        '// 249: Generate a random name.\r\nstring RandomName();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectPoison',
        [ScriptParam(DataType.INT, 'nPoisonType', None), ],
        '// 250: Create a Poison effect.\r\n// - nPoisonType: POISON_*\r\neffect EffectPoison(int nPoisonType);',
        '// 250: Create a Poison effect.\r\n// - nPoisonType: POISON_*\r\neffect EffectPoison(int nPoisonType);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLoadFromSaveGame',
        [],
        '// 251: Returns whether this script is being run\r\n//      while a load game is in progress\r\nint GetLoadFromSaveGame();',
        '// 251: Returns whether this script is being run\r\n//      while a load game is in progress\r\nint GetLoadFromSaveGame();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectAssuredDeflection',
        [ScriptParam(DataType.INT, 'nReturn', 0), ],
        '// 252: Assured Deflection\r\n// This effect ensures that all projectiles shot at a jedi will be deflected\r\n// without doing an opposed roll.  It takes an optional parameter to say whether\r\n// the deflected projectile will return to the attacker and cause damage\r\neffect EffectAssuredDeflection(int nReturn  =  0);',
        '// 252: Assured Deflection\r\n// This effect ensures that all projectiles shot at a jedi will be deflected\r\n// without doing an opposed roll.  It takes an optional parameter to say whether\r\n// the deflected projectile will return to the attacker and cause damage\r\neffect EffectAssuredDeflection(int nReturn  =  0);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetName',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 253: Get the name of oObject.\r\nstring GetName(object oObject);',
        '// 253: Get the name of oObject.\r\nstring GetName(object oObject);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastSpeaker',
        [],
        '// 254: Use this in a conversation script to get the person with whom you are conversing.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetLastSpeaker();',
        '// 254: Use this in a conversation script to get the person with whom you are conversing.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetLastSpeaker();'
    ),
    ScriptFunction(
        DataType.INT,
        'BeginConversation',
        [ScriptParam(DataType.STRING, 'sResRef', ''), ScriptParam(DataType.OBJECT, 'oObjectToDialog', 1), ],
        '// 255: Use this in an OnDialog script to start up the dialog tree.\r\n// - sResRef: if this is not specified, the default dialog file will be used\r\n// - oObjectToDialog: if this is not specified the person that triggered the\r\n//   event will be used\r\nint BeginConversation(string sResRef = "", object oObjectToDialog = OBJECT_INVALID);',
        '// 255: Use this in an OnDialog script to start up the dialog tree.\r\n// - sResRef: if this is not specified, the default dialog file will be used\r\n// - oObjectToDialog: if this is not specified the person that triggered the\r\n//   event will be used\r\nint BeginConversation(string sResRef = "", object oObjectToDialog = OBJECT_INVALID);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastPerceived',
        [],
        '// 256: Use this in an OnPerception script to get the object that was perceived.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetLastPerceived();',
        '// 256: Use this in an OnPerception script to get the object that was perceived.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetLastPerceived();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastPerceptionHeard',
        [],
        '// 257: Use this in an OnPerception script to determine whether the object that was\r\n// perceived was heard.\r\nint GetLastPerceptionHeard();',
        '// 257: Use this in an OnPerception script to determine whether the object that was\r\n// perceived was heard.\r\nint GetLastPerceptionHeard();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastPerceptionInaudible',
        [],
        '// 258: Use this in an OnPerception script to determine whether the object that was\r\n// perceived has become inaudible.\r\nint GetLastPerceptionInaudible();',
        '// 258: Use this in an OnPerception script to determine whether the object that was\r\n// perceived has become inaudible.\r\nint GetLastPerceptionInaudible();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastPerceptionSeen',
        [],
        '// 259: Use this in an OnPerception script to determine whether the object that was\r\n// perceived was seen.\r\nint GetLastPerceptionSeen();',
        '// 259: Use this in an OnPerception script to determine whether the object that was\r\n// perceived was seen.\r\nint GetLastPerceptionSeen();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastClosedBy',
        [],
        '// 260: Use this in an OnClosed script to get the object that closed the door or placeable.\r\n// * Returns OBJECT_INVALID if the caller is not a valid door or placeable.\r\nobject GetLastClosedBy();',
        '// 260: Use this in an OnClosed script to get the object that closed the door or placeable.\r\n// * Returns OBJECT_INVALID if the caller is not a valid door or placeable.\r\nobject GetLastClosedBy();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastPerceptionVanished',
        [],
        '// 261: Use this in an OnPerception script to determine whether the object that was\r\n// perceived has vanished.\r\nint GetLastPerceptionVanished();',
        '// 261: Use this in an OnPerception script to determine whether the object that was\r\n// perceived has vanished.\r\nint GetLastPerceptionVanished();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFirstInPersistentObject',
        [ScriptParam(DataType.OBJECT, 'oPersistentObject', 0), ScriptParam(DataType.INT, 'nResidentObjectType', 1), ScriptParam(DataType.INT, 'nPersistentZone', 0), ],
        '// 262: Get the first object within oPersistentObject.\r\n// - oPersistentObject\r\n// - nResidentObjectType: OBJECT_TYPE_*\r\n// - nPersistentZone: PERSISTENT_ZONE_ACTIVE. [This could also take the value\r\n//   PERSISTENT_ZONE_FOLLOW, but this is no longer used.]\r\n// * Returns OBJECT_INVALID if no object is found.\r\nobject GetFirstInPersistentObject(object oPersistentObject = OBJECT_SELF, int nResidentObjectType = OBJECT_TYPE_CREATURE, int nPersistentZone = PERSISTENT_ZONE_ACTIVE);',
        '// 262: Get the first object within oPersistentObject.\r\n// - oPersistentObject\r\n// - nResidentObjectType: OBJECT_TYPE_*\r\n// - nPersistentZone: PERSISTENT_ZONE_ACTIVE. [This could also take the value\r\n//   PERSISTENT_ZONE_FOLLOW, but this is no longer used.]\r\n// * Returns OBJECT_INVALID if no object is found.\r\nobject GetFirstInPersistentObject(object oPersistentObject = OBJECT_SELF, int nResidentObjectType = OBJECT_TYPE_CREATURE, int nPersistentZone = PERSISTENT_ZONE_ACTIVE);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNextInPersistentObject',
        [ScriptParam(DataType.OBJECT, 'oPersistentObject', 0), ScriptParam(DataType.INT, 'nResidentObjectType', 1), ScriptParam(DataType.INT, 'nPersistentZone', 0), ],
        '// 263: Get the next object within oPersistentObject.\r\n// - oPersistentObject\r\n// - nResidentObjectType: OBJECT_TYPE_*\r\n// - nPersistentZone: PERSISTENT_ZONE_ACTIVE. [This could also take the value\r\n//   PERSISTENT_ZONE_FOLLOW, but this is no longer used.]\r\n// * Returns OBJECT_INVALID if no object is found.\r\nobject GetNextInPersistentObject(object oPersistentObject = OBJECT_SELF, int nResidentObjectType = OBJECT_TYPE_CREATURE, int nPersistentZone = PERSISTENT_ZONE_ACTIVE);',
        '// 263: Get the next object within oPersistentObject.\r\n// - oPersistentObject\r\n// - nResidentObjectType: OBJECT_TYPE_*\r\n// - nPersistentZone: PERSISTENT_ZONE_ACTIVE. [This could also take the value\r\n//   PERSISTENT_ZONE_FOLLOW, but this is no longer used.]\r\n// * Returns OBJECT_INVALID if no object is found.\r\nobject GetNextInPersistentObject(object oPersistentObject = OBJECT_SELF, int nResidentObjectType = OBJECT_TYPE_CREATURE, int nPersistentZone = PERSISTENT_ZONE_ACTIVE);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetAreaOfEffectCreator',
        [ScriptParam(DataType.OBJECT, 'oAreaOfEffectObject', 0), ],
        '// 264: This returns the creator of oAreaOfEffectObject.\r\n// * Returns OBJECT_INVALID if oAreaOfEffectObject is not a valid Area of Effect object.\r\nobject GetAreaOfEffectCreator(object oAreaOfEffectObject = OBJECT_SELF);',
        '// 264: This returns the creator of oAreaOfEffectObject.\r\n// * Returns OBJECT_INVALID if oAreaOfEffectObject is not a valid Area of Effect object.\r\nobject GetAreaOfEffectCreator(object oAreaOfEffectObject = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'ShowLevelUpGUI',
        [],
        '// 265: Brings up the level up GUI for the player.  The GUI will only show up\r\n//      if the player has gained enough experience points to level up.\r\n// * Returns TRUE if the GUI was successfully brought up; FALSE if not.\r\nint ShowLevelUpGUI();',
        '// 265: Brings up the level up GUI for the player.  The GUI will only show up\r\n//      if the player has gained enough experience points to level up.\r\n// * Returns TRUE if the GUI was successfully brought up; FALSE if not.\r\nint ShowLevelUpGUI();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetItemNonEquippable',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.INT, 'bNonEquippable', None), ],
        '// 266: Flag the specified item as being non-equippable or not.  Set bNonEquippable\r\n//      to TRUE to prevent this item from being equipped, and FALSE to allow\r\n//      the normal equipping checks to determine if the item can be equipped.\r\n// NOTE: This will do nothing if the object passed in is not an item.  Items that\r\n//       are already equipped when this is called will not automatically be\r\n//       unequipped.  These items will just be prevented from being re-equipped\r\n//       should they be unequipped.\r\nvoid SetItemNonEquippable( object oItem, int bNonEquippable );',
        '// 266: Flag the specified item as being non-equippable or not.  Set bNonEquippable\r\n//      to TRUE to prevent this item from being equipped, and FALSE to allow\r\n//      the normal equipping checks to determine if the item can be equipped.\r\n// NOTE: This will do nothing if the object passed in is not an item.  Items that\r\n//       are already equipped when this is called will not automatically be\r\n//       unequipped.  These items will just be prevented from being re-equipped\r\n//       should they be unequipped.\r\nvoid SetItemNonEquippable( object oItem, int bNonEquippable );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetButtonMashCheck',
        [],
        '// 267: GetButtonMashCheck\r\n// This function returns whether the button mash check, used for the combat tutorial, is on\r\nint GetButtonMashCheck();',
        '// 267: GetButtonMashCheck\r\n// This function returns whether the button mash check, used for the combat tutorial, is on\r\nint GetButtonMashCheck();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetButtonMashCheck',
        [ScriptParam(DataType.INT, 'nCheck', None), ],
        '// 268: SetButtonMashCheck\r\n// This function sets the button mash check variable, and is used for turning the check on and off\r\nvoid SetButtonMashCheck(int nCheck);',
        '// 268: SetButtonMashCheck\r\n// This function sets the button mash check variable, and is used for turning the check on and off\r\nvoid SetButtonMashCheck(int nCheck);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectForcePushTargeted',
        [ScriptParam(DataType.LOCATION, 'lCentre', None), ScriptParam(DataType.INT, 'nIgnoreTestDirectLine', 0), ],
        '// 269: EffectForcePushTargeted\r\n// This effect is exactly the same as force push, except it takes a location parameter that specifies\r\n// where the location of the force push is to be done from.  All orientations are also based on this location.\r\n// AMF:  The new ignore test direct line variable should be used with extreme caution\r\n// It overrides geometry checks for force pushes, so that the object that the effect is applied to\r\n// is guaranteed to move that far, ignoring collisions.  It is best used for cutscenes.\r\neffect EffectForcePushTargeted(location lCentre, int nIgnoreTestDirectLine  =  0);',
        '// 269: EffectForcePushTargeted\r\n// This effect is exactly the same as force push, except it takes a location parameter that specifies\r\n// where the location of the force push is to be done from.  All orientations are also based on this location.\r\n// AMF:  The new ignore test direct line variable should be used with extreme caution\r\n// It overrides geometry checks for force pushes, so that the object that the effect is applied to\r\n// is guaranteed to move that far, ignoring collisions.  It is best used for cutscenes.\r\neffect EffectForcePushTargeted(location lCentre, int nIgnoreTestDirectLine  =  0);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectHaste',
        [],
        '// 270: Create a Haste effect.\r\neffect EffectHaste();',
        '// 270: Create a Haste effect.\r\neffect EffectHaste();'
    ),
    ScriptFunction(
        DataType.VOID,
        'GiveItem',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.OBJECT, 'oGiveTo', None), ],
        '// 271: Give oItem to oGiveTo (instant; for similar Action use ActionGiveItem)\r\n// If oItem is not a valid item, or oGiveTo is not a valid object, nothing will\r\n// happen.\r\nvoid GiveItem(object oItem, object oGiveTo);',
        '// 271: Give oItem to oGiveTo (instant; for similar Action use ActionGiveItem)\r\n// If oItem is not a valid item, or oGiveTo is not a valid object, nothing will\r\n// happen.\r\nvoid GiveItem(object oItem, object oGiveTo);'
    ),
    ScriptFunction(
        DataType.STRING,
        'ObjectToString',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 272: Convert oObject into a hexadecimal string.\r\nstring ObjectToString(object oObject);',
        '// 272: Convert oObject into a hexadecimal string.\r\nstring ObjectToString(object oObject);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectImmunity',
        [ScriptParam(DataType.INT, 'nImmunityType', None), ],
        '// 273: Create an Immunity effect.\r\n// - nImmunityType: IMMUNITY_TYPE_*\r\neffect EffectImmunity(int nImmunityType);',
        '// 273: Create an Immunity effect.\r\n// - nImmunityType: IMMUNITY_TYPE_*\r\neffect EffectImmunity(int nImmunityType);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsImmune',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nImmunityType', None), ScriptParam(DataType.OBJECT, 'oVersus', 1), ],
        '// 274: - oCreature\r\n// - nImmunityType: IMMUNITY_TYPE_*\r\n// - oVersus: if this is specified, then we also check for the race and\r\n//   alignment of oVersus\r\n// * Returns TRUE if oCreature has immunity of type nImmunity versus oVersus.\r\nint GetIsImmune(object oCreature, int nImmunityType, object oVersus = OBJECT_INVALID);',
        '// 274: - oCreature\r\n// - nImmunityType: IMMUNITY_TYPE_*\r\n// - oVersus: if this is specified, then we also check for the race and\r\n//   alignment of oVersus\r\n// * Returns TRUE if oCreature has immunity of type nImmunity versus oVersus.\r\nint GetIsImmune(object oCreature, int nImmunityType, object oVersus = OBJECT_INVALID);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDamageImmunityIncrease',
        [ScriptParam(DataType.INT, 'nDamageType', None), ScriptParam(DataType.INT, 'nPercentImmunity', None), ],
        '// 275: Creates a Damage Immunity Increase effect.\r\n// - nDamageType: DAMAGE_TYPE_*\r\n// - nPercentImmunity\r\neffect EffectDamageImmunityIncrease(int nDamageType, int nPercentImmunity);',
        '// 275: Creates a Damage Immunity Increase effect.\r\n// - nDamageType: DAMAGE_TYPE_*\r\n// - nPercentImmunity\r\neffect EffectDamageImmunityIncrease(int nDamageType, int nPercentImmunity);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetEncounterActive',
        [ScriptParam(DataType.OBJECT, 'oEncounter', 0), ],
        '// 276: Determine whether oEncounter is active.\r\nint  GetEncounterActive(object oEncounter = OBJECT_SELF);',
        '// 276: Determine whether oEncounter is active.\r\nint  GetEncounterActive(object oEncounter = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetEncounterActive',
        [ScriptParam(DataType.INT, 'nNewValue', None), ScriptParam(DataType.OBJECT, 'oEncounter', 0), ],
        "// 277: Set oEncounter's active state to nNewValue.\r\n// - nNewValue: TRUE/FALSE\r\n// - oEncounter\r\nvoid SetEncounterActive(int nNewValue, object oEncounter = OBJECT_SELF);",
        "// 277: Set oEncounter's active state to nNewValue.\r\n// - nNewValue: TRUE/FALSE\r\n// - oEncounter\r\nvoid SetEncounterActive(int nNewValue, object oEncounter = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetEncounterSpawnsMax',
        [ScriptParam(DataType.OBJECT, 'oEncounter', 0), ],
        '// 278: Get the maximum number of times that oEncounter will spawn.\r\nint GetEncounterSpawnsMax(object oEncounter = OBJECT_SELF);',
        '// 278: Get the maximum number of times that oEncounter will spawn.\r\nint GetEncounterSpawnsMax(object oEncounter = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetEncounterSpawnsMax',
        [ScriptParam(DataType.INT, 'nNewValue', None), ScriptParam(DataType.OBJECT, 'oEncounter', 0), ],
        '// 279: Set the maximum number of times that oEncounter can spawn\r\nvoid SetEncounterSpawnsMax(int nNewValue, object oEncounter = OBJECT_SELF);',
        '// 279: Set the maximum number of times that oEncounter can spawn\r\nvoid SetEncounterSpawnsMax(int nNewValue, object oEncounter = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetEncounterSpawnsCurrent',
        [ScriptParam(DataType.OBJECT, 'oEncounter', 0), ],
        '// 280: Get the number of times that oEncounter has spawned so far\r\nint  GetEncounterSpawnsCurrent(object oEncounter = OBJECT_SELF);',
        '// 280: Get the number of times that oEncounter has spawned so far\r\nint  GetEncounterSpawnsCurrent(object oEncounter = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetEncounterSpawnsCurrent',
        [ScriptParam(DataType.INT, 'nNewValue', None), ScriptParam(DataType.OBJECT, 'oEncounter', 0), ],
        '// 281: Set the number of times that oEncounter has spawned so far\r\nvoid SetEncounterSpawnsCurrent(int nNewValue, object oEncounter = OBJECT_SELF);',
        '// 281: Set the number of times that oEncounter has spawned so far\r\nvoid SetEncounterSpawnsCurrent(int nNewValue, object oEncounter = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetModuleItemAcquired',
        [],
        '// 282: Use this in an OnItemAcquired script to get the item that was acquired.\r\n// * Returns OBJECT_INVALID if the module is not valid.\r\nobject GetModuleItemAcquired();',
        '// 282: Use this in an OnItemAcquired script to get the item that was acquired.\r\n// * Returns OBJECT_INVALID if the module is not valid.\r\nobject GetModuleItemAcquired();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetModuleItemAcquiredFrom',
        [],
        '// 283: Use this in an OnItemAcquired script to get the creatre that previously\r\n// possessed the item.\r\n// * Returns OBJECT_INVALID if the item was picked up from the ground.\r\nobject GetModuleItemAcquiredFrom();',
        '// 283: Use this in an OnItemAcquired script to get the creatre that previously\r\n// possessed the item.\r\n// * Returns OBJECT_INVALID if the item was picked up from the ground.\r\nobject GetModuleItemAcquiredFrom();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetCustomToken',
        [ScriptParam(DataType.INT, 'nCustomTokenNumber', None), ScriptParam(DataType.STRING, 'sTokenValue', None), ],
        '// 284: Set the value for a custom token.\r\nvoid SetCustomToken(int nCustomTokenNumber, string sTokenValue);',
        '// 284: Set the value for a custom token.\r\nvoid SetCustomToken(int nCustomTokenNumber, string sTokenValue);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetHasFeat',
        [ScriptParam(DataType.INT, 'nFeat', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        "// 285: Determine whether oCreature has nFeat, and nFeat is useable.\r\n// PLEASE NOTE!!! - This function will return FALSE if the target\r\n// is not currently able to use the feat due to daily limits or\r\n// other restrictions. Use GetFeatAcquired() if you just want to\r\n// know if they've got it or not.\r\n// - nFeat: FEAT_*\r\n// - oCreature\r\nint GetHasFeat(int nFeat, object oCreature = OBJECT_SELF);",
        "// 285: Determine whether oCreature has nFeat, and nFeat is useable.\r\n// PLEASE NOTE!!! - This function will return FALSE if the target\r\n// is not currently able to use the feat due to daily limits or\r\n// other restrictions. Use GetFeatAcquired() if you just want to\r\n// know if they've got it or not.\r\n// - nFeat: FEAT_*\r\n// - oCreature\r\nint GetHasFeat(int nFeat, object oCreature = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetHasSkill',
        [ScriptParam(DataType.INT, 'nSkill', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        '// 286: Determine whether oCreature has nSkill, and nSkill is useable.\r\n// - nSkill: SKILL_*\r\n// - oCreature\r\nint GetHasSkill(int nSkill, object oCreature = OBJECT_SELF);',
        '// 286: Determine whether oCreature has nSkill, and nSkill is useable.\r\n// - nSkill: SKILL_*\r\n// - oCreature\r\nint GetHasSkill(int nSkill, object oCreature = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionUseFeat',
        [ScriptParam(DataType.INT, 'nFeat', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 287: Use nFeat on oTarget.\r\n// - nFeat: FEAT_*\r\n// - oTarget\r\nvoid ActionUseFeat(int nFeat, object oTarget);',
        '// 287: Use nFeat on oTarget.\r\n// - nFeat: FEAT_*\r\n// - oTarget\r\nvoid ActionUseFeat(int nFeat, object oTarget);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionUseSkill',
        [ScriptParam(DataType.INT, 'nSkill', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'nSubSkill', 0), ScriptParam(DataType.OBJECT, 'oItemUsed', 1), ],
        '// 288: Runs the action "UseSkill" on the current creature\r\n// Use nSkill on oTarget.\r\n// - nSkill: SKILL_*\r\n// - oTarget\r\n// - nSubSkill: SUBSKILL_*\r\n// - oItemUsed: Item to use in conjunction with the skill\r\nvoid ActionUseSkill(int nSkill, object oTarget, int nSubSkill = 0, object oItemUsed = OBJECT_INVALID );',
        '// 288: Runs the action "UseSkill" on the current creature\r\n// Use nSkill on oTarget.\r\n// - nSkill: SKILL_*\r\n// - oTarget\r\n// - nSubSkill: SUBSKILL_*\r\n// - oItemUsed: Item to use in conjunction with the skill\r\nvoid ActionUseSkill(int nSkill, object oTarget, int nSubSkill = 0, object oItemUsed = OBJECT_INVALID );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetObjectSeen',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.OBJECT, 'oSource', 0), ],
        '// 289: Determine whether oSource sees oTarget.\r\nint GetObjectSeen(object oTarget, object oSource = OBJECT_SELF);',
        '// 289: Determine whether oSource sees oTarget.\r\nint GetObjectSeen(object oTarget, object oSource = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetObjectHeard',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.OBJECT, 'oSource', 0), ],
        '// 290: Determine whether oSource hears oTarget.\r\nint GetObjectHeard(object oTarget, object oSource = OBJECT_SELF);',
        '// 290: Determine whether oSource hears oTarget.\r\nint GetObjectHeard(object oTarget, object oSource = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastPlayerDied',
        [],
        '// 291: Use this in an OnPlayerDeath module script to get the last player that died.\r\nobject GetLastPlayerDied();',
        '// 291: Use this in an OnPlayerDeath module script to get the last player that died.\r\nobject GetLastPlayerDied();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetModuleItemLost',
        [],
        '// 292: Use this in an OnItemLost script to get the item that was lost/dropped.\r\n// * Returns OBJECT_INVALID if the module is not valid.\r\nobject GetModuleItemLost();',
        '// 292: Use this in an OnItemLost script to get the item that was lost/dropped.\r\n// * Returns OBJECT_INVALID if the module is not valid.\r\nobject GetModuleItemLost();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetModuleItemLostBy',
        [],
        '// 293: Use this in an OnItemLost script to get the creature that lost the item.\r\n// * Returns OBJECT_INVALID if the module is not valid.\r\nobject GetModuleItemLostBy();',
        '// 293: Use this in an OnItemLost script to get the creature that lost the item.\r\n// * Returns OBJECT_INVALID if the module is not valid.\r\nobject GetModuleItemLostBy();'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionDoCommand',
        [ScriptParam(DataType.ACTION, 'aActionToDo', None), ],
        '// 294: Do aActionToDo.\r\nvoid ActionDoCommand(action aActionToDo);',
        '// 294: Do aActionToDo.\r\nvoid ActionDoCommand(action aActionToDo);'
    ),
    ScriptFunction(
        DataType.EVENT,
        'EventConversation',
        [],
        '// 295: Conversation event.\r\nevent EventConversation();',
        '// 295: Conversation event.\r\nevent EventConversation();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetEncounterDifficulty',
        [ScriptParam(DataType.INT, 'nEncounterDifficulty', None), ScriptParam(DataType.OBJECT, 'oEncounter', 0), ],
        '// 296: Set the difficulty level of oEncounter.\r\n// - nEncounterDifficulty: ENCOUNTER_DIFFICULTY_*\r\n// - oEncounter\r\nvoid SetEncounterDifficulty(int nEncounterDifficulty, object oEncounter = OBJECT_SELF);',
        '// 296: Set the difficulty level of oEncounter.\r\n// - nEncounterDifficulty: ENCOUNTER_DIFFICULTY_*\r\n// - oEncounter\r\nvoid SetEncounterDifficulty(int nEncounterDifficulty, object oEncounter = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetEncounterDifficulty',
        [ScriptParam(DataType.OBJECT, 'oEncounter', 0), ],
        '// 297: Get the difficulty level of oEncounter.\r\nint GetEncounterDifficulty(object oEncounter = OBJECT_SELF);',
        '// 297: Get the difficulty level of oEncounter.\r\nint GetEncounterDifficulty(object oEncounter = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetDistanceBetweenLocations',
        [ScriptParam(DataType.LOCATION, 'lLocationA', None), ScriptParam(DataType.LOCATION, 'lLocationB', None), ],
        '// 298: Get the distance between lLocationA and lLocationB.\r\nfloat GetDistanceBetweenLocations(location lLocationA, location lLocationB);',
        '// 298: Get the distance between lLocationA and lLocationB.\r\nfloat GetDistanceBetweenLocations(location lLocationA, location lLocationB);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetReflexAdjustedDamage',
        [ScriptParam(DataType.INT, 'nDamage', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'nDC', None), ScriptParam(DataType.INT, 'nSaveType', 0), ScriptParam(DataType.OBJECT, 'oSaveVersus', 0), ],
        "// 299: Use this in spell scripts to get nDamage adjusted by oTarget's reflex and\r\n// evasion saves.\r\n// - nDamage\r\n// - oTarget\r\n// - nDC: Difficulty check\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\n// - oSaveVersus\r\nint GetReflexAdjustedDamage(int nDamage, object oTarget, int nDC, int nSaveType = SAVING_THROW_TYPE_NONE, object oSaveVersus = OBJECT_SELF);",
        "// 299: Use this in spell scripts to get nDamage adjusted by oTarget's reflex and\r\n// evasion saves.\r\n// - nDamage\r\n// - oTarget\r\n// - nDC: Difficulty check\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\n// - oSaveVersus\r\nint GetReflexAdjustedDamage(int nDamage, object oTarget, int nDC, int nSaveType = SAVING_THROW_TYPE_NONE, object oSaveVersus = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.VOID,
        'PlayAnimation',
        [ScriptParam(DataType.INT, 'nAnimation', None), ScriptParam(DataType.FLOAT, 'fSpeed', 1.0), ScriptParam(DataType.FLOAT, 'fSeconds', 0.0), ],
        '// 300: Play nAnimation immediately.\r\n// - nAnimation: ANIMATION_*\r\n// - fSpeed\r\n// - fSeconds: Duration of the animation (this is not used for Fire and\r\n//   Forget animations) If a time of -1.0f is specified for a looping animation\r\n//   it will loop until the next animation is applied.\r\nvoid PlayAnimation(int nAnimation, float fSpeed = 1.0, float fSeconds = 0.0);',
        '// 300: Play nAnimation immediately.\r\n// - nAnimation: ANIMATION_*\r\n// - fSpeed\r\n// - fSeconds: Duration of the animation (this is not used for Fire and\r\n//   Forget animations) If a time of -1.0f is specified for a looping animation\r\n//   it will loop until the next animation is applied.\r\nvoid PlayAnimation(int nAnimation, float fSpeed = 1.0, float fSeconds = 0.0);'
    ),
    ScriptFunction(
        DataType.TALENT,
        'TalentSpell',
        [ScriptParam(DataType.INT, 'nSpell', None), ],
        '// 301: Create a Spell Talent.\r\n// - nSpell: SPELL_*\r\ntalent TalentSpell(int nSpell);',
        '// 301: Create a Spell Talent.\r\n// - nSpell: SPELL_*\r\ntalent TalentSpell(int nSpell);'
    ),
    ScriptFunction(
        DataType.TALENT,
        'TalentFeat',
        [ScriptParam(DataType.INT, 'nFeat', None), ],
        '// 302: Create a Feat Talent.\r\n// - nFeat: FEAT_*\r\ntalent TalentFeat(int nFeat);',
        '// 302: Create a Feat Talent.\r\n// - nFeat: FEAT_*\r\ntalent TalentFeat(int nFeat);'
    ),
    ScriptFunction(
        DataType.TALENT,
        'TalentSkill',
        [ScriptParam(DataType.INT, 'nSkill', None), ],
        '// 303: Create a Skill Talent.\r\n// - nSkill: SKILL_*\r\ntalent TalentSkill(int nSkill);',
        '// 303: Create a Skill Talent.\r\n// - nSkill: SKILL_*\r\ntalent TalentSkill(int nSkill);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetHasSpellEffect',
        [ScriptParam(DataType.INT, 'nSpell', None), ScriptParam(DataType.OBJECT, 'oObject', 0), ],
        '// 304: Determine if oObject has effects originating from nSpell.\r\n// - nSpell: SPELL_*\r\n// - oObject\r\nint GetHasSpellEffect(int nSpell, object oObject = OBJECT_SELF);',
        '// 304: Determine if oObject has effects originating from nSpell.\r\n// - nSpell: SPELL_*\r\n// - oObject\r\nint GetHasSpellEffect(int nSpell, object oObject = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetEffectSpellId',
        [ScriptParam(DataType.EFFECT, 'eSpellEffect', None), ],
        '// 305: Get the spell (SPELL_*) that applied eSpellEffect.\r\n// * Returns -1 if eSpellEffect was applied outside a spell script.\r\nint GetEffectSpellId(effect eSpellEffect);',
        '// 305: Get the spell (SPELL_*) that applied eSpellEffect.\r\n// * Returns -1 if eSpellEffect was applied outside a spell script.\r\nint GetEffectSpellId(effect eSpellEffect);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetCreatureHasTalent',
        [ScriptParam(DataType.TALENT, 'tTalent', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        '// 306: Determine whether oCreature has tTalent.\r\nint GetCreatureHasTalent(talent tTalent, object oCreature = OBJECT_SELF);',
        '// 306: Determine whether oCreature has tTalent.\r\nint GetCreatureHasTalent(talent tTalent, object oCreature = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.TALENT,
        'GetCreatureTalentRandom',
        [ScriptParam(DataType.INT, 'nCategory', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ScriptParam(DataType.INT, 'nInclusion', 0), ],
        '// 307: Get a random talent of oCreature, within nCategory.\r\n// - nCategory: TALENT_CATEGORY_*\r\n// - oCreature\r\n// - nInclusion: types of talent to include\r\ntalent GetCreatureTalentRandom(int nCategory, object oCreature = OBJECT_SELF, int nInclusion = 0);',
        '// 307: Get a random talent of oCreature, within nCategory.\r\n// - nCategory: TALENT_CATEGORY_*\r\n// - oCreature\r\n// - nInclusion: types of talent to include\r\ntalent GetCreatureTalentRandom(int nCategory, object oCreature = OBJECT_SELF, int nInclusion = 0);'
    ),
    ScriptFunction(
        DataType.TALENT,
        'GetCreatureTalentBest',
        [ScriptParam(DataType.INT, 'nCategory', None), ScriptParam(DataType.INT, 'nCRMax', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ScriptParam(DataType.INT, 'nInclusion', 0), ScriptParam(DataType.INT, 'nExcludeType', -1), ScriptParam(DataType.INT, 'nExcludeId', -1), ],
        '// 308: Get the best talent (i.e. closest to nCRMax without going over) of oCreature,\r\n// within nCategory.\r\n// - nCategory: TALENT_CATEGORY_*\r\n// - nCRMax: Challenge Rating of the talent\r\n// - oCreature\r\n// - nInclusion: types of talent to include\r\n// - nExcludeType: TALENT_TYPE_FEAT or TALENT_TYPE_FORCE, type of talent that we wish to ignore\r\n// - nExcludeId: Talent ID of the talent we wish to ignore.\r\n//   A value of TALENT_EXCLUDE_ALL_OF_TYPE for this parameter will mean that all talents of\r\n//   type nExcludeType are ignored.\r\ntalent GetCreatureTalentBest(int nCategory, int nCRMax, object oCreature = OBJECT_SELF, int nInclusion = 0, int nExcludeType  =  -1, int nExcludeId  =  -1);',
        '// 308: Get the best talent (i.e. closest to nCRMax without going over) of oCreature,\r\n// within nCategory.\r\n// - nCategory: TALENT_CATEGORY_*\r\n// - nCRMax: Challenge Rating of the talent\r\n// - oCreature\r\n// - nInclusion: types of talent to include\r\n// - nExcludeType: TALENT_TYPE_FEAT or TALENT_TYPE_FORCE, type of talent that we wish to ignore\r\n// - nExcludeId: Talent ID of the talent we wish to ignore.\r\n//   A value of TALENT_EXCLUDE_ALL_OF_TYPE for this parameter will mean that all talents of\r\n//   type nExcludeType are ignored.\r\ntalent GetCreatureTalentBest(int nCategory, int nCRMax, object oCreature = OBJECT_SELF, int nInclusion = 0, int nExcludeType  =  -1, int nExcludeId  =  -1);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionUseTalentOnObject',
        [ScriptParam(DataType.TALENT, 'tChosenTalent', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 309: Use tChosenTalent on oTarget.\r\nvoid ActionUseTalentOnObject(talent tChosenTalent, object oTarget);',
        '// 309: Use tChosenTalent on oTarget.\r\nvoid ActionUseTalentOnObject(talent tChosenTalent, object oTarget);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionUseTalentAtLocation',
        [ScriptParam(DataType.TALENT, 'tChosenTalent', None), ScriptParam(DataType.LOCATION, 'lTargetLocation', None), ],
        '// 310: Use tChosenTalent at lTargetLocation.\r\nvoid ActionUseTalentAtLocation(talent tChosenTalent, location lTargetLocation);',
        '// 310: Use tChosenTalent at lTargetLocation.\r\nvoid ActionUseTalentAtLocation(talent tChosenTalent, location lTargetLocation);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetGoldPieceValue',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 311: Get the gold piece value of oItem.\r\n// * Returns 0 if oItem is not a valid item.\r\nint GetGoldPieceValue(object oItem);',
        '// 311: Get the gold piece value of oItem.\r\n// * Returns 0 if oItem is not a valid item.\r\nint GetGoldPieceValue(object oItem);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsPlayableRacialType',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 312: * Returns TRUE if oCreature is of a playable racial type.\r\nint GetIsPlayableRacialType(object oCreature);',
        '// 312: * Returns TRUE if oCreature is of a playable racial type.\r\nint GetIsPlayableRacialType(object oCreature);'
    ),
    ScriptFunction(
        DataType.VOID,
        'JumpToLocation',
        [ScriptParam(DataType.LOCATION, 'lDestination', None), ],
        '// 313: Jump to lDestination.  The action is added to the TOP of the action queue.\r\nvoid JumpToLocation(location lDestination);',
        '// 313: Jump to lDestination.  The action is added to the TOP of the action queue.\r\nvoid JumpToLocation(location lDestination);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectTemporaryHitpoints',
        [ScriptParam(DataType.INT, 'nHitPoints', None), ],
        '// 314: Create a Temporary Hitpoints effect.\r\n// - nHitPoints: a positive integer\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nHitPoints < 0.\r\neffect EffectTemporaryHitpoints(int nHitPoints);',
        '// 314: Create a Temporary Hitpoints effect.\r\n// - nHitPoints: a positive integer\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nHitPoints < 0.\r\neffect EffectTemporaryHitpoints(int nHitPoints);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetSkillRank',
        [ScriptParam(DataType.INT, 'nSkill', None), ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        "// 315: Get the number of ranks that oTarget has in nSkill.\r\n// - nSkill: SKILL_*\r\n// - oTarget\r\n// * Returns -1 if oTarget doesn't have nSkill.\r\n// * Returns 0 if nSkill is untrained.\r\nint GetSkillRank(int nSkill, object oTarget = OBJECT_SELF);",
        "// 315: Get the number of ranks that oTarget has in nSkill.\r\n// - nSkill: SKILL_*\r\n// - oTarget\r\n// * Returns -1 if oTarget doesn't have nSkill.\r\n// * Returns 0 if nSkill is untrained.\r\nint GetSkillRank(int nSkill, object oTarget = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetAttackTarget',
        [ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        '// 316: Get the attack target of oCreature.\r\n// This only works when oCreature is in combat.\r\nobject GetAttackTarget(object oCreature = OBJECT_SELF);',
        '// 316: Get the attack target of oCreature.\r\n// This only works when oCreature is in combat.\r\nobject GetAttackTarget(object oCreature = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastAttackType',
        [ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        "// 317: Get the attack type (SPECIAL_ATTACK_*) of oCreature's last attack.\r\n// This only works when oCreature is in combat.\r\nint GetLastAttackType(object oCreature = OBJECT_SELF);",
        "// 317: Get the attack type (SPECIAL_ATTACK_*) of oCreature's last attack.\r\n// This only works when oCreature is in combat.\r\nint GetLastAttackType(object oCreature = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastAttackMode',
        [ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        "// 318: Get the attack mode (COMBAT_MODE_*) of oCreature's last attack.\r\n// This only works when oCreature is in combat.\r\nint GetLastAttackMode(object oCreature = OBJECT_SELF);",
        "// 318: Get the attack mode (COMBAT_MODE_*) of oCreature's last attack.\r\n// This only works when oCreature is in combat.\r\nint GetLastAttackMode(object oCreature = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetDistanceBetween2D',
        [ScriptParam(DataType.OBJECT, 'oObjectA', None), ScriptParam(DataType.OBJECT, 'oObjectB', None), ],
        '// 319: Get the distance in metres between oObjectA and oObjectB in 2D.\r\n// * Return value if either object is invalid: 0.0f\r\nfloat GetDistanceBetween2D(object oObjectA, object oObjectB);',
        '// 319: Get the distance in metres between oObjectA and oObjectB in 2D.\r\n// * Return value if either object is invalid: 0.0f\r\nfloat GetDistanceBetween2D(object oObjectA, object oObjectB);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsInCombat',
        [ScriptParam(DataType.OBJECT, 'oCreature', 0), ScriptParam(DataType.INT, 'bOnlyCountReal', 0), ],
        "// 320: * Returns TRUE if oCreature is in combat.\r\n//RWT-OEI 09/30/04 - If you pass TRUE in as the second parameter then\r\n//this function will only return true if the character is in REAL combat.\r\n//If you don't know what that means, don't pass in TRUE.\r\nint GetIsInCombat(object oCreature = OBJECT_SELF, int bOnlyCountReal  =  FALSE);",
        "// 320: * Returns TRUE if oCreature is in combat.\r\n//RWT-OEI 09/30/04 - If you pass TRUE in as the second parameter then\r\n//this function will only return true if the character is in REAL combat.\r\n//If you don't know what that means, don't pass in TRUE.\r\nint GetIsInCombat(object oCreature = OBJECT_SELF, int bOnlyCountReal  =  FALSE);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastAssociateCommand',
        [ScriptParam(DataType.OBJECT, 'oAssociate', 0), ],
        '// 321: Get the last command (ASSOCIATE_COMMAND_*) issued to oAssociate.\r\nint GetLastAssociateCommand(object oAssociate = OBJECT_SELF);',
        '// 321: Get the last command (ASSOCIATE_COMMAND_*) issued to oAssociate.\r\nint GetLastAssociateCommand(object oAssociate = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'GiveGoldToCreature',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nGP', None), ],
        '// 322: Give nGP gold to oCreature.\r\nvoid GiveGoldToCreature(object oCreature, int nGP);',
        '// 322: Give nGP gold to oCreature.\r\nvoid GiveGoldToCreature(object oCreature, int nGP);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetIsDestroyable',
        [ScriptParam(DataType.INT, 'bDestroyable', None), ScriptParam(DataType.INT, 'bRaiseable', 1), ScriptParam(DataType.INT, 'bSelectableWhenDead', 0), ],
        '// 323: Set the destroyable status of the caller.\r\n// - bDestroyable: If this is FALSE, the caller does not fade out on death, but\r\n//   sticks around as a corpse.\r\n// - bRaiseable: If this is TRUE, the caller can be raised via resurrection.\r\n// - bSelectableWhenDead: If this is TRUE, the caller is selectable after death.\r\nvoid SetIsDestroyable(int bDestroyable, int bRaiseable = TRUE, int bSelectableWhenDead = FALSE);',
        '// 323: Set the destroyable status of the caller.\r\n// - bDestroyable: If this is FALSE, the caller does not fade out on death, but\r\n//   sticks around as a corpse.\r\n// - bRaiseable: If this is TRUE, the caller can be raised via resurrection.\r\n// - bSelectableWhenDead: If this is TRUE, the caller is selectable after death.\r\nvoid SetIsDestroyable(int bDestroyable, int bRaiseable = TRUE, int bSelectableWhenDead = FALSE);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetLocked',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'bLocked', None), ],
        '// 324: Set the locked state of oTarget, which can be a door or a placeable object.\r\nvoid SetLocked(object oTarget, int bLocked);',
        '// 324: Set the locked state of oTarget, which can be a door or a placeable object.\r\nvoid SetLocked(object oTarget, int bLocked);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLocked',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 325: Get the locked state of oTarget, which can be a door or a placeable object.\r\nint GetLocked(object oTarget);',
        '// 325: Get the locked state of oTarget, which can be a door or a placeable object.\r\nint GetLocked(object oTarget);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetClickingObject',
        [],
        "// 326: Use this in a trigger's OnClick event script to get the object that last\r\n// clicked on it.\r\n// This is identical to GetEnteringObject.\r\nobject GetClickingObject();",
        "// 326: Use this in a trigger's OnClick event script to get the object that last\r\n// clicked on it.\r\n// This is identical to GetEnteringObject.\r\nobject GetClickingObject();"
    ),
    ScriptFunction(
        DataType.VOID,
        'SetAssociateListenPatterns',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        '// 327: Initialise oTarget to listen for the standard Associates commands.\r\nvoid SetAssociateListenPatterns(object oTarget = OBJECT_SELF);',
        '// 327: Initialise oTarget to listen for the standard Associates commands.\r\nvoid SetAssociateListenPatterns(object oTarget = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastWeaponUsed',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 328: Get the last weapon that oCreature used in an attack.\r\n// * Returns OBJECT_INVALID if oCreature did not attack, or has no weapon equipped.\r\nobject GetLastWeaponUsed(object oCreature);',
        '// 328: Get the last weapon that oCreature used in an attack.\r\n// * Returns OBJECT_INVALID if oCreature did not attack, or has no weapon equipped.\r\nobject GetLastWeaponUsed(object oCreature);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionInteractObject',
        [ScriptParam(DataType.OBJECT, 'oPlaceable', None), ],
        '// 329: Use oPlaceable.\r\nvoid ActionInteractObject(object oPlaceable);',
        '// 329: Use oPlaceable.\r\nvoid ActionInteractObject(object oPlaceable);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastUsedBy',
        [],
        '// 330: Get the last object that used the placeable object that is calling this function.\r\n// * Returns OBJECT_INVALID if it is called by something other than a placeable or\r\n//   a door.\r\nobject GetLastUsedBy();',
        '// 330: Get the last object that used the placeable object that is calling this function.\r\n// * Returns OBJECT_INVALID if it is called by something other than a placeable or\r\n//   a door.\r\nobject GetLastUsedBy();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetAbilityModifier',
        [ScriptParam(DataType.INT, 'nAbility', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        "// 331: Returns the ability modifier for the specified ability\r\n// Get oCreature's ability modifier for nAbility.\r\n// - nAbility: ABILITY_*\r\n// - oCreature\r\nint GetAbilityModifier(int nAbility, object oCreature = OBJECT_SELF);",
        "// 331: Returns the ability modifier for the specified ability\r\n// Get oCreature's ability modifier for nAbility.\r\n// - nAbility: ABILITY_*\r\n// - oCreature\r\nint GetAbilityModifier(int nAbility, object oCreature = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetIdentified',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 332: Determined whether oItem has been identified.\r\nint GetIdentified(object oItem);',
        '// 332: Determined whether oItem has been identified.\r\nint GetIdentified(object oItem);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetIdentified',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.INT, 'bIdentified', None), ],
        '// 333: Set whether oItem has been identified.\r\nvoid SetIdentified(object oItem, int bIdentified);',
        '// 333: Set whether oItem has been identified.\r\nvoid SetIdentified(object oItem, int bIdentified);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetDistanceBetweenLocations2D',
        [ScriptParam(DataType.LOCATION, 'lLocationA', None), ScriptParam(DataType.LOCATION, 'lLocationB', None), ],
        '// 334: Get the distance between lLocationA and lLocationB. in 2D\r\nfloat GetDistanceBetweenLocations2D(location lLocationA, location lLocationB);',
        '// 334: Get the distance between lLocationA and lLocationB. in 2D\r\nfloat GetDistanceBetweenLocations2D(location lLocationA, location lLocationB);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetDistanceToObject2D',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 335: Get the distance from the caller to oObject in metres.\r\n// * Return value on error: -1.0f\r\nfloat GetDistanceToObject2D(object oObject);',
        '// 335: Get the distance from the caller to oObject in metres.\r\n// * Return value on error: -1.0f\r\nfloat GetDistanceToObject2D(object oObject);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetBlockingDoor',
        [],
        '// 336: Get the last blocking door encountered by the caller of this function.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetBlockingDoor();',
        '// 336: Get the last blocking door encountered by the caller of this function.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetBlockingDoor();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsDoorActionPossible',
        [ScriptParam(DataType.OBJECT, 'oTargetDoor', None), ScriptParam(DataType.INT, 'nDoorAction', None), ],
        '// 337: - oTargetDoor\r\n// - nDoorAction: DOOR_ACTION_*\r\n// * Returns TRUE if nDoorAction can be performed on oTargetDoor.\r\nint GetIsDoorActionPossible(object oTargetDoor, int nDoorAction);',
        '// 337: - oTargetDoor\r\n// - nDoorAction: DOOR_ACTION_*\r\n// * Returns TRUE if nDoorAction can be performed on oTargetDoor.\r\nint GetIsDoorActionPossible(object oTargetDoor, int nDoorAction);'
    ),
    ScriptFunction(
        DataType.VOID,
        'DoDoorAction',
        [ScriptParam(DataType.OBJECT, 'oTargetDoor', None), ScriptParam(DataType.INT, 'nDoorAction', None), ],
        '// 338: Perform nDoorAction on oTargetDoor.\r\nvoid DoDoorAction(object oTargetDoor, int nDoorAction);',
        '// 338: Perform nDoorAction on oTargetDoor.\r\nvoid DoDoorAction(object oTargetDoor, int nDoorAction);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFirstItemInInventory',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        "// 339: Get the first item in oTarget's inventory (start to cycle through oTarget's\r\n// inventory).\r\n// * Returns OBJECT_INVALID if the caller is not a creature, item, placeable or store,\r\n//   or if no item is found.\r\nobject GetFirstItemInInventory(object oTarget = OBJECT_SELF);",
        "// 339: Get the first item in oTarget's inventory (start to cycle through oTarget's\r\n// inventory).\r\n// * Returns OBJECT_INVALID if the caller is not a creature, item, placeable or store,\r\n//   or if no item is found.\r\nobject GetFirstItemInInventory(object oTarget = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNextItemInInventory',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        "// 340: Get the next item in oTarget's inventory (continue to cycle through oTarget's\r\n// inventory).\r\n// * Returns OBJECT_INVALID if the caller is not a creature, item, placeable or store,\r\n//   or if no item is found.\r\nobject GetNextItemInInventory(object oTarget = OBJECT_SELF);",
        "// 340: Get the next item in oTarget's inventory (continue to cycle through oTarget's\r\n// inventory).\r\n// * Returns OBJECT_INVALID if the caller is not a creature, item, placeable or store,\r\n//   or if no item is found.\r\nobject GetNextItemInInventory(object oTarget = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetClassByPosition',
        [ScriptParam(DataType.INT, 'nClassPosition', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        "// 341: A creature can have up to three classes.  This function determines the\r\n// creature's class (CLASS_TYPE_*) based on nClassPosition.\r\n// - nClassPosition: 1, 2 or 3\r\n// - oCreature\r\n// * Returns CLASS_TYPE_INVALID if the oCreature does not have a class in\r\n//   nClassPosition (i.e. a single-class creature will only have a value in\r\n//   nClassLocation = 1) or if oCreature is not a valid creature.\r\nint GetClassByPosition(int nClassPosition, object oCreature = OBJECT_SELF);",
        "// 341: A creature can have up to three classes.  This function determines the\r\n// creature's class (CLASS_TYPE_*) based on nClassPosition.\r\n// - nClassPosition: 1, 2 or 3\r\n// - oCreature\r\n// * Returns CLASS_TYPE_INVALID if the oCreature does not have a class in\r\n//   nClassPosition (i.e. a single-class creature will only have a value in\r\n//   nClassLocation = 1) or if oCreature is not a valid creature.\r\nint GetClassByPosition(int nClassPosition, object oCreature = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetLevelByPosition',
        [ScriptParam(DataType.INT, 'nClassPosition', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        "// 342: A creature can have up to three classes.  This function determines the\r\n// creature's class level based on nClass Position.\r\n// - nClassPosition: 1, 2 or 3\r\n// - oCreature\r\n// * Returns 0 if oCreature does not have a class in nClassPosition\r\n//   (i.e. a single-class creature will only have a value in nClassLocation = 1)\r\n//   or if oCreature is not a valid creature.\r\nint GetLevelByPosition(int nClassPosition, object oCreature = OBJECT_SELF);",
        "// 342: A creature can have up to three classes.  This function determines the\r\n// creature's class level based on nClass Position.\r\n// - nClassPosition: 1, 2 or 3\r\n// - oCreature\r\n// * Returns 0 if oCreature does not have a class in nClassPosition\r\n//   (i.e. a single-class creature will only have a value in nClassLocation = 1)\r\n//   or if oCreature is not a valid creature.\r\nint GetLevelByPosition(int nClassPosition, object oCreature = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetLevelByClass',
        [ScriptParam(DataType.INT, 'nClassType', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        '// 343: Determine the levels that oCreature holds in nClassType.\r\n// - nClassType: CLASS_TYPE_*\r\n// - oCreature\r\nint GetLevelByClass(int nClassType, object oCreature = OBJECT_SELF);',
        '// 343: Determine the levels that oCreature holds in nClassType.\r\n// - nClassType: CLASS_TYPE_*\r\n// - oCreature\r\nint GetLevelByClass(int nClassType, object oCreature = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetDamageDealtByType',
        [ScriptParam(DataType.INT, 'nDamageType', None), ],
        '// 344: Get the amount of damage of type nDamageType that has been dealt to the caller.\r\n// - nDamageType: DAMAGE_TYPE_*\r\nint GetDamageDealtByType(int nDamageType);',
        '// 344: Get the amount of damage of type nDamageType that has been dealt to the caller.\r\n// - nDamageType: DAMAGE_TYPE_*\r\nint GetDamageDealtByType(int nDamageType);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTotalDamageDealt',
        [],
        '// 345: Get the total amount of damage that has been dealt to the caller.\r\nint GetTotalDamageDealt();',
        '// 345: Get the total amount of damage that has been dealt to the caller.\r\nint GetTotalDamageDealt();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastDamager',
        [],
        '// 346: Get the last object that damaged the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid object.\r\nobject GetLastDamager();',
        '// 346: Get the last object that damaged the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid object.\r\nobject GetLastDamager();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastDisarmed',
        [],
        '// 347: Get the last object that disarmed the trap on the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid placeable, trigger or\r\n//   door.\r\nobject GetLastDisarmed();',
        '// 347: Get the last object that disarmed the trap on the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid placeable, trigger or\r\n//   door.\r\nobject GetLastDisarmed();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastDisturbed',
        [],
        '// 348: Get the last object that disturbed the inventory of the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature or placeable.\r\nobject GetLastDisturbed();',
        '// 348: Get the last object that disturbed the inventory of the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature or placeable.\r\nobject GetLastDisturbed();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastLocked',
        [],
        '// 349: Get the last object that locked the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid door or placeable.\r\nobject GetLastLocked();',
        '// 349: Get the last object that locked the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid door or placeable.\r\nobject GetLastLocked();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastUnlocked',
        [],
        '// 350: Get the last object that unlocked the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid door or placeable.\r\nobject GetLastUnlocked();',
        '// 350: Get the last object that unlocked the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid door or placeable.\r\nobject GetLastUnlocked();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectSkillIncrease',
        [ScriptParam(DataType.INT, 'nSkill', None), ScriptParam(DataType.INT, 'nValue', None), ],
        '// 351: Create a Skill Increase effect.\r\n// - nSkill: SKILL_*\r\n// - nValue\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nSkill is invalid.\r\neffect EffectSkillIncrease(int nSkill, int nValue);',
        '// 351: Create a Skill Increase effect.\r\n// - nSkill: SKILL_*\r\n// - nValue\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nSkill is invalid.\r\neffect EffectSkillIncrease(int nSkill, int nValue);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetInventoryDisturbType',
        [],
        "// 352: Get the type of disturbance (INVENTORY_DISTURB_*) that caused the caller's\r\n// OnInventoryDisturbed script to fire.  This will only work for creatures and\r\n// placeables.\r\nint GetInventoryDisturbType();",
        "// 352: Get the type of disturbance (INVENTORY_DISTURB_*) that caused the caller's\r\n// OnInventoryDisturbed script to fire.  This will only work for creatures and\r\n// placeables.\r\nint GetInventoryDisturbType();"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetInventoryDisturbItem',
        [],
        "// 353: get the item that caused the caller's OnInventoryDisturbed script to fire.\r\n// * Returns OBJECT_INVALID if the caller is not a valid object.\r\nobject GetInventoryDisturbItem();",
        "// 353: get the item that caused the caller's OnInventoryDisturbed script to fire.\r\n// * Returns OBJECT_INVALID if the caller is not a valid object.\r\nobject GetInventoryDisturbItem();"
    ),
    ScriptFunction(
        DataType.VOID,
        'ShowUpgradeScreen',
        [ScriptParam(DataType.OBJECT, 'oItem', 1), ScriptParam(DataType.OBJECT, 'oCharacter', 1), ScriptParam(DataType.INT, 'nDisableItemCreation', 0), ScriptParam(DataType.INT, 'nDisableUpgrade', 0), ScriptParam(DataType.STRING, 'sOverride2DA', ''), ],
        '// 354: Displays the upgrade screen where the player can modify weapons and armor\r\n// If oItem is NOT invalid, then the player will be forced to upgrade oItem and only oItem.\r\n// If oCharacter is NOT invalid, then that character\'s various skills will be used... *NOT IMPLEMENTED*\r\n// If nDisableItemCreation  =  TRUE, then the player will not be able to access the item creation screen\r\n// If nDisableUpgrade  =  TRUE, then the player will be forced straight to item creation and not be able\r\n//      to access Item Upgrading.\r\nvoid ShowUpgradeScreen(object oItem  =  OBJECT_INVALID, object oCharacter  =  OBJECT_INVALID, int nDisableItemCreation  =  FALSE, int nDisableUpgrade  =  FALSE, string sOverride2DA  =  "");',
        '// 354: Displays the upgrade screen where the player can modify weapons and armor\r\n// If oItem is NOT invalid, then the player will be forced to upgrade oItem and only oItem.\r\n// If oCharacter is NOT invalid, then that character\'s various skills will be used... *NOT IMPLEMENTED*\r\n// If nDisableItemCreation  =  TRUE, then the player will not be able to access the item creation screen\r\n// If nDisableUpgrade  =  TRUE, then the player will be forced straight to item creation and not be able\r\n//      to access Item Upgrading.\r\nvoid ShowUpgradeScreen(object oItem  =  OBJECT_INVALID, object oCharacter  =  OBJECT_INVALID, int nDisableItemCreation  =  FALSE, int nDisableUpgrade  =  FALSE, string sOverride2DA  =  "");'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'VersusAlignmentEffect',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ScriptParam(DataType.INT, 'nLawChaos', 0), ScriptParam(DataType.INT, 'nGoodEvil', 0), ],
        '// 355: Set eEffect to be versus a specific alignment.\r\n// - eEffect\r\n// - nLawChaos: ALIGNMENT_LAWFUL/ALIGNMENT_CHAOTIC/ALIGNMENT_ALL\r\n// - nGoodEvil: ALIGNMENT_GOOD/ALIGNMENT_EVIL/ALIGNMENT_ALL\r\neffect VersusAlignmentEffect(effect eEffect, int nLawChaos = ALIGNMENT_ALL, int nGoodEvil = ALIGNMENT_ALL);',
        '// 355: Set eEffect to be versus a specific alignment.\r\n// - eEffect\r\n// - nLawChaos: ALIGNMENT_LAWFUL/ALIGNMENT_CHAOTIC/ALIGNMENT_ALL\r\n// - nGoodEvil: ALIGNMENT_GOOD/ALIGNMENT_EVIL/ALIGNMENT_ALL\r\neffect VersusAlignmentEffect(effect eEffect, int nLawChaos = ALIGNMENT_ALL, int nGoodEvil = ALIGNMENT_ALL);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'VersusRacialTypeEffect',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ScriptParam(DataType.INT, 'nRacialType', None), ],
        '// 356: Set eEffect to be versus nRacialType.\r\n// - eEffect\r\n// - nRacialType: RACIAL_TYPE_*\r\neffect VersusRacialTypeEffect(effect eEffect, int nRacialType);',
        '// 356: Set eEffect to be versus nRacialType.\r\n// - eEffect\r\n// - nRacialType: RACIAL_TYPE_*\r\neffect VersusRacialTypeEffect(effect eEffect, int nRacialType);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'VersusTrapEffect',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 357: Set eEffect to be versus traps.\r\neffect VersusTrapEffect(effect eEffect);',
        '// 357: Set eEffect to be versus traps.\r\neffect VersusTrapEffect(effect eEffect);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetGender',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 358: Get the gender of oCreature.\r\nint GetGender(object oCreature);',
        '// 358: Get the gender of oCreature.\r\nint GetGender(object oCreature);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsTalentValid',
        [ScriptParam(DataType.TALENT, 'tTalent', None), ],
        '// 359: * Returns TRUE if tTalent is valid.\r\nint GetIsTalentValid(talent tTalent);',
        '// 359: * Returns TRUE if tTalent is valid.\r\nint GetIsTalentValid(talent tTalent);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionMoveAwayFromLocation',
        [ScriptParam(DataType.LOCATION, 'lMoveAwayFrom', None), ScriptParam(DataType.INT, 'bRun', 0), ScriptParam(DataType.FLOAT, 'fMoveAwayRange', 40.0), ],
        '// 360: Causes the action subject to move away from lMoveAwayFrom.\r\nvoid ActionMoveAwayFromLocation(location lMoveAwayFrom, int bRun = FALSE, float fMoveAwayRange = 40.0f);',
        '// 360: Causes the action subject to move away from lMoveAwayFrom.\r\nvoid ActionMoveAwayFromLocation(location lMoveAwayFrom, int bRun = FALSE, float fMoveAwayRange = 40.0f);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetAttemptedAttackTarget',
        [],
        '// 361: Get the target that the caller attempted to attack - this should be used in\r\n// conjunction with GetAttackTarget(). This value is set every time an attack is\r\n// made, and is reset at the end of combat.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetAttemptedAttackTarget();',
        '// 361: Get the target that the caller attempted to attack - this should be used in\r\n// conjunction with GetAttackTarget(). This value is set every time an attack is\r\n// made, and is reset at the end of combat.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetAttemptedAttackTarget();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTypeFromTalent',
        [ScriptParam(DataType.TALENT, 'tTalent', None), ],
        '// 362: Get the type (TALENT_TYPE_*) of tTalent.\r\nint GetTypeFromTalent(talent tTalent);',
        '// 362: Get the type (TALENT_TYPE_*) of tTalent.\r\nint GetTypeFromTalent(talent tTalent);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIdFromTalent',
        [ScriptParam(DataType.TALENT, 'tTalent', None), ],
        '// 363: Get the ID of tTalent.  This could be a SPELL_*, FEAT_* or SKILL_*.\r\nint GetIdFromTalent(talent tTalent);',
        '// 363: Get the ID of tTalent.  This could be a SPELL_*, FEAT_* or SKILL_*.\r\nint GetIdFromTalent(talent tTalent);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PlayPazaak',
        [ScriptParam(DataType.INT, 'nOpponentPazaakDeck', None), ScriptParam(DataType.STRING, 'sEndScript', None), ScriptParam(DataType.INT, 'nMaxWager', None), ScriptParam(DataType.INT, 'bShowTutorial', 0), ScriptParam(DataType.OBJECT, 'oOpponent', 1), ],
        "// 364: Starts a game of pazaak.\r\n// - nOpponentPazaakDeck: Index into PazaakDecks.2da; specifies which deck the opponent will use.\r\n// - sEndScript: Script to be run when game finishes.\r\n// - nMaxWager: Max player wager.  If < =  0, the player's credits won't be modified by the result of the game and the wager screen will not show up.\r\n// - bShowTutorial: Plays in tutorial mode (nMaxWager should be 0).\r\nvoid PlayPazaak(int nOpponentPazaakDeck, string sEndScript, int nMaxWager, int bShowTutorial = FALSE, object oOpponent = OBJECT_INVALID);",
        "// 364: Starts a game of pazaak.\r\n// - nOpponentPazaakDeck: Index into PazaakDecks.2da; specifies which deck the opponent will use.\r\n// - sEndScript: Script to be run when game finishes.\r\n// - nMaxWager: Max player wager.  If < =  0, the player's credits won't be modified by the result of the game and the wager screen will not show up.\r\n// - bShowTutorial: Plays in tutorial mode (nMaxWager should be 0).\r\nvoid PlayPazaak(int nOpponentPazaakDeck, string sEndScript, int nMaxWager, int bShowTutorial = FALSE, object oOpponent = OBJECT_INVALID);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastPazaakResult',
        [],
        '// 365: Returns result of last Pazaak game.  Should be used only in an EndScript sent to PlayPazaak.\r\n// * Returns 0 if player loses, 1 if player wins.\r\nint GetLastPazaakResult();',
        '// 365: Returns result of last Pazaak game.  Should be used only in an EndScript sent to PlayPazaak.\r\n// * Returns 0 if player loses, 1 if player wins.\r\nint GetLastPazaakResult();'
    ),
    ScriptFunction(
        DataType.VOID,
        'DisplayFeedBackText',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nTextConstant', None), ],
        '// 366:  displays a feed back string for the object spicified and the constant\r\n// repersents the string to be displayed see:FeedBackText.2da\r\nvoid DisplayFeedBackText(object oCreature, int nTextConstant);',
        '// 366:  displays a feed back string for the object spicified and the constant\r\n// repersents the string to be displayed see:FeedBackText.2da\r\nvoid DisplayFeedBackText(object oCreature, int nTextConstant);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AddJournalQuestEntry',
        [ScriptParam(DataType.STRING, 'szPlotID', None), ScriptParam(DataType.INT, 'nState', None), ScriptParam(DataType.INT, 'bAllowOverrideHigher', 0), ],
        "// 367: Add a journal quest entry to the player.\r\n// - szPlotID: the plot identifier used in the toolset's Journal Editor\r\n// - nState: the state of the plot as seen in the toolset's Journal Editor\r\n// - bAllowOverrideHigher: If this is TRUE, you can set the state to a lower\r\n//   number than the one it is currently on\r\nvoid AddJournalQuestEntry(string szPlotID, int nState, int bAllowOverrideHigher = FALSE);",
        "// 367: Add a journal quest entry to the player.\r\n// - szPlotID: the plot identifier used in the toolset's Journal Editor\r\n// - nState: the state of the plot as seen in the toolset's Journal Editor\r\n// - bAllowOverrideHigher: If this is TRUE, you can set the state to a lower\r\n//   number than the one it is currently on\r\nvoid AddJournalQuestEntry(string szPlotID, int nState, int bAllowOverrideHigher = FALSE);"
    ),
    ScriptFunction(
        DataType.VOID,
        'RemoveJournalQuestEntry',
        [ScriptParam(DataType.STRING, 'szPlotID', None), ],
        "// 368: Remove a journal quest entry from the player.\r\n// - szPlotID: the plot identifier used in the toolset's Journal Editor\r\nvoid RemoveJournalQuestEntry(string szPlotID);",
        "// 368: Remove a journal quest entry from the player.\r\n// - szPlotID: the plot identifier used in the toolset's Journal Editor\r\nvoid RemoveJournalQuestEntry(string szPlotID);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetJournalEntry',
        [ScriptParam(DataType.STRING, 'szPlotID', None), ],
        "// 369: Gets the State value of a journal quest.  Returns 0 if no quest entry has been added for this szPlotID.\r\n// - szPlotID: the plot identifier used in the toolset's Journal Editor\r\nint GetJournalEntry(string szPlotID);",
        "// 369: Gets the State value of a journal quest.  Returns 0 if no quest entry has been added for this szPlotID.\r\n// - szPlotID: the plot identifier used in the toolset's Journal Editor\r\nint GetJournalEntry(string szPlotID);"
    ),
    ScriptFunction(
        DataType.INT,
        'PlayRumblePattern',
        [ScriptParam(DataType.INT, 'nPattern', None), ],
        '// 370: PlayRumblePattern\r\n// Starts a defined rumble pattern playing\r\nint PlayRumblePattern(int nPattern);',
        '// 370: PlayRumblePattern\r\n// Starts a defined rumble pattern playing\r\nint PlayRumblePattern(int nPattern);'
    ),
    ScriptFunction(
        DataType.INT,
        'StopRumblePattern',
        [ScriptParam(DataType.INT, 'nPattern', None), ],
        '// 371: StopRumblePattern\r\n// Stops a defined rumble pattern\r\nint StopRumblePattern(int nPattern);',
        '// 371: StopRumblePattern\r\n// Stops a defined rumble pattern\r\nint StopRumblePattern(int nPattern);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDamageForcePoints',
        [ScriptParam(DataType.INT, 'nDamage', None), ],
        '// 372: Damages the creatures force points\r\neffect EffectDamageForcePoints(int nDamage);',
        '// 372: Damages the creatures force points\r\neffect EffectDamageForcePoints(int nDamage);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectHealForcePoints',
        [ScriptParam(DataType.INT, 'nHeal', None), ],
        '// 373: Heals the creatures force points\r\neffect EffectHealForcePoints(int nHeal);',
        '// 373: Heals the creatures force points\r\neffect EffectHealForcePoints(int nHeal);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SendMessageToPC',
        [ScriptParam(DataType.OBJECT, 'oPlayer', None), ScriptParam(DataType.STRING, 'szMessage', None), ],
        '// 374: Send a server message (szMessage) to the oPlayer.\r\nvoid SendMessageToPC(object oPlayer, string szMessage);',
        '// 374: Send a server message (szMessage) to the oPlayer.\r\nvoid SendMessageToPC(object oPlayer, string szMessage);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetAttemptedSpellTarget',
        [],
        '// 375: Get the target at which the caller attempted to cast a spell.\r\n// This value is set every time a spell is cast and is reset at the end of\r\n// combat.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetAttemptedSpellTarget();',
        '// 375: Get the target at which the caller attempted to cast a spell.\r\n// This value is set every time a spell is cast and is reset at the end of\r\n// combat.\r\n// * Returns OBJECT_INVALID if the caller is not a valid creature.\r\nobject GetAttemptedSpellTarget();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastOpenedBy',
        [],
        '// 376: Get the last creature that opened the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid door or placeable.\r\nobject GetLastOpenedBy();',
        '// 376: Get the last creature that opened the caller.\r\n// * Returns OBJECT_INVALID if the caller is not a valid door or placeable.\r\nobject GetLastOpenedBy();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetHasSpell',
        [ScriptParam(DataType.INT, 'nSpell', None), ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        "// 377: Determine whether oCreature has nSpell memorised.\r\n// PLEASE NOTE!!! - This function will return FALSE if the target\r\n// is not currently able to use the spell due to lack of sufficient\r\n// Force Points. Use GetSpellAcquired() if you just want to\r\n// know if they've got it or not.\r\n// - nSpell: SPELL_*\r\n// - oCreature\r\nint GetHasSpell(int nSpell, object oCreature = OBJECT_SELF);",
        "// 377: Determine whether oCreature has nSpell memorised.\r\n// PLEASE NOTE!!! - This function will return FALSE if the target\r\n// is not currently able to use the spell due to lack of sufficient\r\n// Force Points. Use GetSpellAcquired() if you just want to\r\n// know if they've got it or not.\r\n// - nSpell: SPELL_*\r\n// - oCreature\r\nint GetHasSpell(int nSpell, object oCreature = OBJECT_SELF);"
    ),
    ScriptFunction(
        DataType.VOID,
        'OpenStore',
        [ScriptParam(DataType.OBJECT, 'oStore', None), ScriptParam(DataType.OBJECT, 'oPC', None), ScriptParam(DataType.INT, 'nBonusMarkUp', 0), ScriptParam(DataType.INT, 'nBonusMarkDown', 0), ],
        '// 378: Open oStore for oPC.\r\nvoid OpenStore(object oStore, object oPC, int nBonusMarkUp = 0, int nBonusMarkDown = 0);',
        '// 378: Open oStore for oPC.\r\nvoid OpenStore(object oStore, object oPC, int nBonusMarkUp = 0, int nBonusMarkDown = 0);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionSurrenderToEnemies',
        [],
        '// 379:\r\nvoid ActionSurrenderToEnemies();',
        '// 379:\r\nvoid ActionSurrenderToEnemies();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFirstFactionMember',
        [ScriptParam(DataType.OBJECT, 'oMemberOfFaction', None), ScriptParam(DataType.INT, 'bPCOnly', 1), ],
        "// 380: Get the first member of oMemberOfFaction's faction (start to cycle through\r\n// oMemberOfFaction's faction).\r\n// * Returns OBJECT_INVALID if oMemberOfFaction's faction is invalid.\r\nobject GetFirstFactionMember(object oMemberOfFaction, int bPCOnly = TRUE);",
        "// 380: Get the first member of oMemberOfFaction's faction (start to cycle through\r\n// oMemberOfFaction's faction).\r\n// * Returns OBJECT_INVALID if oMemberOfFaction's faction is invalid.\r\nobject GetFirstFactionMember(object oMemberOfFaction, int bPCOnly = TRUE);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNextFactionMember',
        [ScriptParam(DataType.OBJECT, 'oMemberOfFaction', None), ScriptParam(DataType.INT, 'bPCOnly', 1), ],
        "// 381: Get the next member of oMemberOfFaction's faction (continue to cycle through\r\n// oMemberOfFaction's faction).\r\n// * Returns OBJECT_INVALID if oMemberOfFaction's faction is invalid.\r\nobject GetNextFactionMember(object oMemberOfFaction, int bPCOnly = TRUE);",
        "// 381: Get the next member of oMemberOfFaction's faction (continue to cycle through\r\n// oMemberOfFaction's faction).\r\n// * Returns OBJECT_INVALID if oMemberOfFaction's faction is invalid.\r\nobject GetNextFactionMember(object oMemberOfFaction, int bPCOnly = TRUE);"
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionForceMoveToLocation',
        [ScriptParam(DataType.LOCATION, 'lDestination', None), ScriptParam(DataType.INT, 'bRun', 0), ScriptParam(DataType.FLOAT, 'fTimeout', 30.0), ],
        '// 382: Force the action subject to move to lDestination.\r\nvoid ActionForceMoveToLocation(location lDestination, int bRun = FALSE, float fTimeout = 30.0f);',
        '// 382: Force the action subject to move to lDestination.\r\nvoid ActionForceMoveToLocation(location lDestination, int bRun = FALSE, float fTimeout = 30.0f);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionForceMoveToObject',
        [ScriptParam(DataType.OBJECT, 'oMoveTo', None), ScriptParam(DataType.INT, 'bRun', 0), ScriptParam(DataType.FLOAT, 'fRange', 1.0), ScriptParam(DataType.FLOAT, 'fTimeout', 30.0), ],
        '// 383: Force the action subject to move to oMoveTo.\r\nvoid ActionForceMoveToObject(object oMoveTo, int bRun = FALSE, float fRange = 1.0f, float fTimeout = 30.0f);',
        '// 383: Force the action subject to move to oMoveTo.\r\nvoid ActionForceMoveToObject(object oMoveTo, int bRun = FALSE, float fRange = 1.0f, float fTimeout = 30.0f);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetJournalQuestExperience',
        [ScriptParam(DataType.STRING, 'szPlotID', None), ],
        '// 384: Get the experience assigned in the journal editor for szPlotID.\r\nint GetJournalQuestExperience(string szPlotID);',
        '// 384: Get the experience assigned in the journal editor for szPlotID.\r\nint GetJournalQuestExperience(string szPlotID);'
    ),
    ScriptFunction(
        DataType.VOID,
        'JumpToObject',
        [ScriptParam(DataType.OBJECT, 'oToJumpTo', None), ScriptParam(DataType.INT, 'nWalkStraightLineToPoint', 1), ],
        '// 385: Jump to oToJumpTo (the action is added to the top of the action queue).\r\nvoid JumpToObject(object oToJumpTo, int nWalkStraightLineToPoint = 1);',
        '// 385: Jump to oToJumpTo (the action is added to the top of the action queue).\r\nvoid JumpToObject(object oToJumpTo, int nWalkStraightLineToPoint = 1);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetMapPinEnabled',
        [ScriptParam(DataType.OBJECT, 'oMapPin', None), ScriptParam(DataType.INT, 'nEnabled', None), ],
        '// 386: Set whether oMapPin is enabled.\r\n// - oMapPin\r\n// - nEnabled: 0 = Off, 1 = On\r\nvoid SetMapPinEnabled(object oMapPin, int nEnabled);',
        '// 386: Set whether oMapPin is enabled.\r\n// - oMapPin\r\n// - nEnabled: 0 = Off, 1 = On\r\nvoid SetMapPinEnabled(object oMapPin, int nEnabled);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectHitPointChangeWhenDying',
        [ScriptParam(DataType.FLOAT, 'fHitPointChangePerRound', None), ],
        '// 387: Create a Hit Point Change When Dying effect.\r\n// - fHitPointChangePerRound: this can be positive or negative, but not zero.\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if fHitPointChangePerRound is 0.\r\neffect EffectHitPointChangeWhenDying(float fHitPointChangePerRound);',
        '// 387: Create a Hit Point Change When Dying effect.\r\n// - fHitPointChangePerRound: this can be positive or negative, but not zero.\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if fHitPointChangePerRound is 0.\r\neffect EffectHitPointChangeWhenDying(float fHitPointChangePerRound);'
    ),
    ScriptFunction(
        DataType.VOID,
        'PopUpGUIPanel',
        [ScriptParam(DataType.OBJECT, 'oPC', None), ScriptParam(DataType.INT, 'nGUIPanel', None), ],
        '// 388: Spawn a GUI panel for the client that controls oPC.\r\n// - oPC\r\n// - nGUIPanel: GUI_PANEL_*\r\n// * Nothing happens if oPC is not a player character or if an invalid value is\r\n//   used for nGUIPanel.\r\nvoid PopUpGUIPanel(object oPC, int nGUIPanel);',
        '// 388: Spawn a GUI panel for the client that controls oPC.\r\n// - oPC\r\n// - nGUIPanel: GUI_PANEL_*\r\n// * Nothing happens if oPC is not a player character or if an invalid value is\r\n//   used for nGUIPanel.\r\nvoid PopUpGUIPanel(object oPC, int nGUIPanel);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AddMultiClass',
        [ScriptParam(DataType.INT, 'nClassType', None), ScriptParam(DataType.OBJECT, 'oSource', None), ],
        '// 389: This allows you to add a new class to any creature object\r\nvoid AddMultiClass(int nClassType, object oSource);',
        '// 389: This allows you to add a new class to any creature object\r\nvoid AddMultiClass(int nClassType, object oSource);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsLinkImmune',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.EFFECT, 'eEffect', None), ],
        '// 390: Tests a linked effect to see if the target is immune to it.\r\n// If the target is imune to any of the linked effect then he is immune to all of it\r\nint GetIsLinkImmune(object oTarget, effect eEffect );',
        '// 390: Tests a linked effect to see if the target is immune to it.\r\n// If the target is imune to any of the linked effect then he is immune to all of it\r\nint GetIsLinkImmune(object oTarget, effect eEffect );'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDroidStun',
        [],
        '// 391: Stunn the droid\r\neffect EffectDroidStun( );',
        '// 391: Stunn the droid\r\neffect EffectDroidStun( );'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectForcePushed',
        [],
        '// 392: Force push the creature...\r\neffect EffectForcePushed();',
        '// 392: Force push the creature...\r\neffect EffectForcePushed();'
    ),
    ScriptFunction(
        DataType.VOID,
        'GiveXPToCreature',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nXpAmount', None), ],
        '// 393: Gives nXpAmount to oCreature.\r\nvoid GiveXPToCreature(object oCreature, int nXpAmount);',
        '// 393: Gives nXpAmount to oCreature.\r\nvoid GiveXPToCreature(object oCreature, int nXpAmount);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetXP',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'nXpAmount', None), ],
        "// 394: Sets oCreature's experience to nXpAmount.\r\nvoid SetXP(object oCreature, int nXpAmount);",
        "// 394: Sets oCreature's experience to nXpAmount.\r\nvoid SetXP(object oCreature, int nXpAmount);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetXP',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        "// 395: Get oCreature's experience.\r\nint GetXP(object oCreature);",
        "// 395: Get oCreature's experience.\r\nint GetXP(object oCreature);"
    ),
    ScriptFunction(
        DataType.STRING,
        'IntToHexString',
        [ScriptParam(DataType.INT, 'nInteger', None), ],
        '// 396: Convert nInteger to hex, returning the hex value as a string.\r\n// * Return value has the format "0x????????" where each ? will be a hex digit\r\n//   (8 digits in total).\r\nstring IntToHexString(int nInteger);',
        '// 396: Convert nInteger to hex, returning the hex value as a string.\r\n// * Return value has the format "0x????????" where each ? will be a hex digit\r\n//   (8 digits in total).\r\nstring IntToHexString(int nInteger);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetBaseItemType',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 397: Get the base item type (BASE_ITEM_*) of oItem.\r\n// * Returns BASE_ITEM_INVALID if oItem is an invalid item.\r\nint GetBaseItemType(object oItem);',
        '// 397: Get the base item type (BASE_ITEM_*) of oItem.\r\n// * Returns BASE_ITEM_INVALID if oItem is an invalid item.\r\nint GetBaseItemType(object oItem);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetItemHasItemProperty',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.INT, 'nProperty', None), ],
        '// 398: Determines whether oItem has nProperty.\r\n// - oItem\r\n// - nProperty: ITEM_PROPERTY_*\r\n// * Returns FALSE if oItem is not a valid item, or if oItem does not have\r\n//   nProperty.\r\nint GetItemHasItemProperty(object oItem, int nProperty);',
        '// 398: Determines whether oItem has nProperty.\r\n// - oItem\r\n// - nProperty: ITEM_PROPERTY_*\r\n// * Returns FALSE if oItem is not a valid item, or if oItem does not have\r\n//   nProperty.\r\nint GetItemHasItemProperty(object oItem, int nProperty);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionEquipMostDamagingMelee',
        [ScriptParam(DataType.OBJECT, 'oVersus', 1), ScriptParam(DataType.INT, 'bOffHand', 0), ],
        '// 399: The creature will equip the melee weapon in its possession that can do the\r\n// most damage. If no valid melee weapon is found, it will equip the most\r\n// damaging range weapon. This function should only ever be called in the\r\n// EndOfCombatRound scripts, because otherwise it would have to stop the combat\r\n// round to run simulation.\r\n// - oVersus: You can try to get the most damaging weapon against oVersus\r\n// - bOffHand\r\nvoid ActionEquipMostDamagingMelee(object oVersus = OBJECT_INVALID, int bOffHand = FALSE);',
        '// 399: The creature will equip the melee weapon in its possession that can do the\r\n// most damage. If no valid melee weapon is found, it will equip the most\r\n// damaging range weapon. This function should only ever be called in the\r\n// EndOfCombatRound scripts, because otherwise it would have to stop the combat\r\n// round to run simulation.\r\n// - oVersus: You can try to get the most damaging weapon against oVersus\r\n// - bOffHand\r\nvoid ActionEquipMostDamagingMelee(object oVersus = OBJECT_INVALID, int bOffHand = FALSE);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionEquipMostDamagingRanged',
        [ScriptParam(DataType.OBJECT, 'oVersus', 1), ],
        '// 400: The creature will equip the range weapon in its possession that can do the\r\n// most damage.\r\n// If no valid range weapon can be found, it will equip the most damaging melee\r\n// weapon.\r\n// - oVersus: You can try to get the most damaging weapon against oVersus\r\nvoid ActionEquipMostDamagingRanged(object oVersus = OBJECT_INVALID);',
        '// 400: The creature will equip the range weapon in its possession that can do the\r\n// most damage.\r\n// If no valid range weapon can be found, it will equip the most damaging melee\r\n// weapon.\r\n// - oVersus: You can try to get the most damaging weapon against oVersus\r\nvoid ActionEquipMostDamagingRanged(object oVersus = OBJECT_INVALID);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetItemACValue',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 401: Get the Armour Class of oItem.\r\n// * Return 0 if the oItem is not a valid item, or if oItem has no armour value.\r\nint GetItemACValue(object oItem);',
        '// 401: Get the Armour Class of oItem.\r\n// * Return 0 if the oItem is not a valid item, or if oItem has no armour value.\r\nint GetItemACValue(object oItem);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectForceResisted',
        [ScriptParam(DataType.OBJECT, 'oSource', None), ],
        '// 402:\r\n// Effect that will play an animation and display a visual effect to indicate the\r\n// target has resisted a force power.\r\neffect EffectForceResisted( object oSource );',
        '// 402:\r\n// Effect that will play an animation and display a visual effect to indicate the\r\n// target has resisted a force power.\r\neffect EffectForceResisted( object oSource );'
    ),
    ScriptFunction(
        DataType.VOID,
        'ExploreAreaForPlayer',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.OBJECT, 'oPlayer', None), ],
        '// 403: Expose the entire map of oArea to oPlayer.\r\nvoid ExploreAreaForPlayer(object oArea, object oPlayer);',
        '// 403: Expose the entire map of oArea to oPlayer.\r\nvoid ExploreAreaForPlayer(object oArea, object oPlayer);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionEquipMostEffectiveArmor',
        [],
        '// 404: The creature will equip the armour in its possession that has the highest\r\n// armour class.\r\nvoid ActionEquipMostEffectiveArmor();',
        '// 404: The creature will equip the armour in its possession that has the highest\r\n// armour class.\r\nvoid ActionEquipMostEffectiveArmor();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsDay',
        [],
        '// 405: * Returns TRUE if it is currently day.\r\nint GetIsDay();',
        '// 405: * Returns TRUE if it is currently day.\r\nint GetIsDay();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsNight',
        [],
        '// 406: * Returns TRUE if it is currently night.\r\nint GetIsNight();',
        '// 406: * Returns TRUE if it is currently night.\r\nint GetIsNight();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsDawn',
        [],
        '// 407: * Returns TRUE if it is currently dawn.\r\nint GetIsDawn();',
        '// 407: * Returns TRUE if it is currently dawn.\r\nint GetIsDawn();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsDusk',
        [],
        '// 408: * Returns TRUE if it is currently dusk.\r\nint GetIsDusk();',
        '// 408: * Returns TRUE if it is currently dusk.\r\nint GetIsDusk();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsEncounterCreature',
        [ScriptParam(DataType.OBJECT, 'oCreature', 0), ],
        '// 409: * Returns TRUE if oCreature was spawned from an encounter.\r\nint GetIsEncounterCreature(object oCreature = OBJECT_SELF);',
        '// 409: * Returns TRUE if oCreature was spawned from an encounter.\r\nint GetIsEncounterCreature(object oCreature = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastPlayerDying',
        [],
        '// 410: Use this in an OnPlayerDying module script to get the last player who is dying.\r\nobject GetLastPlayerDying();',
        '// 410: Use this in an OnPlayerDying module script to get the last player who is dying.\r\nobject GetLastPlayerDying();'
    ),
    ScriptFunction(
        DataType.LOCATION,
        'GetStartingLocation',
        [],
        '// 411: Get the starting location of the module.\r\nlocation GetStartingLocation();',
        '// 411: Get the starting location of the module.\r\nlocation GetStartingLocation();'
    ),
    ScriptFunction(
        DataType.VOID,
        'ChangeToStandardFaction',
        [ScriptParam(DataType.OBJECT, 'oCreatureToChange', None), ScriptParam(DataType.INT, 'nStandardFaction', None), ],
        '// 412: Make oCreatureToChange join one of the standard factions.\r\n// ** This will only work on an NPC **\r\n// - nStandardFaction: STANDARD_FACTION_*\r\nvoid ChangeToStandardFaction(object oCreatureToChange, int nStandardFaction);',
        '// 412: Make oCreatureToChange join one of the standard factions.\r\n// ** This will only work on an NPC **\r\n// - nStandardFaction: STANDARD_FACTION_*\r\nvoid ChangeToStandardFaction(object oCreatureToChange, int nStandardFaction);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SoundObjectPlay',
        [ScriptParam(DataType.OBJECT, 'oSound', None), ],
        '// 413: Play oSound.\r\nvoid SoundObjectPlay(object oSound);',
        '// 413: Play oSound.\r\nvoid SoundObjectPlay(object oSound);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SoundObjectStop',
        [ScriptParam(DataType.OBJECT, 'oSound', None), ],
        '// 414: Stop playing oSound.\r\nvoid SoundObjectStop(object oSound);',
        '// 414: Stop playing oSound.\r\nvoid SoundObjectStop(object oSound);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SoundObjectSetVolume',
        [ScriptParam(DataType.OBJECT, 'oSound', None), ScriptParam(DataType.INT, 'nVolume', None), ],
        '// 415: Set the volume of oSound.\r\n// - oSound\r\n// - nVolume: 0-127\r\nvoid SoundObjectSetVolume(object oSound, int nVolume);',
        '// 415: Set the volume of oSound.\r\n// - oSound\r\n// - nVolume: 0-127\r\nvoid SoundObjectSetVolume(object oSound, int nVolume);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SoundObjectSetPosition',
        [ScriptParam(DataType.OBJECT, 'oSound', None), ScriptParam(DataType.VECTOR, 'vPosition', None), ],
        '// 416: Set the position of oSound.\r\nvoid SoundObjectSetPosition(object oSound, vector vPosition);',
        '// 416: Set the position of oSound.\r\nvoid SoundObjectSetPosition(object oSound, vector vPosition);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SpeakOneLinerConversation',
        [ScriptParam(DataType.STRING, 'sDialogResRef', ''), ScriptParam(DataType.OBJECT, 'oTokenTarget', 32767), ],
        '// 417: Immediately speak a conversation one-liner.\r\n// - sDialogResRef\r\n// - oTokenTarget: This must be specified if there are creature-specific tokens\r\n//   in the string.\r\nvoid SpeakOneLinerConversation(string sDialogResRef = "", object oTokenTarget = OBJECT_TYPE_INVALID);',
        '// 417: Immediately speak a conversation one-liner.\r\n// - sDialogResRef\r\n// - oTokenTarget: This must be specified if there are creature-specific tokens\r\n//   in the string.\r\nvoid SpeakOneLinerConversation(string sDialogResRef = "", object oTokenTarget = OBJECT_TYPE_INVALID);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetGold',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        '// 418: Get the amount of gold possessed by oTarget.\r\nint GetGold(object oTarget = OBJECT_SELF);',
        '// 418: Get the amount of gold possessed by oTarget.\r\nint GetGold(object oTarget = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastRespawnButtonPresser',
        [],
        '// 419: Use this in an OnRespawnButtonPressed module script to get the object id of\r\n// the player who last pressed the respawn button.\r\nobject GetLastRespawnButtonPresser();',
        '// 419: Use this in an OnRespawnButtonPressed module script to get the object id of\r\n// the player who last pressed the respawn button.\r\nobject GetLastRespawnButtonPresser();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectForceFizzle',
        [],
        "// 420:\r\n// Effect that will display a visual effect on the specified object's hand to\r\n// indicate a force power has fizzled out.\r\neffect EffectForceFizzle();",
        "// 420:\r\n// Effect that will display a visual effect on the specified object's hand to\r\n// indicate a force power has fizzled out.\r\neffect EffectForceFizzle();"
    ),
    ScriptFunction(
        DataType.VOID,
        'SetLightsaberPowered',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ScriptParam(DataType.INT, 'bOverride', None), ScriptParam(DataType.INT, 'bPowered', 1), ScriptParam(DataType.INT, 'bShowTransition', 0), ],
        '// 421: SetLightsaberPowered\r\n// Allows a script to set the state of the lightsaber.  This will override any\r\n// game determined lightsaber powerstates.\r\nvoid SetLightsaberPowered( object oCreature, int bOverride, int bPowered  =  TRUE, int bShowTransition  =  FALSE);',
        '// 421: SetLightsaberPowered\r\n// Allows a script to set the state of the lightsaber.  This will override any\r\n// game determined lightsaber powerstates.\r\nvoid SetLightsaberPowered( object oCreature, int bOverride, int bPowered  =  TRUE, int bShowTransition  =  FALSE);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsWeaponEffective',
        [ScriptParam(DataType.OBJECT, 'oVersus', 1), ScriptParam(DataType.INT, 'bOffHand', 0), ],
        '// 422: * Returns TRUE if the weapon equipped is capable of damaging oVersus.\r\nint GetIsWeaponEffective(object oVersus = OBJECT_INVALID, int bOffHand = FALSE);',
        '// 422: * Returns TRUE if the weapon equipped is capable of damaging oVersus.\r\nint GetIsWeaponEffective(object oVersus = OBJECT_INVALID, int bOffHand = FALSE);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLastSpellHarmful',
        [],
        '// 423: Use this in a SpellCast script to determine whether the spell was considered\r\n// harmful.\r\n// * Returns TRUE if the last spell cast was harmful.\r\nint GetLastSpellHarmful();',
        '// 423: Use this in a SpellCast script to determine whether the spell was considered\r\n// harmful.\r\n// * Returns TRUE if the last spell cast was harmful.\r\nint GetLastSpellHarmful();'
    ),
    ScriptFunction(
        DataType.EVENT,
        'EventActivateItem',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ScriptParam(DataType.LOCATION, 'lTarget', None), ScriptParam(DataType.OBJECT, 'oTarget', 1), ],
        '// 424: Activate oItem.\r\nevent EventActivateItem(object oItem, location lTarget, object oTarget = OBJECT_INVALID);',
        '// 424: Activate oItem.\r\nevent EventActivateItem(object oItem, location lTarget, object oTarget = OBJECT_INVALID);'
    ),
    ScriptFunction(
        DataType.VOID,
        'MusicBackgroundPlay',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ],
        '// 425: Play the background music for oArea.\r\nvoid MusicBackgroundPlay(object oArea);',
        '// 425: Play the background music for oArea.\r\nvoid MusicBackgroundPlay(object oArea);'
    ),
    ScriptFunction(
        DataType.VOID,
        'MusicBackgroundStop',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ],
        '// 426: Stop the background music for oArea.\r\nvoid MusicBackgroundStop(object oArea);',
        '// 426: Stop the background music for oArea.\r\nvoid MusicBackgroundStop(object oArea);'
    ),
    ScriptFunction(
        DataType.VOID,
        'MusicBackgroundSetDelay',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.INT, 'nDelay', None), ],
        '// 427: Set the delay for the background music for oArea.\r\n// - oArea\r\n// - nDelay: delay in milliseconds\r\nvoid MusicBackgroundSetDelay(object oArea, int nDelay);',
        '// 427: Set the delay for the background music for oArea.\r\n// - oArea\r\n// - nDelay: delay in milliseconds\r\nvoid MusicBackgroundSetDelay(object oArea, int nDelay);'
    ),
    ScriptFunction(
        DataType.VOID,
        'MusicBackgroundChangeDay',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.INT, 'nTrack', None), ScriptParam(DataType.INT, 'nStreamingMusic', 0), ],
        '// 428: Change the background day track for oArea to nTrack.\r\n// - oArea\r\n// - nTrack\r\nvoid MusicBackgroundChangeDay(object oArea, int nTrack, int nStreamingMusic  =  FALSE);',
        '// 428: Change the background day track for oArea to nTrack.\r\n// - oArea\r\n// - nTrack\r\nvoid MusicBackgroundChangeDay(object oArea, int nTrack, int nStreamingMusic  =  FALSE);'
    ),
    ScriptFunction(
        DataType.VOID,
        'MusicBackgroundChangeNight',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.INT, 'nTrack', None), ScriptParam(DataType.INT, 'nStreamingMusic', 0), ],
        '// 429: Change the background night track for oArea to nTrack.\r\n// - oArea\r\n// - nTrack\r\nvoid MusicBackgroundChangeNight(object oArea, int nTrack, int nStreamingMusic  =  FALSE);',
        '// 429: Change the background night track for oArea to nTrack.\r\n// - oArea\r\n// - nTrack\r\nvoid MusicBackgroundChangeNight(object oArea, int nTrack, int nStreamingMusic  =  FALSE);'
    ),
    ScriptFunction(
        DataType.VOID,
        'MusicBattlePlay',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ],
        '// 430: Play the battle music for oArea.\r\nvoid MusicBattlePlay(object oArea);',
        '// 430: Play the battle music for oArea.\r\nvoid MusicBattlePlay(object oArea);'
    ),
    ScriptFunction(
        DataType.VOID,
        'MusicBattleStop',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ],
        '// 431: Stop the battle music for oArea.\r\nvoid MusicBattleStop(object oArea);',
        '// 431: Stop the battle music for oArea.\r\nvoid MusicBattleStop(object oArea);'
    ),
    ScriptFunction(
        DataType.VOID,
        'MusicBattleChange',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.INT, 'nTrack', None), ],
        '// 432: Change the battle track for oArea.\r\n// - oArea\r\n// - nTrack\r\nvoid MusicBattleChange(object oArea, int nTrack);',
        '// 432: Change the battle track for oArea.\r\n// - oArea\r\n// - nTrack\r\nvoid MusicBattleChange(object oArea, int nTrack);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AmbientSoundPlay',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ],
        '// 433: Play the ambient sound for oArea.\r\nvoid AmbientSoundPlay(object oArea);',
        '// 433: Play the ambient sound for oArea.\r\nvoid AmbientSoundPlay(object oArea);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AmbientSoundStop',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ],
        '// 434: Stop the ambient sound for oArea.\r\nvoid AmbientSoundStop(object oArea);',
        '// 434: Stop the ambient sound for oArea.\r\nvoid AmbientSoundStop(object oArea);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AmbientSoundChangeDay',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.INT, 'nTrack', None), ],
        '// 435: Change the ambient day track for oArea to nTrack.\r\n// - oArea\r\n// - nTrack\r\nvoid AmbientSoundChangeDay(object oArea, int nTrack);',
        '// 435: Change the ambient day track for oArea to nTrack.\r\n// - oArea\r\n// - nTrack\r\nvoid AmbientSoundChangeDay(object oArea, int nTrack);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AmbientSoundChangeNight',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.INT, 'nTrack', None), ],
        '// 436: Change the ambient night track for oArea to nTrack.\r\n// - oArea\r\n// - nTrack\r\nvoid AmbientSoundChangeNight(object oArea, int nTrack);',
        '// 436: Change the ambient night track for oArea to nTrack.\r\n// - oArea\r\n// - nTrack\r\nvoid AmbientSoundChangeNight(object oArea, int nTrack);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastKiller',
        [],
        '// 437: Get the object that killed the caller.\r\nobject GetLastKiller();',
        '// 437: Get the object that killed the caller.\r\nobject GetLastKiller();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetSpellCastItem',
        [],
        '// 438: Use this in a spell script to get the item used to cast the spell.\r\nobject GetSpellCastItem();',
        '// 438: Use this in a spell script to get the item used to cast the spell.\r\nobject GetSpellCastItem();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetItemActivated',
        [],
        '// 439: Use this in an OnItemActivated module script to get the item that was activated.\r\nobject GetItemActivated();',
        '// 439: Use this in an OnItemActivated module script to get the item that was activated.\r\nobject GetItemActivated();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetItemActivator',
        [],
        '// 440: Use this in an OnItemActivated module script to get the creature that\r\n// activated the item.\r\nobject GetItemActivator();',
        '// 440: Use this in an OnItemActivated module script to get the creature that\r\n// activated the item.\r\nobject GetItemActivator();'
    ),
    ScriptFunction(
        DataType.LOCATION,
        'GetItemActivatedTargetLocation',
        [],
        "// 441: Use this in an OnItemActivated module script to get the location of the item's\r\n// target.\r\nlocation GetItemActivatedTargetLocation();",
        "// 441: Use this in an OnItemActivated module script to get the location of the item's\r\n// target.\r\nlocation GetItemActivatedTargetLocation();"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetItemActivatedTarget',
        [],
        "// 442: Use this in an OnItemActivated module script to get the item's target.\r\nobject GetItemActivatedTarget();",
        "// 442: Use this in an OnItemActivated module script to get the item's target.\r\nobject GetItemActivatedTarget();"
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsOpen',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 443: * Returns TRUE if oObject (which is a placeable or a door) is currently open.\r\nint GetIsOpen(object oObject);',
        '// 443: * Returns TRUE if oObject (which is a placeable or a door) is currently open.\r\nint GetIsOpen(object oObject);'
    ),
    ScriptFunction(
        DataType.VOID,
        'TakeGoldFromCreature',
        [ScriptParam(DataType.INT, 'nAmount', None), ScriptParam(DataType.OBJECT, 'oCreatureToTakeFrom', None), ScriptParam(DataType.INT, 'bDestroy', 0), ],
        '// 444: Take nAmount of gold from oCreatureToTakeFrom.\r\n// - nAmount\r\n// - oCreatureToTakeFrom: If this is not a valid creature, nothing will happen.\r\n// - bDestroy: If this is TRUE, the caller will not get the gold.  Instead, the\r\n//   gold will be destroyed and will vanish from the game.\r\nvoid TakeGoldFromCreature(int nAmount, object oCreatureToTakeFrom, int bDestroy = FALSE);',
        '// 444: Take nAmount of gold from oCreatureToTakeFrom.\r\n// - nAmount\r\n// - oCreatureToTakeFrom: If this is not a valid creature, nothing will happen.\r\n// - bDestroy: If this is TRUE, the caller will not get the gold.  Instead, the\r\n//   gold will be destroyed and will vanish from the game.\r\nvoid TakeGoldFromCreature(int nAmount, object oCreatureToTakeFrom, int bDestroy = FALSE);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsInConversation',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 445: Determine whether oObject is in conversation.\r\nint GetIsInConversation(object oObject);',
        '// 445: Determine whether oObject is in conversation.\r\nint GetIsInConversation(object oObject);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectAbilityDecrease',
        [ScriptParam(DataType.INT, 'nAbility', None), ScriptParam(DataType.INT, 'nModifyBy', None), ],
        '// 446: Create an Ability Decrease effect.\r\n// - nAbility: ABILITY_*\r\n// - nModifyBy: This is the amount by which to decrement the ability\r\neffect EffectAbilityDecrease(int nAbility, int nModifyBy);',
        '// 446: Create an Ability Decrease effect.\r\n// - nAbility: ABILITY_*\r\n// - nModifyBy: This is the amount by which to decrement the ability\r\neffect EffectAbilityDecrease(int nAbility, int nModifyBy);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectAttackDecrease',
        [ScriptParam(DataType.INT, 'nPenalty', None), ScriptParam(DataType.INT, 'nModifierType', 0), ],
        '// 447: Create an Attack Decrease effect.\r\n// - nPenalty\r\n// - nModifierType: ATTACK_BONUS_*\r\neffect EffectAttackDecrease(int nPenalty, int nModifierType = ATTACK_BONUS_MISC);',
        '// 447: Create an Attack Decrease effect.\r\n// - nPenalty\r\n// - nModifierType: ATTACK_BONUS_*\r\neffect EffectAttackDecrease(int nPenalty, int nModifierType = ATTACK_BONUS_MISC);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDamageDecrease',
        [ScriptParam(DataType.INT, 'nPenalty', None), ScriptParam(DataType.INT, 'nDamageType', 8), ],
        '// 448: Create a Damage Decrease effect.\r\n// - nPenalty\r\n// - nDamageType: DAMAGE_TYPE_*\r\neffect EffectDamageDecrease(int nPenalty, int nDamageType = DAMAGE_TYPE_UNIVERSAL);',
        '// 448: Create a Damage Decrease effect.\r\n// - nPenalty\r\n// - nDamageType: DAMAGE_TYPE_*\r\neffect EffectDamageDecrease(int nPenalty, int nDamageType = DAMAGE_TYPE_UNIVERSAL);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDamageImmunityDecrease',
        [ScriptParam(DataType.INT, 'nDamageType', None), ScriptParam(DataType.INT, 'nPercentImmunity', None), ],
        '// 449: Create a Damage Immunity Decrease effect.\r\n// - nDamageType: DAMAGE_TYPE_*\r\n// - nPercentImmunity\r\neffect EffectDamageImmunityDecrease(int nDamageType, int nPercentImmunity);',
        '// 449: Create a Damage Immunity Decrease effect.\r\n// - nDamageType: DAMAGE_TYPE_*\r\n// - nPercentImmunity\r\neffect EffectDamageImmunityDecrease(int nDamageType, int nPercentImmunity);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectACDecrease',
        [ScriptParam(DataType.INT, 'nValue', None), ScriptParam(DataType.INT, 'nModifyType', 0), ScriptParam(DataType.INT, 'nDamageType', 8199), ],
        '// 450: Create an AC Decrease effect.\r\n// - nValue\r\n// - nModifyType: AC_*\r\n// - nDamageType: DAMAGE_TYPE_*\r\n//   * Default value for nDamageType should only ever be used in this function prototype.\r\neffect EffectACDecrease(int nValue, int nModifyType = AC_DODGE_BONUS, int nDamageType = AC_VS_DAMAGE_TYPE_ALL);',
        '// 450: Create an AC Decrease effect.\r\n// - nValue\r\n// - nModifyType: AC_*\r\n// - nDamageType: DAMAGE_TYPE_*\r\n//   * Default value for nDamageType should only ever be used in this function prototype.\r\neffect EffectACDecrease(int nValue, int nModifyType = AC_DODGE_BONUS, int nDamageType = AC_VS_DAMAGE_TYPE_ALL);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectMovementSpeedDecrease',
        [ScriptParam(DataType.INT, 'nPercentChange', None), ],
        '// 451: Create a Movement Speed Decrease effect.\r\n// - nPercentChange: This is expected to be a positive integer between 1 and 99 inclusive.\r\n//   If a negative integer is supplied then a movement speed increase will result,\r\n//   and if a number > =  100 is supplied then the effect is deleted.\r\neffect EffectMovementSpeedDecrease(int nPercentChange);',
        '// 451: Create a Movement Speed Decrease effect.\r\n// - nPercentChange: This is expected to be a positive integer between 1 and 99 inclusive.\r\n//   If a negative integer is supplied then a movement speed increase will result,\r\n//   and if a number > =  100 is supplied then the effect is deleted.\r\neffect EffectMovementSpeedDecrease(int nPercentChange);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectSavingThrowDecrease',
        [ScriptParam(DataType.INT, 'nSave', None), ScriptParam(DataType.INT, 'nValue', None), ScriptParam(DataType.INT, 'nSaveType', 0), ],
        '// 452: Create a Saving Throw Decrease effect.\r\n// - nSave\r\n// - nValue\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\neffect EffectSavingThrowDecrease(int nSave, int nValue, int nSaveType = SAVING_THROW_TYPE_ALL);',
        '// 452: Create a Saving Throw Decrease effect.\r\n// - nSave\r\n// - nValue\r\n// - nSaveType: SAVING_THROW_TYPE_*\r\neffect EffectSavingThrowDecrease(int nSave, int nValue, int nSaveType = SAVING_THROW_TYPE_ALL);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectSkillDecrease',
        [ScriptParam(DataType.INT, 'nSkill', None), ScriptParam(DataType.INT, 'nValue', None), ],
        '// 453: Create a Skill Decrease effect.\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nSkill is invalid.\r\neffect EffectSkillDecrease(int nSkill, int nValue);',
        '// 453: Create a Skill Decrease effect.\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nSkill is invalid.\r\neffect EffectSkillDecrease(int nSkill, int nValue);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectForceResistanceDecrease',
        [ScriptParam(DataType.INT, 'nValue', None), ],
        '// 454: Create a Force Resistance Decrease effect.\r\neffect EffectForceResistanceDecrease(int nValue);',
        '// 454: Create a Force Resistance Decrease effect.\r\neffect EffectForceResistanceDecrease(int nValue);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetPlotFlag',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        '// 455: Determine whether oTarget is a plot object.\r\nint GetPlotFlag(object oTarget = OBJECT_SELF);',
        '// 455: Determine whether oTarget is a plot object.\r\nint GetPlotFlag(object oTarget = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetPlotFlag',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'nPlotFlag', None), ],
        "// 456: Set oTarget's plot object status.\r\nvoid SetPlotFlag(object oTarget, int nPlotFlag);",
        "// 456: Set oTarget's plot object status.\r\nvoid SetPlotFlag(object oTarget, int nPlotFlag);"
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectInvisibility',
        [ScriptParam(DataType.INT, 'nInvisibilityType', None), ],
        '// 457: Create an Invisibility effect.\r\n// - nInvisibilityType: INVISIBILITY_TYPE_*\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nInvisibilityType\r\n//   is invalid.\r\neffect EffectInvisibility(int nInvisibilityType);',
        '// 457: Create an Invisibility effect.\r\n// - nInvisibilityType: INVISIBILITY_TYPE_*\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nInvisibilityType\r\n//   is invalid.\r\neffect EffectInvisibility(int nInvisibilityType);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectConcealment',
        [ScriptParam(DataType.INT, 'nPercentage', None), ],
        '// 458: Create a Concealment effect.\r\n// - nPercentage: 1-100 inclusive\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nPercentage < 1 or\r\n//   nPercentage > 100.\r\neffect EffectConcealment(int nPercentage);',
        '// 458: Create a Concealment effect.\r\n// - nPercentage: 1-100 inclusive\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nPercentage < 1 or\r\n//   nPercentage > 100.\r\neffect EffectConcealment(int nPercentage);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectForceShield',
        [ScriptParam(DataType.INT, 'nShield', None), ],
        '// 459: Create a Force Shield that has parameters from the guven index into the forceshields.2da\r\neffect EffectForceShield(int nShield);',
        '// 459: Create a Force Shield that has parameters from the guven index into the forceshields.2da\r\neffect EffectForceShield(int nShield);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDispelMagicAll',
        [ScriptParam(DataType.INT, 'nCasterLevel', None), ],
        '// 460: Create a Dispel Magic All effect.\r\neffect EffectDispelMagicAll(int nCasterLevel);',
        '// 460: Create a Dispel Magic All effect.\r\neffect EffectDispelMagicAll(int nCasterLevel);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetDialogPlaceableCamera',
        [ScriptParam(DataType.INT, 'nCameraId', None), ],
        "// 461: Cut immediately to placeable camera 'nCameraId' during dialog.  nCameraId must be\r\n//      an existing Placeable Camera ID.  Function only works during Dialog.\r\nvoid SetDialogPlaceableCamera( int nCameraId );",
        "// 461: Cut immediately to placeable camera 'nCameraId' during dialog.  nCameraId must be\r\n//      an existing Placeable Camera ID.  Function only works during Dialog.\r\nvoid SetDialogPlaceableCamera( int nCameraId );"
    ),
    ScriptFunction(
        DataType.INT,
        'GetSoloMode',
        [],
        "// 462:\r\n// Returns: TRUE if the player is in 'solo mode' (ie. the party is not supposed to follow the player).\r\n//          FALSE otherwise.\r\nint GetSoloMode();",
        "// 462:\r\n// Returns: TRUE if the player is in 'solo mode' (ie. the party is not supposed to follow the player).\r\n//          FALSE otherwise.\r\nint GetSoloMode();"
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDisguise',
        [ScriptParam(DataType.INT, 'nDisguiseAppearance', None), ],
        '// 463: Create a Disguise effect.\r\n// - * nDisguiseAppearance: DISGUISE_TYPE_*s\r\neffect EffectDisguise(int nDisguiseAppearance);',
        '// 463: Create a Disguise effect.\r\n// - * nDisguiseAppearance: DISGUISE_TYPE_*s\r\neffect EffectDisguise(int nDisguiseAppearance);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetMaxStealthXP',
        [],
        '// 464:\r\n// Returns the maximum amount of stealth xp available in the area.\r\nint GetMaxStealthXP();',
        '// 464:\r\n// Returns the maximum amount of stealth xp available in the area.\r\nint GetMaxStealthXP();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectTrueSeeing',
        [],
        '// 465: Create a True Seeing effect.\r\neffect EffectTrueSeeing();',
        '// 465: Create a True Seeing effect.\r\neffect EffectTrueSeeing();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectSeeInvisible',
        [],
        '// 466: Create a See Invisible effect.\r\neffect EffectSeeInvisible();',
        '// 466: Create a See Invisible effect.\r\neffect EffectSeeInvisible();'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectTimeStop',
        [],
        '// 467: Create a Time Stop effect.\r\neffect EffectTimeStop();',
        '// 467: Create a Time Stop effect.\r\neffect EffectTimeStop();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetMaxStealthXP',
        [ScriptParam(DataType.INT, 'nMax', None), ],
        '// 468:\r\n// Set the maximum amount of stealth xp available in the area.\r\nvoid SetMaxStealthXP( int nMax );',
        '// 468:\r\n// Set the maximum amount of stealth xp available in the area.\r\nvoid SetMaxStealthXP( int nMax );'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectBlasterDeflectionIncrease',
        [ScriptParam(DataType.INT, 'nChange', None), ],
        '// 469: Increase the blaster deflection rate, i think...\r\neffect EffectBlasterDeflectionIncrease(int nChange);',
        '// 469: Increase the blaster deflection rate, i think...\r\neffect EffectBlasterDeflectionIncrease(int nChange);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectBlasterDeflectionDecrease',
        [ScriptParam(DataType.INT, 'nChange', None), ],
        '// 470:decrease the blaster deflection rate\r\neffect EffectBlasterDeflectionDecrease(int nChange);',
        '// 470:decrease the blaster deflection rate\r\neffect EffectBlasterDeflectionDecrease(int nChange);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectHorrified',
        [],
        '// 471: Make the creature horified. BOO!\r\neffect EffectHorrified( );',
        '// 471: Make the creature horified. BOO!\r\neffect EffectHorrified( );'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectSpellLevelAbsorption',
        [ScriptParam(DataType.INT, 'nMaxSpellLevelAbsorbed', None), ScriptParam(DataType.INT, 'nTotalSpellLevelsAbsorbed', 0), ScriptParam(DataType.INT, 'nSpellSchool', 0), ],
        '// 472: Create a Spell Level Absorption effect.\r\n// - nMaxSpellLevelAbsorbed: maximum spell level that will be absorbed by the\r\n//   effect\r\n// - nTotalSpellLevelsAbsorbed: maximum number of spell levels that will be\r\n//   absorbed by the effect\r\n// - nSpellSchool: SPELL_SCHOOL_*\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if:\r\n//   nMaxSpellLevelAbsorbed is not between -1 and 9 inclusive, or nSpellSchool\r\n//   is invalid.\r\neffect EffectSpellLevelAbsorption(int nMaxSpellLevelAbsorbed, int nTotalSpellLevelsAbsorbed = 0, int nSpellSchool = 0 );',
        '// 472: Create a Spell Level Absorption effect.\r\n// - nMaxSpellLevelAbsorbed: maximum spell level that will be absorbed by the\r\n//   effect\r\n// - nTotalSpellLevelsAbsorbed: maximum number of spell levels that will be\r\n//   absorbed by the effect\r\n// - nSpellSchool: SPELL_SCHOOL_*\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if:\r\n//   nMaxSpellLevelAbsorbed is not between -1 and 9 inclusive, or nSpellSchool\r\n//   is invalid.\r\neffect EffectSpellLevelAbsorption(int nMaxSpellLevelAbsorbed, int nTotalSpellLevelsAbsorbed = 0, int nSpellSchool = 0 );'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDispelMagicBest',
        [ScriptParam(DataType.INT, 'nCasterLevel', None), ],
        '// 473: Create a Dispel Magic Best effect.\r\neffect EffectDispelMagicBest(int nCasterLevel);',
        '// 473: Create a Dispel Magic Best effect.\r\neffect EffectDispelMagicBest(int nCasterLevel);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetCurrentStealthXP',
        [],
        '// 474:\r\n// Returns the current amount of stealth xp available in the area.\r\nint GetCurrentStealthXP();',
        '// 474:\r\n// Returns the current amount of stealth xp available in the area.\r\nint GetCurrentStealthXP();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetNumStackedItems',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 475: Get the number of stacked items that oItem comprises.\r\nint GetNumStackedItems(object oItem);',
        '// 475: Get the number of stacked items that oItem comprises.\r\nint GetNumStackedItems(object oItem);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SurrenderToEnemies',
        [],
        "// 476: Use this on an NPC to cause all creatures within a 10-metre radius to stop\r\n// what they are doing and sets the NPC's enemies within this range to be\r\n// neutral towards the NPC. If this command is run on a PC or an object that is\r\n// not a creature, nothing will happen.\r\nvoid SurrenderToEnemies();",
        "// 476: Use this on an NPC to cause all creatures within a 10-metre radius to stop\r\n// what they are doing and sets the NPC's enemies within this range to be\r\n// neutral towards the NPC. If this command is run on a PC or an object that is\r\n// not a creature, nothing will happen.\r\nvoid SurrenderToEnemies();"
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectMissChance',
        [ScriptParam(DataType.INT, 'nPercentage', None), ],
        '// 477: Create a Miss Chance effect.\r\n// - nPercentage: 1-100 inclusive\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nPercentage < 1 or\r\n//   nPercentage > 100.\r\neffect EffectMissChance(int nPercentage);',
        '// 477: Create a Miss Chance effect.\r\n// - nPercentage: 1-100 inclusive\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nPercentage < 1 or\r\n//   nPercentage > 100.\r\neffect EffectMissChance(int nPercentage);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetCurrentStealthXP',
        [ScriptParam(DataType.INT, 'nCurrent', None), ],
        '// 478:\r\n// Set the current amount of stealth xp available in the area.\r\nvoid SetCurrentStealthXP( int nCurrent );',
        '// 478:\r\n// Set the current amount of stealth xp available in the area.\r\nvoid SetCurrentStealthXP( int nCurrent );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetCreatureSize',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 479: Get the size (CREATURE_SIZE_*) of oCreature.\r\nint GetCreatureSize(object oCreature);',
        '// 479: Get the size (CREATURE_SIZE_*) of oCreature.\r\nint GetCreatureSize(object oCreature);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AwardStealthXP',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 480:\r\n// Award the stealth xp to the given oTarget.  This will only work on creatures.\r\nvoid AwardStealthXP( object oTarget );',
        '// 480:\r\n// Award the stealth xp to the given oTarget.  This will only work on creatures.\r\nvoid AwardStealthXP( object oTarget );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetStealthXPEnabled',
        [],
        '// 481:\r\n// Returns whether or not the stealth xp bonus is enabled (ie. whether or not\r\n// AwardStealthXP() will actually award any available stealth xp).\r\nint GetStealthXPEnabled();',
        '// 481:\r\n// Returns whether or not the stealth xp bonus is enabled (ie. whether or not\r\n// AwardStealthXP() will actually award any available stealth xp).\r\nint GetStealthXPEnabled();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetStealthXPEnabled',
        [ScriptParam(DataType.INT, 'bEnabled', None), ],
        '// 482:\r\n// Sets whether or not the stealth xp bonus is enabled (ie. whether or not\r\n// AwardStealthXP() will actually award any available stealth xp).\r\nvoid SetStealthXPEnabled( int bEnabled );',
        '// 482:\r\n// Sets whether or not the stealth xp bonus is enabled (ie. whether or not\r\n// AwardStealthXP() will actually award any available stealth xp).\r\nvoid SetStealthXPEnabled( int bEnabled );'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionUnlockObject',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 483: The action subject will unlock oTarget, which can be a door or a placeable\r\n// object.\r\nvoid ActionUnlockObject(object oTarget);',
        '// 483: The action subject will unlock oTarget, which can be a door or a placeable\r\n// object.\r\nvoid ActionUnlockObject(object oTarget);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionLockObject',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        '// 484: The action subject will lock oTarget, which can be a door or a placeable\r\n// object.\r\nvoid ActionLockObject(object oTarget);',
        '// 484: The action subject will lock oTarget, which can be a door or a placeable\r\n// object.\r\nvoid ActionLockObject(object oTarget);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectModifyAttacks',
        [ScriptParam(DataType.INT, 'nAttacks', None), ],
        '// 485: Create a Modify Attacks effect to add attacks.\r\n// - nAttacks: maximum is 5, even with the effect stacked\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nAttacks > 5.\r\neffect EffectModifyAttacks(int nAttacks);',
        '// 485: Create a Modify Attacks effect to add attacks.\r\n// - nAttacks: maximum is 5, even with the effect stacked\r\n// * Returns an effect of type EFFECT_TYPE_INVALIDEFFECT if nAttacks > 5.\r\neffect EffectModifyAttacks(int nAttacks);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastTrapDetected',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        '// 486: Get the last trap detected by oTarget.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetLastTrapDetected(object oTarget = OBJECT_SELF);',
        '// 486: Get the last trap detected by oTarget.\r\n// * Return value on error: OBJECT_INVALID\r\nobject GetLastTrapDetected(object oTarget = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'EffectDamageShield',
        [ScriptParam(DataType.INT, 'nDamageAmount', None), ScriptParam(DataType.INT, 'nRandomAmount', None), ScriptParam(DataType.INT, 'nDamageType', None), ],
        '// 487: Create a Damage Shield effect which does (nDamageAmount + nRandomAmount)\r\n// damage to any melee attacker on a successful attack of damage type nDamageType.\r\n// - nDamageAmount: an integer value\r\n// - nRandomAmount: DAMAGE_BONUS_*\r\n// - nDamageType: DAMAGE_TYPE_*\r\neffect EffectDamageShield(int nDamageAmount, int nRandomAmount, int nDamageType);',
        '// 487: Create a Damage Shield effect which does (nDamageAmount + nRandomAmount)\r\n// damage to any melee attacker on a successful attack of damage type nDamageType.\r\n// - nDamageAmount: an integer value\r\n// - nRandomAmount: DAMAGE_BONUS_*\r\n// - nDamageType: DAMAGE_TYPE_*\r\neffect EffectDamageShield(int nDamageAmount, int nRandomAmount, int nDamageType);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNearestTrapToObject',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ScriptParam(DataType.INT, 'nTrapDetected', 1), ],
        '// 488: Get the trap nearest to oTarget.\r\n// Note : "trap objects" are actually any trigger, placeable or door that is\r\n// trapped in oTarget\'s area.\r\n// - oTarget\r\n// - nTrapDetected: if this is TRUE, the trap returned has to have been detected\r\n//   by oTarget.\r\nobject GetNearestTrapToObject(object oTarget = OBJECT_SELF, int nTrapDetected = TRUE);',
        '// 488: Get the trap nearest to oTarget.\r\n// Note : "trap objects" are actually any trigger, placeable or door that is\r\n// trapped in oTarget\'s area.\r\n// - oTarget\r\n// - nTrapDetected: if this is TRUE, the trap returned has to have been detected\r\n//   by oTarget.\r\nobject GetNearestTrapToObject(object oTarget = OBJECT_SELF, int nTrapDetected = TRUE);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetAttemptedMovementTarget',
        [],
        '// 489: the will get the last attmpted movment target\r\nobject GetAttemptedMovementTarget();',
        '// 489: the will get the last attmpted movment target\r\nobject GetAttemptedMovementTarget();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetBlockingCreature',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        '// 490: this function returns the bloking creature for the k_def_CBTBlk01 script\r\nobject GetBlockingCreature(object oTarget = OBJECT_SELF);',
        '// 490: this function returns the bloking creature for the k_def_CBTBlk01 script\r\nobject GetBlockingCreature(object oTarget = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetFortitudeSavingThrow',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        "// 491: Get oTarget's base fortitude saving throw value (this will only work for\r\n// creatures, doors, and placeables).\r\n// * Returns 0 if oTarget is invalid.\r\nint GetFortitudeSavingThrow(object oTarget);",
        "// 491: Get oTarget's base fortitude saving throw value (this will only work for\r\n// creatures, doors, and placeables).\r\n// * Returns 0 if oTarget is invalid.\r\nint GetFortitudeSavingThrow(object oTarget);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetWillSavingThrow',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        "// 492: Get oTarget's base will saving throw value (this will only work for creatures,\r\n// doors, and placeables).\r\n// * Returns 0 if oTarget is invalid.\r\nint GetWillSavingThrow(object oTarget);",
        "// 492: Get oTarget's base will saving throw value (this will only work for creatures,\r\n// doors, and placeables).\r\n// * Returns 0 if oTarget is invalid.\r\nint GetWillSavingThrow(object oTarget);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetReflexSavingThrow',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ],
        "// 493: Get oTarget's base reflex saving throw value (this will only work for\r\n// creatures, doors, and placeables).\r\n// * Returns 0 if oTarget is invalid.\r\nint GetReflexSavingThrow(object oTarget);",
        "// 493: Get oTarget's base reflex saving throw value (this will only work for\r\n// creatures, doors, and placeables).\r\n// * Returns 0 if oTarget is invalid.\r\nint GetReflexSavingThrow(object oTarget);"
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetChallengeRating',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        "// 494: Get oCreature's challenge rating.\r\n// * Returns 0.0 if oCreature is invalid.\r\nfloat GetChallengeRating(object oCreature);",
        "// 494: Get oCreature's challenge rating.\r\n// * Returns 0.0 if oCreature is invalid.\r\nfloat GetChallengeRating(object oCreature);"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFoundEnemyCreature',
        [ScriptParam(DataType.OBJECT, 'oTarget', 0), ],
        '// 495: Returns the found enemy creature on a pathfind.\r\nobject GetFoundEnemyCreature(object oTarget = OBJECT_SELF);',
        '// 495: Returns the found enemy creature on a pathfind.\r\nobject GetFoundEnemyCreature(object oTarget = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetMovementRate',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        "// 496: Get oCreature's movement rate.\r\n// * Returns 0 if oCreature is invalid.\r\nint GetMovementRate(object oCreature);",
        "// 496: Get oCreature's movement rate.\r\n// * Returns 0 if oCreature is invalid.\r\nint GetMovementRate(object oCreature);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetSubRace',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 497: GetSubRace of oCreature\r\n// Returns SUBRACE_*\r\nint GetSubRace(object oCreature);',
        '// 497: GetSubRace of oCreature\r\n// Returns SUBRACE_*\r\nint GetSubRace(object oCreature);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetStealthXPDecrement',
        [],
        '// 498:\r\n// Returns the amount the stealth xp bonus gets decreased each time the player is detected.\r\nint GetStealthXPDecrement();',
        '// 498:\r\n// Returns the amount the stealth xp bonus gets decreased each time the player is detected.\r\nint GetStealthXPDecrement();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetStealthXPDecrement',
        [ScriptParam(DataType.INT, 'nDecrement', None), ],
        '// 499:\r\n// Sets the amount the stealth xp bonus gets decreased each time the player is detected.\r\nvoid SetStealthXPDecrement( int nDecrement );',
        '// 499:\r\n// Sets the amount the stealth xp bonus gets decreased each time the player is detected.\r\nvoid SetStealthXPDecrement( int nDecrement );'
    ),
    ScriptFunction(
        DataType.VOID,
        'DuplicateHeadAppearance',
        [ScriptParam(DataType.OBJECT, 'oidCreatureToChange', None), ScriptParam(DataType.OBJECT, 'oidCreatureToMatch', None), ],
        '// 500:\r\nvoid DuplicateHeadAppearance(object oidCreatureToChange, object oidCreatureToMatch);',
        '// 500:\r\nvoid DuplicateHeadAppearance(object oidCreatureToChange, object oidCreatureToMatch);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionCastFakeSpellAtObject',
        [ScriptParam(DataType.INT, 'nSpell', None), ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'nProjectilePathType', 0), ],
        '// 501: The action subject will fake casting a spell at oTarget; the conjure and cast\r\n// animations and visuals will occur, nothing else.\r\n// - nSpell\r\n// - oTarget\r\n// - nProjectilePathType: PROJECTILE_PATH_TYPE_*\r\nvoid ActionCastFakeSpellAtObject(int nSpell, object oTarget, int nProjectilePathType = PROJECTILE_PATH_TYPE_DEFAULT);',
        '// 501: The action subject will fake casting a spell at oTarget; the conjure and cast\r\n// animations and visuals will occur, nothing else.\r\n// - nSpell\r\n// - oTarget\r\n// - nProjectilePathType: PROJECTILE_PATH_TYPE_*\r\nvoid ActionCastFakeSpellAtObject(int nSpell, object oTarget, int nProjectilePathType = PROJECTILE_PATH_TYPE_DEFAULT);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ActionCastFakeSpellAtLocation',
        [ScriptParam(DataType.INT, 'nSpell', None), ScriptParam(DataType.LOCATION, 'lTarget', None), ScriptParam(DataType.INT, 'nProjectilePathType', 0), ],
        '// 502: The action subject will fake casting a spell at lLocation; the conjure and\r\n// cast animations and visuals will occur, nothing else.\r\n// - nSpell\r\n// - lTarget\r\n// - nProjectilePathType: PROJECTILE_PATH_TYPE_*\r\nvoid ActionCastFakeSpellAtLocation(int nSpell, location lTarget, int nProjectilePathType = PROJECTILE_PATH_TYPE_DEFAULT);',
        '// 502: The action subject will fake casting a spell at lLocation; the conjure and\r\n// cast animations and visuals will occur, nothing else.\r\n// - nSpell\r\n// - lTarget\r\n// - nProjectilePathType: PROJECTILE_PATH_TYPE_*\r\nvoid ActionCastFakeSpellAtLocation(int nSpell, location lTarget, int nProjectilePathType = PROJECTILE_PATH_TYPE_DEFAULT);'
    ),
    ScriptFunction(
        DataType.VOID,
        'CutsceneAttack',
        [ScriptParam(DataType.OBJECT, 'oTarget', None), ScriptParam(DataType.INT, 'nAnimation', None), ScriptParam(DataType.INT, 'nAttackResult', None), ScriptParam(DataType.INT, 'nDamage', None), ],
        "// 503: CutsceneAttack\r\n// This function allows the designer to specify exactly what's going to happen in a combat round\r\n// There are no guarentees made that the animation specified here will be correct - only that it will be played,\r\n// so it is up to the designer to ensure that they have selected the right animation\r\n// It relies upon constants specified above for the attack result\r\nvoid CutsceneAttack(object oTarget, int nAnimation, int nAttackResult, int nDamage);",
        "// 503: CutsceneAttack\r\n// This function allows the designer to specify exactly what's going to happen in a combat round\r\n// There are no guarentees made that the animation specified here will be correct - only that it will be played,\r\n// so it is up to the designer to ensure that they have selected the right animation\r\n// It relies upon constants specified above for the attack result\r\nvoid CutsceneAttack(object oTarget, int nAnimation, int nAttackResult, int nDamage);"
    ),
    ScriptFunction(
        DataType.VOID,
        'SetCameraMode',
        [ScriptParam(DataType.OBJECT, 'oPlayer', None), ScriptParam(DataType.INT, 'nCameraMode', None), ],
        '// 504: Set the camera mode for oPlayer.\r\n// - oPlayer\r\n// - nCameraMode: CAMERA_MODE_*\r\n// * If oPlayer is not player-controlled or nCameraMode is invalid, nothing\r\n//   happens.\r\nvoid SetCameraMode(object oPlayer, int nCameraMode);',
        '// 504: Set the camera mode for oPlayer.\r\n// - oPlayer\r\n// - nCameraMode: CAMERA_MODE_*\r\n// * If oPlayer is not player-controlled or nCameraMode is invalid, nothing\r\n//   happens.\r\nvoid SetCameraMode(object oPlayer, int nCameraMode);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetLockOrientationInDialog',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.INT, 'nValue', None), ],
        '// 505: SetLockOrientationInDialog\r\n// Allows the locking and unlocking of orientation changes for an object in dialog\r\n// - oObject - Object\r\n// - nValue - TRUE or FALSE\r\nvoid SetLockOrientationInDialog(object oObject, int nValue);',
        '// 505: SetLockOrientationInDialog\r\n// Allows the locking and unlocking of orientation changes for an object in dialog\r\n// - oObject - Object\r\n// - nValue - TRUE or FALSE\r\nvoid SetLockOrientationInDialog(object oObject, int nValue);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetLockHeadFollowInDialog',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.INT, 'nValue', None), ],
        '// 506: SetLockHeadFollowInDialog\r\n// Allows the locking and undlocking of head following for an object in dialog\r\n// - oObject - Object\r\n// - nValue - TRUE or FALSE\r\nvoid SetLockHeadFollowInDialog(object oObject, int nValue);',
        '// 506: SetLockHeadFollowInDialog\r\n// Allows the locking and undlocking of head following for an object in dialog\r\n// - oObject - Object\r\n// - nValue - TRUE or FALSE\r\nvoid SetLockHeadFollowInDialog(object oObject, int nValue);'
    ),
    ScriptFunction(
        DataType.VOID,
        'CutsceneMove',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.VECTOR, 'vPosition', None), ScriptParam(DataType.INT, 'nRun', None), ],
        '// 507: CutsceneMoveToPoint\r\n// Used by the cutscene system to allow designers to script combat\r\nvoid CutsceneMove(object oObject, vector vPosition, int nRun);',
        '// 507: CutsceneMoveToPoint\r\n// Used by the cutscene system to allow designers to script combat\r\nvoid CutsceneMove(object oObject, vector vPosition, int nRun);'
    ),
    ScriptFunction(
        DataType.VOID,
        'EnableVideoEffect',
        [ScriptParam(DataType.INT, 'nEffectType', None), ],
        '// 508: EnableVideoEffect\r\n// Enables the video frame buffer effect specified by nEffectType, which is\r\n// an index into VideoEffects.2da. This video effect will apply indefinitely,\r\n// and so it should *always* be cleared by a call to DisableVideoEffect().\r\nvoid EnableVideoEffect(int nEffectType);',
        '// 508: EnableVideoEffect\r\n// Enables the video frame buffer effect specified by nEffectType, which is\r\n// an index into VideoEffects.2da. This video effect will apply indefinitely,\r\n// and so it should *always* be cleared by a call to DisableVideoEffect().\r\nvoid EnableVideoEffect(int nEffectType);'
    ),
    ScriptFunction(
        DataType.VOID,
        'StartNewModule',
        [ScriptParam(DataType.STRING, 'sModuleName', None), ScriptParam(DataType.STRING, 'sWayPoint', ''), ScriptParam(DataType.STRING, 'sMovie1', ''), ScriptParam(DataType.STRING, 'sMovie2', ''), ScriptParam(DataType.STRING, 'sMovie3', ''), ScriptParam(DataType.STRING, 'sMovie4', ''), ScriptParam(DataType.STRING, 'sMovie5', ''), ScriptParam(DataType.STRING, 'sMovie6', ''), ],
        '// 509: Shut down the currently loaded module and start a new one (moving all\r\n// currently-connected players to the starting point.\r\nvoid StartNewModule(string sModuleName, string sWayPoint = "", string sMovie1 = "", string sMovie2 = "", string sMovie3 = "", string sMovie4 = "", string sMovie5 = "", string sMovie6 = "");',
        '// 509: Shut down the currently loaded module and start a new one (moving all\r\n// currently-connected players to the starting point.\r\nvoid StartNewModule(string sModuleName, string sWayPoint = "", string sMovie1 = "", string sMovie2 = "", string sMovie3 = "", string sMovie4 = "", string sMovie5 = "", string sMovie6 = "");'
    ),
    ScriptFunction(
        DataType.VOID,
        'DisableVideoEffect',
        [],
        '// 510: DisableVideoEffect\r\n// Disables any video frame buffer effect that may be running. See\r\n// EnableVideoEffect() to see how to use them.\r\nvoid DisableVideoEffect();',
        '// 510: DisableVideoEffect\r\n// Disables any video frame buffer effect that may be running. See\r\n// EnableVideoEffect() to see how to use them.\r\nvoid DisableVideoEffect();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetWeaponRanged',
        [ScriptParam(DataType.OBJECT, 'oItem', None), ],
        '// 511: * Returns TRUE if oItem is a ranged weapon.\r\nint GetWeaponRanged(object oItem);',
        '// 511: * Returns TRUE if oItem is a ranged weapon.\r\nint GetWeaponRanged(object oItem);'
    ),
    ScriptFunction(
        DataType.VOID,
        'DoSinglePlayerAutoSave',
        [],
        '// 512: Only if we are in a single player game, AutoSave the game.\r\nvoid DoSinglePlayerAutoSave();',
        '// 512: Only if we are in a single player game, AutoSave the game.\r\nvoid DoSinglePlayerAutoSave();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetGameDifficulty',
        [],
        '// 513: Get the game difficulty (GAME_DIFFICULTY_*).\r\nint GetGameDifficulty();',
        '// 513: Get the game difficulty (GAME_DIFFICULTY_*).\r\nint GetGameDifficulty();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetUserActionsPending',
        [],
        '// 514:\r\n// This will test the combat action queu to see if the user has placed any actions on the queue.\r\n// will only work during combat.\r\nint GetUserActionsPending();',
        '// 514:\r\n// This will test the combat action queu to see if the user has placed any actions on the queue.\r\n// will only work during combat.\r\nint GetUserActionsPending();'
    ),
    ScriptFunction(
        DataType.VOID,
        'RevealMap',
        [ScriptParam(DataType.VECTOR, 'vPoint', Vector3(0.0, 0.0, 0.0)), ScriptParam(DataType.INT, 'nRadius', -1), ],
        "// 515: RevealMap\r\n// Reveals the map at the given WORLD point 'vPoint' with a MAP Grid Radius 'nRadius'\r\n// If this function is called with no parameters it will reveal the entire map.\r\n// (NOTE: if this function is called with a valid point but a default radius, ie. 'nRadius' of -1\r\n//        then the entire map will be revealed)\r\nvoid RevealMap(vector vPoint = [0.0,0.0,0.0],int nRadius = -1);",
        "// 515: RevealMap\r\n// Reveals the map at the given WORLD point 'vPoint' with a MAP Grid Radius 'nRadius'\r\n// If this function is called with no parameters it will reveal the entire map.\r\n// (NOTE: if this function is called with a valid point but a default radius, ie. 'nRadius' of -1\r\n//        then the entire map will be revealed)\r\nvoid RevealMap(vector vPoint = [0.0,0.0,0.0],int nRadius = -1);"
    ),
    ScriptFunction(
        DataType.VOID,
        'SetTutorialWindowsEnabled',
        [ScriptParam(DataType.INT, 'bEnabled', None), ],
        '// 516: SetTutorialWindowsEnabled\r\n// Sets whether or not the tutorial windows are enabled (ie. whether or not they will\r\n// appear when certain things happen for the first time).\r\nvoid SetTutorialWindowsEnabled( int bEnabled );',
        '// 516: SetTutorialWindowsEnabled\r\n// Sets whether or not the tutorial windows are enabled (ie. whether or not they will\r\n// appear when certain things happen for the first time).\r\nvoid SetTutorialWindowsEnabled( int bEnabled );'
    ),
    ScriptFunction(
        DataType.VOID,
        'ShowTutorialWindow',
        [ScriptParam(DataType.INT, 'nWindow', None), ],
        '// 517: ShowTutorialWindow\r\n// nWindow - A row index from Tutorial.2DA specifying the message to display.\r\n// Pops up the specified tutorial window.  If the tutorial window has already popped\r\n// up once before, this will do nothing.\r\nvoid ShowTutorialWindow( int nWindow );',
        '// 517: ShowTutorialWindow\r\n// nWindow - A row index from Tutorial.2DA specifying the message to display.\r\n// Pops up the specified tutorial window.  If the tutorial window has already popped\r\n// up once before, this will do nothing.\r\nvoid ShowTutorialWindow( int nWindow );'
    ),
    ScriptFunction(
        DataType.VOID,
        'StartCreditSequence',
        [ScriptParam(DataType.INT, 'bTransparentBackground', None), ],
        '// 518: StartCreditSequence\r\n// Starts the credits sequence.  If bTransparentBackground is TRUE, the credits will be displayed\r\n// with a transparent background, allowing whatever is currently onscreen to show through.  If it\r\n// is set to FALSE, the credits will be displayed on a black background.\r\nvoid StartCreditSequence( int bTransparentBackground );',
        '// 518: StartCreditSequence\r\n// Starts the credits sequence.  If bTransparentBackground is TRUE, the credits will be displayed\r\n// with a transparent background, allowing whatever is currently onscreen to show through.  If it\r\n// is set to FALSE, the credits will be displayed on a black background.\r\nvoid StartCreditSequence( int bTransparentBackground );'
    ),
    ScriptFunction(
        DataType.INT,
        'IsCreditSequenceInProgress',
        [],
        '// 519: IsCreditSequenceInProgress\r\n// Returns TRUE if the credits sequence is currently in progress, FALSE otherwise.\r\nint IsCreditSequenceInProgress();',
        '// 519: IsCreditSequenceInProgress\r\n// Returns TRUE if the credits sequence is currently in progress, FALSE otherwise.\r\nint IsCreditSequenceInProgress();'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetLateralAccelerationPerSecond',
        [ScriptParam(DataType.FLOAT, 'fLAPS', None), ],
        '// 520: Sets the minigame lateral acceleration/sec value\r\nvoid SWMG_SetLateralAccelerationPerSecond(float fLAPS);',
        '// 520: Sets the minigame lateral acceleration/sec value\r\nvoid SWMG_SetLateralAccelerationPerSecond(float fLAPS);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'SWMG_GetLateralAccelerationPerSecond',
        [],
        '// 521: Returns the minigame lateral acceleration/sec value\r\nfloat SWMG_GetLateralAccelerationPerSecond();',
        '// 521: Returns the minigame lateral acceleration/sec value\r\nfloat SWMG_GetLateralAccelerationPerSecond();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetCurrentAction',
        [ScriptParam(DataType.OBJECT, 'oObject', 0), ],
        '// 522: Get the current action (ACTION_*) that oObject is executing.\r\nint GetCurrentAction(object oObject = OBJECT_SELF);',
        '// 522: Get the current action (ACTION_*) that oObject is executing.\r\nint GetCurrentAction(object oObject = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetDifficultyModifier',
        [],
        '// 523:\r\nfloat GetDifficultyModifier();',
        '// 523:\r\nfloat GetDifficultyModifier();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetAppearanceType',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        "// 524: Returns the appearance type of oCreature (0 if creature doesn't exist)\r\n// - oCreature\r\nint GetAppearanceType(object oCreature);",
        "// 524: Returns the appearance type of oCreature (0 if creature doesn't exist)\r\n// - oCreature\r\nint GetAppearanceType(object oCreature);"
    ),
    ScriptFunction(
        DataType.VOID,
        'FloatingTextStrRefOnCreature',
        [ScriptParam(DataType.INT, 'nStrRefToDisplay', None), ScriptParam(DataType.OBJECT, 'oCreatureToFloatAbove', None), ScriptParam(DataType.INT, 'bBroadcastToFaction', 1), ],
        '// 525: Display floaty text above the specified creature.\r\n// The text will also appear in the chat buffer of each player that receives the\r\n// floaty text.\r\n// - nStrRefToDisplay: String ref (therefore text is translated)\r\n// - oCreatureToFloatAbove\r\n// - bBroadcastToFaction: If this is TRUE then only creatures in the same faction\r\n//   as oCreatureToFloatAbove\r\n//   will see the floaty text, and only if they are within range (30 metres).\r\nvoid FloatingTextStrRefOnCreature(int nStrRefToDisplay, object oCreatureToFloatAbove, int bBroadcastToFaction = TRUE);',
        '// 525: Display floaty text above the specified creature.\r\n// The text will also appear in the chat buffer of each player that receives the\r\n// floaty text.\r\n// - nStrRefToDisplay: String ref (therefore text is translated)\r\n// - oCreatureToFloatAbove\r\n// - bBroadcastToFaction: If this is TRUE then only creatures in the same faction\r\n//   as oCreatureToFloatAbove\r\n//   will see the floaty text, and only if they are within range (30 metres).\r\nvoid FloatingTextStrRefOnCreature(int nStrRefToDisplay, object oCreatureToFloatAbove, int bBroadcastToFaction = TRUE);'
    ),
    ScriptFunction(
        DataType.VOID,
        'FloatingTextStringOnCreature',
        [ScriptParam(DataType.STRING, 'sStringToDisplay', None), ScriptParam(DataType.OBJECT, 'oCreatureToFloatAbove', None), ScriptParam(DataType.INT, 'bBroadcastToFaction', 1), ],
        '// 526: Display floaty text above the specified creature.\r\n// The text will also appear in the chat buffer of each player that receives the\r\n// floaty text.\r\n// - sStringToDisplay: String\r\n// - oCreatureToFloatAbove\r\n// - bBroadcastToFaction: If this is TRUE then only creatures in the same faction\r\n//   as oCreatureToFloatAbove\r\n//   will see the floaty text, and only if they are within range (30 metres).\r\nvoid FloatingTextStringOnCreature(string sStringToDisplay, object oCreatureToFloatAbove, int bBroadcastToFaction = TRUE);',
        '// 526: Display floaty text above the specified creature.\r\n// The text will also appear in the chat buffer of each player that receives the\r\n// floaty text.\r\n// - sStringToDisplay: String\r\n// - oCreatureToFloatAbove\r\n// - bBroadcastToFaction: If this is TRUE then only creatures in the same faction\r\n//   as oCreatureToFloatAbove\r\n//   will see the floaty text, and only if they are within range (30 metres).\r\nvoid FloatingTextStringOnCreature(string sStringToDisplay, object oCreatureToFloatAbove, int bBroadcastToFaction = TRUE);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTrapDisarmable',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ],
        '// 527: - oTrapObject: a placeable, door or trigger\r\n// * Returns TRUE if oTrapObject is disarmable.\r\nint GetTrapDisarmable(object oTrapObject);',
        '// 527: - oTrapObject: a placeable, door or trigger\r\n// * Returns TRUE if oTrapObject is disarmable.\r\nint GetTrapDisarmable(object oTrapObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTrapDetectable',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ],
        '// 528: - oTrapObject: a placeable, door or trigger\r\n// * Returns TRUE if oTrapObject is detectable.\r\nint GetTrapDetectable(object oTrapObject);',
        '// 528: - oTrapObject: a placeable, door or trigger\r\n// * Returns TRUE if oTrapObject is detectable.\r\nint GetTrapDetectable(object oTrapObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTrapDetectedBy',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 529: - oTrapObject: a placeable, door or trigger\r\n// - oCreature\r\n// * Returns TRUE if oCreature has detected oTrapObject\r\nint GetTrapDetectedBy(object oTrapObject, object oCreature);',
        '// 529: - oTrapObject: a placeable, door or trigger\r\n// - oCreature\r\n// * Returns TRUE if oCreature has detected oTrapObject\r\nint GetTrapDetectedBy(object oTrapObject, object oCreature);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTrapFlagged',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ],
        '// 530: - oTrapObject: a placeable, door or trigger\r\n// * Returns TRUE if oTrapObject has been flagged as visible to all creatures.\r\nint GetTrapFlagged(object oTrapObject);',
        '// 530: - oTrapObject: a placeable, door or trigger\r\n// * Returns TRUE if oTrapObject has been flagged as visible to all creatures.\r\nint GetTrapFlagged(object oTrapObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTrapBaseType',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ],
        '// 531: Get the trap base type (TRAP_BASE_TYPE_*) of oTrapObject.\r\n// - oTrapObject: a placeable, door or trigger\r\nint GetTrapBaseType(object oTrapObject);',
        '// 531: Get the trap base type (TRAP_BASE_TYPE_*) of oTrapObject.\r\n// - oTrapObject: a placeable, door or trigger\r\nint GetTrapBaseType(object oTrapObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTrapOneShot',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ],
        '// 532: - oTrapObject: a placeable, door or trigger\r\n// * Returns TRUE if oTrapObject is one-shot (i.e. it does not reset itself\r\n//   after firing.\r\nint GetTrapOneShot(object oTrapObject);',
        '// 532: - oTrapObject: a placeable, door or trigger\r\n// * Returns TRUE if oTrapObject is one-shot (i.e. it does not reset itself\r\n//   after firing.\r\nint GetTrapOneShot(object oTrapObject);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetTrapCreator',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ],
        '// 533: Get the creator of oTrapObject, the creature that set the trap.\r\n// - oTrapObject: a placeable, door or trigger\r\n// * Returns OBJECT_INVALID if oTrapObject was created in the toolset.\r\nobject GetTrapCreator(object oTrapObject);',
        '// 533: Get the creator of oTrapObject, the creature that set the trap.\r\n// - oTrapObject: a placeable, door or trigger\r\n// * Returns OBJECT_INVALID if oTrapObject was created in the toolset.\r\nobject GetTrapCreator(object oTrapObject);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetTrapKeyTag',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ],
        '// 534: Get the tag of the key that will disarm oTrapObject.\r\n// - oTrapObject: a placeable, door or trigger\r\nstring GetTrapKeyTag(object oTrapObject);',
        '// 534: Get the tag of the key that will disarm oTrapObject.\r\n// - oTrapObject: a placeable, door or trigger\r\nstring GetTrapKeyTag(object oTrapObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTrapDisarmDC',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ],
        '// 535: Get the DC for disarming oTrapObject.\r\n// - oTrapObject: a placeable, door or trigger\r\nint GetTrapDisarmDC(object oTrapObject);',
        '// 535: Get the DC for disarming oTrapObject.\r\n// - oTrapObject: a placeable, door or trigger\r\nint GetTrapDisarmDC(object oTrapObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetTrapDetectDC',
        [ScriptParam(DataType.OBJECT, 'oTrapObject', None), ],
        '// 536: Get the DC for detecting oTrapObject.\r\n// - oTrapObject: a placeable, door or trigger\r\nint GetTrapDetectDC(object oTrapObject);',
        '// 536: Get the DC for detecting oTrapObject.\r\n// - oTrapObject: a placeable, door or trigger\r\nint GetTrapDetectDC(object oTrapObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLockKeyRequired',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 537: * Returns TRUE if a specific key is required to open the lock on oObject.\r\nint GetLockKeyRequired(object oObject);',
        '// 537: * Returns TRUE if a specific key is required to open the lock on oObject.\r\nint GetLockKeyRequired(object oObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLockKeyTag',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 538: Get the tag of the key that will open the lock on oObject.\r\nint GetLockKeyTag(object oObject);',
        '// 538: Get the tag of the key that will open the lock on oObject.\r\nint GetLockKeyTag(object oObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLockLockable',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 539: * Returns TRUE if the lock on oObject is lockable.\r\nint GetLockLockable(object oObject);',
        '// 539: * Returns TRUE if the lock on oObject is lockable.\r\nint GetLockLockable(object oObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLockUnlockDC',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 540: Get the DC for unlocking oObject.\r\nint GetLockUnlockDC(object oObject);',
        '// 540: Get the DC for unlocking oObject.\r\nint GetLockUnlockDC(object oObject);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetLockLockDC',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 541: Get the DC for locking oObject.\r\nint GetLockLockDC(object oObject);',
        '// 541: Get the DC for locking oObject.\r\nint GetLockLockDC(object oObject);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetPCLevellingUp',
        [],
        '// 542: Get the last PC that levelled up.\r\nobject GetPCLevellingUp();',
        '// 542: Get the last PC that levelled up.\r\nobject GetPCLevellingUp();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetHasFeatEffect',
        [ScriptParam(DataType.INT, 'nFeat', None), ScriptParam(DataType.OBJECT, 'oObject', 0), ],
        '// 543: - nFeat: FEAT_*\r\n// - oObject\r\n// * Returns TRUE if oObject has effects on it originating from nFeat.\r\nint GetHasFeatEffect(int nFeat, object oObject = OBJECT_SELF);',
        '// 543: - nFeat: FEAT_*\r\n// - oObject\r\n// * Returns TRUE if oObject has effects on it originating from nFeat.\r\nint GetHasFeatEffect(int nFeat, object oObject = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetPlaceableIllumination',
        [ScriptParam(DataType.OBJECT, 'oPlaceable', 0), ScriptParam(DataType.INT, 'bIlluminate', 1), ],
        "// 544: Set the status of the illumination for oPlaceable.\r\n// - oPlaceable\r\n// - bIlluminate: if this is TRUE, oPlaceable's illumination will be turned on.\r\n//   If this is FALSE, oPlaceable's illumination will be turned off.\r\n// Note: You must call RecomputeStaticLighting() after calling this function in\r\n// order for the changes to occur visually for the players.\r\n// SetPlaceableIllumination() buffers the illumination changes, which are then\r\n// sent out to the players once RecomputeStaticLighting() is called.  As such,\r\n// it is best to call SetPlaceableIllumination() for all the placeables you wish\r\n// to set the illumination on, and then call RecomputeStaticLighting() once after\r\n// all the placeable illumination has been set.\r\n// * If oPlaceable is not a placeable object, or oPlaceable is a placeable that\r\n//   doesn't have a light, nothing will happen.\r\nvoid SetPlaceableIllumination(object oPlaceable = OBJECT_SELF, int bIlluminate = TRUE);",
        "// 544: Set the status of the illumination for oPlaceable.\r\n// - oPlaceable\r\n// - bIlluminate: if this is TRUE, oPlaceable's illumination will be turned on.\r\n//   If this is FALSE, oPlaceable's illumination will be turned off.\r\n// Note: You must call RecomputeStaticLighting() after calling this function in\r\n// order for the changes to occur visually for the players.\r\n// SetPlaceableIllumination() buffers the illumination changes, which are then\r\n// sent out to the players once RecomputeStaticLighting() is called.  As such,\r\n// it is best to call SetPlaceableIllumination() for all the placeables you wish\r\n// to set the illumination on, and then call RecomputeStaticLighting() once after\r\n// all the placeable illumination has been set.\r\n// * If oPlaceable is not a placeable object, or oPlaceable is a placeable that\r\n//   doesn't have a light, nothing will happen.\r\nvoid SetPlaceableIllumination(object oPlaceable = OBJECT_SELF, int bIlluminate = TRUE);"
    ),
    ScriptFunction(
        DataType.INT,
        'GetPlaceableIllumination',
        [ScriptParam(DataType.OBJECT, 'oPlaceable', 0), ],
        '// 545: * Returns TRUE if the illumination for oPlaceable is on\r\nint GetPlaceableIllumination(object oPlaceable = OBJECT_SELF);',
        '// 545: * Returns TRUE if the illumination for oPlaceable is on\r\nint GetPlaceableIllumination(object oPlaceable = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsPlaceableObjectActionPossible',
        [ScriptParam(DataType.OBJECT, 'oPlaceable', None), ScriptParam(DataType.INT, 'nPlaceableAction', None), ],
        '// 546: - oPlaceable\r\n// - nPlaceableAction: PLACEABLE_ACTION_*\r\n// * Returns TRUE if nPlacebleAction is valid for oPlaceable.\r\nint GetIsPlaceableObjectActionPossible(object oPlaceable, int nPlaceableAction);',
        '// 546: - oPlaceable\r\n// - nPlaceableAction: PLACEABLE_ACTION_*\r\n// * Returns TRUE if nPlacebleAction is valid for oPlaceable.\r\nint GetIsPlaceableObjectActionPossible(object oPlaceable, int nPlaceableAction);'
    ),
    ScriptFunction(
        DataType.VOID,
        'DoPlaceableObjectAction',
        [ScriptParam(DataType.OBJECT, 'oPlaceable', None), ScriptParam(DataType.INT, 'nPlaceableAction', None), ],
        '// 547: The caller performs nPlaceableAction on oPlaceable.\r\n// - oPlaceable\r\n// - nPlaceableAction: PLACEABLE_ACTION_*\r\nvoid DoPlaceableObjectAction(object oPlaceable, int nPlaceableAction);',
        '// 547: The caller performs nPlaceableAction on oPlaceable.\r\n// - oPlaceable\r\n// - nPlaceableAction: PLACEABLE_ACTION_*\r\nvoid DoPlaceableObjectAction(object oPlaceable, int nPlaceableAction);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFirstPC',
        [],
        '// 548: Get the first PC in the player list.\r\n// This resets the position in the player list for GetNextPC().\r\nobject GetFirstPC();',
        '// 548: Get the first PC in the player list.\r\n// This resets the position in the player list for GetNextPC().\r\nobject GetFirstPC();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetNextPC',
        [],
        '// 549: Get the next PC in the player list.\r\n// This picks up where the last GetFirstPC() or GetNextPC() left off.\r\nobject GetNextPC();',
        '// 549: Get the next PC in the player list.\r\n// This picks up where the last GetFirstPC() or GetNextPC() left off.\r\nobject GetNextPC();'
    ),
    ScriptFunction(
        DataType.INT,
        'SetTrapDetectedBy',
        [ScriptParam(DataType.OBJECT, 'oTrap', None), ScriptParam(DataType.OBJECT, 'oDetector', None), ],
        '// 550: Set oDetector to have detected oTrap.\r\nint SetTrapDetectedBy(object oTrap, object oDetector);',
        '// 550: Set oDetector to have detected oTrap.\r\nint SetTrapDetectedBy(object oTrap, object oDetector);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetIsTrapped',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 551: Note: Only placeables, doors and triggers can be trapped.\r\n// * Returns TRUE if oObject is trapped.\r\nint GetIsTrapped(object oObject);',
        '// 551: Note: Only placeables, doors and triggers can be trapped.\r\n// * Returns TRUE if oObject is trapped.\r\nint GetIsTrapped(object oObject);'
    ),
    ScriptFunction(
        DataType.EFFECT,
        'SetEffectIcon',
        [ScriptParam(DataType.EFFECT, 'eEffect', None), ScriptParam(DataType.INT, 'nIcon', None), ],
        '// 552: SetEffectIcon\r\n// This will link the specified effect icon to the specified effect.  The\r\n// effect returned will contain the link to the effect icon and applying this\r\n// effect will cause an effect icon to appear on the portrait/charsheet gui.\r\n// eEffect: The effect which should cause the effect icon to appear.\r\n// nIcon: Index into effecticon.2da of the effect icon to use.\r\neffect SetEffectIcon( effect eEffect, int nIcon );',
        '// 552: SetEffectIcon\r\n// This will link the specified effect icon to the specified effect.  The\r\n// effect returned will contain the link to the effect icon and applying this\r\n// effect will cause an effect icon to appear on the portrait/charsheet gui.\r\n// eEffect: The effect which should cause the effect icon to appear.\r\n// nIcon: Index into effecticon.2da of the effect icon to use.\r\neffect SetEffectIcon( effect eEffect, int nIcon );'
    ),
    ScriptFunction(
        DataType.VOID,
        'FaceObjectAwayFromObject',
        [ScriptParam(DataType.OBJECT, 'oFacer', None), ScriptParam(DataType.OBJECT, 'oObjectToFaceAwayFrom', None), ],
        '// 553: FaceObjectAwayFromObject\r\n// This will cause the object oFacer to face away from oObjectToFaceAwayFrom.\r\n// The objects must be in the same area for this to work.\r\nvoid FaceObjectAwayFromObject( object oFacer, object oObjectToFaceAwayFrom );',
        '// 553: FaceObjectAwayFromObject\r\n// This will cause the object oFacer to face away from oObjectToFaceAwayFrom.\r\n// The objects must be in the same area for this to work.\r\nvoid FaceObjectAwayFromObject( object oFacer, object oObjectToFaceAwayFrom );'
    ),
    ScriptFunction(
        DataType.VOID,
        'PopUpDeathGUIPanel',
        [ScriptParam(DataType.OBJECT, 'oPC', None), ScriptParam(DataType.INT, 'bRespawnButtonEnabled', 1), ScriptParam(DataType.INT, 'bWaitForHelpButtonEnabled', 1), ScriptParam(DataType.INT, 'nHelpStringReference', 0), ScriptParam(DataType.STRING, 'sHelpString', ''), ],
        '// 554: Spawn in the Death GUI.\r\n// The default (as defined by BioWare) can be spawned in by PopUpGUIPanel, but\r\n// if you want to turn off the "Respawn" or "Wait for Help" buttons, this is the\r\n// function to use.\r\n// - oPC\r\n// - bRespawnButtonEnabled: if this is TRUE, the "Respawn" button will be enabled\r\n//   on the Death GUI.\r\n// - bWaitForHelpButtonEnabled: if this is TRUE, the "Wait For Help" button will\r\n//   be enabled on the Death GUI.\r\n// - nHelpStringReference\r\n// - sHelpString\r\nvoid PopUpDeathGUIPanel(object oPC, int bRespawnButtonEnabled = TRUE, int bWaitForHelpButtonEnabled = TRUE, int nHelpStringReference = 0, string sHelpString = "");',
        '// 554: Spawn in the Death GUI.\r\n// The default (as defined by BioWare) can be spawned in by PopUpGUIPanel, but\r\n// if you want to turn off the "Respawn" or "Wait for Help" buttons, this is the\r\n// function to use.\r\n// - oPC\r\n// - bRespawnButtonEnabled: if this is TRUE, the "Respawn" button will be enabled\r\n//   on the Death GUI.\r\n// - bWaitForHelpButtonEnabled: if this is TRUE, the "Wait For Help" button will\r\n//   be enabled on the Death GUI.\r\n// - nHelpStringReference\r\n// - sHelpString\r\nvoid PopUpDeathGUIPanel(object oPC, int bRespawnButtonEnabled = TRUE, int bWaitForHelpButtonEnabled = TRUE, int nHelpStringReference = 0, string sHelpString = "");'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetTrapDisabled',
        [ScriptParam(DataType.OBJECT, 'oTrap', None), ],
        '// 555: Disable oTrap.\r\n// - oTrap: a placeable, door or trigger.\r\nvoid SetTrapDisabled(object oTrap);',
        '// 555: Disable oTrap.\r\n// - oTrap: a placeable, door or trigger.\r\nvoid SetTrapDisabled(object oTrap);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetLastHostileActor',
        [ScriptParam(DataType.OBJECT, 'oVictim', 0), ],
        '// 556: Get the last object that was sent as a GetLastAttacker(), GetLastDamager(),\r\n// GetLastSpellCaster() (for a hostile spell), or GetLastDisturbed() (when a\r\n// creature is pickpocketed).\r\n// Note: Return values may only ever be:\r\n// 1) A Creature\r\n// 2) Plot Characters will never have this value set\r\n// 3) Area of Effect Objects will return the AOE creator if they are registered\r\n//    as this value, otherwise they will return INVALID_OBJECT_ID\r\n// 4) Traps will not return the creature that set the trap.\r\n// 5) This value will never be overwritten by another non-creature object.\r\n// 6) This value will never be a dead/destroyed creature\r\nobject GetLastHostileActor(object oVictim = OBJECT_SELF);',
        '// 556: Get the last object that was sent as a GetLastAttacker(), GetLastDamager(),\r\n// GetLastSpellCaster() (for a hostile spell), or GetLastDisturbed() (when a\r\n// creature is pickpocketed).\r\n// Note: Return values may only ever be:\r\n// 1) A Creature\r\n// 2) Plot Characters will never have this value set\r\n// 3) Area of Effect Objects will return the AOE creator if they are registered\r\n//    as this value, otherwise they will return INVALID_OBJECT_ID\r\n// 4) Traps will not return the creature that set the trap.\r\n// 5) This value will never be overwritten by another non-creature object.\r\n// 6) This value will never be a dead/destroyed creature\r\nobject GetLastHostileActor(object oVictim = OBJECT_SELF);'
    ),
    ScriptFunction(
        DataType.VOID,
        'ExportAllCharacters',
        [],
        '// 557: Force all the characters of the players who are currently in the game to\r\n// be exported to their respective directories i.e. LocalVault/ServerVault/ etc.\r\nvoid ExportAllCharacters();',
        '// 557: Force all the characters of the players who are currently in the game to\r\n// be exported to their respective directories i.e. LocalVault/ServerVault/ etc.\r\nvoid ExportAllCharacters();'
    ),
    ScriptFunction(
        DataType.INT,
        'MusicBackgroundGetDayTrack',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ],
        '// 558: Get the Day Track for oArea.\r\nint MusicBackgroundGetDayTrack(object oArea);',
        '// 558: Get the Day Track for oArea.\r\nint MusicBackgroundGetDayTrack(object oArea);'
    ),
    ScriptFunction(
        DataType.INT,
        'MusicBackgroundGetNightTrack',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ],
        '// 559: Get the Night Track for oArea.\r\nint MusicBackgroundGetNightTrack(object oArea);',
        '// 559: Get the Night Track for oArea.\r\nint MusicBackgroundGetNightTrack(object oArea);'
    ),
    ScriptFunction(
        DataType.VOID,
        'WriteTimestampedLogEntry',
        [ScriptParam(DataType.STRING, 'sLogEntry', None), ],
        '// 560: Write sLogEntry as a timestamped entry into the log file\r\nvoid WriteTimestampedLogEntry(string sLogEntry);',
        '// 560: Write sLogEntry as a timestamped entry into the log file\r\nvoid WriteTimestampedLogEntry(string sLogEntry);'
    ),
    ScriptFunction(
        DataType.STRING,
        'GetModuleName',
        [],
        "// 561: Get the module's name in the language of the server that's running it.\r\n// * If there is no entry for the language of the server, it will return an\r\n//   empty string\r\nstring GetModuleName();",
        "// 561: Get the module's name in the language of the server that's running it.\r\n// * If there is no entry for the language of the server, it will return an\r\n//   empty string\r\nstring GetModuleName();"
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetFactionLeader',
        [ScriptParam(DataType.OBJECT, 'oMemberOfFaction', None), ],
        '// 562: Get the leader of the faction of which oMemberOfFaction is a member.\r\n// * Returns OBJECT_INVALID if oMemberOfFaction is not a valid creature.\r\nobject GetFactionLeader(object oMemberOfFaction);',
        '// 562: Get the leader of the faction of which oMemberOfFaction is a member.\r\n// * Returns OBJECT_INVALID if oMemberOfFaction is not a valid creature.\r\nobject GetFactionLeader(object oMemberOfFaction);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_SetSpeedBlurEffect',
        [ScriptParam(DataType.INT, 'bEnabled', None), ScriptParam(DataType.FLOAT, 'fRatio', 0.75), ],
        '// 563: Turns on or off the speed blur effect in rendered scenes.\r\n// bEnabled: Set TRUE to turn it on, FALSE to turn it off.\r\n// fRatio: Sets the frame accumulation ratio.\r\nvoid SWMG_SetSpeedBlurEffect( int bEnabled, float fRatio = 0.75f );',
        '// 563: Turns on or off the speed blur effect in rendered scenes.\r\n// bEnabled: Set TRUE to turn it on, FALSE to turn it off.\r\n// fRatio: Sets the frame accumulation ratio.\r\nvoid SWMG_SetSpeedBlurEffect( int bEnabled, float fRatio = 0.75f );'
    ),
    ScriptFunction(
        DataType.VOID,
        'EndGame',
        [ScriptParam(DataType.INT, 'nShowEndGameGui', 1), ],
        '// 564: Immediately ends the currently running game and returns to the start screen.\r\n// nShowEndGameGui: Set TRUE to display the death gui.\r\nvoid EndGame( int nShowEndGameGui = TRUE );',
        '// 564: Immediately ends the currently running game and returns to the start screen.\r\n// nShowEndGameGui: Set TRUE to display the death gui.\r\nvoid EndGame( int nShowEndGameGui = TRUE );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetRunScriptVar',
        [],
        '// 565: Get a variable passed when calling console debug runscript\r\nint GetRunScriptVar();',
        '// 565: Get a variable passed when calling console debug runscript\r\nint GetRunScriptVar();'
    ),
    ScriptFunction(
        DataType.INT,
        'GetCreatureMovmentType',
        [ScriptParam(DataType.OBJECT, 'oidCreature', None), ],
        '// 566: This function returns a value that matches one of the MOVEMENT_SPEED_... constants\r\n//      if the OID passed in is not found or not a creature then it will return\r\n//  MOVEMENT_SPEED_IMMOBILE.\r\nint GetCreatureMovmentType(object oidCreature);',
        '// 566: This function returns a value that matches one of the MOVEMENT_SPEED_... constants\r\n//      if the OID passed in is not found or not a creature then it will return\r\n//  MOVEMENT_SPEED_IMMOBILE.\r\nint GetCreatureMovmentType(object oidCreature);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AmbientSoundSetDayVolume',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.INT, 'nVolume', None), ],
        '// 567: Set the ambient day volume for oArea to nVolume.\r\n// - oArea\r\n// - nVolume: 0 - 100\r\nvoid AmbientSoundSetDayVolume(object oArea, int nVolume);',
        '// 567: Set the ambient day volume for oArea to nVolume.\r\n// - oArea\r\n// - nVolume: 0 - 100\r\nvoid AmbientSoundSetDayVolume(object oArea, int nVolume);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AmbientSoundSetNightVolume',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ScriptParam(DataType.INT, 'nVolume', None), ],
        '// 568: Set the ambient night volume for oArea to nVolume.\r\n// - oArea\r\n// - nVolume: 0 - 100\r\nvoid AmbientSoundSetNightVolume(object oArea, int nVolume);',
        '// 568: Set the ambient night volume for oArea to nVolume.\r\n// - oArea\r\n// - nVolume: 0 - 100\r\nvoid AmbientSoundSetNightVolume(object oArea, int nVolume);'
    ),
    ScriptFunction(
        DataType.INT,
        'MusicBackgroundGetBattleTrack',
        [ScriptParam(DataType.OBJECT, 'oArea', None), ],
        '// 569: Get the Battle Track for oArea.\r\nint MusicBackgroundGetBattleTrack(object oArea);',
        '// 569: Get the Battle Track for oArea.\r\nint MusicBackgroundGetBattleTrack(object oArea);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetHasInventory',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ],
        '// 570: Determine whether oObject has an inventory.\r\n// * Returns TRUE for creatures and stores, and checks to see if an item or placeable object is a container.\r\n// * Returns FALSE for all other object types.\r\nint GetHasInventory(object oObject);',
        '// 570: Determine whether oObject has an inventory.\r\n// * Returns TRUE for creatures and stores, and checks to see if an item or placeable object is a container.\r\n// * Returns FALSE for all other object types.\r\nint GetHasInventory(object oObject);'
    ),
    ScriptFunction(
        DataType.FLOAT,
        'GetStrRefSoundDuration',
        [ScriptParam(DataType.INT, 'nStrRef', None), ],
        '// 571: Get the duration (in seconds) of the sound attached to nStrRef\r\n// * Returns 0.0f if no duration is stored or if no sound is attached\r\nfloat GetStrRefSoundDuration(int nStrRef);',
        '// 571: Get the duration (in seconds) of the sound attached to nStrRef\r\n// * Returns 0.0f if no duration is stored or if no sound is attached\r\nfloat GetStrRefSoundDuration(int nStrRef);'
    ),
    ScriptFunction(
        DataType.VOID,
        'AddToParty',
        [ScriptParam(DataType.OBJECT, 'oPC', None), ScriptParam(DataType.OBJECT, 'oPartyLeader', None), ],
        "// 572: Add oPC to oPartyLeader's party.  This will only work on two PCs.\r\n// - oPC: player to add to a party\r\n// - oPartyLeader: player already in the party\r\nvoid AddToParty(object oPC, object oPartyLeader);",
        "// 572: Add oPC to oPartyLeader's party.  This will only work on two PCs.\r\n// - oPC: player to add to a party\r\n// - oPartyLeader: player already in the party\r\nvoid AddToParty(object oPC, object oPartyLeader);"
    ),
    ScriptFunction(
        DataType.VOID,
        'RemoveFromParty',
        [ScriptParam(DataType.OBJECT, 'oPC', None), ],
        "// 573: Remove oPC from their current party. This will only work on a PC.\r\n// - oPC: removes this player from whatever party they're currently in.\r\nvoid RemoveFromParty(object oPC);",
        "// 573: Remove oPC from their current party. This will only work on a PC.\r\n// - oPC: removes this player from whatever party they're currently in.\r\nvoid RemoveFromParty(object oPC);"
    ),
    ScriptFunction(
        DataType.INT,
        'AddPartyMember',
        [ScriptParam(DataType.INT, 'nNPC', None), ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 574: Adds a creature to the party\r\n// Returns whether the addition was successful\r\n// AddPartyMember\r\nint AddPartyMember(int nNPC, object oCreature);',
        '// 574: Adds a creature to the party\r\n// Returns whether the addition was successful\r\n// AddPartyMember\r\nint AddPartyMember(int nNPC, object oCreature);'
    ),
    ScriptFunction(
        DataType.INT,
        'RemovePartyMember',
        [ScriptParam(DataType.INT, 'nNPC', None), ],
        '// 575: Removes a creature from the party\r\n// Returns whether the removal was syccessful\r\n// RemovePartyMember\r\nint RemovePartyMember(int nNPC);',
        '// 575: Removes a creature from the party\r\n// Returns whether the removal was syccessful\r\n// RemovePartyMember\r\nint RemovePartyMember(int nNPC);'
    ),
    ScriptFunction(
        DataType.INT,
        'IsObjectPartyMember',
        [ScriptParam(DataType.OBJECT, 'oCreature', None), ],
        '// 576: Returns whether a specified creature is a party member\r\n// IsObjectPartyMember\r\nint IsObjectPartyMember(object oCreature);',
        '// 576: Returns whether a specified creature is a party member\r\n// IsObjectPartyMember\r\nint IsObjectPartyMember(object oCreature);'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'GetPartyMemberByIndex',
        [ScriptParam(DataType.INT, 'nIndex', None), ],
        '// 577: Returns the party member at a given index in the party.\r\n// The order of members in the party can vary based on\r\n// who the current leader is (member 0 is always the current\r\n// party leader).\r\n// GetPartyMemberByIndex\r\nobject GetPartyMemberByIndex(int nIndex);',
        '// 577: Returns the party member at a given index in the party.\r\n// The order of members in the party can vary based on\r\n// who the current leader is (member 0 is always the current\r\n// party leader).\r\n// GetPartyMemberByIndex\r\nobject GetPartyMemberByIndex(int nIndex);'
    ),
    ScriptFunction(
        DataType.INT,
        'GetGlobalBoolean',
        [ScriptParam(DataType.STRING, 'sIdentifier', None), ],
        '// 578: GetGlobalBoolean\r\n// This function returns the value of a global boolean (TRUE or FALSE) scripting variable.\r\nint GetGlobalBoolean( string sIdentifier );',
        '// 578: GetGlobalBoolean\r\n// This function returns the value of a global boolean (TRUE or FALSE) scripting variable.\r\nint GetGlobalBoolean( string sIdentifier );'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetGlobalBoolean',
        [ScriptParam(DataType.STRING, 'sIdentifier', None), ScriptParam(DataType.INT, 'nValue', None), ],
        '// 579: SetGlobalBoolean\r\n// This function sets the value of a global boolean (TRUE or FALSE) scripting variable.\r\nvoid SetGlobalBoolean( string sIdentifier, int nValue );',
        '// 579: SetGlobalBoolean\r\n// This function sets the value of a global boolean (TRUE or FALSE) scripting variable.\r\nvoid SetGlobalBoolean( string sIdentifier, int nValue );'
    ),
    ScriptFunction(
        DataType.INT,
        'GetGlobalNumber',
        [ScriptParam(DataType.STRING, 'sIdentifier', None), ],
        '// 580: GetGlobalNumber\r\n// This function returns the value of a global number (-128 to +127) scripting variable.\r\nint GetGlobalNumber( string sIdentifier );',
        '// 580: GetGlobalNumber\r\n// This function returns the value of a global number (-128 to +127) scripting variable.\r\nint GetGlobalNumber( string sIdentifier );'
    ),
    ScriptFunction(
        DataType.VOID,
        'SetGlobalNumber',
        [ScriptParam(DataType.STRING, 'sIdentifier', None), ScriptParam(DataType.INT, 'nValue', None), ],
        '// 581: SetGlobalNumber\r\n// This function sets the value of a global number (-128 to +127) scripting variable.\r\nvoid SetGlobalNumber( string sIdentifier, int nValue );',
        '// 581: SetGlobalNumber\r\n// This function sets the value of a global number (-128 to +127) scripting variable.\r\nvoid SetGlobalNumber( string sIdentifier, int nValue );'
    ),
    ScriptFunction(
        DataType.VOID,
        'AurPostString',
        [ScriptParam(DataType.STRING, 'sString', None), ScriptParam(DataType.INT, 'nX', None), ScriptParam(DataType.INT, 'nY', None), ScriptParam(DataType.FLOAT, 'fLife', None), ],
        '// 582. AurPostString\r\nvoid AurPostString(string sString, int nX, int nY, float fLife);',
        '// 582. AurPostString\r\nvoid AurPostString(string sString, int nX, int nY, float fLife);'
    ),
    ScriptFunction(
        DataType.STRING,
        'SWMG_GetLastEvent',
        [],
        '// 583: OnAnimKey\r\n// get the event and the name of the model on which the event happened\r\n// SWMG_GetLastEvent\r\nstring SWMG_GetLastEvent();',
        '// 583: OnAnimKey\r\n// get the event and the name of the model on which the event happened\r\n// SWMG_GetLastEvent\r\nstring SWMG_GetLastEvent();'
    ),
    ScriptFunction(
        DataType.STRING,
        'SWMG_GetLastEventModelName',
        [],
        '// 584: SWMG_GetLastEventModelName\r\nstring SWMG_GetLastEventModelName();',
        '// 584: SWMG_GetLastEventModelName\r\nstring SWMG_GetLastEventModelName();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'SWMG_GetObjectByName',
        [ScriptParam(DataType.STRING, 'sName', None), ],
        '// 585: gets an object by its name (duh!)\r\n// SWMG_GetObjectByName\r\nobject SWMG_GetObjectByName(string sName);',
        '// 585: gets an object by its name (duh!)\r\n// SWMG_GetObjectByName\r\nobject SWMG_GetObjectByName(string sName);'
    ),
    ScriptFunction(
        DataType.VOID,
        'SWMG_PlayAnimation',
        [ScriptParam(DataType.OBJECT, 'oObject', None), ScriptParam(DataType.STRING, 'sAnimName', None), ScriptParam(DataType.INT, 'bLooping', 1), ScriptParam(DataType.INT, 'bQueue', 0), ScriptParam(DataType.INT, 'bOverlay', 0), ],
        '// 586: plays an animation on an object\r\n// SWMG_PlayAnimation\r\nvoid SWMG_PlayAnimation(object oObject, string sAnimName, int bLooping = 1, int bQueue = 0, int bOverlay = 0);',
        '// 586: plays an animation on an object\r\n// SWMG_PlayAnimation\r\nvoid SWMG_PlayAnimation(object oObject, string sAnimName, int bLooping = 1, int bQueue = 0, int bOverlay = 0);'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetLastBulletHitDamage',
        [],
        '// 587: OnHitBullet\r\n// get the damage, the target type (see TARGETflags), and the shooter\r\n// SWMG_GetLastBulletHitDamage\r\nint SWMG_GetLastBulletHitDamage();',
        '// 587: OnHitBullet\r\n// get the damage, the target type (see TARGETflags), and the shooter\r\n// SWMG_GetLastBulletHitDamage\r\nint SWMG_GetLastBulletHitDamage();'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_GetLastBulletHitTarget',
        [],
        '// 588: SWMG_GetLastBulletHitTarget\r\nint SWMG_GetLastBulletHitTarget();',
        '// 588: SWMG_GetLastBulletHitTarget\r\nint SWMG_GetLastBulletHitTarget();'
    ),
    ScriptFunction(
        DataType.OBJECT,
        'SWMG_GetLastBulletHitShooter',
        [],
        '// 589: SWMG_GetLastBulletHitShooter\r\nobject SWMG_GetLastBulletHitShooter();',
        '// 589: SWMG_GetLastBulletHitShooter\r\nobject SWMG_GetLastBulletHitShooter();'
    ),
    ScriptFunction(
        DataType.INT,
        'SWMG_AdjustFollowerHitPoints',
        [ScriptParam(DataType.OBJECT, 'oFollower', None), ScriptParam(DataType.INT, 'nHP', None), ScriptParam(DataType.INT, 'nAbsolute', 0), ],
    