"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.awsCredentialStep = void 0;
function awsCredentialStep(stepName, props) {
    var _a;
    const params = {};
    // Neither of these checks should occur, since this method is internal,
    // but they are here just in case.
    if (!props.gitHubActionRoleArn && !(props.accessKeyId && props.secretAccessKey)) {
        throw new Error('AWS authentication not found via OIDC or GitHub secrets');
    }
    if (props.gitHubActionRoleArn && (props.accessKeyId || props.secretAccessKey)) {
        throw new Error('Please provide one method of authentication, not both');
    }
    params['aws-region'] = props.region;
    params['role-duration-seconds'] = 30 * 60;
    // Session tagging requires the role to have `sts:TagSession` permissions,
    // which CDK bootstrapped roles do not currently have.
    params['role-skip-session-tagging'] = (_a = props.roleSkipSessionTagging) !== null && _a !== void 0 ? _a : true;
    if (props.gitHubActionRoleArn) {
        params['role-to-assume'] = props.gitHubActionRoleArn;
    }
    else {
        params['aws-access-key-id'] = props.accessKeyId;
        params['aws-secret-access-key'] = props.secretAccessKey;
        if (props.sessionToken) {
            params['aws-session-token'] = props.sessionToken;
        }
        if (props.roleToAssume) {
            params['role-to-assume'] = props.roleToAssume;
            params['role-external-id'] = 'Pipeline';
        }
    }
    return {
        name: stepName,
        uses: 'aws-actions/configure-aws-credentials@v1',
        with: params,
    };
}
exports.awsCredentialStep = awsCredentialStep;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzLWNyZWRlbnRpYWxzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3ByaXZhdGUvYXdzLWNyZWRlbnRpYWxzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQXVEQSxTQUFnQixpQkFBaUIsQ0FBQyxRQUFnQixFQUFFLEtBQThCOztJQUNoRixNQUFNLE1BQU0sR0FBd0IsRUFBRSxDQUFDO0lBRXZDLHVFQUF1RTtJQUN2RSxrQ0FBa0M7SUFDbEMsSUFBSSxDQUFDLEtBQUssQ0FBQyxtQkFBbUIsSUFBSSxDQUFDLENBQUMsS0FBSyxDQUFDLFdBQVcsSUFBSSxLQUFLLENBQUMsZUFBZSxDQUFDLEVBQUU7UUFDL0UsTUFBTSxJQUFJLEtBQUssQ0FBQyx5REFBeUQsQ0FBQyxDQUFDO0tBQzVFO0lBRUQsSUFBSSxLQUFLLENBQUMsbUJBQW1CLElBQUksQ0FBQyxLQUFLLENBQUMsV0FBVyxJQUFJLEtBQUssQ0FBQyxlQUFlLENBQUMsRUFBRTtRQUM3RSxNQUFNLElBQUksS0FBSyxDQUFDLHVEQUF1RCxDQUFDLENBQUM7S0FDMUU7SUFFRCxNQUFNLENBQUMsWUFBWSxDQUFDLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztJQUNwQyxNQUFNLENBQUMsdUJBQXVCLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxDQUFDO0lBQzFDLDBFQUEwRTtJQUMxRSxzREFBc0Q7SUFDdEQsTUFBTSxDQUFDLDJCQUEyQixDQUFDLFNBQUcsS0FBSyxDQUFDLHNCQUFzQixtQ0FBSSxJQUFJLENBQUM7SUFFM0UsSUFBSSxLQUFLLENBQUMsbUJBQW1CLEVBQUU7UUFDN0IsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsS0FBSyxDQUFDLG1CQUFtQixDQUFDO0tBQ3REO1NBQU07UUFDTCxNQUFNLENBQUMsbUJBQW1CLENBQUMsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1FBQ2hELE1BQU0sQ0FBQyx1QkFBdUIsQ0FBQyxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7UUFFeEQsSUFBSSxLQUFLLENBQUMsWUFBWSxFQUFFO1lBQ3RCLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7U0FDbEQ7UUFFRCxJQUFJLEtBQUssQ0FBQyxZQUFZLEVBQUU7WUFDdEIsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztZQUM5QyxNQUFNLENBQUMsa0JBQWtCLENBQUMsR0FBRyxVQUFVLENBQUM7U0FDekM7S0FDRjtJQUVELE9BQU87UUFDTCxJQUFJLEVBQUUsUUFBUTtRQUNkLElBQUksRUFBRSwwQ0FBMEM7UUFDaEQsSUFBSSxFQUFFLE1BQU07S0FDYixDQUFDO0FBQ0osQ0FBQztBQXhDRCw4Q0F3Q0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBnaXRodWIgZnJvbSAnLi4vd29ya2Zsb3dzLW1vZGVsJztcblxuaW50ZXJmYWNlIEF3c0NyZWRlbnRpYWxzU3RlcFByb3BzIHtcbiAgLyoqXG4gICAqIEBkZWZhdWx0IHVuZGVmaW5lZFxuICAgKi9cbiAgcmVhZG9ubHkgcm9sZVRvQXNzdW1lPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBAZGVmYXVsdCB1bmRlZmluZWRcbiAgICovXG4gIHJlYWRvbmx5IHJvbGVFeHRlcm5hbElkPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSByb2xlU2tpcFNlc3Npb25UYWdnaW5nPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogVGhlIEdpdEh1YiBBY3Rpb24gcm9sZSBhcm4sIGlmIHdlIGFyZSB1c2luZyBPSURDIHRvIGF1dGhlbnRpY2F0ZS4gVGhlIG90aGVyIG9wdGlvblxuICAgKiB0byBhdXRoZW50aWNhdGUgaXMgd2l0aCBgYWNjZXNzS2V5SWRgIGFuZCBgc2VjcmV0QWNjZXNzS2V5YC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBPSURDIG5vdCB1c2VkIGFuZCBgYWNjZXNzS2V5SWRgIGFuZCBgc2VjcmV0QWNjZXNzS2V5YCBhcmUgZXhwZWN0ZWQuXG4gICAqL1xuICByZWFkb25seSBnaXRIdWJBY3Rpb25Sb2xlQXJuPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgQVdTIFJlZ2lvbi5cbiAgICovXG4gIHJlYWRvbmx5IHJlZ2lvbjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUbyBhdXRoZW50aWNhdGUgdmlhIEdpdEh1YiBzZWNyZXRzLCBhdCBsZWFzdCB0aGlzIGFuZCBgc2VjcmV0QWNjZXNzS2V5YCBtdXN0XG4gICAqIGJlIHByb3ZpZGVkLiBBbHRlcm5hdGl2ZWx5LCBwcm92aWRlIGp1c3QgYW4gYG9pZGNSb2xlQXJuYC5cbiAgICpcbiAgICogQGRlZmF1bHQgdW5kZWZpbmVkXG4gICAqL1xuICByZWFkb25seSBhY2Nlc3NLZXlJZD86IHN0cmluZztcblxuICAvKipcbiAgICogVG8gYXV0aGVudGljYXRlIHZpYSBHaXRIdWIgc2VjcmV0cywgYXQgbGVhc3QgdGhpcyBhbmQgYGFjY2Vzc0tleUlkYCBtdXN0XG4gICAqIGJlIHByb3ZpZGVkLiBBbHRlcm5hdGl2ZWx5LCBwcm92aWRlIGp1c3QgYW4gYG9pZGNSb2xlQXJuYC5cbiAgICpcbiAgICogQGRlZmF1bHQgdW5kZWZpbmVkXG4gICAqL1xuICByZWFkb25seSBzZWNyZXRBY2Nlc3NLZXk/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFByb3ZpZGUgYW4gQVdTIHNlc3Npb24gdG9rZW4uXG4gICAqXG4gICAqIEBkZWZhdWx0IHVuZGVmaW5lZFxuICAgKi9cbiAgcmVhZG9ubHkgc2Vzc2lvblRva2VuPzogc3RyaW5nO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gYXdzQ3JlZGVudGlhbFN0ZXAoc3RlcE5hbWU6IHN0cmluZywgcHJvcHM6IEF3c0NyZWRlbnRpYWxzU3RlcFByb3BzKTogZ2l0aHViLkpvYlN0ZXAge1xuICBjb25zdCBwYXJhbXM6IFJlY29yZDxzdHJpbmcsIGFueT4gPSB7fTtcblxuICAvLyBOZWl0aGVyIG9mIHRoZXNlIGNoZWNrcyBzaG91bGQgb2NjdXIsIHNpbmNlIHRoaXMgbWV0aG9kIGlzIGludGVybmFsLFxuICAvLyBidXQgdGhleSBhcmUgaGVyZSBqdXN0IGluIGNhc2UuXG4gIGlmICghcHJvcHMuZ2l0SHViQWN0aW9uUm9sZUFybiAmJiAhKHByb3BzLmFjY2Vzc0tleUlkICYmIHByb3BzLnNlY3JldEFjY2Vzc0tleSkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ0FXUyBhdXRoZW50aWNhdGlvbiBub3QgZm91bmQgdmlhIE9JREMgb3IgR2l0SHViIHNlY3JldHMnKTtcbiAgfVxuXG4gIGlmIChwcm9wcy5naXRIdWJBY3Rpb25Sb2xlQXJuICYmIChwcm9wcy5hY2Nlc3NLZXlJZCB8fCBwcm9wcy5zZWNyZXRBY2Nlc3NLZXkpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKCdQbGVhc2UgcHJvdmlkZSBvbmUgbWV0aG9kIG9mIGF1dGhlbnRpY2F0aW9uLCBub3QgYm90aCcpO1xuICB9XG5cbiAgcGFyYW1zWydhd3MtcmVnaW9uJ10gPSBwcm9wcy5yZWdpb247XG4gIHBhcmFtc1sncm9sZS1kdXJhdGlvbi1zZWNvbmRzJ10gPSAzMCAqIDYwO1xuICAvLyBTZXNzaW9uIHRhZ2dpbmcgcmVxdWlyZXMgdGhlIHJvbGUgdG8gaGF2ZSBgc3RzOlRhZ1Nlc3Npb25gIHBlcm1pc3Npb25zLFxuICAvLyB3aGljaCBDREsgYm9vdHN0cmFwcGVkIHJvbGVzIGRvIG5vdCBjdXJyZW50bHkgaGF2ZS5cbiAgcGFyYW1zWydyb2xlLXNraXAtc2Vzc2lvbi10YWdnaW5nJ10gPSBwcm9wcy5yb2xlU2tpcFNlc3Npb25UYWdnaW5nID8/IHRydWU7XG5cbiAgaWYgKHByb3BzLmdpdEh1YkFjdGlvblJvbGVBcm4pIHtcbiAgICBwYXJhbXNbJ3JvbGUtdG8tYXNzdW1lJ10gPSBwcm9wcy5naXRIdWJBY3Rpb25Sb2xlQXJuO1xuICB9IGVsc2Uge1xuICAgIHBhcmFtc1snYXdzLWFjY2Vzcy1rZXktaWQnXSA9IHByb3BzLmFjY2Vzc0tleUlkO1xuICAgIHBhcmFtc1snYXdzLXNlY3JldC1hY2Nlc3Mta2V5J10gPSBwcm9wcy5zZWNyZXRBY2Nlc3NLZXk7XG5cbiAgICBpZiAocHJvcHMuc2Vzc2lvblRva2VuKSB7XG4gICAgICBwYXJhbXNbJ2F3cy1zZXNzaW9uLXRva2VuJ10gPSBwcm9wcy5zZXNzaW9uVG9rZW47XG4gICAgfVxuXG4gICAgaWYgKHByb3BzLnJvbGVUb0Fzc3VtZSkge1xuICAgICAgcGFyYW1zWydyb2xlLXRvLWFzc3VtZSddID0gcHJvcHMucm9sZVRvQXNzdW1lO1xuICAgICAgcGFyYW1zWydyb2xlLWV4dGVybmFsLWlkJ10gPSAnUGlwZWxpbmUnO1xuICAgIH1cbiAgfVxuXG4gIHJldHVybiB7XG4gICAgbmFtZTogc3RlcE5hbWUsXG4gICAgdXNlczogJ2F3cy1hY3Rpb25zL2NvbmZpZ3VyZS1hd3MtY3JlZGVudGlhbHNAdjEnLFxuICAgIHdpdGg6IHBhcmFtcyxcbiAgfTtcbn0iXX0=