"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TreeInspector = void 0;
/**
 * Inspector that maintains an attribute bag
 */
class TreeInspector {
    constructor() {
        /**
         * Represents the bag of attributes as key-value pairs.
         */
        this.attributes = {};
    }
    /**
     * Adds attribute to bag. Keys should be added by convention to prevent conflicts
     *
     * @param key - key for metadata
     * @param value - value of metadata.
     */
    addAttribute(key, value) {
        this.attributes[key] = value;
    }
}
exports.TreeInspector = TreeInspector;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHJlZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRyZWUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUE7O0dBRUc7QUFDSCxNQUFhLGFBQWE7SUFBMUI7UUFDRTs7V0FFRztRQUNhLGVBQVUsR0FBMkIsRUFBRSxDQUFDO0lBVzFELENBQUM7SUFUQzs7Ozs7T0FLRztJQUNJLFlBQVksQ0FBQyxHQUFXLEVBQUUsS0FBVTtRQUN6QyxJQUFJLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxHQUFHLEtBQUssQ0FBQztJQUMvQixDQUFDO0NBQ0Y7QUFmRCxzQ0FlQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxyXG4gKiBJbnNwZWN0b3IgdGhhdCBtYWludGFpbnMgYW4gYXR0cmlidXRlIGJhZ1xyXG4gKi9cclxuZXhwb3J0IGNsYXNzIFRyZWVJbnNwZWN0b3Ige1xyXG4gIC8qKlxyXG4gICAqIFJlcHJlc2VudHMgdGhlIGJhZyBvZiBhdHRyaWJ1dGVzIGFzIGtleS12YWx1ZSBwYWlycy5cclxuICAgKi9cclxuICBwdWJsaWMgcmVhZG9ubHkgYXR0cmlidXRlczogeyBba2V5OiBzdHJpbmddOiBhbnkgfSA9IHt9O1xyXG5cclxuICAvKipcclxuICAgKiBBZGRzIGF0dHJpYnV0ZSB0byBiYWcuIEtleXMgc2hvdWxkIGJlIGFkZGVkIGJ5IGNvbnZlbnRpb24gdG8gcHJldmVudCBjb25mbGljdHNcclxuICAgKlxyXG4gICAqIEBwYXJhbSBrZXkgLSBrZXkgZm9yIG1ldGFkYXRhXHJcbiAgICogQHBhcmFtIHZhbHVlIC0gdmFsdWUgb2YgbWV0YWRhdGEuXHJcbiAgICovXHJcbiAgcHVibGljIGFkZEF0dHJpYnV0ZShrZXk6IHN0cmluZywgdmFsdWU6IGFueSkge1xyXG4gICAgdGhpcy5hdHRyaWJ1dGVzW2tleV0gPSB2YWx1ZTtcclxuICB9XHJcbn1cclxuXHJcbi8qKlxyXG4gKiBJbnRlcmZhY2UgZm9yIGV4YW1pbmluZyBhIGNvbnN0cnVjdCBhbmQgZXhwb3NpbmcgbWV0YWRhdGEuXHJcbiAqXHJcbiAqL1xyXG5leHBvcnQgaW50ZXJmYWNlIElJbnNwZWN0YWJsZSB7XHJcbiAgLyoqXHJcbiAgICogRXhhbWluZXMgY29uc3RydWN0XHJcbiAgICpcclxuICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXHJcbiAgICovXHJcbiAgaW5zcGVjdChpbnNwZWN0b3I6IFRyZWVJbnNwZWN0b3IpOiB2b2lkO1xyXG59XHJcbiJdfQ==