"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.captureStackTrace = void 0;
// tslint:disable-next-line:ban-types
function captureStackTrace(below) {
    if (process.env.CDK_DISABLE_STACK_TRACE) {
        return ["stack traces disabled"];
    }
    below = below || captureStackTrace; // hide myself if nothing else
    const object = { stack: "" };
    const previousLimit = Error.stackTraceLimit;
    try {
        Error.stackTraceLimit = Number.MAX_SAFE_INTEGER;
        Error.captureStackTrace(object, below);
    }
    finally {
        Error.stackTraceLimit = previousLimit;
    }
    if (!object.stack) {
        return [];
    }
    return object.stack
        .split("\n")
        .slice(1)
        .map((s) => s.replace(/^\s*at\s+/, ""));
}
exports.captureStackTrace = captureStackTrace;
//# sourceMappingURL=data:application/json;base64,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