"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultStackSynthesizer = void 0;
const _shared_1 = require("./_shared");
/**
 * Uses conventionally named roles and reify asset storage locations
 */
class DefaultStackSynthesizer {
    // private readonly files: NonNullable<cxschema.AssetManifest['files']> = {};
    constructor() { }
    bind(stack) {
        this._stack = stack;
    }
    synthesizeStackArtifacts(session) {
        _shared_1.assertBound(this.stack);
        const artifactId = this.writeAssetManifest();
        _shared_1.addStackArtifactToAssembly(session, this.stack, {}, [artifactId]);
    }
    get stack() {
        return this._stack;
    }
    /**
     * Write an asset manifest to the Cloud Assembly, return the artifact IDs written
     */
    writeAssetManifest() {
        _shared_1.assertBound(this.stack);
        const artifactId = `${this.stack.artifactId}.assets`;
        return artifactId;
    }
}
exports.DefaultStackSynthesizer = DefaultStackSynthesizer;
/**
 * Default ARN qualifier
 */
DefaultStackSynthesizer.DEFAULT_QUALIFIER = "hnb659fds";
//# sourceMappingURL=data:application/json;base64,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