"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosStack = void 0;
const runtime_1 = require("./runtime");
const tag_manager_1 = require("./tag-manager");
const ros_resource_1 = require("./ros-resource");
const tag_manager_2 = require("./tag-manager");
function rosStackPropsToRosTemplate(properties) {
    if (!runtime_1.canInspect(properties)) {
        return properties;
    }
    return {
        TemplateBody: runtime_1.stringToRosTemplate(properties.templateBody),
        TemplateURL: runtime_1.stringToRosTemplate(properties.templateUrl),
        NotificationARNs: runtime_1.listMapper(runtime_1.stringToRosTemplate)(properties.notificationArns),
        Parameters: runtime_1.hashMapper(runtime_1.stringToRosTemplate)(properties.parameters),
        Tags: runtime_1.listMapper(runtime_1.rosTagToRosTemplate)(properties.tags),
        TimeoutMins: runtime_1.numberToRosTemplate(properties.timeoutMins),
    };
}
class RosStack extends ros_resource_1.RosResource {
    constructor(scope, id, props) {
        super(scope, id, {
            type: RosStack.ROS_RESOURCE_TYPE_NAME,
            properties: props,
        });
        this.templateBody = props.templateBody;
        this.templateUrl = props.templateUrl;
        this.parameters = props.parameters;
        this.tags = new tag_manager_1.TagManager(tag_manager_2.TagType.STANDARD, "ALIYUN::ROS::Stack", props.tags, { tagPropertyName: "tags" });
        this.timeoutMins = props.timeoutMins;
    }
    get rosProperties() {
        return {
            templateBody: this.templateBody,
            templateUrl: this.templateUrl,
            parameters: this.parameters,
            tags: this.tags.renderTags(),
            timeoutMins: this.timeoutMins,
        };
    }
    renderProperties(props) {
        return rosStackPropsToRosTemplate(props);
    }
}
exports.RosStack = RosStack;
RosStack.ROS_RESOURCE_TYPE_NAME = "ALIYUN::ROS::Stack";
//# sourceMappingURL=data:application/json;base64,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