"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosDeletionPolicy = void 0;
/**
 * With the DeletionPolicy attribute you can preserve or (in some cases) backup a resource when its stack is deleted.
 * You specify a DeletionPolicy attribute for each resource that you want to control. If a resource has no DeletionPolicy
 * attribute, ROS deletes the resource by default.
 */
var RosDeletionPolicy;
(function (RosDeletionPolicy) {
    /**
     * ROS will deletes the resource and all its content if applicable during stack deletion.
     * You can add this deletion policy to any resource type.
     */
    RosDeletionPolicy["DELETE"] = "Delete";
    /**
     * ROS keeps the resource without deleting the resource or its contents when its stack is deleted.
     * You can add this deletion policy to any resource type.
     */
    RosDeletionPolicy["RETAIN"] = "Retain";
})(RosDeletionPolicy = exports.RosDeletionPolicy || (exports.RosDeletionPolicy = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicm9zLXJlc291cmNlLXBvbGljeS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInJvcy1yZXNvdXJjZS1wb2xpY3kudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUE7Ozs7R0FJRztBQUNILElBQVksaUJBWVg7QUFaRCxXQUFZLGlCQUFpQjtJQUMzQjs7O09BR0c7SUFDSCxzQ0FBaUIsQ0FBQTtJQUVqQjs7O09BR0c7SUFDSCxzQ0FBaUIsQ0FBQTtBQUNuQixDQUFDLEVBWlcsaUJBQWlCLEdBQWpCLHlCQUFpQixLQUFqQix5QkFBaUIsUUFZNUIiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcclxuICogV2l0aCB0aGUgRGVsZXRpb25Qb2xpY3kgYXR0cmlidXRlIHlvdSBjYW4gcHJlc2VydmUgb3IgKGluIHNvbWUgY2FzZXMpIGJhY2t1cCBhIHJlc291cmNlIHdoZW4gaXRzIHN0YWNrIGlzIGRlbGV0ZWQuXHJcbiAqIFlvdSBzcGVjaWZ5IGEgRGVsZXRpb25Qb2xpY3kgYXR0cmlidXRlIGZvciBlYWNoIHJlc291cmNlIHRoYXQgeW91IHdhbnQgdG8gY29udHJvbC4gSWYgYSByZXNvdXJjZSBoYXMgbm8gRGVsZXRpb25Qb2xpY3lcclxuICogYXR0cmlidXRlLCBST1MgZGVsZXRlcyB0aGUgcmVzb3VyY2UgYnkgZGVmYXVsdC5cclxuICovXHJcbmV4cG9ydCBlbnVtIFJvc0RlbGV0aW9uUG9saWN5IHtcclxuICAvKipcclxuICAgKiBST1Mgd2lsbCBkZWxldGVzIHRoZSByZXNvdXJjZSBhbmQgYWxsIGl0cyBjb250ZW50IGlmIGFwcGxpY2FibGUgZHVyaW5nIHN0YWNrIGRlbGV0aW9uLlxyXG4gICAqIFlvdSBjYW4gYWRkIHRoaXMgZGVsZXRpb24gcG9saWN5IHRvIGFueSByZXNvdXJjZSB0eXBlLlxyXG4gICAqL1xyXG4gIERFTEVURSA9IFwiRGVsZXRlXCIsXHJcblxyXG4gIC8qKlxyXG4gICAqIFJPUyBrZWVwcyB0aGUgcmVzb3VyY2Ugd2l0aG91dCBkZWxldGluZyB0aGUgcmVzb3VyY2Ugb3IgaXRzIGNvbnRlbnRzIHdoZW4gaXRzIHN0YWNrIGlzIGRlbGV0ZWQuXHJcbiAgICogWW91IGNhbiBhZGQgdGhpcyBkZWxldGlvbiBwb2xpY3kgdG8gYW55IHJlc291cmNlIHR5cGUuXHJcbiAgICovXHJcbiAgUkVUQUlOID0gXCJSZXRhaW5cIixcclxufVxyXG4iXX0=