"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosPseudo = void 0;
const token_1 = require("./token");
const ROS_REGION = "ALIYUN::Region";
const ROS_STACKID = "ALIYUN::StackId";
const ROS_STACKNAME = "ALIYUN::StackName";
const ROS_NOVALUE = "ALIYUN::NoValue";
const ROS_ACCOUNTID = "ALIYUN::AccountId";
const ROS_TENANTID = "ALIYUN::TenantId";
/**
 * Accessor for pseudo parameters
 */
class RosPseudo {
    constructor() { }
    static get accountId() {
        return this.asString(ROS_ACCOUNTID);
    }
    static get region() {
        return this.asString(ROS_REGION);
    }
    static get stackId() {
        return this.asString(ROS_STACKID);
    }
    static get stackName() {
        return this.asString(ROS_STACKNAME);
    }
    static get noValue() {
        return this.asString(ROS_NOVALUE);
    }
    static get tenantId() {
        return this.asString(ROS_TENANTID);
    }
    static asString(name) {
        return token_1.Token.asString({ Ref: name }, { displayHint: name });
    }
}
exports.RosPseudo = RosPseudo;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicm9zLXBzZXVkby5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInJvcy1wc2V1ZG8udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsbUNBQWdDO0FBRWhDLE1BQU0sVUFBVSxHQUFHLGdCQUFnQixDQUFDO0FBQ3BDLE1BQU0sV0FBVyxHQUFHLGlCQUFpQixDQUFDO0FBQ3RDLE1BQU0sYUFBYSxHQUFHLG1CQUFtQixDQUFDO0FBQzFDLE1BQU0sV0FBVyxHQUFHLGlCQUFpQixDQUFDO0FBQ3RDLE1BQU0sYUFBYSxHQUFHLG1CQUFtQixDQUFDO0FBQzFDLE1BQU0sWUFBWSxHQUFHLGtCQUFrQixDQUFDO0FBRXhDOztHQUVHO0FBQ0gsTUFBYSxTQUFTO0lBQ3BCLGdCQUF1QixDQUFDO0lBRWpCLE1BQU0sS0FBSyxTQUFTO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUN0QyxDQUFDO0lBRU0sTUFBTSxLQUFLLE1BQU07UUFDdEIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ25DLENBQUM7SUFFTSxNQUFNLEtBQUssT0FBTztRQUN2QixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDcEMsQ0FBQztJQUVNLE1BQU0sS0FBSyxTQUFTO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUN0QyxDQUFDO0lBRU0sTUFBTSxLQUFLLE9BQU87UUFDdkIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQ3BDLENBQUM7SUFFTSxNQUFNLEtBQUssUUFBUTtRQUN4QixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVPLE1BQU0sQ0FBQyxRQUFRLENBQUMsSUFBWTtRQUNsQyxPQUFPLGFBQUssQ0FBQyxRQUFRLENBQUMsRUFBRSxHQUFHLEVBQUUsSUFBSSxFQUFFLEVBQUUsRUFBRSxXQUFXLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztJQUM5RCxDQUFDO0NBQ0Y7QUE5QkQsOEJBOEJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVG9rZW4gfSBmcm9tIFwiLi90b2tlblwiO1xyXG5cclxuY29uc3QgUk9TX1JFR0lPTiA9IFwiQUxJWVVOOjpSZWdpb25cIjtcclxuY29uc3QgUk9TX1NUQUNLSUQgPSBcIkFMSVlVTjo6U3RhY2tJZFwiO1xyXG5jb25zdCBST1NfU1RBQ0tOQU1FID0gXCJBTElZVU46OlN0YWNrTmFtZVwiO1xyXG5jb25zdCBST1NfTk9WQUxVRSA9IFwiQUxJWVVOOjpOb1ZhbHVlXCI7XHJcbmNvbnN0IFJPU19BQ0NPVU5USUQgPSBcIkFMSVlVTjo6QWNjb3VudElkXCI7XHJcbmNvbnN0IFJPU19URU5BTlRJRCA9IFwiQUxJWVVOOjpUZW5hbnRJZFwiO1xyXG5cclxuLyoqXHJcbiAqIEFjY2Vzc29yIGZvciBwc2V1ZG8gcGFyYW1ldGVyc1xyXG4gKi9cclxuZXhwb3J0IGNsYXNzIFJvc1BzZXVkbyB7XHJcbiAgcHJpdmF0ZSBjb25zdHJ1Y3RvcigpIHt9XHJcblxyXG4gIHB1YmxpYyBzdGF0aWMgZ2V0IGFjY291bnRJZCgpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIHRoaXMuYXNTdHJpbmcoUk9TX0FDQ09VTlRJRCk7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc3RhdGljIGdldCByZWdpb24oKTogc3RyaW5nIHtcclxuICAgIHJldHVybiB0aGlzLmFzU3RyaW5nKFJPU19SRUdJT04pO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHN0YXRpYyBnZXQgc3RhY2tJZCgpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIHRoaXMuYXNTdHJpbmcoUk9TX1NUQUNLSUQpO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHN0YXRpYyBnZXQgc3RhY2tOYW1lKCk6IHN0cmluZyB7XHJcbiAgICByZXR1cm4gdGhpcy5hc1N0cmluZyhST1NfU1RBQ0tOQU1FKTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzdGF0aWMgZ2V0IG5vVmFsdWUoKTogc3RyaW5nIHtcclxuICAgIHJldHVybiB0aGlzLmFzU3RyaW5nKFJPU19OT1ZBTFVFKTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzdGF0aWMgZ2V0IHRlbmFudElkKCk6IHN0cmluZyB7XHJcbiAgICByZXR1cm4gdGhpcy5hc1N0cmluZyhST1NfVEVOQU5USUQpO1xyXG4gIH1cclxuXHJcbiAgcHJpdmF0ZSBzdGF0aWMgYXNTdHJpbmcobmFtZTogc3RyaW5nKSB7XHJcbiAgICByZXR1cm4gVG9rZW4uYXNTdHJpbmcoeyBSZWY6IG5hbWUgfSwgeyBkaXNwbGF5SGludDogbmFtZSB9KTtcclxuICB9XHJcbn1cclxuIl19