"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosOutput = void 0;
const ros_element_1 = require("./ros-element");
class RosOutput extends ros_element_1.RosElement {
    /**
     * Creates an RosOutput value for this stack.
     * @param scope The parent construct.
     * @param props RosOutput properties.
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (props.value === undefined) {
            throw new Error(`Missing value for ROS output at path "${this.node.path}"`);
        }
        this._description = props.description;
        this._value = props.value;
        this._condition = props.condition;
        this._export = props.exportName;
    }
    /**
     * @internal
     */
    _toRosTemplate() {
        return {
            Outputs: {
                [this.logicalId]: {
                    Description: this._description,
                    Value: this._value,
                    Export: this._export != null ? { Name: this._export } : undefined,
                    Condition: this._condition ? this._condition.logicalId : undefined,
                },
            },
        };
    }
    addCondition(condition) {
        this._condition = condition;
    }
}
exports.RosOutput = RosOutput;
//# sourceMappingURL=data:application/json;base64,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