"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosMapping = void 0;
const token_1 = require("./token");
const ros_element_1 = require("./ros-element");
const ros_fn_1 = require("./ros-fn");
/**
 * Represents a mapping.
 */
class RosMapping extends ros_element_1.RosRefElement {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.mapping = {};
        this.mapping = props.mapping || {};
    }
    /**
     * Sets a value in the map based on the two keys.
     */
    setValue(key1, key2, value) {
        if (!(key1 in this.mapping)) {
            this.mapping[key1] = {};
        }
        this.mapping[key1][key2] = value;
    }
    /**
     * @returns A reference to a value in the map based on the two keys.
     */
    findInMap(key1, key2) {
        // opportunistically check that the key exists (if the key does not contain tokens)
        if (!token_1.Token.isUnresolved(key1) && !(key1 in this.mapping)) {
            throw new Error(`Mapping doesn't contain top-level key '${key1}'`);
        }
        // opportunistically check that the second key exists (if the key does not contain tokens)
        if (!token_1.Token.isUnresolved(key1) &&
            !token_1.Token.isUnresolved(key2) &&
            !(key2 in this.mapping[key1])) {
            throw new Error(`Mapping doesn't contain second-level key '${key2}'`);
        }
        return ros_fn_1.Fn.findInMap(this.logicalId, key1, key2);
    }
    /**
     * @internal
     */
    _toRosTemplate() {
        return {
            Mappings: {
                [this.logicalId]: this.mapping,
            },
        };
    }
}
exports.RosMapping = RosMapping;
//# sourceMappingURL=data:application/json;base64,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